/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.util.Orderable;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="collector", uniqueConstraints={@UniqueConstraint(columnNames={"AgentID", "CollectingEventID"})})
@Table(appliesTo="collector", indexes={@Index(name="COLTRDivIDX", columnNames={"DivisionID"})})
public class Collector
extends DataModelObjBase
implements Serializable,
Orderable,
Comparable<Collector>,
Cloneable {
    protected Integer collectorId;
    protected Integer orderNumber;
    protected Boolean isPrimary;
    protected String remarks;
    protected CollectingEvent collectingEvent;
    protected Agent agent;
    protected Division division;

    public Collector() {
    }

    public Collector(Integer collectorId) {
        this.collectorId = collectorId;
    }

    @Override
    public void initialize() {
        super.init();
        this.collectorId = null;
        this.orderNumber = null;
        this.isPrimary = true;
        this.remarks = null;
        this.collectingEvent = null;
        this.agent = null;
        this.division = AppContextMgr.getInstance() != null ? AppContextMgr.getInstance().getClassObject(Division.class) : null;
    }

    @Id
    @GeneratedValue
    @Column(name="CollectorID")
    public Integer getCollectorId() {
        return this.collectorId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.collectorId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Collector.class;
    }

    public void setCollectorId(Integer collectorId) {
        this.collectorId = collectorId;
    }

    @Column(name="OrderNumber", nullable=false)
    public Integer getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(Integer orderNumber) {
        this.orderNumber = orderNumber;
    }

    @Column(name="IsPrimary", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    public void setIsPrimary(Boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CollectingEventID", nullable=false)
    public CollectingEvent getCollectingEvent() {
        return this.collectingEvent;
    }

    public void setCollectingEvent(CollectingEvent collectingEvent) {
        this.collectingEvent = collectingEvent;
    }

    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="AgentID", nullable=false)
    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="DivisionID", unique=false, nullable=true, insertable=true, updatable=true)
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        String name = "";
        if (this.agent != null) {
            name = this.agent.getIdentityTitle();
        }
        if (StringUtils.isNotEmpty((String)name)) {
            return name;
        }
        return super.getIdentityTitle();
    }

    @Override
    @Transient
    public int getTableId() {
        return Collector.getClassTableId();
    }

    public static int getClassTableId() {
        return 30;
    }

    @Override
    @Transient
    public int getOrderIndex() {
        return this.getOrderNumber();
    }

    @Override
    public void setOrderIndex(int order) {
        this.setOrderNumber(order);
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return CollectingEvent.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.collectingEvent != null ? this.collectingEvent.getId() : null;
    }

    @Override
    public int compareTo(Collector obj) {
        return this.orderNumber != null && obj != null && obj.orderNumber != null ? this.orderNumber.compareTo(obj.orderNumber) : 0;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Collector obj = (Collector)super.clone();
        obj.setCollectorId(null);
        return obj;
    }
}

