/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.CollectionRelType;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="collectionrelationship")
public class CollectionRelationship
extends DataModelObjBase
implements Serializable {
    protected Integer collectionRelationshipId;
    protected CollectionRelType collectionRelType;
    protected CollectionObject leftSide;
    protected CollectionObject rightSide;
    protected String text1;
    protected String text2;

    @Override
    public void initialize() {
        super.init();
        this.collectionRelationshipId = null;
        this.collectionRelType = null;
        this.text1 = null;
        this.text2 = null;
        this.leftSide = null;
        this.rightSide = null;
    }

    @Id
    @GeneratedValue
    @Column(name="CollectionRelationshipID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getCollectionRelationshipId() {
        return this.collectionRelationshipId;
    }

    public void setCollectionRelationshipId(Integer collectionRelationshipId) {
        this.collectionRelationshipId = collectionRelationshipId;
    }

    @Column(name="Text1", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CollectionRelTypeID", unique=false, nullable=true, insertable=true, updatable=true)
    public CollectionRelType getCollectionRelType() {
        return this.collectionRelType;
    }

    public void setCollectionRelType(CollectionRelType collectionRelType) {
        this.collectionRelType = collectionRelType;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="LeftSideCollectionID", unique=false, nullable=false, insertable=true, updatable=true)
    public CollectionObject getLeftSide() {
        return this.leftSide;
    }

    public void setLeftSide(CollectionObject leftSide) {
        this.leftSide = leftSide;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="RightSideCollectionID", unique=false, nullable=false, insertable=true, updatable=true)
    public CollectionObject getRightSide() {
        return this.rightSide;
    }

    public void setRightSide(CollectionObject rightSide) {
        this.rightSide = rightSide;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return CollectionRelationship.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.collectionRelationshipId;
    }

    @Override
    @Transient
    public int getTableId() {
        return CollectionRelationship.getClassTableId();
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        String relTypName = this.collectionRelType != null ? this.collectionRelType.getName() : null;
        return StringUtils.isNotEmpty((String)relTypName) ? relTypName : super.getIdentityTitle();
    }

    public static int getClassTableId() {
        return 99;
    }
}

