/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.specify.datamodel.CollectionMember;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.ObjectAttachmentIFace;
import edu.ku.brc.util.Orderable;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OrderBy;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="collectionobjectattachment")
@Table(appliesTo="collectionobjectattachment", indexes={@Index(name="COLOBJATTColMemIDX", columnNames={"CollectionMemberID"})})
public class CollectionObjectAttachment
extends CollectionMember
implements ObjectAttachmentIFace<CollectionObject>,
Orderable,
Serializable,
Comparable<CollectionObjectAttachment> {
    protected Integer collectionObjectAttachmentId;
    protected CollectionObject collectionObject;
    protected Attachment attachment;
    protected Integer ordinal;
    protected String remarks;

    public CollectionObjectAttachment() {
    }

    public CollectionObjectAttachment(Integer id) {
        this.collectionObjectAttachmentId = id;
    }

    @Override
    public void initialize() {
        super.init();
        this.collectionObjectAttachmentId = null;
        this.collectionObject = null;
        this.ordinal = null;
        this.attachment = new Attachment();
        this.attachment.initialize();
    }

    @Id
    @GeneratedValue
    @Column(name="CollectionObjectAttachmentID")
    public Integer getCollectionObjectAttachmentId() {
        return this.collectionObjectAttachmentId;
    }

    public void setCollectionObjectAttachmentId(Integer collectionObjectAttachmentId) {
        this.collectionObjectAttachmentId = collectionObjectAttachmentId;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CollectionObjectID", nullable=false)
    public CollectionObject getCollectionObject() {
        return this.collectionObject;
    }

    public void setCollectionObject(CollectionObject collectionObject) {
        this.collectionObject = collectionObject;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="AttachmentID", nullable=false)
    @OrderBy(value="ordinal ASC")
    public Attachment getAttachment() {
        return this.attachment;
    }

    @Override
    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    @Override
    @Column(name="Ordinal")
    public Integer getOrdinal() {
        return this.ordinal;
    }

    @Override
    public void setOrdinal(Integer ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    @Transient
    public int getOrderIndex() {
        return this.ordinal != null ? this.ordinal : 0;
    }

    @Override
    public void setOrderIndex(int ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return CollectionObjectAttachment.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.collectionObjectAttachmentId;
    }

    @Override
    @Transient
    public int getTableId() {
        return CollectionObjectAttachment.getClassTableId();
    }

    public static int getClassTableId() {
        return 111;
    }

    @Override
    @Transient
    public CollectionObject getObject() {
        return this.getCollectionObject();
    }

    @Override
    public void setObject(CollectionObject object) {
        this.setCollectionObject(object);
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return CollectionObject.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.collectionObject != null ? this.collectionObject.getId() : null;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return Attachment.getIdentityTitle(this);
    }

    @Override
    public String toString() {
        String aString = this.attachment != null ? this.attachment.getIdentityTitle() : "NULL Attachment";
        String oString = this.getObject() != null ? this.getObject().getIdentityTitle() : "NULL Object Reference";
        return String.valueOf(aString) + " : " + oString;
    }

    @Override
    public int compareTo(CollectionObjectAttachment obj) {
        if (this.ordinal != null && obj != null && obj.ordinal != null) {
            return this.ordinal.compareTo(obj.ordinal);
        }
        return 0;
    }
}

