/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.dbsupport.AttributeIFace;
import edu.ku.brc.dbsupport.AttributeProviderIFace;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Appraisal;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionMember;
import edu.ku.brc.specify.datamodel.CollectionObjectAttachment;
import edu.ku.brc.specify.datamodel.CollectionObjectAttr;
import edu.ku.brc.specify.datamodel.CollectionObjectAttribute;
import edu.ku.brc.specify.datamodel.CollectionObjectCitation;
import edu.ku.brc.specify.datamodel.CollectionRelationship;
import edu.ku.brc.specify.datamodel.ConservDescription;
import edu.ku.brc.specify.datamodel.Container;
import edu.ku.brc.specify.datamodel.DNASequence;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.ExsiccataItem;
import edu.ku.brc.specify.datamodel.FieldNotebookPage;
import edu.ku.brc.specify.datamodel.OtherIdentifier;
import edu.ku.brc.specify.datamodel.PaleoContext;
import edu.ku.brc.specify.datamodel.Preparation;
import edu.ku.brc.specify.datamodel.Project;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.TreatmentEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="collectionobject", uniqueConstraints={@UniqueConstraint(columnNames={"CollectionID", "CatalogNumber"})})
@Table(appliesTo="collectionobject", indexes={@Index(name="FieldNumberIDX", columnNames={"FieldNumber"}), @Index(name="CatalogedDateIDX", columnNames={"CatalogedDate"}), @Index(name="CatalogNumberIDX", columnNames={"CatalogNumber"}), @Index(name="ColObjGuidIDX", columnNames={"GUID"}), @Index(name="COColMemIDX", columnNames={"CollectionmemberID"})})
public class CollectionObject
extends CollectionMember
implements AttachmentOwnerIFace<CollectionObjectAttachment>,
Serializable,
AttributeProviderIFace,
Comparable<CollectionObject> {
    protected Integer collectionObjectId;
    protected String fieldNumber;
    protected String description;
    protected String projectNumber;
    protected String text1;
    protected String text2;
    protected Float number1;
    protected Float number2;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected Boolean yesNo3;
    protected Boolean yesNo4;
    protected Boolean yesNo5;
    protected Boolean yesNo6;
    protected Integer countAmt;
    protected String remarks;
    protected String name;
    protected String modifier;
    protected Calendar catalogedDate;
    protected Byte catalogedDatePrecision;
    protected String catalogedDateVerbatim;
    protected String guid;
    protected String altCatalogNumber;
    protected Boolean deaccessioned;
    protected String catalogNumber;
    protected Calendar inventoryDate;
    protected String objectCondition;
    protected String availability;
    protected String restrictions;
    protected String notifications;
    protected BigDecimal totalValue;
    protected Byte sgrStatus;
    protected String ocr;
    protected Byte visibility;
    protected SpecifyUser visibilitySetBy;
    protected CollectingEvent collectingEvent;
    protected Set<CollectionObjectCitation> collectionObjectCitations;
    protected Set<Preparation> preparations;
    protected Set<Determination> determinations;
    protected Set<Project> projects;
    protected Set<OtherIdentifier> otherIdentifiers;
    protected Collection collection;
    protected Accession accession;
    protected Agent cataloger;
    protected Container container;
    protected Container containerOwner;
    protected Appraisal appraisal;
    protected CollectionObjectAttribute collectionObjectAttribute;
    protected Set<CollectionObjectAttr> collectionObjectAttrs;
    protected Set<CollectionRelationship> leftSideRels;
    protected Set<CollectionRelationship> rightSideRels;
    protected PaleoContext paleoContext;
    protected Set<DNASequence> dnaSequences;
    protected FieldNotebookPage fieldNotebookPage;
    protected Set<ConservDescription> conservDescriptions;
    protected Set<TreatmentEvent> treatmentEvents;
    protected Set<CollectionObjectAttachment> collectionObjectAttachments;
    protected Set<ExsiccataItem> exsiccataItems;

    public CollectionObject() {
    }

    public CollectionObject(Integer collectionObjectId) {
        this.collectionObjectId = collectionObjectId;
    }

    @Override
    public void initialize() {
        super.init();
        this.collectionObjectId = null;
        this.fieldNumber = null;
        this.description = null;
        this.text1 = null;
        this.text2 = null;
        this.number1 = null;
        this.number2 = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.yesNo3 = null;
        this.yesNo4 = null;
        this.yesNo5 = null;
        this.yesNo6 = null;
        this.countAmt = null;
        this.remarks = null;
        this.name = null;
        this.modifier = null;
        this.catalogedDate = null;
        this.catalogedDateVerbatim = null;
        this.guid = null;
        this.altCatalogNumber = null;
        this.deaccessioned = null;
        this.catalogNumber = null;
        this.objectCondition = null;
        this.availability = null;
        this.restrictions = null;
        this.notifications = null;
        this.totalValue = null;
        this.visibility = null;
        this.visibilitySetBy = null;
        this.sgrStatus = null;
        this.collectingEvent = null;
        this.appraisal = null;
        this.collectionObjectCitations = new HashSet<CollectionObjectCitation>();
        this.collectionObjectAttrs = new HashSet<CollectionObjectAttr>();
        this.preparations = new HashSet<Preparation>();
        this.determinations = new HashSet<Determination>();
        this.projects = new HashSet<Project>();
        this.otherIdentifiers = new HashSet<OtherIdentifier>();
        this.collection = null;
        this.accession = null;
        this.cataloger = null;
        this.container = null;
        this.containerOwner = null;
        this.paleoContext = null;
        this.dnaSequences = new HashSet<DNASequence>();
        this.fieldNotebookPage = null;
        this.leftSideRels = new HashSet<CollectionRelationship>();
        this.rightSideRels = new HashSet<CollectionRelationship>();
        this.conservDescriptions = new HashSet<ConservDescription>();
        this.treatmentEvents = new HashSet<TreatmentEvent>();
        this.collectionObjectAttachments = new HashSet<CollectionObjectAttachment>();
        this.exsiccataItems = new HashSet<ExsiccataItem>();
    }

    public void initForSearch() {
        this.collection = new Collection();
        this.collection.initialize();
        this.accession = new Accession();
        this.accession.initialize();
        this.cataloger = new Agent();
        this.cataloger.initialize();
    }

    @Id
    @GeneratedValue
    @Column(name="CollectionObjectID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getCollectionObjectId() {
        return this.collectionObjectId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.collectionObjectId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return CollectionObject.class;
    }

    public void setCollectionObjectId(Integer collectionObjectId) {
        this.collectionObjectId = collectionObjectId;
    }

    @Column(name="FieldNumber", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getFieldNumber() {
        return this.fieldNumber;
    }

    public void setFieldNumber(String fieldNumber) {
        this.fieldNumber = fieldNumber;
    }

    @Column(name="Description", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="Text1", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber1() {
        return this.number1;
    }

    public void setNumber1(Float number1) {
        this.number1 = number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber2() {
        return this.number2;
    }

    public void setNumber2(Float number2) {
        this.number2 = number2;
    }

    @Column(name="YesNo1", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @Column(name="YesNo3", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo3() {
        return this.yesNo3;
    }

    public void setYesNo3(Boolean yesNo3) {
        this.yesNo3 = yesNo3;
    }

    @Column(name="YesNo4", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo4() {
        return this.yesNo4;
    }

    public void setYesNo4(Boolean yesNo4) {
        this.yesNo4 = yesNo4;
    }

    @Column(name="YesNo5", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo5() {
        return this.yesNo5;
    }

    public void setYesNo5(Boolean yesNo5) {
        this.yesNo5 = yesNo5;
    }

    @Column(name="YesNo6", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo6() {
        return this.yesNo6;
    }

    public void setYesNo6(Boolean yesNo6) {
        this.yesNo6 = yesNo6;
    }

    @Column(name="CountAmt", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getCountAmt() {
        return this.countAmt;
    }

    public void setCountAmt(Integer countAmt) {
        this.countAmt = countAmt;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="Name", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="Modifier", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="CatalogedDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getCatalogedDate() {
        return this.catalogedDate;
    }

    public void setCatalogedDate(Calendar catalogedDate) {
        this.catalogedDate = catalogedDate;
    }

    @Column(name="CatalogedDateVerbatim", length=32, unique=false, nullable=true, insertable=true, updatable=true)
    public String getCatalogedDateVerbatim() {
        return this.catalogedDateVerbatim;
    }

    public void setCatalogedDateVerbatim(String catalogedDateVerbatim) {
        this.catalogedDateVerbatim = catalogedDateVerbatim;
    }

    @Column(name="GUID", unique=false, nullable=true, insertable=true, updatable=true, length=128)
    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    @Column(name="AltCatalogNumber", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getAltCatalogNumber() {
        return this.altCatalogNumber;
    }

    public void setAltCatalogNumber(String altCatalogNumber) {
        this.altCatalogNumber = altCatalogNumber;
    }

    @Column(name="Deaccessioned", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getDeaccessioned() {
        return this.deaccessioned;
    }

    public void setDeaccessioned(Boolean deaccessioned) {
        this.deaccessioned = deaccessioned;
    }

    @Column(name="CatalogNumber", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getCatalogNumber() {
        return this.catalogNumber;
    }

    public void setCatalogNumber(String catalogNumber) {
        this.catalogNumber = catalogNumber;
    }

    @Column(name="CatalogedDatePrecision", unique=false, nullable=true, insertable=true, updatable=true)
    public Byte getCatalogedDatePrecision() {
        return this.catalogedDatePrecision != null ? this.catalogedDatePrecision : (byte)UIFieldFormatterIFace.PartialDateEnum.Full.ordinal();
    }

    public void setCatalogedDatePrecision(Byte catalogedDatePrecision) {
        this.catalogedDatePrecision = catalogedDatePrecision;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="InventoryDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getInventoryDate() {
        return this.inventoryDate;
    }

    public void setInventoryDate(Calendar inventoryDate) {
        this.inventoryDate = inventoryDate;
    }

    @Column(name="ObjectCondition", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getObjectCondition() {
        return this.objectCondition;
    }

    public void setObjectCondition(String objectCondition) {
        this.objectCondition = objectCondition;
    }

    @Column(name="Availability", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getAvailability() {
        return this.availability;
    }

    public void setAvailability(String availability) {
        this.availability = availability;
    }

    @Column(name="Restrictions", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(String restrictions) {
        this.restrictions = restrictions;
    }

    @Column(name="Notifications", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getNotifications() {
        return this.notifications;
    }

    public void setNotifications(String notifications) {
        this.notifications = notifications;
    }

    @Column(name="TotalValue", unique=false, nullable=true, insertable=true, updatable=true, precision=12, scale=2)
    public BigDecimal getTotalValue() {
        return this.totalValue;
    }

    public void setTotalValue(BigDecimal totalValue) {
        this.totalValue = totalValue;
    }

    @Column(name="ProjectNumber", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getProjectNumber() {
        return this.projectNumber;
    }

    public void setProjectNumber(String projectNumber) {
        this.projectNumber = projectNumber;
    }

    @Column(name="Visibility", unique=false, nullable=true, insertable=true, updatable=true, length=10)
    public Byte getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Byte visibility) {
        this.visibility = visibility;
    }

    @Override
    @Transient
    public boolean isRestrictable() {
        return true;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="VisibilitySetByID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpecifyUser getVisibilitySetBy() {
        return this.visibilitySetBy;
    }

    public void setVisibilitySetBy(SpecifyUser visibilitySetBy) {
        this.visibilitySetBy = visibilitySetBy;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK})
    @JoinColumn(name="CollectingEventID", unique=false, nullable=true, insertable=true, updatable=true)
    public CollectingEvent getCollectingEvent() {
        return this.collectingEvent;
    }

    public void setCollectingEvent(CollectingEvent collectingEvent) {
        this.collectingEvent = collectingEvent;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AppraisalID", unique=false, nullable=true, insertable=true, updatable=true)
    public Appraisal getAppraisal() {
        return this.appraisal;
    }

    public void setAppraisal(Appraisal appraisal) {
        this.appraisal = appraisal;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="CollectionObjectAttributeID", unique=false, nullable=true, insertable=true, updatable=true)
    public CollectionObjectAttribute getCollectionObjectAttribute() {
        return this.collectionObjectAttribute;
    }

    public void setCollectionObjectAttribute(CollectionObjectAttribute colObjAttribute) {
        this.collectionObjectAttribute = colObjAttribute;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="collectionObject")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<CollectionObjectCitation> getCollectionObjectCitations() {
        return this.collectionObjectCitations;
    }

    public void setCollectionObjectCitations(Set<CollectionObjectCitation> collectionObjectCitations) {
        this.collectionObjectCitations = collectionObjectCitations;
    }

    @Override
    @Transient
    public Set<AttributeIFace> getAttrs() {
        return new HashSet<AttributeIFace>(this.collectionObjectAttrs);
    }

    @Override
    public void setAttrs(Set<AttributeIFace> collectionObjectAttrs) {
        this.collectionObjectAttrs.clear();
        for (AttributeIFace a : collectionObjectAttrs) {
            if (!(a instanceof CollectionObjectAttr)) continue;
            this.collectionObjectAttrs.add((CollectionObjectAttr)a);
        }
    }

    @OneToMany(targetEntity=CollectionObjectAttr.class, cascade={}, fetch=FetchType.LAZY, mappedBy="collectionObject")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<CollectionObjectAttr> getCollectionObjectAttrs() {
        return this.collectionObjectAttrs;
    }

    public void setCollectionObjectAttrs(Set<CollectionObjectAttr> collectionObjectAttrs) {
        this.collectionObjectAttrs = collectionObjectAttrs;
    }

    @OneToMany(mappedBy="collectionObject")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<Preparation> getPreparations() {
        return this.preparations;
    }

    public void setPreparations(Set<Preparation> preparations) {
        this.preparations = preparations;
    }

    @OneToMany(mappedBy="collectionObject")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<Determination> getDeterminations() {
        return this.determinations;
    }

    public void setDeterminations(Set<Determination> determinations) {
        this.determinations = determinations;
    }

    @ManyToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="collectionObjects")
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.LOCK})
    public Set<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(Set<Project> projects) {
        this.projects = projects;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="PaleoContextID", unique=false, nullable=true, insertable=true, updatable=true)
    public PaleoContext getPaleoContext() {
        return this.paleoContext;
    }

    public void setPaleoContext(PaleoContext paleoContext) {
        this.paleoContext = paleoContext;
    }

    @OneToMany(mappedBy="collectionObject")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<DNASequence> getDnaSequences() {
        return this.dnaSequences;
    }

    public void setDnaSequences(Set<DNASequence> dnaSequences) {
        this.dnaSequences = dnaSequences;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="FieldNotebookPageID", unique=false, nullable=true, insertable=true, updatable=true)
    public FieldNotebookPage getFieldNotebookPage() {
        return this.fieldNotebookPage;
    }

    public void setFieldNotebookPage(FieldNotebookPage fieldNotebookPage) {
        this.fieldNotebookPage = fieldNotebookPage;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="collectionObject")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<TreatmentEvent> getTreatmentEvents() {
        return this.treatmentEvents;
    }

    public void setTreatmentEvents(Set<TreatmentEvent> treatmentEvents) {
        this.treatmentEvents = treatmentEvents;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="collectionObject")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<OtherIdentifier> getOtherIdentifiers() {
        return this.otherIdentifiers;
    }

    public void setOtherIdentifiers(Set<OtherIdentifier> otherIdentifiers) {
        this.otherIdentifiers = otherIdentifiers;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CollectionID", unique=false, nullable=false, insertable=true, updatable=true)
    public Collection getCollection() {
        return this.collection;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AccessionID", unique=false, nullable=true, insertable=true, updatable=true)
    public Accession getAccession() {
        return this.accession;
    }

    public void setAccession(Accession accession) {
        this.accession = accession;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CatalogerID", unique=false, nullable=true, insertable=true, updatable=true)
    public Agent getCataloger() {
        return this.cataloger;
    }

    public void setCataloger(Agent cataloger) {
        this.cataloger = cataloger;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.LOCK})
    @JoinColumn(name="ContainerID", unique=false, nullable=true, insertable=true, updatable=true)
    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.LOCK})
    @JoinColumn(name="ContainerOwnerID", unique=false, nullable=true, insertable=true, updatable=true)
    public Container getContainerOwner() {
        return this.containerOwner;
    }

    public void setContainerOwner(Container containerOwner) {
        this.containerOwner = containerOwner;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="leftSide")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<CollectionRelationship> getLeftSideRels() {
        return this.leftSideRels;
    }

    public void setLeftSideRels(Set<CollectionRelationship> leftSideRels) {
        this.leftSideRels = leftSideRels;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="rightSide")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<CollectionRelationship> getRightSideRels() {
        return this.rightSideRels;
    }

    public void setRightSideRels(Set<CollectionRelationship> rightSideRels) {
        this.rightSideRels = rightSideRels;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="collectionObject")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<ConservDescription> getConservDescriptions() {
        return this.conservDescriptions;
    }

    public void setConservDescriptions(Set<ConservDescription> conservDescriptions) {
        this.conservDescriptions = conservDescriptions;
    }

    @OneToMany(mappedBy="collectionObject")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @OrderBy(value="ordinal ASC")
    public Set<CollectionObjectAttachment> getCollectionObjectAttachments() {
        return this.collectionObjectAttachments;
    }

    public void setCollectionObjectAttachments(Set<CollectionObjectAttachment> collectionObjectAttachments) {
        this.collectionObjectAttachments = collectionObjectAttachments;
    }

    @OneToMany(mappedBy="collectionObject")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<ExsiccataItem> getExsiccataItems() {
        return this.exsiccataItems;
    }

    public void setExsiccataItems(Set<ExsiccataItem> exsiccataItems) {
        this.exsiccataItems = exsiccataItems;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        UIFieldFormatterIFace fmt;
        if (StringUtils.isNotEmpty((String)this.catalogNumber) && (fmt = AppContextMgr.getInstance().getFormatter("CollectionObject", "CatalogNumber")) != null) {
            return fmt.formatToUI(this.catalogNumber).toString();
        }
        return this.fieldNumber != null ? this.fieldNumber : super.getIdentityTitle();
    }

    @Override
    public String toString() {
        return this.getIdentityTitle();
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Collection.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.collection != null ? this.collection.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return CollectionObject.getClassTableId();
    }

    public static int getClassTableId() {
        return 1;
    }

    @Override
    @Transient
    public Set<CollectionObjectAttachment> getAttachmentReferences() {
        return this.collectionObjectAttachments;
    }

    @Column(name="SGRStatus", unique=false, nullable=true, insertable=true, updatable=true)
    public Byte getSgrStatus() {
        return this.sgrStatus;
    }

    public void setSgrStatus(Byte sgrStatus) {
        this.sgrStatus = sgrStatus;
    }

    @Lob
    @Column(name="OCR", length=4096)
    public String getOcr() {
        return this.ocr;
    }

    public void setOcr(String ocr) {
        this.ocr = ocr;
    }

    @Override
    public void forceLoad() {
        CollectingEvent ce;
        DBTableInfo ti;
        this.determinations.size();
        this.preparations.size();
        for (Preparation prep : this.preparations) {
            prep.forceLoad();
        }
        this.collectionObjectAttachments.size();
        this.collectionObjectCitations.size();
        this.projects.size();
        if (this.collection != null) {
            this.collection.getId();
        }
        if ((ti = DBTableIdMgr.getInstance().getInfoById(OtherIdentifier.getClassTableId())) != null && !ti.isHidden()) {
            this.otherIdentifiers.size();
        }
        if ((ce = this.getCollectingEvent()) != null) {
            ce.forceLoad();
        }
    }

    @Override
    public int compareTo(CollectionObject obj) {
        if (this.catalogNumber != null && obj != null && obj.catalogNumber != null) {
            return this.catalogNumber.compareTo(obj.catalogNumber);
        }
        return this.timestampCreated != null && obj != null && obj.timestampCreated != null ? this.timestampCreated.compareTo(obj.timestampCreated) : 0;
    }
}

