/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.CollectionRelType;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.datamodel.PrepType;
import edu.ku.brc.specify.datamodel.UserGroupScope;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;

@Entity
@javax.persistence.Table(name="collection")
@Table(appliesTo="collection", indexes={@Index(name="CollectionNameIDX", columnNames={"CollectionName"})})
public class Collection
extends UserGroupScope
implements Serializable,
Comparable<Collection> {
    protected static Collection currentCollection = null;
    protected static List<Integer> currentCollectionIds = null;
    protected String collectionName;
    protected String catalogNumFormatName;
    protected String code;
    protected Boolean isEmbeddedCollectingEvent;
    protected String regNumber;
    protected String description;
    protected String remarks;
    protected String webPortalURI;
    protected String webSiteURI;
    protected String isaNumber;
    protected String kingdomCoverage;
    protected String primaryFocus;
    protected String collectionType;
    protected String primaryPurpose;
    protected String preservationMethodType;
    protected String developmentStatus;
    protected String institutionType;
    protected String scope;
    protected String dbContentVersion;
    protected Integer estimatedSize;
    protected Discipline discipline;
    protected Set<Agent> technicalContacts;
    protected Set<Agent> contentContacts;
    protected Set<PrepType> prepTypes;
    protected Set<PickList> pickLists;
    protected Set<CollectionRelType> leftSideRelTypes;
    protected Set<CollectionRelType> rightSideRelTypes;
    protected Set<AutoNumberingScheme> numberingSchemes;
    protected Institution institutionNetwork;

    public Collection() {
    }

    public Collection(Integer collectionId) {
        super(collectionId);
    }

    @Override
    public void initialize() {
        super.init();
        this.collectionName = null;
        this.catalogNumFormatName = null;
        this.code = null;
        this.isEmbeddedCollectingEvent = true;
        this.regNumber = null;
        this.description = null;
        this.remarks = null;
        this.discipline = AppContextMgr.getInstance().getClassObject(Discipline.class);
        this.kingdomCoverage = null;
        this.primaryFocus = null;
        this.collectionType = null;
        this.primaryPurpose = null;
        this.preservationMethodType = null;
        this.developmentStatus = null;
        this.institutionType = null;
        this.scope = null;
        this.dbContentVersion = null;
        this.webPortalURI = null;
        this.webSiteURI = null;
        this.isaNumber = null;
        this.estimatedSize = 0;
        this.technicalContacts = new HashSet<Agent>();
        this.contentContacts = new HashSet<Agent>();
        this.numberingSchemes = new HashSet<AutoNumberingScheme>();
        this.prepTypes = new HashSet<PrepType>();
        this.pickLists = new HashSet<PickList>();
        this.leftSideRelTypes = new HashSet<CollectionRelType>();
        this.rightSideRelTypes = new HashSet<CollectionRelType>();
        this.institutionNetwork = null;
    }

    public Integer getCollectionId() {
        return this.getUserGroupScopeId();
    }

    @Override
    @Transient
    public Integer getId() {
        return this.getUserGroupScopeId();
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Collection.class;
    }

    public void setCollectionId(Integer collectionId) {
        this.setUserGroupScopeId(collectionId);
    }

    @Column(name="CollectionName", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    @Column(name="CatalogFormatNumName", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getCatalogNumFormatName() {
        return this.catalogNumFormatName;
    }

    public void setCatalogNumFormatName(String catalogNumFormatName) {
        this.catalogNumFormatName = catalogNumFormatName;
    }

    @Column(name="Code", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Lob
    @Column(name="Description", unique=false, nullable=true, insertable=true, updatable=true, length=2048)
    public String getDescription() {
        return this.description;
    }

    @Column(name="IsEmbeddedCollectingEvent", unique=false, nullable=false, insertable=true, updatable=true)
    public Boolean getIsEmbeddedCollectingEvent() {
        return this.isEmbeddedCollectingEvent;
    }

    public void setIsEmbeddedCollectingEvent(Boolean isEmbeddedCollectingEvent) {
        this.isEmbeddedCollectingEvent = isEmbeddedCollectingEvent;
    }

    @Column(name="RegNumber", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public String getRegNumber() {
        return this.regNumber;
    }

    public void setRegNumber(String regNumber) {
        this.regNumber = regNumber;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @ManyToMany(cascade={}, fetch=FetchType.LAZY)
    @JoinTable(name="autonumsch_coll", joinColumns={@JoinColumn(name="CollectionID", unique=false, nullable=false, insertable=true, updatable=false)}, inverseJoinColumns={@JoinColumn(name="AutoNumberingSchemeID", unique=false, nullable=false, insertable=true, updatable=false)})
    public Set<AutoNumberingScheme> getNumberingSchemes() {
        return this.numberingSchemes;
    }

    public void setNumberingSchemes(Set<AutoNumberingScheme> numberingSchemes) {
        this.numberingSchemes = numberingSchemes;
    }

    @Transient
    public AutoNumberingScheme getNumberingSchemesByType(Integer schemeType) {
        for (AutoNumberingScheme scheme : this.numberingSchemes) {
            if (!scheme.getTableNumber().equals(schemeType)) continue;
            return scheme;
        }
        return null;
    }

    @Column(name="KingdomCoverage", length=32)
    public String getKingdomCoverage() {
        return this.kingdomCoverage;
    }

    public void setKingdomCoverage(String kingdomCoverage) {
        this.kingdomCoverage = kingdomCoverage;
    }

    @Column(name="PrimaryFocus", length=32)
    public String getPrimaryFocus() {
        return this.primaryFocus;
    }

    public void setPrimaryFocus(String primaryFocus) {
        this.primaryFocus = primaryFocus;
    }

    @Column(name="CollectionType", length=32)
    public String getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(String collectionType) {
        this.collectionType = collectionType;
    }

    @Column(name="PrimaryPurpose", length=32)
    public String getPrimaryPurpose() {
        return this.primaryPurpose;
    }

    public void setPrimaryPurpose(String primaryPurpose) {
        this.primaryPurpose = primaryPurpose;
    }

    @Column(name="PreservationMethodType", length=32)
    public String getPreservationMethodType() {
        return this.preservationMethodType;
    }

    public void setPreservationMethodType(String preservationMethodType) {
        this.preservationMethodType = preservationMethodType;
    }

    @Column(name="DevelopmentStatus", length=32)
    public String getDevelopmentStatus() {
        return this.developmentStatus;
    }

    public void setDevelopmentStatus(String developmentStatus) {
        this.developmentStatus = developmentStatus;
    }

    @Column(name="InstitutionType", length=32)
    public String getInstitutionType() {
        return this.institutionType;
    }

    public void setInstitutionType(String institutionType) {
        this.institutionType = institutionType;
    }

    @Lob
    @Column(name="Scope", unique=false, nullable=true, insertable=true, updatable=true, length=2048)
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Column(name="DbContentVersion", length=32)
    public String getDbContentVersion() {
        return this.dbContentVersion;
    }

    public void setDbContentVersion(String dbContentVersion) {
        this.dbContentVersion = dbContentVersion;
    }

    @Column(name="WebPortalURI", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getWebPortalURI() {
        return this.webPortalURI;
    }

    public void setWebPortalURI(String webPortalURI) {
        this.webPortalURI = webPortalURI;
    }

    @Column(name="WebSiteURI", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getWebSiteURI() {
        return this.webSiteURI;
    }

    public void setWebSiteURI(String webSiteURI) {
        this.webSiteURI = webSiteURI;
    }

    @Column(name="IsaNumber", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public String getIsaNumber() {
        return this.isaNumber;
    }

    public void setIsaNumber(String isaNumber) {
        this.isaNumber = isaNumber;
    }

    @Column(name="EstimatedSize", unique=false, nullable=true, insertable=true, updatable=true)
    public Integer getEstimatedSize() {
        return this.estimatedSize;
    }

    public void setEstimatedSize(Integer estimatedSize) {
        this.estimatedSize = estimatedSize;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="DisciplineID", unique=false, nullable=false, insertable=true, updatable=true)
    public Discipline getDiscipline() {
        return this.discipline;
    }

    public void setDiscipline(Discipline discipline) {
        this.discipline = discipline;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="collTechContact")
    public Set<Agent> getTechnicalContacts() {
        return this.technicalContacts;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="collContentContact")
    public Set<Agent> getContentContacts() {
        return this.contentContacts;
    }

    public void setTechnicalContacts(Set<Agent> technicalContacts) {
        this.technicalContacts = technicalContacts;
    }

    public void setContentContacts(Set<Agent> contentContacts) {
        this.contentContacts = contentContacts;
    }

    @Override
    public String toString() {
        return this.collectionName;
    }

    @Override
    public int compareTo(Collection obj) {
        return this.collectionName != null && obj != null && obj.collectionName != null ? this.collectionName.compareTo(obj.collectionName) : 0;
    }

    @OneToMany(mappedBy="collection")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<PrepType> getPrepTypes() {
        return this.prepTypes;
    }

    public void setPrepTypes(Set<PrepType> prepTypes) {
        this.prepTypes = prepTypes;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="leftSideCollection")
    public Set<CollectionRelType> getLeftSideRelTypes() {
        return this.leftSideRelTypes;
    }

    public void setLeftSideRelTypes(Set<CollectionRelType> leftSideRelTypes) {
        this.leftSideRelTypes = leftSideRelTypes;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="rightSideCollection")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<CollectionRelType> getRightSideRelTypes() {
        return this.rightSideRelTypes;
    }

    public void setRightSideRelTypes(Set<CollectionRelType> rightSideRelTypes) {
        this.rightSideRelTypes = rightSideRelTypes;
    }

    @OneToMany(mappedBy="collection")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<PickList> getPickLists() {
        return this.pickLists;
    }

    public void setPickLists(Set<PickList> pickLists) {
        this.pickLists = pickLists;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="InstitutionNetworkID", unique=false, nullable=true, insertable=true, updatable=true)
    public Institution getInstitutionNetwork() {
        return this.institutionNetwork;
    }

    public void setInstitutionNetwork(Institution institutionNetwork) {
        this.institutionNetwork = institutionNetwork;
    }

    @Override
    public void forceLoad() {
        for (AutoNumberingScheme ans : this.numberingSchemes) {
            ans.getTableNumber();
            ans.getCollections();
            ans.getDivisions();
            ans.getDisciplines();
        }
        this.rightSideRelTypes.size();
        this.leftSideRelTypes.size();
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return this.collectionName;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Discipline.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.discipline != null ? this.discipline.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return Collection.getClassTableId();
    }

    public static int getClassTableId() {
        return 23;
    }
}

