/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.dbsupport.AttributeIFace;
import edu.ku.brc.dbsupport.AttributeProviderIFace;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.specify.datamodel.CollectingEventAttachment;
import edu.ku.brc.specify.datamodel.CollectingEventAttr;
import edu.ku.brc.specify.datamodel.CollectingEventAttribute;
import edu.ku.brc.specify.datamodel.CollectingTrip;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Collector;
import edu.ku.brc.specify.datamodel.DisciplineMember;
import edu.ku.brc.specify.datamodel.Locality;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="collectingevent")
@Table(appliesTo="collectingevent", indexes={@Index(name="CEStationFieldNumberIDX", columnNames={"StationFieldNumber"}), @Index(name="CEStartDateIDX", columnNames={"StartDate"}), @Index(name="CEEndDateIDX", columnNames={"EndDate"})})
public class CollectingEvent
extends DisciplineMember
implements AttachmentOwnerIFace<CollectingEventAttachment>,
AttributeProviderIFace,
Serializable,
Comparable<CollectingEvent>,
Cloneable {
    protected Integer collectingEventId;
    protected String stationFieldNumber;
    protected String method;
    protected String verbatimDate;
    protected Calendar startDate;
    protected Byte startDatePrecision;
    protected String startDateVerbatim;
    protected Calendar endDate;
    protected Byte endDatePrecision;
    protected String endDateVerbatim;
    protected Short startTime;
    protected Short endTime;
    protected String verbatimLocality;
    protected String remarks;
    protected Byte visibility;
    protected SpecifyUser visibilitySetBy;
    protected Set<CollectionObject> collectionObjects;
    protected Set<Collector> collectors;
    protected Locality locality;
    protected CollectingTrip collectingTrip;
    protected Byte sgrStatus;
    protected CollectingEventAttribute collectingEventAttribute;
    protected Set<CollectingEventAttr> collectingEventAttrs;
    protected Set<CollectingEventAttachment> collectingEventAttachments;
    private static String ceCOSQL = " FROM collectingevent ce INNER JOIN collectionobject c ON ce.CollectingEventID = c.CollectingEventID WHERE c.CollectingEventID = ";

    public CollectingEvent() {
    }

    public CollectingEvent(Integer collectingEventId) {
        this.collectingEventId = collectingEventId;
    }

    @Override
    public void initialize() {
        super.init();
        this.collectingEventId = null;
        this.stationFieldNumber = null;
        this.method = null;
        this.verbatimDate = null;
        this.startDate = null;
        this.startDatePrecision = null;
        this.startDateVerbatim = null;
        this.endDate = null;
        this.endDatePrecision = null;
        this.endDateVerbatim = null;
        this.startTime = null;
        this.endTime = null;
        this.verbatimLocality = null;
        this.remarks = null;
        this.visibility = null;
        this.sgrStatus = null;
        this.collectionObjects = new HashSet<CollectionObject>();
        this.collectors = new HashSet<Collector>();
        this.locality = null;
        this.collectingEventAttribute = null;
        this.collectingEventAttrs = new HashSet<CollectingEventAttr>();
        this.collectingEventAttachments = new HashSet<CollectingEventAttachment>();
    }

    @Id
    @GeneratedValue
    @Column(name="CollectingEventID", nullable=false)
    public Integer getCollectingEventId() {
        return this.collectingEventId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.collectingEventId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return CollectingEvent.class;
    }

    public void setCollectingEventId(Integer collectingEventId) {
        this.collectingEventId = collectingEventId;
    }

    @Column(name="StationFieldNumber", length=50)
    public String getStationFieldNumber() {
        return this.stationFieldNumber;
    }

    public void setStationFieldNumber(String stationFieldNumber) {
        this.stationFieldNumber = stationFieldNumber;
    }

    @Column(name="SGRStatus", unique=false, nullable=true, insertable=true, updatable=true)
    public Byte getSgrStatus() {
        return this.sgrStatus;
    }

    public void setSgrStatus(Byte sgrStatus) {
        this.sgrStatus = sgrStatus;
    }

    @Column(name="Method", length=50)
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Column(name="VerbatimDate", length=50)
    public String getVerbatimDate() {
        return this.verbatimDate;
    }

    public void setVerbatimDate(String verbatimDate) {
        this.verbatimDate = verbatimDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="StartDate")
    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    @Column(name="StartDatePrecision")
    public Byte getStartDatePrecision() {
        return this.startDatePrecision != null ? this.startDatePrecision : (byte)UIFieldFormatterIFace.PartialDateEnum.Full.ordinal();
    }

    public void setStartDatePrecision(Byte startDatePrecision) {
        this.startDatePrecision = startDatePrecision;
    }

    @Column(name="StartDateVerbatim", length=50)
    public String getStartDateVerbatim() {
        return this.startDateVerbatim;
    }

    public void setStartDateVerbatim(String startDateVerbatim) {
        this.startDateVerbatim = startDateVerbatim;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="EndDate")
    public Calendar getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }

    @Column(name="EndDatePrecision")
    public Byte getEndDatePrecision() {
        return this.endDatePrecision != null ? this.endDatePrecision : (byte)UIFieldFormatterIFace.PartialDateEnum.Full.ordinal();
    }

    public void setEndDatePrecision(Byte endDatePrecision) {
        this.endDatePrecision = endDatePrecision;
    }

    @Column(name="EndDateVerbatim", length=50)
    public String getEndDateVerbatim() {
        return this.endDateVerbatim;
    }

    public void setEndDateVerbatim(String endDateVerbatim) {
        this.endDateVerbatim = endDateVerbatim;
    }

    @Column(name="StartTime")
    public Short getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Short startTime) {
        this.startTime = startTime;
    }

    @Column(name="EndTime")
    public Short getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Short endTime) {
        this.endTime = endTime;
    }

    @Lob
    @Column(name="VerbatimLocality", length=2048)
    public String getVerbatimLocality() {
        return this.verbatimLocality;
    }

    public void setVerbatimLocality(String verbatimLocality) {
        this.verbatimLocality = verbatimLocality;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="Visibility")
    public Byte getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Byte visibility) {
        this.visibility = visibility;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="VisibilitySetByID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpecifyUser getVisibilitySetBy() {
        return this.visibilitySetBy;
    }

    public void setVisibilitySetBy(SpecifyUser visibilitySetBy) {
        this.visibilitySetBy = visibilitySetBy;
    }

    @Override
    @Transient
    public boolean isRestrictable() {
        return true;
    }

    @OneToMany(mappedBy="collectingEvent")
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.LOCK})
    public Set<CollectionObject> getCollectionObjects() {
        return this.collectionObjects;
    }

    public void setCollectionObjects(Set<CollectionObject> collectionObjects) {
        this.collectionObjects = collectionObjects;
    }

    @OneToMany(mappedBy="collectingEvent")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @OrderBy(value="orderNumber ASC")
    public Set<Collector> getCollectors() {
        return this.collectors;
    }

    public void setCollectors(Set<Collector> collectors) {
        this.collectors = collectors;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="LocalityID")
    public Locality getLocality() {
        return this.locality;
    }

    public void setLocality(Locality locality) {
        this.locality = locality;
    }

    @OneToMany(mappedBy="collectingEvent")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<CollectingEventAttr> getCollectingEventAttrs() {
        return this.collectingEventAttrs;
    }

    public void setCollectingEventAttrs(Set<CollectingEventAttr> collectingEventAttrs) {
        this.collectingEventAttrs = collectingEventAttrs;
    }

    @Override
    @Transient
    public Set<AttributeIFace> getAttrs() {
        return new HashSet<AttributeIFace>(this.collectingEventAttrs);
    }

    @Override
    public void setAttrs(Set<AttributeIFace> collectingEventAttrs) {
        this.collectingEventAttrs.clear();
        for (AttributeIFace a : collectingEventAttrs) {
            if (!(a instanceof CollectingEventAttr)) continue;
            this.collectingEventAttrs.add((CollectingEventAttr)a);
        }
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CollectingTripID")
    public CollectingTrip getCollectingTrip() {
        return this.collectingTrip;
    }

    public void setCollectingTrip(CollectingTrip collectingTrip) {
        this.collectingTrip = collectingTrip;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="CollectingEventAttributeID")
    public CollectingEventAttribute getCollectingEventAttribute() {
        return this.collectingEventAttribute;
    }

    public void setCollectingEventAttribute(CollectingEventAttribute collectingEventAttribute) {
        this.collectingEventAttribute = collectingEventAttribute;
    }

    @OneToMany(mappedBy="collectingEvent")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @OrderBy(value="ordinal ASC")
    public Set<CollectingEventAttachment> getCollectingEventAttachments() {
        return this.collectingEventAttachments;
    }

    public void setCollectingEventAttachments(Set<CollectingEventAttachment> collectingEventAttachments) {
        this.collectingEventAttachments = collectingEventAttachments;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        if (this.collectingTrip != null) {
            return CollectingTrip.getClassTableId();
        }
        int cnt = BasicSQLUtils.getCountAsInt("SELECT COUNT(c.CollectionObjectID)" + ceCOSQL + this.collectingEventId);
        if (cnt > 1) {
            return CollectionObject.getClassTableId();
        }
        return null;
    }

    @Override
    public void forceLoad() {
        if (this.collectingEventAttribute != null) {
            this.collectingEventAttribute.getId();
        }
        this.collectingEventAttachments.size();
        this.collectors.size();
        this.collectingEventAttrs.size();
    }

    @Override
    @Transient
    public Integer getParentId() {
        if (this.collectingTrip != null) {
            return this.collectingTrip.getId();
        }
        String postSQL = String.valueOf(ceCOSQL) + this.collectingEventId;
        int cnt = BasicSQLUtils.getCountAsInt("SELECT COUNT(c.CollectionObjectID)" + postSQL);
        if (cnt == 1) {
            Vector<Object> ids = BasicSQLUtils.querySingleCol("SELECT c.CollectionObjectID" + postSQL);
            return (Integer)ids.get(0);
        }
        return null;
    }

    @Override
    @Transient
    public int getTableId() {
        return CollectingEvent.getClassTableId();
    }

    public static int getClassTableId() {
        return 10;
    }

    @Override
    @Transient
    public Set<CollectingEventAttachment> getAttachmentReferences() {
        return this.collectingEventAttachments;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CollectingEvent obj = (CollectingEvent)super.clone();
        obj.collectingEventId = null;
        obj.collectionObjects = new HashSet<CollectionObject>();
        obj.collectors = new HashSet<Collector>();
        obj.collectingEventAttribute = null;
        obj.collectingEventAttrs = new HashSet<CollectingEventAttr>();
        obj.collectingEventAttachments = new HashSet<CollectingEventAttachment>();
        for (Collector collector : this.collectors) {
            Collector newCollector = (Collector)collector.clone();
            newCollector.setCollectingEvent(obj);
            obj.collectors.add(newCollector);
        }
        obj.collectingEventAttribute = this.collectingEventAttribute != null ? (CollectingEventAttribute)this.collectingEventAttribute.clone() : null;
        obj.collectingEventAttrs = new HashSet<CollectingEventAttr>();
        for (CollectingEventAttr cea : this.collectingEventAttrs) {
            CollectingEventAttr newCEA = (CollectingEventAttr)cea.clone();
            obj.collectingEventAttrs.add(newCEA);
            newCEA.setCollectingEvent(obj);
        }
        return obj;
    }

    @Override
    public int compareTo(CollectingEvent obj) {
        Date date2;
        if (obj == null) {
            return 0;
        }
        Calendar startDateObj = obj.getStartDate();
        Date date1 = this.startDate != null ? this.startDate.getTime() : null;
        Date date = date2 = startDateObj != null ? startDateObj.getTime() : null;
        if (this.startDate == null || startDateObj == null) {
            return 0;
        }
        return date1.compareTo(date2);
    }
}

