/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Borrow;
import edu.ku.brc.specify.datamodel.BorrowReturnMaterial;
import edu.ku.brc.specify.datamodel.CollectionMember;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="borrowmaterial")
@Table(appliesTo="borrowmaterial", indexes={@Index(name="BorMaterialNumberIDX", columnNames={"MaterialNumber"}), @Index(name="BorMaterialColMemIDX", columnNames={"CollectionMemberID"}), @Index(name="DescriptionIDX", columnNames={"Description"})})
public class BorrowMaterial
extends CollectionMember
implements Serializable {
    protected Integer borrowMaterialId;
    protected String materialNumber;
    protected String description;
    protected Short quantity;
    protected String outComments;
    protected String inComments;
    protected Short quantityResolved;
    protected Short quantityReturned;
    protected Set<BorrowReturnMaterial> borrowReturnMaterials;
    protected Borrow borrow;

    public BorrowMaterial() {
    }

    public BorrowMaterial(Integer borrowMaterialId) {
        this.borrowMaterialId = borrowMaterialId;
    }

    @Override
    public void initialize() {
        super.init();
        this.borrowMaterialId = null;
        this.materialNumber = null;
        this.description = null;
        this.quantity = null;
        this.outComments = null;
        this.inComments = null;
        this.quantityResolved = null;
        this.quantityReturned = null;
        this.borrowReturnMaterials = new HashSet<BorrowReturnMaterial>();
        this.borrow = null;
    }

    @Id
    @GeneratedValue
    @Column(name="BorrowMaterialID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getBorrowMaterialId() {
        return this.borrowMaterialId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.borrowMaterialId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return BorrowMaterial.class;
    }

    public void setBorrowMaterialId(Integer borrowMaterialId) {
        this.borrowMaterialId = borrowMaterialId;
    }

    @Column(name="MaterialNumber", unique=false, nullable=false, insertable=true, updatable=true, length=50)
    public String getMaterialNumber() {
        return this.materialNumber;
    }

    public void setMaterialNumber(String materialNumber) {
        this.materialNumber = materialNumber;
    }

    @Column(name="Description", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="Quantity", unique=false, nullable=true, insertable=true, updatable=true)
    public Short getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Short quantity) {
        this.quantity = quantity;
    }

    @Lob
    @Column(name="OutComments", length=1024, unique=false, nullable=true, insertable=true, updatable=true)
    public String getOutComments() {
        return this.outComments;
    }

    public void setOutComments(String outComments) {
        this.outComments = outComments;
    }

    @Lob
    @Column(name="InComments", length=1024, unique=false, nullable=true, insertable=true, updatable=true)
    public String getInComments() {
        return this.inComments;
    }

    public void setInComments(String inComments) {
        this.inComments = inComments;
    }

    @Column(name="QuantityResolved", unique=false, nullable=true, insertable=true, updatable=true)
    public Short getQuantityResolved() {
        return this.quantityResolved;
    }

    public void setQuantityResolved(Short quantityResolved) {
        this.quantityResolved = quantityResolved;
    }

    @Column(name="QuantityReturned", unique=false, nullable=true, insertable=true, updatable=true)
    public Short getQuantityReturned() {
        return this.quantityReturned;
    }

    public void setQuantityReturned(Short quantityReturned) {
        this.quantityReturned = quantityReturned;
    }

    @OneToMany(cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY, mappedBy="borrowMaterial")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<BorrowReturnMaterial> getBorrowReturnMaterials() {
        return this.borrowReturnMaterials;
    }

    public void setBorrowReturnMaterials(Set<BorrowReturnMaterial> borrowReturnMaterials) {
        this.borrowReturnMaterials = borrowReturnMaterials;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="BorrowID", unique=false, nullable=false, insertable=true, updatable=true)
    public Borrow getBorrow() {
        return this.borrow;
    }

    public void setBorrow(Borrow borrow) {
        this.borrow = borrow;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Borrow.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.borrow != null ? this.borrow.getId() : null;
    }

    public void addBorrowReturnMaterials(BorrowReturnMaterial borrowReturnMaterial) {
        this.borrowReturnMaterials.add(borrowReturnMaterial);
        borrowReturnMaterial.setBorrowMaterial(this);
    }

    public void removeBorrowReturnMaterials(BorrowReturnMaterial borrowReturnMaterial) {
        this.borrowReturnMaterials.remove(borrowReturnMaterial);
        borrowReturnMaterial.setBorrowMaterial(null);
    }

    @Override
    @Transient
    public int getTableId() {
        return BorrowMaterial.getClassTableId();
    }

    public static int getClassTableId() {
        return 20;
    }
}

