/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Borrow;
import edu.ku.brc.specify.datamodel.CollectionMember;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="borrowagent", uniqueConstraints={@UniqueConstraint(columnNames={"Role", "AgentID", "BorrowID"})})
@Table(appliesTo="borrowagent", indexes={@Index(name="BorColMemIDX2", columnNames={"CollectionMemberID"})})
public class BorrowAgent
extends CollectionMember
implements Serializable {
    protected Integer borrowAgentId;
    protected String role;
    protected String remarks;
    protected Agent agent;
    protected Borrow borrow;

    public BorrowAgent() {
    }

    public BorrowAgent(Integer borrowAgentId) {
        this.borrowAgentId = borrowAgentId;
    }

    @Override
    public void initialize() {
        super.init();
        this.borrowAgentId = null;
        this.role = null;
        this.remarks = null;
        this.agent = null;
        this.borrow = null;
    }

    @Id
    @GeneratedValue
    @Column(name="BorrowAgentID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getBorrowAgentId() {
        return this.borrowAgentId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.borrowAgentId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return BorrowAgent.class;
    }

    public void setBorrowAgentId(Integer borrowAgentId) {
        this.borrowAgentId = borrowAgentId;
    }

    @Column(name="Role", unique=false, nullable=false, insertable=true, updatable=true, length=32)
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AgentID", unique=false, nullable=false, insertable=true, updatable=true)
    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="BorrowID", unique=false, nullable=false, insertable=true, updatable=true)
    public Borrow getBorrow() {
        return this.borrow;
    }

    public void setBorrow(Borrow borrow) {
        this.borrow = borrow;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Agent.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.agent != null ? this.agent.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return BorrowAgent.getClassTableId();
    }

    public static int getClassTableId() {
        return 19;
    }
}

