/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.AddressOfRecord;
import edu.ku.brc.specify.datamodel.BorrowAgent;
import edu.ku.brc.specify.datamodel.BorrowAttachment;
import edu.ku.brc.specify.datamodel.BorrowMaterial;
import edu.ku.brc.specify.datamodel.CollectionMember;
import edu.ku.brc.specify.datamodel.Shipment;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="borrow")
@Table(appliesTo="borrow", indexes={@Index(name="BorInvoiceNumberIDX", columnNames={"InvoiceNumber"}), @Index(name="BorReceivedDateIDX", columnNames={"ReceivedDate"}), @Index(name="BorColMemIDX", columnNames={"CollectionMemberID"})})
public class Borrow
extends CollectionMember
implements Serializable {
    protected Integer borrowId;
    protected String invoiceNumber;
    protected Calendar receivedDate;
    protected Calendar originalDueDate;
    protected Calendar dateClosed;
    protected String remarks;
    protected String text1;
    protected String text2;
    protected Float number1;
    protected Float number2;
    protected Boolean isClosed;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected Calendar currentDueDate;
    protected Boolean isFinancialResponsibility;
    protected AddressOfRecord addressOfRecord;
    protected Set<Shipment> shipments;
    protected Set<BorrowAgent> borrowAgents;
    protected Set<BorrowMaterial> borrowMaterials;
    protected Set<BorrowAttachment> borrowAttachments;

    public Borrow() {
    }

    public Borrow(Integer borrowId) {
        this.borrowId = borrowId;
    }

    @Override
    public void initialize() {
        super.init();
        this.borrowId = null;
        this.invoiceNumber = null;
        this.receivedDate = null;
        this.originalDueDate = null;
        this.dateClosed = null;
        this.remarks = null;
        this.text1 = null;
        this.text2 = null;
        this.number1 = null;
        this.number2 = null;
        this.isClosed = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.currentDueDate = null;
        this.addressOfRecord = null;
        this.shipments = new HashSet<Shipment>();
        this.borrowAgents = new HashSet<BorrowAgent>();
        this.borrowAttachments = new HashSet<BorrowAttachment>();
        this.borrowMaterials = new HashSet<BorrowMaterial>();
    }

    @Id
    @GeneratedValue
    @Column(name="BorrowID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getBorrowId() {
        return this.borrowId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.borrowId;
    }

    @Override
    public void forceLoad() {
        super.forceLoad();
        this.borrowAgents.size();
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Borrow.class;
    }

    public void setBorrowId(Integer borrowId) {
        this.borrowId = borrowId;
    }

    @Column(name="InvoiceNumber", unique=false, nullable=false, insertable=true, updatable=true, length=50)
    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="ReceivedDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getReceivedDate() {
        return this.receivedDate;
    }

    public void setReceivedDate(Calendar receivedDate) {
        this.receivedDate = receivedDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="OriginalDueDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getOriginalDueDate() {
        return this.originalDueDate;
    }

    public void setOriginalDueDate(Calendar originalDueDate) {
        this.originalDueDate = originalDueDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DateClosed", unique=false, nullable=true, insertable=true, updatable=true, length=10)
    public Calendar getDateClosed() {
        return this.dateClosed;
    }

    public void setDateClosed(Calendar dateClosed) {
        this.dateClosed = dateClosed;
    }

    @Column(name="IsFinancialResponsibility", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsFinancialResponsibility() {
        return this.isFinancialResponsibility;
    }

    public void setIsFinancialResponsibility(Boolean isFinancialResonsibility) {
        this.isFinancialResponsibility = isFinancialResonsibility;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="Text1", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber1() {
        return this.number1;
    }

    public void setNumber1(Float number1) {
        this.number1 = number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true, length=24)
    public Float getNumber2() {
        return this.number2;
    }

    public void setNumber2(Float number2) {
        this.number2 = number2;
    }

    @Column(name="IsClosed", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getIsClosed() {
        return this.isClosed;
    }

    public void setIsClosed(Boolean closed) {
        this.isClosed = closed;
    }

    @Column(name="YesNo1", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="CurrentDueDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getCurrentDueDate() {
        return this.currentDueDate;
    }

    public void setCurrentDueDate(Calendar currentDueDate) {
        this.currentDueDate = currentDueDate;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="borrow")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<Shipment> getShipments() {
        return this.shipments;
    }

    public void setShipments(Set<Shipment> shipments) {
        this.shipments = shipments;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="borrow")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<BorrowAgent> getBorrowAgents() {
        return this.borrowAgents;
    }

    public void setBorrowAgents(Set<BorrowAgent> borrowAgents) {
        this.borrowAgents = borrowAgents;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="borrow")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<BorrowMaterial> getBorrowMaterials() {
        return this.borrowMaterials;
    }

    public void setBorrowMaterials(Set<BorrowMaterial> borrowMaterials) {
        this.borrowMaterials = borrowMaterials;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AddressOfRecordID", unique=false, nullable=true, insertable=true, updatable=true)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public AddressOfRecord getAddressOfRecord() {
        return this.addressOfRecord;
    }

    public void setAddressOfRecord(AddressOfRecord addressOfRecord) {
        this.addressOfRecord = addressOfRecord;
    }

    @OneToMany(mappedBy="borrow")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @OrderBy(value="ordinal ASC")
    public Set<BorrowAttachment> getBorrowAttachments() {
        return this.borrowAttachments;
    }

    public void setBorrowAttachments(Set<BorrowAttachment> borrowAttachments) {
        this.borrowAttachments = borrowAttachments;
    }

    @Override
    @Transient
    public int getTableId() {
        return Borrow.getClassTableId();
    }

    public static int getClassTableId() {
        return 18;
    }
}

