/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.SpecifyUserTypes;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.SpTaskSemaphore;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.TreeDefIface;
import edu.ku.brc.specify.datamodel.TreeDefItemIface;
import edu.ku.brc.specify.datamodel.TreeDefItemStandardEntry;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgr;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgrCallerIFace;
import edu.ku.brc.specify.dbsupport.TreeDefStatusMgr;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTable;
import edu.ku.brc.specify.treeutils.TreeRebuilder;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.ProgressDialog;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.Transient;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class BaseTreeDef<N extends Treeable<N, D, I>, D extends TreeDefIface<N, D, I>, I extends TreeDefItemIface<N, D, I>>
extends DataModelObjBase
implements TreeDefIface<N, D, I> {
    private static final Logger log = Logger.getLogger(BaseTreeDef.class);
    protected transient DataProviderSessionIFace nodeUpdateSession = null;
    protected transient DataProviderSessionIFace.QueryIFace nodeQ = null;
    protected transient DataProviderSessionIFace.QueryIFace highestNodeQ = null;
    protected transient DataProviderSessionIFace.QueryIFace childrenQ = null;

    @Override
    public boolean getNodeNumbersAreUpToDate() {
        return TreeDefStatusMgr.isNodeNumbersAreUpToDate(this);
    }

    protected void buildQueries(DataModelObjBase rootObj) {
        String hql = "select n." + UploadTable.deCapitalize(rootObj.getDataClass().getSimpleName()) + "Id from " + rootObj.getDataClass().getSimpleName() + " n where parentID=:parent";
        this.childrenQ = this.nodeUpdateSession.createQuery(hql, false);
        hql = "update " + rootObj.getDataClass().getSimpleName() + " set nodeNumber=:node where " + UploadTable.deCapitalize(rootObj.getDataClass().getSimpleName()) + "Id=:id";
        this.nodeQ = this.nodeUpdateSession.createQuery(hql, false);
        hql = "update " + rootObj.getDataClass().getSimpleName() + " set highestChildNodeNumber=:node where " + UploadTable.deCapitalize(rootObj.getDataClass().getSimpleName()) + "ID=:id";
        this.highestNodeQ = this.nodeUpdateSession.createQuery(hql, false);
    }

    public void updateAllNodesOld(DataModelObjBase rootObj) throws Exception {
        this.nodeUpdateSession = DataProviderFactory.getInstance().createSession();
        Treeable root = (Treeable)((Object)rootObj);
        if (root == null) {
            Object rootDefItem = this.getDefItemByRank(0);
            this.nodeUpdateSession.attach(rootDefItem);
            root = (Treeable)rootDefItem.getTreeEntries().iterator().next();
            this.nodeUpdateSession.evict(rootDefItem);
        }
        try {
            try {
                this.buildQueries((DataModelObjBase)((Object)root));
                this.nodeUpdateSession.beginTransaction();
                this.writeNodeNumber(root.getTreeId(), 1);
                int highestChild = this.updateAllNodes2(root.getTreeId(), 1);
                this.writeHighestChildNodeNumber(root.getTreeId(), highestChild);
                this.nodeUpdateSession.commit();
                TreeDefStatusMgr.setNodeNumbersAreUpToDate(this, true);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(BaseTreeDef.class, ex);
                this.nodeUpdateSession.rollback();
                this.nodeUpdateSession.close();
                this.childrenQ = null;
                this.nodeQ = null;
                this.highestNodeQ = null;
                this.nodeUpdateSession = null;
            }
        }
        finally {
            this.nodeUpdateSession.close();
            this.childrenQ = null;
            this.nodeQ = null;
            this.highestNodeQ = null;
            this.nodeUpdateSession = null;
        }
    }

    public N getTreeRootNode() {
        Object rootDefItem = this.getDefItemByRank(0);
        this.nodeUpdateSession.attach(rootDefItem);
        Treeable result = (Treeable)rootDefItem.getTreeEntries().iterator().next();
        this.nodeUpdateSession.evict(rootDefItem);
        return (N)result;
    }

    protected Integer updateAllNodes2(Integer rootId, int rootNodeNumber) throws Exception {
        List<?> children = this.getChildren(rootId);
        int nodeNumber = rootNodeNumber;
        for (Object childId : children) {
            this.writeNodeNumber(childId, nodeNumber + 1);
            nodeNumber = this.updateAllNodes2((Integer)childId, nodeNumber + 1);
            this.writeHighestChildNodeNumber(childId, nodeNumber);
        }
        return nodeNumber;
    }

    protected List<?> getChildren(int nodeId) {
        this.childrenQ.setParameter("parent", nodeId);
        return this.childrenQ.list();
    }

    protected void writeNodeNumber(Object childId, Integer nodeNumber) {
        this.nodeQ.setParameter("node", nodeNumber);
        this.nodeQ.setParameter("id", childId);
        this.nodeQ.executeUpdate();
    }

    protected void writeHighestChildNodeNumber(Object childId, Integer nodeNumber) {
        this.highestNodeQ.setParameter("node", nodeNumber);
        this.highestNodeQ.setParameter("id", childId);
        this.highestNodeQ.executeUpdate();
    }

    @Override
    public boolean getDoNodeNumberUpdates() {
        return TreeDefStatusMgr.isDoNodeNumberUpdates(this);
    }

    @Override
    public void setDoNodeNumberUpdates(boolean arg) {
        TreeDefStatusMgr.setDoNodeNumberUpdates(this, arg);
    }

    @Override
    public boolean isUploadInProgress() {
        return TreeDefStatusMgr.isUploadInProgress(this);
    }

    @Override
    public void setUploadInProgress(boolean arg) {
        TreeDefStatusMgr.setUploadInProgress(this, arg);
    }

    @Override
    public void setNodeNumbersAreUpToDate(boolean arg) {
        TreeDefStatusMgr.setNodeNumbersAreUpToDate(this, arg);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public Class<?> getDataClass() {
        return null;
    }

    @Override
    public Integer getId() {
        return null;
    }

    @Override
    public int getTableId() {
        return 0;
    }

    @Override
    public List<TreeDefItemStandardEntry> getStandardLevels() {
        return new LinkedList<TreeDefItemStandardEntry>();
    }

    @Override
    public int getRankIncrement() {
        return 1000;
    }

    @Override
    public boolean updateAllFullNames(DataModelObjBase rootObj, boolean useProgDlg, boolean lockedByCaller, int minRank) throws Exception {
        return this.treeTraversal(rootObj, useProgDlg, lockedByCaller, minRank, TreeRebuilder.RebuildMode.FullNames);
    }

    protected boolean checkForOtherLoginsBeforeNodeNumberUpdate() {
        List<String> logins = ((SpecifyAppContextMgr)AppContextMgr.getInstance()).getAgentListLoggedIn(AppContextMgr.getInstance().getClassObject(Discipline.class));
        if (logins.size() > 0) {
            String loginStr = "";
            int l = 0;
            while (l < logins.size()) {
                if (l > 0) {
                    loginStr = String.valueOf(loginStr) + ", ";
                }
                loginStr = String.valueOf(loginStr) + "'" + logins.get(l) + "'";
                ++l;
            }
            PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu, f:p:g, 5dlu", "5dlu, f:p:g, 2dlu, f:p:g, 2dlu, f:p:g, 5dlu"));
            pb.add((Component)new JLabel(UIRegistry.getResourceString("BaseTreeDef.OTHER_USERS")), new CellConstraints().xy(2, 2));
            pb.add((Component)new JLabel(loginStr), new CellConstraints().xy(2, 4));
            pb.add((Component)new JLabel(UIRegistry.getResourceString("BaseTreeDef.OTHER_USERS2")), new CellConstraints().xy(2, 6));
            CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("BaseTreeDef.DENIED_DLG"), true, 15, (Component)pb.getPanel());
            dlg.setApplyLabel(UIRegistry.getResourceString("BaseTreeDef.OVERRIDE"));
            dlg.setCloseOnApplyClk(true);
            dlg.createUI();
            dlg.getOkBtn().setVisible(false);
            dlg.setCancelLabel(dlg.getOkBtn().getText());
            UIHelper.centerAndShow(dlg);
            dlg.dispose();
            if (dlg.isCancelled()) {
                return false;
            }
            PanelBuilder pb2 = new PanelBuilder(new FormLayout("5dlu, f:p:g, 5dlu", "5dlu, f:p:g, 5dlu"));
            pb2.add((Component)new JLabel(UIRegistry.getResourceString("BaseTreeDef.CONFIRM_ANNIHILATION")), new CellConstraints().xy(2, 2));
            CustomDialog dlg2 = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("BaseTreeDef.DANGER"), true, 7, (Component)pb2.getPanel());
            dlg2.setOkLabel(UIRegistry.getResourceString("YES"));
            UIHelper.centerAndShow(dlg2);
            dlg2.dispose();
            if (dlg2.isCancelled()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean updateAllNodes(DataModelObjBase rootObj, boolean useProgDlg, boolean lockedByCaller) throws Exception {
        return this.treeTraversal(rootObj, useProgDlg, lockedByCaller, 0, TreeRebuilder.RebuildMode.Full);
    }

    @Override
    public boolean updateAllNodeNumbers(DataModelObjBase rootObj, boolean useProgDlg, boolean lockedByCaller) throws Exception {
        return this.treeTraversal(rootObj, useProgDlg, lockedByCaller, 0, TreeRebuilder.RebuildMode.NodeNumbers);
    }

    public boolean treeTraversal(DataModelObjBase rootObj, boolean useProgDlg, boolean lockedByCaller, int minRank, TreeRebuilder.RebuildMode rebuildMode) throws Exception {
        boolean useGlassPane;
        ProgressDialog progDlg;
        Window win;
        boolean isOnUIThread = SwingUtilities.isEventDispatchThread();
        ProgressFrame progressFrame = null;
        if (!isOnUIThread && (win = UIRegistry.getMostRecentWindow()) instanceof ProgressFrame) {
            progressFrame = (ProgressFrame)win;
        }
        final ProgressFrame progFrame = progressFrame;
        final TreeRebuilder treeRebuilder = new TreeRebuilder(this, minRank, rebuildMode);
        final JStatusBar nStatusBar = useProgDlg ? null : UIRegistry.getStatusBar();
        String progDlgMsg = UIRegistry.getResourceString("BaseTreeDef.UPDATING_TREE_DLG");
        ProgressDialog progressDialog = progDlg = nStatusBar != null || !isOnUIThread ? null : new ProgressDialog(progDlgMsg, false, false);
        if (nStatusBar != null) {
            nStatusBar.setProgressRange(treeRebuilder.getProgressName(), 0, 100);
        } else if (isOnUIThread) {
            progDlg.setResizable(false);
            progDlg.setDefaultCloseOperation(0);
            progDlg.setModal(true);
            progDlg.setProcess(0, 100);
            progDlg.setProcessPercent(true);
            if (rebuildMode.equals((Object)TreeRebuilder.RebuildMode.FullNames)) {
                progDlg.setDesc(String.format(UIRegistry.getResourceString("BaseTreeDef.UPDATING_FULLNAMES"), this.getName()));
            } else {
                progDlg.setDesc(String.format(UIRegistry.getResourceString("BaseTreeDef.UPDATING_TREE"), this.getName()));
            }
            progDlg.setAlwaysOnTop(true);
            treeRebuilder.setProgWin(progDlg);
        }
        treeRebuilder.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("progress".equals(evt.getPropertyName())) {
                    if (nStatusBar != null) {
                        nStatusBar.setValue(treeRebuilder.getProgressName(), (Integer)evt.getNewValue());
                    } else if (progDlg != null) {
                        progDlg.setProcess((Integer)evt.getNewValue());
                    } else if (progFrame != null) {
                        progFrame.setProcess((Integer)evt.getNewValue());
                    }
                }
            }
        });
        boolean ok = this.checkForOtherLoginsBeforeNodeNumberUpdate();
        if (!ok) {
            return false;
        }
        boolean wasUpToDate = TreeDefStatusMgr.isNodeNumbersAreUpToDate(this);
        this.setRenumberingNodes(true);
        this.setNodeNumbersAreUpToDate(false);
        if (!TreeDefStatusMgr.isRenumberingNodes(this) || TreeDefStatusMgr.isNodeNumbersAreUpToDate(this)) {
            UIRegistry.showLocalizedError("BaseTreeDef.UnableToUpdate");
            this.setRenumberingNodes(false);
            this.setNodeNumbersAreUpToDate(wasUpToDate);
            return false;
        }
        boolean bl = useGlassPane = !UIRegistry.isShowingGlassPane() && nStatusBar != null;
        if (isOnUIThread && !lockedByCaller && !TreeDefStatusMgr.lockTree(this, new TaskSemaphoreMgrCallerIFace(){

            @Override
            public TaskSemaphoreMgr.USER_ACTION resolveConflict(SpTaskSemaphore semaphore, boolean previouslyLocked, String prevLockBy) {
                boolean okay = UIRegistry.displayConfirm(UIRegistry.getResourceString("BaseTreeDef.TreeLockMsgTitle"), String.format(UIRegistry.getResourceString("BaseTreeDef.TreeLockMsg"), BaseTreeDef.this.getName(), prevLockBy), UIRegistry.getResourceString("BaseTreeDef.RemoveLock"), UIRegistry.getResourceString("CANCEL"), 2);
                if (okay) {
                    return TaskSemaphoreMgr.USER_ACTION.Override;
                }
                return TaskSemaphoreMgr.USER_ACTION.Error;
            }
        })) {
            this.setRenumberingNodes(false);
            this.setNodeNumbersAreUpToDate(wasUpToDate);
            return false;
        }
        if (isOnUIThread) {
            try {
                if (useGlassPane) {
                    UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getLocalizedMessage("BaseTreeDef.UPDATING_TREE", this.getName()), 24);
                } else if (nStatusBar != null) {
                    UIRegistry.displayLocalizedStatusBarText("BaseTreeDef.UPDATING_TREE", this.getName());
                }
                treeRebuilder.execute();
                if (progDlg != null && isOnUIThread) {
                    UIHelper.centerAndShow(progDlg);
                }
                this.setNodeNumbersAreUpToDate((Boolean)treeRebuilder.get());
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(BaseTreeDef.class, ex);
                log.error((Object)ex);
                UIRegistry.showLocalizedError("BaseTreeDef.UnableToUpdate");
                return false;
            }
            finally {
                this.setRenumberingNodes(false);
                if (!lockedByCaller) {
                    TreeDefStatusMgr.unlockTree(this);
                }
                if (useGlassPane) {
                    UIRegistry.clearSimpleGlassPaneMsg();
                } else if (nStatusBar != null) {
                    UIRegistry.displayStatusBarText("");
                }
                if (nStatusBar != null) {
                    nStatusBar.setProgressDone(treeRebuilder.getProgressName());
                } else {
                    progDlg.processDone();
                    progDlg.setVisible(false);
                    progDlg.dispose();
                }
            }
        }
        try {
            if (progFrame != null) {
                progFrame.setProcess(0, 100);
                progFrame.setProcessPercent(true);
                progFrame.setDesc(String.format(UIRegistry.getResourceString("BaseTreeDef.UPDATING_TREE"), this.getName()));
            }
            treeRebuilder.run();
            if (progFrame != null) {
                progFrame.setProcess(100);
            }
            this.setRenumberingNodes(false);
            this.setNodeNumbersAreUpToDate(treeRebuilder.hasCompletedOK());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(BaseTreeDef.class, ex);
            log.error((Object)ex);
            UIRegistry.showLocalizedError("BaseTreeDef.UnableToUpdate");
            return false;
        }
        return true;
    }

    public void setRenumberingNodes(boolean arg) {
        TreeDefStatusMgr.setRenumberingNodes(this, arg);
    }

    protected boolean canOverrideLock() {
        return SpecifyUser.isCurrentUserType(SpecifyUserTypes.UserType.Manager);
    }

    public boolean checkNodeNumbersUpToDate(boolean useProgDlg) throws Exception {
        boolean result;
        if (TreeDefStatusMgr.isNodeNumbersAreUpToDate(this)) {
            result = true;
        } else if (this.userCanUpdateTree()) {
            PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu, f:p:g, 5dlu", "5dlu, f:p:g, 2dlu, f:p:g, 5dlu"));
            pb.add((Component)new JLabel(String.format(UIRegistry.getResourceString("BaseTreeDef.TREE_UPDATE_REQUIRED1"), this.getName())), new CellConstraints().xy(2, 2));
            pb.add((Component)new JLabel(UIRegistry.getResourceString("BaseTreeDef.TREE_UPDATE_REQUIRED2")), new CellConstraints().xy(2, 4));
            CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("BaseTreeDef.TREE_UPDATE_REQUIRED_TITLE"), true, 7, (Component)pb.getPanel());
            dlg.setCancelLabel(UIRegistry.getResourceString("SpecifyAppContextMgr.EXIT"));
            UIHelper.centerAndShow(dlg);
            if (dlg.getBtnPressed() == 1) {
                this.updateAllNodes(null, useProgDlg, false);
                result = TreeDefStatusMgr.isNodeNumbersAreUpToDate(this);
            } else {
                result = false;
            }
        } else {
            PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu, f:p:g, 5dlu", "5dlu, f:p:g, 2dlu, f:p:g, 5dlu"));
            pb.add((Component)new JLabel(String.format(UIRegistry.getResourceString("BaseTreeDef.TREE_UPDATE_REQUIRED1"), this.getName())), new CellConstraints().xy(2, 2));
            pb.add((Component)new JLabel(UIRegistry.getResourceString("BaseTreeDef.NO_TREE_UPDATE_PERMISSION")), new CellConstraints().xy(2, 4));
            CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("BaseTreeDef.TREE_UPDATE_REQUIRED_TITLE"), true, 5, (Component)pb.getPanel());
            UIHelper.centerAndShow(dlg);
            result = false;
        }
        return result;
    }

    protected boolean userCanUpdateTree() {
        if (!AppContextMgr.isSecurityOn()) {
            return true;
        }
        return DBTableIdMgr.getInstance().getByClassName(this.getClass().getName()).getPermissions().canModify();
    }

    public boolean checkNodeRenumberingLock() {
        boolean ok;
        if (TreeDefStatusMgr.isRenumberingNodes(this) && this.canOverrideLock() && (ok = UIRegistry.displayConfirm(UIRegistry.getResourceString("BaseTreeDef.IsNumberingWarnTitle"), String.format(UIRegistry.getResourceString("BaseTreeDef.NumberingKillMsg"), this.getName()), UIRegistry.getResourceString("BaseTreeDef.RemoveLock"), UIRegistry.getResourceString("CANCEL"), 2))) {
            TreeDefStatusMgr.setRenumberingNodes(this, false);
        }
        return !TreeDefStatusMgr.isRenumberingNodes(this);
    }

    @Override
    @Transient
    public boolean isSynonymySupported() {
        return false;
    }

    @Override
    @Transient
    public boolean isRequiredLevel(int levelRank) {
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void forceLoad() {
        Set treeDefItems = this.getTreeDefItems();
        for (TreeDefItemIface tdi : treeDefItems) {
            tdi.getTreeDef();
        }
    }
}

