/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.ReferenceWork;
import edu.ku.brc.util.Orderable;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="author", uniqueConstraints={@UniqueConstraint(columnNames={"OrderNumber", "ReferenceWorkID"})})
public class Author
extends DataModelObjBase
implements Serializable,
Orderable,
Comparable<Author> {
    protected Integer authorId;
    protected Short orderNumber;
    protected String remarks;
    protected ReferenceWork referenceWork;
    protected Agent agent;

    public Author() {
    }

    public Author(Integer authorId) {
        this.authorId = authorId;
    }

    @Override
    public void initialize() {
        super.init();
        this.authorId = null;
        this.orderNumber = null;
        this.remarks = null;
        this.referenceWork = null;
        this.agent = null;
    }

    @Id
    @GeneratedValue
    @Column(name="AuthorID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getAuthorId() {
        return this.authorId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.authorId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Author.class;
    }

    public void setAuthorId(Integer authorId) {
        this.authorId = authorId;
    }

    @Column(name="OrderNumber", unique=false, nullable=false, insertable=true, updatable=true)
    public Short getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(Short orderNumber) {
        this.orderNumber = orderNumber;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ReferenceWorkID", unique=false, nullable=false, insertable=true, updatable=true)
    public ReferenceWork getReferenceWork() {
        return this.referenceWork;
    }

    public void setReferenceWork(ReferenceWork referenceWork) {
        this.referenceWork = referenceWork;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AgentID", unique=false, nullable=false, insertable=true, updatable=true)
    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        String name = "";
        if (this.agent != null) {
            name = this.agent.getIdentityTitle();
        }
        if (StringUtils.isNotEmpty((String)name)) {
            return name;
        }
        return super.getIdentityTitle();
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return ReferenceWork.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.referenceWork != null ? this.referenceWork.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return Author.getClassTableId();
    }

    public static int getClassTableId() {
        return 17;
    }

    @Override
    @Transient
    public int getOrderIndex() {
        return this.orderNumber.shortValue();
    }

    @Override
    public void setOrderIndex(int order) {
        this.orderNumber = (short)order;
    }

    @Override
    public int compareTo(Author obj) {
        return this.orderNumber != null && obj != null && obj.orderNumber != null ? this.orderNumber.compareTo(obj.orderNumber) : 0;
    }
}

