/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.CollectingEventAttr;
import edu.ku.brc.specify.datamodel.CollectionObjectAttr;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.PrepType;
import edu.ku.brc.specify.datamodel.PreparationAttr;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="attributedef")
public class AttributeDef
extends DataModelObjBase
implements Serializable {
    protected Integer attributeDefId;
    protected Short tableType;
    protected String fieldName;
    protected Short dataType;
    protected Discipline discipline;
    protected PrepType prepType;
    protected Set<CollectingEventAttr> collectingEventAttrs;
    protected Set<PreparationAttr> preparationAttrs;
    protected Set<CollectionObjectAttr> collectionObjectAttrs;

    public AttributeDef() {
    }

    public AttributeDef(Integer attributeDefId) {
        this.attributeDefId = attributeDefId;
    }

    @Override
    public void initialize() {
        super.init();
        this.attributeDefId = null;
        this.tableType = null;
        this.fieldName = null;
        this.dataType = null;
        this.discipline = AppContextMgr.getInstance().getClassObject(Discipline.class);
        this.prepType = null;
        this.collectingEventAttrs = new HashSet<CollectingEventAttr>();
        this.preparationAttrs = new HashSet<PreparationAttr>();
        this.collectionObjectAttrs = new HashSet<CollectionObjectAttr>();
    }

    @Id
    @GeneratedValue
    @Column(name="AttributeDefID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getAttributeDefId() {
        return this.attributeDefId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.attributeDefId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return AttributeDef.class;
    }

    public void setAttributeDefId(Integer attributeDefId) {
        this.attributeDefId = attributeDefId;
    }

    @Column(name="TableType", unique=false, nullable=true, insertable=true, updatable=true)
    public Short getTableType() {
        return this.tableType;
    }

    public void setTableType(Short tableType) {
        this.tableType = tableType;
    }

    @Column(name="FieldName", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Column(name="DataType", unique=false, nullable=true, insertable=true, updatable=true)
    public Short getDataType() {
        return this.dataType;
    }

    public void setDataType(Short dataType) {
        this.dataType = dataType;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="DisciplineID", unique=false, nullable=false, insertable=true, updatable=true)
    public Discipline getDiscipline() {
        return this.discipline;
    }

    public void setDiscipline(Discipline discipline) {
        this.discipline = discipline;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="PrepTypeID", unique=false, nullable=true, insertable=true, updatable=true)
    public PrepType getPrepType() {
        return this.prepType;
    }

    public void setPrepType(PrepType prepType) {
        this.prepType = prepType;
    }

    @OneToMany(cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY, mappedBy="definition")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<CollectingEventAttr> getCollectingEventAttrs() {
        return this.collectingEventAttrs;
    }

    public void setCollectingEventAttrs(Set<CollectingEventAttr> collectingEventAttrs) {
        this.collectingEventAttrs = collectingEventAttrs;
    }

    @OneToMany(cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY, mappedBy="definition")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<PreparationAttr> getPreparationAttrs() {
        return this.preparationAttrs;
    }

    public void setPreparationAttrs(Set<PreparationAttr> preparationAttrs) {
        this.preparationAttrs = preparationAttrs;
    }

    @OneToMany(cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY, mappedBy="definition")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<CollectionObjectAttr> getCollectionObjectAttrs() {
        return this.collectionObjectAttrs;
    }

    public void setCollectionObjectAttrs(Set<CollectionObjectAttr> collectionObjectAttrs) {
        this.collectionObjectAttrs = collectionObjectAttrs;
    }

    public void addCollectingEventAttrs(CollectingEventAttr collectingEventAttr) {
        this.collectingEventAttrs.add(collectingEventAttr);
        collectingEventAttr.setDefinition(this);
    }

    public void addPreparationAttrs(PreparationAttr preparationAttrArg) {
        this.preparationAttrs.add(preparationAttrArg);
        preparationAttrArg.setDefinition(this);
    }

    public void addCollectionObjectAttrs(CollectionObjectAttr collectionObjectAttr) {
        this.collectionObjectAttrs.add(collectionObjectAttr);
        collectionObjectAttr.setDefinition(this);
    }

    public void removeCollectingEventAttrs(CollectingEventAttr collectingEventAttr) {
        this.collectingEventAttrs.remove(collectingEventAttr);
        collectingEventAttr.setCollectingEvent(null);
    }

    public void removePreparationAttrs(PreparationAttr preparationAttrArg) {
        this.preparationAttrs.remove(preparationAttrArg);
        preparationAttrArg.setPreparation(null);
    }

    public void removeCollectionObjectAttrs(CollectionObjectAttr collectionObjectAttr) {
        this.collectionObjectAttrs.remove(collectionObjectAttr);
        collectionObjectAttr.setCollectionObject(null);
    }

    @Override
    @Transient
    public Integer getParentId() {
        Vector<Object> ids = BasicSQLUtils.querySingleCol("SELECT AttributeDefID FROM collectingeventattr WHERE AttributeDefID = " + this.attributeDefId);
        if (ids.size() == 1) {
            this.parentTblId = CollectingEventAttr.getClassTableId();
            return (Integer)ids.get(0);
        }
        ids = BasicSQLUtils.querySingleCol("SELECT AttributeDefID FROM preparationattr WHERE AttributeDefID = " + this.attributeDefId);
        if (ids.size() == 1) {
            this.parentTblId = PreparationAttr.getClassTableId();
            return (Integer)ids.get(0);
        }
        ids = BasicSQLUtils.querySingleCol("SELECT AttributeDefID FROM collectionobjectattr WHERE AttributeDefID = " + this.attributeDefId);
        if (ids.size() == 1) {
            this.parentTblId = CollectionObjectAttr.getClassTableId();
            return (Integer)ids.get(0);
        }
        this.parentTblId = null;
        return null;
    }

    @Override
    @Transient
    public int getTableId() {
        return AttributeDef.getClassTableId();
    }

    public static int getClassTableId() {
        return 16;
    }
}

