/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.specify.datamodel.AccessionAttachment;
import edu.ku.brc.specify.datamodel.AgentAttachment;
import edu.ku.brc.specify.datamodel.AttachmentImageAttribute;
import edu.ku.brc.specify.datamodel.AttachmentMetadata;
import edu.ku.brc.specify.datamodel.AttachmentTag;
import edu.ku.brc.specify.datamodel.BorrowAttachment;
import edu.ku.brc.specify.datamodel.CollectingEventAttachment;
import edu.ku.brc.specify.datamodel.CollectionObjectAttachment;
import edu.ku.brc.specify.datamodel.ConservDescriptionAttachment;
import edu.ku.brc.specify.datamodel.ConservEventAttachment;
import edu.ku.brc.specify.datamodel.DNASequenceAttachment;
import edu.ku.brc.specify.datamodel.DNASequencingRunAttachment;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.FieldNotebookAttachment;
import edu.ku.brc.specify.datamodel.FieldNotebookPageAttachment;
import edu.ku.brc.specify.datamodel.FieldNotebookPageSetAttachment;
import edu.ku.brc.specify.datamodel.GiftAttachment;
import edu.ku.brc.specify.datamodel.LoanAttachment;
import edu.ku.brc.specify.datamodel.LocalityAttachment;
import edu.ku.brc.specify.datamodel.ObjectAttachmentIFace;
import edu.ku.brc.specify.datamodel.PermitAttachment;
import edu.ku.brc.specify.datamodel.PreparationAttachment;
import edu.ku.brc.specify.datamodel.ReferenceWorkAttachment;
import edu.ku.brc.specify.datamodel.RepositoryAgreementAttachment;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.TaxonAttachment;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentManagerIface;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.thumbnails.Thumbnailer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="attachment")
@Table(appliesTo="attachment", indexes={@Index(name="TitleIDX", columnNames={"Title"}), @Index(name="DateImagedIDX", columnNames={"DateImaged"})})
public class Attachment
extends DataModelObjBase
implements Serializable {
    protected Integer attachmentId;
    protected String mimeType;
    protected String origFilename;
    protected String title;
    protected String license;
    protected String copyrightHolder;
    protected String copyrightDate;
    protected String credit;
    protected String dateImaged;
    protected Calendar fileCreatedDate;
    protected String remarks;
    protected String attachmentLocation;
    protected Byte visibility;
    protected SpecifyUser visibilitySetBy;
    protected Set<AttachmentMetadata> metadata;
    protected Set<AttachmentTag> tags;
    protected AttachmentImageAttribute attachmentImageAttribute;
    protected boolean storeFile;
    protected Set<AccessionAttachment> accessionAttachments;
    protected Set<AgentAttachment> agentAttachments;
    protected Set<BorrowAttachment> borrowAttachments;
    protected Set<CollectingEventAttachment> collectingEventAttachments;
    protected Set<CollectionObjectAttachment> collectionObjectAttachments;
    protected Set<ConservDescriptionAttachment> conservDescriptionAttachments;
    protected Set<ConservEventAttachment> conservEventAttachments;
    protected Set<DNASequenceAttachment> dnaSequenceAttachments;
    protected Set<DNASequencingRunAttachment> dnaSequencingRunAttachments;
    protected Set<FieldNotebookAttachment> fieldNotebookAttachments;
    protected Set<FieldNotebookPageAttachment> fieldNotebookPageAttachments;
    protected Set<FieldNotebookPageSetAttachment> fieldNotebookPageSetAttachments;
    protected Set<GiftAttachment> giftAttachments;
    protected Set<LoanAttachment> loanAttachments;
    protected Set<LocalityAttachment> localityAttachments;
    protected Set<PermitAttachment> permitAttachments;
    protected Set<PreparationAttachment> preparationAttachments;
    protected Set<ReferenceWorkAttachment> referenceWorkAttachments;
    protected Set<RepositoryAgreementAttachment> repositoryAgreementAttachments;
    protected Set<TaxonAttachment> taxonAttachments;

    public Attachment() {
    }

    public Attachment(Integer attachmentId) {
        this.attachmentId = attachmentId;
    }

    @Override
    public void initialize() {
        super.init();
        this.attachmentId = null;
        this.mimeType = null;
        this.origFilename = null;
        this.fileCreatedDate = null;
        this.remarks = null;
        this.attachmentLocation = null;
        this.title = null;
        this.license = null;
        this.copyrightHolder = null;
        this.credit = null;
        this.copyrightDate = null;
        this.dateImaged = null;
        this.metadata = new HashSet<AttachmentMetadata>();
        this.tags = new HashSet<AttachmentTag>();
        this.storeFile = false;
        this.accessionAttachments = new HashSet<AccessionAttachment>();
        this.agentAttachments = new HashSet<AgentAttachment>();
        this.borrowAttachments = new HashSet<BorrowAttachment>();
        this.collectionObjectAttachments = new HashSet<CollectionObjectAttachment>();
        this.collectingEventAttachments = new HashSet<CollectingEventAttachment>();
        this.conservDescriptionAttachments = new HashSet<ConservDescriptionAttachment>();
        this.conservEventAttachments = new HashSet<ConservEventAttachment>();
        this.dnaSequenceAttachments = new HashSet<DNASequenceAttachment>();
        this.dnaSequencingRunAttachments = new HashSet<DNASequencingRunAttachment>();
        this.giftAttachments = new HashSet<GiftAttachment>();
        this.loanAttachments = new HashSet<LoanAttachment>();
        this.localityAttachments = new HashSet<LocalityAttachment>();
        this.permitAttachments = new HashSet<PermitAttachment>();
        this.preparationAttachments = new HashSet<PreparationAttachment>();
        this.repositoryAgreementAttachments = new HashSet<RepositoryAgreementAttachment>();
        this.referenceWorkAttachments = new HashSet<ReferenceWorkAttachment>();
        this.taxonAttachments = new HashSet<TaxonAttachment>();
    }

    @Id
    @GeneratedValue
    @Column(name="AttachmentID")
    public Integer getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(Integer attachmentId) {
        this.attachmentId = attachmentId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.attachmentId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Attachment.class;
    }

    @Column(name="MimeType", length=64)
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Column(name="OrigFilename", nullable=false, length=128)
    public String getOrigFilename() {
        return this.origFilename;
    }

    public void setOrigFilename(String origFilename) {
        this.origFilename = origFilename;
        if (this.mimeType == null && this.origFilename != null) {
            this.mimeType = AttachmentUtils.getMimeType(origFilename);
        }
    }

    @Column(name="Title", length=64)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name="License", length=64)
    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    @Column(name="CopyrightDate", length=64)
    public String getCopyrightDate() {
        return this.copyrightDate;
    }

    public void setCopyrightDate(String copyrightDate) {
        this.copyrightDate = copyrightDate;
    }

    @Column(name="CopyrightHolder", length=64)
    public String getCopyrightHolder() {
        return this.copyrightHolder;
    }

    public void setCopyrightHolder(String copyrightHolder) {
        this.copyrightHolder = copyrightHolder;
    }

    @Column(name="Credit", length=64)
    public String getCredit() {
        return this.credit;
    }

    public void setCredit(String credit) {
        this.credit = credit;
    }

    @Column(name="DateImaged", length=64)
    public String getDateImaged() {
        return this.dateImaged;
    }

    public void setDateImaged(String dateImaged) {
        this.dateImaged = dateImaged;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="FileCreatedDate")
    public Calendar getFileCreatedDate() {
        return this.fileCreatedDate;
    }

    public void setFileCreatedDate(Calendar fileCreatedDate) {
        this.fileCreatedDate = fileCreatedDate;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="AttachmentLocation", length=128)
    public String getAttachmentLocation() {
        return this.attachmentLocation;
    }

    public void setAttachmentLocation(String attachmentLocation) {
        this.attachmentLocation = attachmentLocation;
    }

    @Column(name="Visibility")
    public Byte getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Byte visibility) {
        this.visibility = visibility;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="VisibilitySetByID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpecifyUser getVisibilitySetBy() {
        return this.visibilitySetBy;
    }

    public void setVisibilitySetBy(SpecifyUser visibilitySetBy) {
        this.visibilitySetBy = visibilitySetBy;
    }

    @OneToMany(fetch=FetchType.EAGER, mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<AttachmentMetadata> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Set<AttachmentMetadata> metadata) {
        this.metadata = metadata;
    }

    @OneToMany(fetch=FetchType.EAGER, mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<AttachmentTag> getTags() {
        return this.tags;
    }

    public void setTags(Set<AttachmentTag> tags) {
        this.tags = tags;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<AccessionAttachment> getAccessionAttachments() {
        return this.accessionAttachments;
    }

    public void setAccessionAttachments(Set<AccessionAttachment> accessionAttachments) {
        this.accessionAttachments = accessionAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<AgentAttachment> getAgentAttachments() {
        return this.agentAttachments;
    }

    public void setAgentAttachments(Set<AgentAttachment> agentAttachments) {
        this.agentAttachments = agentAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<CollectingEventAttachment> getCollectingEventAttachments() {
        return this.collectingEventAttachments;
    }

    public void setCollectingEventAttachments(Set<CollectingEventAttachment> collectingEventAttachments) {
        this.collectingEventAttachments = collectingEventAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<CollectionObjectAttachment> getCollectionObjectAttachments() {
        return this.collectionObjectAttachments;
    }

    public void setCollectionObjectAttachments(Set<CollectionObjectAttachment> collectionObjectAttachments) {
        this.collectionObjectAttachments = collectionObjectAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<ConservDescriptionAttachment> getConservDescriptionAttachments() {
        return this.conservDescriptionAttachments;
    }

    public void setConservDescriptionAttachments(Set<ConservDescriptionAttachment> conservDescriptionAttachments) {
        this.conservDescriptionAttachments = conservDescriptionAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<ConservEventAttachment> getConservEventAttachments() {
        return this.conservEventAttachments;
    }

    public void setConservEventAttachments(Set<ConservEventAttachment> conservEventAttachments) {
        this.conservEventAttachments = conservEventAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<DNASequenceAttachment> getDnaSequenceAttachments() {
        return this.dnaSequenceAttachments;
    }

    public void setDnaSequenceAttachments(Set<DNASequenceAttachment> dnaSequenceAttachments) {
        this.dnaSequenceAttachments = dnaSequenceAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<DNASequencingRunAttachment> getDnaSequencingRunAttachments() {
        return this.dnaSequencingRunAttachments;
    }

    public void setDnaSequencingRunAttachments(Set<DNASequencingRunAttachment> dnaSequencingRunAttachments) {
        this.dnaSequencingRunAttachments = dnaSequencingRunAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<FieldNotebookAttachment> getFieldNotebookAttachments() {
        return this.fieldNotebookAttachments;
    }

    public void setFieldNotebookAttachments(Set<FieldNotebookAttachment> fieldNotebookAttachments) {
        this.fieldNotebookAttachments = fieldNotebookAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<FieldNotebookPageAttachment> getFieldNotebookPageAttachments() {
        return this.fieldNotebookPageAttachments;
    }

    public void setFieldNotebookPageAttachments(Set<FieldNotebookPageAttachment> fieldNotebookPageAttachments) {
        this.fieldNotebookPageAttachments = fieldNotebookPageAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<FieldNotebookPageSetAttachment> getFieldNotebookPageSetAttachments() {
        return this.fieldNotebookPageSetAttachments;
    }

    public void setFieldNotebookPageSetAttachments(Set<FieldNotebookPageSetAttachment> fieldNotebookPageSetAttachments) {
        this.fieldNotebookPageSetAttachments = fieldNotebookPageSetAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<LoanAttachment> getLoanAttachments() {
        return this.loanAttachments;
    }

    public void setLoanAttachments(Set<LoanAttachment> loanAttachments) {
        this.loanAttachments = loanAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<LocalityAttachment> getLocalityAttachments() {
        return this.localityAttachments;
    }

    public void setLocalityAttachments(Set<LocalityAttachment> localityAttachments) {
        this.localityAttachments = localityAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<PreparationAttachment> getPreparationAttachments() {
        return this.preparationAttachments;
    }

    public void setPreparationAttachments(Set<PreparationAttachment> preparationAttachments) {
        this.preparationAttachments = preparationAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<PermitAttachment> getPermitAttachments() {
        return this.permitAttachments;
    }

    public void setPermitAttachments(Set<PermitAttachment> permitAttachments) {
        this.permitAttachments = permitAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<RepositoryAgreementAttachment> getRepositoryAgreementAttachments() {
        return this.repositoryAgreementAttachments;
    }

    public void setRepositoryAgreementAttachments(Set<RepositoryAgreementAttachment> repositoryAgreementAttachments) {
        this.repositoryAgreementAttachments = repositoryAgreementAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<TaxonAttachment> getTaxonAttachments() {
        return this.taxonAttachments;
    }

    public void setTaxonAttachments(Set<TaxonAttachment> taxonAttachments) {
        this.taxonAttachments = taxonAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<BorrowAttachment> getBorrowAttachments() {
        return this.borrowAttachments;
    }

    public void setBorrowAttachments(Set<BorrowAttachment> borrowAttachments) {
        this.borrowAttachments = borrowAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<GiftAttachment> getGiftAttachments() {
        return this.giftAttachments;
    }

    public void setGiftAttachments(Set<GiftAttachment> giftAttachments) {
        this.giftAttachments = giftAttachments;
    }

    @OneToMany(mappedBy="attachment")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public Set<ReferenceWorkAttachment> getReferenceWorkAttachments() {
        return this.referenceWorkAttachments;
    }

    public void setReferenceWorkAttachments(Set<ReferenceWorkAttachment> referenceWorkAttachments) {
        this.referenceWorkAttachments = referenceWorkAttachments;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="AttachmentImageAttributeID", unique=false, nullable=true, insertable=true, updatable=true)
    public AttachmentImageAttribute getAttachmentImageAttribute() {
        return this.attachmentImageAttribute;
    }

    public void setAttachmentImageAttribute(AttachmentImageAttribute attachmentImageAttribute) {
        this.attachmentImageAttribute = attachmentImageAttribute;
    }

    @Override
    @Transient
    public int getTableId() {
        return Attachment.getClassTableId();
    }

    public static int getClassTableId() {
        return 41;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        int lastUnixSepIndex;
        int lastWinSepIndex;
        int lastIndex;
        String filename = this.getOrigFilename();
        if (filename != null && (lastIndex = Math.max(lastWinSepIndex = filename.lastIndexOf(92), lastUnixSepIndex = filename.lastIndexOf(47))) != -1) {
            filename = filename.substring(lastIndex + 1);
        }
        return String.valueOf(this.title) + ": " + filename;
    }

    @Transient
    public boolean isStoreFile() {
        return this.storeFile;
    }

    public void setStoreFile(boolean storeFile) {
        this.storeFile = storeFile;
    }

    public void storeFile(boolean doDisplayErrors) throws IOException {
        Thumbnailer thumbnailGen = AttachmentUtils.getThumbnailer();
        AttachmentManagerIface attachmentMgr = AttachmentUtils.getAttachmentManager();
        File origFile = new File(this.origFilename);
        File thumbFile = null;
        try {
            thumbFile = File.createTempFile("sp6_thumb_", null);
            thumbFile.deleteOnExit();
            thumbnailGen.generateThumbnail(this.origFilename, thumbFile.getAbsolutePath(), false);
        }
        catch (IOException e) {
            thumbFile = null;
        }
        try {
            try {
                attachmentMgr.storeAttachmentFile(this, origFile, thumbFile);
            }
            catch (IOException ex) {
                if (doDisplayErrors) {
                    AppPreferences prefs = AppPreferences.getGlobalPrefs().getBoolean("USE_GLOBAL_PREFS", false) != false ? AppPreferences.getGlobalPrefs() : AppPreferences.getLocalPrefs();
                    boolean useFilePath = prefs.getBoolean("attachment.use_path", true);
                    String msgKey = "ATTCH_NOT_SAVED_REPOS" + (useFilePath ? "" : "_WEB");
                    String errMsg = ex.getMessage();
                    UIRegistry.showLocalizedError(msgKey, this.origFilename, StringUtils.isNotEmpty((String)errMsg) ? errMsg : "");
                    this.storeFile = false;
                    return;
                }
                throw ex;
            }
        }
        finally {
            this.storeFile = false;
        }
    }

    public static String getIdentityTitle(ObjectAttachmentIFace<?> objAttachment) {
        Integer id;
        Attachment attachment;
        if (objAttachment != null && (attachment = objAttachment.getAttachment()) != null) {
            String title = attachment.getTitle();
            if (StringUtils.isNotEmpty((String)title)) {
                return title;
            }
            String fileName = attachment.getOrigFilename();
            if (StringUtils.isNotEmpty((String)(fileName = FilenameUtils.getName((String)fileName)))) {
                return fileName;
            }
        }
        return (id = ((FormDataObjIFace)((Object)objAttachment)).getId()) != null ? id.toString() : "N/A";
    }
}

