/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="appraisal")
@Table(appliesTo="appraisal", indexes={@Index(name="AppraisalNumberIDX", columnNames={"AppraisalNumber"}), @Index(name="AppraisalDateIDX", columnNames={"AppraisalDate"})})
public class Appraisal
extends DataModelObjBase {
    protected Integer appraisalId;
    protected Calendar appraisalDate;
    protected String appraisalNumber;
    protected BigDecimal appraisalValue;
    protected String monetaryUnitType;
    protected String notes;
    protected Set<CollectionObject> collectionObjects;
    protected Accession accession;
    protected Agent agent;

    @Override
    public void initialize() {
        super.init();
        this.appraisalId = null;
        this.appraisalDate = null;
        this.appraisalNumber = null;
        this.appraisalValue = null;
        this.monetaryUnitType = null;
        this.notes = null;
        this.agent = null;
        this.collectionObjects = new HashSet<CollectionObject>();
        this.accession = null;
    }

    public void setAppraisalId(Integer appraisalId) {
        this.appraisalId = appraisalId;
    }

    public void setAppraisalDate(Calendar appraisalDate) {
        this.appraisalDate = appraisalDate;
    }

    public void setAppraisalNumber(String appraisalNumber) {
        this.appraisalNumber = appraisalNumber;
    }

    public void setAppraisalValue(BigDecimal appraisalValue) {
        this.appraisalValue = appraisalValue;
    }

    public void setMonetaryUnitType(String monetaryUnitType) {
        this.monetaryUnitType = monetaryUnitType;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void setCollectionObjects(Set<CollectionObject> collectionObjects) {
        this.collectionObjects = collectionObjects;
    }

    public void setAccession(Accession accession) {
        this.accession = accession;
    }

    @Id
    @GeneratedValue
    @Column(name="AppraisalID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getAppraisalId() {
        return this.appraisalId;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="AppraisalDate", unique=false, nullable=false, insertable=true, updatable=true)
    public Calendar getAppraisalDate() {
        return this.appraisalDate;
    }

    @Column(name="AppraisalNumber", unique=true, nullable=false, insertable=true, updatable=true, length=64)
    public String getAppraisalNumber() {
        return this.appraisalNumber;
    }

    @Column(name="AppraisalValue", unique=false, nullable=true, insertable=true, updatable=true, precision=12, scale=2)
    public BigDecimal getAppraisalValue() {
        return this.appraisalValue;
    }

    @Column(name="MonetaryUnitType", unique=false, nullable=true, insertable=true, updatable=true, length=8)
    public String getMonetaryUnitType() {
        return this.monetaryUnitType;
    }

    @Lob
    @Column(name="Notes", unique=false, nullable=true, insertable=true, updatable=true, length=2048)
    public String getNotes() {
        return this.notes;
    }

    @OneToMany(cascade={}, mappedBy="appraisal")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    public Set<CollectionObject> getCollectionObjects() {
        return this.collectionObjects;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    @JoinColumn(name="AccessionID", unique=false, nullable=true, insertable=true, updatable=true)
    public Accession getAccession() {
        return this.accession;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AgentID", unique=false, nullable=false, insertable=true, updatable=true)
    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Appraisal.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.appraisalId;
    }

    @Override
    @Transient
    public Integer getParentId() {
        if (this.accession != null) {
            this.parentTblId = Accession.getClassTableId();
            return this.accession.getId();
        }
        Vector<Object> ids = BasicSQLUtils.querySingleCol("SELECT CollectionObjectID FROM collectionobject WHERE AppraisalID = " + this.appraisalId);
        if (ids.size() == 1) {
            this.parentTblId = CollectionObject.getClassTableId();
            return (Integer)ids.get(0);
        }
        this.parentTblId = null;
        return null;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return StringUtils.isNotEmpty((String)this.appraisalNumber) ? this.appraisalNumber : super.getIdentityTitle();
    }

    @Override
    @Transient
    public int getTableId() {
        return Appraisal.getClassTableId();
    }

    public static int getClassTableId() {
        return 67;
    }
}

