/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="agentvariant")
public class AgentVariant
extends DataModelObjBase
implements Serializable,
Cloneable {
    public static final Byte VARIANT = 0;
    public static final Byte VERNACULAR = 1;
    public static final Byte AUTHOR = 2;
    public static final Byte AUTHOR_ABBREV = 3;
    public static final Byte LABLELNAME = 4;
    protected Integer agentVariantId;
    protected String country;
    protected String language;
    protected String variant;
    protected Byte varType;
    protected String name;
    protected Agent agent;

    public AgentVariant() {
    }

    public AgentVariant(Integer agentVariantId) {
        this.agentVariantId = agentVariantId;
    }

    @Override
    public void initialize() {
        super.init();
        this.agentVariantId = null;
        this.name = null;
        this.country = null;
        this.language = null;
        this.variant = null;
        this.agent = null;
    }

    @Id
    @GeneratedValue
    @Column(name="AgentVariantID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getAgentVariantId() {
        return this.agentVariantId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.agentVariantId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return AgentVariant.class;
    }

    public void setAgentVariantId(Integer agentVariantId) {
        this.agentVariantId = agentVariantId;
    }

    @Column(name="Name", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="Language", unique=false, nullable=true, insertable=true, updatable=true, length=2)
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Column(name="Country", unique=false, nullable=true, insertable=true, updatable=true, length=2)
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @Column(name="Variant", unique=false, nullable=true, insertable=true, updatable=true, length=2)
    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    @Column(name="VarType", unique=false, nullable=false, insertable=true, updatable=true)
    public Byte getVarType() {
        return this.varType;
    }

    public void setVarType(Byte varType) {
        this.varType = varType;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AgentID", unique=false, nullable=false, insertable=true, updatable=true)
    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Agent.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.agent != null ? this.agent.getId() : null;
    }

    @Override
    @Transient
    public int getTableId() {
        return AgentVariant.getClassTableId();
    }

    public static int getClassTableId() {
        return 107;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return this.name != null ? this.name : super.getIdentityTitle();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AgentVariant obj = (AgentVariant)super.clone();
        obj.setAgentVariantId(null);
        return obj;
    }
}

