/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.util.Orderable;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="agentspecialty", uniqueConstraints={@UniqueConstraint(columnNames={"AgentID", "OrderNumber"})})
public class AgentSpecialty
extends DataModelObjBase
implements Serializable,
Orderable,
Comparable<AgentSpecialty>,
Cloneable {
    protected Integer agentSpecialtyId;
    protected Integer orderNumber;
    protected String specialtyName;
    protected Agent agent;

    public AgentSpecialty() {
    }

    public AgentSpecialty(Integer agentSpecialtyId) {
        this.agentSpecialtyId = agentSpecialtyId;
    }

    @Override
    public void initialize() {
        super.init();
        this.agentSpecialtyId = null;
        this.orderNumber = null;
        this.specialtyName = null;
        this.agent = null;
    }

    @Id
    @GeneratedValue
    @Column(name="AgentSpecialtyID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getAgentSpecialtyId() {
        return this.agentSpecialtyId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.agentSpecialtyId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return AgentSpecialty.class;
    }

    @Column(name="OrderNumber", nullable=false)
    public Integer getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(Integer orderNumber) {
        this.orderNumber = orderNumber;
    }

    public void setAgentSpecialtyId(Integer agentSpecialtyId) {
        this.agentSpecialtyId = agentSpecialtyId;
    }

    @Column(name="SpecialtyName", unique=false, nullable=false, insertable=true, updatable=true, length=64)
    public String getSpecialtyName() {
        return this.specialtyName;
    }

    public void setSpecialtyName(String specialtyName) {
        this.specialtyName = specialtyName;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AgentID", unique=false, nullable=false, insertable=true, updatable=true)
    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    @Override
    @Transient
    public int getTableId() {
        return AgentSpecialty.getClassTableId();
    }

    public static int getClassTableId() {
        return 86;
    }

    @Override
    @Transient
    public int getOrderIndex() {
        return this.getOrderNumber();
    }

    @Override
    public void setOrderIndex(int order) {
        this.setOrderNumber(order);
    }

    @Override
    public int compareTo(AgentSpecialty obj) {
        return this.orderNumber != null && obj != null && obj.orderNumber != null ? this.orderNumber.compareTo(obj.orderNumber) : 0;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Agent.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.agent != null ? this.agent.getId() : null;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        String name = "";
        if (this.agent != null) {
            name = this.agent.getIdentityTitle();
        }
        if (StringUtils.isNotEmpty((String)name)) {
            return name;
        }
        return super.getIdentityTitle();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AgentSpecialty obj = (AgentSpecialty)super.clone();
        obj.setAgentSpecialtyId(null);
        return obj;
    }
}

