/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.af.ui.forms.formatters.DataObjFieldFormatMgr;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Address;
import edu.ku.brc.specify.datamodel.AgentAttachment;
import edu.ku.brc.specify.datamodel.AgentGeography;
import edu.ku.brc.specify.datamodel.AgentSpecialty;
import edu.ku.brc.specify.datamodel.AgentVariant;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.Collector;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.GroupPerson;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.busrules.AgentBusRules;
import edu.ku.brc.specify.dbsupport.TypeCode;
import edu.ku.brc.specify.dbsupport.TypeCodeItem;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.UIRegistry;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="agent")
@Table(appliesTo="agent", indexes={@Index(name="AgentLastNameIDX", columnNames={"LastName"}), @Index(name="AgentFirstNameIDX", columnNames={"FirstName"}), @Index(name="AgentGuidIDX", columnNames={"GUID"}), @Index(name="AgentTypeIDX", columnNames={"AgentType"}), @Index(name="AbbreviationIDX", columnNames={"Abbreviation"})})
public class Agent
extends DataModelObjBase
implements Serializable,
AttachmentOwnerIFace<AgentAttachment>,
Cloneable {
    private static Agent userAgent = null;
    public static final byte ORG = 0;
    public static final byte PERSON = 1;
    public static final byte OTHER = 2;
    public static final byte GROUP = 3;
    protected Integer agentId;
    protected Byte agentType;
    protected String firstName;
    protected String lastName;
    protected String middleInitial;
    protected String title;
    protected Byte dateType;
    protected Calendar dateOfBirth;
    protected Byte dateOfBirthPrecision;
    protected Calendar dateOfDeath;
    protected Byte dateOfDeathPrecision;
    protected String interests;
    protected String abbreviation;
    protected String initials;
    protected String remarks;
    protected String guid;
    protected Set<Agent> orgMembers;
    protected Agent organization;
    protected Set<GroupPerson> groups;
    protected Set<GroupPerson> members;
    protected Set<Collector> collectors;
    protected Division division;
    protected Institution instTechContact;
    protected Institution instContentContact;
    protected Collection collTechContact;
    protected Collection collContentContact;
    protected SpecifyUser specifyUser;
    protected String jobTitle;
    protected String email;
    protected String url;
    protected Set<Address> addresses;
    protected Set<AgentVariant> variants;
    protected Set<AgentAttachment> agentAttachments;
    protected Set<AgentGeography> agentGeographies;
    protected Set<AgentSpecialty> agentSpecialties;
    protected static Agent currentUserAgent = null;

    public Agent() {
    }

    public Agent(Integer agentId) {
        this.agentId = agentId;
    }

    @Override
    public void initialize() {
        super.init();
        this.agentId = null;
        this.agentType = 1;
        this.firstName = null;
        this.lastName = null;
        this.middleInitial = null;
        this.title = null;
        this.dateType = null;
        this.dateOfBirth = null;
        this.dateOfBirthPrecision = null;
        this.dateOfDeath = null;
        this.dateOfDeathPrecision = null;
        this.interests = null;
        this.abbreviation = null;
        this.initials = null;
        this.remarks = null;
        this.guid = null;
        this.orgMembers = new HashSet<Agent>();
        this.organization = null;
        this.groups = new HashSet<GroupPerson>();
        this.members = new HashSet<GroupPerson>();
        this.collectors = new HashSet<Collector>();
        this.division = null;
        this.instTechContact = null;
        this.instContentContact = null;
        this.collTechContact = null;
        this.collContentContact = null;
        this.specifyUser = null;
        this.jobTitle = null;
        this.email = null;
        this.url = null;
        this.remarks = null;
        this.addresses = new HashSet<Address>();
        this.agentAttachments = new HashSet<AgentAttachment>();
        this.variants = new HashSet<AgentVariant>();
        this.agentGeographies = new HashSet<AgentGeography>();
        this.agentSpecialties = new HashSet<AgentSpecialty>();
    }

    @Id
    @GeneratedValue
    @Column(name="AgentID")
    public Integer getAgentId() {
        return this.agentId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.agentId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Agent.class;
    }

    public void setAgentId(Integer agentId) {
        this.agentId = agentId;
    }

    @Override
    public void forceLoad() {
        super.forceLoad();
    }

    @Column(name="AgentType", nullable=false)
    public Byte getAgentType() {
        return this.agentType;
    }

    public void setAgentType(Byte agentType) {
        this.agentType = agentType;
    }

    @Column(name="FirstName", length=50)
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="LastName", length=120)
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(name="MiddleInitial", length=50)
    public String getMiddleInitial() {
        return this.middleInitial;
    }

    public void setMiddleInitial(String middleInitial) {
        this.middleInitial = middleInitial;
    }

    @Column(name="Title", length=50)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name="DateType", unique=false, nullable=true, insertable=true, updatable=true)
    public Byte getDateType() {
        return this.dateType;
    }

    public void setDateType(Byte dateType) {
        this.dateType = dateType;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DateOfBirth", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Calendar dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    @Column(name="DateOfBirthPrecision", unique=false, nullable=true, insertable=true, updatable=true)
    public Byte getDateOfBirthPrecision() {
        return this.dateOfBirthPrecision;
    }

    public void setDateOfBirthPrecision(Byte dateOfBirthPrecision) {
        this.dateOfBirthPrecision = dateOfBirthPrecision;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DateOfDeath", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDateOfDeath() {
        return this.dateOfDeath;
    }

    public void setDateOfDeath(Calendar dateOfDeath) {
        this.dateOfDeath = dateOfDeath;
    }

    @Column(name="DateOfDeathPrecision", unique=false, nullable=true, insertable=true, updatable=true)
    public Byte getDateOfDeathPrecision() {
        return this.dateOfDeathPrecision;
    }

    public void setDateOfDeathPrecision(Byte dateOfDeathPrecision) {
        this.dateOfDeathPrecision = dateOfDeathPrecision;
    }

    @Column(name="Interests", length=255)
    public String getInterests() {
        return this.interests;
    }

    public void setInterests(String interests) {
        this.interests = interests;
    }

    @Column(name="Abbreviation", length=50)
    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    @Column(name="Initials", length=8)
    public String getInitials() {
        return this.initials;
    }

    public void setInitials(String initials) {
        this.initials = initials;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @OneToMany(mappedBy="organization")
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.MERGE, CascadeType.LOCK})
    public Set<Agent> getOrgMembers() {
        return this.orgMembers;
    }

    public void setOrgMembers(Set<Agent> orgMembers) {
        this.orgMembers = orgMembers;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="ParentOrganizationID")
    public Agent getOrganization() {
        return this.organization;
    }

    public void setOrganization(Agent organization) {
        this.organization = organization;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="SpecifyUserID", unique=false, nullable=true, insertable=true, updatable=true)
    public SpecifyUser getSpecifyUser() {
        return this.specifyUser;
    }

    public void setSpecifyUser(SpecifyUser specifyUser) {
        this.specifyUser = specifyUser;
    }

    @OneToMany(mappedBy="group")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<GroupPerson> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<GroupPerson> groupPersonByGroup) {
        this.groups = groupPersonByGroup;
    }

    @OneToMany(mappedBy="member")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<GroupPerson> getMembers() {
        return this.members;
    }

    public void setMembers(Set<GroupPerson> groupPersonByMember) {
        this.members = groupPersonByMember;
    }

    @OneToMany(mappedBy="agent")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<Collector> getCollectors() {
        return this.collectors;
    }

    public void setCollectors(Set<Collector> collectors) {
        this.collectors = collectors;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="DivisionID", unique=false, nullable=true, insertable=true, updatable=true)
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="InstitutionTCID")
    public Institution getInstTechContact() {
        return this.instTechContact;
    }

    public void setInstTechContact(Institution instTechContact) {
        this.instTechContact = instTechContact;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="InstitutionCCID")
    public Institution getInstContentContact() {
        return this.instContentContact;
    }

    public void setInstContentContact(Institution instContentContact) {
        this.instContentContact = instContentContact;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CollectionTCID")
    public Collection getCollTechContact() {
        return this.collTechContact;
    }

    public void setCollTechContact(Collection collTechContact) {
        this.collTechContact = collTechContact;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="CollectionCCID")
    public Collection getCollContentContact() {
        return this.collContentContact;
    }

    public void setCollContentContact(Collection collContentContact) {
        this.collContentContact = collContentContact;
    }

    @Column(name="JobTitle", length=50)
    public String getJobTitle() {
        return this.jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    @Column(name="Email", length=50)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Column(name="URL", length=1024)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Column(name="GUID", length=128)
    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    @OneToMany(mappedBy="agent")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Set<Address> addresses) {
        this.addresses = addresses;
    }

    @OneToMany(mappedBy="agent")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @OrderBy(value="ordinal ASC")
    public Set<AgentAttachment> getAgentAttachments() {
        return this.agentAttachments;
    }

    public void setAgentAttachments(Set<AgentAttachment> agentAttachments) {
        this.agentAttachments = agentAttachments;
    }

    @OneToMany(mappedBy="agent")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<AgentVariant> getVariants() {
        return this.variants;
    }

    public void setVariants(Set<AgentVariant> variants) {
        this.variants = variants;
    }

    @OneToMany(mappedBy="agent")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<AgentGeography> getAgentGeographies() {
        return this.agentGeographies;
    }

    public void setAgentGeographies(Set<AgentGeography> agentGeographies) {
        this.agentGeographies = agentGeographies;
    }

    @OneToMany(mappedBy="agent")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<AgentSpecialty> getAgentSpecialties() {
        return this.agentSpecialties;
    }

    public void setAgentSpecialties(Set<AgentSpecialty> agentSpecialties) {
        this.agentSpecialties = agentSpecialties;
    }

    @Override
    @Transient
    public int getTableId() {
        return Agent.getClassTableId();
    }

    public static int getClassTableId() {
        return 5;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        if (StringUtils.isNotEmpty((String)this.lastName)) {
            if (StringUtils.isNotEmpty((String)this.firstName)) {
                return String.valueOf(this.lastName) + ", " + this.firstName;
            }
            return this.lastName;
        }
        if (StringUtils.isEmpty((String)this.lastName)) {
            DBTableInfo ti = DBTableIdMgr.getInstance().getByClassName(Agent.class.getName());
            return ti.getTitle();
        }
        return super.getIdentityTitle();
    }

    @Override
    public String toString() {
        if (this.agentType == null) {
            return super.toString();
        }
        return DataObjFieldFormatMgr.getInstance().format((Object)this, this.getClass());
    }

    @Override
    @Transient
    public Set<AgentAttachment> getAttachmentReferences() {
        return this.agentAttachments;
    }

    private void cloneSets(Agent src, Agent dst) throws CloneNotSupportedException {
        DataModelObjBase newObj;
        for (Address address : src.addresses) {
            Address newAddr = (Address)address.clone();
            dst.addresses.add(newAddr);
            newAddr.setAgent(dst);
        }
        for (AgentVariant agentVariant : src.variants) {
            newObj = (AgentVariant)agentVariant.clone();
            dst.variants.add((AgentVariant)newObj);
            agentVariant.setAgent(dst);
        }
        for (AgentGeography agentGeography : src.agentGeographies) {
            newObj = (AgentGeography)agentGeography.clone();
            dst.agentGeographies.add((AgentGeography)newObj);
            agentGeography.setAgent(dst);
        }
        for (AgentSpecialty agentSpecialty : src.agentSpecialties) {
            newObj = (AgentSpecialty)agentSpecialty.clone();
            dst.agentSpecialties.add((AgentSpecialty)newObj);
            agentSpecialty.setAgent(dst);
        }
        for (Collector collector : src.collectors) {
            newObj = (Collector)collector.clone();
            dst.collectors.add((Collector)newObj);
            collector.setAgent(dst);
        }
        for (GroupPerson groupPerson : src.members) {
            newObj = (GroupPerson)groupPerson.clone();
            dst.members.add((GroupPerson)newObj);
            groupPerson.setMember(dst);
        }
        for (GroupPerson groupPerson : src.groups) {
            newObj = (GroupPerson)groupPerson.clone();
            dst.groups.add((GroupPerson)newObj);
            groupPerson.setGroup(dst);
        }
        for (Agent agent : src.orgMembers) {
            newObj = (Agent)agent.clone();
            dst.orgMembers.add((Agent)newObj);
            agent.setOrganization(dst);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Agent obj = (Agent)super.clone();
        obj.agentId = null;
        Agent.initializeSets(obj);
        this.cloneSets(this, obj);
        return obj;
    }

    public static void initializeSets(Agent obj) {
        obj.orgMembers = new HashSet<Agent>();
        obj.groups = new HashSet<GroupPerson>();
        obj.members = new HashSet<GroupPerson>();
        obj.collectors = new HashSet<Collector>();
        obj.addresses = new HashSet<Address>();
        obj.agentAttachments = new HashSet<AgentAttachment>();
        obj.variants = new HashSet<AgentVariant>();
        obj.agentGeographies = new HashSet<AgentGeography>();
        obj.agentSpecialties = new HashSet<AgentSpecialty>();
    }

    public static Agent getUserAgent() {
        return userAgent;
    }

    public static boolean setUserAgent(SpecifyUser user, Division division) {
        String sql = "SELECT a.AgentID FROM agent AS a WHERE a.DivisionID = " + division.getId() + " AND a.SpecifyUserID = " + user.getId();
        boolean notFndErr = false;
        userAgent = null;
        Integer agentId = BasicSQLUtils.getCount(sql);
        if (agentId != null) {
            userAgent = (Agent)Agent.getDataObj(Agent.class, agentId);
            if (userAgent == null) {
                UIRegistry.showError("A user agent was not found for the SpecifyUser for division[" + division.getName() + "] and Agent id [" + agentId + "]");
                notFndErr = true;
            }
        } else {
            UIRegistry.showError("A user agent was not found for the SpecifyUser for division[" + division.getName() + "]");
            notFndErr = true;
        }
        if (notFndErr) {
            AgentBusRules.createUserAgent(user, division);
            UIRegistry.showLocalizedMsg("Specify.ABT_EXIT");
            CommandDispatcher.dispatch(new CommandAction("App", "AppReqExit"));
            return false;
        }
        return true;
    }

    public static void setUserAgent(Agent userAgent) {
        Agent.userAgent = userAgent;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Agent) {
            Agent item = (Agent)obj;
            if (item.agentId != null) {
                return item.agentId.equals(this.agentId);
            }
            return super.equals(obj);
        }
        return false;
    }

    @Transient
    public static List<PickListDBAdapterIFace> getSpSystemTypeCodes() {
        Vector<PickListDBAdapterIFace> result = new Vector<PickListDBAdapterIFace>(1);
        Vector<PickListItemIFace> stats = new Vector<PickListItemIFace>(4);
        stats.add(new TypeCodeItem(UIRegistry.getResourceString("Agent_ORG"), (Object)0));
        stats.add(new TypeCodeItem(UIRegistry.getResourceString("Agent_PERSON"), (Object)1));
        stats.add(new TypeCodeItem(UIRegistry.getResourceString("Agent_OTHER"), (Object)2));
        stats.add(new TypeCodeItem(UIRegistry.getResourceString("Agent_GROUP"), (Object)3));
        result.add(new TypeCode(stats, "agentType"));
        return result;
    }

    @Transient
    public static String[] getSpSystemTypeCodeFlds() {
        String[] result = new String[]{"agentType"};
        return result;
    }
}

