/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.ExchangeIn;
import edu.ku.brc.specify.datamodel.ExchangeOut;
import edu.ku.brc.specify.datamodel.Loan;
import edu.ku.brc.specify.datamodel.RepositoryAgreement;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="addressofrecord")
public class AddressOfRecord
extends DataModelObjBase {
    protected Integer addressOfRecordId;
    protected String address;
    protected String address2;
    protected String city;
    protected String state;
    protected String country;
    protected String postalCode;
    protected String remarks;
    protected Agent agent;
    protected Set<Accession> accessions;
    protected Set<RepositoryAgreement> repositoryAgreements;
    protected Set<Loan> loans;
    protected Set<ExchangeIn> exchangeIns;
    protected Set<ExchangeOut> exchangeOuts;

    @Override
    public void initialize() {
        super.init();
        this.addressOfRecordId = null;
        this.address = null;
        this.address2 = null;
        this.city = null;
        this.state = null;
        this.country = null;
        this.postalCode = null;
        this.remarks = null;
        this.agent = null;
        this.accessions = new HashSet<Accession>();
        this.repositoryAgreements = new HashSet<RepositoryAgreement>();
        this.loans = new HashSet<Loan>();
        this.exchangeIns = new HashSet<ExchangeIn>();
        this.exchangeOuts = new HashSet<ExchangeOut>();
    }

    @Id
    @GeneratedValue
    @Column(name="AddressOfRecordID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getAddressOfRecordId() {
        return this.addressOfRecordId;
    }

    public void setAddressOfRecordId(Integer addressOfRecordId) {
        this.addressOfRecordId = addressOfRecordId;
    }

    @Column(name="Address", unique=false, nullable=true, insertable=true, updatable=true)
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Column(name="Address2", unique=false, nullable=true, insertable=true, updatable=true)
    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    @Column(name="City", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @Column(name="State", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Column(name="Country", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @Column(name="PostalCode", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AgentID", unique=false, nullable=true, insertable=true, updatable=true)
    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    @OneToMany(mappedBy="addressOfRecord")
    public Set<Accession> getAccessions() {
        return this.accessions;
    }

    public void setAccessions(Set<Accession> accessions) {
        this.accessions = accessions;
    }

    @OneToMany(mappedBy="addressOfRecord")
    public Set<RepositoryAgreement> getRepositoryAgreements() {
        return this.repositoryAgreements;
    }

    public void setRepositoryAgreements(Set<RepositoryAgreement> repositoryAgreements) {
        this.repositoryAgreements = repositoryAgreements;
    }

    @OneToMany(mappedBy="addressOfRecord")
    public Set<Loan> getLoans() {
        return this.loans;
    }

    public void setLoans(Set<Loan> loans) {
        this.loans = loans;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="addressOfRecord")
    public Set<ExchangeIn> getExchangeIns() {
        return this.exchangeIns;
    }

    public void setExchangeIns(Set<ExchangeIn> exchangeIns) {
        this.exchangeIns = exchangeIns;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="addressOfRecord")
    public Set<ExchangeOut> getExchangeOuts() {
        return this.exchangeOuts;
    }

    public void setExchangeOuts(Set<ExchangeOut> exchangeOuts) {
        this.exchangeOuts = exchangeOuts;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return AddressOfRecord.class;
    }

    @Override
    @Transient
    public Integer getParentId() {
        Vector<Object> ids = BasicSQLUtils.querySingleCol("SELECT AccessionID FROM accession WHERE AddressOfRecordID = " + this.addressOfRecordId);
        if (ids.size() == 1) {
            this.parentTblId = Accession.getClassTableId();
            return (Integer)ids.get(0);
        }
        ids = BasicSQLUtils.querySingleCol("SELECT RepositoryAgreementID FROM repositoryagreement WHERE AddressOfRecordID = " + this.addressOfRecordId);
        if (ids.size() == 1) {
            this.parentTblId = RepositoryAgreement.getClassTableId();
            return (Integer)ids.get(0);
        }
        ids = BasicSQLUtils.querySingleCol("SELECT LoanID FROM loan WHERE AddressOfRecordID = " + this.addressOfRecordId);
        if (ids.size() == 1) {
            this.parentTblId = Loan.getClassTableId();
            return (Integer)ids.get(0);
        }
        ids = BasicSQLUtils.querySingleCol("SELECT ExchangeInID FROM exchangein WHERE AddressOfRecordID = " + this.addressOfRecordId);
        if (ids.size() == 1) {
            this.parentTblId = ExchangeIn.getClassTableId();
            return (Integer)ids.get(0);
        }
        ids = BasicSQLUtils.querySingleCol("SELECT ExchangeOutID FROM exchangeout WHERE AddressOfRecordID = " + this.addressOfRecordId);
        if (ids.size() == 1) {
            this.parentTblId = ExchangeOut.getClassTableId();
            return (Integer)ids.get(0);
        }
        this.parentTblId = null;
        return null;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.addressOfRecordId;
    }

    @Override
    @Transient
    public int getTableId() {
        return AddressOfRecord.getClassTableId();
    }

    public static int getClassTableId() {
        return 125;
    }
}

