/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.util.Orderable;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="address")
public class Address
extends DataModelObjBase
implements Orderable,
Comparable<Address>,
Serializable,
Cloneable {
    protected Integer addressId;
    protected String address;
    protected String address2;
    protected String address3;
    protected String address4;
    protected String address5;
    protected String city;
    protected String state;
    protected String country;
    protected String postalCode;
    protected String remarks;
    protected Agent agent;
    protected Integer ordinal;
    protected Boolean isPrimary;
    protected String phone1;
    protected String phone2;
    protected String fax;
    protected String roomOrBuilding;
    protected String typeOfAddr;
    protected Boolean isCurrent;
    protected Boolean isShipping;
    protected Calendar startDate;
    protected Calendar endDate;
    protected String positionHeld;
    protected Set<Institution> insitutions;
    protected Set<Division> divisions;

    public Address() {
    }

    public Address(Integer addressId) {
        this.addressId = addressId;
    }

    @Override
    public void initialize() {
        super.init();
        this.addressId = null;
        this.address = null;
        this.address2 = null;
        this.address3 = null;
        this.address4 = null;
        this.address5 = null;
        this.city = null;
        this.state = null;
        this.country = null;
        this.postalCode = null;
        this.remarks = null;
        this.agent = null;
        this.ordinal = null;
        this.isPrimary = false;
        this.phone1 = null;
        this.phone2 = null;
        this.fax = null;
        this.roomOrBuilding = null;
        this.startDate = null;
        this.endDate = null;
        this.positionHeld = null;
        this.isCurrent = null;
        this.isShipping = null;
        this.typeOfAddr = null;
        this.insitutions = new HashSet<Institution>();
        this.divisions = new HashSet<Division>();
    }

    @Id
    @GeneratedValue
    @Column(name="AddressID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getAddressId() {
        return this.addressId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.addressId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Address.class;
    }

    public void setAddressId(Integer addressId) {
        this.addressId = addressId;
    }

    @Column(name="Address", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Column(name="Address2", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    @Column(name="Address3", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getAddress3() {
        return this.address3;
    }

    public void setAddress3(String address3) {
        this.address3 = address3;
    }

    @Column(name="Address4", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getAddress4() {
        return this.address4;
    }

    public void setAddress4(String address4) {
        this.address4 = address4;
    }

    @Column(name="Address5", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getAddress5() {
        return this.address5;
    }

    public void setAddress5(String address5) {
        this.address5 = address5;
    }

    @Column(name="City", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @Column(name="State", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Column(name="Country", unique=false, nullable=true, insertable=true, updatable=true, length=64)
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @Column(name="PostalCode", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AgentID", unique=false, nullable=true, insertable=true, updatable=true)
    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    @Column(name="Phone1", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getPhone1() {
        return this.phone1;
    }

    public void setPhone1(String phone1) {
        this.phone1 = phone1;
    }

    @Column(name="Phone2", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getPhone2() {
        return this.phone2;
    }

    public void setPhone2(String phone2) {
        this.phone2 = phone2;
    }

    @Column(name="Fax", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    @Column(name="RoomOrBuilding", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getRoomOrBuilding() {
        return this.roomOrBuilding;
    }

    public void setRoomOrBuilding(String roomOrBuilding) {
        this.roomOrBuilding = roomOrBuilding;
    }

    @Column(name="IsPrimary", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsPrimary() {
        return this.isPrimary == null ? false : this.isPrimary;
    }

    public void setIsPrimary(Boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="EndDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="StartDate", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    @Column(name="PositionHeld", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getPositionHeld() {
        return this.positionHeld;
    }

    public void setPositionHeld(String positionHeld) {
        this.positionHeld = positionHeld;
    }

    @Column(name="Ordinal")
    public Integer getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(Integer ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    @Transient
    public int getOrderIndex() {
        return this.ordinal != null ? this.ordinal : 0;
    }

    @Override
    public void setOrderIndex(int ordinal) {
        this.ordinal = ordinal;
    }

    public static void append(StringBuilder sb, String val) {
        if (StringUtils.isNotEmpty((String)val)) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(val);
        }
    }

    @Column(name="TypeOfAddr", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getTypeOfAddr() {
        return this.typeOfAddr;
    }

    public void setTypeOfAddr(String typeOfAddr) {
        this.typeOfAddr = typeOfAddr;
    }

    @Column(name="IsCurrent", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsCurrent() {
        return this.isCurrent;
    }

    public void setIsCurrent(Boolean isCurrent) {
        this.isCurrent = isCurrent;
    }

    @Column(name="IsShipping", unique=false, nullable=true, insertable=true, updatable=true)
    public Boolean getIsShipping() {
        return this.isShipping;
    }

    public void setIsShipping(Boolean isShipping) {
        this.isShipping = isShipping;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="address")
    public Set<Institution> getInsitutions() {
        return this.insitutions;
    }

    public void setInsitutions(Set<Institution> insitutions) {
        this.insitutions = insitutions;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="address")
    public Set<Division> getDivisions() {
        return this.divisions;
    }

    public void setDivisions(Set<Division> divisions) {
        this.divisions = divisions;
    }

    @Override
    @Transient
    public Integer getParentId() {
        if (this.agent != null) {
            this.parentTblId = Agent.getClassTableId();
            return this.agent.getId();
        }
        Vector<Object> ids = BasicSQLUtils.querySingleCol("SELECT InstitutionID FROM institution WHERE AddressID = " + this.addressId);
        if (ids.size() == 1) {
            this.parentTblId = Institution.getClassTableId();
            return (Integer)ids.get(0);
        }
        ids = BasicSQLUtils.querySingleCol("SELECT DivisionID FROM division WHERE AddressID = " + this.addressId);
        if (ids.size() == 1) {
            this.parentTblId = Division.getClassTableId();
            return (Integer)ids.get(0);
        }
        this.parentTblId = null;
        return null;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        StringBuilder sb = new StringBuilder();
        Address.append(sb, this.address);
        Address.append(sb, this.address2);
        Address.append(sb, this.city);
        Address.append(sb, this.state);
        Address.append(sb, this.country);
        Address.append(sb, this.postalCode);
        if (sb.length() > 0) {
            return sb.toString();
        }
        return super.getIdentityTitle();
    }

    @Override
    @Transient
    public int getTableId() {
        return Address.getClassTableId();
    }

    public static int getClassTableId() {
        return 8;
    }

    @Override
    public int compareTo(Address obj) {
        if (this.ordinal != null && obj != null && obj.ordinal != null) {
            return this.ordinal.compareTo(obj.ordinal);
        }
        return 0;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Address obj = (Address)super.clone();
        obj.addressId = null;
        obj.agent = null;
        obj.insitutions = new HashSet<Institution>();
        obj.divisions = new HashSet<Division>();
        return obj;
    }

    public boolean matches(Address o) {
        if (o == null) {
            return false;
        }
        return (this.address == null && o.address == null || this.address != null && o.address != null && this.address.equals(o.address)) && (this.address2 == null && o.address2 == null || this.address2 != null && o.address2 != null && this.address2.equals(o.address2)) && (this.address3 == null && o.address3 == null || this.address3 != null && o.address3 != null && this.address3.equals(o.address3)) && (this.address4 == null && o.address4 == null || this.address4 != null && o.address4 != null && this.address4.equals(o.address4)) && (this.address5 == null && o.address5 == null || this.address5 != null && o.address5 != null && this.address5.equals(o.address5)) && (this.city == null && o.city == null || this.city != null && o.city != null && this.city.equals(o.city)) && (this.state == null && o.state == null || this.state != null && o.state != null && this.state.equals(o.state)) && (this.country == null && o.country == null || this.country != null && o.country != null && this.country.equals(o.country)) && (this.postalCode == null && o.postalCode == null || this.postalCode != null && o.postalCode != null && this.postalCode.equals(o.postalCode)) && (this.remarks == null && o.remarks == null || this.remarks != null && o.remarks != null && this.remarks.equals(o.remarks)) && (this.isPrimary == null && o.isPrimary == null || this.isPrimary != null && o.isPrimary != null && this.isPrimary.equals(o.isPrimary)) && (this.phone1 == null && o.phone1 == null || this.phone1 != null && o.phone1 != null && this.phone1.equals(o.phone1)) && (this.phone2 == null && o.phone2 == null || this.phone2 != null && o.phone2 != null && this.phone2.equals(o.phone2)) && (this.fax == null && o.fax == null || this.fax != null && o.fax != null && this.fax.equals(o.fax)) && (this.roomOrBuilding == null && o.roomOrBuilding == null || this.roomOrBuilding != null && o.roomOrBuilding != null && this.roomOrBuilding.equals(o.roomOrBuilding)) && (this.startDate == null && o.startDate == null || this.startDate != null && o.startDate != null && this.startDate.equals(o.startDate)) && (this.endDate == null && o.endDate == null || this.endDate != null && o.endDate != null && this.endDate.equals(o.endDate)) && (this.positionHeld == null && o.positionHeld == null || this.positionHeld != null && o.positionHeld != null && this.positionHeld.equals(o.positionHeld)) && (this.isCurrent == null && o.isCurrent == null || this.isCurrent != null && o.isCurrent != null && this.isCurrent.equals(o.isCurrent)) && (this.isShipping == null && o.isShipping == null || this.isShipping != null && o.isShipping != null && this.isShipping.equals(o.isShipping)) && (this.typeOfAddr == null && o.typeOfAddr == null || this.typeOfAddr != null && o.typeOfAddr != null && this.typeOfAddr.equals(o.typeOfAddr));
    }
}

