/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.ObjectAttachmentIFace;
import edu.ku.brc.util.Orderable;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="accessionattachment")
public class AccessionAttachment
extends DataModelObjBase
implements ObjectAttachmentIFace<Accession>,
Orderable,
Serializable,
Comparable<AccessionAttachment> {
    protected Integer accessionAttachmentId;
    protected Accession accession;
    protected Attachment attachment;
    protected Integer ordinal;
    protected String remarks;

    public AccessionAttachment() {
    }

    public AccessionAttachment(Integer id) {
        this.accessionAttachmentId = id;
    }

    @Override
    public void initialize() {
        super.init();
        this.accessionAttachmentId = null;
        this.accession = null;
        this.attachment = new Attachment();
        this.attachment.initialize();
        this.ordinal = null;
    }

    @Id
    @GeneratedValue
    @Column(name="AccessionAttachmentID")
    public Integer getAccessionAttachmentId() {
        return this.accessionAttachmentId;
    }

    public void setAccessionAttachmentId(Integer accessionAttachmentId) {
        this.accessionAttachmentId = accessionAttachmentId;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AccessionID", nullable=false)
    public Accession getAccession() {
        return this.accession;
    }

    public void setAccession(Accession accession) {
        this.accession = accession;
    }

    @Override
    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="AttachmentID", nullable=false)
    @OrderBy(value="ordinal ASC")
    public Attachment getAttachment() {
        return this.attachment;
    }

    @Override
    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    @Override
    @Column(name="Ordinal")
    public Integer getOrdinal() {
        return this.ordinal;
    }

    @Override
    public void setOrdinal(Integer ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    @Transient
    public int getOrderIndex() {
        return this.ordinal != null ? this.ordinal : 0;
    }

    @Override
    public void setOrderIndex(int ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return AccessionAttachment.class;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.accessionAttachmentId;
    }

    @Override
    @Transient
    public int getTableId() {
        return AccessionAttachment.getClassTableId();
    }

    public static int getClassTableId() {
        return 108;
    }

    @Override
    @Transient
    public Accession getObject() {
        return this.getAccession();
    }

    @Override
    public void setObject(Accession object) {
        this.setAccession(object);
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Accession.getClassTableId();
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.accession != null ? this.accession.getId() : null;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return Attachment.getIdentityTitle(this);
    }

    @Override
    public String toString() {
        return this.attachment != null ? this.attachment.getIdentityTitle() : super.getIdentityTitle();
    }

    @Override
    public int compareTo(AccessionAttachment obj) {
        if (this.ordinal != null && obj != null && obj.ordinal != null) {
            return this.ordinal.compareTo(obj.ordinal);
        }
        return 0;
    }
}

