/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.Accession;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.RepositoryAgreement;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Proxy;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@Table(name="accessionagent", uniqueConstraints={@UniqueConstraint(columnNames={"Role", "AgentID", "AccessionID"})})
public class AccessionAgent
extends DataModelObjBase
implements Serializable {
    protected Integer accessionAgentId;
    protected String role;
    protected String remarks;
    protected Agent agent;
    protected Accession accession;
    protected RepositoryAgreement repositoryAgreement;

    public AccessionAgent() {
    }

    public AccessionAgent(Integer accessionAgentId) {
        this.accessionAgentId = accessionAgentId;
    }

    @Override
    public void initialize() {
        super.init();
        this.accessionAgentId = null;
        this.role = null;
        this.remarks = null;
        this.agent = null;
        this.accession = null;
        this.repositoryAgreement = null;
    }

    @Id
    @GeneratedValue
    @Column(name="AccessionAgentID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getAccessionAgentId() {
        return this.accessionAgentId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.accessionAgentId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return AccessionAgent.class;
    }

    public void setAccessionAgentId(Integer accessionAgentId) {
        this.accessionAgentId = accessionAgentId;
    }

    @Column(name="Role", unique=false, nullable=false, insertable=true, updatable=true, length=50)
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @ManyToOne(cascade={}, fetch=FetchType.EAGER)
    @JoinColumn(name="AgentID", unique=false, nullable=false, insertable=true, updatable=true)
    public Agent getAgent() {
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AccessionID", unique=false, nullable=true, insertable=true, updatable=true)
    public Accession getAccession() {
        return this.accession;
    }

    public void setAccession(Accession accession) {
        this.accession = accession;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="RepositoryAgreementID", unique=false, nullable=true, insertable=true, updatable=true)
    public RepositoryAgreement getRepositoryAgreement() {
        return this.repositoryAgreement;
    }

    public void setRepositoryAgreement(RepositoryAgreement repositoryAgreement) {
        this.repositoryAgreement = repositoryAgreement;
    }

    @Override
    @Transient
    public Integer getParentId() {
        return this.accession != null ? this.accession.getId() : null;
    }

    @Override
    @Transient
    public Integer getParentTableId() {
        return Accession.getClassTableId();
    }

    @Override
    @Transient
    public int getTableId() {
        return AccessionAgent.getClassTableId();
    }

    public static int getClassTableId() {
        return 12;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        String str = String.valueOf(StringUtils.isNotEmpty((String)this.role) ? this.role : "") + (this.agent != null ? ": " + this.agent.getIdentityTitle() : "");
        if (StringUtils.isEmpty((String)str)) {
            str = super.getIdentityTitle();
        }
        return str;
    }
}

