/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.datamodel;

import edu.ku.brc.specify.datamodel.AccessionAgent;
import edu.ku.brc.specify.datamodel.AccessionAttachment;
import edu.ku.brc.specify.datamodel.AccessionAuthorization;
import edu.ku.brc.specify.datamodel.AddressOfRecord;
import edu.ku.brc.specify.datamodel.Appraisal;
import edu.ku.brc.specify.datamodel.AttachmentOwnerIFace;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.DataModelObjBase;
import edu.ku.brc.specify.datamodel.Deaccession;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.RepositoryAgreement;
import edu.ku.brc.specify.datamodel.TreatmentEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicInsert=true, dynamicUpdate=true)
@Proxy(lazy=false)
@javax.persistence.Table(name="accession")
@Table(appliesTo="accession", indexes={@Index(name="AccessionNumberIDX", columnNames={"AccessionNumber"}), @Index(name="AccessionDateIDX", columnNames={"DateAccessioned"})})
public class Accession
extends DataModelObjBase
implements Serializable,
AttachmentOwnerIFace<AccessionAttachment> {
    protected Integer accessionId;
    protected String type;
    protected String status;
    protected String accessionNumber;
    protected String verbatimDate;
    protected Calendar dateAccessioned;
    protected Calendar dateReceived;
    protected Calendar dateAcknowledged;
    protected String accessionCondition;
    protected BigDecimal totalValue;
    protected String text1;
    protected String text2;
    protected String text3;
    protected Float number1;
    protected Float number2;
    protected String remarks;
    protected Boolean yesNo1;
    protected Boolean yesNo2;
    protected Division division;
    protected AddressOfRecord addressOfRecord;
    protected RepositoryAgreement repositoryAgreement;
    protected Set<CollectionObject> collectionObjects;
    protected Set<AccessionAuthorization> accessionAuthorizations;
    protected Set<AccessionAgent> accessionAgents;
    protected Set<AccessionAttachment> accessionAttachments;
    protected Set<Appraisal> appraisals;
    protected Set<TreatmentEvent> treatmentEvents;
    protected Set<Deaccession> deaccessions;

    public Accession() {
    }

    public Accession(Integer accessionId) {
        this.accessionId = accessionId;
    }

    @Override
    public void initialize() {
        super.init();
        this.accessionId = null;
        this.type = null;
        this.status = null;
        this.accessionNumber = null;
        this.verbatimDate = null;
        this.dateAccessioned = null;
        this.dateReceived = null;
        this.accessionCondition = null;
        this.totalValue = null;
        this.text1 = null;
        this.text2 = null;
        this.text3 = null;
        this.number1 = null;
        this.number2 = null;
        this.remarks = null;
        this.yesNo1 = null;
        this.yesNo2 = null;
        this.division = null;
        this.addressOfRecord = null;
        this.collectionObjects = new HashSet<CollectionObject>();
        this.accessionAuthorizations = new HashSet<AccessionAuthorization>();
        this.accessionAgents = new HashSet<AccessionAgent>();
        this.repositoryAgreement = null;
        this.accessionAttachments = new HashSet<AccessionAttachment>();
        this.appraisals = new HashSet<Appraisal>();
        this.treatmentEvents = new HashSet<TreatmentEvent>();
        this.deaccessions = new HashSet<Deaccession>();
    }

    @Id
    @GeneratedValue
    @Column(name="AccessionID", unique=false, nullable=false, insertable=true, updatable=true)
    public Integer getAccessionId() {
        return this.accessionId;
    }

    @Override
    @Transient
    public Integer getId() {
        return this.accessionId;
    }

    @Override
    @Transient
    public Class<?> getDataClass() {
        return Accession.class;
    }

    public void setAccessionId(Integer accessionId) {
        this.accessionId = accessionId;
    }

    @Column(name="Type", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Column(name="Status", unique=false, nullable=true, insertable=true, updatable=true, length=32)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Column(name="AccessionNumber", unique=false, nullable=false, insertable=true, updatable=true, length=60)
    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public void setAccessionNumber(String accessionNumber) {
        this.firePropertyChange("accessionNumber", this.accessionNumber, accessionNumber);
        this.accessionNumber = accessionNumber;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DateAcknowledged", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDateAcknowledged() {
        return this.dateAcknowledged;
    }

    public void setDateAcknowledged(Calendar dateAcknowledged) {
        this.dateAcknowledged = dateAcknowledged;
    }

    @Column(name="AccessionCondition", unique=false, nullable=true, insertable=true, updatable=true, length=255)
    public String getAccessionCondition() {
        return this.accessionCondition;
    }

    public void setAccessionCondition(String accessionCondition) {
        this.accessionCondition = accessionCondition;
    }

    @Column(name="TotalValue", unique=false, nullable=true, insertable=true, updatable=true, precision=12, scale=2)
    public BigDecimal getTotalValue() {
        return this.totalValue;
    }

    public void setTotalValue(BigDecimal totalValue) {
        this.totalValue = totalValue;
    }

    @Column(name="VerbatimDate", unique=false, nullable=true, insertable=true, updatable=true, length=50)
    public String getVerbatimDate() {
        return this.verbatimDate;
    }

    public void setVerbatimDate(String verbatimDate) {
        this.verbatimDate = verbatimDate;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DateAccessioned", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDateAccessioned() {
        return this.dateAccessioned;
    }

    public void setDateAccessioned(Calendar dateAccessioned) {
        this.dateAccessioned = dateAccessioned;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DateReceived", unique=false, nullable=true, insertable=true, updatable=true)
    public Calendar getDateReceived() {
        return this.dateReceived;
    }

    public void setDateReceived(Calendar dateReceived) {
        this.dateReceived = dateReceived;
    }

    @Column(name="Text1", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText1() {
        return this.text1;
    }

    public void setText1(String text1) {
        this.text1 = text1;
    }

    @Column(name="Text2", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText2() {
        return this.text2;
    }

    public void setText2(String text2) {
        this.text2 = text2;
    }

    @Column(name="Text3", length=300, unique=false, nullable=true, insertable=true, updatable=true)
    public String getText3() {
        return this.text3;
    }

    public void setText3(String text3) {
        this.text3 = text3;
    }

    @Column(name="Number1", unique=false, nullable=true, insertable=true, updatable=true)
    public Float getNumber1() {
        return this.number1;
    }

    public void setNumber1(Float number1) {
        this.number1 = number1;
    }

    @Column(name="Number2", unique=false, nullable=true, insertable=true, updatable=true)
    public Float getNumber2() {
        return this.number2;
    }

    public void setNumber2(Float number2) {
        this.number2 = number2;
    }

    @Lob
    @Column(name="Remarks", length=4096)
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Column(name="YesNo1", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo1() {
        return this.yesNo1;
    }

    public void setYesNo1(Boolean yesNo1) {
        this.yesNo1 = yesNo1;
    }

    @Column(name="YesNo2", unique=false, nullable=true, updatable=true, insertable=true)
    public Boolean getYesNo2() {
        return this.yesNo2;
    }

    public void setYesNo2(Boolean yesNo2) {
        this.yesNo2 = yesNo2;
    }

    @OneToMany(mappedBy="accession")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @OrderBy(value="ordinal ASC")
    public Set<AccessionAttachment> getAccessionAttachments() {
        return this.accessionAttachments;
    }

    public void setAccessionAttachments(Set<AccessionAttachment> accessionAttachments) {
        this.accessionAttachments = accessionAttachments;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="accession")
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.LOCK})
    public Set<CollectionObject> getCollectionObjects() {
        return this.collectionObjects;
    }

    public void setCollectionObjects(Set<CollectionObject> collectionObjects) {
        this.collectionObjects = collectionObjects;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="accession")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<AccessionAuthorization> getAccessionAuthorizations() {
        return this.accessionAuthorizations;
    }

    public void setAccessionAuthorizations(Set<AccessionAuthorization> accessionAuthorizations) {
        this.accessionAuthorizations = accessionAuthorizations;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="accession")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<AccessionAgent> getAccessionAgents() {
        return this.accessionAgents;
    }

    public void setAccessionAgents(Set<AccessionAgent> accessionAgents) {
        this.accessionAgents = accessionAgents;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="RepositoryAgreementID", unique=false, nullable=true, insertable=true, updatable=true)
    public RepositoryAgreement getRepositoryAgreement() {
        return this.repositoryAgreement;
    }

    public void setRepositoryAgreement(RepositoryAgreement repositoryAgreement) {
        this.repositoryAgreement = repositoryAgreement;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="accession")
    public Set<Appraisal> getAppraisals() {
        return this.appraisals;
    }

    public void setAppraisals(Set<Appraisal> appraisals) {
        this.appraisals = appraisals;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="accession")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<TreatmentEvent> getTreatmentEvents() {
        return this.treatmentEvents;
    }

    public void setTreatmentEvents(Set<TreatmentEvent> treatmentEvents) {
        this.treatmentEvents = treatmentEvents;
    }

    @OneToMany(cascade={}, fetch=FetchType.LAZY, mappedBy="accession")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<Deaccession> getDeaccessions() {
        return this.deaccessions;
    }

    public void setDeaccessions(Set<Deaccession> deaccessions) {
        this.deaccessions = deaccessions;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="AddressOfRecordID", unique=false, nullable=true, insertable=true, updatable=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public AddressOfRecord getAddressOfRecord() {
        return this.addressOfRecord;
    }

    public void setAddressOfRecord(AddressOfRecord addressOfRecord) {
        this.addressOfRecord = addressOfRecord;
    }

    @ManyToOne(cascade={}, fetch=FetchType.LAZY)
    @JoinColumn(name="DivisionID", unique=false, nullable=false, insertable=true, updatable=true)
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    @Override
    @Transient
    public String getIdentityTitle() {
        return this.accessionNumber != null ? this.accessionNumber : super.getIdentityTitle();
    }

    @Override
    @Transient
    public int getTableId() {
        return Accession.getClassTableId();
    }

    public static int getClassTableId() {
        return 7;
    }

    @Override
    @Transient
    public Set<AccessionAttachment> getAttachmentReferences() {
        return this.accessionAttachments;
    }
}

