/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import org.apache.log4j.Logger;

public class TimeLogger {
    private static final Logger log = Logger.getLogger(TimeLogger.class);
    private String desc = null;
    private long startTime;
    private long endTime;

    public TimeLogger() {
        this.start();
    }

    public TimeLogger(String desc) {
        this();
        this.desc = desc;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.endTime = 0L;
    }

    public void start(String description) {
        this.desc = description;
        this.start();
    }

    public void restart(String description) {
        this.end();
        this.desc = description;
        this.start();
    }

    public String end() {
        return this.end(null);
    }

    public String end(String msg) {
        if (msg != null) {
            this.desc = msg;
        }
        this.endTime = System.currentTimeMillis();
        double totalSeconds = (double)(this.endTime - this.startTime) / 1000.0;
        int hours = (int)(totalSeconds / 3600.0);
        int mins = (int)((totalSeconds - (double)(hours * 3600)) / 60.0);
        int secs = (int)(totalSeconds - (double)(hours * 3600) - (double)(mins * 60));
        String str = String.format("%sElapsed Time: %02d:%02d:%02d (%8.4f) (%d)", this.desc != null ? String.valueOf(this.desc) + " - " : "", hours, mins, secs, totalSeconds, this.endTime);
        log.debug((Object)str);
        return str;
    }
}

