/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.apache.axis.utils.StringUtils;

public class TableWriter
extends PrintWriter {
    public static final String TR = "<TR>";
    public static final String TR_ = "</TR>";
    public static final String TD = "<TD>";
    public static final String TD_ = "</TD>";
    public static final String TH = "<TH>";
    public static final String TH_ = "</TH>";
    private String fName;
    private String title;
    private String extraStyle = null;
    private int errCount = 0;
    private int lineCnt = 0;

    public TableWriter(String fileName, String title, boolean doCenterTitle) throws FileNotFoundException, UnsupportedEncodingException {
        this(fileName, title, null, doCenterTitle);
    }

    public TableWriter(String fileName, String title, String extraStyle, boolean doCenterTitle) throws FileNotFoundException, UnsupportedEncodingException {
        super(fileName, "UTF8");
        this.fName = fileName;
        this.title = title;
        this.extraStyle = extraStyle;
        this.println("<HTML>\n<HEAD>\n<meta HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=UTF-8\"><TITLE>" + title + "</TITLE>\n");
        this.writeStyle(this);
        this.println("</HEAD>\n<BODY>");
        if (doCenterTitle) {
            this.println("<center><span style=\"font-weight: bold;font-size:14pt;\">");
            this.println(title);
            this.println("</span></center>");
        } else {
            this.println("<H2>" + title + "</H2>");
        }
    }

    public TableWriter(String fileName, String title) throws FileNotFoundException, UnsupportedEncodingException {
        this(fileName, title, false);
    }

    private void writeStyle(PrintWriter pwOut) {
        pwOut.println("<STYLE>");
        pwOut.println("body { font-family: sans-serif; }");
        pwOut.println(" SPAN.err { color: red; }");
        pwOut.println(" TABLE.o    { border-bottom: solid 1px rgb(128, 128, 128); border-right: solid 1px rgb(128, 128, 128); }");
        pwOut.println(" TABLE.o td { border-top: solid 1px rgb(128, 128, 128); border-left: solid 1px rgb(128, 128, 128); }");
        pwOut.println(" TABLE.o th { border-top: solid 1px rgb(128, 128, 128); border-left: solid 1px rgb(128, 128, 128); }");
        pwOut.println(" TABLE.i    { border-bottom: solid 1px rgb(192, 192, 192); border-right: solid 1px rgb(192, 192, 192); }");
        pwOut.println(" TABLE.i td { border-top: solid 1px rgb(192, 192, 192); border-left: solid 1px rgb(192, 192, 192); }");
        pwOut.println(" TABLE.i th { border-top: solid 1px rgb(192, 192, 192); border-left: solid 1px rgb(192, 192, 192); }");
        if (this.extraStyle != null) {
            pwOut.println(this.extraStyle);
        }
        pwOut.println("</STYLE>");
    }

    public String getFileName() {
        return this.fName;
    }

    public String getTitle() {
        return this.title;
    }

    public void log(String msg) {
        ++this.lineCnt;
        this.print(msg);
        this.println("<BR>");
        this.flush();
    }

    public void logError(String msg) {
        ++this.errCount;
        ++this.lineCnt;
        this.println("<SPAN class=\"err\">");
        this.print(msg);
        this.println("</SPAN><BR>");
        this.flush();
    }

    public void setHasLines() {
        ++this.lineCnt;
    }

    public void logErrors(String ... cols) {
        ++this.errCount;
        ++this.lineCnt;
        this.print(TR);
        int i = 0;
        while (i < cols.length) {
            String str = cols[i];
            if (str != null) {
                if (i == cols.length - 1) {
                    this.print(TD);
                    this.print("<SPAN class=\"err\">");
                    this.print(str);
                    this.print("</SPAN><BR>");
                    this.print(TD_);
                } else {
                    this.print(TD);
                    this.print(str);
                    this.print(TD_);
                }
            }
            ++i;
        }
        this.println(TR_);
        this.flush();
    }

    public void startTable() {
        this.println("<TABLE class=\"o\" cellspacing=\"0\">");
        this.flush();
    }

    public void startTable(int width) {
        this.println(String.format("<TABLE class=\"o\" cellspacing=\"0\" width=\"%d%c\">", width, Character.valueOf('%')));
        this.flush();
    }

    public void endTable() {
        this.println("</TABLE>");
        this.flush();
    }

    public void log(String ... cols) {
        ++this.lineCnt;
        this.print(TR);
        String[] stringArray = cols;
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c != null) {
                this.print(TD);
                this.print(c);
                this.print(TD_);
            }
            ++n2;
        }
        this.println(TR_);
        this.flush();
    }

    public void logTDCls(String cls, String c) {
        ++this.lineCnt;
        if (cls != null) {
            this.print("<TD class=\"");
            this.print(cls);
            this.print("\">");
        } else {
            this.print(TD);
        }
        this.print(StringUtils.isEmpty((String)c) ? "&nbsp;" : c);
        this.print(TD_);
    }

    public void logWithSpaces(String ... cols) {
        ++this.lineCnt;
        this.print(TR);
        String[] stringArray = cols;
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            this.print(TD);
            this.print(c == null ? "&nbsp;" : c);
            this.print(TD_);
            ++n2;
        }
        this.println(TR_);
        this.flush();
    }

    public void logObjRow(Object[] row) {
        ++this.lineCnt;
        this.print(TR);
        Object[] objectArray = row;
        int n = row.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.print(TD);
            this.print(o != null ? o.toString() : "&nbsp;");
            this.print(TD_);
            ++n2;
        }
        this.println(TR_);
        this.flush();
    }

    public void logHdr(String ... cols) {
        this.print(TR);
        String[] stringArray = cols;
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c != null) {
                this.print(TH);
                this.print(c);
                this.print(TH_);
            }
            ++n2;
        }
        this.println(TR_);
        this.flush();
    }

    @Override
    public void close() {
        this.println("</BODY></HTML>");
        super.close();
    }

    public boolean hasLines() {
        return this.lineCnt > 0;
    }
}

