/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class TableStats {
    protected SingleTable oldTable;
    protected SingleTable newTable;

    public TableStats(Connection oldDBConn, String oldTableName, Connection newDBConn, String newTableName) {
        this.oldTable = new SingleTable(oldDBConn, oldTableName);
        this.newTable = new SingleTable(newDBConn, newTableName);
    }

    public void collectStats() {
        this.oldTable.collectStats();
        this.newTable.collectStats();
    }

    public SingleTable getNewTable() {
        return this.newTable;
    }

    public void setNewTable(SingleTable newTable) {
        this.newTable = newTable;
    }

    public SingleTable getOldTable() {
        return this.oldTable;
    }

    public void setOldTable(SingleTable oldTable) {
        this.oldTable = oldTable;
    }

    public void compareStats() {
        if (this.oldTable.hasStats() && this.newTable.hasStats()) {
            double rowsDiff = this.oldTable.getNumRows() > 0 ? (double)(this.newTable.getNumRows() / this.oldTable.getNumRows()) * 100.0 : 0.0;
            double sizeDiff = this.oldTable.getSize() > 0 ? (double)(this.newTable.getSize() / this.oldTable.getSize()) * 100.0 : 0.0;
            System.out.println("Table " + this.oldTable.getName() + " " + this.newTable.getName());
            System.out.println("Rows  " + this.oldTable.getNumRows() + "  " + this.oldTable.getNumRows() + " " + String.format("%5.2f", rowsDiff));
            System.out.println("Size  " + this.oldTable.getSize() + "  " + this.oldTable.getSize() + " " + String.format("%5.2f", sizeDiff));
            System.out.println(String.valueOf(this.oldTable.conn.hashCode()) + " " + this.newTable.conn.hashCode());
        } else {
            System.out.println(String.format("No Stats for %s, %s", this.oldTable.getName(), this.newTable.getName()));
        }
    }

    protected class SingleTable {
        protected Connection conn;
        protected String name;
        protected int size;
        protected int numRows;
        protected boolean hasStats = false;

        public SingleTable(Connection conn, String name) {
            this.conn = conn;
            this.name = name;
            this.size = 0;
            this.numRows = 0;
        }

        public SingleTable(String name, int size, int numRows) {
            this.name = name;
            this.size = size;
            this.numRows = numRows;
        }

        public boolean hasStats() {
            return this.hasStats;
        }

        public void collectStats() {
            if (this.conn != null) {
                try {
                    this.readTables();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public int getColNameIndex(ResultSet rs, String colNameArg) throws SQLException {
            int i = 1;
            while (i < rs.getMetaData().getColumnCount()) {
                String colName = rs.getMetaData().getColumnName(i);
                if (colName.equals(colNameArg)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void readTables() throws SQLException {
            try {
                Statement st = this.conn.createStatement(1004, 1007);
                ResultSet rs = st.executeQuery("show table status");
                if (rs.first()) {
                    do {
                        String tableName;
                        if (!(tableName = rs.getString(this.getColNameIndex(rs, "Name"))).equals(this.name)) continue;
                        this.numRows = BasicSQLUtils.getNumRecords(this.conn, this.name);
                        this.size = rs.getInt(this.getColNameIndex(rs, "Data_length"));
                        break;
                    } while (rs.next());
                    this.hasStats = true;
                } else {
                    System.err.println("Couldn't get Table Stats for Table [" + this.name + "]");
                }
            }
            catch (Exception ex) {
                System.err.println("Couldn't get Table Stats for Table [" + this.name + "]");
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getNumRows() {
            return this.numRows;
        }

        public void setNumRows(int numRows) {
            this.numRows = numRows;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }
}

