/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.FieldMetaData;
import edu.ku.brc.specify.conversion.IdMapperIFace;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import edu.ku.brc.specify.conversion.TableAutoNumbering;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class TableDuplicator {
    private Connection conn;
    private String tableName;
    private String primaryKey;
    private PreparedStatement insertStmt;
    private IdMapperIFace mapper;
    private List<FieldMetaData> fields = null;
    private int keyIndex = -1;
    private String selectStr;
    private TableAutoNumbering autoNum;
    private String whereSQL;
    private String orderBy;
    private String mapperName;

    public TableDuplicator(Connection conn, String tableName, String primaryKey, String whereSQL, String orderBy, String postFix) {
        this.conn = conn;
        this.tableName = tableName;
        this.primaryKey = primaryKey;
        this.whereSQL = whereSQL;
        this.orderBy = orderBy;
        this.mapperName = String.valueOf(tableName) + "_duplicator_" + postFix;
        this.mapper = IdMapperMgr.getInstance().addHashMapper(this.mapperName, true);
        this.autoNum = new TableAutoNumbering(conn, tableName, primaryKey);
    }

    public void initialize() throws SQLException {
        this.autoNum.initialize();
    }

    protected void buildSQL() throws SQLException {
        this.fields = BasicSQLUtils.getFieldMetaDataFromSchema(this.conn, this.tableName);
        String fieldSelStr = BasicSQLUtils.buildSelectFieldMetaDataList(this.fields, null);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.fields.size()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append('?');
            if (this.fields.get(i).getName().equals(this.primaryKey)) {
                this.keyIndex = i + 1;
            }
            ++i;
        }
        String wStr = this.whereSQL != null ? "WHERE " + this.whereSQL : "";
        String oStr = this.orderBy != null ? "ORDER BY " + this.orderBy : "";
        this.selectStr = String.format("SELECT %s FROM %s %s %s", fieldSelStr, this.tableName, wStr, oStr);
        System.out.println(this.selectStr);
        String insertStr = String.format("INSERT INTO %s (%s) VALUES(%s)", this.tableName, fieldSelStr, sb.toString());
        System.out.println(insertStr);
        this.insertStmt = this.conn.prepareStatement(insertStr);
    }

    public void duplicate() throws SQLException {
        this.buildSQL();
        int cnt = 0;
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(this.selectStr);
        while (rs.next()) {
            int i = 1;
            while (i < this.fields.size() + 1) {
                if (this.keyIndex == i) {
                    int newId = this.autoNum.getNext();
                    int oldId = rs.getInt(i);
                    this.insertStmt.setObject(i, newId);
                    this.mapper.put(oldId, newId);
                } else {
                    this.insertStmt.setObject(i, rs.getObject(i));
                }
                ++i;
            }
            this.insertStmt.execute();
            if (++cnt % 1000 != 0) continue;
            System.out.println(cnt);
            break;
        }
        rs.close();
        stmt.close();
    }

    public void cleanup() throws SQLException {
        if (this.insertStmt != null) {
            this.insertStmt.close();
        }
        this.autoNum.cleanup();
    }

    public IdMapperIFace getMapper() {
        return this.mapper;
    }

    public String getMapperName() {
        return this.mapperName;
    }
}

