/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.util.Pair;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class TableDataChecker {
    private Connection connection;

    public TableDataChecker(Connection connection) {
        this.connection = connection;
    }

    public List<Pair<String, String>> getColumnNamesWithData(String tableName, HashSet<String> skipNames) {
        Vector<Pair<String, String>> fieldsWithData = new Vector<Pair<String, String>>();
        int numRows = BasicSQLUtils.getNumRecords(this.connection, tableName);
        if (numRows > 0) {
            try {
                Vector<Object[]> rows = BasicSQLUtils.query(this.connection, String.format("SELECT COLUMN_NAME, DATA_TYPE, IS_NULLABLE, COLUMN_DEFAULT FROM INFORMATION_SCHEMA.COLUMNS WHERE table_name = '%s' AND table_schema = '%s'", tableName, this.connection.getCatalog()));
                for (Object[] cols : rows) {
                    String sql;
                    int cnt;
                    String fieldName = cols[0].toString();
                    if (skipNames != null && skipNames.contains(fieldName.toLowerCase()) || !cols[2].equals("YES") || (cnt = BasicSQLUtils.getCountAsInt(this.connection, sql = String.format("SELECT COUNT(*) FROM `%s` WHERE `%s` IS NOT NULL", tableName, fieldName))) <= 0) continue;
                    sql = String.format("SELECT DISTINCT c.caption, fst.TextForValue from usysmetacontrol c INNER JOIN usysmetaobject o on o.objectid = c.objectid INNER JOIN usysmetafieldset fs on fs.fieldsetid = o.fieldsetid LEFT JOIN usysmetafieldsetsubtype fst on fst.fieldsetsubtypeid = c.fieldsetsubtypeid WHERE fs.fieldsetname = '%s' and o.objectname = '%s' and (fst.TextForValue is null or (fst.TextForValue not in('TissueOrExtract', 'KaryoSlide', 'HistoSlideSeries', 'Image', 'Sound', 'SoundRecording', 'ImagePrint', 'Spectrogram', 'Container')))", tableName, fieldName);
                    Pair namePair = new Pair();
                    Vector<Object[]> captions = BasicSQLUtils.query(this.connection, sql);
                    if (captions.size() > 0) {
                        namePair.second = (String)captions.get(0)[0];
                    }
                    namePair.first = fieldName;
                    fieldsWithData.add(namePair);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return fieldsWithData;
    }

    public void createHTMLReport(TableWriter tblWriter) {
        String[] sknames;
        tblWriter.setHasLines();
        HashSet<String> skipNames = new HashSet<String>();
        String[] stringArray = sknames = new String[]{"TimestampCreated", "TimestampModified", "LastEditedBy"};
        int n = sknames.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            skipNames.add(n3.toLowerCase());
            ++n2;
        }
        try {
            tblWriter.print("<center>");
            String titleStr = String.format("Nullable Table Columns with Data", this.connection.getCatalog());
            tblWriter.print("<H3>");
            tblWriter.print(titleStr);
            tblWriter.print("</H3>");
            Vector<Object> tableNames = BasicSQLUtils.querySingleCol(this.connection, "SHOW TABLES");
            tblWriter.startTable();
            tblWriter.print("<caption style=\"text-align: center; font-weight: bold; font-size: 14pt;\">");
            tblWriter.print(this.connection.getCatalog());
            tblWriter.print("</caption>");
            String[] headings = new String[]{"Table", "Field Name", "Sp5 Caption"};
            tblWriter.print("<tr>");
            String[] stringArray2 = headings;
            int n4 = headings.length;
            int n5 = 0;
            while (n5 < n4) {
                String head = stringArray2[n5];
                tblWriter.print("<th>");
                tblWriter.print(head);
                tblWriter.println("</th>");
                ++n5;
            }
            tblWriter.println("</tr>");
            for (Object tblObj : tableNames) {
                String tblName = tblObj.toString();
                if (tblName.startsWith("usys") || tblName.startsWith("web") || tblName.startsWith("ft_") || tblName.startsWith("data") || tblName.startsWith("rave") || tblName.startsWith("reports") || StringUtils.contains((String)tblName, (String)"_tmp") || StringUtils.contains((String)tblName, (String)"_dup") || StringUtils.contains((String)tblName, (String)"fulltext")) continue;
                System.out.println("Processing " + tblName);
                List<Pair<String, String>> cols = this.getColumnNamesWithData(tblName, skipNames);
                if (cols.size() <= 0) continue;
                tblWriter.println("<tr>");
                tblWriter.println("<td valign=\"top\" rowspan=\"" + cols.size() + "\"><span style=\"font-weight:bold;\">" + tblName + "</span></td>");
                int cnt = 0;
                for (Pair<String, String> colName : cols) {
                    if (cnt > 0) {
                        tblWriter.print("<tr>");
                    }
                    tblWriter.print("<td>");
                    tblWriter.print((String)colName.first);
                    tblWriter.println("</td><td>");
                    tblWriter.println(colName.second != null ? (String)colName.second : "&nbsp;");
                    tblWriter.println("</td></tr>");
                    ++cnt;
                }
            }
            tblWriter.endTable();
            tblWriter.print("</center>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doCheckDB() {
        try {
            String dbName = this.connection.getCatalog();
            boolean fnd = false;
            Vector<Object[]> tables = BasicSQLUtils.query(this.connection, "show tables");
            for (Object[] tblRow : tables) {
                String tableName = tblRow[0].toString();
                if (!tableName.equalsIgnoreCase("usysversion")) continue;
                fnd = true;
                break;
            }
            if (fnd) {
                TableWriter tDSTblWriter = new TableWriter(String.valueOf(dbName) + "_TableDataSummary.html", "Table Data Summary", true);
                this.createHTMLReport(tDSTblWriter);
                tDSTblWriter.flush();
                tDSTblWriter.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void doAllSp5DBs() {
        try {
            PrintWriter pw = new PrintWriter(new File("index.html"));
            pw.println("<html><body>Databases<br>");
            String cacheCatalog = this.connection.getCatalog();
            Vector<Object[]> dbNames = BasicSQLUtils.query(this.connection, "show databases");
            for (Object[] row : dbNames) {
                String dbName = row[0].toString();
                System.out.print("Database Found [" + dbName + "]  ");
                this.connection.setCatalog(dbName);
                boolean fnd = false;
                Vector<Object[]> tables = BasicSQLUtils.query(this.connection, "show tables");
                for (Object[] tblRow : tables) {
                    String tableName = tblRow[0].toString();
                    if (!tableName.equalsIgnoreCase("usysversion")) continue;
                    fnd = true;
                    break;
                }
                if (!fnd) continue;
                pw.println("<a href='" + dbName + ".html'>" + dbName + "</a><br>");
                TableWriter tDSTblWriter = new TableWriter(String.valueOf(dbName) + "_TableDataSummary.html", "Table Data Summary", true);
                this.createHTMLReport(tDSTblWriter);
                tDSTblWriter.flush();
                tDSTblWriter.close();
            }
            pw.println("</body></html>");
            pw.close();
            if (cacheCatalog != null) {
                this.connection.setCatalog(cacheCatalog);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

