/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TableAutoNumbering {
    private Connection conn;
    private String tableName;
    private String primaryKey;
    private int currentId = 0;
    private PreparedStatement pStmt = null;

    public TableAutoNumbering(Connection conn, String tableName, String primaryKey) {
        this.conn = conn;
        this.tableName = tableName;
        this.primaryKey = primaryKey;
    }

    public void initialize() throws SQLException {
        this.pStmt = this.conn.prepareStatement(String.format("SELECT COUNT(*) FROM %s WHERE %s = ?", this.tableName, this.primaryKey));
    }

    public int getNext() throws SQLException {
        ResultSet rs;
        do {
            ++this.currentId;
            if (this.currentId == Integer.MAX_VALUE) {
                this.currentId = Integer.MIN_VALUE;
            }
            this.pStmt.setInt(1, this.currentId);
        } while (!(rs = this.pStmt.executeQuery()).next() || rs.getInt(1) != 0);
        return this.currentId;
    }

    public void cleanup() throws SQLException {
        if (this.pStmt != null) {
            this.pStmt.close();
        }
    }
}

