/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.specify.config.init.DataBuilder;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.GenericDBConversion;
import edu.ku.brc.specify.conversion.IdMapperIFace;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import edu.ku.brc.specify.conversion.IdTableMapper;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.GeologicTimePeriod;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDef;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDefItem;
import edu.ku.brc.specify.datamodel.LithoStrat;
import edu.ku.brc.specify.datamodel.LithoStratTreeDef;
import edu.ku.brc.specify.datamodel.LithoStratTreeDefItem;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.treeutils.TreeHelper;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIRegistry;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class StratToGTP {
    protected static final Logger log = Logger.getLogger(StratToGTP.class);
    protected GenericDBConversion conversion;
    protected static StringBuilder strBuf = new StringBuilder("");
    protected static SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    protected static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    protected static Timestamp now = new Timestamp(System.currentTimeMillis());
    protected static String nowStr = dateTimeFormatter.format(now);
    protected ProgressFrame frame = null;
    protected boolean hasFrame = false;
    protected Connection oldDBConn = null;
    protected Connection newDBConn = null;
    protected IdMapperMgr idMapperMgr;
    protected TableWriter tblWriter;
    protected GeologicTimePeriodTreeDefItem era;
    protected GeologicTimePeriodTreeDef geoLogTmTreeDef;
    protected GeologicTimePeriod eraNode;
    protected Hashtable<String, GeologicTimePeriod> geoLogTmHash = new Hashtable();

    public StratToGTP(Connection oldDBConn, Connection newDBConn, String oldDBName, TableWriter tblWriter, GenericDBConversion conv) {
        this.oldDBConn = oldDBConn;
        this.newDBConn = newDBConn;
        this.tblWriter = tblWriter;
        this.conversion = conv;
        this.idMapperMgr = IdMapperMgr.getInstance();
    }

    public void createGTPTreeDef() throws SQLException {
        BasicSQLUtils.deleteAllRecordsFromTable("geologictimeperiodtreedef", BasicSQLUtils.myDestinationServerType);
        BasicSQLUtils.deleteAllRecordsFromTable("geologictimeperiodtreedefitem", BasicSQLUtils.myDestinationServerType);
        Session localSession = HibernateUtil.getCurrentSession();
        HibernateUtil.beginTransaction();
        this.geoLogTmTreeDef = StratToGTP.createGeologicTimePeriodTreeDef("GeologicTimePeriod");
        localSession.saveOrUpdate((Object)this.geoLogTmTreeDef);
        this.era = StratToGTP.createGeologicTimePeriodTreeDefItem(this.geoLogTmTreeDef, "Era", 0, false);
        GeologicTimePeriodTreeDefItem superGrp = StratToGTP.createGeologicTimePeriodTreeDefItem(this.era, "Period", 100, false);
        GeologicTimePeriodTreeDefItem lithoGrp = StratToGTP.createGeologicTimePeriodTreeDefItem(superGrp, "Epoch", 200, false);
        GeologicTimePeriodTreeDefItem eml = StratToGTP.createGeologicTimePeriodTreeDefItem(lithoGrp, "EML (epoch)", 300, false);
        GeologicTimePeriodTreeDefItem age = StratToGTP.createGeologicTimePeriodTreeDefItem(eml, "Age", 400, false);
        StratToGTP.createGeologicTimePeriodTreeDefItem(age, "EML (age)", 500, false);
        localSession.saveOrUpdate((Object)this.era);
        this.eraNode = new GeologicTimePeriod();
        this.eraNode.initialize();
        this.eraNode.setName("Era");
        this.eraNode.setFullName("Era");
        this.eraNode.setNodeNumber(1);
        this.eraNode.setHighestChildNodeNumber(1);
        this.eraNode.setRankId(0);
        this.eraNode.setDefinition(this.geoLogTmTreeDef);
        this.eraNode.setDefinitionItem(this.era);
        this.era.getTreeEntries().add(this.eraNode);
        localSession.saveOrUpdate((Object)this.eraNode);
        HibernateUtil.commitTransaction();
        log.info((Object)"Finished inferring GTP tree definition and items");
    }

    public void createGTPTreeDefKUINVP() throws SQLException {
        BasicSQLUtils.deleteAllRecordsFromTable("geologictimeperiodtreedef", BasicSQLUtils.myDestinationServerType);
        BasicSQLUtils.deleteAllRecordsFromTable("geologictimeperiodtreedefitem", BasicSQLUtils.myDestinationServerType);
        Session localSession = HibernateUtil.getCurrentSession();
        HibernateUtil.beginTransaction();
        this.geoLogTmTreeDef = StratToGTP.createGeologicTimePeriodTreeDef("GeologicTimePeriod");
        localSession.saveOrUpdate((Object)this.geoLogTmTreeDef);
        this.era = StratToGTP.createGeologicTimePeriodTreeDefItem(this.geoLogTmTreeDef, "Era", 0, false);
        GeologicTimePeriodTreeDefItem superGrp = StratToGTP.createGeologicTimePeriodTreeDefItem(this.era, "System", 100, false);
        GeologicTimePeriodTreeDefItem lithoGrp = StratToGTP.createGeologicTimePeriodTreeDefItem(superGrp, "Series", 200, false);
        GeologicTimePeriodTreeDefItem eml = StratToGTP.createGeologicTimePeriodTreeDefItem(lithoGrp, "Stage", 300, false);
        localSession.saveOrUpdate((Object)this.era);
        this.eraNode = new GeologicTimePeriod();
        this.eraNode.initialize();
        this.eraNode.setName("Era");
        this.eraNode.setFullName("Era");
        this.eraNode.setNodeNumber(1);
        this.eraNode.setHighestChildNodeNumber(1);
        this.eraNode.setRankId(0);
        this.eraNode.setDefinition(this.geoLogTmTreeDef);
        this.eraNode.setDefinitionItem(this.era);
        this.era.getTreeEntries().add(this.eraNode);
        localSession.saveOrUpdate((Object)this.eraNode);
        HibernateUtil.commitTransaction();
        log.info((Object)"Finished inferring GTP tree definition and items");
    }

    public void createGTPTreeDefNDGS() throws SQLException {
        BasicSQLUtils.deleteAllRecordsFromTable("geologictimeperiodtreedef", BasicSQLUtils.myDestinationServerType);
        BasicSQLUtils.deleteAllRecordsFromTable("geologictimeperiodtreedefitem", BasicSQLUtils.myDestinationServerType);
        Session localSession = HibernateUtil.getCurrentSession();
        HibernateUtil.beginTransaction();
        this.geoLogTmTreeDef = StratToGTP.createGeologicTimePeriodTreeDef("GeologicTimePeriod");
        localSession.saveOrUpdate((Object)this.geoLogTmTreeDef);
        this.era = StratToGTP.createGeologicTimePeriodTreeDefItem(this.geoLogTmTreeDef, "Era", 0, false);
        GeologicTimePeriodTreeDefItem superGrp = StratToGTP.createGeologicTimePeriodTreeDefItem(this.era, "Period", 100, false);
        GeologicTimePeriodTreeDefItem lithoGrp = StratToGTP.createGeologicTimePeriodTreeDefItem(superGrp, "Epoch", 200, false);
        GeologicTimePeriodTreeDefItem eml = StratToGTP.createGeologicTimePeriodTreeDefItem(lithoGrp, "Age", 300, false);
        localSession.saveOrUpdate((Object)this.era);
        this.eraNode = new GeologicTimePeriod();
        this.eraNode.initialize();
        this.eraNode.setName("Era");
        this.eraNode.setFullName("Era");
        this.eraNode.setNodeNumber(1);
        this.eraNode.setHighestChildNodeNumber(1);
        this.eraNode.setRankId(0);
        this.eraNode.setDefinition(this.geoLogTmTreeDef);
        this.eraNode.setDefinitionItem(this.era);
        this.era.getTreeEntries().add(this.eraNode);
        localSession.saveOrUpdate((Object)this.eraNode);
        HibernateUtil.commitTransaction();
        log.info((Object)"Finished inferring GTP tree definition and items");
    }

    public void convertStratToGTP() throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Session localSession = HibernateUtil.getCurrentSession();
            HibernateUtil.beginTransaction();
            int count = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*) FROM stratigraphy");
            if (count < 1) {
                return;
            }
            if (this.hasFrame) {
                this.setProcess(0, count);
            }
            IdTableMapper gtpIdMapper = IdMapperMgr.getInstance().addTableMapper("geologictimeperiod", "GeologicTimePeriodID");
            Hashtable<Integer, Integer> ceToNewStratIdHash = new Hashtable<Integer, Integer>();
            IdMapperIFace ceMapper = IdMapperMgr.getInstance().get("collectingevent", "CollectingEventID");
            String sql = "SELECT s.StratigraphyID, s.SuperGroup, s.Group, s.Formation, s.Member, s.Bed,    s.Text1, s.Text2,  s.Remarks FROM stratigraphy s ORDER BY s.StratigraphyID";
            stmt = this.oldDBConn.createStatement(1004, 1007);
            rs = stmt.executeQuery(sql);
            int counter = 0;
            while (rs.next()) {
                if (counter % 500 == 0) {
                    if (this.hasFrame) {
                        this.setProcess(counter);
                    } else {
                        log.info((Object)("Converted " + counter + " Stratigraphy records"));
                    }
                }
                int oldStratId = rs.getInt(1);
                String period = rs.getString(2);
                String epoch = rs.getString(3);
                String eml = rs.getString(4);
                String age = rs.getString(5);
                String emlAge = rs.getString(6);
                String text1 = rs.getString(7);
                String text2 = rs.getString(8);
                String remarks = rs.getString(9);
                if (StringUtils.isNotEmpty((String)text2) && text2.length() > 128) {
                    remarks = String.valueOf(remarks) + "; " + text2;
                    text2 = text2.substring(0, 128);
                }
                if (StringUtils.isNotEmpty((String)eml)) {
                    epoch = StringUtils.isNotEmpty((String)epoch) ? String.valueOf(epoch) + ' ' + eml : eml;
                }
                if (StringUtils.isEmpty((String)epoch)) {
                    epoch = "(Empty)";
                }
                GeologicTimePeriod newStrat = this.convertOldStratRecord(localSession, this.eraNode, text1, text2, remarks, period, epoch, eml, age, emlAge);
                ++counter;
                gtpIdMapper.put(oldStratId, newStrat.getGeologicTimePeriodId());
                Integer ceId = ceMapper.get(oldStratId);
                if (ceId != null) {
                    ceToNewStratIdHash.put(ceId, newStrat.getGeologicTimePeriodId());
                    continue;
                }
                String msg = String.format("No CE mapping for Old StratId %d, when they are a one-to-one.", oldStratId);
                this.tblWriter.logError(msg);
                log.error((Object)msg);
            }
            stmt.close();
            if (this.hasFrame) {
                this.setProcess(counter);
            } else {
                log.info((Object)("Converted " + counter + " Stratigraphy records"));
            }
            TreeHelper.fixFullnameForNodeAndDescendants(this.eraNode);
            this.eraNode.setNodeNumber(1);
            StratToGTP.fixNodeNumbersFromRoot(this.eraNode);
            rs.close();
            HibernateUtil.commitTransaction();
            log.info((Object)("Converted " + counter + " Stratigraphy records"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void convertStratToGTPNDGS() throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Session localSession = HibernateUtil.getCurrentSession();
            HibernateUtil.beginTransaction();
            int count = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*) FROM stratigraphy");
            if (count < 1) {
                return;
            }
            if (this.hasFrame) {
                this.setProcess(0, count);
            }
            IdTableMapper gtpIdMapper = IdMapperMgr.getInstance().addTableMapper("geologictimeperiod", "GeologicTimePeriodID");
            Hashtable<Integer, Integer> ceToNewStratIdHash = new Hashtable<Integer, Integer>();
            IdMapperIFace ceMapper = IdMapperMgr.getInstance().get("collectingevent", "CollectingEventID");
            String sql = "SELECT StratigraphyID, 'Placeholder',  SuperGroup,  `Group` FROM stratigraphy ORDER BY StratigraphyID";
            stmt = this.oldDBConn.createStatement(1004, 1007);
            rs = stmt.executeQuery(sql);
            int counter = 0;
            while (rs.next()) {
                if (counter % 500 == 0) {
                    if (this.hasFrame) {
                        this.setProcess(counter);
                    } else {
                        log.info((Object)("Converted " + counter + " Stratigraphy records"));
                    }
                }
                int oldStratId = rs.getInt(1);
                String period = rs.getString(2);
                String epoch = rs.getString(3);
                String age = rs.getString(4);
                if (StringUtils.isEmpty((String)epoch)) {
                    epoch = "(Empty)";
                }
                GeologicTimePeriod newStrat = this.convertOldStratRecord(localSession, this.eraNode, null, null, null, period, epoch, age);
                ++counter;
                gtpIdMapper.put(oldStratId, newStrat.getGeologicTimePeriodId());
                Integer ceId = ceMapper.get(oldStratId);
                if (ceId != null) {
                    ceToNewStratIdHash.put(ceId, newStrat.getGeologicTimePeriodId());
                    continue;
                }
                String msg = String.format("No CE mapping for Old StratId %d, when they are a one-to-one.", oldStratId);
                this.tblWriter.logError(msg);
                log.error((Object)msg);
            }
            stmt.close();
            if (this.hasFrame) {
                this.setProcess(counter);
            } else {
                log.info((Object)("Converted " + counter + " Stratigraphy records"));
            }
            TreeHelper.fixFullnameForNodeAndDescendants(this.eraNode);
            this.eraNode.setNodeNumber(1);
            StratToGTP.fixNodeNumbersFromRoot(this.eraNode);
            rs.close();
            HibernateUtil.commitTransaction();
            log.info((Object)("Converted " + counter + " Stratigraphy records"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void convertStratToGTPKUIVP() throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Session localSession = HibernateUtil.getCurrentSession();
            HibernateUtil.beginTransaction();
            int count = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*) FROM stratigraphy");
            if (count < 1) {
                return;
            }
            if (this.hasFrame) {
                this.setProcess(0, count);
            }
            IdTableMapper gtpIdMapper = IdMapperMgr.getInstance().addTableMapper("geologictimeperiod", "GeologicTimePeriodID");
            Hashtable<Integer, Integer> ceToNewStratIdHash = new Hashtable<Integer, Integer>();
            IdMapperIFace ceMapper = IdMapperMgr.getInstance().get("collectingevent", "CollectingEventID");
            String sql = "SELECT s.StratigraphyID, s.Formation, s.SuperGroup, s.Text1 FROM stratigraphy s ORDER BY s.StratigraphyID";
            stmt = this.oldDBConn.createStatement(1004, 1007);
            rs = stmt.executeQuery(sql);
            int counter = 0;
            while (rs.next()) {
                if (counter % 500 == 0) {
                    if (this.hasFrame) {
                        this.setProcess(counter);
                    } else {
                        log.info((Object)("Converted " + counter + " Stratigraphy records"));
                    }
                }
                int oldStratId = rs.getInt(1);
                String system = rs.getString(2);
                String series = rs.getString(3);
                String stage = rs.getString(4);
                if (StringUtils.isNotEmpty((String)stage)) {
                    series = StringUtils.isNotEmpty((String)series) ? String.valueOf(series) + ' ' + stage : stage;
                }
                if (StringUtils.isEmpty((String)series)) {
                    series = "(Empty)";
                }
                GeologicTimePeriod newStrat = this.convertOldStratRecord(localSession, this.eraNode, null, null, null, system, series, stage);
                ++counter;
                gtpIdMapper.put(oldStratId, newStrat.getGeologicTimePeriodId());
                Integer ceId = ceMapper.get(oldStratId);
                if (ceId != null) {
                    ceToNewStratIdHash.put(ceId, newStrat.getGeologicTimePeriodId());
                    continue;
                }
                String msg = String.format("No CE mapping for Old StratId %d, when they are a one-to-one.", oldStratId);
                this.tblWriter.logError(msg);
                log.error((Object)msg);
            }
            stmt.close();
            if (this.hasFrame) {
                this.setProcess(counter);
            } else {
                log.info((Object)("Converted " + counter + " Stratigraphy records"));
            }
            TreeHelper.fixFullnameForNodeAndDescendants(this.eraNode);
            this.eraNode.setNodeNumber(1);
            StratToGTP.fixNodeNumbersFromRoot(this.eraNode);
            rs.close();
            HibernateUtil.commitTransaction();
            log.info((Object)("Converted " + counter + " Stratigraphy records"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static <T extends Treeable<T, ?, ?>> int fixNodeNumbersFromRoot(T root) {
        int nextNodeNumber = root.getNodeNumber();
        for (Treeable child : root.getChildren()) {
            child.setNodeNumber(++nextNodeNumber);
            nextNodeNumber = StratToGTP.fixNodeNumbersFromRoot(child);
        }
        root.setHighestChildNodeNumber(nextNodeNumber);
        return nextNodeNumber;
    }

    private GeologicTimePeriod buildGeologicTimePeriodLevel(String nameArg, GeologicTimePeriod parentArg, Session sessionArg) {
        String name = nameArg;
        if (name == null) {
            name = "N/A";
        }
        Set<GeologicTimePeriod> children = parentArg.getChildren();
        for (GeologicTimePeriod child : children) {
            if (!name.equalsIgnoreCase(child.getName())) continue;
            return child;
        }
        GeologicTimePeriod newStrat = new GeologicTimePeriod();
        newStrat.initialize();
        newStrat.setName(name);
        newStrat.setParent(parentArg);
        parentArg.addChild(newStrat);
        newStrat.setDefinition(parentArg.getDefinition());
        int newGeoRank = parentArg.getRankId() + 100;
        GeologicTimePeriodTreeDefItem defItem = parentArg.getDefinition().getDefItemByRank(newGeoRank);
        newStrat.setDefinitionItem(defItem);
        newStrat.setRankId(newGeoRank);
        if (sessionArg != null) {
            sessionArg.save((Object)newStrat);
        }
        return newStrat;
    }

    private GeologicTimePeriod convertOldStratRecord(Session localSession, GeologicTimePeriod stratRoot, String text1, String text2, String remarks, String ... levelNames) {
        int levelsToBuild = 0;
        int i = levelNames.length;
        while (i > 0) {
            if (StringUtils.isNotEmpty((String)levelNames[i - 1])) {
                levelsToBuild = i;
                break;
            }
            --i;
        }
        i = 0;
        while (i < levelsToBuild) {
            if (StringUtils.isEmpty((String)levelNames[i])) {
                levelNames[i] = "Placeholder";
            }
            ++i;
        }
        GeologicTimePeriod prevLevelGeo = stratRoot;
        int i2 = 0;
        while (i2 < levelsToBuild) {
            GeologicTimePeriod newLevelStrat = this.buildGeologicTimePeriodLevel(levelNames[i2], prevLevelGeo, localSession);
            if (StringUtils.isNotEmpty((String)text1)) {
                newLevelStrat.setText1(text1);
            }
            if (StringUtils.isNotEmpty((String)text2)) {
                newLevelStrat.setText2(text2);
            }
            if (StringUtils.isNotEmpty((String)remarks)) {
                newLevelStrat.setRemarks(remarks);
            }
            if (localSession != null) {
                localSession.save((Object)newLevelStrat);
            }
            prevLevelGeo = newLevelStrat;
            ++i2;
        }
        return prevLevelGeo;
    }

    private static GeologicTimePeriodTreeDef createGeologicTimePeriodTreeDef(String name) {
        GeologicTimePeriodTreeDef lstd = new GeologicTimePeriodTreeDef();
        lstd.initialize();
        lstd.setName(name);
        lstd.setFullNameDirection(1);
        return lstd;
    }

    private static GeologicTimePeriodTreeDefItem createGeologicTimePeriodTreeDefItem(GeologicTimePeriodTreeDefItem parent, String name, int rankId, boolean inFullName) {
        if (parent != null) {
            GeologicTimePeriodTreeDef treeDef = parent.getTreeDef();
            if (treeDef != null) {
                GeologicTimePeriodTreeDefItem lstdi = new GeologicTimePeriodTreeDefItem();
                lstdi.initialize();
                lstdi.setName(name);
                lstdi.setRankId(rankId);
                lstdi.setIsInFullName(inFullName);
                lstdi.setIsEnforced(false);
                lstdi.setTreeDef(treeDef);
                treeDef.getTreeDefItems().add(lstdi);
                parent.getChildren().add(lstdi);
                lstdi.setParent(parent);
                return lstdi;
            }
            throw new RuntimeException("GeologicTimePeriodTreeDef is null!");
        }
        throw new RuntimeException("Parent is null!");
    }

    private static GeologicTimePeriodTreeDefItem createGeologicTimePeriodTreeDefItem(GeologicTimePeriodTreeDef treeDef, String name, int rankId, boolean inFullName) {
        if (treeDef != null) {
            GeologicTimePeriodTreeDefItem lstdi = new GeologicTimePeriodTreeDefItem();
            lstdi.initialize();
            lstdi.setName(name);
            lstdi.setRankId(rankId);
            lstdi.setIsInFullName(inFullName);
            lstdi.setIsEnforced(false);
            lstdi.setTreeDef(treeDef);
            treeDef.getTreeDefItems().add(lstdi);
            return lstdi;
        }
        throw new RuntimeException("GeologicTimePeriodTreeDef is null!");
    }

    public void convertStrat(TableWriter stratTblWriter, boolean isPaleo, boolean useStrat2) throws SQLException {
        Transaction trans = null;
        Session lclSession = null;
        try {
            try {
                BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "lithostrat", BasicSQLUtils.myDestinationServerType);
                lclSession = HibernateUtil.getNewSession();
                List disciplineeList = lclSession.createQuery("FROM Discipline").list();
                for (Object obj : disciplineeList) {
                    trans = lclSession.beginTransaction();
                    Discipline discipline = (Discipline)obj;
                    LithoStratTreeDef lithoStratTreeDef = DataBuilder.createLithoStratTreeDef("LithoStrat");
                    lithoStratTreeDef.getDisciplines().add(discipline);
                    discipline.setLithoStratTreeDef(lithoStratTreeDef);
                    lclSession.saveOrUpdate((Object)lithoStratTreeDef);
                    lclSession.saveOrUpdate((Object)discipline);
                    LithoStratTreeDefItem earth = DataBuilder.createLithoStratTreeDefItem(lithoStratTreeDef, "Earth", 0, false);
                    LithoStratTreeDefItem superGroup = DataBuilder.createLithoStratTreeDefItem(earth, "Suprt Group", 100, false);
                    LithoStratTreeDefItem group = DataBuilder.createLithoStratTreeDefItem(superGroup, "Group", 200, false);
                    LithoStratTreeDefItem formation = DataBuilder.createLithoStratTreeDefItem(group, "Formation", 300, false);
                    LithoStratTreeDefItem member = DataBuilder.createLithoStratTreeDefItem(formation, "Member", 400, false);
                    DataBuilder.createLithoStratTreeDefItem(member, "Unit", 500, false);
                    lclSession.saveOrUpdate((Object)earth);
                    LithoStrat earthNode = new LithoStrat();
                    earthNode.initialize();
                    earthNode.setName("Earth");
                    earthNode.setFullName("Earth");
                    earthNode.setNodeNumber(1);
                    earthNode.setHighestChildNodeNumber(1);
                    earthNode.setRankId(0);
                    earthNode.setDefinition(lithoStratTreeDef);
                    earthNode.setDefinitionItem(earth);
                    earth.getTreeEntries().add(earthNode);
                    lclSession.saveOrUpdate((Object)earthNode);
                    trans.commit();
                    if (!isPaleo) continue;
                    String stratTblName = "stratigraphy" + (useStrat2 ? "2" : "");
                    this.conversion.convertLithoStrat(lithoStratTreeDef, earthNode, stratTblWriter, stratTblName, false);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UIRegistry.showError("Error in convertStrat - " + ex.getLocalizedMessage());
                if (trans != null) {
                    trans.rollback();
                }
                if (lclSession != null) {
                    lclSession.close();
                }
            }
        }
        finally {
            if (lclSession != null) {
                lclSession.close();
            }
        }
    }

    public void convertStratKUINVP(TableWriter stratTblWriter, boolean isPaleo) throws SQLException {
        this.convStratGTPToStratKUINVP();
        Transaction trans = null;
        Session lclSession = null;
        try {
            try {
                BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "lithostrat", BasicSQLUtils.myDestinationServerType);
                lclSession = HibernateUtil.getNewSession();
                List disciplineeList = lclSession.createQuery("FROM Discipline").list();
                for (Object obj : disciplineeList) {
                    trans = lclSession.beginTransaction();
                    Discipline discipline = (Discipline)obj;
                    LithoStratTreeDef lithoStratTreeDef = DataBuilder.createLithoStratTreeDef("LithoStrat");
                    lithoStratTreeDef.getDisciplines().add(discipline);
                    discipline.setLithoStratTreeDef(lithoStratTreeDef);
                    lclSession.saveOrUpdate((Object)lithoStratTreeDef);
                    lclSession.saveOrUpdate((Object)discipline);
                    LithoStratTreeDefItem earth = DataBuilder.createLithoStratTreeDefItem(lithoStratTreeDef, "Earth", 0, false);
                    LithoStratTreeDefItem superGroup = DataBuilder.createLithoStratTreeDefItem(earth, "Super Group", 100, false);
                    LithoStratTreeDefItem group = DataBuilder.createLithoStratTreeDefItem(superGroup, "Group", 200, false);
                    LithoStratTreeDefItem formation = DataBuilder.createLithoStratTreeDefItem(group, "Formation", 300, false);
                    LithoStratTreeDefItem member = DataBuilder.createLithoStratTreeDefItem(formation, "Member", 400, false);
                    DataBuilder.createLithoStratTreeDefItem(member, "Unit", 500, false);
                    lclSession.saveOrUpdate((Object)earth);
                    LithoStrat earthNode = new LithoStrat();
                    earthNode.initialize();
                    earthNode.setName("Earth");
                    earthNode.setFullName("Earth");
                    earthNode.setNodeNumber(1);
                    earthNode.setHighestChildNodeNumber(1);
                    earthNode.setRankId(0);
                    earthNode.setDefinition(lithoStratTreeDef);
                    earthNode.setDefinitionItem(earth);
                    earth.getTreeEntries().add(earthNode);
                    lclSession.saveOrUpdate((Object)earthNode);
                    trans.commit();
                    if (!isPaleo) continue;
                    this.conversion.convertLithoStrat(lithoStratTreeDef, earthNode, stratTblWriter, "stratigraphy2", false);
                }
            }
            catch (Exception ex) {
                if (trans != null) {
                    trans.rollback();
                }
                ex.printStackTrace();
                lclSession.close();
            }
        }
        finally {
            lclSession.close();
        }
    }

    private boolean convStratGTPToStratKUINVP() {
        Statement pStmt1 = null;
        try {
            String sqlCreate = "CREATE TABLE `stratigraphy2` (  `StratigraphyID` int(10) NOT NULL,  `GeologicTimePeriodID` int(10) DEFAULT NULL,  `SuperGroup` varchar(50) CHARACTER SET utf8 DEFAULT NULL,  `Group` varchar(50) CHARACTER SET utf8 DEFAULT NULL,  `Formation` varchar(50) CHARACTER SET utf8 DEFAULT NULL, `Member` varchar(50) CHARACTER SET utf8 DEFAULT NULL,  `Bed` varchar(50) CHARACTER SET utf8 DEFAULT NULL,  `Remarks` longtext,  `Text1` varchar(300) CHARACTER SET utf8 DEFAULT NULL,  `Text2` varchar(300) CHARACTER SET utf8 DEFAULT NULL,  `Number1` double DEFAULT NULL, `Number2` double DEFAULT NULL,  `TimestampCreated` datetime DEFAULT NULL,  `TimestampModified` datetime DEFAULT NULL,  `LastEditedBy` varchar(50) CHARACTER SET utf8 DEFAULT NULL,  `YesNo1` smallint(5) DEFAULT NULL,  `YesNo2` smallint(5) DEFAULT NULL,  PRIMARY KEY (`StratigraphyID`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
            DBMSUserMgr dbMgr = DBMSUserMgr.getInstance();
            dbMgr.setConnection(this.oldDBConn);
            if (dbMgr.doesDBHaveTable("stratigraphy2")) {
                try {
                    BasicSQLUtils.update(this.oldDBConn, "DROP TABLE stratigraphy2");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dbMgr.setConnection(null);
            BasicSQLUtils.update(this.oldDBConn, sqlCreate);
            String postfix = " FROM collectingevent AS ce Inner Join stratigraphy AS s ON ce.CollectingEventID = s.StratigraphyID Left Join geologictimeperiod AS g ON s.GeologicTimePeriodID = g.GeologicTimePeriodID WHERE s.`Group` IS NOT NULL OR g.Name IS NOT NULL OR s.Member IS NOT NULL OR s.Bed IS NOT NULL OR g.GeologicTimePeriodID IS NOT NULL";
            String sql = "SELECT ce.CollectingEventID, s.`Group`, g.Name, s.Member, s.Bed, s.TimestampCreated, s.TimestampModified " + postfix;
            log.debug((Object)sql);
            String cntSQL = "SELECT COUNT(*) " + postfix;
            int habCnt = BasicSQLUtils.getCountAsInt(this.oldDBConn, cntSQL);
            log.debug((Object)("****** Startigraphy Count: " + habCnt));
            String placeholder = "Placeholder";
            pStmt1 = this.oldDBConn.prepareStatement("INSERT INTO stratigraphy2 (StratigraphyID, SuperGroup, `Group`, Formation, Member, Bed, TimestampCreated, TimestampModified) VALUES(?,?,?,?,?,?,?,?)");
            int cnt = 0;
            Vector<Object[]> rows = BasicSQLUtils.query(this.oldDBConn, sql);
            for (Object[] row : rows) {
                Integer ceID = (Integer)row[0];
                String superGrp = placeholder;
                String group = (String)row[1];
                String formation = (String)row[2];
                String member = (String)row[3];
                String bed = (String)row[4];
                Timestamp crTS = (Timestamp)row[5];
                Timestamp mdTS = (Timestamp)row[6];
                if (StringUtils.isNotEmpty((String)bed) && bed.length() > 50) {
                    bed = bed.substring(0, 50);
                }
                if (ceID == null) continue;
                pStmt1.setInt(1, ceID);
                pStmt1.setString(2, superGrp);
                pStmt1.setString(3, group);
                pStmt1.setString(4, formation);
                pStmt1.setString(5, member);
                pStmt1.setString(6, bed);
                pStmt1.setTimestamp(7, crTS);
                pStmt1.setTimestamp(8, mdTS);
                pStmt1.execute();
                if (++cnt % 100 != 0) continue;
                log.debug((Object)(String.valueOf(cnt) + " / " + habCnt));
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (pStmt1 != null) {
                    pStmt1.close();
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public void setFrame(ProgressFrame frame) {
        this.frame = frame;
        this.hasFrame = frame != null;
        BasicSQLUtils.setFrame(frame);
        if (this.idMapperMgr != null) {
            this.idMapperMgr.setFrame(frame);
        }
    }

    public void setOverall(int min, int max) {
        if (this.hasFrame) {
            this.frame.setOverall(min, max);
        }
    }

    public void setOverall(int value) {
        if (this.hasFrame) {
            this.frame.setOverall(value);
        }
    }

    public void setProcess(int min, int max) {
        if (this.hasFrame) {
            this.frame.setProcess(min, max);
        }
    }

    public void setProcess(int value) {
        if (this.hasFrame) {
            this.frame.setProcess(value);
        }
    }

    public void setDesc(String text) {
        if (this.hasFrame) {
            this.frame.setDesc(text);
        }
    }

    public Connection getOldDBConnection() {
        return this.oldDBConn;
    }
}

