/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.DesertBlue;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.db.MySQLBackupService;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.dbsupport.MySQLDMBSUserMgr;
import edu.ku.brc.dbsupport.ResultsPager;
import edu.ku.brc.dbsupport.SchemaUpdateService;
import edu.ku.brc.helpers.Encryption;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.SpecifyUserTypes;
import edu.ku.brc.specify.config.FixDBAfterLogin;
import edu.ku.brc.specify.config.init.DataBuilder;
import edu.ku.brc.specify.conversion.AgentConverter;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.CollectionInfo;
import edu.ku.brc.specify.conversion.CollectionInfoModel;
import edu.ku.brc.specify.conversion.ConvScopeFixer;
import edu.ku.brc.specify.conversion.ConversionLogger;
import edu.ku.brc.specify.conversion.ConvertMiscData;
import edu.ku.brc.specify.conversion.ConvertStatSender;
import edu.ku.brc.specify.conversion.ConvertTaxonHelper;
import edu.ku.brc.specify.conversion.CustomDBConverterDlg;
import edu.ku.brc.specify.conversion.DisciplineDuplicator;
import edu.ku.brc.specify.conversion.DuplicateCollectingEvents;
import edu.ku.brc.specify.conversion.GenericDBConversion;
import edu.ku.brc.specify.conversion.GulfInvertsFixer;
import edu.ku.brc.specify.conversion.IdHashMapper;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import edu.ku.brc.specify.conversion.IdTableMapper;
import edu.ku.brc.specify.conversion.OldDBStatsDlg;
import edu.ku.brc.specify.conversion.ShipmentConverter;
import edu.ku.brc.specify.conversion.StratToGTP;
import edu.ku.brc.specify.conversion.TableDataChecker;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.PrepType;
import edu.ku.brc.specify.datamodel.Preparation;
import edu.ku.brc.specify.datamodel.SpPrincipal;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.Storage;
import edu.ku.brc.specify.datamodel.StorageTreeDef;
import edu.ku.brc.specify.datamodel.StorageTreeDefItem;
import edu.ku.brc.specify.dbsupport.PostInsertEventListener;
import edu.ku.brc.specify.tools.SpecifySchemaGenerator;
import edu.ku.brc.specify.ui.AppBase;
import edu.ku.brc.specify.utilapps.BuildSampleDatabase;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import edu.ku.brc.util.Triple;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class SpecifyDBConverter
extends AppBase {
    protected static final Logger log = Logger.getLogger(SpecifyDBConverter.class);
    protected static final int OVERALL_STEPS = 22;
    protected static Hashtable<String, Integer> prepTypeMapper = new Hashtable();
    protected static int attrsId = 0;
    protected static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    protected static StringBuffer strBuf = new StringBuffer("");
    protected static Calendar calendar = Calendar.getInstance();
    protected static String convOutputPath = null;
    protected long startTime;
    protected long endTime;
    protected long waitTime;
    protected static boolean doFixCollectors = false;
    protected Pair<String, String> namePairToConvert = null;
    protected static ProgressFrame frame = null;
    protected Pair<String, String> itUsrPwd = new Pair<Object, Object>(null, null);
    protected Pair<String, String> masterUsrPwd = new Pair<String, String>("Master", "Master");
    protected String hostName = "localhost";
    protected GenericDBConversion conversion;
    protected ConversionLogger convLogger = new ConversionLogger();

    public SpecifyDBConverter() {
        PostInsertEventListener.setAuditOn(false);
        SpecifyDBConverter.setUpSystemProperties();
        AppContextMgr.getInstance().setHasContext(true);
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        localPrefs.setDirPath(UIRegistry.getAppDataDir());
        IconManager.setApplicationClass(Specify.class);
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_datamodel.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_plugins.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_disciplines.xml"));
        this.appIcon = new JLabel("  ");
        this.setAppIcon(null);
    }

    public static void main(String[] args) throws Exception {
        UIRegistry.setAppName("Specify");
        log.debug((Object)("********* Current [" + new File(".").getAbsolutePath() + "]"));
        UIRegistry.setEmbeddedDBPath(UIRegistry.getDefaultEmbeddedDBPath());
        AppBase.processArgs(args);
        SpecifyDBConverter converter = new SpecifyDBConverter();
        Logger logger = LogManager.getLogger((String)"edu.ku.brc");
        if (logger != null) {
            logger.setLevel(Level.ALL);
            System.out.println("Setting " + logger.getName() + " to " + logger.getLevel());
        }
        if ((logger = LogManager.getLogger(HibernateUtil.class)) != null) {
            logger.setLevel(Level.INFO);
            System.out.println("Setting " + logger.getName() + " to " + logger.getLevel());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!System.getProperty("os.name").equals("Mac OS X")) {
                        UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
                        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new DesertBlue());
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Can't change L&F: ", (Throwable)e);
                }
                Pair<String, String> namePair = null;
                try {
                    if (SpecifyDBConverter.this.selectedDBsToConvert(false)) {
                        namePair = SpecifyDBConverter.this.chooseTable("Select a DB to Convert", "Specify 5 Databases", true);
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    JOptionPane.showConfirmDialog(null, "The Converter was unable to login.", "Error", -1);
                }
                if (namePair != null) {
                    frame = new ProgressFrame("Converting");
                    SpecifyDBConverter.this.processDB();
                } else {
                    JOptionPane.showConfirmDialog(null, "The Converter was unable to login.", "Error", -1);
                    System.exit(0);
                }
            }
        });
    }

    protected boolean showStatsFromNewCollection(Connection newDBConn) {
        String[] queries = new String[]{"SELECT count(*) FROM collectionobject", "SELECT count(*) FROM preparation", "SELECT count(*) FROM determination", "SELECT count(*) FROM taxon", "SELECT count(*) FROM agent"};
        String[] descs = new String[]{"CollectionObjects", "Preparations", "Determinations", "Taxon", "Agents"};
        Object[][] rows = new Object[queries.length][2];
        int i = 0;
        while (i < queries.length) {
            rows[i][0] = descs[i];
            rows[i][1] = BasicSQLUtils.getCount(newDBConn, queries[i]);
            ++i;
        }
        JTable table = new JTable(rows, new Object[]{"Description", "Count"});
        CustomDialog dlg = new CustomDialog(null, "Destination DB Statistics", true, 3, (Component)UIHelper.createScrollPane(table, true));
        dlg.setOkLabel("Continue");
        dlg.setVisible(true);
        return !dlg.isCancelled();
    }

    public Pair<String, String> chooseTable(String title, String subTitle, boolean doSp5DBs) throws SQLException {
        MySQLDMBSUserMgr mgr = new MySQLDMBSUserMgr();
        Vector<DBNamePair> availPairs = new Vector<DBNamePair>();
        if (mgr.connectToDBMS((String)this.itUsrPwd.first, (String)this.itUsrPwd.second, this.hostName)) {
            BasicSQLUtils.setSkipTrackExceptions(true);
            Connection conn = mgr.getConnection();
            Vector<Object[]> dbNames = BasicSQLUtils.query(conn, "show databases");
            for (Object[] row : dbNames) {
                Vector<Object> tableDesc;
                String dbName = row[0].toString();
                conn.setCatalog(dbName);
                boolean isSp5DB = false;
                Vector<Object[]> tables = BasicSQLUtils.query(conn, "show tables");
                for (Object[] tblRow : tables) {
                    String tableName = tblRow[0].toString();
                    if (!tableName.equalsIgnoreCase("usysversion")) continue;
                    isSp5DB = true;
                    break;
                }
                if (!isSp5DB && doSp5DBs || isSp5DB && !doSp5DBs) continue;
                try {
                    Integer count = BasicSQLUtils.getCount(conn, "select COUNT(*) FROM collection");
                    if (count == null) {
                        for (Object[] tblRow : tables) {
                            String tableName = tblRow[0].toString();
                            if (tableName.equals(tableName.toLowerCase())) continue;
                            BasicSQLUtils.update(conn, "RENAME TABLE " + tableName + " TO " + tableName.toLowerCase());
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if ((tableDesc = BasicSQLUtils.querySingleCol(conn, "select CollectionName FROM collection")).size() <= 0) continue;
                String collName = tableDesc.get(0).toString();
                availPairs.add(new DBNamePair(collName, row[0].toString()));
            }
            Collections.sort(availPairs, new Comparator<Pair<String, String>>(){

                @Override
                public int compare(Pair<String, String> o1, Pair<String, String> o2) {
                    return ((String)o1.second).compareTo((String)o2.second);
                }
            });
            mgr.close();
            BasicSQLUtils.setSkipTrackExceptions(false);
            final JList list = new JList(availPairs);
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p,4px,f:p:g"));
            pb.add((Component)UIHelper.createLabel(subTitle), cc.xy(1, 1));
            pb.add((Component)UIHelper.createScrollPane(list, true), cc.xy(1, 3));
            pb.setDefaultDialogBorder();
            final CustomDialog dlg = new CustomDialog(null, title, true, pb.getPanel());
            list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        dlg.getOkBtn().setEnabled(list.getSelectedIndex() > -1);
                    }
                }
            });
            list.setSelectionMode(0);
            list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        dlg.getOkBtn().setEnabled(list.getSelectedIndex() > -1);
                        dlg.getOkBtn().doClick();
                    }
                }
            });
            dlg.createUI();
            dlg.pack();
            Dimension d = dlg.getPreferredSize();
            d.height = 700;
            dlg.setSize(d);
            UIHelper.centerAndShow(dlg);
            if (dlg.isCancelled()) {
                return null;
            }
            this.namePairToConvert = (DBNamePair)list.getSelectedValue();
            return this.namePairToConvert;
        }
        return null;
    }

    protected void processDB() {
        convOutputPath = String.valueOf(UIRegistry.getUserHomeDir()) + File.separator + "conversions";
        String inputName = null;
        inputName = this.namePairToConvert.second != null && ((String)this.namePairToConvert.second).startsWith("sp5_") ? ((String)this.namePairToConvert.second).substring(4) : String.valueOf((String)this.namePairToConvert.second) + "_6";
        if (inputName != null) {
            final String destName = inputName;
            SwingWorker worker = new SwingWorker(){

                @Override
                public Object construct() {
                    try {
                        frame.setTitle("Converting " + SpecifyDBConverter.this.namePairToConvert.toString() + "...");
                        SpecifyDBConverter.this.convertDB((String)SpecifyDBConverter.this.namePairToConvert.second, destName);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return null;
                }

                @Override
                public void finished() {
                    System.exit(0);
                }
            };
            worker.start();
        }
    }

    private void fixOldTablesTimestamps(Connection oldDBConn) {
        SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String nowStr = dateTimeFormatter.format(now);
        List<String> tableNames = BasicSQLUtils.getTableNames(oldDBConn);
        frame.setProcess(0, tableNames.size());
        int cnt = 0;
        for (String tableName : tableNames) {
            frame.setProcess(cnt++);
            if (tableName.toLowerCase().startsWith("usys") || tableName.toLowerCase().startsWith("web") || tableName.toLowerCase().equals("taxonomytype") || tableName.toLowerCase().equals("taxonomicunittype") || tableName.toLowerCase().equals("reports")) continue;
            try {
                System.out.println("Table: " + tableName);
                List<String> fieldNames = BasicSQLUtils.getFieldNamesFromSchema(oldDBConn, tableName);
                for (String fieldName : fieldNames) {
                    if (!fieldName.equals("TimestampCreated") || BasicSQLUtils.getCountAsInt(oldDBConn, "SELECT COUNT(*) FROM " + tableName + " WHERE TimestampCreated IS NULL") <= 0) continue;
                    BasicSQLUtils.update(oldDBConn, "UPDATE " + tableName + " SET TimestampCreated='" + nowStr + "' WHERE TimestampCreated IS NULL");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        frame.setProcess(tableNames.size());
        log.debug((Object)"Done setting Timestamps");
    }

    private HashSet<String> getOldEditedByStrings(Connection oldDBConn) {
        HashSet<String> names = new HashSet<String>();
        List<String> tableNames = BasicSQLUtils.getTableNames(oldDBConn);
        frame.setProcess(0, tableNames.size());
        int cnt = 0;
        block2: for (String tableName : tableNames) {
            frame.setProcess(cnt++);
            if (tableName.toLowerCase().startsWith("usys") || tableName.toLowerCase().startsWith("web") || tableName.toLowerCase().equals("taxonomytype") || tableName.toLowerCase().equals("taxonomicunittype") || tableName.toLowerCase().equals("reports")) continue;
            try {
                System.out.println("Table: " + tableName);
                List<String> fieldNames = BasicSQLUtils.getFieldNamesFromSchema(oldDBConn, tableName);
                for (String fieldName : fieldNames) {
                    if (!fieldName.equals("LastEditedBy")) continue;
                    String sql = "SELECT LastEditedBy FROM " + tableName + " WHERE LastEditedBy IS NOT NULL GROUP BY LastEditedBy";
                    for (Object obj : BasicSQLUtils.querySingleCol(oldDBConn, sql)) {
                        names.add(obj.toString());
                    }
                    continue block2;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        frame.setProcess(tableNames.size());
        for (String name : names) {
            System.out.println(name);
        }
        log.debug((Object)"Done getting LastEditedBy");
        return names;
    }

    /*
     * Unable to fully structure code
     */
    protected void convertDB(String dbNameSource, String dbNameDest) throws Exception {
        AppContextMgr.getInstance().clear();
        startfromScratch = true;
        deleteMappingTables = false;
        System.out.println("************************************************************");
        System.out.println("From " + dbNameSource + " to " + dbNameDest);
        System.out.println("************************************************************");
        HibernateUtil.shutdown();
        driverInfo = DatabaseDriverInfo.getDriver("MySQL");
        oldConnStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, this.hostName, dbNameSource, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second, driverInfo.getName());
        newConnStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, this.hostName, dbNameDest, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second, driverInfo.getName());
        mysqlMgr = new MySQLDMBSUserMgr();
        if (mysqlMgr.connectToDBMS((String)this.itUsrPwd.first, (String)this.itUsrPwd.second, this.hostName) && !mysqlMgr.doesDBExists(dbNameDest)) {
            mysqlMgr.createDatabase(dbNameDest);
        }
        mysqlMgr.close();
        if (!UIHelper.tryLogin(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), dbNameDest, newConnStr, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second)) {
            SpecifyDBConverter.log.error((Object)("Failed connection string: " + driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, this.hostName, dbNameDest, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second, driverInfo.getName())));
            throw new RuntimeException("Couldn't login into [" + dbNameDest + "] " + DBConnection.getInstance().getErrorMsg());
        }
        SpecifyDBConverter.log.debug((Object)"Preparing new database");
        SpecifyDBConverter.frame.setDesc("Gather statistics from " + dbNameDest);
        SpecifyDBConverter.frame.turnOffOverAll();
        SpecifyDBConverter.frame.getProcessProgress().setIndeterminate(true);
        UIHelper.centerAndShow(SpecifyDBConverter.frame);
        oldDB = DBConnection.createInstance(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), dbNameDest, oldConnStr, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second);
        oldDBConn = oldDB.createConnection();
        newDBConn = DBConnection.getInstance().createConnection();
        if (!this.isOldDBOK(oldDBConn)) {
            return;
        }
        doUserAgents = false;
        if (doUserAgents) {
            this.fixupUserAgents(newDBConn);
            return;
        }
        doObs = false;
        if (doObs) {
            ConvertMiscData.convertObservations(oldDBConn, newDBConn, 3);
            return;
        }
        doFixLoanPreps = false;
        if (doFixLoanPreps) {
            this.fixLoanPreps(oldDBConn, newDBConn);
            this.fixGiftPreps(oldDBConn, newDBConn);
            return;
        }
        doGetLastEditedByNamesHashSet = false;
        if (doGetLastEditedByNamesHashSet) {
            this.getOldEditedByStrings(oldDBConn);
        }
        if (doFix = false) {
            IdMapperMgr.getInstance().setDBs(oldDBConn, newDBConn);
            dce = new DuplicateCollectingEvents(oldDBConn, newDBConn);
            dce.fixCollectorsForCollectingEvents2();
            return;
        }
        doCEAttrFIx = false;
        if (doCEAttrFIx) {
            SpecifyDBConverter.frame.setDesc("Fixing Scope....");
            IdMapperMgr.getInstance().setDBs(oldDBConn, newDBConn);
            this.convLogger.initialize(SpecifyDBConverter.convOutputPath, dbNameDest);
            tblWriter = this.convLogger.getWriter("ScopeUpdater.html", "Updating Scope Summary");
            convScopeFixer = new ConvScopeFixer(oldDBConn, newDBConn, dbNameDest, tblWriter);
            convScopeFixer.doFixTables();
            oldDBConn.close();
            newDBConn.close();
            System.exit(0);
        }
        if (doImagesToWebLinks = false) {
            SpecifyDBConverter.frame.setDesc("Fixing Scope....");
            IdMapperMgr.getInstance().setDBs(oldDBConn, newDBConn);
            ConvertMiscData.convertImagesToWebLinks(oldDBConn, newDBConn);
            oldDBConn.close();
            newDBConn.close();
            System.exit(0);
        }
        if (!System.getProperty("user.name").equals("rods")) {
            dlg = new OldDBStatsDlg(oldDBConn);
            SpecifyDBConverter.frame.setVisible(false);
            dlg.setVisible(true);
            if (dlg.isCancelled()) {
                oldDBConn.close();
                newDBConn.close();
                System.exit(0);
            }
            SpecifyDBConverter.doFixCollectors = dlg.doFixAgents();
        }
        this.startTime = System.currentTimeMillis();
        this.convLogger.initialize(SpecifyDBConverter.convOutputPath, dbNameDest);
        this.convLogger.setIndexTitle(String.valueOf(dbNameDest) + " Conversion " + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(Calendar.getInstance().getTime()));
        doCheckLastEditedByNamesHashSet = false;
        if (doCheckLastEditedByNamesHashSet) {
            IdMapperMgr.getInstance().setDBs(oldDBConn, newDBConn);
            IdMapperMgr.getInstance().addTableMapper("agent", "AgentID", false);
            this.convLogger.initialize(SpecifyDBConverter.convOutputPath, dbNameDest);
            this.convLogger.setIndexTitle(String.valueOf(dbNameDest) + " Conversion " + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(Calendar.getInstance().getTime()));
            this.conversion = new GenericDBConversion(oldDBConn, newDBConn, dbNameSource, this.convLogger);
            this.conversion.checkCreatedModifiedByAgents();
            return;
        }
        doKUINVP = StringUtils.contains((String)dbNameDest, (String)"kuinvp4_dbo");
        doCUPaleo = StringUtils.contains((String)dbNameDest, (String)"cupaleo");
        ndgs = StringUtils.contains((String)dbNameDest, (String)"ndgs");
        if (doCUPaleo) {
            ConvertMiscData.moveHabitatToStratSp5(oldDBConn);
        }
        if (doFix2 = false) {
            ConvertMiscData.convertMethodFromStratGTP(oldDBConn, newDBConn);
            return;
        }
        SpecifyDBConverter.frame.setSize(500, SpecifyDBConverter.frame.getPreferredSize().height);
        SpecifyDBConverter.frame.setDesc("Fixing NULL Timestamps for conversion.");
        UIHelper.centerAndShow(SpecifyDBConverter.frame);
        this.fixOldTablesTimestamps(oldDBConn);
        SpecifyDBConverter.frame.turnOnOverAll();
        this.conversion = new GenericDBConversion(oldDBConn, newDBConn, dbNameSource, this.convLogger);
        collInitStatus = this.conversion.initialize();
        if (collInitStatus == GenericDBConversion.CollectionResultType.eError) {
            oldDBConn.close();
            newDBConn.close();
            throw new RuntimeException("There are no collections!");
        }
        if (collInitStatus == GenericDBConversion.CollectionResultType.eCancel) {
            oldDBConn.close();
            newDBConn.close();
            System.exit(0);
        }
        if (doFixDisciplineIntoCEs = false) {
            this.doSetDisciplineIntoCEs(oldDBConn, newDBConn);
            return;
        }
        doFixDisciplineIntoLocalities = false;
        if (doFixDisciplineIntoLocalities) {
            this.doSetDisciplineIntoLocalities(oldDBConn, newDBConn);
            return;
        }
        doFix3 = false;
        if (doFix3) {
            IdMapperMgr.getInstance().setDBs(oldDBConn, newDBConn);
            agentConverter = new AgentConverter(this.conversion, IdMapperMgr.getInstance(), false);
            agentConverter.fixMissingAddrsFromConv();
            oldDBConn.close();
            newDBConn.close();
            return;
        }
        doFix4 = false;
        if (doFix4) {
            IdMapperMgr.getInstance().setDBs(oldDBConn, newDBConn);
            ConvertMiscData.moveStratFieldsToCEA(oldDBConn, newDBConn);
            oldDBConn.close();
            newDBConn.close();
            return;
        }
        doFix5 = false;
        if (doFix5) {
            IdMapperMgr.getInstance().setDBs(oldDBConn, newDBConn);
            ConvertMiscData.moveGTPNameToCEText1(oldDBConn, newDBConn);
            oldDBConn.close();
            newDBConn.close();
            return;
        }
        doFix6 = false;
        if (doFix6) {
            ConvertTaxonHelper.fixTaxonomicUnitType(oldDBConn);
            oldDBConn.close();
            newDBConn.close();
            return;
        }
        doFix7 = false;
        if (doFix7) {
            IdMapperMgr.getInstance().setDBs(oldDBConn, newDBConn);
            ConvertMiscData.moveGTPNameToLocalityVer(oldDBConn, newDBConn);
            oldDBConn.close();
            newDBConn.close();
            return;
        }
        sql = "SELECT count(*) FROM (SELECT ce.CollectingEventID, Count(ce.CollectingEventID) as cnt FROM collectingevent AS ce Inner Join collectionobject AS co ON ce.CollectingEventID = co.CollectingEventID Inner Join collectionobjectcatalog AS cc ON co.CollectionObjectID = cc.CollectionObjectCatalogID WHERE ce.BiologicalObjectTypeCollectedID <  21 GROUP BY ce.CollectingEventID) T1 WHERE cnt > 1";
        numCESharing = BasicSQLUtils.getCountAsInt(oldDBConn, sql);
        msg = String.format("Will this Collection share Collecting Events?\nThere are %d Collecting Events that are sharing now.\n(Sp5 was %ssharing them.)", new Object[]{numCESharing, this.isUsingEmbeddedCEsInSp5() != false ? "NOT " : ""});
        isSharingCollectingEvents = UIHelper.promptForAction("Share", "Adjust CEs", "Duplicate Collecting Events", msg);
        doingOneToOneForColObjToCE = isSharingCollectingEvents == false;
        this.conversion.setSharingCollectingEvents(isSharingCollectingEvents);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpecifyDBConverter.this.conversion.setFrame(frame);
                frame.setDesc("Building Database Schema...");
                frame.adjustProgressFrame();
                frame.getProcessProgress().setIndeterminate(true);
                frame.getProcessProgress().setString("");
                UIHelper.centerAndShow(frame);
            }
        });
        if (startfromScratch) {
            doBuild = true;
            file = new File("blank.sql");
            System.err.println(file.getAbsolutePath());
            if (file.exists()) {
                dbMgr = DBMSUserMgr.getInstance();
                if (dbMgr.connect((String)this.itUsrPwd.first, (String)this.itUsrPwd.second, "localhost", dbNameDest)) {
                    if (dbMgr.doesDBExists(dbNameDest)) {
                        dbMgr.dropDatabase(dbNameDest);
                    }
                    if (dbMgr.createDatabase(dbNameDest)) {
                        doBuild = false;
                    }
                    dbMgr.close();
                }
                v0 = doBuild = (bkService = new MySQLBackupService()).doRestore(file.getAbsolutePath(), "/usr/local/mysql/bin/mysql", dbNameDest, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second) == false;
            }
            if (doBuild) {
                dbMgr = DBMSUserMgr.getInstance();
                if (dbMgr.connect((String)this.itUsrPwd.first, (String)this.itUsrPwd.second, "localhost", dbNameDest)) {
                    if (dbMgr.doesDBExists(dbNameDest)) {
                        dbMgr.dropDatabase(dbNameDest);
                    }
                    if (dbMgr.createDatabase(dbNameDest)) {
                        doBuild = false;
                    }
                    dbMgr.close();
                }
                SpecifyDBConverter.log.debug((Object)"Starting from scratch and generating the schema");
                SpecifySchemaGenerator.generateSchema(driverInfo, this.hostName, dbNameDest, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second);
            }
        }
        SpecifyDBConverter.log.debug((Object)"Preparing new database: completed");
        DataBuilder.setSession(HibernateUtil.getNewSession());
        idMapperMgr = null;
        specifyUser = null;
        try {
            block130: {
                GenericDBConversion.setShouldCreateMapTables(startfromScratch);
                GenericDBConversion.setShouldDeleteMapTables(deleteMappingTables);
                SpecifyDBConverter.frame.setOverall(0, 22);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UIHelper.centerAndShow(frame);
                    }
                });
                doConvert = true;
                if (!doConvert) ** GOTO lbl684
                BuildSampleDatabase.createSpecifySAUser(this.hostName, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second, (String)this.masterUsrPwd.first, (String)this.masterUsrPwd.second, dbNameDest);
                idMapperMgr = IdMapperMgr.getInstance();
                oldConn = this.conversion.getOldDBConnection();
                newConn = this.conversion.getNewDBConnection();
                if (oldConn == null || newConn == null) {
                    SpecifyDBConverter.log.error((Object)"One of the DB connections is null.  Cannot proceed.  Check your DB install to make sure both DBs exist.");
                    System.exit(-1);
                }
                idMapperMgr.setDBs(oldConn, newConn);
                BasicSQLUtils.setDBConnection(this.conversion.getNewDBConnection());
                this.conversion.doInitialize();
                doAll = true;
                if (startfromScratch) {
                    BasicSQLUtils.deleteAllRecordsFromTable(this.conversion.getNewDBConnection(), "agent", BasicSQLUtils.myDestinationServerType);
                    BasicSQLUtils.deleteAllRecordsFromTable(this.conversion.getNewDBConnection(), "address", BasicSQLUtils.myDestinationServerType);
                }
                this.conversion.initializeAgentInfo(startfromScratch);
                SpecifyDBConverter.frame.setDesc("Mapping Tables.");
                SpecifyDBConverter.log.info((Object)"Mapping Tables.");
                mapTables = true;
                if (mapTables) {
                    BasicSQLUtils.setFieldsToIgnoreWhenMappingIDs(new String[]{"MethodID", "RoleID", "CollectionID", "ConfidenceID", "TypeStatusNameID", "ObservationMethodID", "StatusID", "TypeID", "ShipmentMethodID", "RankID", "DirectParentRankID", "RequiredParentRankID", "MediumID"});
                    this.conversion.mapIds();
                    BasicSQLUtils.setFieldsToIgnoreWhenMappingIDs(null);
                }
                SpecifyDBConverter.frame.incOverall();
                institutionId = this.conversion.createInstitution("Natural History Museum");
                if (institutionId == null) {
                    UIRegistry.showError("Problem with creating institution, the Id came back null");
                    System.exit(0);
                }
                this.conversion.convertDivision(institutionId);
                SpecifyDBConverter.frame.incOverall();
                userAgent = null;
                if (startfromScratch) {
                    username = "testuser";
                    title = "Mr.";
                    firstName = "Test";
                    lastName = "User";
                    midInit = "C";
                    abbrev = "tcu";
                    email = "testuser@ku.edu";
                    userType = SpecifyUserTypes.UserType.Manager.toString();
                    password = "testuser";
                    trans = DataBuilder.getSession().beginTransaction();
                    BasicSQLUtils.deleteAllRecordsFromTable(newConn, "specifyuser", BasicSQLUtils.myDestinationServerType);
                    criteria = DataBuilder.getSession().createCriteria(Agent.class);
                    criteria.add((Criterion)Restrictions.eq((String)"lastName", (Object)lastName));
                    criteria.add((Criterion)Restrictions.eq((String)"firstName", (Object)firstName));
                    list = criteria.list();
                    userAgent = list != null && list.size() == 1 ? (Agent)list.get(0) : DataBuilder.createAgent(title, firstName, midInit, lastName, abbrev, email);
                    institution = (Institution)DataBuilder.getSession().createQuery("FROM Institution").list().get(0);
                    encrypted = Encryption.encrypt(password, password);
                    specifyUser = DataBuilder.createAdminGroupAndUser(DataBuilder.getSession(), institution, null, username, email, encrypted, userType);
                    specifyUser.addReference(userAgent, "agents");
                    DataBuilder.getSession().saveOrUpdate((Object)institution);
                    userAgent.setDivision(AppContextMgr.getInstance().getClassObject(Division.class));
                    DataBuilder.getSession().saveOrUpdate((Object)userAgent);
                    trans.commit();
                    DataBuilder.getSession().flush();
                } else {
                    specifyUser = (SpecifyUser)DataBuilder.getSession().createCriteria(SpecifyUser.class).list().get(0);
                    userAgent = specifyUser.getAgents().iterator().next();
                    AppContextMgr.getInstance().setClassObject(SpecifyUser.class, specifyUser);
                    collection = (Collection)DataBuilder.getSession().createCriteria(Collection.class).list().get(0);
                    AppContextMgr.getInstance().setClassObject(Collection.class, collection);
                }
                taxonTblWriter = this.convLogger.getWriter("FullTaxon.html", "Taxon Conversion");
                taxonHelper = new ConvertTaxonHelper(oldDBConn, newDBConn, dbNameDest, SpecifyDBConverter.frame, taxonTblWriter, this.conversion, this.conversion);
                taxonHelper.createTaxonIdMappings();
                taxonHelper.doForeignKeyMappings();
                SpecifyDBConverter.frame.setDesc("Converting CollectionObjectDefs.");
                SpecifyDBConverter.log.info((Object)"Converting CollectionObjectDefs.");
                convertDiscipline = doAll;
                if (!convertDiscipline) break block130;
                if (!this.conversion.convertCollectionObjectTypes(specifyUser.getSpecifyUserId(), userAgent)) {
                    return;
                }
                ** GOTO lbl293
            }
            try {
                idMapperMgr.addTableMapper("CatalogSeriesDefinition", "CatalogSeriesDefinitionID");
                idMapperMgr.addTableMapper("CollectionObjectType", "CollectionObjectTypeID");
lbl293:
                // 2 sources

                SpecifyDBConverter.frame.incOverall();
                SpecifyDBConverter.frame.setDesc("Converting Agents.");
                SpecifyDBConverter.log.info((Object)"Converting Agents.");
                agentConverter = new AgentConverter(this.conversion, idMapperMgr, startfromScratch);
                copyAgentAddressTables = doAll;
                if (copyAgentAddressTables) {
                    SpecifyDBConverter.log.info((Object)"Calling - convertAgents");
                    agentConverter.convertAgents(SpecifyDBConverter.doFixCollectors);
                } else {
                    idMapperMgr.addTableMapper("agent", "AgentID");
                    idMapperMgr.addTableMapper("agentaddress", "AgentAddressID");
                }
                SpecifyDBConverter.frame.incOverall();
                SpecifyDBConverter.frame.setDesc("Mapping Agent Tables.");
                SpecifyDBConverter.log.info((Object)"MappingAgent Tables.");
                if (mapTables) {
                    BasicSQLUtils.setFieldsToIgnoreWhenMappingIDs(new String[]{"MethodID", "RoleID", "CollectionID", "ConfidenceID", "TypeStatusNameID", "ObservationMethodID", "StatusID", "TypeID", "ShipmentMethodID", "RankID", "DirectParentRankID", "RequiredParentRankID", "MediumID"});
                    this.conversion.mapAgentRelatedIds();
                    BasicSQLUtils.setFieldsToIgnoreWhenMappingIDs(null);
                }
                SpecifyDBConverter.frame.incOverall();
                gtpTblWriter = this.convLogger.getWriter("GTP.html", "Geologic Time Period");
                stratToGTP = doCUPaleo != false || doKUINVP != false || ndgs != false ? new StratToGTP(oldDBConn, newDBConn, dbNameDest, gtpTblWriter, this.conversion) : null;
                SpecifyDBConverter.frame.setDesc("Converting Geography");
                SpecifyDBConverter.log.info((Object)"Converting Geography");
                doGeography = doAll;
                if (!dbNameDest.startsWith("accessions") && doGeography) {
                    treeDef = this.conversion.createStandardGeographyDefinitionAndItems(true);
                    this.conversion.convertGeography(treeDef, null, true);
                }
                SpecifyDBConverter.frame.incOverall();
                SpecifyDBConverter.frame.setDesc("Converting Geologic Time Period.");
                SpecifyDBConverter.log.info((Object)"Converting Geologic Time Period.");
                doGTP = doAll;
                if (doGTP) {
                    if (stratToGTP != null) {
                        if (doCUPaleo) {
                            stratToGTP.createGTPTreeDef();
                        } else if (doKUINVP) {
                            stratToGTP.createGTPTreeDefKUINVP();
                        } else if (ndgs) {
                            stratToGTP.createGTPTreeDefNDGS();
                        }
                    } else {
                        treeDef = this.conversion.convertGTPDefAndItems(this.conversion.isPaleo());
                        this.conversion.convertGTP(gtpTblWriter, treeDef, this.conversion.isPaleo());
                    }
                } else {
                    idMapperMgr.addTableMapper("geologictimeperiod", "GeologicTimePeriodID");
                    idMapperMgr.mapForeignKey("Stratigraphy", "GeologicTimePeriodID", "GeologicTimePeriod", "GeologicTimePeriodID");
                }
                SpecifyDBConverter.frame.incOverall();
                SpecifyDBConverter.frame.setDesc("Converting Taxonomy");
                SpecifyDBConverter.log.info((Object)"Converting Taxonomy");
                doTaxonomy = doAll;
                if (doTaxonomy) {
                    BasicSQLUtils.setTblWriter(taxonTblWriter);
                    taxonHelper.doConvert();
                    BasicSQLUtils.setTblWriter(null);
                }
                SpecifyDBConverter.frame.incOverall();
                this.conversion.convertHabitat();
                SpecifyDBConverter.frame.setDesc("Converting Determinations Records");
                SpecifyDBConverter.log.info((Object)"Converting Determinations Records");
                doDeterminations = doAll;
                if (doDeterminations) {
                    SpecifyDBConverter.frame.incOverall();
                    this.conversion.convertDeterminationRecords();
                } else {
                    SpecifyDBConverter.frame.incOverall();
                }
                SpecifyDBConverter.frame.incOverall();
                SpecifyDBConverter.frame.setDesc("Copying Tables");
                SpecifyDBConverter.log.info((Object)"Copying Tables");
                copyTables = doAll;
                if (copyTables) {
                    doBrief = false;
                    this.conversion.copyTables(doBrief);
                }
                SpecifyDBConverter.frame.incOverall();
                this.conversion.updateHabitatIds();
                SpecifyDBConverter.frame.setDesc("Converting Locality");
                SpecifyDBConverter.log.info((Object)"Converting Locality");
                doLocality = doAll;
                if (!dbNameDest.startsWith("accessions") && (doGeography || doLocality)) {
                    this.conversion.convertLocality();
                    SpecifyDBConverter.frame.incOverall();
                } else {
                    SpecifyDBConverter.frame.incOverall();
                    SpecifyDBConverter.frame.incOverall();
                }
                SpecifyDBConverter.frame.setDesc("Converting DeaccessionCollectionObject");
                SpecifyDBConverter.log.info((Object)"Converting DeaccessionCollectionObject");
                doDeaccessionCollectionObject = doAll;
                if (doDeaccessionCollectionObject) {
                    this.conversion.convertDeaccessionCollectionObject();
                }
                SpecifyDBConverter.frame.incOverall();
                SpecifyDBConverter.frame.setDesc("Converting Preparations");
                SpecifyDBConverter.log.info((Object)"Converting Preparations");
                doCollectionObjects = doAll;
                if (doCollectionObjects) {
                    session = HibernateUtil.getCurrentSession();
                    try {
                        collToPrepTypeHash = new Hashtable<Integer, Map<String, PrepType>>();
                        q = session.createQuery("FROM Collection");
                        for (E dataObj : q.list()) {
                            collection = (Collection)dataObj;
                            prepTypeMap = this.conversion.createPreparationTypesFromUSys(collection);
                            miscPT = prepTypeMap.get("misc");
                            if (miscPT != null) {
                                prepTypeMap.put("n/a", miscPT);
                            } else {
                                miscPT = prepTypeMap.get("Misc");
                                if (miscPT != null) {
                                    prepTypeMap.put("n/a", miscPT);
                                } else {
                                    SpecifyDBConverter.log.error((Object)"******************************* Couldn't find 'Misc' PrepType!");
                                }
                            }
                            collToPrepTypeHash.put(collection.getCollectionId(), prepTypeMap);
                        }
                        this.conversion.convertPreparationRecords(collToPrepTypeHash);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                    SpecifyDBConverter.frame.setDesc("Converting Loan Records");
                    SpecifyDBConverter.log.info((Object)"Converting Loan Records");
                    doLoanPreparations = doAll;
                    if (doLoanPreparations) {
                        this.conversion.convertLoanRecords(false);
                        this.conversion.convertLoanAgentRecords(false);
                        this.conversion.convertLoanPreparations();
                        SpecifyDBConverter.frame.setDesc("Converting Gift Records");
                        SpecifyDBConverter.log.info((Object)"Converting Gift Records");
                        this.conversion.convertLoanAgentRecords(true);
                        this.conversion.convertLoanRecords(true);
                        this.conversion.convertGiftPreparations();
                        SpecifyDBConverter.frame.incOverall();
                    } else {
                        SpecifyDBConverter.frame.incOverall();
                    }
                    SpecifyDBConverter.frame.setDesc("Converting CollectionObjects Records");
                    SpecifyDBConverter.log.info((Object)"Converting CollectionObjects Records");
                    this.conversion.convertCollectionObjects(true, false);
                    SpecifyDBConverter.frame.incOverall();
                } else {
                    SpecifyDBConverter.frame.incOverall();
                    SpecifyDBConverter.frame.incOverall();
                }
                this.conversion.updateBioLogicalObjAttrIds();
                this.conversion.updatePrepAttrIds();
                this.conversion.convertHostTaxonId();
                if (DataBuilder.getSession() != null) {
                    DataBuilder.getSession().close();
                    DataBuilder.setSession(null);
                }
                DataBuilder.setSession(HibernateUtil.getNewSession());
                if (stratToGTP != null) {
                    if (doCUPaleo) {
                        stratToGTP.convertStratToGTP();
                    } else if (doKUINVP) {
                        stratToGTP.convertStratToGTPKUIVP();
                    } else if (ndgs) {
                        stratToGTP.convertStratToGTPNDGS();
                    }
                }
                SpecifyDBConverter.frame.setDesc("Converting Stratigraphy");
                SpecifyDBConverter.log.info((Object)"Converting Stratigraphy");
                doStrat = true;
                if (doStrat) {
                    tblWriter = this.convLogger.getWriter("FullStrat.html", "Straigraphy Conversion");
                    if (stratToGTP != null) {
                        if (doCUPaleo || ndgs) {
                            stratToGTP.convertStrat(tblWriter, this.conversion.isPaleo(), doCUPaleo);
                        } else if (doKUINVP) {
                            stratToGTP.convertStratKUINVP(tblWriter, this.conversion.isPaleo());
                        }
                    } else {
                        this.conversion.convertStrat(tblWriter, this.conversion.isPaleo());
                    }
                }
                SpecifyDBConverter.frame.incOverall();
                if (DataBuilder.getSession() != null) {
                    DataBuilder.getSession().close();
                    DataBuilder.setSession(null);
                }
                status = false;
                institution = null;
                division = null;
                collection = null;
                dscp = null;
                localSession = HibernateUtil.getNewSession();
                cachedCurrentSession = DataBuilder.getSession();
                DataBuilder.setSession(null);
                try {
                    if (this.conversion.getCurDisciplineID() == null) {
                        list = localSession.createQuery("FROM Discipline").list();
                        dscp = (Discipline)list.get(0);
                    } else {
                        SpecifyDBConverter.log.debug((Object)("Loading Discipline with Id[" + this.conversion.getCurDisciplineID() + "]"));
                        list = localSession.createQuery("FROM Discipline WHERE id = " + this.conversion.getCurDisciplineID()).list();
                        dscp = (Discipline)list.get(0);
                    }
                    AppContextMgr.getInstance().setClassObject(Discipline.class, dscp);
                    if (dscp.getCollections().size() == 1) {
                        collection = dscp.getCollections().iterator().next();
                    }
                    if (collection == null) {
                        if (this.conversion.getCurCollectionID() == null || this.conversion.getCurCollectionID() == 0) {
                            list = localSession.createQuery("FROM Collection").list();
                            collection = (Collection)list.get(0);
                        } else {
                            hsql = "FROM Collection WHERE id = " + this.conversion.getCurCollectionID();
                            SpecifyDBConverter.log.info((Object)hsql);
                            list = localSession.createQuery(hsql).list();
                            if (list == null || list.size() == 0) {
                                UIRegistry.showError("Couldn't find the Collection record [" + hsql + "]");
                            }
                            collection = (Collection)list.get(0);
                        }
                    }
                    division = dscp.getDivision();
                    localSession.lock((Object)division, LockMode.NONE);
                    institution = division.getInstitution();
                    localSession.lock((Object)institution, LockMode.NONE);
                    institution.getDivisions().size();
                    AppContextMgr.getInstance().setClassObject(Collection.class, collection);
                    AppContextMgr.getInstance().setClassObject(Division.class, division);
                    AppContextMgr.getInstance().setClassObject(Institution.class, institution);
                    if (SpecifyDBConverter.doFixCollectors) {
                        agentConverter.fixupForCollectors(division, dscp);
                    }
                    DataBuilder.setSession(localSession);
                    try {
                        for (CollectionInfo collInfo : CollectionInfo.getCollectionInfoList(oldDBConn, true)) {
                            if (collInfo.getCollectionId() == null) {
                                SpecifyDBConverter.log.error((Object)("CollectionID: was null for " + collInfo.getCatSeriesName()));
                                continue;
                            }
                            list = localSession.createQuery("FROM Collection WHERE id = " + collInfo.getCollectionId()).list();
                            tmpCollList = list;
                            tmpCollection = (Collection)tmpCollList.get(0);
                            groupMap = DataBuilder.createStandardGroups(localSession, tmpCollection);
                            specifyUser.addUserToSpPrincipalGroup(groupMap.get(SpecifyUserTypes.UserType.Manager.toString()));
                            trans = localSession.beginTransaction();
                            for (SpPrincipal prin : groupMap.values()) {
                                localSession.saveOrUpdate((Object)prin);
                            }
                            localSession.saveOrUpdate((Object)specifyUser);
                            trans.commit();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    status = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                localSession.close();
                localSession = HibernateUtil.getNewSession();
                DataBuilder.setSession(localSession);
                specifyUser = (SpecifyUser)localSession.merge((Object)specifyUser);
                division = (Division)localSession.createQuery("FROM Division WHERE id = " + division.getId()).list().iterator().next();
                institution = (Institution)localSession.createQuery("FROM Institution WHERE id = " + institution.getId()).list().iterator().next();
                collection = (Collection)localSession.createQuery("FROM Collection WHERE id = " + collection.getId()).list().iterator().next();
                AppContextMgr.getInstance().setClassObject(Collection.class, collection);
                AppContextMgr.getInstance().setClassObject(Division.class, division);
                AppContextMgr.getInstance().setClassObject(Institution.class, institution);
                dscp = (Discipline)localSession.createQuery("FROM Discipline WHERE id = " + dscp.getId()).list().iterator().next();
                AppContextMgr.getInstance().setClassObject(Discipline.class, dscp);
                localSession.flush();
                DataBuilder.setSession(cachedCurrentSession);
                SpecifyDBConverter.frame.setDesc("Converting USYS Tables.");
                SpecifyDBConverter.log.info((Object)"Converting USYS Tables.");
                copyUSYSTables = doAll;
                if (copyUSYSTables) {
                    if (status) {
                        BasicSQLUtils.deleteAllRecordsFromTable("picklist", BasicSQLUtils.myDestinationServerType);
                        BasicSQLUtils.deleteAllRecordsFromTable("picklistitem", BasicSQLUtils.myDestinationServerType);
                        for (Collection collectionObj : localSession.createQuery("FROM Collection").list()) {
                            SpecifyDBConverter.log.debug((Object)("Loading PickLists for Collection [" + collectionObj.getCollectionName() + "] id[" + collectionObj.getId() + "]"));
                            this.conversion.convertUSYSTables(localSession, collectionObj);
                            SpecifyDBConverter.frame.setDesc("Creating PickLists from XML.");
                            BuildSampleDatabase.createPickLists(localSession, null, true, collectionObj);
                            BuildSampleDatabase.createPickLists(localSession, collection.getDiscipline(), true, collectionObj);
                        }
                    } else {
                        SpecifyDBConverter.log.error((Object)"STATUS was FALSE for PickList creation!");
                    }
                    SpecifyDBConverter.frame.incOverall();
                } else {
                    SpecifyDBConverter.frame.incOverall();
                }
                if (localSession != null) {
                    localSession.close();
                }
                SpecifyDBConverter.frame.incOverall();
                this.doSetDisciplineIntoCEs(oldDBConn, newDBConn);
                SpecifyDBConverter.frame.setDesc("Fixing Preferred Taxon");
                sql = "UPDATE determination SET PreferredTaxonID = CASE WHEN (SELECT AcceptedID FROM taxon WHERE taxon.TaxonID = determination.TaxonID) IS NULL THEN determination.TaxonID ELSE (SELECT AcceptedID FROM taxon WHERE taxon.TaxonID = determination.TaxonID) END";
                System.out.println(sql);
                BasicSQLUtils.setSkipTrackExceptions(true);
                BasicSQLUtils.update(sql);
                SpecifyDBConverter.frame.incOverall();
                shipmentConv = new ShipmentConverter(oldDBConn, newDBConn);
                shipmentConv.fixup();
                SpecifyDBConverter.frame.setDesc("Localizing the Schema");
                this.conversion.doLocalizeSchema();
                SpecifyDBConverter.frame.incOverall();
                SpecifyDBConverter.frame.incOverall();
                agentConverter.fixAddressOfRecord();
                SpecifyDBConverter.frame.incOverall();
                if (dbNameSource.startsWith("gcf")) {
                    giFixer = new GulfInvertsFixer(oldDBConn, newDBConn, dbNameSource, null);
                    giFixer.convert(this.conversion.getCollectionMemberId());
                }
                SpecifyDBConverter.frame.setDesc("Fixing Scope....");
                tblWriter = this.convLogger.getWriter("ScopeUpdater.html", "Updating Scope Summary");
                convScopeFixer = new ConvScopeFixer(oldDBConn, newDBConn, dbNameDest, tblWriter);
                convScopeFixer.doFixTables();
                convScopeFixer.checkTables();
                FixDBAfterLogin.fixUserPermissions(true);
                this.waitTime = 0L;
                SpecifyDBConverter.frame.setDesc("Duplicating CollectingEvents Performing Maintenance...");
                ceFile = new File(String.valueOf(dbNameDest) + ".ce_all");
                if (doingOneToOneForColObjToCE) {
                    dce = new DuplicateCollectingEvents(oldDBConn, newDBConn, SpecifyDBConverter.frame, this.conversion.getCurAgentCreatorID(), dscp.getId());
                    dce.performMaint(true);
                    FileUtils.writeStringToFile((File)ceFile, (String)dbNameDest);
                } else if (ceFile.exists()) {
                    ceFile.delete();
                }
                convertTimeInSeconds = (int)((double)(this.endTime - this.startTime - this.waitTime) / 1000.0);
                colObjCnt = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM collectionobject");
                sender = new ConvertStatSender();
                sender.sendConvertInfo(dbNameDest, colObjCnt, convertTimeInSeconds);
                SpecifyDBConverter.frame.incOverall();
                this.fixHibernateHiLo(newDBConn);
                try {
                    SpecifyDBConverter.frame.setDesc("Discipline Duplicator...");
                    d = new DisciplineDuplicator(this.conversion.getOldDBConn(), this.conversion.getNewDBConn(), tblWriter, SpecifyDBConverter.frame, this.conversion);
                    d.doShowFieldsForDiscipline();
                    SpecifyDBConverter.frame.setDesc("Duplicating Collecting Events...");
                    d.duplicateCollectingEvents();
                    SpecifyDBConverter.frame.setDesc("Duplicating Localities...");
                    d.duplicateLocalities();
                    SpecifyDBConverter.frame.setDesc("Duplicating Geography...");
                    d.duplicateGeography();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                SpecifyDBConverter.frame.setDesc("Running Table Checker to report on fields with data.");
                tDSTblWriter = this.convLogger.getWriter("TableDataSummary.html", "Table Data Summary", true);
                tblDataChecker = new TableDataChecker(oldDBConn);
                tblDataChecker.createHTMLReport(tDSTblWriter);
                SpecifyDBConverter.frame.setDesc("Updating Version...");
                this.updateVersionInfo(newConn);
                if (dbNameDest.startsWith("kui_fish_") || dbNameDest.startsWith("kui_tissue")) {
                    ConvertMiscData.convertKUFishCruiseData(oldDBConn, newDBConn, this.conversion.getCurDisciplineID());
                    ConvertMiscData.convertKUFishObsData(oldDBConn, newDBConn);
                } else if (dbNameDest.startsWith("ku_invert_")) {
                    ConvertMiscData.convertKUInvertsObsData(oldDBConn, newDBConn);
                }
                sql = "SELECT Count(ce.CollectingEventID) FROM collectingevent AS ce Inner Join collectingeventattribute AS cea ON ce.CollectingEventAttributeID = cea.CollectingEventAttributeID WHERE ce.DisciplineID <> cea.DisciplineID";
                ceCnt = BasicSQLUtils.getCountAsInt(sql);
                if (ceCnt > 0) {
                    UIRegistry.showErrorNonModal(String.format("There are %d CollectingEvents and CE Attributes where their DisciplineID do not match.", new Object[]{ceCnt}));
                }
                if ((dspCnt = BasicSQLUtils.getCountAsInt(sql = "SELECT Count(ce.CollectingEventID) FROM collectingevent AS ce Inner Join collectionobject AS co ON ce.CollectingEventID = co.CollectingEventID Inner Join collection ON co.CollectionID = collection.UserGroupScopeId WHERE ce.DisciplineID <>  collection.DisciplineID")) > 0) {
                    UIRegistry.showErrorNonModal(String.format("There are %d mismatches between the Collection Object Discipline and the Discipline of the Colleciton it is in", new Object[]{dspCnt}));
                }
                if (doingOneToOneForColObjToCE && (ceCnt = BasicSQLUtils.getCountAsInt(sql = "SELECT COUNT(*) FROM (SELECT ce.CollectingEventID, Count(ce.CollectingEventID) AS cnt FROM collectingevent AS ce Inner Join collectionobject AS co ON ce.CollectingEventID = co.CollectingEventID GROUP BY ce.CollectingEventID) T1 WHERE cnt > 1")) > 0) {
                    sql = "SELECT id,cnt FROM (SELECT ce.CollectingEventID as id, Count(ce.CollectingEventID) AS cnt FROM collectingevent AS ce Inner Join collectionobject AS co ON ce.CollectingEventID = co.CollectingEventID GROUP BY ce.CollectingEventID) T1 WHERE cnt > 1";
                    for (Object[] row : BasicSQLUtils.query(sql)) {
                        SpecifyDBConverter.log.debug((Object)String.format("CE[%s] has %s Collection Objects.", new Object[]{row[0].toString(), row[1].toString()}));
                    }
                    UIRegistry.showErrorNonModal(String.format("There are %d CollectingEvents that have more than one Collection Object and they are suppose to be a One-To-One", new Object[]{ceCnt}));
                }
                v1 = doCheckLastEditedByNamesHashSet2 = doCheckLastEditedByNamesHashSet == false;
                if (doCheckLastEditedByNamesHashSet2) {
                    this.conversion.checkCreatedModifiedByAgents();
                }
                SpecifyDBConverter.log.info((Object)("Done - " + dbNameDest + " " + convertTimeInSeconds));
                SpecifyDBConverter.frame.setDesc("Done - " + dbNameDest + " " + convertTimeInSeconds);
                System.setProperty("edu.ku.brc.dbsupport.DataProvider", "edu.ku.brc.specify.dbsupport.HibernateDataProvider");
                this.createTableSummaryPage();
                this.conversion.cleanUp();
lbl684:
                // 2 sources

                if (idMapperMgr != null && GenericDBConversion.shouldDeleteMapTables()) {
                    idMapperMgr.cleanup();
                }
                SpecifyDBConverter.frame.setTitle("Done - " + dbNameDest);
                SpecifyDBConverter.frame.incOverall();
                SpecifyDBConverter.frame.processDone();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (idMapperMgr != null && GenericDBConversion.shouldDeleteMapTables()) {
                    idMapperMgr.cleanup();
                }
            }
        }
        finally {
            if (DataBuilder.getSession() != null) {
                DataBuilder.getSession().close();
            }
        }
    }

    public void doSetDisciplineIntoCEs(Connection oldDBConn, Connection newDBConn) {
        IdTableMapper ceMapper = IdMapperMgr.getInstance().addTableMapper("collectingevent", "CollectingEventID", false);
        HashMap<Integer, Integer> catSeriesToDisciplineHash = new HashMap<Integer, Integer>();
        for (CollectionInfo ci : CollectionInfo.getCollectionInfoList()) {
            catSeriesToDisciplineHash.put(ci.getCatSeriesId(), ci.getDisciplineId());
        }
        String sql = "SELECT csd.CatalogSeriesID, ce.CollectingEventID FROM catalogseriesdefinition AS csd Inner Join collectingevent AS ce ON csd.ObjectTypeID = ce.BiologicalObjectTypeCollectedID";
        PreparedStatement pStmt = null;
        Statement stmt = null;
        try {
            try {
                pStmt = newDBConn.prepareStatement("UPDATE collectingevent SET DisciplineID=? WHERE CollectingEventID=?");
                int totalCnt = BasicSQLUtils.getNumRecords(oldDBConn, "collectingevent");
                stmt = oldDBConn.createStatement(1004, 1007);
                stmt.setFetchSize(Integer.MIN_VALUE);
                ResultSet rs = stmt.executeQuery(sql);
                if (frame != null) {
                    frame.setProcess(0, totalCnt);
                    frame.setDesc("Setting Discipline Ids in CollectingEvents");
                }
                int count = 0;
                while (rs.next()) {
                    int catSerId = rs.getInt(1);
                    int id = rs.getInt(2);
                    Integer dispId = (Integer)catSeriesToDisciplineHash.get(catSerId);
                    if (dispId != null) {
                        Integer newId = ceMapper.get(id);
                        if (newId != null) {
                            pStmt.setInt(1, dispId);
                            pStmt.setInt(2, newId);
                            pStmt.executeUpdate();
                        } else {
                            System.err.println(String.format("Unable to map oldId %d", id));
                        }
                    } else {
                        System.err.println(String.format("Unable to map Cat Series %d to a discipline", catSerId));
                    }
                    if (++count % 1000 != 0) continue;
                    if (frame != null) {
                        frame.setProcess(count);
                        continue;
                    }
                    log.info((Object)String.format("CE Records: %d / %d", count, totalCnt));
                }
                rs.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void doSetDisciplineIntoLocalities(Connection oldDBConn, Connection newDBConn) {
        TableWriter tblWriter = this.convLogger.getWriter("LocalityDisciplines.html", "Setting Discipline into Localities");
        BasicSQLUtils.setTblWriter(tblWriter);
        IdHashMapper.setTblWriter(tblWriter);
        IdMapperMgr.getInstance().setDBs(oldDBConn, newDBConn);
        IdTableMapper ceMapper = IdMapperMgr.getInstance().addTableMapper("locality", "LocalityID", false);
        HashMap<Integer, Integer> catSeriesToDisciplineHash = new HashMap<Integer, Integer>();
        for (CollectionInfo ci : CollectionInfo.getCollectionInfoList()) {
            catSeriesToDisciplineHash.put(ci.getCatSeriesId(), ci.getDisciplineId());
        }
        catSeriesToDisciplineHash.put(0, 3);
        catSeriesToDisciplineHash.put(-568842536, 7);
        String sql = " SELECT l.LocalityName, l.LocalityID FROM locality AS l Left Join collectingevent AS ce ON l.LocalityID = ce.LocalityID WHERE ce.CollectingEventID IS NULL";
        Vector<Object[]> rows = BasicSQLUtils.query(oldDBConn, sql);
        tblWriter.println(String.format("Unused Localities in the Sp5 database: %d<br>", rows.size()));
        if (rows.size() > 0) {
            tblWriter.startTable();
            tblWriter.logHdr("Id", "Locality Name");
            for (Object[] row : rows) {
                tblWriter.logObjRow(row);
            }
            tblWriter.endTable();
        }
        HashSet<Integer> sharedLocDifObjTypeSet = new HashSet<Integer>();
        int numSharedLocaltiesDifObjTypes = 0;
        sql = " SELECT * FROM (SELECT l.LocalityID, COUNT(l.LocalityID) cnt, l.LocalityName FROM locality AS l Left Join collectingevent AS ce ON l.LocalityID = ce.LocalityID WHERE ce.CollectingEventID IS NOT NULL GROUP BY l.LocalityID) T1 WHERE cnt > 1";
        rows = BasicSQLUtils.query(oldDBConn, sql);
        tblWriter.println(String.format("Localities being Shared: %d<br>", rows.size()));
        tblWriter.println("Shared Localities with different ObjectTypes<br>");
        if (rows.size() > 0) {
            tblWriter.startTable();
            tblWriter.logHdr("Id", "Count", "Locality Name");
            for (Object[] row : rows) {
                Integer localityId = (Integer)row[0];
                sql = String.format("SELECT COUNT(*) FROM (SELECT ce.BiologicalObjectTypeCollectedID, COUNT(ce.BiologicalObjectTypeCollectedID) FROM locality AS l Left Join collectingevent AS ce ON l.LocalityID = ce.LocalityID WHERE l.LocalityID = %d GROUP BY ce.BiologicalObjectTypeCollectedID) T1", localityId);
                int count = BasicSQLUtils.getCountAsInt(oldDBConn, sql);
                if (count <= 1) continue;
                tblWriter.logObjRow(row);
                ++numSharedLocaltiesDifObjTypes;
                sharedLocDifObjTypeSet.add(localityId);
            }
            tblWriter.endTable();
        }
        tblWriter.println(String.format("Number of Shared Localities with different ObjectTypes: %d<br>", numSharedLocaltiesDifObjTypes));
        sql = "SELECT csd.CatalogSeriesID, l.LocalityID FROM locality AS l Left Join collectingevent AS ce ON l.LocalityID = ce.LocalityID Inner Join catalogseriesdefinition AS csd ON ce.BiologicalObjectTypeCollectedID = csd.ObjectTypeID WHERE ce.CollectingEventID IS NOT NULL GROUP BY l.LocalityID";
        PreparedStatement pStmt = null;
        Statement stmt = null;
        try {
            try {
                pStmt = newDBConn.prepareStatement("UPDATE locality SET DisciplineID=? WHERE LocalityID=?");
                int totalCnt = BasicSQLUtils.getNumRecords(oldDBConn, "locality");
                stmt = oldDBConn.createStatement(1004, 1007);
                stmt.setFetchSize(Integer.MIN_VALUE);
                ResultSet rs = stmt.executeQuery(sql);
                if (frame != null) {
                    frame.setProcess(0, totalCnt);
                    frame.setDesc("Setting Discipline Ids in Locality");
                }
                int count = 0;
                while (rs.next()) {
                    int catSerId = rs.getInt(1);
                    int id = rs.getInt(2);
                    if (sharedLocDifObjTypeSet.contains(id)) continue;
                    Integer dispId = (Integer)catSeriesToDisciplineHash.get(catSerId);
                    if (dispId != null) {
                        Integer newId = ceMapper.get(id);
                        if (newId != null) {
                            pStmt.setInt(1, dispId);
                            pStmt.setInt(2, newId);
                            pStmt.executeUpdate();
                        } else {
                            System.err.println(String.format("Unable to map oldId %d", id));
                        }
                    } else {
                        System.err.println(String.format("Unable to map Cat Series %d to a discipline", catSerId));
                    }
                    if (++count % 1000 != 0) continue;
                    if (frame != null) {
                        frame.setProcess(count);
                        continue;
                    }
                    log.info((Object)String.format("CE Records: %d / %d", count, totalCnt));
                }
                rs.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void fixLoanPreps(Connection oldDBConn, Connection newDBConn) {
        int noMatch;
        int notFndCnt;
        int skippedCnt;
        int totalCnt;
        int fixCnt;
        block33: {
            System.out.println("------------------------ Loans ----------------------------");
            fixCnt = 0;
            totalCnt = 0;
            skippedCnt = 0;
            notFndCnt = 0;
            noMatch = 0;
            IdMapperMgr.getInstance().setDBs(oldDBConn, newDBConn);
            IdTableMapper loanPrepsMapper = IdMapperMgr.getInstance().addTableMapper("loanphysicalobject", "LoanPhysicalObjectID", false);
            IdTableMapper loansMapper = IdMapperMgr.getInstance().addTableMapper("loan", "LoanID", false);
            IdTableMapper prepMapper = IdMapperMgr.getInstance().addTableMapper("collectionobject", "CollectionObjectID", false);
            Statement stmt = null;
            PreparedStatement newStmt = null;
            PreparedStatement pStmt = null;
            try {
                try {
                    pStmt = newDBConn.prepareStatement("UPDATE loanpreparation SET Quantity=?, QuantityResolved=?, QuantityReturned=?, IsResolved=?, TimestampModified=?, TimestampCreated=?, LoanID=?, DescriptionOfMaterial=?, OutComments=?, InComments=?, PreparationID=?, Version=? WHERE LoanPreparationID = ?");
                    newStmt = newDBConn.prepareStatement("SELECT LoanPreparationID, TimestampModified, Version FROM loanpreparation WHERE LoanPreparationID = ?");
                    String sql = "SELECT lp.LoanPhysicalObjectID, lp.PhysicalObjectID, lp.LoanID, lp.Quantity, lp.DescriptionOfMaterial, lp.OutComments, lp.InComments, lp.QuantityResolved, lp.QuantityReturned, lp.TimestampCreated, lp.TimestampModified, lp.LastEditedBy, l.Closed FROM loanphysicalobject lp INNER JOIN loan l ON l.LoanID = lp.LoanID WHERE l.Category = 0";
                    stmt = oldDBConn.createStatement();
                    ResultSet rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        int id = rs.getInt(1);
                        Timestamp oldCreatedTS = rs.getTimestamp(10);
                        Integer newID = loanPrepsMapper.get(id);
                        if (newID != null) {
                            newStmt.setInt(1, newID);
                            ResultSet rs2 = newStmt.executeQuery();
                            if (rs2.next()) {
                                Timestamp oldModifiedTS = rs.getTimestamp(11);
                                if (rs2.getInt(3) == 0) {
                                    Integer prepId = rs.getInt(2);
                                    Integer loanId = rs.getInt(3);
                                    Integer newLoanId = loansMapper.get(loanId);
                                    Integer qty = rs.getInt(4);
                                    String descOfMat = rs.getString(5);
                                    String outComments = rs.getString(6);
                                    String inComments = rs.getString(7);
                                    Integer qtyRes = rs.getInt(8);
                                    Integer qtyRet = rs.getInt(9);
                                    String lasteditedBy = rs.getString(12);
                                    Boolean isLoanClosed = rs.getBoolean(13);
                                    isLoanClosed = isLoanClosed == null ? false : isLoanClosed;
                                    pStmt.setInt(1, qty);
                                    pStmt.setInt(2, qtyRes);
                                    pStmt.setInt(3, qtyRet);
                                    boolean isResolved = isLoanClosed;
                                    if (!isLoanClosed.booleanValue() && qty != null) {
                                        if (qtyRes != null && qty.equals(qtyRes)) {
                                            isResolved = true;
                                        } else if (qtyRet != null && qty.equals(qtyRet)) {
                                            isResolved = true;
                                        }
                                    }
                                    pStmt.setBoolean(4, isResolved);
                                    pStmt.setTimestamp(5, oldModifiedTS);
                                    pStmt.setTimestamp(6, oldCreatedTS);
                                    pStmt.setInt(7, newLoanId);
                                    pStmt.setString(8, descOfMat);
                                    pStmt.setString(9, outComments);
                                    pStmt.setString(10, inComments);
                                    pStmt.setInt(11, prepId != null ? prepMapper.get(prepId) : null);
                                    pStmt.setInt(12, 1);
                                    pStmt.setInt(13, newID);
                                    if (pStmt.executeUpdate() != 1) {
                                        log.error((Object)String.format("*** Error updating OldID %d  newID %d", rs.getInt(1), newID));
                                    } else {
                                        ++fixCnt;
                                    }
                                } else {
                                    ++noMatch;
                                }
                            } else {
                                ++notFndCnt;
                            }
                            rs2.close();
                        } else {
                            ++skippedCnt;
                        }
                        ++totalCnt;
                    }
                    rs.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (newStmt != null) {
                            newStmt.close();
                        }
                        if (pStmt != null) {
                            pStmt.close();
                        }
                        break block33;
                    }
                    catch (Exception exception) {}
                    break block33;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (newStmt != null) {
                        newStmt.close();
                    }
                    if (pStmt != null) {
                        pStmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (newStmt != null) {
                    newStmt.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println(String.format("Total: %d  Fixed: %d  Skipped: %d  NotFnd: %d  noMatch: %d", totalCnt, fixCnt, skippedCnt, notFndCnt, noMatch));
    }

    protected void fixGiftPreps(Connection oldDBConn, Connection newDBConn) {
        int notFndCnt;
        int skippedCnt;
        int totalCnt;
        int fixCnt;
        block29: {
            System.out.println("------------------------ Gifts ----------------------------");
            fixCnt = 0;
            totalCnt = 0;
            skippedCnt = 0;
            notFndCnt = 0;
            IdMapperMgr.getInstance().setDBs(oldDBConn, newDBConn);
            IdTableMapper colObjMapper = IdMapperMgr.getInstance().addTableMapper("collectionobject", "CollectionObjectID", false);
            IdTableMapper giftMapper = new IdTableMapper("gift", "GiftID", false, false);
            Statement stmt = null;
            PreparedStatement newStmt = null;
            PreparedStatement pStmt = null;
            try {
                try {
                    pStmt = newDBConn.prepareStatement("UPDATE giftpreparation SET Quantity=?, TimestampModified=?, TimestampCreated=?, GiftID=?, DescriptionOfMaterial=?, OutComments=?, InComments=?, PreparationID=?, Version=? WHERE GiftPreparationID = ?");
                    newStmt = newDBConn.prepareStatement("SELECT GiftPreparationID FROM giftpreparation WHERE GiftID = ? AND PreparationID = ?");
                    String sql = "SELECT lp.LoanPhysicalObjectID, lp.PhysicalObjectID, lp.LoanID, lp.Quantity, lp.DescriptionOfMaterial, lp.OutComments, lp.InComments, lp.QuantityResolved, lp.QuantityReturned, lp.TimestampCreated, lp.TimestampModified, lp.LastEditedBy, l.Closed FROM loanphysicalobject lp INNER JOIN loan l ON l.LoanID = lp.LoanID WHERE l.Category = 1";
                    stmt = oldDBConn.createStatement();
                    ResultSet rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        int loanId = rs.getInt(5);
                        int oldPrepId = rs.getInt(6);
                        Integer newPrepId = colObjMapper.get(oldPrepId);
                        Integer giftID = giftMapper.get(loanId);
                        if (giftID != null) {
                            String s = String.format("SELECT COUNT(*) FROM giftpreparation WHERE GiftID = %d AND PreparationID = %d", giftID, newPrepId);
                            int cnt = BasicSQLUtils.getCountAsInt(s);
                            if (cnt == 1) {
                                newStmt.setInt(1, giftID);
                                newStmt.setInt(2, newPrepId);
                            } else {
                                log.error((Object)(String.valueOf(String.format("*** Error get unique GiftPrep GiftID = %d AND PrepId = %d  %s", giftID, newPrepId, s)) + "  " + rs.getTimestamp(2)));
                            }
                            ResultSet rs2 = newStmt.executeQuery();
                            if (rs2.next()) {
                                pStmt.setInt(1, rs.getInt(4));
                                pStmt.setTimestamp(2, rs.getTimestamp(2));
                                pStmt.setInt(3, rs2.getInt(1));
                                if (pStmt.executeUpdate() != 1) {
                                    log.error((Object)String.format("*** Error updating OldID %d  newID %d", rs.getInt(1), giftID));
                                } else {
                                    ++fixCnt;
                                }
                            } else {
                                ++notFndCnt;
                            }
                            rs2.close();
                        } else {
                            ++skippedCnt;
                        }
                        ++totalCnt;
                    }
                    rs.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (newStmt != null) {
                            newStmt.close();
                        }
                        if (pStmt != null) {
                            pStmt.close();
                        }
                        break block29;
                    }
                    catch (Exception exception) {}
                    break block29;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (newStmt != null) {
                        newStmt.close();
                    }
                    if (pStmt != null) {
                        pStmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (newStmt != null) {
                    newStmt.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println(String.format("Total: %d  Fixed: %d  Skipped: %d  NotFnd: %d", totalCnt, fixCnt, skippedCnt, notFndCnt));
    }

    public void fixupUserAgents(Connection newDBConn) {
        List<String> agentFieldNames = BasicSQLUtils.getFieldNamesFromSchema(newDBConn, "agent");
        String fieldNameStr = BasicSQLUtils.buildSelectFieldList(agentFieldNames, null);
        fieldNameStr = StringUtils.replace((String)fieldNameStr, (String)"AgentID, ", (String)"");
        String dupSQL = String.format("INSERT INTO agent (%s) SELECT (%s) WHERE AgentID = ", fieldNameStr, fieldNameStr);
        String sql = "SELECT DivisionID FROM division";
        Vector<Integer> divs = BasicSQLUtils.queryForInts(newDBConn, sql);
        sql = "SELECT AgentID, SpecifyUserID, DivisionID FROM agent WHERE SpecifyUserID IS NOT NULL";
        Vector<Object[]> existingUserAgent = BasicSQLUtils.query(newDBConn, sql);
        if (existingUserAgent.size() == 1) {
            Object[] existingRow = existingUserAgent.get(0);
            Integer refAgentId = (Integer)existingRow[0];
            Integer refSpUserId = (Integer)existingRow[1];
            Integer refDivId = (Integer)existingRow[2];
            for (Integer divId : divs) {
                Vector<Integer> agents;
                if (!divId.equals(refDivId) || (agents = BasicSQLUtils.queryForInts(newDBConn, sql = String.format("SELECT AgentID FROM agent WHERE SpecifyUserID = %d AND DivisionID = %d", refSpUserId, divId))) != null && agents.size() != 0) continue;
                String updateSQL = String.valueOf(dupSQL) + refAgentId;
                System.out.println(updateSQL);
                int rv = BasicSQLUtils.update(newDBConn, dupSQL);
                System.out.println("rv: " + rv);
                int newId = BasicSQLUtils.getHighestId(newDBConn, "AgentID", "agent");
                updateSQL = String.format("UPDATE agent SET DivisionID = %d WHERE AgentID = %d", divId, newId);
                System.out.println(updateSQL);
                rv = BasicSQLUtils.update(newDBConn, updateSQL);
                System.out.println("rv: " + rv);
            }
        } else {
            UIRegistry.displayErrorDlg("There is more than one SpecifyUser / Division and shouldn't be!");
        }
    }

    protected void checkDisciplines() {
        System.out.println("Checking Disciplines....");
        int count = 0;
        for (Object obj : BasicSQLUtils.querySingleCol("SELECT TaxonTreeDefID FROM discipline")) {
            if ((Integer)obj != 1) continue;
            ++count;
        }
        System.out.println("Disciplines Count: " + count);
        if (count == 3) {
            throw new RuntimeException("set back");
        }
    }

    private void fixHibernateHiLo(Connection connection) {
        Vector<Object> values = BasicSQLUtils.querySingleCol(connection, "SELECT next_hi FROM hibernate_unique_key");
        if (values.size() != 1) {
            throw new RuntimeException("The hibernate_unique_key must be created.");
        }
        int nextHi = (Integer)values.get(0);
        BasicSQLUtils.update("UPDATE hibernate_unique_key SET next_hi=" + (nextHi + 1));
    }

    private void updateVersionInfo(Connection newDBConn) throws SQLException {
        PreparedStatement pStmt;
        String appVerStr = null;
        String schemaVersion = null;
        Integer spverId = null;
        Integer recVerNum = 1;
        try {
            System.setProperty("edu.ku.brc.af.core.db.SchmeaUpdateService", "edu.ku.brc.specify.dbsupport.SpecifySchemaUpdateService");
            schemaVersion = SchemaUpdateService.getInstance().getDBSchemaVersionFromXML();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Vector<Object[]> rows = BasicSQLUtils.query(newDBConn, "SELECT AppVersion, SchemaVersion, SpVersionID, Version FROM spversion");
        if (rows.size() == 1) {
            Object[] row = rows.get(0);
            appVerStr = row[0].toString();
            schemaVersion = row[1].toString();
            spverId = (Integer)row[2];
            recVerNum = (Integer)row[3];
        }
        if (appVerStr != null) {
            appVerStr = UIHelper.getInstall4JInstallString();
            if (appVerStr == null) {
                while (StringUtils.isEmpty((String)(appVerStr = JOptionPane.showInputDialog("Enter Specify App version:")))) {
                }
            }
            pStmt = newDBConn.prepareStatement("UPDATE spversion SET AppVersion=?, SchemaVersion=?, Version=? WHERE SpVersionID = ?");
            pStmt.setString(1, appVerStr);
            pStmt.setString(2, SchemaUpdateService.getInstance().getDBSchemaVersionFromXML());
            recVerNum = recVerNum + 1;
            pStmt.setInt(3, recVerNum);
            pStmt.setInt(4, spverId);
            if (pStmt.executeUpdate() != 1) {
                throw new RuntimeException("Problem updating SpVersion");
            }
        } else {
            appVerStr = UIHelper.getInstall4JInstallString();
            if (appVerStr == null) {
                while (StringUtils.isEmpty((String)(appVerStr = JOptionPane.showInputDialog("Enter Specify App version:")))) {
                }
            }
            pStmt = newDBConn.prepareStatement("INSERT INTO spversion (AppVersion, SchemaVersion, Version, TimestampCreated) VALUES(?,?,?,?)");
            pStmt.setString(1, appVerStr);
            pStmt.setString(2, schemaVersion);
            pStmt.setInt(3, 0);
            pStmt.setTimestamp(4, new Timestamp(Calendar.getInstance().getTime().getTime()));
            if (pStmt.executeUpdate() != 1) {
                throw new RuntimeException("Problem inserting SpVersion");
            }
        }
    }

    private boolean isUsingEmbeddedCEsInSp5() {
        String sql = String.format("SELECT ControlType FROM usysmetacontrollayout mcl INNER JOIN usysmetacontrol mc ON mc.ControlID = mcl.ControlID WHERE mc.FieldSetSubTypeID = (SELECT FieldSetSubTypeID FROM usysmetafieldsetsubtype sst where sst.FieldSetID = 19 AND sst.FieldValue = %d) AND mc.ObjectID = 10152 AND mcl.FullForm <> 0 ", this.conversion.getColObjTypeID());
        Integer controlType = BasicSQLUtils.getCount(this.conversion.getOldDBConn(), sql);
        return controlType != null && controlType != 5;
    }

    protected void createTableSummaryPage() {
        TableWriter tblWriter = this.convLogger.getWriter("TableSummary.html", "Table Summary");
        tblWriter.startTable();
        tblWriter.println("<tr><th>Table</th><th>Count</th></tr>");
        int total = 0;
        for (DBTableInfo ti : DBTableIdMgr.getInstance().getTables()) {
            Integer count = BasicSQLUtils.getCount("select count(*) from " + ti.getName());
            if (count != null && count > 0) {
                tblWriter.log(ti.getName(), count.toString());
            }
            total += count.intValue();
        }
        tblWriter.println("<tr><td>Total Records</td><td>" + total + "</td></tr>");
        tblWriter.endTable();
        tblWriter.println("<H3>Col Obj Counts By Discipline/Collection</H3>");
        String sql = " SELECT cct.CollectionObjectTypeName, cs.SeriesName, Count(cc.CollectionObjectCatalogID) FROM catalogseries AS cs Inner Join collectionobjectcatalog AS cc ON cs.CatalogSeriesID = cc.CatalogSeriesID Inner Join collectionobjecttype AS cct ON cc.CollectionObjectTypeID = cct.CollectionObjectTypeID Inner Join collectionobject AS co ON cc.CollectionObjectCatalogID = co.CollectionObjectID  WHERE co.DerivedFromID IS NULL GROUP BY cct.CollectionObjectTypeName, cs.SeriesName";
        this.showTable(tblWriter, "Specify 5", false, sql, "Discipline", "Collection", "Count");
        sql = "SELECT d.Name, c.CollectionName, Count(co.CollectionObjectID) AS `Count` FROM discipline AS d Inner Join collection AS c ON d.UserGroupScopeId = c.DisciplineID Inner Join collectionobject AS co ON co.CollectionID = c.UserGroupScopeId GROUP BY d.Name, c.CollectionName";
        tblWriter.println("<BR>");
        this.showTable(tblWriter, "Specify 6", true, sql, "Discipline", "Collection", "Count");
        tblWriter.println("<H3>Col Obj Counts By Collection</H3>");
        sql = " SELECT cs.SeriesName, Count(cc.CollectionObjectCatalogID) FROM catalogseries AS cs Inner Join collectionobjectcatalog AS cc ON cs.CatalogSeriesID = cc.CatalogSeriesID Inner Join collectionobject AS co ON cc.CollectionObjectCatalogID = co.CollectionObjectID  WHERE co.DerivedFromID IS NULL GROUP BY cs.SeriesName";
        this.showTable(tblWriter, "Specify 5", false, sql, "Collection", "Count");
        sql = " SELECT c.CollectionName, Count(co.CollectionObjectID) FROM collection AS c Inner Join collectionobject AS co ON c.UserGroupScopeId = co.CollectionID GROUP BY c.CollectionName";
        tblWriter.println("<BR>");
        this.showTable(tblWriter, "Specify 6", true, sql, "Collection", "Count");
        tblWriter.println("<H3>Locality Counts</H3>");
        sql = " SELECT Count(LocalityID) FROM locality";
        this.showTable(tblWriter, "Specify 5", false, sql, "Count");
        sql = " SELECT Count(LocalityID) FROM locality";
        tblWriter.println("<BR>");
        this.showTable(tblWriter, "Specify 6", true, sql, "Count");
        tblWriter.println("<H3>Locality Counts By Discipline</H3>");
        sql = " SELECT ct.CollectionObjectTypeName, Count(locid) FROM collectionobjecttype AS ct Inner Join (SELECT ce.CollectingEventID as ceid, ce.BiologicalObjectTypeCollectedID as botid, locality.LocalityID as locid FROM collectingevent ce Inner Join locality ON ce.LocalityID = locality.LocalityID GROUP BY locality.LocalityID) T1 ON ct.CollectionObjectTypeID = T1.botid GROUP BY ct.CollectionObjectTypeName";
        this.showTable(tblWriter, "Specify 5", false, sql, "Discipline", "Count");
        sql = " SELECT d.Name, Count(l.LocalityID) FROM discipline AS d Inner Join locality AS l ON d.UserGroupScopeId = l.DisciplineID GROUP BY d.Name";
        tblWriter.println("<BR>");
        this.showTable(tblWriter, "Specify 6", true, sql, "Discipline", "Count");
        tblWriter.startTable();
        tblWriter.logHdr(CollectionInfoModel.getHeaders());
        DefaultTableModel model = CollectionInfo.getCollectionInfoTableModel(true);
        Object[] row = new Object[model.getColumnCount()];
        int r = 0;
        while (r < model.getRowCount()) {
            int i = 0;
            while (i < model.getColumnCount()) {
                row[i] = model.getValueAt(r, i);
                ++i;
            }
            tblWriter.logObjRow(row);
            ++r;
        }
        tblWriter.endTable();
        tblWriter.close();
    }

    private void showTable(TableWriter tblWriter, String title, boolean isNewDB, String sql, String ... cols) {
        tblWriter.println(String.valueOf(title) + "<BR>");
        tblWriter.startTable();
        tblWriter.logHdr(cols);
        for (Object[] row : BasicSQLUtils.query(isNewDB ? this.conversion.getNewDBConn() : this.conversion.getOldDBConn(), sql)) {
            tblWriter.logObjRow(row);
        }
        tblWriter.endTable();
    }

    private List<Triple<String, String, String>> getSummaryQueries() {
        String[] desc = new String[]{};
        String[] oldQ = new String[]{};
        String[] newQ = new String[]{};
        ArrayList<Triple<String, String, String>> list = new ArrayList<Triple<String, String, String>>(oldQ.length);
        int i = 0;
        while (i < oldQ.length) {
            list.add(new Triple<String, String, String>(desc[i], oldQ[i], newQ[i]));
            ++i;
        }
        return list;
    }

    protected boolean isOldDBOK(Connection conn) {
        int cntDTLeftCO;
        int cntDTInnerCO;
        int cntACLeftCO;
        StringBuilder errMsgs = new StringBuilder();
        int cntACInnerCO = BasicSQLUtils.getCount(conn, "SELECT count(*) FROM accession INNER JOIN collectionobjectcatalog ON accession.AccessionID = collectionobjectcatalog.AccessionID WHERE CollectionObjectTypeID < 20");
        if (cntACInnerCO != (cntACLeftCO = BasicSQLUtils.getCount(conn, "SELECT count(*) FROM accession LEFT JOIN collectionobjectcatalog ON accession.AccessionID = collectionobjectcatalog.AccessionID WHERE CollectionObjectTypeID < 20").intValue())) {
            errMsgs.append("There is a mismatch between Accessions and its CollectionObject references.\n");
        }
        if ((cntDTInnerCO = BasicSQLUtils.getCount(conn, "SELECT count(*) FROM determination INNER JOIN collectionobject ON determination.BiologicalObjectID = collectionobject.CollectionObjectID WHERE CollectionObjectTypeID < 20").intValue()) != (cntDTLeftCO = BasicSQLUtils.getCount(conn, "SELECT count(*) FROM determination LEFT JOIN collectionobject ON determination.BiologicalObjectID = collectionobject.CollectionObjectID WHERE CollectionObjectTypeID < 20").intValue())) {
            errMsgs.append("There is a mismatch between Determinations and its CollectionObject references.\n");
        }
        if (errMsgs.length() > 0) {
            UIRegistry.showError(errMsgs.toString());
            return false;
        }
        return true;
    }

    public static void addStorageTreeFomrXML(boolean doAddTreeNodes) {
        block13: {
            BuildSampleDatabase bsd = new BuildSampleDatabase();
            Session tmpSession = HibernateUtil.getNewSession();
            bsd.setSession(tmpSession);
            Transaction trans = null;
            try {
                try {
                    List list = tmpSession.createQuery("FROM StorageTreeDef WHERE id = 1").list();
                    if (list != null) {
                        StorageTreeDef std = (StorageTreeDef)list.iterator().next();
                        trans = tmpSession.beginTransaction();
                        for (StorageTreeDefItem item : new Vector<StorageTreeDefItem>(std.getTreeDefItems())) {
                            for (Storage s : new Vector<Storage>(item.getTreeEntries())) {
                                item.getTreeEntries().remove(s);
                                for (Preparation p : s.getPreparations()) {
                                    p.setStorage(null);
                                    tmpSession.saveOrUpdate((Object)p);
                                }
                                s.getPreparations().clear();
                                tmpSession.delete((Object)s);
                            }
                        }
                        trans.commit();
                        tmpSession.flush();
                        trans = tmpSession.beginTransaction();
                        for (StorageTreeDefItem item : new Vector<StorageTreeDefItem>(std.getTreeDefItems())) {
                            std.getTreeDefItems().remove(item);
                            tmpSession.delete((Object)item);
                        }
                        trans.commit();
                        tmpSession.flush();
                        File domFile = new File("demo_files/storage_init.xml");
                        if (domFile.exists()) {
                            trans = tmpSession.beginTransaction();
                            Vector<Object> storages = new Vector<Object>();
                            bsd.createStorageTreeDefFromXML(storages, domFile, std, doAddTreeNodes);
                            trans.commit();
                        } else {
                            log.error((Object)("File[" + domFile.getAbsolutePath() + "] is not found."));
                        }
                    }
                }
                catch (Exception ex) {
                    if (trans != null) {
                        trans.rollback();
                    }
                    ex.printStackTrace();
                    tmpSession.close();
                    break block13;
                }
            }
            catch (Throwable throwable) {
                tmpSession.close();
                throw throwable;
            }
            tmpSession.close();
        }
        log.info((Object)"Done creating Storage treee.");
    }

    protected void testPaging() {
        boolean testPaging = false;
        if (testPaging) {
            ResultsPager pager = new ResultsPager(HibernateUtil.getCurrentSession().createQuery("from collectionobject in class CollectionObject"), 0, 10);
            int pageNo = 1;
            do {
                long start = System.currentTimeMillis();
                List<?> list = pager.getList();
                if (pageNo % 100 == 0) {
                    log.info((Object)("******************** Page " + pageNo + " " + (double)(System.currentTimeMillis() - start) / 1000.0));
                }
                ++pageNo;
                for (Object co : list) {
                    if (pageNo % 1000 != 0) continue;
                    log.info((Object)((CollectionObject)co).getCatalogNumber());
                }
                list.clear();
                System.gc();
            } while (pager.isNextPage());
        }
    }

    public boolean selectedDBsToConvert(boolean useITOnly) {
        JTextField itUserNameTF = UIHelper.createTextField("root", 15);
        JPasswordField itPasswordTF = UIHelper.createPasswordField("", 15);
        JTextField masterUserNameTF = UIHelper.createTextField("Master", 15);
        JPasswordField masterPasswordTF = UIHelper.createPasswordField("Master", 15);
        JTextField hostNameTF = UIHelper.createTextField("localhost", 15);
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,p,f:p:g", "p,2px,p,2px,p,4px," + (useITOnly ? "" : "p,2px,p,2px,") + "p,8px,p,4px"));
        int y = 1;
        pb.addSeparator("IT User", cc.xyw(1, y, 4));
        pb.add((Component)UIHelper.createLabel("Username:", 4), cc.xy(1, y += 2));
        pb.add((Component)itUserNameTF, cc.xy(3, y));
        pb.add((Component)UIHelper.createLabel("Password:", 4), cc.xy(1, y += 2));
        pb.add((Component)itPasswordTF, cc.xy(3, y));
        y += 2;
        if (!useITOnly) {
            pb.addSeparator("Master User", cc.xyw(1, y, 4));
            pb.add((Component)UIHelper.createLabel("Username:", 4), cc.xy(1, y += 2));
            pb.add((Component)masterUserNameTF, cc.xy(3, y));
            pb.add((Component)UIHelper.createLabel("Password:", 4), cc.xy(1, y += 2));
            pb.add((Component)masterPasswordTF, cc.xy(3, y));
            y += 2;
        }
        pb.add((Component)UIHelper.createLabel("Host Name:", 4), cc.xy(1, y));
        pb.add((Component)hostNameTF, cc.xy(3, y));
        y += 2;
        if (System.getProperty("user.name").equals("rods")) {
            itPasswordTF.setText("root");
        } else {
            itPasswordTF.requestFocus();
        }
        PanelBuilder panel = new PanelBuilder(new FormLayout("f:p:g,10px,f:p:g", "f:p:g"));
        panel.add((Component)new JLabel(IconManager.getIcon("SpecifyConv")), cc.xy(1, 1));
        panel.add((Component)pb.getPanel(), cc.xy(3, 1));
        panel.setDefaultDialogBorder();
        CustomDialog dlg = new CustomDialog(null, "Specify Converter", true, panel.getPanel());
        UIHelper.centerAndShow(dlg);
        dlg.dispose();
        if (dlg.isCancelled()) {
            return false;
        }
        this.hostName = hostNameTF.getText();
        this.itUsrPwd.first = itUserNameTF.getText();
        this.itUsrPwd.second = ((JTextComponent)itPasswordTF).getText();
        this.masterUsrPwd.first = masterUserNameTF.getText();
        this.masterUsrPwd.second = ((JTextComponent)masterPasswordTF).getText();
        return true;
    }

    public Pair<String, String> getItUsrPwd() {
        return this.itUsrPwd;
    }

    public String getHostName() {
        return this.hostName;
    }

    public CustomDBConverterDlg runCustomConverter() {
        return UIHelper.doSpecifyConvert();
    }

    class DBNamePair
    extends Pair<String, String> {
        public DBNamePair() {
        }

        public DBNamePair(String first, String second) {
            super(first, second);
        }

        @Override
        public String toString() {
            return String.valueOf((String)this.second) + "   (" + (String)this.first + ")";
        }
    }
}

