/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import java.sql.Connection;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class Sp5CollectionCleaner {
    protected Connection connection = null;
    protected int total = 0;

    protected void clean() {
        String dbName = "entosp_dbo";
        String itUsername = "root";
        String itPassword = "root";
        DBConnection colDBConn = null;
        Statement stmt = null;
        try {
            boolean bl;
            boolean doTaxon;
            String ids;
            DatabaseDriverInfo driverInfo = DatabaseDriverInfo.getDriver("MySQL");
            String connStr = driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, "localhost", dbName, itUsername, itPassword, driverInfo.getName());
            colDBConn = DBConnection.createInstance(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), dbName, connStr, itUsername, itPassword);
            this.connection = colDBConn.createConnection();
            stmt = this.connection.createStatement();
            String sql = "select DISTINCT CollectionObjectTypeID from collectionobject";
            HashSet<Integer> colObjTypeIds = new HashSet<Integer>();
            HashSet<Integer> colObjIds = new HashSet<Integer>();
            HashSet<Integer> habIds = new HashSet<Integer>();
            HashSet<Integer> ceIds = new HashSet<Integer>();
            HashSet<Integer> preps = new HashSet<Integer>();
            HashSet<Integer> taxs = new HashSet<Integer>();
            HashSet<Integer> loans = new HashSet<Integer>();
            for (Object idObj : BasicSQLUtils.querySingleCol(this.connection, sql)) {
                Integer id = (Integer)idObj;
                colObjTypeIds.add(id);
                if (id <= 8 || id >= 20) continue;
                sql = "SELECT co.CollectionObjectID, ce.CollectingEventID FROM collectionobject AS co Inner Join collectingevent AS ce ON co.CollectingEventID = ce.CollectingEventID WHERE CollectionObjectTypeID = " + id + " LIMIT 0,10";
                for (Object[] row : BasicSQLUtils.query(this.connection, sql)) {
                    colObjIds.add((Integer)row[0]);
                    ceIds.add((Integer)row[1]);
                    System.out.println("Adding co[" + (Integer)row[0] + "]   ce[" + (Integer)row[1] + "]");
                }
            }
            sql = "SELECT DISTINCT h.HabitatID, ce.CollectingEventID, co.CollectionObjectID FROM habitat AS h Inner Join collectingevent AS ce ON h.HabitatID = ce.CollectingEventID Inner Join collectionobject AS co ON ce.CollectingEventID = co.CollectingEventID Inner Join determination AS d ON co.CollectionObjectID = d.BiologicalObjectID Inner Join taxonname AS tn ON d.TaxonNameID = tn.TaxonNameID WHERE h.HostTaxonID IS NOT NULL LIMIT 0,20";
            System.out.println("Gathering HBs[\n" + sql + "\n]");
            for (Object[] row : BasicSQLUtils.query(this.connection, sql)) {
                Iterator<Object[]> hId = (Integer)row[0];
                Integer n = (Integer)row[1];
                Integer coId = (Integer)row[2];
                System.out.println("Adding co[" + coId + "]   ce[" + n + "]   hb[" + hId + "]");
                habIds.add((Integer)((Object)hId));
                ceIds.add(n);
                colObjIds.add(coId);
            }
            this.addToSet(colObjIds, "SELECT co.CollectionObjectID FROM collectionobjectcitation AS ci Inner Join collectionobject  AS co ON ci.BiologicalObjectID = co.CollectionObjectID LIMIT 0,5");
            for (Integer colId : colObjIds) {
                sql = "SELECT CollectionObjectID FROM collectionobject WHERE DerivedFromID = " + colId;
                for (Object e : BasicSQLUtils.querySingleCol(this.connection, sql)) {
                    preps.add((Integer)e);
                    System.out.println("Adding prep[" + (Integer)e + "]");
                }
            }
            sql = "SELECT co.DerivedFromID AS CoID, co.CollectionObjectID AS PrepID, lp.LoanID FROM collectionobject AS co Inner Join loanphysicalobject AS lp ON co.CollectionObjectID = lp.PhysicalObjectID LIMIT 0,5";
            for (Object[] row : BasicSQLUtils.query(this.connection, sql)) {
                Integer n = (Integer)row[0];
                Iterator<Object> prepId = (Integer)row[1];
                Integer loanId = (Integer)row[2];
                System.out.println("Adding co[" + n + "]   p[" + prepId + "]   l[" + loanId + "]");
                loans.add(loanId);
                preps.add((Integer)((Object)prepId));
                colObjIds.add(n);
            }
            boolean doNonTaxon = true;
            if (doNonTaxon) {
                String coIds = String.valueOf(this.getIdStrFromSet(colObjIds)) + (preps.size() > 0 ? "," + this.getIdStrFromSet(preps) : "");
                sql = "DELETE FROM collectionobject WHERE CollectionObjectID NOT IN (" + coIds + ")";
                System.out.println("Deleting COs[\n" + sql + "\n]");
                int count = BasicSQLUtils.update(this.connection, sql);
                this.total += count;
                System.out.println("Deleted [" + count + "] COs");
                sql = "DELETE FROM collectionobjectcatalog WHERE CollectionObjectCatalogID NOT IN (" + coIds + ")";
                System.out.println("Deleting CCs[\n" + sql + "\n]");
                count = BasicSQLUtils.update(this.connection, sql);
                this.total += count;
                System.out.println("Deleted [" + count + "] CCs");
                ids = this.getIdStrFromSet(ceIds);
                sql = "DELETE FROM collectingevent WHERE CollectingEventID NOT IN (" + ids + ")";
                System.out.println("Deleting CEs[\n" + sql + "\n]");
                count = BasicSQLUtils.update(this.connection, sql);
                this.total += count;
                System.out.println("Deleted [" + count + "] CEs");
                this.total += this.cleanTable(sql, "collectingevent", "CollectingEventID");
                ids = this.getIdStrFromSet(habIds);
                sql = "DELETE FROM habitat WHERE HabitatID NOT IN (" + ids + ")";
                System.out.println("Deleting Habs[\n" + sql + "\n]");
                count = BasicSQLUtils.update(this.connection, sql);
                this.total += count;
                System.out.println("Deleted [" + count + "] Habs");
                sql = "SELECT d.DeterminationID FROM determination  AS d Left Join collectionobject  AS co ON d.BiologicalObjectID = co.CollectionObjectID WHERE co.CollectionObjectID IS NOT NULL ";
                this.total += this.cleanTable(sql, "determination", "DeterminationID");
                sql = "SELECT l.LocalityID, ce.CollectingEventID FROM locality AS l Left Join collectingevent AS ce ON l.LocalityID = ce.LocalityID WHERE ce.CollectingEventID IS NOT NULL";
                this.total += this.cleanTable(sql, "locality", "LocalityID");
                sql = "SELECT ba.BiologicalObjectAttributesID FROM biologicalobjectattributes AS ba Left Join collectionobject AS co ON ba.BiologicalObjectAttributesID = co.CollectionObjectID WHERE co.CollectionObjectID IS NOT NULL";
                this.total += this.cleanTable(sql, "biologicalobjectattributes", "BiologicalObjectAttributesID");
                sql = "SELECT c.CollectorsID FROM collectors AS c  Left Join collectingevent AS ce ON c.CollectingEventID = ce.CollectingEventID WHERE ce.CollectingEventID IS NOT NULL";
                this.total += this.cleanTable(sql, "collectors", "CollectorsID");
                sql = "SELECT ci.CollectionObjectCitationID FROM collectionobjectcitation ci LEFT JOIN collectionobject co ON ci.BiologicalObjectID = co.CollectionObjectID WHERE co.CollectionObjectID IS NOT NULL";
                this.total += this.cleanTable(sql, "collectionobjectcitation", "CollectionObjectCitationID");
            }
            if (doTaxon = false) {
                Integer id;
                sql = "SELECT tn.TaxonNameID FROM habitat AS h Left Join taxonname AS tn ON h.HostTaxonID = tn.TaxonNameID WHERE tn.TaxonNameID IS NOT NULL";
                for (Object e : BasicSQLUtils.querySingleCol(this.connection, sql)) {
                    id = (Integer)e;
                    taxs.add(id);
                }
                sql = "SELECT tn.TaxonNameID FROM determination AS d Left Join taxonname tn ON d.TaxonNameID = tn.TaxonNameID WHERE tn.TaxonNameID IS NOT NULL";
                for (Object object : BasicSQLUtils.querySingleCol(this.connection, sql)) {
                    id = (Integer)object;
                    taxs.add(id);
                }
                ids = this.getIdStrFromSet(taxs);
                sql = "SELECT tn.AcceptedID FROM taxonname AS tn Inner Join taxonname AS tn2 ON tn.AcceptedID = tn2.TaxonNameID WHERE tn2.TaxonNameID IN (" + ids + ")";
                for (Object object : BasicSQLUtils.querySingleCol(this.connection, sql)) {
                    id = (Integer)object;
                    taxs.add(id);
                }
                ids = this.getIdStrFromSet(taxs);
                sql = "DELETE FROM taxonname WHERE RankID = 220 AND TaxonNameID NOT IN (" + ids + ")";
                System.out.println("Deleting TXs[\n" + sql + "\n]");
                int count = BasicSQLUtils.update(this.connection, sql);
                this.total += count;
                System.out.println("Deleted [" + count + "] TXs");
            }
            if (bl = false) {
                int cnt = 0;
                Vector<Object> idsToDel = BasicSQLUtils.querySingleCol(this.connection, "SELECT tn1.TaxonNameID FROM taxonname  AS tn1 LEFT JOIN taxonname tn2 ON tn1.ParentTaxonNameID = tn2.TaxonNameID WHERE tn1.RankID > 220 AND tn2.TaxonNameID IS NULL");
                for (Object obj : idsToDel) {
                    if (!taxs.contains(obj)) {
                        BasicSQLUtils.update(this.connection, "DELETE FROM taxonname WHERE TaxonNameID = " + obj);
                        if (cnt % 1000 == 0) {
                            System.out.println((int)((double)cnt * 100.0 / (double)idsToDel.size()));
                        }
                    }
                    ++cnt;
                }
                cnt = 0;
                idsToDel = BasicSQLUtils.querySingleCol(this.connection, "SELECT tn1.TaxonNameID FROM taxonname  AS tn1 LEFT JOIN taxonname tn2 ON tn1.AcceptedID = tn2.TaxonNameID WHERE tn2.TaxonNameID IS NULL");
                for (Object obj : idsToDel) {
                    if (!taxs.contains(obj)) {
                        BasicSQLUtils.update(this.connection, "DELETE FROM taxonname WHERE TaxonNameID = " + obj);
                        if (cnt % 1000 == 0) {
                            System.out.println((int)((double)cnt * 100.0 / (double)idsToDel.size()));
                        }
                    }
                    ++cnt;
                }
            }
            stmt.close();
            colDBConn.close();
            System.out.println("Done " + this.total);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected int cleanTable(String gatherSQL, String tableName, String idFieldName) {
        HashSet<Integer> setOfIds = new HashSet<Integer>();
        this.addToSet(setOfIds, gatherSQL);
        String ids = this.getIdStrFromSet(setOfIds);
        String sql = String.format("DELETE FROM %s WHERE %s NOT IN (%s)", tableName, idFieldName, ids);
        System.out.println(String.format("Deleting %s[\n%s\n]", tableName, sql));
        int count = BasicSQLUtils.update(this.connection, sql);
        System.out.println(String.format("Deleted [%d] %s", count, tableName));
        return count;
    }

    protected void addToSet(HashSet<Integer> setOfIds, String sql) {
        for (Object idObj : BasicSQLUtils.querySingleCol(this.connection, sql)) {
            Integer id = (Integer)idObj;
            setOfIds.add(id);
        }
    }

    protected String getIdStrFromSet(HashSet<Integer> set) {
        StringBuilder sb = new StringBuilder();
        for (Integer id : set) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(id);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        Sp5CollectionCleaner clearer = new Sp5CollectionCleaner();
        clearer.clean();
    }
}

