/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.IdMapperIFace;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;

public class ShipmentConverter {
    protected Connection oldDBConn;
    protected Connection newDBConn;

    public ShipmentConverter(Connection oldDBConn, Connection newDBConn) {
        this.oldDBConn = oldDBConn;
        this.newDBConn = newDBConn;
    }

    public void fixup() {
        try {
            Integer shipmentID;
            IdMapperIFace shipMapper = IdMapperMgr.getInstance().get("shipment", "ShipmentID");
            IdMapperIFace loanMapper = IdMapperMgr.getInstance().get("loan", "LoanID");
            IdMapperIFace giftMapper = IdMapperMgr.getInstance().get("gift", "GiftID");
            IdMapperIFace brrwMapper = IdMapperMgr.getInstance().get("borrow", "BorrowID");
            IdMapperIFace exchMapper = IdMapperMgr.getInstance().get("exchangeout", "ExchangeOutID");
            PreparedStatement pStmt = this.newDBConn.prepareStatement("UPDATE shipment SET LoanID=? WHERE ShipmentID=?");
            String sql = "SELECT LoanID, ShipmentID FROM loan WHERE ShipmentID IS NOT NULL AND Category = 0";
            for (Object[] row : BasicSQLUtils.query(this.oldDBConn, sql)) {
                Integer loandID = (Integer)row[0];
                shipmentID = (Integer)row[1];
                pStmt.setInt(1, loanMapper.get(loandID));
                pStmt.setInt(2, shipMapper.get(shipmentID));
                pStmt.execute();
            }
            pStmt.close();
            pStmt = this.newDBConn.prepareStatement("UPDATE shipment SET GiftID=? WHERE ShipmentID=?");
            sql = "SELECT LoanID, ShipmentID FROM loan WHERE ShipmentID IS NOT NULL AND Category = 1";
            for (Object[] row : BasicSQLUtils.query(this.oldDBConn, sql)) {
                Integer giftID = (Integer)row[0];
                shipmentID = (Integer)row[1];
                pStmt.setInt(1, giftMapper.get(giftID));
                pStmt.setInt(2, shipMapper.get(shipmentID));
                pStmt.execute();
            }
            pStmt.close();
            pStmt = this.newDBConn.prepareStatement("UPDATE shipment SET BorrowID=? WHERE ShipmentID=?");
            sql = "SELECT BorrowID, ShipmentID FROM borrowshipments WHERE ShipmentID IS NOT NULL";
            for (Object[] row : BasicSQLUtils.query(this.oldDBConn, sql)) {
                Integer brrwID = (Integer)row[0];
                shipmentID = (Integer)row[1];
                pStmt.setInt(1, brrwMapper.get(brrwID));
                pStmt.setInt(2, shipMapper.get(shipmentID));
                pStmt.execute();
            }
            pStmt.close();
            pStmt = this.newDBConn.prepareStatement("UPDATE shipment SET ExchangeOutID=? WHERE ShipmentID=?");
            sql = "SELECT ExchangeOutID, ShipmentID FROM exchangeout WHERE ShipmentID IS NOT NULL";
            for (Object[] row : BasicSQLUtils.query(this.oldDBConn, sql)) {
                Integer exchID = (Integer)row[0];
                shipmentID = (Integer)row[1];
                pStmt.setInt(1, exchMapper.get(exchID));
                pStmt.setInt(2, shipMapper.get(shipmentID));
                pStmt.execute();
            }
            pStmt.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

