/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.SpQueryField;
import edu.ku.brc.specify.tasks.subpane.qb.QueryFieldPanel;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.UploadTable;
import java.io.File;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.dom4j.Element;

public class QueryConverter {
    protected static final int scLike = 0;
    protected static final int scIn = 1;
    protected static final int scBetween = 2;
    protected static final int scExactlyLike = 3;
    protected static final int scLessThan = 4;
    protected static final int scMoreThan = 5;
    protected static final int scContains = 6;
    protected static final int scDontCare = 7;
    protected static final int scYes = 8;
    protected static final int scNo = 9;
    protected static final int scEmpty = 10;
    protected static final int scOn = 11;
    protected static final int scBefore = 12;
    protected static final int scAfter = 13;
    protected static final int scPartial = 14;
    protected static String[] localityDetailFlds = new String[]{"BaseMeridian", "NationalParkName", "Range", "RangeDirection", "Section", "SectionPart", "Township", "TownshipDirection"};

    protected static SpQueryField.OperatorType getSp6Op(int sp5QueryOp) {
        switch (sp5QueryOp) {
            case 0: {
                return SpQueryField.OperatorType.LIKE;
            }
            case 1: {
                return SpQueryField.OperatorType.IN;
            }
            case 2: {
                return SpQueryField.OperatorType.BETWEEN;
            }
            case 3: 
            case 11: {
                return SpQueryField.OperatorType.EQUALS;
            }
            case 4: 
            case 12: {
                return SpQueryField.OperatorType.LESSTHAN;
            }
            case 5: 
            case 13: {
                return SpQueryField.OperatorType.GREATERTHAN;
            }
            case 6: {
                return SpQueryField.OperatorType.CONTAINS;
            }
            case 7: {
                return SpQueryField.OperatorType.DONTCARE;
            }
            case 8: {
                return SpQueryField.OperatorType.TRUE;
            }
            case 9: {
                return SpQueryField.OperatorType.FALSE;
            }
            case 10: {
                return SpQueryField.OperatorType.EMPTY;
            }
        }
        return null;
    }

    protected static String getSixTableName(String fiveTableName, String fiveSubType, String fiveFldName) throws Exception {
        if (fiveTableName.equalsIgnoreCase("taxonname")) {
            return "taxon";
        }
        if (fiveTableName.equalsIgnoreCase("BorrowAgents")) {
            return "borrowagent";
        }
        if (fiveTableName.equalsIgnoreCase("collectors")) {
            return "collector";
        }
        if (fiveTableName.equalsIgnoreCase("CollectionObjectCatalog")) {
            return "collectionobject";
        }
        if (fiveTableName.equalsIgnoreCase("CollectionObject")) {
            if (fiveSubType != null && fiveSubType.endsWith("Preparation")) {
                return "preparation";
            }
            return "collectionobject";
        }
        if (fiveTableName.equalsIgnoreCase("LoanAgents")) {
            if (fiveSubType != null && fiveSubType.equals("Gift")) {
                return "giftagent";
            }
            return "loanagent";
        }
        if (fiveTableName.equalsIgnoreCase("Habitat")) {
            return "collectingeventattribute";
        }
        if (fiveTableName.equalsIgnoreCase("BiologicalObjectAttributes")) {
            return "collectionobjectattribute";
        }
        if (fiveTableName.equalsIgnoreCase("LoanPhysicalObject")) {
            if (fiveSubType.equalsIgnoreCase("Gift")) {
                return "giftpreparation";
            }
            return "loanpreparation";
        }
        if (fiveTableName.equalsIgnoreCase("Loan") && fiveSubType.equalsIgnoreCase("Gift")) {
            return "gift";
        }
        if (fiveTableName.equalsIgnoreCase("CatalogSeries")) {
            throw new Exception(fiveTableName);
        }
        if (fiveTableName.equalsIgnoreCase("locality") || fiveTableName.equals("geography")) {
            String[] stringArray = localityDetailFlds;
            int n = localityDetailFlds.length;
            int n2 = 0;
            while (n2 < n) {
                String fld = stringArray[n2];
                if (fld.equalsIgnoreCase(fiveFldName)) {
                    return "localitydetail";
                }
                ++n2;
            }
        }
        return fiveTableName.toLowerCase();
    }

    protected static String getSixFldName(String sixTblName, String fiveTblName, String fiveFldName) {
        String result = UploadTable.deCapitalize(fiveFldName);
        if (result.equalsIgnoreCase("collectionobjectcatalogid")) {
            result = "collectionobjectid";
        }
        if (result.equalsIgnoreCase("continentOrOcean")) {
            result = "Continent";
        }
        if (result.equals("loanNumber") && sixTblName.equals("gift")) {
            result = "giftNumber";
        }
        if (result.equals("name") && sixTblName.equals("agent")) {
            result = "lastName";
        }
        if (result.equals("number") && sixTblName.equalsIgnoreCase("accession")) {
            result = "accessionNumber";
        }
        if (result.equalsIgnoreCase("preparationmethod")) {
            result = "name";
        }
        if (result.equalsIgnoreCase("taxonnameid")) {
            result = "taxonid";
        }
        if (result.equalsIgnoreCase("current") && sixTblName.equalsIgnoreCase("determination")) {
            result = "isCurrent";
        }
        if (result.equalsIgnoreCase("fulltaxonname")) {
            result = "fullName";
        }
        if (result.equalsIgnoreCase("taxonname")) {
            result = "name";
        }
        if (result.equalsIgnoreCase("FullGeographicName")) {
            result = "fullName";
        }
        if (result.equalsIgnoreCase("LastEditedBy")) {
            result = "lastName";
        }
        if (result.equalsIgnoreCase("range")) {
            result = "rangeDesc";
        }
        if (result.equalsIgnoreCase("closed")) {
            result = "isClosed";
        }
        if (result.equalsIgnoreCase("accepted")) {
            result = "isAccepted";
        }
        if (result.equalsIgnoreCase("groupPermittedToView")) {
            result = "visibility";
        }
        if (result.equalsIgnoreCase("date") && fiveTblName.equalsIgnoreCase("deaccession")) {
            result = "deaccessionDate";
        }
        if (result.equalsIgnoreCase("date") && fiveTblName.equalsIgnoreCase("determination")) {
            result = "determinedDate";
        }
        if (result.equalsIgnoreCase("loandate") && sixTblName.equalsIgnoreCase("gift")) {
            result = "giftDate";
        }
        if (result.equalsIgnoreCase("count") && sixTblName.equalsIgnoreCase("preparation")) {
            result = "countAmt";
        }
        return result;
    }

    public static void getSixQueryXML(StringBuilder sb, Element fiveQueryXML, List<String> unconvertedFields) throws Exception {
        StringBuilder querySb = new StringBuilder();
        querySb.append("<query ");
        String queryName = fiveQueryXML.attributeValue("name");
        XMLHelper.addAttr(querySb, "name", queryName);
        String fiveTblName = fiveQueryXML.attributeValue("contextName");
        String fiveSubType = fiveQueryXML.attributeValue("subType", null);
        String contextName = QueryConverter.getSixTableName(fiveTblName, fiveSubType, null);
        XMLHelper.addAttr(querySb, "contextName", contextName);
        XMLHelper.addAttr(querySb, "contextTableId", DBTableIdMgr.getInstance().getIdByShortName(contextName));
        XMLHelper.addAttr(querySb, "isFavorite", fiveQueryXML.attributeValue("isFavorite"));
        XMLHelper.addAttr(querySb, "named", fiveQueryXML.attributeValue("named"));
        XMLHelper.addAttr(querySb, "ordinal", fiveQueryXML.attributeValue("ordinal"));
        querySb.append(">\r\n");
        querySb.append("<fields>\r\n");
        TreeSet<String> queryLines = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                String fld0 = arg0.replaceFirst("position=\".*\" isNot", "isNot");
                String fld1 = arg1.replaceFirst("position=\".*\" isNot", "isNot");
                return fld0.compareTo(fld1);
            }
        });
        for (Object fldObj : fiveQueryXML.selectNodes("fields/field")) {
            String fldStr = QueryConverter.getSixQueryFieldXML((Element)fldObj, contextName, queryName, unconvertedFields);
            if (fldStr == null || queryLines.contains(fldStr)) continue;
            queryLines.add(fldStr);
            querySb.append(String.valueOf(fldStr) + "\r\n");
        }
        querySb.append("</fields>\r\n");
        querySb.append("</query>");
        sb.append((CharSequence)querySb);
    }

    protected static String getSixQueryFieldXML(Element fiveXML, String sixQueryTblName, String queryName, List<String> unconvertedFields) {
        boolean converted = false;
        Exception exception = null;
        StringBuilder fldSb = new StringBuilder();
        String result = null;
        try {
            if (fiveXML.attributeValue("isConvertable", "true").equals("true")) {
                converted = true;
                fldSb.append("<field ");
                XMLHelper.addAttr(fldSb, "position", fiveXML.attributeValue("position"));
                XMLHelper.addAttr(fldSb, "isNot", fiveXML.attributeValue("isNot"));
                XMLHelper.addAttr(fldSb, "isDisplay", fiveXML.attributeValue("isDisplay"));
                XMLHelper.addAttr(fldSb, "isPrompt", fiveXML.attributeValue("isPrompt"));
                boolean isRelFld = !fiveXML.attributeValue("isRelFld", "false").equals("false");
                XMLHelper.addAttr(fldSb, "isRelFld", isRelFld);
                XMLHelper.addAttr(fldSb, "isAlwaysFilter", fiveXML.attributeValue("isAlwaysFilter"));
                XMLHelper.addAttr(fldSb, "startValue", fiveXML.attributeValue("startValue"));
                XMLHelper.addAttr(fldSb, "endValue", fiveXML.attributeValue("endValue"));
                XMLHelper.addAttr(fldSb, "sortType", fiveXML.attributeValue("sortType"));
                String fiveTblName = fiveXML.attributeValue("contextTable");
                String fiveSubType = fiveXML.attributeValue("subType", null);
                String contextTable = QueryConverter.getSixTableName(fiveTblName, fiveSubType, fiveXML.attributeValue("name"));
                XMLHelper.addAttr(fldSb, "contextTableIdent", DBTableIdMgr.getInstance().getIdByShortName(contextTable));
                String sixFldName = QueryConverter.getSixFldName(contextTable, fiveTblName, fiveXML.attributeValue("name"));
                if (!isRelFld) {
                    XMLHelper.addAttr(fldSb, "fieldName", sixFldName);
                    XMLHelper.addAttr(fldSb, "fieldAlias", sixFldName);
                }
                String sixTblIdList = null;
                String[] idListInfo = QueryConverter.processTableIdList(fiveXML, sixFldName, contextTable, isRelFld);
                if (idListInfo[0] != null) {
                    sixTblIdList = idListInfo[0];
                    if (isRelFld && idListInfo[1] != null) {
                        sixFldName = idListInfo[1];
                    }
                    if (idListInfo[2] != null) {
                        contextTable = idListInfo[2];
                    }
                } else {
                    converted = false;
                }
                if (converted) {
                    if (isRelFld) {
                        XMLHelper.addAttr(fldSb, "fieldName", sixFldName);
                        XMLHelper.addAttr(fldSb, "fieldAlias", sixFldName);
                    }
                    XMLHelper.addAttr(fldSb, "tableList", sixTblIdList);
                    XMLHelper.addAttr(fldSb, "stringId", String.valueOf(sixTblIdList) + "." + contextTable + "." + sixFldName);
                    XMLHelper.addAttr(fldSb, "operStart", QueryConverter.getOperatorAttribute(fiveXML.attributeValue("operStart", ""), fiveXML.attributeValue("dataType")));
                    XMLHelper.addAttr(fldSb, "operEnd", fiveXML.attributeValue("operEnd"));
                }
            }
        }
        catch (Exception ex) {
            converted = false;
            exception = ex;
        }
        if (!converted) {
            String text = String.valueOf(queryName) + " - " + fiveXML.attributeValue("contextTable", "unknown") + "." + fiveXML.attributeValue("name", "unknown");
            if (exception != null) {
                text = String.valueOf(text) + ": " + exception.getMessage();
            }
            unconvertedFields.add(text);
        } else {
            fldSb.append(" />");
            result = fldSb.toString();
        }
        return result;
    }

    protected static SpQueryField.OperatorType[] getSp6Ops(String sp5Type) {
        if (sp5Type.equals("tree")) {
            return new SpQueryField.OperatorType[]{SpQueryField.OperatorType.EQUALS, SpQueryField.OperatorType.LIKE, SpQueryField.OperatorType.IN, SpQueryField.OperatorType.EMPTY};
        }
        Class cls = null;
        if (sp5Type.equals("string") || sp5Type.equals("picklist")) {
            cls = String.class;
        } else if (sp5Type.equals("boolean")) {
            cls = Boolean.class;
        } else if (sp5Type.equals("date")) {
            cls = Timestamp.class;
        }
        return QueryFieldPanel.getComparatorListForClass(cls);
    }

    protected static String getOperatorAttribute(String sp5Op, String sp5Type) {
        if (!sp5Op.equals("")) {
            SpQueryField.OperatorType sp6Op = QueryConverter.getSp6Op(Integer.valueOf(sp5Op));
            SpQueryField.OperatorType[] ops = QueryConverter.getSp6Ops(sp5Type);
            int op = 0;
            while (op < ops.length) {
                if (ops[op].equals((Object)sp6Op)) {
                    return String.valueOf(op);
                }
                ++op;
            }
        }
        return "";
    }

    protected static String[] processTableIdList(Element fiveXML, String sixFldName, String sixTblName, boolean isRelFld) throws Exception {
        String fiveTblList = fiveXML.attributeValue("tableList").replaceAll(", ", ",");
        String newSixFldName = null;
        String newContextTblName = null;
        String sixTblIdList = "";
        String[] fiveLinks = fiveTblList.split(",");
        String prevSixTbl = null;
        String prevSubType = null;
        int l = 0;
        while (l < fiveLinks.length) {
            String fiveLink = QueryConverter.preProcessLink(fiveLinks, l);
            if (fiveLink != null) {
                String subType;
                String[] linkParts = fiveLink.split("-");
                String tblPart = linkParts[0];
                String relPart = linkParts.length > 1 ? linkParts[1] : null;
                String[] tblParts = tblPart.split("\\.");
                String tblName = tblParts[0];
                String sixTbl = QueryConverter.getSixTableName(tblName, (subType = tblParts.length > 1 ? tblParts[1] : null) == null ? prevSubType : subType, null);
                if (!sixTbl.equals(prevSixTbl)) {
                    DBTableInfo prevInfo = prevSixTbl != null ? DBTableIdMgr.getInstance().getInfoByTableName(prevSixTbl) : null;
                    DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(sixTbl);
                    String sixLink = String.valueOf(info.getTableId());
                    if (relPart != null) {
                        DBRelationshipInfo match = QueryConverter.getRelationship(relPart, info, prevInfo, sixTbl, tblName);
                        if (match != null) {
                            if (!match.getName().equalsIgnoreCase(info.getName())) {
                                sixLink = String.valueOf(sixLink) + "-" + match.getName();
                            }
                            if (isRelFld) {
                                newSixFldName = match.getName();
                            }
                        } else {
                            return null;
                        }
                    }
                    String[] specialStuff = QueryConverter.processSpecialCases(sixLink, sixFldName, sixTblName, fiveXML.attributeValue("name"));
                    if (sixTblIdList.length() > 0 && specialStuff[0] != null) {
                        sixTblIdList = String.valueOf(sixTblIdList) + ",";
                    }
                    sixTblIdList = String.valueOf(sixTblIdList) + specialStuff[0];
                    if (specialStuff[1] != null) {
                        newContextTblName = specialStuff[1];
                    }
                    prevSixTbl = sixTbl;
                    if (subType != null) {
                        prevSubType = subType;
                    }
                }
            }
            ++l;
        }
        String[] result = new String[]{sixTblIdList, newSixFldName, newContextTblName};
        return result;
    }

    protected static DBRelationshipInfo getRelationship(String relPart, DBTableInfo info, DBTableInfo prevInfo, String sixTbl, String tblName) {
        String[] relParts = relPart.split(":");
        String fromKey = QueryConverter.getSixFldName(sixTbl, tblName, relParts[0]);
        Vector<DBRelationshipInfo> matches = new Vector<DBRelationshipInfo>();
        for (DBRelationshipInfo rel : prevInfo.getRelationships()) {
            if (!rel.getDataClass().equals(info.getClassObj())) continue;
            matches.add(rel);
        }
        DBRelationshipInfo match = null;
        if (matches.size() > 0) {
            if (matches.size() == 1) {
                match = (DBRelationshipInfo)matches.get(0);
            } else {
                for (DBRelationshipInfo candidate : matches) {
                    if (!fromKey.equalsIgnoreCase(candidate.getColName())) continue;
                    match = candidate;
                }
            }
            if (match == null && info.getClassObj().equals(Agent.class)) {
                int m = matches.size() - 1;
                while (m >= 0) {
                    DBRelationshipInfo rel = (DBRelationshipInfo)matches.get(m);
                    if (rel.getName().equalsIgnoreCase("modifiedbyagent") || rel.getName().equalsIgnoreCase("createdbyagent")) {
                        matches.remove(m);
                    }
                    --m;
                }
                if (matches.size() == 1) {
                    match = (DBRelationshipInfo)matches.get(0);
                }
            }
        }
        return match;
    }

    protected static String preProcessLink(String[] fiveLinks, int linkIndex) {
        String link = fiveLinks[linkIndex];
        if (link.toLowerCase().startsWith("agentaddress-agent")) {
            String nextLink = fiveLinks[linkIndex + 1];
            if (nextLink.toLowerCase().startsWith("agent")) {
                return null;
            }
            if (nextLink.toLowerCase().startsWith("address")) {
                return "Agent-?:AgentID";
            }
        }
        return fiveLinks[linkIndex];
    }

    protected static String[] processSpecialCases(String node, String sixFldName, String sixTblName, String fiveFldName) {
        String[] result = new String[2];
        if (sixFldName.equalsIgnoreCase("name") && sixTblName.equalsIgnoreCase("preparation") && node.equalsIgnoreCase("63-preparations")) {
            result[0] = String.valueOf(node) + ",65";
            result[1] = "preptype";
        } else if (sixFldName.equalsIgnoreCase("lastName") && fiveFldName.equalsIgnoreCase("LastEditedBy")) {
            result[0] = String.valueOf(node) + ",5-modifiedByAgent";
            result[1] = "agent";
        } else if (sixTblName.equalsIgnoreCase("localitydetail") && node.equals("2")) {
            result[0] = String.valueOf(node) + ",124-localityDetails";
            result[1] = null;
        } else {
            result[0] = node;
            result[1] = null;
        }
        return result;
    }

    public static void convert(String fiveQueryFile, String sixQueryFile, String logFile) throws Exception {
        Element fiveXML = XMLHelper.readFileToDOM4J(new File(fiveQueryFile));
        StringBuilder sb = new StringBuilder();
        sb.append("<queries>\r\n");
        Vector<String> unconvertable = new Vector<String>();
        Vector<String> allUnconvertables = new Vector<String>();
        for (Object fiveQ : fiveXML.selectNodes("/queries/sp5query")) {
            Element fiveQE = (Element)fiveQ;
            System.out.println("processing " + fiveQE.attributeValue("name", "unknown"));
            try {
                QueryConverter.getSixQueryXML(sb, fiveQE, unconvertable);
            }
            catch (Exception ex) {
                System.out.println("  " + ex.getClass().getName() + " - " + ex.getMessage());
                unconvertable.clear();
                allUnconvertables.add("unabled to convert query: " + fiveQE.attributeValue("name", "unknown"));
            }
            if (unconvertable.size() > 0) {
                allUnconvertables.addAll(unconvertable);
                unconvertable.clear();
            }
            sb.append("\r\n");
        }
        sb.append("</queries>");
        FileUtils.writeStringToFile((File)new File(sixQueryFile), (String)sb.toString());
        FileUtils.writeLines((File)new File(logFile), allUnconvertables);
    }

    public static void main(String[] args) {
        try {
            if (args.length != 3) {
                System.out.println("Usage: QueryConverter InputFileName OutputFileName LogFileName");
                System.exit(1);
            }
            String fiveQueryFile = args[0];
            String sixQueryFile = args[1];
            String logFile = args[2];
            QueryConverter.convert(fiveQueryFile, sixQueryFile, logFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

