/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Triple;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class OldDBStatsDlg
extends CustomDialog {
    protected Connection oldDBConn;
    protected Vector<Triple<String, Integer, Boolean>> statsData = new Vector();
    protected JCheckBox doFixAgentsChkbx;

    public OldDBStatsDlg(Connection oldDBConn) {
        super((Frame)UIRegistry.getMostRecentWindow(), "Source DB Statistics", true, (Component)null);
        this.oldDBConn = oldDBConn;
    }

    @Override
    public void createUI() {
        this.setOkLabel("Continue");
        super.createUI();
        String[] stringArray = new String[18];
        stringArray[0] = "SELECT COUNT(*) FROM collectionobject co1 LEFT JOIN collectionobject co2 ON co1.DerivedFromID = co2.CollectionObjectID WHERE co1.DerivedFromID is not NULL AND co2.CollectionObjectID is NULL";
        stringArray[1] = "SELECT COUNT(*) FROM taxonname WHERE RankID iS NULL";
        stringArray[2] = "SELECT COUNT(*) FROM collectionobject";
        stringArray[3] = "SELECT COUNT(*) FROM collectionobjectcatalog";
        stringArray[4] = "SELECT COUNT(*) FROM taxonname";
        stringArray[5] = "SELECT COUNT(*) FROM determination";
        stringArray[6] = "SELECT COUNT(*) FROM agent";
        stringArray[7] = "SELECT COUNT(*) FROM agent WHERE LENGTH(Name) > 50";
        stringArray[8] = "SELECT COUNT(*) FROM agent WHERE LENGTH(LastName) > 50";
        stringArray[9] = "SELECT COUNT(*) FROM agent WHERE LastName LIKE '%;%'";
        stringArray[10] = "SELECT COUNT(c.AgentID) FROM collectingevent ce INNER JOIN collectors c ON ce.CollectingEventID = c.CollectingEventID INNER JOIN agent a ON c.AgentID = a.AgentID WHERE a.LastName LIKE '%;%'";
        stringArray[11] = "SELECT COUNT(*) FROM authors au INNER JOIN agent a ON au.AgentID = a.AgentID WHERE a.LastName LIKE '%;%'";
        stringArray[12] = "SELECT COUNT(*) FROM accessionagents aagt INNER JOIN agentaddress aa ON aagt.AgentAddressID = aa.AgentAddressID INNER JOIN agent a ON aa.AgentID = a.AgentID WHERE a.LastName LIKE '%;%'";
        stringArray[13] = "SELECT COUNT(*) FROM borrowagents ba INNER JOIN agentaddress aa ON ba.AgentAddressID = aa.AgentAddressID INNER JOIN agent a ON aa.AgentID = a.AgentID WHERE a.LastName LIKE '%;%'";
        stringArray[14] = "SELECT COUNT(*) FROM loanagents la INNER JOIN agentaddress aa ON la.AgentAddressID = aa.AgentAddressID INNER JOIN agent a ON aa.AgentID = a.AgentID WHERE a.LastName LIKE '%;%'";
        stringArray[15] = "SELECT COUNT(ID) FROM (SELECT DISTINCT ce.LocalityID as ID FROM collectingevent ce LEFT JOIN locality loc ON loc.localityid = ce.LocalityID  WHERE loc.LocalityID IS NULL) AS T1";
        stringArray[16] = "SELECT COUNT(*) FROM shipment";
        String[] queries = stringArray;
        String[] descs = new String[]{"Stranded Preparations", "Number of Taxon with a NULL RankId", "CollectionObjects Table", "Collection Object Catalogs Table", "Taxon", "Determinations", "Agents", "Agent Names Truncated", "Agent Last Names Truncated", "Agent Last Names with ';'", "Collector Last Names with ';'", "Author Last Names with ';'", "Accession Agents Last Names with ';'", "Borrow Agent Last Names with ';'", "Loan Agent Last Names with ';'", "Collecting Events with NULL Localities", "Number of Shipments", "Stranded Agents Last Names with ';'"};
        Integer[] errors = new Integer[]{0, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int i = 0;
        while (i < queries.length) {
            int count = queries[i] != null ? BasicSQLUtils.getCountAsInt(this.oldDBConn, queries[i]) : 0;
            this.statsData.add(new Triple<String, Integer, Boolean>(descs[i], count, errors[i] != null && count > errors[i]));
            ++i;
        }
        Triple<String, Integer, Boolean> stranded = this.statsData.get(errors.length - 1);
        stranded.second = this.getStrandedAgentsCount();
        stranded.third = (Integer)stranded.second > errors[errors.length - 1];
        JTable table = new JTable(new StatsModel());
        table.setPreferredScrollableViewportSize(new Dimension(table.getPreferredScrollableViewportSize().width, 10 * table.getRowHeight()));
        table.getColumnModel().getColumn(0).setCellRenderer(new StatTblCellRenderer());
        table.getColumnModel().getColumn(1).setCellRenderer(new StatTblCellRenderer());
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,f:p:g", "f:p:g,10px,p,2px,f:p:g,4px,p"));
        pb.add((Component)UIHelper.createScrollPane(table, true), cc.xyw(1, 1, 3));
        String sql = "SELECT DISTINCT(CNAME), L, F, M FROM (SELECT a.LastName AS L, a.FirstName AS F, a.MiddleInitial AS M, CONCAT(a.LastName, CONCAT(IFNULL(a.FirstName, ''), IFNULL(a.MiddleInitial, ''))) AS CNAME FROM collectingevent ce INNER JOIN collectors c ON ce.CollectingEventID = c.CollectingEventID INNER JOIN agent a ON c.AgentID = a.AgentID WHERE a.LastName LIKE '%;%' OR a.FirstName LIKE '%,%') T1";
        Vector<Object[]> collRows = BasicSQLUtils.query(this.oldDBConn, sql);
        Object[][] rows = new Object[collRows.size()][4];
        int i2 = 0;
        for (Object[] row : collRows) {
            rows[i2][0] = row[0];
            rows[i2][1] = row[1];
            rows[i2][2] = row[2];
            rows[i2][3] = row[3];
            ++i2;
        }
        JTable collTable = new JTable(rows, new Object[]{"Combined", "Last Name", "First Name", "Middle"});
        collTable.setPreferredScrollableViewportSize(new Dimension(collTable.getPreferredScrollableViewportSize().width, 10 * collTable.getRowHeight()));
        this.doFixAgentsChkbx = UIHelper.createCheckBox("Fix Agents");
        this.contentPanel = pb.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
    }

    private int getStrandedAgentsCount() {
        String[] queries = new String[]{"SELECT AgentID FROM agent WHERE LastName LIKE '%;%'", "SELECT c.AgentID FROM collectingevent ce INNER JOIN collectors c ON ce.CollectingEventID = c.CollectingEventID INNER JOIN agent a ON c.AgentID = a.AgentID WHERE a.LastName LIKE '%;%'", "SELECT au.AgentID FROM authors au INNER JOIN agent a ON au.AgentID = a.AgentID WHERE a.LastName LIKE '%;%'", "SELECT a.AgentID FROM accessionagents aagt INNER JOIN agentaddress aa ON aagt.AgentAddressID = aa.AgentAddressID INNER JOIN agent a ON aa.AgentID = a.AgentID WHERE a.LastName LIKE '%;%'", "SELECT a.AgentID FROM borrowagents ba INNER JOIN agentaddress aa ON ba.AgentAddressID = aa.AgentAddressID INNER JOIN agent a ON aa.AgentID = a.AgentID WHERE a.LastName LIKE '%;%'", "SELECT a.AgentID FROM loanagents la INNER JOIN agentaddress aa ON la.AgentAddressID = aa.AgentAddressID INNER JOIN agent a ON aa.AgentID = a.AgentID WHERE a.LastName LIKE '%;%'"};
        Hashtable<Integer, Boolean> hash = new Hashtable<Integer, Boolean>();
        int cnt = 0;
        String[] stringArray = queries;
        int n = queries.length;
        int n2 = 0;
        while (n2 < n) {
            String sql = stringArray[n2];
            ArrayList<Integer> ids = this.getIds(sql);
            if (cnt == 0) {
                for (Integer id : ids) {
                    hash.put(id, true);
                }
            } else {
                for (Integer id : ids) {
                    if (hash.get(id) == null) continue;
                    hash.remove(id);
                }
            }
            ++cnt;
            ++n2;
        }
        return hash.size();
    }

    private ArrayList<Integer> getIds(String sql) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        try {
            Statement stmt = this.oldDBConn.createStatement(1004, 1007);
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                list.add(rs.getInt(1));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public boolean doFixAgents() {
        return this.doFixAgentsChkbx.isSelected();
    }

    class StatTblCellRenderer
    extends DefaultTableCellRenderer {
        protected Color red = new Color(255, 192, 192);

        StatTblCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel lbl = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Triple<String, Integer, Boolean> triple = OldDBStatsDlg.this.statsData.get(row);
            String text = column == 0 ? (String)triple.first : ((Integer)triple.second).toString();
            lbl.setText(text);
            lbl.setBackground((Boolean)triple.third != false ? this.red : Color.WHITE);
            return lbl;
        }
    }

    class StatsModel
    extends AbstractTableModel {
        String[] titles = new String[]{"Description", "Count"};

        StatsModel() {
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? String.class : Integer.class;
        }

        @Override
        public String getColumnName(int column) {
            return this.titles[column];
        }

        @Override
        public int getColumnCount() {
            return this.titles != null ? this.titles.length : 0;
        }

        @Override
        public int getRowCount() {
            return OldDBStatsDlg.this.statsData.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Triple<String, Integer, Boolean> triple = OldDBStatsDlg.this.statsData.get(rowIndex);
            return columnIndex == 0 ? (Serializable)triple.first : (Serializable)triple.second;
        }
    }
}

