/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.CollectionInfo;
import edu.ku.brc.specify.conversion.GenericDBConversion;
import edu.ku.brc.specify.conversion.GulfInvertsFixer;
import edu.ku.brc.specify.conversion.IdMapperIFace;
import edu.ku.brc.specify.conversion.IdMapperIndexIncrementerIFace;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.treeutils.NodeNumberer;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIRegistry;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MSULichensFixer {
    protected static final Logger log = Logger.getLogger(GulfInvertsFixer.class);
    private static final String connStr = "jdbc:mysql://localhost/%s?characterEncoding=UTF-8&autoReconnect=true";
    protected static SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    protected static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    protected static Timestamp now = new Timestamp(System.currentTimeMillis());
    protected static String nowStr = dateTimeFormatter.format(now);
    protected Connection oldDBConn;
    protected Connection newDBConn;
    protected String oldDBName;
    protected String newDBName;
    protected TableWriter tblWriter;
    protected static int taxonomicUnitTypeId = 11111111;
    protected IdMapperIndexIncrementerIFace indexIncremeter;
    protected GenericDBConversion conversion;
    protected ProgressFrame frame;
    protected String taxonomyTypeIdInClause = null;
    protected String taxonFromClause = null;
    protected Vector<CollectionInfo> collectionInfoList;
    protected HashMap<Integer, Vector<CollectionInfo>> collDispHash;
    protected HashMap<Integer, TaxonTreeDef> newTaxonInfoHash = new HashMap();
    protected HashSet<Integer> taxonTypesInUse = new HashSet();
    protected HashMap<Integer, TaxonTreeDef> taxonTreeDefHash = new HashMap();
    protected HashMap<Integer, Taxon> taxonTreeHash = new HashMap();
    protected IdMapperIFace txMapper = null;
    protected IdMapperIFace txTypMapper = null;
    protected IdMapperIFace txUnitTypMapper = null;
    protected IdMapperIFace[] mappers = null;
    protected String[] oldCols = new String[]{"TaxonNameID", "ParentTaxonNameID", "TaxonomyTypeID", "AcceptedID", "TaxonomicUnitTypeID", "TaxonomicSerialNumber", "TaxonName", "UnitInd1", "UnitName1", "UnitInd2", "UnitName2", "UnitInd3", "UnitName3", "UnitInd4", "UnitName4", "FullTaxonName", "CommonName", "Author", "Source", "GroupPermittedToView", "EnvironmentalProtectionStatus", "Remarks", "NodeNumber", "HighestChildNodeNumber", "LastEditedBy", "Accepted", "RankID", "GroupNumber", "TimestampCreated", "TimestampModified"};
    protected String[] cols = new String[]{"TaxonID", "Author", "CitesStatus", "COLStatus", "CommonName", "CultivarName", "EnvironmentalProtectionStatus", "EsaStatus", "FullName", "GroupNumber", "GUID", "HighestChildNodeNumber", "IsAccepted", "IsHybrid", "IsisNumber", "LabelFormat", "Name", "NcbiTaxonNumber", "NodeNumber", "Number1", "Number2", "RankID", "Remarks", "Source", "TaxonomicSerialNumber", "Text1", "Text2", "UnitInd1", "UnitInd2", "UnitInd3", "UnitInd4", "UnitName1", "UnitName2", "UnitName3", "UnitName4", "UsfwsCode", "Visibility", "ParentID", "AcceptedID", "ModifiedByAgentID", "TaxonTreeDefItemID", "VisibilitySetByID", "CreatedByAgentID", "HybridParent1ID", "TaxonTreeDefID", "HybridParent2ID", "TimestampCreated", "TimestampModified", "Version"};
    protected int[] colTypes = null;
    protected int[] colSizes = null;
    protected Hashtable<String, String> newToOldColMap = new Hashtable();
    protected Hashtable<String, String> oldToNewColMap = new Hashtable();
    protected HashMap<String, Integer> fieldToColHash = new HashMap();
    protected HashMap<Integer, String> colToFieldHash = new HashMap();
    protected HashMap<String, Integer> oldFieldToColHash = new HashMap();
    protected PreparedStatement pStmtTx = null;
    protected Statement stmtTx = null;
    protected int missingParentTaxonCount = 0;
    protected int lastEditedByInx;
    protected int modifiedByAgentInx;
    protected int rankIdOldDBInx;

    public MSULichensFixer(String oldDBName, String newDBName, TableWriter tblWriter) {
        this.oldDBName = oldDBName;
        this.newDBName = newDBName;
        this.tblWriter = tblWriter;
    }

    public void doConnect() {
        try {
            this.oldDBConn = DriverManager.getConnection(String.format(connStr, this.oldDBName), "root", "root");
            this.newDBConn = DriverManager.getConnection(String.format(connStr, this.newDBName), "root", "root");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        try {
            this.oldDBConn.close();
            this.newDBConn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void convertTaxonRecords() {
        block33: {
            IdMapperMgr.getInstance().setDBs(this.oldDBConn, this.newDBConn);
            this.txMapper = IdMapperMgr.getInstance().addTableMapper("taxonname", "TaxonNameID", false);
            this.txTypMapper = IdMapperMgr.getInstance().addTableMapper("TaxonomyType", "TaxonomyTypeID", false);
            this.txUnitTypMapper = IdMapperMgr.getInstance().addTableMapper("TaxonomicUnitType", "TaxonomicUnitTypeID", false);
            this.mappers = new IdMapperIFace[]{this.txMapper, this.txMapper, this.txTypMapper, this.txMapper, this.txUnitTypMapper};
            this.newToOldColMap.put("TaxonID", "TaxonNameID");
            this.newToOldColMap.put("ParentID", "ParentTaxonNameID");
            this.newToOldColMap.put("TaxonTreeDefID", "TaxonomyTypeID");
            this.newToOldColMap.put("TaxonTreeDefItemID", "TaxonomicUnitTypeID");
            this.newToOldColMap.put("Name", "TaxonName");
            this.newToOldColMap.put("FullName", "FullTaxonName");
            this.newToOldColMap.put("IsAccepted", "Accepted");
            this.oldToNewColMap.put("TaxonNameID", "TaxonID");
            this.oldToNewColMap.put("ParentTaxonNameID", "ParentID");
            this.oldToNewColMap.put("TaxonomyTypeID", "TaxonTreeDefID");
            this.oldToNewColMap.put("TaxonomicUnitTypeID", "TaxonTreeDefItemID");
            this.oldToNewColMap.put("TaxonName", "Name");
            this.oldToNewColMap.put("FullTaxonName", "FullName");
            this.oldToNewColMap.put("Accepted", "IsAccepted");
            BasicSQLUtils.setDBConnection(this.newDBConn);
            StringBuilder newSB = new StringBuilder();
            StringBuilder vl = new StringBuilder();
            int i = 0;
            while (i < this.cols.length) {
                this.fieldToColHash.put(this.cols[i], i + 1);
                this.colToFieldHash.put(i + 1, this.cols[i]);
                if (newSB.length() > 0) {
                    newSB.append(", ");
                }
                newSB.append(this.cols[i]);
                if (vl.length() > 0) {
                    vl.append(',');
                }
                vl.append('?');
                ++i;
            }
            StringBuilder oldSB = new StringBuilder();
            int i2 = 0;
            while (i2 < this.oldCols.length) {
                this.oldFieldToColHash.put(this.oldCols[i2], i2 + 1);
                if (oldSB.length() > 0) {
                    oldSB.append(", ");
                }
                oldSB.append("ttx.");
                oldSB.append(this.oldCols[i2]);
                ++i2;
            }
            this.rankIdOldDBInx = this.oldFieldToColHash.get("RankID");
            String sqlStr = String.format("SELECT %s FROM taxon ", newSB.toString());
            log.debug((Object)sqlStr);
            String fromClause = " FROM taxonname ttx LEFT JOIN msu_lichens.taxonname_TaxonNameID ON OldID = ttx.TaxonNameID LEFT JOIN msu_lichens_6.taxon AS ntx ON NewID = ntx.TaxonID WHERE ntx.TaxonID IS NULL";
            String sql = String.format("SELECT %s %s", oldSB.toString(), fromClause);
            log.debug((Object)sql);
            String cntSQL = String.format("SELECT COUNT(*) %s", fromClause);
            log.debug((Object)cntSQL);
            int txCnt = BasicSQLUtils.getCountAsInt(this.oldDBConn, cntSQL);
            if (this.frame != null) {
                this.frame.setProcess(0, txCnt);
            }
            log.debug((Object)txCnt);
            String pStr = String.format("INSERT INTO taxon (%s) VALUES (%s)", newSB.toString(), vl.toString());
            log.debug((Object)pStr);
            try {
                try {
                    this.stmtTx = this.newDBConn.createStatement(1004, 1007);
                    ResultSet rs1 = this.stmtTx.executeQuery(sqlStr);
                    ResultSetMetaData rsmd1 = rs1.getMetaData();
                    this.colTypes = new int[rsmd1.getColumnCount()];
                    this.colSizes = new int[rsmd1.getColumnCount()];
                    int i3 = 0;
                    while (i3 < this.colTypes.length) {
                        this.colTypes[i3] = rsmd1.getColumnType(i3 + 1);
                        this.colSizes[i3] = rsmd1.getPrecision(i3 + 1);
                        ++i3;
                    }
                    rs1.close();
                    this.stmtTx.close();
                    this.missingParentTaxonCount = 0;
                    this.lastEditedByInx = this.oldFieldToColHash.get("LastEditedBy");
                    this.modifiedByAgentInx = this.fieldToColHash.get("ModifiedByAgentID");
                    this.stmtTx = this.oldDBConn.createStatement(1004, 1007);
                    this.pStmtTx = this.newDBConn.prepareStatement(pStr);
                    int cnt = 0;
                    ResultSet rs = this.stmtTx.executeQuery(sql);
                    ResultSetMetaData rsmd = rs.getMetaData();
                    while (rs.next()) {
                        this.processRow(rs, rsmd, null);
                        if (++cnt % 1000 != 0) continue;
                        log.debug((Object)cnt);
                        if (this.frame == null) continue;
                        this.frame.setProcess(cnt);
                    }
                    rs.close();
                    if (this.frame != null) {
                        this.frame.setProcess(txCnt, txCnt);
                    }
                    String msg = String.format("Stranded Taxon (no parent): %d", this.missingParentTaxonCount);
                    this.tblWriter.log(msg);
                    log.debug((Object)msg);
                    if (this.missingParentTaxonCount > 0) {
                        if (this.frame != null) {
                            this.frame.setDesc("Renumbering the tree nodes, this may take a while...");
                        }
                        HashSet<Integer> ttdHash = new HashSet<Integer>();
                        for (CollectionInfo colInfo : CollectionInfo.getFilteredCollectionInfoList()) {
                            block31: {
                                if (ttdHash.contains(colInfo.getTaxonTreeDef().getId())) continue;
                                DataProviderSessionIFace session = null;
                                try {
                                    try {
                                        session = DataProviderFactory.getInstance().createSession();
                                        TaxonTreeDef taxonTreeDef = colInfo.getTaxonTreeDef();
                                        taxonTreeDef = (TaxonTreeDef)session.getData("FROM TaxonTreeDef WHERE id = " + taxonTreeDef.getId());
                                        sql = "SELECT TaxonID FROM taxon WHERE RankID = 0 AND TaxonTreeDefID = " + taxonTreeDef.getId();
                                        log.debug((Object)sql);
                                        Integer txRootId = BasicSQLUtils.getCount(sql);
                                        Taxon txRoot = (Taxon)session.getData("FROM Taxon WHERE id = " + txRootId);
                                        NodeNumberer nodeNumberer = new NodeNumberer(txRoot.getDefinition());
                                        nodeNumberer.doInBackground();
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                        if (session != null) {
                                            session.close();
                                        }
                                        break block31;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (session != null) {
                                        session.close();
                                    }
                                    throw throwable;
                                }
                                if (session != null) {
                                    session.close();
                                }
                            }
                            ttdHash.add(colInfo.getTaxonTreeDef().getId());
                        }
                        if (this.frame != null) {
                            this.frame.setDesc("Renumbering done.");
                        }
                    }
                    this.missingParentTaxonCount = 0;
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    try {
                        this.stmtTx.close();
                        this.pStmtTx.close();
                    }
                    catch (Exception exception) {}
                    break block33;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.stmtTx.close();
                    this.pStmtTx.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.stmtTx.close();
                this.pStmtTx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("Done.");
    }

    protected boolean processRow(ResultSet rs, ResultSetMetaData rsmd, Integer parentNodeId) throws SQLException {
        int colInx = 1;
        while (colInx <= this.cols.length) {
            this.pStmtTx.setNull(colInx, this.colTypes[colInx - 1]);
            ++colInx;
        }
        String newName = null;
        Boolean isRoot = null;
        boolean skip = false;
        int colInx2 = 1;
        while (colInx2 <= this.oldCols.length && !skip) {
            block77: {
                Integer newInx;
                String oldName;
                block74: {
                    block76: {
                        Integer agtId;
                        block75: {
                            oldName = this.oldCols[colInx2 - 1];
                            newInx = this.fieldToColHash.get(oldName);
                            if (newInx != null) break block74;
                            newName = this.oldToNewColMap.get(oldName);
                            if (newName == null) break block75;
                            newInx = this.fieldToColHash.get(newName);
                            if (newInx == -1) {
                                String msg = "Couldn't find column index for New Name[" + newName + "]";
                                log.error((Object)msg);
                                this.tblWriter.logError(msg);
                            }
                            break block74;
                        }
                        if (colInx2 != this.lastEditedByInx) break block76;
                        String lastEditedByStr = rs.getString(colInx2);
                        if (StringUtils.isNotEmpty((String)lastEditedByStr) && (agtId = Integer.valueOf(1)) != null) {
                            this.pStmtTx.setInt(this.modifiedByAgentInx, agtId);
                        } else {
                            this.pStmtTx.setInt(colInx2, 1);
                        }
                        break block77;
                    }
                    if (colInx2 == 20) break block77;
                    String msg = "Couldn't find Old Name[" + oldName + "]";
                    log.error((Object)msg);
                    this.tblWriter.logError(msg);
                }
                if (colInx2 < 6) {
                    if (isRoot == null) {
                        isRoot = rs.getInt(this.rankIdOldDBInx) == 0;
                    }
                    Integer oldID = rs.getInt(colInx2);
                    if (!rs.wasNull() || isRoot.booleanValue() && colInx2 == 2) {
                        boolean skipError = false;
                        Integer newID = null;
                        if (oldID == 612195491) {
                            oldID = 21;
                        } else if (oldID == -447245554) {
                            oldID = -1414322196;
                        }
                        if (oldName.equals("TaxonomyTypeID")) {
                            newID = 1;
                        } else if (oldName.equals("TaxonomicUnitTypeID")) {
                            String s = "SELECT RankID FROM taxonomicunittype WHERE TaxonomicUnitTypeID = " + oldID;
                            Integer rankId = BasicSQLUtils.getCount(this.oldDBConn, s);
                            log.debug((Object)s);
                            switch (rankId) {
                                case 0: {
                                    newID = 8;
                                    break;
                                }
                                case 10: {
                                    newID = 12;
                                    break;
                                }
                                case 20: {
                                    newID = 22;
                                    break;
                                }
                                case 30: {
                                    newID = 23;
                                    break;
                                }
                                case 40: {
                                    newID = 7;
                                    break;
                                }
                                case 60: {
                                    newID = 14;
                                    break;
                                }
                                case 70: {
                                    newID = 4;
                                    break;
                                }
                                case 100: {
                                    newID = 17;
                                    break;
                                }
                                case 110: {
                                    newID = 19;
                                    break;
                                }
                                case 140: {
                                    newID = 15;
                                    break;
                                }
                                case 150: {
                                    newID = 10;
                                    break;
                                }
                                case 160: {
                                    newID = 16;
                                    break;
                                }
                                case 170: {
                                    newID = 2;
                                    break;
                                }
                                case 180: {
                                    newID = 5;
                                    break;
                                }
                                case 190: {
                                    newID = 13;
                                    break;
                                }
                                case 200: {
                                    newID = 1;
                                    break;
                                }
                                case 210: {
                                    newID = 6;
                                    break;
                                }
                                case 220: {
                                    newID = 21;
                                    break;
                                }
                                case 230: {
                                    newID = 18;
                                    break;
                                }
                                case 240: {
                                    newID = 11;
                                    break;
                                }
                                case 250: {
                                    newID = 3;
                                    break;
                                }
                                case 260: {
                                    newID = 20;
                                    break;
                                }
                                case 270: {
                                    newID = 9;
                                    break;
                                }
                                default: {
                                    log.error((Object)("Error with rank: " + rankId));
                                    break;
                                }
                            }
                        } else {
                            newID = this.mappers[colInx2 - 1].get(oldID);
                            if (newID == null && (colInx2 == 5 || colInx2 == 3)) {
                                String s = "SELECT RankID FROM taxonomicunittype WHERE TaxonomicUnitTypeID = " + oldID;
                                Integer rankId = BasicSQLUtils.getCount(this.oldDBConn, s);
                                log.debug((Object)s);
                                if (rankId != null) {
                                    s = "SELECT TaxonomicUnitTypeID FROM taxonomicunittype WHERE TaxonomyTypeID = 6 && RankID = " + rankId;
                                    oldID = BasicSQLUtils.getCount(this.oldDBConn, s);
                                    log.debug((Object)s);
                                    if (oldID != null) {
                                        newID = this.mappers[colInx2 - 1].get(oldID);
                                        if (newID == null) {
                                            log.error((Object)("newID is null for Old Id " + oldID + "   colInx: " + colInx2));
                                        }
                                    } else {
                                        log.error((Object)"oldID is null");
                                    }
                                } else {
                                    log.error((Object)"rankId is null");
                                }
                            }
                        }
                        if (newID == null) {
                            if (colInx2 == 3 || colInx2 == 5) {
                                if (!isRoot.booleanValue()) {
                                    skip = true;
                                }
                            } else if (colInx2 == 2 && (parentNodeId != null || isRoot.booleanValue())) {
                                newID = parentNodeId;
                            } else {
                                boolean isDetPointToTaxon;
                                boolean wasInOldTaxonTable = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*) FROM taxonname WHERE TaxonNameID = " + oldID) > 0;
                                boolean bl = isDetPointToTaxon = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*) FROM determination WHERE TaxonNameID = " + oldID) > 0;
                                if (isDetPointToTaxon) {
                                    String msg = String.format("***** Couldn't get %s NewID [%d] from mapper for colInx[%d] In Old taxonname table: %s  WasParentID: %s  Det Using: %s", colInx2 == 2 ? "Parent" : "", oldID, colInx2, wasInOldTaxonTable ? "YES" : "no", colInx2 == 2 ? "YES" : "no", isDetPointToTaxon ? "YES" : "no");
                                    log.error((Object)msg);
                                    this.tblWriter.logError(msg);
                                }
                                skipError = true;
                                ++this.missingParentTaxonCount;
                            }
                        }
                        if (!skip) {
                            if (newID != null) {
                                this.pStmtTx.setInt(newInx, newID);
                            } else if (!skipError && !isRoot.booleanValue()) {
                                String msg = "Unable to map old TaxonNameID[" + oldID + "]";
                                log.error((Object)msg);
                                this.tblWriter.logError(msg);
                            }
                        }
                    }
                } else {
                    switch (this.colTypes[newInx - 1]) {
                        case -7: {
                            boolean val = rs.getBoolean(colInx2);
                            if (rs.wasNull()) break;
                            this.pStmtTx.setBoolean(newInx, val);
                            break;
                        }
                        case 4: {
                            int val = rs.getInt(colInx2);
                            if (rs.wasNull()) break;
                            this.pStmtTx.setInt(newInx, val);
                            break;
                        }
                        case 5: {
                            short val = rs.getShort(colInx2);
                            if (rs.wasNull()) break;
                            this.pStmtTx.setShort(newInx, val);
                            break;
                        }
                        case 93: {
                            Timestamp val = rs.getTimestamp(colInx2);
                            this.pStmtTx.setTimestamp(newInx, !rs.wasNull() ? val : null);
                            break;
                        }
                        case -1: 
                        case 12: {
                            int len = this.colSizes[newInx - 1];
                            String val = rs.getString(colInx2);
                            if (val != null && val.length() > len) {
                                newName = this.oldToNewColMap.get(oldName);
                                String msg = String.format("Concatinating field [%s] from length %d to %d String Lost:[%s]", newName, val.length(), len, val.substring(len));
                                log.debug((Object)msg);
                                this.tblWriter.logError(msg);
                                val = val.substring(0, len);
                            }
                            if (!rs.wasNull()) {
                                this.pStmtTx.setString(newInx, val);
                                break;
                            }
                            if (colInx2 != 7) break;
                            this.pStmtTx.setString(newInx, "Empty");
                            break;
                        }
                        default: {
                            log.error((Object)("Didn't support SQL Type: " + rsmd.getColumnType(colInx2)));
                        }
                    }
                }
            }
            ++colInx2;
        }
        if (!skip) {
            if (parentNodeId != null) {
                int nxtId = BasicSQLUtils.getCountAsInt("SELECT TaxonID FROM taxon ORDER BY TaxonID DESC LIMIT 0,1") + 1;
                this.pStmtTx.setInt(1, nxtId);
            }
            this.pStmtTx.setInt(this.fieldToColHash.get("Version"), 0);
            try {
                this.pStmtTx.execute();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UIRegistry.showError(ex.toString());
            }
        }
        return true;
    }

    public static void main(String[] args) {
        String path = "msulichens.html";
        try {
            TableWriter writer = new TableWriter(path, "MSU Lichens");
            MSULichensFixer msuf = new MSULichensFixer("msu_lichens", "msu_lichens_6", writer);
            msuf.doConnect();
            msuf.convertTaxonRecords();
            msuf.shutdown();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

