/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.IdHashMapper;
import edu.ku.brc.specify.conversion.IdMapperIndexIncrementerIFace;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;

public class IdTableMapper
extends IdHashMapper {
    protected String idName;
    protected IdMapperIndexIncrementerIFace indexIncremeter = null;

    public IdTableMapper(String tableName, String idName) {
        this(tableName, idName, true, true);
    }

    public IdTableMapper(String tableName, String idName, boolean doDelete, boolean doCheckOldDB) {
        this.tableName = tableName;
        this.idName = idName;
        this.mapTableName = String.valueOf(tableName) + "_" + idName;
        this.doDelete = doDelete;
        this.init(doCheckOldDB);
    }

    public IdTableMapper(String tableName, String idName, String sql) {
        this(tableName, idName, sql, true);
    }

    public IdTableMapper(String tableName, String idName, String sql, boolean doDelete) {
        this(tableName, idName, sql, doDelete, true);
    }

    public IdTableMapper(String tableName, String idName, String sql, boolean doDelete, boolean doCheckOldDB) {
        this(tableName, idName, doDelete, doCheckOldDB);
        this.sql = sql;
        log.debug((Object)("IdTableMapper created for table[" + tableName + "] idName[" + idName + "] "));
        log.debug((Object)("IdTableMapper using sql: " + sql));
    }

    public void setIndexIncremeter(IdMapperIndexIncrementerIFace indexIncremeter) {
        this.indexIncremeter = indexIncremeter;
    }

    public void clearRecords() {
        BasicSQLUtils.deleteAllRecordsFromTable(this.oldConn, this.mapTableName, BasicSQLUtils.myDestinationServerType);
    }

    public void copy(IdTableMapper dest) {
        Statement pStmt = null;
        Statement stmt = null;
        try {
            try {
                pStmt = this.oldConn.prepareStatement(String.format("INSERT INTO %s SET OldID=?, NewID=?", dest.getName()));
                stmt = this.oldConn.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT OldID, NewID FROM " + this.getName());
                while (rs.next()) {
                    pStmt.setInt(1, rs.getInt(1));
                    pStmt.setInt(2, rs.getInt(2));
                    pStmt.execute();
                }
                rs.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public void mapAllIds(String sqlArg) {
        log.debug((Object)("mapAllIds with sql: " + sqlArg));
        this.sql = sqlArg;
        int mappingCount = this.getMapCount(this.mapTableName);
        boolean bl = this.wasEmpty = mappingCount == 0;
        if (this.doDelete || mappingCount == 0) {
            BasicSQLUtils.deleteAllRecordsFromTable(this.oldConn, this.mapTableName, BasicSQLUtils.myDestinationServerType);
            if (this.frame != null) {
                String dMsg = "Mapping " + this.mapTableName;
                this.frame.setDesc(dMsg);
                log.debug((Object)dMsg);
            }
            try {
                log.debug((Object)("Executing: " + this.sql));
                PreparedStatement pStmt = this.oldConn.prepareStatement("INSERT INTO " + this.mapTableName + " VALUES (?,?)");
                Statement stmtOld = this.oldConn.createStatement(1004, 1007);
                ResultSet rs = stmtOld.executeQuery(this.sql);
                if (rs.last() && this.frame != null) {
                    this.frame.setProcess(0, rs.getRow());
                }
                if (rs.first()) {
                    int newIndex = this.initialIndex;
                    do {
                        int oldIndex = rs.getInt(1);
                        if (this.indexIncremeter != null) {
                            newIndex = this.indexIncremeter.getNextIndex();
                        }
                        pStmt.setInt(1, oldIndex);
                        pStmt.setInt(2, newIndex);
                        if (pStmt.executeUpdate() != 1) {
                            String msg = String.format("Error writing to Map table[%s] old: %d  new: %d", this.mapTableName, oldIndex, newIndex);
                            log.error((Object)msg);
                            throw new RuntimeException(msg);
                        }
                        ++newIndex;
                        if (this.frame != null) {
                            if (newIndex % 1000 != 0) continue;
                            this.frame.setProcess(newIndex);
                            continue;
                        }
                        if (newIndex % 2000 != 0) continue;
                        log.debug((Object)("Mapped " + newIndex + " records from " + this.tableName));
                    } while (rs.next());
                    log.info((Object)("Mapped " + newIndex + " records from " + this.tableName));
                } else {
                    log.info((Object)("No records to map in " + this.tableName));
                }
                rs.close();
                stmtOld.close();
                pStmt.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(IdTableMapper.class, ex);
                log.error((Object)ex);
                throw new RuntimeException(ex);
            }
        } else {
            log.debug((Object)("Skipping the build of mapper: " + this.mapTableName));
        }
        if (this.frame != null) {
            this.frame.setProcess(0, 0);
        }
    }

    public void mapAllIdsWithSQL() {
        if (!StringUtils.isNotEmpty((String)this.sql)) {
            throw new RuntimeException("The SQL strng is empty in idmapper. " + this.tableName);
        }
        this.mapAllIds(this.sql);
    }

    public void mapAllIdsNoIncrement(Integer numRecords) {
        this.mapAllIdsNoIncrement(this.sql, numRecords);
    }

    public void mapAllIdsNoIncrement(String sqlArg, Integer numRecords) {
        log.debug((Object)("mapAllIdsNoIncrement with sql: " + sqlArg));
        this.sql = sqlArg;
        int mappingCount = numRecords != null ? numRecords.intValue() : this.getMapCount(this.mapTableName);
        boolean bl = this.wasEmpty = mappingCount == 0;
        if (this.doDelete || mappingCount == 0) {
            BasicSQLUtils.deleteAllRecordsFromTable(this.oldConn, this.mapTableName, BasicSQLUtils.myDestinationServerType);
            if (this.frame != null) {
                String dMsg = "Mapping " + this.mapTableName;
                this.frame.setDesc(dMsg);
                log.debug((Object)dMsg);
            }
            try {
                log.debug((Object)("Executing: " + this.sql));
                PreparedStatement pStmt = this.oldConn.prepareStatement("INSERT INTO " + this.mapTableName + " VALUES (?,?)");
                Statement stmtOld = this.oldConn.createStatement(1004, 1007);
                ResultSet rs = stmtOld.executeQuery(this.sql);
                if (rs.last() && this.frame != null) {
                    this.frame.setProcess(0, rs.getRow());
                }
                int cnt = 0;
                if (rs.first()) {
                    do {
                        int oldIndex = rs.getInt(1);
                        int toIndex = rs.getInt(2);
                        pStmt.setInt(1, oldIndex);
                        pStmt.setInt(2, toIndex);
                        if (pStmt.executeUpdate() != 1) {
                            String msg = String.format("Error writing to Map table[%s] old: %d  new: %d", this.mapTableName, oldIndex, toIndex);
                            log.error((Object)msg);
                            throw new RuntimeException(msg);
                        }
                        if (this.frame != null) {
                            if (cnt % 1000 == 0) {
                                this.frame.setProcess(cnt);
                            }
                        } else if (cnt % 2000 == 0) {
                            log.debug((Object)("Mapped " + cnt + " records from " + this.tableName));
                        }
                        ++cnt;
                    } while (rs.next());
                    log.info((Object)("Mapped " + cnt + " records from " + this.tableName));
                } else {
                    log.info((Object)("No records to map in " + this.tableName));
                }
                rs.close();
                stmtOld.close();
                pStmt.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(IdTableMapper.class, ex);
                log.error((Object)ex);
                throw new RuntimeException(ex);
            }
        } else {
            log.debug((Object)("Skipping the build of mapper: " + this.mapTableName));
        }
        if (this.frame != null) {
            this.frame.setProcess(0, 0);
        }
    }

    @Override
    public void mapAllIds() {
        this.sql = "SELECT " + this.idName + " FROM " + this.tableName + " ORDER BY " + this.idName;
        this.mapAllIds(this.sql);
    }
}

