/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.IdHashMapper;
import edu.ku.brc.specify.conversion.IdMapperIFace;
import edu.ku.brc.specify.conversion.IdTableMapper;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIRegistry;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IdMapperMgr {
    protected static final Logger log = Logger.getLogger(IdMapperMgr.class);
    protected static IdMapperMgr idMapperMgr = new IdMapperMgr();
    protected Connection oldConn = null;
    protected Connection newConn = null;
    protected Hashtable<String, IdHashMapper> idMappers = new Hashtable();
    protected ProgressFrame frame = null;

    public void setFrame(ProgressFrame frame) {
        this.frame = frame;
    }

    public void setDBs(Connection oldConn, Connection newConn) {
        this.oldConn = oldConn;
        this.newConn = newConn;
    }

    public IdTableMapper addTableMapper(String tableName, String idName, String sql, boolean doDelete) {
        if (StringUtils.isEmpty((String)idName)) {
            String msg = String.format("The idName field is empty for table %s", tableName);
            log.error((Object)msg);
            UIRegistry.showError(msg);
            throw new RuntimeException(msg);
        }
        log.debug((Object)("addTableMapper called for table: " + tableName));
        log.debug((Object)("addTableMapper called for sql: " + sql));
        if (this.oldConn == null || this.newConn == null) {
            throw new RuntimeException("setDBs MUST be called on IdMapperMgr before using it! oldConn[" + this.oldConn + "]  newConn[" + this.newConn + "]");
        }
        String name = tableName.toLowerCase();
        List<String> fieldNames = BasicSQLUtils.getFieldNamesFromSchema(this.oldConn, name);
        if (fieldNames == null || fieldNames.size() == 0) {
            String msg = String.format("There are no fields for table %s", name);
            log.error((Object)msg);
            UIRegistry.showError(msg);
            throw new RuntimeException(msg);
        }
        if (!fieldNames.get(0).equals(idName)) {
            log.error((Object)("Table[" + name + "] doesn't have first column id[" + idName + "]"));
        }
        IdTableMapper idMapper = new IdTableMapper(name.toLowerCase(), idName, sql, doDelete);
        this.idMappers.put(idMapper.getName(), idMapper);
        idMapper.setFrame(this.frame);
        return idMapper;
    }

    public void addMapper(IdTableMapper idMapper) {
        this.idMappers.put(idMapper.getName(), idMapper);
        idMapper.setFrame(this.frame);
    }

    public IdTableMapper addTableMapper(String tableName, String idName) {
        return this.addTableMapper(tableName, idName, null, true);
    }

    public IdTableMapper addTableMapper(String tableName, String idName, boolean doDelete) {
        return this.addTableMapper(tableName, idName, null, doDelete);
    }

    public IdHashMapper addHashMapper(String tableName, String sql, boolean doDelete) {
        if (this.oldConn == null || this.newConn == null) {
            throw new RuntimeException("setDBs MUST be called on IdMapperMgr before using it!");
        }
        IdHashMapper idMapper = new IdHashMapper(tableName.toLowerCase(), sql, doDelete);
        this.idMappers.put(idMapper.getName(), idMapper);
        idMapper.setFrame(this.frame);
        return idMapper;
    }

    public IdHashMapper addHashMapper(String tableName, boolean doDelete) {
        return this.addHashMapper(tableName, null, doDelete);
    }

    public Connection getOldConnection() {
        return this.oldConn;
    }

    public Connection getNewConnection() {
        return this.newConn;
    }

    public IdMapperIFace get(String tableName, String idName) {
        return this.idMappers.get(String.valueOf(tableName.toLowerCase()) + "_" + idName);
    }

    public IdMapperIFace get(String name) {
        return this.idMappers.get(name);
    }

    public void mapForeignKey(String fkTableName, String fkIdName, String tableName, String idName) {
        IdHashMapper idMapper = this.idMappers.get(String.valueOf(tableName.toLowerCase()) + "_" + idName);
        if (idMapper != null) {
            this.idMappers.put(idMapper.getName(), idMapper);
            this.idMappers.put(String.valueOf(fkTableName.toLowerCase()) + "_" + fkIdName, idMapper);
        }
    }

    public void cleanup() {
        for (IdHashMapper mapper : this.idMappers.values()) {
            mapper.cleanup();
        }
        this.idMappers.clear();
    }

    public static IdMapperMgr getInstance() {
        return idMapperMgr;
    }

    public void dumpKeys() {
        for (String key : this.idMappers.keySet()) {
            System.out.println(key);
        }
    }
}

