/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import com.mysql.jdbc.exceptions.MySQLSyntaxErrorException;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.IdMapperIFace;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.ui.ProgressFrame;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IdHashMapper
implements IdMapperIFace {
    protected static final Logger log = Logger.getLogger(IdHashMapper.class);
    protected static TableWriter tblWriter = null;
    protected static boolean enableDelete = true;
    protected String sql = null;
    protected boolean isUsingSQL = false;
    protected String tableName;
    protected Connection oldConn;
    protected PreparedStatement prepStmt = null;
    protected String mapTableName = null;
    protected boolean showLogErrors = true;
    protected ProgressFrame frame = null;
    protected int initialIndex = 1;
    protected Vector<Integer> oldIdNullList = new Vector();
    protected boolean doDelete = true;
    protected boolean wasEmpty = true;
    protected Statement stmtNew = null;
    protected boolean debug = false;

    protected IdHashMapper() {
    }

    public IdHashMapper(String tableName) {
        this(tableName, false);
    }

    public IdHashMapper(String tableName, boolean doDelete) {
        this.tableName = tableName.toLowerCase();
        this.mapTableName = tableName;
        this.doDelete = doDelete;
        this.init(false);
    }

    public IdHashMapper(String tableName, String sql) {
        this(tableName, sql, false);
    }

    public IdHashMapper(String tableName, String sql, boolean doDelete) {
        this(tableName, doDelete);
        this.sql = sql;
        this.isUsingSQL = StringUtils.isNotEmpty((String)sql);
    }

    public int getMapCount(String tblName) {
        Statement cntStmt = null;
        ResultSet rs = null;
        try {
            Integer count = 0;
            cntStmt = this.oldConn.createStatement(1004, 1007);
            rs = cntStmt.executeQuery("select count(*) from " + tblName);
            if (rs.first() && (count = Integer.valueOf(rs.getInt(1))) == null) {
                return 0;
            }
            int n = count;
            return n;
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (cntStmt != null) {
                    cntStmt.close();
                }
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    public static void setEnableDelete(boolean enableDelete) {
        IdHashMapper.enableDelete = enableDelete;
    }

    protected void init(boolean checkOldDB) {
        block8: {
            this.oldConn = IdMapperMgr.getInstance().getOldConnection();
            int numRecs = checkOldDB ? BasicSQLUtils.getNumRecords(this.oldConn, this.tableName) : 0;
            int mappingCount = this.oldConn != null ? this.getMapCount(this.mapTableName) : 0;
            this.wasEmpty = mappingCount == 0;
            log.info((Object)(String.valueOf(numRecs) + " Records in " + this.tableName));
            try {
                if (!this.doDelete && mappingCount != 0 || !enableDelete) break block8;
                this.wasEmpty = true;
                Statement stmt = this.oldConn.createStatement();
                String str = "DROP TABLE " + this.mapTableName;
                try {
                    log.info((Object)str);
                    stmt.executeUpdate(str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                str = "CREATE TABLE `" + this.mapTableName + "` (" + "`OldID` int(11) NOT NULL default '0', " + "`NewID` int(11) NOT NULL default '0', " + " PRIMARY KEY (`OldID`) ) ENGINE=InnoDB DEFAULT CHARSET=latin1";
                if (this.debug) {
                    log.info((Object)("orig sql: " + str));
                }
                str = BasicSQLUtils.getServerTypeSpecificSQL(str, BasicSQLUtils.myDestinationServerType);
                if (this.debug) {
                    log.info((Object)("sql standard query: " + str));
                }
                stmt.executeUpdate(str);
                String str2 = "ALTER TABLE " + this.mapTableName + " ADD INDEX INX_" + this.mapTableName + " (NewID)";
                if (this.debug) {
                    log.info((Object)("orig sql: " + str2));
                }
                str2 = BasicSQLUtils.createIndexFieldStatment(this.mapTableName, BasicSQLUtils.myDestinationServerType);
                if (this.debug) {
                    log.info((Object)("sql standard query: " + str2));
                }
                stmt.executeUpdate(str2);
                stmt.clearBatch();
                stmt.close();
            }
            catch (SQLException ex) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(IdHashMapper.class, ex);
                log.error((Object)ex);
                ex.printStackTrace();
            }
        }
    }

    public void mapAllIds() {
        if (this.sql == null) {
            throw new RuntimeException("Calling mapAllIds and the SQL statement is NULL!");
        }
        int mappingCount = this.getMapCount(this.mapTableName);
        boolean bl = this.wasEmpty = mappingCount == 0;
        if (this.doDelete || mappingCount == 0) {
            if (!this.isUsingSQL) {
                BasicSQLUtils.deleteAllRecordsFromTable(this.oldConn, this.mapTableName, BasicSQLUtils.myDestinationServerType);
            }
            if (this.frame != null) {
                this.frame.setDesc("Mapping " + this.mapTableName);
            }
            try {
                if (this.frame != null) {
                    this.frame.setProcess(0, 0);
                }
                PreparedStatement pStmt = this.oldConn.prepareStatement("INSERT INTO " + this.mapTableName + " VALUES (?,?)");
                Statement stmtOld = this.oldConn.createStatement(1004, 1007);
                ResultSet rs = stmtOld.executeQuery(this.sql);
                if (rs.last() && this.frame != null) {
                    this.frame.setProcess(0, rs.getRow());
                }
                if (rs.first()) {
                    int count = 0;
                    do {
                        pStmt.setInt(1, rs.getInt(1));
                        pStmt.setInt(2, rs.getInt(2));
                        if (pStmt.executeUpdate() != 1) {
                            String msg = String.format("Error writing to Map table[%s] old: %d  new: %d", this.mapTableName, rs.getInt(1), rs.getInt(2));
                            log.error((Object)msg);
                            throw new RuntimeException(msg);
                        }
                        if (this.frame != null) {
                            if (count % 1000 == 0) {
                                this.frame.setProcess(count);
                            }
                        } else if (count % 2000 == 0) {
                            log.debug((Object)("Mapped " + count + " records from " + this.tableName));
                        }
                        ++count;
                    } while (rs.next());
                    log.info((Object)("Mapped " + count + " records from " + this.tableName));
                    if (this.frame != null) {
                        this.frame.setProcess(0, 0);
                    }
                } else {
                    log.info((Object)("No records to map in " + this.tableName));
                }
                rs.close();
                stmtOld.close();
                pStmt.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(IdHashMapper.class, ex);
                log.error((Object)("trying to execute:" + this.sql));
                log.error((Object)ex);
                throw new RuntimeException(ex);
            }
        } else {
            log.debug((Object)("Skipping the build of mapper: " + this.mapTableName));
        }
        if (this.frame != null) {
            this.frame.setProcess(0, 0);
        }
    }

    public boolean isShowLogErrors() {
        return this.showLogErrors;
    }

    @Override
    public void setShowLogErrors(boolean showLogErrors) {
        this.showLogErrors = showLogErrors;
    }

    @Override
    public void reset() {
        try {
            try {
                BasicSQLUtils.setSkipTrackExceptions(false);
                BasicSQLUtils.deleteAllRecordsFromTable(this.oldConn, this.mapTableName, BasicSQLUtils.myDestinationServerType);
            }
            catch (Exception exception) {
                BasicSQLUtils.setSkipTrackExceptions(false);
            }
        }
        finally {
            BasicSQLUtils.setSkipTrackExceptions(false);
        }
    }

    public void cleanup() {
        this.closeSQLStatements();
        if (this.mapTableName != null && this.doDelete) {
            try {
                Statement stmt = this.oldConn.createStatement(1004, 1007);
                stmt.executeUpdate("DROP TABLE `" + this.mapTableName + "`");
                stmt.close();
            }
            catch (MySQLSyntaxErrorException ex) {
                log.error((Object)ex);
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
            this.mapTableName = null;
        }
    }

    public void closeSQLStatements() {
        try {
            if (this.prepStmt != null) {
                this.prepStmt.close();
            }
            if (this.stmtNew != null) {
                this.stmtNew.close();
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        this.prepStmt = null;
        this.stmtNew = null;
    }

    @Override
    public String getName() {
        return this.mapTableName;
    }

    @Override
    public void put(int oldIndex, int newIndex) {
        if (this.wasEmpty) {
            try {
                if (this.prepStmt == null) {
                    this.prepStmt = this.oldConn.prepareStatement("INSERT INTO " + this.mapTableName + " VALUES (?,?)");
                }
                this.prepStmt.setInt(1, oldIndex);
                this.prepStmt.setInt(2, newIndex);
                if (this.prepStmt.executeUpdate() != 1) {
                    String msg = String.format("Error writing to Map table[%s] old: %d  new: %d", this.mapTableName, oldIndex, newIndex);
                    log.error((Object)msg);
                    throw new RuntimeException(msg);
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(IdHashMapper.class, ex);
                log.error((Object)ex);
            }
        }
    }

    @Override
    public Integer get(Integer oldId) {
        ResultSet rs;
        Integer newId;
        if (oldId == null) {
            return null;
        }
        try {
            if (this.stmtNew == null) {
                this.stmtNew = this.oldConn.createStatement(1004, 1007);
            }
            newId = null;
            rs = this.stmtNew.executeQuery("SELECT NewID FROM " + this.mapTableName + " WHERE OldID = " + oldId);
            if (!rs.next()) {
                this.oldIdNullList.add(oldId);
                if (this.showLogErrors) {
                    String msg = "********** Couldn't find old index [" + oldId + "] for " + this.mapTableName;
                    log.error((Object)msg);
                    if (tblWriter != null) {
                        tblWriter.logError(msg);
                    }
                }
                rs.close();
                return null;
            }
            newId = rs.getInt(1);
        }
        catch (SQLException ex) {
            String msg = "Couldn't find old index [" + oldId + "] for " + this.mapTableName;
            if (tblWriter != null) {
                tblWriter.logError(msg);
            }
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(IdHashMapper.class, ex);
            ex.printStackTrace();
            log.error((Object)ex);
            throw new RuntimeException(msg);
        }
        rs.close();
        return newId;
    }

    public Integer reverseGet(Integer newId) {
        ResultSet rs;
        Integer oldId;
        if (newId == null) {
            return null;
        }
        try {
            if (this.stmtNew == null) {
                this.stmtNew = this.oldConn.createStatement(1004, 1007);
            }
            oldId = null;
            rs = this.stmtNew.executeQuery("SELECT OldID FROM " + this.mapTableName + " WHERE NewID = " + newId);
            if (!rs.next()) {
                rs.close();
                return null;
            }
            oldId = rs.getInt(1);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            log.error((Object)ex);
            return null;
        }
        rs.close();
        return oldId;
    }

    public Vector<Integer> getOldIdNullList() {
        return this.oldIdNullList;
    }

    @Override
    public int size() {
        return BasicSQLUtils.getNumRecords(this.oldConn, this.mapTableName);
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    @Override
    public void setFrame(ProgressFrame frame) {
        this.frame = frame;
    }

    @Override
    public void setInitialIndex(int initialIndex) {
        this.initialIndex = initialIndex;
    }

    public static TableWriter getTblWriter() {
        return tblWriter;
    }

    public static void setTblWriter(TableWriter tblWriter) {
        IdHashMapper.tblWriter = tblWriter;
    }
}

