/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.IdMapperIFace;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

public class HabitatTaxonIdConverter {
    protected SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    protected SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    protected Timestamp now = new Timestamp(System.currentTimeMillis());
    protected String nowStr = this.dateTimeFormatter.format(this.now);
    protected Connection oldDBConn;
    protected Connection newDBConn;

    public HabitatTaxonIdConverter(Connection oldDBConn, Connection newDBConn) {
        this.oldDBConn = oldDBConn;
        this.newDBConn = newDBConn;
    }

    public boolean shouldConvert() {
        return BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*) FROM habitat WHERE HostTaxonID IS NOT NULL") > 0;
    }

    public boolean convert(int collectionMemberId) {
        IdMapperIFace txMapper = IdMapperMgr.getInstance().get("taxonname", "TaxonNameID");
        IdMapperIFace hbMapper = IdMapperMgr.getInstance().get("habitat", "HabitatID");
        IdMapperIFace coMapper = IdMapperMgr.getInstance().get("collectionobjectcatalog", "CollectionObjectCatalogID");
        String sql = "SELECT co.CollectionObjectID, ce.CollectingEventID, h.HabitatID, h.HostTaxonID FROM collectionobject co INNER JOIN collectingevent ce ON co.CollectingEventID = ce.CollectingEventID INNER JOIN habitat h ON ce.CollectingEventID = h.HabitatID WHERE h.HostTaxonID IS NOT NULL";
        PreparedStatement updateStmt = null;
        Statement insertStmt = null;
        PreparedStatement coUpdateStmt = null;
        Statement stmt = null;
        try {
            updateStmt = this.newDBConn.prepareStatement("UPDATE collectionobjectattribute SET RelatedTaxonID=? WHERE CollectionObjectAttributeID = ?");
            coUpdateStmt = this.newDBConn.prepareStatement("UPDATE collectionobject SET CollectionObjectAttributeID=? WHERE CollectionObjectID = ?");
            insertStmt = this.newDBConn.prepareStatement("INSERT INTO collectionobjectattribute (TimestampCreated, TimestampModified, Version, RelatedTaxonID, CollectionMemberID) VALUES(?,?,?,?,?)");
            stmt = this.oldDBConn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                int coId = rs.getInt(1);
                int hbId = rs.getInt(3);
                int txId = rs.getInt(4);
                int newCOId = coMapper.get(coId);
                boolean hasAttr = BasicSQLUtils.getCountAsInt(this.newDBConn, "SELECT CollectionObjectAttributeID FROM collectionobject WHERE CollectionObjectAttributeID IS NOT NULL AND CollectionObjectID = " + newCOId) == 1;
                int newHBId = hbMapper.get(hbId);
                int newTXId = txMapper.get(txId);
                if (hasAttr) {
                    updateStmt.setInt(1, newTXId);
                    updateStmt.setInt(2, newHBId);
                    if (updateStmt.executeUpdate() == 1) continue;
                    throw new RuntimeException("Couldn't update ColObjAttr Id[" + newHBId + "] with TaxonId [" + newTXId + "]");
                }
                insertStmt.setTimestamp(1, this.now);
                insertStmt.setTimestamp(2, this.now);
                insertStmt.setInt(3, 0);
                insertStmt.setInt(4, newTXId);
                insertStmt.setInt(5, collectionMemberId);
                if (insertStmt.executeUpdate() != 1) {
                    throw new RuntimeException("Couldn't update ColObjAttr Id[" + newHBId + "] with TaxonId [" + newTXId + "]");
                }
                int newColObjAttrId = BasicSQLUtils.getInsertedId(insertStmt);
                coUpdateStmt.setInt(1, newColObjAttrId);
                coUpdateStmt.setInt(2, newCOId);
                if (coUpdateStmt.executeUpdate() == 1) continue;
                throw new RuntimeException("Couldn't update CollectionObject Id[" + newCOId + "] with newColObjAttrId [" + newColObjAttrId + "]");
            }
            rs.close();
            return true;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
                if (insertStmt != null) {
                    insertStmt.close();
                }
                if (coUpdateStmt != null) {
                    coUpdateStmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }
}

