/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.IdMapperIFace;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import edu.ku.brc.specify.conversion.TableWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class GulfInvertsFixer {
    protected static final Logger log = Logger.getLogger(GulfInvertsFixer.class);
    protected static SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    protected static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    protected static Timestamp now = new Timestamp(System.currentTimeMillis());
    protected static String nowStr = dateTimeFormatter.format(now);
    protected Connection oldDBConn;
    protected Connection newDBConn;
    protected String oldDBName;
    protected TableWriter tblWriter;

    public GulfInvertsFixer(Connection oldDBConn, Connection newDBConn, String oldDBName, TableWriter tblWriter) {
        this.oldDBConn = oldDBConn;
        this.newDBConn = newDBConn;
        this.oldDBName = oldDBName;
        this.tblWriter = tblWriter;
    }

    protected void convert(int collectionMemberID) {
        Statement pStmtAdd = null;
        Statement pStmtUpd = null;
        Statement pStmtCEUpd = null;
        Statement stmt = null;
        IdMapperIFace ceMapper = IdMapperMgr.getInstance().get("collectingevent", "CollectingEventID");
        IdMapperIFace hbMapper = IdMapperMgr.getInstance().get("habitat", "HabitatID");
        try {
            try {
                String sql = "SELECT cc.CatalogNumber,ce.CollectingEventID,h.HabitatID,s.StratigraphyID,s.Remarks,s.Text1,s.Text2,s.YesNo1 FROM collectionobject AS co Inner Join collectionobjectcatalog AS cc ON cc.CollectionObjectCatalogID = co.CollectionObjectID Inner Join collectingevent AS ce ON co.CollectingEventID = ce.CollectingEventID Left Join habitat AS h ON ce.CollectingEventID = h.HabitatID Left Join stratigraphy AS s ON ce.CollectingEventID = s.StratigraphyID WHERE s.StratigraphyID IS NOT NULL ORDER BY ce.CollectingEventID ASC";
                log.debug((Object)sql);
                Timestamp ts = new Timestamp(Calendar.getInstance().getTime().getTime());
                stmt = this.oldDBConn.createStatement();
                pStmtUpd = this.newDBConn.prepareStatement("UPDATE collectingeventattribute SET Text4=?, Text5=?, Text6=?, YesNo1=? WHERE CollectingEventAttributeID = ?");
                pStmtCEUpd = this.newDBConn.prepareStatement("UPDATE collectingevent SET CollectingEventAttributeID=? WHERE CollectingEventID = ?");
                pStmtAdd = this.newDBConn.prepareStatement("INSERT INTO collectingeventattribute (Text4, Text5, Text6, YesNo1, TimestampCreated, TimestampModified, Version, CollectionMemberID) VALUES(?,?,?,?,?,?,?,?)");
                int counterAdd = 0;
                int counterUpd = 0;
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    Integer ceId = rs.getInt(2);
                    Integer hbId = rs.getInt(3);
                    String remarks = rs.getString(5);
                    String text1 = rs.getString(6);
                    String text2 = rs.getString(7);
                    boolean yesNo1 = rs.getBoolean(8);
                    Integer newCEID = ceMapper.get(ceId);
                    Integer newHBID = hbMapper.get(hbId);
                    if (newHBID != null) {
                        pStmtUpd.setString(1, remarks);
                        pStmtUpd.setString(2, text1);
                        pStmtUpd.setString(3, text2);
                        pStmtUpd.setBoolean(4, yesNo1);
                        pStmtUpd.setInt(5, newHBID);
                        pStmtUpd.execute();
                        ++counterUpd;
                        continue;
                    }
                    pStmtAdd.setString(1, remarks);
                    pStmtAdd.setString(2, text1);
                    pStmtAdd.setString(3, text2);
                    pStmtAdd.setBoolean(4, yesNo1);
                    pStmtAdd.setTimestamp(5, ts);
                    pStmtAdd.setTimestamp(6, ts);
                    pStmtAdd.setInt(7, 0);
                    pStmtAdd.setInt(8, collectionMemberID);
                    pStmtAdd.execute();
                    newHBID = BasicSQLUtils.getInsertedId(pStmtAdd);
                    pStmtCEUpd.setInt(1, newHBID);
                    pStmtCEUpd.setInt(2, newCEID);
                    pStmtCEUpd.execute();
                    ++counterAdd;
                }
                rs.close();
                log.debug((Object)String.format("%d updated  %d inserted", counterUpd, counterAdd));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    stmt.close();
                    pStmtUpd.close();
                    pStmtCEUpd.close();
                    pStmtAdd.close();
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                stmt.close();
                pStmtUpd.close();
                pStmtCEUpd.close();
                pStmtAdd.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
    }
}

