/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.DesertBlue;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.dbsupport.MySQLDMBSUserMgr;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.ConversionLogger;
import edu.ku.brc.specify.conversion.ConvertVerifier;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import edu.ku.brc.specify.conversion.IdTableMapper;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.specify.dbsupport.PostInsertEventListener;
import edu.ku.brc.specify.ui.AppBase;
import edu.ku.brc.specify.utilapps.BuildSampleDatabase;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class GroupPermittedToViewFixer
extends AppBase {
    private static final Logger log = Logger.getLogger(ConvertVerifier.class);
    private Pair<String, String> itUsrPwd = new Pair<Object, Object>(null, null);
    private String hostName = "localhost";
    private Pair<String, String> namePairToConvert = null;
    private boolean dbgStatus = false;
    private boolean compareTo6DBs = false;
    private Connection oldDBConn;
    private Connection newDBConn;
    private int numErrors = 0;
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private boolean debug = false;
    private static ProgressFrame progressFrame;
    private ConversionLogger convLogger = new ConversionLogger();
    private TableWriter tblWriter = null;

    public GroupPermittedToViewFixer() {
        PostInsertEventListener.setAuditOn(false);
        GroupPermittedToViewFixer.setUpSystemProperties();
        AppContextMgr.getInstance().setHasContext(true);
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        localPrefs.setDirPath(UIRegistry.getAppDataDir());
        IconManager.setApplicationClass(Specify.class);
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_datamodel.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_plugins.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_disciplines.xml"));
        this.appIcon = new JLabel("  ");
        this.setAppIcon(null);
    }

    public void fixDB(String databaseNameSource, String databaseNameDest) throws Exception {
        this.convLogger.initialize("verify", databaseNameDest);
        String title = "From " + databaseNameSource + " to " + databaseNameDest;
        System.out.println("************************************************************");
        System.out.println(title);
        System.out.println("************************************************************");
        HibernateUtil.shutdown();
        Properties initPrefs = BuildSampleDatabase.getInitializePrefs(databaseNameDest);
        String driverNameSource = "";
        String databaseHostSource = "";
        DatabaseDriverInfo driverInfoSource = null;
        String driverNameDest = "";
        String databaseHostDest = "";
        DatabaseDriverInfo driverInfoDest = null;
        log.debug((Object)"Running an non-custom MySQL convert, using old default login creds");
        driverNameSource = initPrefs.getProperty("initializer.driver", "MySQL");
        databaseHostSource = initPrefs.getProperty("initializer.host", "localhost");
        driverNameDest = initPrefs.getProperty("initializer.driver", "MySQL");
        databaseHostDest = initPrefs.getProperty("initializer.host", "localhost");
        log.debug((Object)"Custom Convert Source Properties ----------------------");
        log.debug((Object)("databaseNameSource: " + databaseNameSource));
        log.debug((Object)("driverNameSource: " + driverNameSource));
        log.debug((Object)("databaseHostSource: " + databaseHostSource));
        log.debug((Object)"Custom Convert Destination Properties ----------------------");
        log.debug((Object)("databaseNameDest: " + databaseNameDest));
        log.debug((Object)("driverNameDest: " + driverNameDest));
        log.debug((Object)("databaseHostDest: " + databaseHostDest));
        driverInfoSource = DatabaseDriverInfo.getDriver(driverNameSource);
        driverInfoDest = DatabaseDriverInfo.getDriver(driverNameDest);
        if (driverInfoSource == null) {
            throw new RuntimeException("Couldn't find Source DB driver by name [" + driverInfoSource + "] in driver list.");
        }
        if (driverInfoDest == null) {
            throw new RuntimeException("Couldn't find Destination driver by name [" + driverInfoDest + "] in driver list.");
        }
        if (driverNameDest.equals("MySQL")) {
            BasicSQLUtils.myDestinationServerType = BasicSQLUtils.SERVERTYPE.MySQL;
        } else if (driverNameDest.equals("SQLServer")) {
            BasicSQLUtils.myDestinationServerType = BasicSQLUtils.SERVERTYPE.MS_SQLServer;
        }
        if (driverNameSource.equals("MySQL")) {
            BasicSQLUtils.mySourceServerType = BasicSQLUtils.SERVERTYPE.MySQL;
        } else if (driverNameSource.equals("SQLServer")) {
            BasicSQLUtils.mySourceServerType = BasicSQLUtils.SERVERTYPE.MS_SQLServer;
        } else {
            log.error((Object)"Error setting ServerType for destination database for conversion.  Could affect the way that SQL string are generated and executed on differetn DB egnines");
        }
        String destConnectionString = driverInfoDest.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, databaseHostDest, "", (String)this.itUsrPwd.first, (String)this.itUsrPwd.second, driverNameDest);
        log.debug((Object)("attempting login to destination: " + destConnectionString));
        if (!UIHelper.tryLogin(driverInfoDest.getDriverClassName(), driverInfoDest.getDialectClassName(), databaseNameDest, destConnectionString, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second)) {
            log.error((Object)("Failed connection string: " + driverInfoSource.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, databaseHostDest, databaseNameDest, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second, driverNameDest)));
            throw new RuntimeException("Couldn't login into [" + databaseNameDest + "] " + DBConnection.getInstance().getErrorMsg());
        }
        this.convLogger.setIndexTitle(String.valueOf(databaseNameDest) + " Verify " + new SimpleDateFormat("yyy-MM-dd hh:mm:ss").format(Calendar.getInstance().getTime()));
        log.debug((Object)("DESTINATION driver class: " + driverInfoDest.getDriverClassName()));
        log.debug((Object)("DESTINATION dialect class: " + driverInfoDest.getDialectClassName()));
        log.debug((Object)("DESTINATION Connection String: " + driverInfoDest.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, databaseHostDest, databaseNameDest, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second, driverNameDest)));
        if (!UIHelper.tryLogin(driverInfoDest.getDriverClassName(), driverInfoDest.getDialectClassName(), databaseNameDest, driverInfoDest.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, databaseHostDest, databaseNameDest, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second, driverNameDest), (String)this.itUsrPwd.first, (String)this.itUsrPwd.second)) {
            throw new RuntimeException("Couldn't login into [" + databaseNameDest + "] " + DBConnection.getInstance().getErrorMsg());
        }
        String srcConStr = driverInfoSource.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, databaseHostSource, databaseNameSource, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second, driverNameSource);
        DBConnection oldDB = DBConnection.createInstance(driverInfoSource.getDriverClassName(), null, databaseNameSource, srcConStr, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second);
        this.oldDBConn = oldDB.getConnection();
        if (this.oldDBConn == null) {
            throw new RuntimeException(oldDB.getErrorMsg());
        }
        this.newDBConn = DBConnection.getInstance().createConnection();
        long startTime = System.currentTimeMillis();
        progressFrame = new ProgressFrame("Checking Catalog Objects....");
        progressFrame.adjustProgressFrame();
        progressFrame.setOverall(0);
        progressFrame.setDesc("");
        UIHelper.centerAndShow(progressFrame);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIHelper.centerAndShow(progressFrame);
            }
        });
        this.tblWriter = this.convLogger.getWriter("GPTVReport.html", "Group Permitted To View");
        IdMapperMgr.getInstance().setDBs(this.oldDBConn, this.newDBConn);
        String[] tblNamesOld = new String[]{"CollectionObject", "CollectingEvent", "Locality", "TaxonName"};
        String[] tblNamesNew = new String[]{"CollectionObject", "CollectingEvent", "Locality", "Taxon"};
        int i = 0;
        while (i < tblNamesOld.length) {
            block27: {
                String sql;
                int cnt;
                progressFrame.setDesc(tblNamesOld[i]);
                String oldTblName = tblNamesOld[i];
                String newTblName = tblNamesNew[i];
                String oldTblNameLower = oldTblName.toLowerCase();
                String newTblNameLower = newTblName.toLowerCase();
                String oldKeyName = String.valueOf(oldTblName) + "ID";
                String newKeyName = String.valueOf(newTblName) + "ID";
                int colCnt = BasicSQLUtils.getCount(this.oldDBConn, String.format("SELECT count(*) FROM `INFORMATION_SCHEMA`.`COLUMNS` WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s' AND COLUMN_NAME = 'GroupPermittedToView'", databaseNameSource, oldTblName));
                if (colCnt == 1 && (cnt = BasicSQLUtils.getCount(this.oldDBConn, sql = String.format("SELECT COUNT(*) FROM %s.%s WHERE GroupPermittedToView is NOT NULL", databaseNameSource, oldTblName)).intValue()) > 0) {
                    this.tblWriter.log(String.format("%s %s  Count: %d", databaseNameSource, oldTblNameLower, cnt));
                    int totalCnt = cnt;
                    int cnvCnt = 0;
                    progressFrame.setProcess(0, cnt);
                    IdMapperMgr.getInstance().addTableMapper(oldTblNameLower, oldKeyName, false);
                    IdTableMapper mapper = (IdTableMapper)IdMapperMgr.getInstance().get(oldTblNameLower, oldKeyName);
                    Statement pStmt = null;
                    try {
                        try {
                            pStmt = this.newDBConn.prepareStatement(String.format("UPDATE %s SET Visibility=? WHERE %s = ?", newTblNameLower, newKeyName));
                            cnt = 0;
                            sql = String.format("SELECT %s,GroupPermittedToView FROM %s.%s WHERE GroupPermittedToView is NOT NULL", oldKeyName, databaseNameSource, oldTblName);
                            for (Object[] col : BasicSQLUtils.query(sql)) {
                                Integer oldId = (Integer)col[0];
                                Integer newId = mapper.get(oldId);
                                if (newId != null) {
                                    Integer gptv = (Integer)col[1];
                                    try {
                                        pStmt.setInt(1, gptv);
                                        pStmt.setInt(2, newId);
                                        pStmt.execute();
                                        ++cnvCnt;
                                    }
                                    catch (SQLException ex) {
                                        ex.printStackTrace();
                                    }
                                } else {
                                    this.tblWriter.logError("No mapping for Old Id " + oldId);
                                }
                                if (++cnt % 10 != 0) continue;
                                progressFrame.setProcess(cnt);
                            }
                            progressFrame.setProcess(totalCnt);
                            this.tblWriter.log(String.format("%s %s  Converted: %d", databaseNameSource, oldTblNameLower, cnvCnt));
                        }
                        catch (SQLException ex) {
                            ex.printStackTrace();
                            if (pStmt != null) {
                                pStmt.close();
                            }
                            break block27;
                        }
                    }
                    catch (Throwable throwable) {
                        if (pStmt != null) {
                            pStmt.close();
                        }
                        throw throwable;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                    }
                }
            }
            ++i;
        }
        this.newDBConn.close();
        this.oldDBConn.close();
        File indexFile = this.convLogger.closeAll();
        log.info((Object)"Done.");
        progressFrame.setVisible(false);
        AttachmentUtils.openURI(indexFile.toURI());
        System.exit(0);
    }

    private boolean selectedDBsToConvert() {
        JTextField itUserNameTF = UIHelper.createTextField("root", 15);
        JPasswordField itPasswordTF = UIHelper.createPasswordField("", 15);
        JTextField hostNameTF = UIHelper.createTextField("localhost", 15);
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,p,f:p:g", "p,2px,p,2px,p,8px,p"));
        int y = 1;
        pb.addSeparator("IT User", cc.xyw(1, y, 4));
        pb.add((Component)UIHelper.createLabel("Username:", 4), cc.xy(1, y += 2));
        pb.add((Component)itUserNameTF, cc.xy(3, y));
        pb.add((Component)UIHelper.createLabel("Password:", 4), cc.xy(1, y += 2));
        pb.add((Component)itPasswordTF, cc.xy(3, y));
        pb.add((Component)UIHelper.createLabel("Host Name:", 4), cc.xy(1, y += 2));
        pb.add((Component)hostNameTF, cc.xy(3, y));
        y += 2;
        PanelBuilder panel = new PanelBuilder(new FormLayout("f:p:g,10px,f:p:g", "f:p:g"));
        panel.add((Component)new JLabel(IconManager.getIcon("SpecifyLargeIcon")), cc.xy(1, 1));
        panel.add((Component)pb.getPanel(), cc.xy(3, 1));
        CustomDialog dlg = new CustomDialog(null, "Database Info", true, panel.getPanel());
        ((JPanel)dlg.getContentPanel()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        UIHelper.centerAndShow(dlg);
        dlg.dispose();
        if (dlg.isCancelled()) {
            return false;
        }
        this.hostName = hostNameTF.getText();
        this.itUsrPwd.first = itUserNameTF.getText();
        this.itUsrPwd.second = ((JTextComponent)itPasswordTF).getText();
        return true;
    }

    private Pair<String, String> chooseTable() throws SQLException {
        block11: {
            JList newList;
            JList oldlist;
            block12: {
                MySQLDMBSUserMgr mgr = new MySQLDMBSUserMgr();
                Vector<DBNamePair> availOldPairs = new Vector<DBNamePair>();
                final Vector<DBNamePair> availNewPairs = new Vector<DBNamePair>();
                if (!mgr.connectToDBMS((String)this.itUsrPwd.first, (String)this.itUsrPwd.second, this.hostName)) break block11;
                BasicSQLUtils.setSkipTrackExceptions(true);
                Connection conn = mgr.getConnection();
                Vector<Object[]> dbNames = BasicSQLUtils.query(conn, "show databases");
                for (Object[] row : dbNames) {
                    System.err.println("Setting [" + row[0].toString() + "] ");
                    conn.setCatalog(row[0].toString());
                    boolean isSp5 = false;
                    boolean isSp6 = false;
                    Vector<Object[]> tables = BasicSQLUtils.query(conn, "show tables");
                    for (Object[] tblRow : tables) {
                        if (row[0].toString().equals("debugdb")) {
                            System.err.println(tblRow[0].toString());
                        }
                        if (tblRow[0].toString().equals("usysversion")) {
                            isSp5 = true;
                            break;
                        }
                        if (!tblRow[0].toString().equals("gift")) continue;
                        isSp6 = true;
                        break;
                    }
                    if (isSp5 || isSp6) {
                        String collName = null;
                        Vector<Object[]> tableDesc = BasicSQLUtils.query(conn, "SELECT CollectionName FROM collection");
                        if (tableDesc.size() > 0) {
                            collName = tableDesc.get(0)[0].toString();
                        }
                        if (collName == null) continue;
                        if (isSp5) {
                            availOldPairs.add(new DBNamePair(collName, row[0].toString()));
                        } else {
                            availNewPairs.add(new DBNamePair(collName, row[0].toString()));
                        }
                    }
                    System.err.println("isSp5 [" + isSp5 + "] isSp6 [" + isSp6 + "] ");
                }
                Comparator<Pair<String, String>> comparator = new Comparator<Pair<String, String>>(){

                    @Override
                    public int compare(Pair<String, String> o1, Pair<String, String> o2) {
                        return ((String)o1.second).compareTo((String)o2.second);
                    }
                };
                Collections.sort(availOldPairs, comparator);
                Collections.sort(availNewPairs, comparator);
                mgr.close();
                BasicSQLUtils.setSkipTrackExceptions(false);
                oldlist = new JList(availOldPairs);
                newList = new JList(availNewPairs);
                CellConstraints cc = new CellConstraints();
                PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,10px,f:p:g", "p,2px,f:p:g,4px,p"));
                pb.addSeparator("Specify 5 Databases", cc.xy(1, 1));
                pb.add((Component)UIHelper.createScrollPane(oldlist), cc.xy(1, 3));
                pb.addSeparator("Specify 6 Databases", cc.xy(3, 1));
                pb.add((Component)UIHelper.createScrollPane(newList), cc.xy(3, 3));
                ListSelectionListener oldDBListener = new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        DBNamePair pair;
                        if (!e.getValueIsAdjusting() && (pair = (DBNamePair)oldlist.getSelectedValue()) != null) {
                            int index = 0;
                            for (DBNamePair p : availNewPairs) {
                                if (((String)p.second).startsWith((String)pair.second)) {
                                    final int inx = index;
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            newList.setSelectedIndex(inx);
                                            newList.ensureIndexIsVisible(inx);
                                        }
                                    });
                                }
                                ++index;
                            }
                        }
                    }
                };
                oldlist.getSelectionModel().addListSelectionListener(oldDBListener);
                pb.setDefaultDialogBorder();
                final CustomDialog dlg = new CustomDialog(null, "Select a DB to Verify", true, pb.getPanel());
                ListSelectionListener lsl = new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (!e.getValueIsAdjusting()) {
                            dlg.getOkBtn().setEnabled(oldlist.getSelectedIndex() > -1);
                        }
                    }
                };
                oldlist.addListSelectionListener(lsl);
                newList.addListSelectionListener(lsl);
                oldlist.setSelectionMode(0);
                newList.setSelectionMode(0);
                MouseAdapter listMA = new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() == 2) {
                            dlg.getOkBtn().setEnabled(oldlist.getSelectedIndex() > -1 && newList.getSelectedIndex() > -1);
                            dlg.getOkBtn().doClick();
                        }
                    }
                };
                oldlist.addMouseListener(listMA);
                newList.addMouseListener(listMA);
                dlg.createUI();
                dlg.pack();
                dlg.pack();
                dlg.setVisible(true);
                if (!dlg.isCancelled()) break block12;
                return null;
            }
            try {
                DBNamePair oldPair = (DBNamePair)oldlist.getSelectedValue();
                this.namePairToConvert = (DBNamePair)newList.getSelectedValue();
                this.namePairToConvert.first = (String)oldPair.second;
                return this.namePairToConvert;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void main(String[] args) {
        UIRegistry.setAppName("Specify");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GroupPermittedToViewFixer cv;
                try {
                    if (!System.getProperty("os.name").equals("Mac OS X")) {
                        UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
                        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new DesertBlue());
                    }
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(ConvertVerifier.class, e);
                    log.error((Object)"Can't change L&F: ", (Throwable)e);
                }
                if ((cv = new GroupPermittedToViewFixer()).selectedDBsToConvert()) {
                    try {
                        final Pair pair = cv.chooseTable();
                        if (pair != null) {
                            SwingWorker workerThread = new SwingWorker(){

                                @Override
                                public Object construct() {
                                    try {
                                        cv.fixDB((String)pair.first, (String)pair.second);
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                    return null;
                                }

                                @Override
                                public void finished() {
                                }
                            };
                            workerThread.start();
                        } else {
                            JOptionPane.showMessageDialog(null, "The GroupPermittedToViewFixer was unable to login", "Not Logged In", 0);
                            System.exit(0);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        System.exit(0);
                    }
                }
            }
        });
    }

    class DBNamePair
    extends Pair<String, String> {
        public DBNamePair() {
        }

        public DBNamePair(String first, String second) {
            super(first, second);
        }

        @Override
        public String toString() {
            return String.valueOf((String)this.second) + "   (" + (String)this.first + ")";
        }
    }
}

