/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.BrowseBtnPanel;
import edu.ku.brc.af.ui.db.PickListItemIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.dbsupport.AttributeIFace;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.config.init.DataBuilder;
import edu.ku.brc.specify.conversion.AttrUtils;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.BasicSQLUtilsMapValueIFace;
import edu.ku.brc.specify.conversion.CollectionInfo;
import edu.ku.brc.specify.conversion.CollectionInfoModel;
import edu.ku.brc.specify.conversion.ConversionLogger;
import edu.ku.brc.specify.conversion.ConvertTaxonHelper;
import edu.ku.brc.specify.conversion.ConvertVerifier;
import edu.ku.brc.specify.conversion.FieldMetaData;
import edu.ku.brc.specify.conversion.IdHashMapper;
import edu.ku.brc.specify.conversion.IdMapperIFace;
import edu.ku.brc.specify.conversion.IdMapperIndexIncrementerIFace;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import edu.ku.brc.specify.conversion.IdTableMapper;
import edu.ku.brc.specify.conversion.PartialDateConv;
import edu.ku.brc.specify.conversion.TableDuplicator;
import edu.ku.brc.specify.conversion.TableStats;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.specify.conversion.TimeLogger;
import edu.ku.brc.specify.datamodel.Agent;
import edu.ku.brc.specify.datamodel.AttributeDef;
import edu.ku.brc.specify.datamodel.AutoNumberingScheme;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.CollectionObjectAttr;
import edu.ku.brc.specify.datamodel.DataType;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.Geography;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.datamodel.GeographyTreeDefItem;
import edu.ku.brc.specify.datamodel.GeologicTimePeriod;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDef;
import edu.ku.brc.specify.datamodel.GeologicTimePeriodTreeDefItem;
import edu.ku.brc.specify.datamodel.LithoStrat;
import edu.ku.brc.specify.datamodel.LithoStratTreeDef;
import edu.ku.brc.specify.datamodel.LithoStratTreeDefItem;
import edu.ku.brc.specify.datamodel.PickList;
import edu.ku.brc.specify.datamodel.PickListItem;
import edu.ku.brc.specify.datamodel.PrepType;
import edu.ku.brc.specify.datamodel.SpLocaleContainer;
import edu.ku.brc.specify.datamodel.Storage;
import edu.ku.brc.specify.datamodel.StorageTreeDef;
import edu.ku.brc.specify.datamodel.StorageTreeDefItem;
import edu.ku.brc.specify.datamodel.Treeable;
import edu.ku.brc.specify.treeutils.TreeFactory;
import edu.ku.brc.specify.treeutils.TreeHelper;
import edu.ku.brc.specify.utilapps.BuildSampleDatabase;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.ToggleButtonChooserDlg;
import edu.ku.brc.ui.ToggleButtonChooserPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class GenericDBConversion
implements IdMapperIndexIncrementerIFace {
    public static int defaultVisibilityLevel = 0;
    protected static final Logger log = Logger.getLogger(GenericDBConversion.class);
    protected static StringBuilder strBuf = new StringBuilder("");
    protected static SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    protected static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    protected static Timestamp now = new Timestamp(System.currentTimeMillis());
    protected static String nowStr = dateTimeFormatter.format(now);
    protected String oldDBName = "";
    protected String newDBName = "";
    protected IdMapperMgr idMapperMgr;
    protected Connection oldDBConn;
    protected Connection newDBConn;
    protected String[] standardDataTypes = new String[]{"Plant", "Animal", "Mineral", "Fungi"};
    protected Hashtable<String, Integer> dataTypeNameIndexes = new Hashtable();
    protected Hashtable<String, Integer> dataTypeNameToIds = new Hashtable();
    protected Hashtable<Integer, Vector<Integer>> catSeriesToNewCollectionID = new Hashtable();
    protected Hashtable<String, TableStats> tableStatHash = new Hashtable();
    protected static boolean shouldCreateMapTables = true;
    protected static boolean shouldDeleteMapTables = true;
    protected static boolean doDeleteAllMappings = false;
    protected SpecifyAppContextMgr appContextMgr = new SpecifyAppContextMgr();
    protected ProgressFrame frame = null;
    protected boolean hasFrame = false;
    protected Hashtable<String, Integer> collectionHash = new Hashtable();
    protected Hashtable<String, String> prefixHash = new Hashtable();
    protected Hashtable<String, Integer> catNumSchemeHash = new Hashtable();
    protected Hashtable<DisciplineType.STD_DISCIPLINES, Pair<Integer, Boolean>> dispToObjTypeHash = new Hashtable();
    protected boolean isSharingCollectingEvents = false;
    protected Vector<CollectionInfo> collectionInfoList;
    protected Vector<CollectionInfo> collectionInfoShortList;
    protected HashMap<Integer, AutoNumberingScheme> catSeriesToAutoNumSchemeHash = new HashMap();
    protected Hashtable<String, LithoStrat> lithoStratHash = new Hashtable();
    protected Session session;
    protected Agent creatorAgent;
    protected Agent modifierAgent;
    protected Hashtable<String, BasicSQLUtilsMapValueIFace> columnValueMapper = new Hashtable();
    protected Division division = null;
    protected Integer curDivisionID = 0;
    protected Integer curDisciplineID = 0;
    protected Integer curCollectionID = 0;
    protected Integer curAgentCreatorID = 0;
    protected Integer curAgentModifierID = 0;
    protected Integer colObjTypeID = null;
    protected int globalIdNumber = 1;
    protected TaxonTypeHolder taxonTypeHolder = null;
    protected DisciplineType disciplineType = null;
    protected ConversionLogger convLogger = null;
    protected SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private Hashtable<Integer, Collection> collIdToCollObj = new Hashtable();
    private static final HashMap<String, Integer> oldAgentHash = new HashMap();
    private static final HashSet<String> oldUnmappedAgentNames = new HashSet();
    private static IdMapperIFace agentIdMapper = null;
    private static Object[] oldAgentPairs = null;
    private static final HashMap<Integer, Agent> agentHash = new HashMap();

    public GenericDBConversion(Connection oldDBConn, Connection newDBConn, String oldDBName, ConversionLogger convLogger) {
        this.oldDBConn = oldDBConn;
        this.newDBConn = newDBConn;
        this.convLogger = convLogger;
        this.idMapperMgr = IdMapperMgr.getInstance();
        this.loadAgentIdMappings();
        int[] nArray = new int[12];
        nArray[0] = 10;
        nArray[1] = 14;
        nArray[2] = 17;
        nArray[3] = 18;
        nArray[4] = 15;
        nArray[5] = 9;
        nArray[6] = 12;
        nArray[7] = 13;
        nArray[8] = 16;
        nArray[9] = 19;
        int[] objTypes = nArray;
        boolean[] blArray = new boolean[12];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        boolean[] isEmbdded = blArray;
        DisciplineType.STD_DISCIPLINES[] sTD_DISCIPLINESArray = DisciplineType.STD_DISCIPLINES.values();
        int n = sTD_DISCIPLINESArray.length;
        int n2 = 0;
        while (n2 < n) {
            DisciplineType.STD_DISCIPLINES dt = sTD_DISCIPLINESArray[n2];
            int i = dt.ordinal();
            this.dispToObjTypeHash.put(dt, new Pair<Integer, Boolean>(objTypes[i], isEmbdded[i]));
            ++n2;
        }
    }

    public Integer findColObjTypeID() {
        Integer colObjTypeCnt = BasicSQLUtils.getCount(this.oldDBConn, "SELECT COUNT(*) FROM collectionobject WHERE CollectionObjectTypeID > 8 AND CollectionObjectTypeID < 20 ");
        if (colObjTypeCnt != null && colObjTypeCnt > 0) {
            String sql = "SELECT CollectionObjectTypeID, CollectionObjectTypeName, Category FROM collectionobjecttype WHERE CollectionObjectTypeID in (SELECT DISTINCT CollectionObjectTypeID FROM collectionobject WHERE CollectionObjectTypeID > 8 AND CollectionObjectTypeID < 20)";
            Vector<TaxonTypeHolder> datas = new Vector<TaxonTypeHolder>();
            Vector<Object[]> rows = BasicSQLUtils.query(this.oldDBConn, sql);
            for (Object[] row : rows) {
                TaxonTypeHolder tth = new TaxonTypeHolder(row);
                datas.add(tth);
            }
            TaxonTypeHolder selectedTTH = null;
            if (datas.size() > 1) {
                ToggleButtonChooserDlg dlg = new ToggleButtonChooserDlg(null, "Choose a Collection Object Type", datas, ToggleButtonChooserPanel.Type.RadioButton);
                dlg.setVisible(true);
                if (!dlg.isCancelled()) {
                    selectedTTH = (TaxonTypeHolder)dlg.getSelectedObject();
                }
            } else if (datas.size() == 1) {
                selectedTTH = (TaxonTypeHolder)datas.get(0);
            }
            if (selectedTTH != null) {
                return selectedTTH.getId();
            }
        }
        return null;
    }

    private void fixIdaho() {
        try {
            String s;
            String prefix = "CIDA";
            HashSet<Integer> catSeriesOldIds = new HashSet<Integer>();
            HashSet<Integer> catSeriesDefOldIds = new HashSet<Integer>();
            System.out.println(String.format("%11s %11s %11s %11s %11s %11s %16s %11s ", "CatSerDef", "CatSeries", "ColObjType", "TaxoNameId", "TaxonType", "TaxUnitType", "COT Name", "CO Cnt"));
            HashMap<String, ArrayList<CollectionInfo>> hashTaxonRootToCI = new HashMap<String, ArrayList<CollectionInfo>>();
            for (CollectionInfo ci : this.collectionInfoList) {
                System.out.print(String.format("%11d %11d %11d %11d %11d %11d %16s %11d ", ci.getCatSeriesDefId(), ci.getCatSeriesId(), ci.getColObjTypeId(), ci.getTaxonNameId(), ci.getTaxonomyTypeId(), ci.getTaxonomicUnitTypeID(), ci.getColObjTypeName(), ci.getColObjCnt()));
                String key = String.format("%d,%d", ci.getTaxonNameId(), ci.getColObjTypeId());
                ArrayList<CollectionInfo> list = (ArrayList<CollectionInfo>)hashTaxonRootToCI.get(key);
                if (list == null) {
                    list = new ArrayList<CollectionInfo>();
                    System.out.print(key);
                    hashTaxonRootToCI.put(key, list);
                }
                list.add(ci);
                System.out.println();
            }
            String dateStr = "2011-06-30 00:00:00";
            String sql1 = "INSERT INTO catalogseries (CatalogSeriesID, CollectionID, SeriesName, CatalogSeriesPrefix, Remarks, TimestampModified, TimestampCreated, LastEditedBy) VALUES (%d,%d,'%s','%s','%s','%s','%s','%s')";
            String sql2 = "INSERT INTO catalogseriesdefinition (CatalogSeriesDefinitionID, CatalogSeriesID, ObjectTypeID, Remarks,TimestampModified,TimestampCreated,LastEditedBy) VALUES (%d,%d,'%s','%s','%s','%s','%s')";
            String sql3 = "UPDATE collectionobjectcatalog SET CatalogSeriesID=%d WHERE CatalogSeriesID=%d AND CollectionObjectTypeID=%d";
            String sql4 = "SELECT COUNT(*) FROM collectionobjectcatalog WHERE CatalogSeriesID=%d AND CollectionObjectTypeID=%d";
            int catSeriesID = 1;
            int catSeriesDefID = 1;
            HashMap txRootToObjsIdHash = new HashMap();
            for (String key : hashTaxonRootToCI.keySet()) {
                ArrayList ciList = (ArrayList)hashTaxonRootToCI.get(key);
                int taxRootID = ((CollectionInfo)ciList.get(0)).getTaxonNameId();
                System.out.println(String.format("\n-------------- For TaxonId: %d (%s) ---------------", ((CollectionInfo)ciList.get(0)).getTaxonNameId(), ((CollectionInfo)ciList.get(0)).getTaxonName()));
                for (CollectionInfo ci : ciList) {
                    System.out.println(String.format("    %s - %s", ci.getTaxonNameId(), ci.getTaxonName()));
                }
                System.out.println();
                int colObjTypeID = -1;
                StringBuilder combinedCatSeriesName = new StringBuilder();
                String catSeriesName = null;
                for (CollectionInfo ci : ciList) {
                    String sql = "SELECT CollectionObjectTypeName FROM collectionobjecttype WHERE CollectionObjectTypeID = " + ci.getColObjTypeId();
                    String objTypeName = (String)BasicSQLUtils.querySingleObj(this.oldDBConn, sql);
                    if (combinedCatSeriesName.length() > 0) {
                        combinedCatSeriesName.append('|');
                    }
                    combinedCatSeriesName.append(objTypeName);
                    if (combinedCatSeriesName.length() > 50) {
                        combinedCatSeriesName.setLength(50);
                    }
                    catSeriesOldIds.add(ci.getCatSeriesId());
                    catSeriesDefOldIds.add(ci.getCatSeriesDefId());
                    if (catSeriesName != null && (StringUtils.containsIgnoreCase((String)catSeriesName, (String)"paleo") || !StringUtils.containsIgnoreCase((String)objTypeName, (String)"paleo"))) continue;
                    catSeriesName = objTypeName;
                    colObjTypeID = ci.getColObjTypeId();
                }
                System.out.println("Combined Series Name: [" + combinedCatSeriesName + "]");
                System.out.println("New Cat Series Name:  [" + catSeriesName + "]");
                System.out.println("New Cat Series ID:    [" + catSeriesID + "]");
                System.out.println("New Cat Series Def ID:[" + catSeriesDefID + "]");
                System.out.println("Col Obj Type:         [" + colObjTypeID + "]");
                String insert = String.format(sql1, catSeriesID, 0, catSeriesName, prefix, "", dateStr, dateStr, "conversion");
                System.out.println(insert);
                BasicSQLUtils.update(this.oldDBConn, insert);
                insert = String.format(sql2, catSeriesDefID, catSeriesID, colObjTypeID, "", dateStr, dateStr, "conversion");
                System.out.println(insert);
                BasicSQLUtils.update(this.oldDBConn, insert);
                HashSet<Integer> colObjIDHash = new HashSet<Integer>();
                for (CollectionInfo ci : ciList) {
                    int cnt = BasicSQLUtils.getCountAsInt(this.oldDBConn, String.format(sql4, ci.getCatSeriesId(), ci.getColObjTypeId()));
                    String updateStr = String.format(sql3, catSeriesID, ci.getCatSeriesId(), ci.getColObjTypeId());
                    System.out.println("Count: " + cnt + " -> " + updateStr);
                    BasicSQLUtils.update(this.oldDBConn, updateStr);
                    colObjIDHash.add(ci.getColObjTypeId());
                    String sql = "SELECT DISTINCT co2.CollectionObjectTypeID FROM collectionobject co1 INNER JOIN collectionobject co2 ON co1.CollectionObjectID = co2.DerivedFromID WHERE co1.CollectionObjectTypeID = " + ci.getColObjTypeId();
                    for (Integer cotId : BasicSQLUtils.queryForInts(this.oldDBConn, sql)) {
                        cnt = BasicSQLUtils.getCountAsInt(this.oldDBConn, String.format(sql4, ci.getCatSeriesId(), cotId));
                        updateStr = String.format(sql3, catSeriesID, ci.getCatSeriesId(), cotId);
                        System.out.println("Count: " + cnt + " -> " + updateStr);
                        BasicSQLUtils.update(this.oldDBConn, updateStr);
                        colObjIDHash.add(cotId);
                    }
                }
                txRootToObjsIdHash.put(taxRootID, colObjIDHash);
                ++catSeriesID;
                ++catSeriesDefID;
            }
            this.duplicateTaxonTree(6, 8, 3, 17, "PaleoBotany");
            this.duplicateTaxonTree(7, 9, 5, 18, "Invert Paleo");
            for (Integer id : catSeriesDefOldIds) {
                s = "DELETE FROM catalogseriesdefinition WHERE CatalogSeriesDefinitionID = " + id;
                log.debug((Object)s);
                BasicSQLUtils.update(this.oldDBConn, s);
            }
            for (Integer id : catSeriesOldIds) {
                s = "DELETE FROM catalogseries WHERE CatalogSeriesID = " + id;
                log.debug((Object)s);
                BasicSQLUtils.update(this.oldDBConn, s);
            }
            CollectionInfo.getCollectionInfoList().clear();
            this.collectionInfoList = CollectionInfo.getCollectionInfoList(this.oldDBConn, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void duplicateTaxonTree(int oldTaxonomyTypeID, int newTaxonomyTypeID, int kingdom, int curColObjTypeID, String taxonTypeName) {
        try {
            String dateStr = "2011-06-30 00:00:00";
            String postFix = Integer.toString(oldTaxonomyTypeID);
            System.out.println("----------------------------------------");
            System.out.println(String.format("Copying 'taxonomicunittype' Old TaxonomyTypeID %d to New TaxonomyTypeID %d\n", oldTaxonomyTypeID, newTaxonomyTypeID));
            IdMapperMgr.getInstance().setDBs(this.oldDBConn, this.newDBConn);
            TableDuplicator taxonomicunittypeDup = new TableDuplicator(this.oldDBConn, "taxonomicunittype", "TaxonomicUnitTypeID", "TaxonomyTypeID = " + oldTaxonomyTypeID, "RankID", postFix);
            taxonomicunittypeDup.initialize();
            taxonomicunittypeDup.duplicate();
            TableDuplicator taxonnameDup = new TableDuplicator(this.oldDBConn, "taxonname", "TaxonNameID", "TaxonomyTypeID = " + oldTaxonomyTypeID, "RankID", postFix);
            taxonnameDup.initialize();
            taxonnameDup.duplicate();
            String sql = String.format("INSERT INTO taxonomytype (TaxonomyTypeID, KingdomID, TaxonomyTypeName, TreeInfoUpToDate) VALUES(%d, %d, '%s', 1)", newTaxonomyTypeID, kingdom, taxonTypeName);
            System.out.println(sql);
            BasicSQLUtils.update(this.oldDBConn, sql);
            sql = String.format("UPDATE taxonomicunittype SET TaxonomyTypeID = %d WHERE TaxonomicUnitTypeID = ?", newTaxonomyTypeID);
            System.out.println(sql);
            PreparedStatement pStmt = this.oldDBConn.prepareStatement(sql);
            Statement stmt = this.oldDBConn.createStatement();
            sql = "SELECT NewID FROM " + taxonomicunittypeDup.getMapperName();
            System.out.println(sql);
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                pStmt.setInt(1, rs.getInt(1));
                System.out.println(String.format("UPDATE taxonomicunittype SET TaxonomyTypeID = %d WHERE TaxonomicUnitTypeID = %d", newTaxonomyTypeID, rs.getInt(1)));
                pStmt.executeUpdate();
            }
            rs.close();
            pStmt.close();
            int cnt = 0;
            pStmt = this.oldDBConn.prepareStatement(String.format("UPDATE taxonname SET TaxonomyTypeID = %d WHERE TaxonNameID = ?", newTaxonomyTypeID));
            sql = "SELECT NewID FROM " + taxonnameDup.getMapperName();
            System.out.println(sql);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                pStmt.setInt(1, rs.getInt(1));
                pStmt.executeUpdate();
                if (++cnt % 2000 != 0) continue;
                System.out.println(cnt);
                break;
            }
            rs.close();
            pStmt.close();
            IdMapperIFace taxonMapper = taxonnameDup.getMapper();
            IdMapperIFace taxUnitTypeMapper = taxonomicunittypeDup.getMapper();
            cnt = 0;
            pStmt = this.oldDBConn.prepareStatement("UPDATE taxonname SET ParentTaxonNameID=?, AcceptedID=?, TaxonomicUnitTypeID=? WHERE TaxonNameID = ?");
            rs = stmt.executeQuery("SELECT TaxonNameID, ParentTaxonNameID, AcceptedID, TaxonomicUnitTypeID FROM taxonname WHERE TaxonomyTypeID = " + newTaxonomyTypeID);
            while (rs.next()) {
                Integer newId;
                int taxonId = rs.getInt(1);
                Integer parentId = rs.getInt(2);
                Integer acceptId = rs.getInt(3);
                Integer tutId = rs.getInt(4);
                if (parentId == null || parentId == 0) {
                    pStmt.setObject(1, null);
                } else {
                    newId = taxonMapper.get(parentId);
                    if (newId != null) {
                        pStmt.setInt(1, newId);
                    } else {
                        pStmt.setObject(1, null);
                    }
                }
                if (acceptId == null || acceptId == 0) {
                    pStmt.setObject(2, null);
                } else {
                    newId = taxonMapper.get(acceptId);
                    if (newId != null) {
                        pStmt.setInt(2, newId);
                    } else {
                        pStmt.setObject(2, null);
                    }
                }
                pStmt.setInt(3, taxUnitTypeMapper.get(tutId));
                pStmt.setInt(4, taxonId);
                pStmt.executeUpdate();
                if (++cnt % 2000 != 0) continue;
                System.out.println(cnt);
                break;
            }
            rs.close();
            pStmt.close();
            stmt.close();
            taxonomicunittypeDup.cleanup();
            taxonnameDup.cleanup();
            sql = String.format("SELECT CollectionTaxonomyTypesID FROM collectiontaxonomytypes WHERE BiologicalObjectTypeID = %d AND TaxonomyTypeID = %d", curColObjTypeID, oldTaxonomyTypeID);
            System.out.println(sql);
            int collectiontaxonomytypesID = BasicSQLUtils.getCountAsInt(this.oldDBConn, sql);
            sql = String.format("UPDATE collectiontaxonomytypes SET TaxonomyTypeID = %d WHERE CollectionTaxonomyTypesID = %d", newTaxonomyTypeID, collectiontaxonomytypesID);
            System.out.println(sql);
            BasicSQLUtils.update(this.oldDBConn, sql);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public CollectionResultType initialize() {
        this.collectionInfoList = CollectionInfo.getCollectionInfoList(this.oldDBConn, false);
        if (this.collectionInfoList == null) {
            if (CollectionInfo.isAskForFix()) {
                if (ConvertTaxonHelper.fixTaxonomicUnitType(this.oldDBConn)) {
                    this.collectionInfoList = CollectionInfo.getCollectionInfoList(this.oldDBConn, true);
                } else {
                    try {
                        this.oldDBConn.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            } else {
                try {
                    this.oldDBConn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                System.exit(0);
            }
        }
        this.collectionInfoShortList = CollectionInfo.getFilteredCollectionInfoList();
        if (this.collectionInfoList != null && this.collectionInfoList.size() > 0) {
            DefaultTableModel model;
            Vector ciList;
            int paleoCnt = 0;
            HashMap taxonomyTypeHash = new HashMap();
            HashMap<Integer, Vector<CollectionInfo>> paleoColInfoHash = new HashMap<Integer, Vector<CollectionInfo>>();
            HashMap<Integer, HashSet<DisciplineType.STD_DISCIPLINES>> paleoDispTypeHash = new HashMap<Integer, HashSet<DisciplineType.STD_DISCIPLINES>>();
            for (CollectionInfo colInfo : this.collectionInfoShortList) {
                HashSet<CollectionInfo> taxonomyTypeSet = (HashSet<CollectionInfo>)taxonomyTypeHash.get(colInfo.getTaxonomyTypeId());
                if (taxonomyTypeSet == null) {
                    System.out.println("Creating TxTypeID: " + colInfo.getTaxonomyTypeId() + "  From " + colInfo.getCatSeriesName());
                    taxonomyTypeSet = new HashSet<CollectionInfo>();
                    taxonomyTypeHash.put(colInfo.getTaxonomyTypeId(), taxonomyTypeSet);
                } else {
                    System.out.println("Adding TxTypeID: " + colInfo.getTaxonomyTypeId() + "  From " + colInfo.getCatSeriesName() + "  " + taxonomyTypeSet.size());
                }
                taxonomyTypeSet.add(colInfo);
                DisciplineType dType = this.getStandardDisciplineName(colInfo.getTaxonomyTypeName(), colInfo.getColObjTypeName(), colInfo.getCatSeriesName());
                colInfo.setDisciplineTypeObj(dType);
                if (dType != null && dType.isPaleo()) {
                    ciList = (Vector)paleoColInfoHash.get(colInfo.getTaxonNameId());
                    if (ciList == null) {
                        ciList = new Vector();
                        paleoColInfoHash.put(colInfo.getTaxonNameId(), ciList);
                    }
                    ciList.add(colInfo);
                    HashSet<DisciplineType.STD_DISCIPLINES> typeDispSet = (HashSet<DisciplineType.STD_DISCIPLINES>)paleoDispTypeHash.get(colInfo.getTaxonNameId());
                    if (typeDispSet == null) {
                        typeDispSet = new HashSet<DisciplineType.STD_DISCIPLINES>();
                        paleoDispTypeHash.put(colInfo.getTaxonNameId(), typeDispSet);
                    }
                    typeDispSet.add(colInfo.getDisciplineTypeObj().getDisciplineType());
                    ++paleoCnt;
                }
                System.out.println("--------------------------------------");
            }
            int cnt = 0;
            StringBuilder msg = new StringBuilder();
            for (Integer taxonomyTypId : taxonomyTypeHash.keySet()) {
                HashSet taxonomyTypeSet = (HashSet)taxonomyTypeHash.get(taxonomyTypId);
                if (taxonomyTypeSet.size() <= 1) continue;
                msg.append(String.format("<html>TaxonomyTypeId %d has more than one Discpline/Collection:<br><OL>", taxonomyTypId));
                for (Object ci : taxonomyTypeSet) {
                    msg.append(String.format("<LI>%s - %s - %s</LI>", ((CollectionInfo)ci).getCatSeriesName(), ((CollectionInfo)ci).getColObjTypeName(), ((CollectionInfo)ci).getTaxonomyTypeName()));
                }
                msg.append("</OL>");
                ++cnt;
            }
            if (cnt > 0) {
                JOptionPane.showConfirmDialog(null, msg.toString(), "Taxomony Type Issues", -1, 3);
            }
            if (paleoCnt > 1) {
                if (paleoColInfoHash.size() > 1) {
                    msg.setLength(0);
                    for (Integer treeId : paleoColInfoHash.keySet()) {
                        ciList = (Vector)paleoColInfoHash.get(treeId);
                        CollectionInfo colInfo = (CollectionInfo)ciList.get(0);
                        msg.append(String.format("The following collections use Taxon Tree '%s':\n", colInfo.getTaxonomyTypeName()));
                        for (Object ci : (Vector)paleoColInfoHash.get(treeId)) {
                            DisciplineType dType = this.getStandardDisciplineName(((CollectionInfo)ci).getTaxonomyTypeName(), ((CollectionInfo)ci).getColObjTypeName(), ((CollectionInfo)ci).getCatSeriesName());
                            Iterator<Object[]> name = String.format("%s / %s / %s / %s / %s", ((CollectionInfo)ci).getCatSeriesPrefix(), ((CollectionInfo)ci).getCatSeriesName(), ((CollectionInfo)ci).getColObjTypeName(), ((CollectionInfo)ci).getTaxonomyTypeName(), dType.toString());
                            msg.append((String)((Object)name));
                            msg.append("\n");
                        }
                        msg.append("\n");
                    }
                    JOptionPane.showConfirmDialog(null, msg.toString(), "Paleo Taxon Tree Issues", 0, 3);
                } else {
                    StringBuilder colNames = new StringBuilder();
                    for (Integer treeId : paleoColInfoHash.keySet()) {
                        for (Object ci : (Vector)paleoColInfoHash.get(treeId)) {
                            colNames.append("<LI>");
                            colNames.append(((CollectionInfo)ci).getCatSeriesName());
                            colNames.append("</LI>");
                        }
                    }
                    String msgStr = "<html>All the Paleo Collections need to use the same Taxon Tree and<br>therefore needs to be in the same discipline:<br><ol>";
                    JOptionPane.showConfirmDialog(null, String.valueOf(msgStr) + colNames.toString(), "Paleo Taxon Tree Issues", -1, 3);
                    for (Integer treeId : paleoColInfoHash.keySet()) {
                        Vector ciList2 = (Vector)paleoColInfoHash.get(treeId);
                        CollectionInfo colInfo = (CollectionInfo)ciList2.get(0);
                        for (CollectionInfo ci : (Vector)paleoColInfoHash.get(treeId)) {
                            ci.setDisciplineTypeObj(colInfo.getDisciplineTypeObj());
                        }
                    }
                }
            }
            if ((model = CollectionInfo.getCollectionInfoTableModel(false)).getRowCount() > 1) {
                TableWriter colInfoTblWriter = this.convLogger.getWriter("colinfo.html", "Collection Info");
                colInfoTblWriter.startTable();
                colInfoTblWriter.logHdr(CollectionInfoModel.getHeaders());
                Object[] row = new Object[model.getColumnCount()];
                int r = 0;
                while (r < model.getRowCount()) {
                    int i = 0;
                    while (i < model.getColumnCount()) {
                        row[i] = model.getValueAt(r, i);
                        ++i;
                    }
                    colInfoTblWriter.logObjRow(row);
                    ++r;
                }
                colInfoTblWriter.endTable();
                colInfoTblWriter.println("<BR><h3>Collections to be Created.</h3>");
                colInfoTblWriter.startTable();
                colInfoTblWriter.logHdr(CollectionInfoModel.getHeaders());
                model = CollectionInfo.getCollectionInfoTableModel(true);
                row = new Object[model.getColumnCount()];
                r = 0;
                while (r < model.getRowCount()) {
                    int i = 0;
                    while (i < model.getColumnCount()) {
                        row[i] = model.getValueAt(r, i);
                        ++i;
                    }
                    colInfoTblWriter.logObjRow(row);
                    ++r;
                }
                colInfoTblWriter.endTable();
                colInfoTblWriter.close();
                File file = new File(colInfoTblWriter.getFileName());
                if (file != null && file.exists()) {
                    try {
                        AttachmentUtils.openURI(file.toURI());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            for (CollectionInfo ci : CollectionInfo.getFilteredCollectionInfoList()) {
                Object col;
                int n;
                int n2;
                Object[] objectArray;
                String sql = "select preparationmethod, ct.* from usyscollobjprepmeth pt inner join usysmetafieldsetsubtype st on st.fieldsetsubtypeid = pt.fieldsetsubtypeid inner join collectionobjecttype ct1 on ct1.collectionobjecttypeid = st.fieldvalue inner join collectionobjecttype ct on ct.collectionobjecttypename = replace(ct1.collectionobjecttypename, ' Preparation', '') inner join catalogseriesdefinition csd on csd.objecttypeid = ct.collectionobjecttypeid inner join catalogseries cs on cs.catalogseriesid = csd.catalogseriesid WHERE csd.catalogseriesid = " + ci.getCatSeriesId();
                System.out.println("\n------------------");
                System.out.println(ci.getCatSeriesName());
                System.out.println(sql);
                System.out.println("------------------");
                int i = 0;
                Vector<Object[]> list = BasicSQLUtils.query(this.oldDBConn, sql);
                if (list.size() > 0) {
                    for (Object[] row : list) {
                        System.out.print(String.valueOf(i) + " - ");
                        objectArray = row;
                        n2 = row.length;
                        n = 0;
                        while (n < n2) {
                            col = objectArray[n];
                            System.out.print(col != null ? col.toString() : "null");
                            System.out.print(", ");
                            ++n;
                        }
                        System.out.println();
                        ++i;
                    }
                } else {
                    System.out.println("No Results");
                }
                sql = "select ct.*, (select relatedsubtypevalues from usysmetacontrol c left join usysmetafieldsetsubtype fst on fst.fieldsetsubtypeid = c.fieldsetsubtypeid where objectid = 10290 and ct.taxonomytypeid = c.relatedsubtypevalues) as DeterminationTaxonType from collectiontaxonomytypes ct where ct.biologicalobjecttypeid = " + ci.getColObjTypeId();
                sql = String.format("SELECT CollectionTaxonomyTypesID, BiologicalObjectTypeID, CollectionObjectTypeName FROM (select ct.*, (SELECT distinct relatedsubtypevalues FROM usysmetacontrol c LEFT JOIN usysmetafieldsetsubtype fst ON fst.fieldsetsubtypeid = c.fieldsetsubtypeid WHERE objectid = 10290 AND ct.taxonomytypeid = c.relatedsubtypevalues) AS DeterminationTaxonType FROM collectiontaxonomytypes ct WHERE ct.biologicalobjecttypeid = %d) T1 INNER JOIN collectionobjecttype cot ON T1.biologicalobjecttypeid = cot.CollectionObjectTypeID", ci.getColObjTypeId());
                System.out.println("\n------------------");
                System.out.println(ci.getColObjTypeName());
                System.out.println(sql);
                System.out.println("------------------");
                i = 0;
                list = BasicSQLUtils.query(this.oldDBConn, sql);
                if (list.size() > 0) {
                    for (Object[] row : list) {
                        System.out.print(String.valueOf(i) + " - ");
                        objectArray = row;
                        n2 = row.length;
                        n = 0;
                        while (n < n2) {
                            col = objectArray[n];
                            System.out.print(col != null ? col.toString() : "null");
                            System.out.print(", ");
                            ++n;
                        }
                        System.out.println();
                        ++i;
                    }
                    continue;
                }
                System.out.println("No Results");
            }
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p,2px,f:p:g,10px,p,2px,p:g,8px"));
            JTable tableTop = new JTable(CollectionInfo.getCollectionInfoTableModel(false));
            JTable tableBot = new JTable(CollectionInfo.getCollectionInfoTableModel(!CollectionInfo.DOING_ACCESSSION));
            int rows = 10;
            tableTop.setPreferredScrollableViewportSize(new Dimension(tableTop.getPreferredScrollableViewportSize().width, rows * tableTop.getRowHeight()));
            tableBot.setPreferredScrollableViewportSize(new Dimension(tableBot.getPreferredScrollableViewportSize().width, rows * tableBot.getRowHeight()));
            pb.add((Component)UIHelper.createLabel("Available Specify 5 Taxononmic Types", 0), cc.xy(1, 1));
            pb.add((Component)UIHelper.createScrollPane(tableTop), cc.xy(1, 3));
            pb.add((Component)UIHelper.createLabel("Specify 5 Collections to be Created", 0), cc.xy(1, 5));
            pb.add((Component)UIHelper.createScrollPane(tableBot), cc.xy(1, 7));
            pb.setDefaultDialogBorder();
            CustomDialog dlg = new CustomDialog(null, "Taxononic Types", true, pb.getPanel());
            dlg.createUI();
            dlg.setSize(1024, 500);
            UIHelper.centerWindow(dlg);
            dlg.setAlwaysOnTop(true);
            dlg.setVisible(true);
            if (dlg.isCancelled()) {
                return CollectionResultType.eCancel;
            }
            Pair<CollectionInfo, DisciplineType> pair = CollectionInfo.getDisciplineType(this.oldDBConn);
            if (pair == null || pair.second == null) {
                CollectionInfo colInfo = (CollectionInfo)pair.first;
                this.disciplineType = this.getStandardDisciplineName(colInfo.getTaxonomyTypeName(), colInfo.getColObjTypeName(), colInfo.getCatSeriesName());
            } else {
                this.disciplineType = (DisciplineType)pair.second;
            }
            return this.disciplineType != null ? CollectionResultType.eOK : CollectionResultType.eError;
        }
        return CollectionResultType.eError;
    }

    public ProgressFrame getFrame() {
        return this.frame;
    }

    public void setNewDBConn(Connection newDBConn) {
        this.newDBConn = newDBConn;
    }

    public boolean isPaleo() {
        return this.disciplineType.isPaleo();
    }

    public void shutdown() {
        try {
            this.oldDBConn.close();
            this.newDBConn.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public Integer getColObjTypeID() {
        return this.colObjTypeID;
    }

    public void setFrame(ProgressFrame frame) {
        this.frame = frame;
        this.hasFrame = frame != null;
        BasicSQLUtils.setFrame(frame);
        if (this.idMapperMgr != null) {
            this.idMapperMgr.setFrame(frame);
        }
    }

    public void setOverall(int min, int max) {
        if (this.hasFrame) {
            this.frame.setOverall(min, max);
        }
    }

    public void setOverall(int value) {
        if (this.hasFrame) {
            this.frame.setOverall(value);
        }
    }

    public void setProcess(int min, int max) {
        if (this.hasFrame) {
            this.frame.setProcess(min, max);
        }
    }

    public void setProcess(int value) {
        if (this.hasFrame) {
            this.frame.setProcess(value);
        }
    }

    public void setDesc(String text) {
        if (this.hasFrame) {
            this.frame.setDesc(text);
        }
    }

    public Connection getOldDBConnection() {
        return this.oldDBConn;
    }

    public Connection getNewDBConnection() {
        return this.newDBConn;
    }

    public void showStats() {
        Enumeration<TableStats> ts = this.tableStatHash.elements();
        while (ts.hasMoreElements()) {
            ts.nextElement().compareStats();
        }
    }

    public void doInitialize() {
        BasicSQLUtilsMapValueIFace collectionMemberIDValueMapper = this.getCollectionMemberIDValueMapper();
        BasicSQLUtilsMapValueIFace agentCreatorValueMapper = this.getAgentCreatorValueMapper();
        BasicSQLUtilsMapValueIFace agentModiferValueMapper = this.getAgentModiferValueMapper();
        BasicSQLUtilsMapValueIFace versionValueMapper = this.getVersionValueMapper();
        BasicSQLUtilsMapValueIFace divisionValueMapper = this.getDivisionValueMapper();
        this.columnValueMapper.put("CollectioMemberID", collectionMemberIDValueMapper);
        this.columnValueMapper.put("CreatedByAgentID", agentCreatorValueMapper);
        this.columnValueMapper.put("ModifiedByAgentID", agentModiferValueMapper);
        this.columnValueMapper.put("Version", versionValueMapper);
        this.columnValueMapper.put("DivisionID", divisionValueMapper);
    }

    public void initializeAgentInfo(boolean startFromScratch) {
        if (startFromScratch) {
            Hashtable<String, Agent> agentMap = new Hashtable<String, Agent>();
            this.creatorAgent = new Agent();
            this.creatorAgent.initialize();
            this.creatorAgent.setAgentType((byte)1);
            this.creatorAgent.setFirstName("DB");
            this.creatorAgent.setLastName("Creator");
            agentMap.put("Creator", this.creatorAgent);
            this.modifierAgent = new Agent();
            this.modifierAgent.initialize();
            this.modifierAgent.setAgentType((byte)1);
            this.modifierAgent.setFirstName("DB");
            this.modifierAgent.setLastName("Modifier");
            agentMap.put("Modifier", this.modifierAgent);
            this.setSession(HibernateUtil.getCurrentSession());
            this.startTx();
            this.persist(this.creatorAgent);
            this.persist(this.modifierAgent);
            this.commitTx();
            this.setSession(null);
        } else {
            DataProviderSessionIFace s = DataProviderFactory.getInstance().createSession();
            this.creatorAgent = s.getData(Agent.class, "lastName", "Creator", DataProviderSessionIFace.CompareType.Equals);
            this.modifierAgent = s.getData(Agent.class, "lastName", "Modifier", DataProviderSessionIFace.CompareType.Equals);
            s.close();
        }
        this.curAgentCreatorID = this.creatorAgent.getId();
        this.curAgentModifierID = this.modifierAgent.getId();
    }

    public void mapIds() throws SQLException {
        log.debug((Object)"mapIds()");
        boolean skipRestOfMappings = false;
        String[] tableNamesXXX = new String[]{"CollectionObjectType", "CollectionTaxonomyTypes"};
        String[] tableNames = new String[]{"Locality", "Accession", "AccessionAuthorizations", "BiologicalObjectAttributes", "BiologicalObjectRelation", "BiologicalObjectRelationType", "Borrow", "BorrowMaterial", "BorrowReturnMaterial", "CatalogSeriesDefinition", "CollectingEvent", "CollectionObjectCitation", "CollectionObjectType", "CollectionTaxonomyTypes", "Collectors", "Deaccession", "DeaccessionCollectionObject", "Determination", "DeterminationCitation", "ExchangeIn", "ExchangeOut", "GeologicTimeBoundary", "GroupPersons", "ImageCollectionObjects", "ImageLocalities", "Journal", "LoanReturnPhysicalObject", "LocalityCitation", "Observation", "OtherIdentifier", "Permit", "Preparation", "Project", "ProjectCollectionObjects", "ReferenceWork", "Shipment", "Stratigraphy"};
        IdTableMapper idMapper = null;
        String[] stringArray = tableNames;
        int n = tableNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tableName = stringArray[n2];
            idMapper = this.idMapperMgr.addTableMapper(tableName, String.valueOf(tableName) + "ID", doDeleteAllMappings);
            log.debug((Object)("mapIds() for table" + tableName));
            if (shouldCreateMapTables) {
                idMapper.mapAllIds();
            }
            ++n2;
        }
        if (!skipRestOfMappings) {
            idMapper = this.idMapperMgr.addTableMapper("Loan", "LoanID", "SELECT LoanID FROM loan WHERE Category = 0 ORDER BY LoanID", true);
            if (shouldCreateMapTables) {
                idMapper.mapAllIdsWithSQL();
            }
            idMapper = this.idMapperMgr.addTableMapper("LoanPhysicalObject", "LoanPhysicalObjectID", "SELECT LoanPhysicalObjectID FROM loanphysicalobject lpo INNER JOIN loan l ON l.LoanID = lpo.LoanID WHERE l.Category = 0 ORDER BY l.LoanID", doDeleteAllMappings);
            if (shouldCreateMapTables) {
                idMapper.mapAllIdsWithSQL();
            }
            IdTableMapper giftPrepsIdMapper = new IdTableMapper("giftphysicalobject", "id", "SELECT LoanPhysicalObjectID FROM loanphysicalobject lpo INNER JOIN loan l ON l.LoanID = lpo.LoanID WHERE l.Category = 1 ORDER BY l.LoanID", true, false);
            this.idMapperMgr.addMapper(giftPrepsIdMapper);
            if (shouldCreateMapTables) {
                giftPrepsIdMapper.mapAllIdsWithSQL();
            }
            idMapper = this.idMapperMgr.addTableMapper("collectionobjectcatalog", "CollectionObjectCatalogID", doDeleteAllMappings);
            if (shouldCreateMapTables) {
                idMapper.mapAllIds("select CollectionObjectID from collectionobject Where collectionobject.DerivedFromID Is Null order by CollectionObjectID");
            }
            idMapper = this.idMapperMgr.addTableMapper("collectionobject", "CollectionObjectID", doDeleteAllMappings);
            if (shouldCreateMapTables) {
                idMapper.mapAllIds("select CollectionObjectID From collectionobject co WHERE co.CollectionObjectTypeID > 20 ORDER BY CollectionObjectID");
            }
            String oldDetermination_Current = "Current";
            String oldDetermination_CurrentValue = "1";
            IdHashMapper idHashMapper = this.idMapperMgr.addHashMapper("ColObjCatToTaxonType", "Select collectionobjectcatalog.CollectionObjectCatalogID, taxonname.TaxonomyTypeID From collectionobjectcatalog Inner Join determination ON determination.BiologicalObjectID = collectionobjectcatalog.CollectionObjectCatalogID Inner Join taxonname ON taxonname.TaxonNameID = determination.TaxonNameID Where determination." + oldDetermination_Current + " = '" + oldDetermination_CurrentValue + "'  group by collectionobjectcatalog.CollectionObjectCatalogID, taxonname.TaxonomyTypeID", doDeleteAllMappings);
            if (shouldCreateMapTables) {
                idHashMapper.mapAllIds();
                log.info((Object)("colObjTaxonMapper: " + idHashMapper.size()));
            }
        }
        String[] mappings = new String[]{"BorrowReturnMaterial", "BorrowMaterialID", "BorrowMaterial", "BorrowMaterialID", "LoanPhysicalObject", "PhysicalObjectID", "CollectionObject", "CollectionObjectID", "LoanPhysicalObject", "LoanID", "Loan", "LoanID", "ExchangeOut", "ShipmentID", "Shipment", "ShipmentID", "ReferenceWork", "JournalID", "Journal", "JournalID", "ReferenceWork", "ContainingReferenceWorkID", "ReferenceWork", "ReferenceWorkID", "BiologicalObjectRelation", "BiologicalObjectID", "CollectionObject", "CollectionObjectID", "BiologicalObjectRelation", "RelatedBiologicalObjectID", "CollectionObject", "CollectionObjectID", "BiologicalObjectRelation", "BiologicalObjectRelationTypeID", "BiologicalObjectRelationType", "BiologicalObjectRelationTypeID", "Authors", "ReferenceWorkID", "ReferenceWork", "ReferenceWorkID", "BorrowMaterial", "BorrowID", "Borrow", "BorrowID", "BorrowAgents", "BorrowID", "Borrow", "BorrowID", "DeaccessionCollectionObject", "DeaccessionID", "Deaccession", "DeaccessionID", "DeaccessionCollectionObject", "CollectionObjectID", "Preparation", "PreparationID", "CollectionObjectCitation", "ReferenceWorkID", "ReferenceWork", "ReferenceWorkID", "CollectionObjectCitation", "BiologicalObjectID", "CollectionObjectCatalog", "CollectionObjectCatalogID", "CollectingEvent", "HabitatAttributeID", "Habitat", "HabitatID", "CollectingEvent", "LocalityID", "Locality", "LocalityID", "CollectingEvent", "StratigraphyID", "Stratigraphy", "StratigraphyID", "Collectors", "CollectingEventID", "CollectingEvent", "CollectingEventID", "Determination", "BiologicalObjectID", "CollectionObjectCatalog", "CollectionObjectCatalogID", "CollectionObjectType", "CollectionObjectTypeID", "CatalogSeriesDefinition", "CatalogSeriesDefinitionID", "CollectionObject", "CollectionObjectTypeID", "CatalogSeriesDefinition", "CatalogSeriesDefinitionID", "CollectionObject", "CollectingEventID", "CollectingEvent", "CollectingEventID", "CollectionObject", "AccessionID", "Accession", "AccessionID", "Loan", "ShipmentID", "Shipment", "ShipmentID", "AccessionAuthorizations", "AccessionID", "Accession", "AccessionID", "AccessionAuthorizations", "PermitID", "Permit", "PermitID", "AccessionAgents", "AccessionID", "Accession", "AccessionID", "DeterminationCitation", "ReferenceWorkID", "ReferenceWork", "ReferenceWorkID", "DeterminationCitation", "DeterminationID", "Determination", "DeterminationID", "OtherIdentifier", "CollectionObjectID", "CollectionObjectCatalog", "CollectionObjectCatalogID", "LocalityCitation", "ReferenceWorkID", "ReferenceWork", "ReferenceWorkID", "LocalityCitation", "LocalityID", "Locality", "LocalityID", "LoanReturnPhysicalObject", "LoanPhysicalObjectID", "LoanPhysicalObject", "LoanPhysicalObjectID", "LoanReturnPhysicalObject", "DeaccessionPhysicalObjectID", "CollectionObject", "CollectionObjectID", "DeaccessionAgents", "DeaccessionID", "Deaccession", "DeaccessionID", "ProjectCollectionObjects", "ProjectID", "Project", "ProjectID", "ProjectCollectionObjects", "CollectionObjectID", "CollectionObject", "CollectionObjectID", "LoanAgents", "LoanID", "Loan", "LoanID"};
        int i = 0;
        while (i < mappings.length) {
            this.idMapperMgr.mapForeignKey(mappings[i], mappings[i + 1], mappings[i + 2], mappings[i + 3]);
            i += 4;
        }
    }

    public void mapAgentRelatedIds() {
        log.debug((Object)"mapAgentRelatedIds()");
        String[] tableNames = new String[]{"AccessionAgents", "Authors", "BorrowAgents", "DeaccessionAgents", "ImageAgents"};
        IdTableMapper idMapper = null;
        String[] stringArray = tableNames;
        int n = tableNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tableName = stringArray[n2];
            idMapper = this.idMapperMgr.addTableMapper(tableName, String.valueOf(tableName) + "ID");
            log.debug((Object)("mapIds() for table" + tableName));
            if (shouldCreateMapTables) {
                idMapper.mapAllIds();
            }
            ++n2;
        }
        IdTableMapper loanAgentsMapper = this.idMapperMgr.addTableMapper("loanagents", "LoanAgentsID", "SELECT loanagents.LoanAgentsID FROM loanagents INNER JOIN loan ON loanagents.LoanID = loan.LoanID ORDER BY loan.LoanID", true);
        if (shouldCreateMapTables) {
            loanAgentsMapper.mapAllIdsWithSQL();
        }
        String[] mappings = new String[]{"BorrowReturnMaterial", "ReturnedByID", "Agent", "AgentID", "Preparation", "PreparedByID", "Agent", "AgentID", "ExchangeIn", "ReceivedFromOrganizationID", "Agent", "AgentID", "ExchangeIn", "CatalogedByID", "Agent", "AgentID", "Collection", "OrganizationID", "Agent", "AgentID", "GroupPersons", "GroupID", "Agent", "AgentID", "GroupPersons", "MemberID", "Agent", "AgentID", "ExchangeOut", "SentToOrganizationID", "Agent", "AgentID", "ExchangeOut", "CatalogedByID", "Agent", "AgentID", "ExchangeOut", "ShipmentID", "Shipment", "ShipmentID", "Shipment", "ShipperID", "AgentAddress", "AgentAddressID", "Shipment", "ShippedToID", "AgentAddress", "AgentAddressID", "Shipment", "ShippedByID", "Agent", "AgentID", "Authors", "AgentID", "Agent", "AgentID", "BorrowAgents", "AgentAddressID", "AgentAddress", "AgentAddressID", "Collectors", "AgentID", "Agent", "AgentID", "Permit", "IssuerID", "AgentAddress", "AgentAddressID", "Permit", "IssueeID", "AgentAddress", "AgentAddressID", "Determination", "DeterminerID", "Agent", "AgentID", "CollectionObject", "CatalogerID", "Agent", "AgentID", "AccessionAgents", "AgentAddressID", "AgentAddress", "AgentAddressID", "Agent", "ParentOrganizationID", "Agent", "AgentID", "AgentAddress", "AddressID", "Address", "AddressID", "AgentAddress", "AgentID", "Agent", "AgentID", "AgentAddress", "OrganizationID", "Agent", "AgentID", "LoanReturnPhysicalObject", "ReceivedByID", "Agent", "AgentID", "DeaccessionAgents", "AgentAddressID", "AgentAddress", "AgentAddressID", "Project", "ProjectAgentID", "Agent", "AgentID", "LoanAgents", "AgentAddressID", "AgentAddress", "AgentAddressID"};
        int i = 0;
        while (i < mappings.length) {
            this.idMapperMgr.mapForeignKey(mappings[i], mappings[i + 1], mappings[i + 2], mappings[i + 3]);
            i += 4;
        }
    }

    protected BasicSQLUtilsMapValueIFace getCollectionMemberIDValueMapper() {
        return new BasicSQLUtilsMapValueIFace(){

            @Override
            public String mapValue(Object oldValue) {
                return GenericDBConversion.this.curCollectionID.toString();
            }
        };
    }

    protected BasicSQLUtilsMapValueIFace getAgentCreatorValueMapper() {
        return new BasicSQLUtilsMapValueIFace(){

            @Override
            public String mapValue(Object oldValue) {
                Integer id;
                if (oldValue instanceof String && (id = GenericDBConversion.this.getCreatorAgentId((String)oldValue)) != null) {
                    return id.toString();
                }
                return GenericDBConversion.this.curAgentCreatorID.toString();
            }
        };
    }

    protected BasicSQLUtilsMapValueIFace getAgentModiferValueMapper() {
        return new BasicSQLUtilsMapValueIFace(){

            @Override
            public String mapValue(Object oldValue) {
                Integer id;
                if (oldValue instanceof String && !oldValue.toString().equals("NULL") && (id = GenericDBConversion.this.getModifiedByAgentId((String)oldValue)) != null) {
                    return id.toString();
                }
                return GenericDBConversion.this.curAgentModifierID.toString();
            }
        };
    }

    protected BasicSQLUtilsMapValueIFace getVersionValueMapper() {
        return new BasicSQLUtilsMapValueIFace(){

            @Override
            public String mapValue(Object oldValue) {
                return "0";
            }
        };
    }

    protected BasicSQLUtilsMapValueIFace getIsPrimaryValueMapper() {
        return new BasicSQLUtilsMapValueIFace(){

            @Override
            public String mapValue(Object oldValue) {
                return "1";
            }
        };
    }

    protected BasicSQLUtilsMapValueIFace getDivisionValueMapper() {
        return new BasicSQLUtilsMapValueIFace(){

            @Override
            public String mapValue(Object oldValue) {
                return GenericDBConversion.this.curDivisionID.toString();
            }
        };
    }

    protected BasicSQLUtilsMapValueIFace getDisciplineValueMapper() {
        return new BasicSQLUtilsMapValueIFace(){

            @Override
            public String mapValue(Object oldValue) {
                return GenericDBConversion.this.curDisciplineID.toString();
            }
        };
    }

    protected BasicSQLUtilsMapValueIFace getSrcLatLongUnitValueMapper() {
        return new BasicSQLUtilsMapValueIFace(){

            @Override
            public String mapValue(Object oldValue) {
                return "0";
            }
        };
    }

    public void copyTables(boolean doBrief) {
        log.debug((Object)"copyTables()");
        BasicSQLUtilsMapValueIFace collectionMemberIDValueMapper = this.getCollectionMemberIDValueMapper();
        BasicSQLUtilsMapValueIFace agentCreatorValueMapper = this.getAgentCreatorValueMapper();
        BasicSQLUtilsMapValueIFace agentModiferValueMapper = this.getAgentModiferValueMapper();
        BasicSQLUtilsMapValueIFace versionValueMapper = this.getVersionValueMapper();
        BasicSQLUtilsMapValueIFace divisionValueMapper = this.getDivisionValueMapper();
        BasicSQLUtilsMapValueIFace disciplineValueMapper = this.getDisciplineValueMapper();
        BasicSQLUtilsMapValueIFace isPrimaryValueMapper = this.getIsPrimaryValueMapper();
        BasicSQLUtilsMapValueIFace srcLatLongUnitValueMapper = this.getSrcLatLongUnitValueMapper();
        String[] tablesToMoveOver = !doBrief ? new String[]{"CollectingEvent", "AccessionAgent", "Accession", "AccessionAuthorization", "Author", "BiologicalObjectAttributes", "Borrow", "BorrowAgent", "BorrowMaterial", "BorrowReturnMaterial", "CollectionObjectCitation", "Collector", "Deaccession", "DeaccessionAgent", "DeterminationCitation", "ExchangeIn", "ExchangeOut", "GroupPerson", "Journal", "DeaccessionCollectionObject", "LoanReturnPhysicalObject", "LocalityCitation", "OtherIdentifier", "Permit", "Preparation", "Project", "ReferenceWork", "Shipment", "TaxonCitation"} : new String[]{"GroupPerson", "Habitat"};
        String oldLoanReturnPhysicalObj_Date_FieldName = "Date";
        String oldRefWork_Date_FieldName = "Date";
        String oldDeaccession_Date_FieldName = "Date";
        String oldAuthors_Order_FieldName = "Order";
        String oldCollectors_Order_FieldName = "Order";
        String oldGroupPersons_Order_FieldName = "Order";
        String oldStratigraphy_Group_FieldName = "Group";
        String oldBorrowReturnMaterial_Date_FieldName = "Date";
        HashMap<String, Map<String, String>> tableMaps = new HashMap<String, Map<String, String>>();
        tableMaps.put("accession", BasicSQLUtils.createFieldNameMap(new String[]{"AccessionNumber", "Number"}));
        tableMaps.put("accessionagent", BasicSQLUtils.createFieldNameMap(new String[]{"AgentID", "AgentAddressID", "AccessionAgentID", "AccessionAgentsID"}));
        tableMaps.put("accessionauthorization", BasicSQLUtils.createFieldNameMap(new String[]{"AccessionAuthorizationID", "AccessionAuthorizationsID"}));
        tableMaps.put("author", BasicSQLUtils.createFieldNameMap(new String[]{"OrderNumber", oldAuthors_Order_FieldName, "AuthorID", "AuthorsID"}));
        tableMaps.put("borrow", BasicSQLUtils.createFieldNameMap(new String[]{"IsClosed", "Closed"}));
        tableMaps.put("borrowagent", BasicSQLUtils.createFieldNameMap(new String[]{"AgentID", "AgentAddressID", "BorrowAgentID", "BorrowAgentsID"}));
        tableMaps.put("borrowreturnmaterial", BasicSQLUtils.createFieldNameMap(new String[]{"ReturnedDate", oldBorrowReturnMaterial_Date_FieldName}));
        tableMaps.put("borrowshipment", BasicSQLUtils.createFieldNameMap(new String[]{"BorrowShipmentID", "BorrowShipmentsID"}));
        tableMaps.put("collectingevent", BasicSQLUtils.createFieldNameMap(new String[]{"TaxonID", "TaxonNameID", "Visibility", "GroupPermittedToView"}));
        tableMaps.put("collectionobjectcitation", BasicSQLUtils.createFieldNameMap(new String[]{"CollectionObjectID", "BiologicalObjectID"}));
        tableMaps.put("collector", BasicSQLUtils.createFieldNameMap(new String[]{"OrderNumber", oldCollectors_Order_FieldName, "CollectorID", "CollectorsID"}));
        tableMaps.put("deaccession", BasicSQLUtils.createFieldNameMap(new String[]{"DeaccessionDate", oldDeaccession_Date_FieldName}));
        tableMaps.put("deaccessionagent", BasicSQLUtils.createFieldNameMap(new String[]{"AgentID", "AgentAddressID", "DeaccessionAgentID", "DeaccessionAgentsID"}));
        tableMaps.put("deaccessionpreparation", BasicSQLUtils.createFieldNameMap(new String[]{"DeaccessionPreparationID", "DeaccessionCollectionObjectID", "PreparationID", "CollectionObjectID"}));
        tableMaps.put("groupperson", BasicSQLUtils.createFieldNameMap(new String[]{"GroupPersonID", "GroupPersonsID", "OrderNumber", oldGroupPersons_Order_FieldName}));
        tableMaps.put("loanreturnpreparation", BasicSQLUtils.createFieldNameMap(new String[]{"DeaccessionPreparationID", "DeaccessionPhysicalObjectID", "LoanPreparationID", "LoanPhysicalObjectID", "LoanReturnPreparationID", "LoanReturnPhysicalObjectID", "ReturnedDate", oldLoanReturnPhysicalObj_Date_FieldName, "QuantityResolved", "Quantity"}));
        tableMaps.put("permit", BasicSQLUtils.createFieldNameMap(new String[]{"IssuedByID", "IssuerID", "IssuedToID", "IssueeID"}));
        tableMaps.put("projectcollectionobjects", BasicSQLUtils.createFieldNameMap(new String[]{"ProjectCollectionObjectID", "ProjectCollectionObjectsID"}));
        tableMaps.put("referencework", BasicSQLUtils.createFieldNameMap(new String[]{"WorkDate", oldRefWork_Date_FieldName, "IsPublished", "Published"}));
        tableMaps.put("stratigraphy", BasicSQLUtils.createFieldNameMap(new String[]{"LithoGroup", oldStratigraphy_Group_FieldName}));
        tableMaps.put("taxoncitation", BasicSQLUtils.createFieldNameMap(new String[]{"TaxonID", "TaxonNameID"}));
        tableMaps.put("collectionobjectattribute", BasicSQLUtils.createFieldNameMap(this.getCollectionObjectAttributeMappings()));
        tableMaps.put("preparationattribute", BasicSQLUtils.createFieldNameMap(this.getPrepAttributeMappings()));
        tableMaps.put("collectingeventattribute", BasicSQLUtils.createFieldNameMap(this.getHabitatAttributeMappings()));
        BasicSQLUtils.clearValueMapper();
        BasicSQLUtils.addToValueMapper("CollectionMemberID", collectionMemberIDValueMapper);
        BasicSQLUtils.addToValueMapper("CreatedByAgentID", agentCreatorValueMapper);
        BasicSQLUtils.addToValueMapper("ModifiedByAgentID", agentModiferValueMapper);
        BasicSQLUtils.addToValueMapper("Version", versionValueMapper);
        BasicSQLUtils.addToValueMapper("DivisionID", divisionValueMapper);
        BasicSQLUtils.addToValueMapper("DisciplineID", disciplineValueMapper);
        BasicSQLUtils.addToValueMapper("IsPrimary", isPrimaryValueMapper);
        BasicSQLUtils.addToValueMapper("SrcLatLongUnit", srcLatLongUnitValueMapper);
        TableWriter tblWriter = this.convLogger.getWriter("CopyTable.html", "Copy Tables");
        BasicSQLUtils.setTblWriter(tblWriter);
        String[] stringArray = tablesToMoveOver;
        int n = tablesToMoveOver.length;
        int n2 = 0;
        while (n2 < n) {
            Map map;
            String[] ignoredFields;
            String fromTableName;
            String tableName = stringArray[n2];
            String sql = null;
            String toTableName = fromTableName = tableName.toLowerCase();
            tblWriter.log("From [" + fromTableName + "][" + toTableName + "]");
            BasicSQLUtils.setOneToOneIDHash(null);
            int errorsToShow = 63;
            TableStats tblStats = new TableStats(this.oldDBConn, fromTableName, this.newDBConn, toTableName);
            this.tableStatHash.put(fromTableName, tblStats);
            log.info((Object)("Getting ready to copy table: " + fromTableName));
            BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(null);
            HashMap<String, String> verbatimDateMapper = null;
            if (tableName.equals("Accession") || tableName.equals("AccessionAuthorization")) {
                ignoredFields = new String[]{"RepositoryAgreementID", "Version", "CreatedByAgentID", "DateAcknowledged", "AddressOfRecordID", "AppraisalID", "AccessionCondition", "DivisionID", "TotalValue"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
            } else if (fromTableName.equals("accession")) {
                ignoredFields = new String[]{"RepositoryAgreementID", "Version", "CreatedByAgentID", "DivisionID", "TotalValue"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
            } else if (fromTableName.equals("accessionagent")) {
                ignoredFields = new String[]{"RepositoryAgreementID", "Version", "CreatedByAgentID", "CollectionMemberID"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
            } else if (fromTableName.equals("attachment")) {
                ignoredFields = new String[]{"Visibility", "VisibilitySetBy", "Version", "CreatedByAgentID", "CollectionMemberID"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
            } else if (fromTableName.equals("biologicalobjectattributes")) {
                toTableName = "collectionobjectattribute";
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(this.getCollectionObjectAttributeToIgnore());
            } else if (fromTableName.equals("borrow")) {
                ignoredFields = new String[]{"IsFinancialResponsibility", "AddressOfRecordID", "Version", "CreatedByAgentID", "CollectionMemberID"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
            } else if (fromTableName.equals("borrowreturnmaterial")) {
                errorsToShow &= 0xFFFFFFFB;
            } else if (fromTableName.equals("collectionobject")) {
                BasicSQLUtils.setOneToOneIDHash(BasicSQLUtils.createFieldNameMap(new String[]{"PreparationAttributeID", "PreparationAttributeID", "CollectionObjectAttributeID", "CollectionObjectAttributeID", "TotalValue"}));
            } else if (fromTableName.equals("collectionobjectcitation")) {
                ignoredFields = new String[]{"IsFinancialResponsibility", "AddressOfRecordID", "Version", "CreatedByAgentID", "CollectionMemberID", "IsFigured"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
            } else if (fromTableName.equals("collectingevent")) {
                ignoredFields = new String[]{"VisibilitySetByID", "CollectingTripID", "EndDateVerbatim", "EndDatePrecision", "StartDatePrecision", "HabitatAttributeID", "Version", "CreatedByAgentID", "CollectionMemberID", "CollectingEventAttributeID", "DisciplineID", "SGRStatus"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
                BasicSQLUtils.setOneToOneIDHash(BasicSQLUtils.createFieldNameMap(new String[]{"HabitatAttributeID", "HabitatAttributeID"}));
                verbatimDateMapper = new HashMap<String, String>();
                verbatimDateMapper.put("StartDateVerbatim", "StartDateVerbatim");
                errorsToShow &= 0xFFFFFFFE;
                errorsToShow &= 0xFFFFFFFB;
                errorsToShow &= 0xFFFFFFFD;
            } else if (fromTableName.equals("collector") || fromTableName.equals("collectors")) {
                ignoredFields = new String[]{"IsPrimary", "Version", "CreatedByAgentID", "CollectionMemberID", "DisciplineID", "DivisionID"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
            } else if (fromTableName.equals("deaccession")) {
                ignoredFields = new String[]{"AccessionID", "Version", "CreatedByAgentID", "ModifiedByAgentID"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
            } else if (fromTableName.equals("deaccessioncollectionobject")) {
                toTableName = "deaccessionpreparation";
                ignoredFields = new String[]{"Version", "CreatedByAgentID", "ModifiedByAgentID"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
            } else if (fromTableName.equals("determination")) {
                ignoredFields = new String[]{"Version", "CreatedByAgentID", "CollectionMemberID"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
            } else if (fromTableName.startsWith("groupperson")) {
                ignoredFields = new String[]{"DivisionID", "Version", "CreatedByAgentID"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
            } else if (fromTableName.equals("habitat")) {
                toTableName = "collectingeventattribute";
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(this.getHabitatAttributeToIgnore());
                errorsToShow &= 0xFFFFFFFB;
            } else if (fromTableName.equals("loan")) {
                ignoredFields = new String[]{"SpecialConditions", "AddressOfRecordID", "DateReceived", "ReceivedComments", "PurposeOfLoan", "OverdueNotiSetDate", "IsFinancialResponsibility", "Version", "CreatedByAgentID", "IsFinancialResponsibility", "SrcTaxonomy", "SrcGeography", "CollectionMemberID", "DisciplineID", "DivisionID", "IsGift"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
                sql = "SELECT * FROM loan WHERE Category = 1";
            } else if (fromTableName.equals("journal")) {
                ignoredFields = new String[]{"ISSN", "Version", "CreatedByAgentID", "GUID", "Text1"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
            } else if (fromTableName.equals("loanreturnphysicalobject")) {
                toTableName = "loanreturnpreparation";
                ignoredFields = new String[]{"QuantityReturned", "Version", "CreatedByAgentID", "DisciplineID"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
                errorsToShow &= 0xFFFFFFFB;
            } else if (fromTableName.equals("localitycitation")) {
                ignoredFields = new String[]{"Version", "CreatedByAgentID", "DisciplineID"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
            } else if (fromTableName.equals("otheridentifier")) {
                ignoredFields = new String[]{"Institution", "Version", "CreatedByAgentID", "CollectionMemberID"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
            } else if (fromTableName.equals("permit")) {
                errorsToShow &= 0xFFFFFFFB;
            } else if (fromTableName.equals("preparation")) {
                toTableName = "preparationattribute";
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(this.getPrepAttributeAttributeToIgnore());
                BasicSQLUtils.setFieldsToIgnoreWhenMappingIDs(new String[]{"MediumID", "PreparationAttributeID"});
            } else if (fromTableName.equals("referencework")) {
                ignoredFields = new String[]{"GUID", "Version", "CreatedByAgentID", "CollectionMemberID", "ISBN", "ContainedRFParentID"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
                errorsToShow &= 0xFFFFFFFB;
            } else if (fromTableName.equals("shipment")) {
                ignoredFields = new String[]{"GUID", "Version", "CreatedByAgentID", "DisciplineID", "BorrowID", "ExchangeOutID", "GiftID", "LoanID"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
                BasicSQLUtils.setFieldsToIgnoreWhenMappingIDs(new String[]{"ShipmentMethodID"});
                errorsToShow &= 0xFFFFFFFB;
            } else if (fromTableName.equals("stratigraphy")) {
                errorsToShow &= 0xFFFFFFFB;
            } else {
                ignoredFields = new String[]{"GUID", "Version", "CreatedByAgentID", "CollectionMemberID"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields);
            }
            if (fromTableName.equals("accessionagent") || fromTableName.equals("accessionauthorization") || fromTableName.equals("author") || fromTableName.equals("borrowshipment") || fromTableName.equals("borrowagent") || fromTableName.equals("collector") || fromTableName.equals("deaccessionagent") || fromTableName.equals("groupperson")) {
                fromTableName = String.valueOf(fromTableName) + "s";
            }
            if ((map = (Map)tableMaps.get(toTableName)) == null) {
                tableMaps.put(toTableName, BasicSQLUtils.createFieldNameMap(new String[]{"ModifiedByAgentID", "LastEditedBy"}));
            } else {
                map.put("ModifiedByAgentID", "LastEditedBy");
            }
            if (!BasicSQLUtils.hasIgnoreFields()) {
                String[] ignoredFields2 = new String[]{"Version", "CreatedByAgentID", "CollectionMemberID"};
                BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(ignoredFields2);
            }
            BasicSQLUtils.deleteAllRecordsFromTable(toTableName, BasicSQLUtils.myDestinationServerType);
            BasicSQLUtils.setShowErrors(errorsToShow);
            BasicSQLUtils.setIdentityInsertONCommandForSQLServer(this.newDBConn, toTableName, BasicSQLUtils.myDestinationServerType);
            if (!BasicSQLUtils.copyTable(this.oldDBConn, this.newDBConn, sql, fromTableName, toTableName, (Map)tableMaps.get(toTableName), verbatimDateMapper, BasicSQLUtils.mySourceServerType, BasicSQLUtils.myDestinationServerType)) {
                String msg = "Table [" + tableName + "] didn't copy correctly.";
                log.error((Object)msg);
                tblWriter.logError(msg);
                break;
            }
            BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, toTableName, BasicSQLUtils.myDestinationServerType);
            BasicSQLUtils.setFieldsToIgnoreWhenMappingIDs(null);
            tblStats.collectStats();
            ++n2;
        }
        BasicSQLUtils.setShowErrors(63);
        BasicSQLUtils.setTblWriter(null);
        tblWriter.close();
    }

    protected String[] getCollectionObjectAttributeToIgnore() {
        return new String[]{"BiologicalObjectTypeId", "BiologicalObjectAttributesID", "SexId", "StageId", "Text8", "Number34", "Number35", "Number36", "Text8", "Version", "CreatedByAgentID", "CollectionMemberID", "Text11", "Text12", "Text13", "Text14", "CollectionObjectAttributeID", "RelatedTaxonID"};
    }

    protected String[] getCollectionObjectAttributeMappings() {
        return new String[]{"CollectionObjectAttributeID", "BiologicalObjectAttributesID", "Text10", "Sex", "Text11", "Condition", "Text15", "Age", "Text12", "Stage", "Number37", "Weight", "Number38", "Length", "Number8", "GosnerStage", "Number9", "SnoutVentLength", "Text8", "Activity", "Number10", "LengthTail", "Text13", "ReproductiveCondition", "Text14", "ObjCondition", "Number11", "LengthTarsus", "Number12", "LengthWing", "Number13", "LengthHead", "Number14", "LengthBody", "Number15", "LengthMiddleToe", "Number16", "LengthBill", "Number17", "TotalExposedCulmen", "Number39", "MaxLength", "Number40", "MinLength", "Number18", "LengthHindFoot", "Number19", "LengthForeArm", "Number20", "LengthTragus", "Number21", "LengthEar", "Number22", "EarFromNotch", "Number23", "Wingspan", "Number24", "LengthGonad", "Number25", "WidthGonad", "Number26", "LengthHeadBody", "Number41", "Width", "Number27", "HeightFinalWhorl", "Number28", "InsideHeightAperture", "Number29", "InsideWidthAperture", "Number30", "NumberWhorls", "Number31", "OuterLipThickness", "Number32", "Mantle", "Number42", "Height", "Number33", "Diameter", "Text9", "BranchingAt", "ModifiedByAgentID", "LastEditedBy"};
    }

    protected String[] getPrepAttributeAttributeToIgnore() {
        return new String[]{"MediumId", "PreparationTypeId", "ContainerTypeId", "Number3", "Number8", "Text16", "Version", "CreatedByAgentID", "CollectionMemberID", "Text22", "Text23", "Text24", "Text25", "Text26", "YesNo3", "YesNo4"};
    }

    protected String[] getPrepAttributeMappings() {
        return new String[]{"PreparationAttributeID", "PreparationID", "AttrDate", "PreparedDate", "Number3", "MediumID", "Text3", "PartInformation", "Text4", "StartBoxNumber", "Text5", "EndBoxNumber", "Text6", "StartSlideNumber", "Text7", "EndSlideNumber", "Text8", "SectionOrientation", "Text9", "SectionWidth", "Text26", "size", "Text10", "URL", "Text11", "Identifier", "Text12", "NestLining", "Text13", "NestMaterial", "Text14", "NestLocation", "Text15", "SetMark", "Number4", "CollectedEggCount", "Number5", "CollectedParasiteEggCount", "Number6", "FieldEggCount", "Number7", "FieldParasiteEggCount", "Text17", "EggIncubationStage", "Text18", "EggDescription", "Text19", "Format", "Text25", "StorageInfo", "Text22", "PreparationType", "Text23", "ContainerType", "Text24", "Medium", "Text20", "DNAConcentration", "Text21", "Volume", "Number9", "NestCollected", "ModifiedByAgentID", "LastEditedBy"};
    }

    protected String[] getHabitatAttributeToIgnore() {
        return new String[]{"HabitatTypeId", "CreatedByAgentID", "CollectionMemberID", "Number10", "Number12", "DivisionID", "Number13", "Number9", "Text12", "Text13", "Text14", "Text15", "Text16", "Text17", "Version", "DisciplineID"};
    }

    protected String[] getHabitatAttributeMappings() {
        String oldHabitatAttribute_Current_FieldName = "Current";
        return new String[]{"CollectingEventAttributeID", "HabitatID", "Number9", "AirTempC", "Number10", "WaterTempC", "Number11", "WaterpH", "Text12", "Turbidity", "Text16", "Clarity", "Text14", "Salinity", "Text6", "SoilType", "Number6", "SoilPh", "Number7", "SoilTempC", "Text7", "SoilMoisture", "Text15", "Slope", "Text13", "Vegetation", "Text17", "HabitatType", "Text8", oldHabitatAttribute_Current_FieldName, "Text9", "Substrate", "Text10", "SubstrateMoisture", "Number8", "HeightAboveGround", "Text11", "NearestNeighbor", "Number13", "MinDepth", "Number12", "MaxDepth", "ModifiedByAgentID", "LastEditedBy"};
    }

    private void loadAgentIdMappings() {
        if (oldAgentPairs == null) {
            String fileName;
            JTextField textField = new JTextField();
            BrowseBtnPanel bbp = new BrowseBtnPanel(textField, false, true);
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p"));
            pb.add((Component)bbp, cc.xy(1, 1));
            pb.setDefaultDialogBorder();
            CustomDialog dlg = new CustomDialog(null, "Choose Agent Mapping File", true, pb.getPanel());
            dlg.createUI();
            dlg.pack();
            UIHelper.centerAndShow(dlg, 600, dlg.getHeight());
            if (!dlg.isCancelled() && StringUtils.isNotEmpty((String)(fileName = textField.getText()))) {
                try {
                    File file = new File(fileName);
                    if (file.exists()) {
                        XStream xstream = new XStream();
                        oldAgentPairs = (Object[])xstream.fromXML((InputStream)new FileInputStream(file));
                    } else {
                        UIRegistry.showError("The file [" + fileName + "] does not exist!");
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    UIRegistry.showError("Error parsing agent XML file [" + fileName + "]");
                    oldAgentPairs = null;
                }
            }
        }
    }

    private Integer getOldAgentIdFromName(String nameArg) {
        if (oldAgentPairs != null) {
            Integer oldId;
            String name = nameArg;
            if (agentIdMapper == null) {
                agentIdMapper = this.idMapperMgr.get("agent", "AgentID");
            }
            if (oldAgentHash.size() == 0) {
                int i = 0;
                while (i < oldAgentPairs.length) {
                    oldAgentHash.put((String)oldAgentPairs[i], (Integer)oldAgentPairs[i + 1]);
                    i += 2;
                }
            }
            if (name.startsWith("'")) {
                name = name.substring(1);
            }
            if (name.endsWith("'")) {
                name = name.substring(0, name.length() - 1);
            }
            if ((oldId = oldAgentHash.get(name)) != null) {
                agentIdMapper = this.idMapperMgr.get("agent", "AgentID");
                Integer newId = agentIdMapper.get(oldId);
                if (newId == null) {
                    agentIdMapper = this.idMapperMgr.get("agentaddress", "AgentAddressID");
                    newId = agentIdMapper.get(oldId);
                    agentIdMapper = this.idMapperMgr.get("agent", "AgentID");
                }
                if (newId != null) {
                    return newId;
                }
                if (!oldUnmappedAgentNames.contains(name)) {
                    log.error((Object)String.format("Couldn't map old Agent Name [%s] oldId[%d]", name, oldId));
                }
                oldUnmappedAgentNames.add(name);
            } else if (!oldUnmappedAgentNames.contains(name)) {
                log.error((Object)String.format("Couldn't find old Agent Name [%s] in hash", name));
                oldUnmappedAgentNames.add(name);
            }
        }
        return null;
    }

    protected Integer getCreatorAgentId(String createdByName) {
        Integer id;
        if (StringUtils.isNotEmpty((String)createdByName) && (id = this.getOldAgentIdFromName(createdByName)) != null) {
            return id;
        }
        return this.creatorAgent == null ? null : this.creatorAgent.getAgentId();
    }

    public Integer getModifiedByAgentId(String modifierAgentName) {
        Integer id;
        if (StringUtils.isNotEmpty((String)modifierAgentName) && agentIdMapper != null && (id = this.getOldAgentIdFromName(modifierAgentName)) != null) {
            return id;
        }
        return this.modifierAgent == null ? null : this.modifierAgent.getAgentId();
    }

    protected Integer getCreatorAgentIdForAgent(String createdByName) {
        return this.creatorAgent == null ? null : this.creatorAgent.getAgentId();
    }

    public Integer getModifiedByAgentIdForAgent(String modifierAgentName) {
        return this.modifierAgent == null ? null : this.modifierAgent.getAgentId();
    }

    public void fixCreatedModifiedByAgents(String itUsername, String itPwd, String dbNameSrc) {
        DBMSUserMgr dbMgr = DBMSUserMgr.getInstance();
        if (!dbMgr.connect(itUsername, itPwd, "localhost", dbNameSrc)) {
            log.error((Object)"Connecting to old DB");
            return;
        }
        String[] newTableNames = new String[]{"collectingevent", "shipment", "preparationattribute", "collectionobject", "permit", "otheridentifier", "locality", "loanreturnpreparation", "loanpreparation", "loanagent", "loan", "journal", "groupperson", "geologictimeperiod", "geography", "exchangein", "exchangeout", "determination", "collector", "collectionobjectattribute", "gift"};
        String[] oldTableNames = new String[]{"collectingevent", "shipment", "preparation", "collectionobject", "permit", "otheridentifier", "locality", "loanreturnpreparation", "loanpreparation", "loanagent", "loan", "journal", "groupperson", "geologictimeperiod", "geography", "exchangein", "exchangeout", "determination", "collector", "biologicalobjectattributes", "loan"};
        String[] oldIDNames = new String[]{"CollectingEventID", "ShipmentID", "PreparationID", "CollectionObjectID", "PermitID", "OtherIdentifierID", "LocalityID", "LoanReturnPreparationID", "LoanPreparationID", "LoanAgentID", "LoanID", "JournalID", "GroupPersonID", "GeologicTimePeriodID", "GeographyID", "ExchangeInID", "ExchangeOutID", "DeterminationID", "CollectorID", "BiologicalObjectAttributesID", "LoanID"};
        try {
            PrintWriter pw = new PrintWriter("missing_agentmappings_work.txt");
            Statement oStmt = this.oldDBConn.createStatement();
            int i = 0;
            while (i < newTableNames.length) {
                String newTblName = newTableNames[i];
                String oldTblName = oldTableNames[i];
                String msg = "------------------------------------------- " + newTblName + "-------------------------------------------";
                log.debug((Object)msg);
                pw.println(msg);
                DBTableInfo ti = DBTableIdMgr.getInstance().getInfoByTableName(newTblName);
                if (dbMgr.doesFieldExistInTable(oldTblName, "LastEditedBy")) {
                    IdMapperIFace idMapper;
                    String mapTblName = oldTblName;
                    String mapTblIdCol = oldIDNames[i];
                    if (newTblName.equals("gift")) {
                        mapTblName = "gift";
                        mapTblIdCol = "GiftID";
                    }
                    if ((idMapper = this.idMapperMgr.get(mapTblName, mapTblIdCol)) == null) {
                        idMapper = this.idMapperMgr.addTableMapper(mapTblName, mapTblIdCol, false);
                    }
                    if (idMapper != null) {
                        String uSql = String.format("UPDATE %s SET CreatedByAgentID=? WHERE %s=?", ti.getName(), ti.getIdColumnName());
                        log.debug((Object)uSql);
                        PreparedStatement pStmt = this.newDBConn.prepareStatement(uSql);
                        int totalCnt = BasicSQLUtils.getCountAsInt(this.oldDBConn, String.format("SELECT COUNT(*) FROM %s WHERE LastEditedBy IS NOT NULL", oldTblName));
                        System.out.println("Total Records: " + totalCnt);
                        pw.println("Total Records: " + totalCnt);
                        int cnt = 0;
                        String sql = String.format("SELECT %s, LastEditedBy FROM %s WHERE LastEditedBy IS NOT NULL", oldIDNames[i], oldTableNames[i]);
                        ResultSet rs = oStmt.executeQuery(sql);
                        while (rs.next()) {
                            int oldId = rs.getInt(1);
                            String lastEditedByStr = rs.getString(2);
                            Integer newId = idMapper.get(oldId);
                            if (newId != null) {
                                Integer agtId = this.getCreatorAgentId(lastEditedByStr);
                                if (agtId != null) {
                                    pStmt.setInt(1, agtId);
                                    pStmt.setInt(2, newId);
                                    if (pStmt.executeUpdate() != 1) {
                                        msg = String.format("Error updating AgentID for %s for old Id %d  New Id: %d", oldTblName, oldId, newId);
                                        log.error((Object)msg);
                                        pw.println(msg);
                                        continue;
                                    }
                                    ++cnt;
                                    continue;
                                }
                                if (lastEditedByStr.equals("casper")) continue;
                                msg = String.format("Error updating AgentID for %s for no agent for '%s'", oldTblName, lastEditedByStr);
                                log.error((Object)msg);
                                pw.println(msg);
                                continue;
                            }
                            msg = String.format("No mapping for %s for old Id %d", oldTblName, oldId);
                            log.error((Object)msg);
                            pw.println(msg);
                        }
                        msg = "Records updated: " + cnt;
                        log.debug((Object)msg);
                        pw.println(msg);
                        rs.close();
                        pStmt.close();
                    }
                }
                ++i;
            }
            pw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        dbMgr.close();
    }

    public void checkCreatedModifiedByAgents() {
        try {
            PrintWriter pw = new PrintWriter("missing_agentmappings.txt");
            for (DBTableInfo ti : DBTableIdMgr.getInstance().getTables()) {
                String sql;
                Vector<Object[]> counts;
                boolean doCheck = false;
                DBRelationshipInfo ri = ti.getRelationshipByName("modifiedByAgent");
                if (ri != null) {
                    doCheck = true;
                }
                if (!doCheck || (counts = BasicSQLUtils.query(this.newDBConn, sql = String.format("SELECT T1.*, a.LastName FROM (SELECT s.ModifiedByAgentID, COUNT(s.ModifiedByAgentID) FROM %s s GROUP BY s.ModifiedByAgentID) T1 LEFT JOIN agent a ON a.AgentID = T1.ModifiedByAgentID ", ti.getName()))).size() <= 0 || counts.size() >= 5) continue;
                String msg = String.format("Table %s has %d different agents", ti.getName(), counts.size());
                System.out.println(msg);
                pw.println(msg);
                Iterator<Object[]> iterator = counts.iterator();
                while (iterator.hasNext()) {
                    Object[] row;
                    Object[] objectArray = row = iterator.next();
                    int n = row.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        System.out.print(obj + " ");
                        pw.print(obj + " ");
                        ++n2;
                    }
                    System.out.println();
                    pw.println();
                }
            }
            pw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected int getCollectionMemberId() {
        return this.curCollectionID;
    }

    protected int getDisciplineId() {
        return this.curDisciplineID;
    }

    protected boolean checkName(String[] referenceNames, String nameArg) {
        String rn;
        int n;
        int n2;
        String[] stringArray;
        String tok;
        String[] tokens;
        String name = nameArg.toLowerCase();
        String[] stringArray2 = tokens = StringUtils.split((String)name.toLowerCase(), (char)' ');
        int n3 = tokens.length;
        int n4 = 0;
        while (n4 < n3) {
            tok = stringArray2[n4];
            stringArray = referenceNames;
            n2 = referenceNames.length;
            n = 0;
            while (n < n2) {
                rn = stringArray[n];
                if (tok.startsWith(rn.toLowerCase())) {
                    return true;
                }
                if (rn.toLowerCase().startsWith(tok)) {
                    return true;
                }
                ++n;
            }
            ++n4;
        }
        stringArray2 = tokens;
        n3 = tokens.length;
        n4 = 0;
        while (n4 < n3) {
            tok = stringArray2[n4];
            stringArray = referenceNames;
            n2 = referenceNames.length;
            n = 0;
            while (n < n2) {
                rn = stringArray[n];
                if (StringUtils.contains((String)tok, (String)rn.toLowerCase())) {
                    return true;
                }
                if (StringUtils.contains((String)rn.toLowerCase(), (String)tok)) {
                    return true;
                }
                ++n;
            }
            ++n4;
        }
        return false;
    }

    public String getStandardDataTypeName(String collectionObjTypeName) {
        if (this.checkName(new String[]{"Plant", "Herb"}, collectionObjTypeName)) {
            return "Plant";
        }
        if (this.checkName(new String[]{"Fish", "Bird", "Frog", "Insect", "Fossil", "Icth", "Orn", "Herp", "Entom", "Paleo", "Mammal", "Invertebrate", "Animal"}, collectionObjTypeName)) {
            return "Animal";
        }
        if (this.checkName(new String[]{"Mineral", "Rock"}, collectionObjTypeName)) {
            return "Mineral";
        }
        if (this.checkName(new String[]{"Fungi"}, collectionObjTypeName)) {
            return "Fungi";
        }
        String msg = "****** Unable to Map [" + collectionObjTypeName + "] to a standard DataType.";
        log.error((Object)msg);
        UIRegistry.showError(msg);
        return null;
    }

    public DisciplineType getStandardDisciplineName(String taxonDefName, String colObjTypeName, String catSeriesName) {
        String taxonDescrStr = String.valueOf(taxonDefName.toLowerCase()) + " " + colObjTypeName.toLowerCase();
        DisciplineType dispType = this.getStandardDisciplineName(taxonDescrStr);
        if (dispType != null) {
            return dispType;
        }
        log.debug((Object)("**************** [" + taxonDescrStr + "][" + catSeriesName + "] *****************"));
        if (dispType == null && catSeriesName != null) {
            StringTokenizer st = new StringTokenizer(catSeriesName, " ,");
            while (st.hasMoreTokens()) {
                String name = st.nextToken().trim();
                log.debug((Object)("Checking token[" + name + "]"));
                dispType = this.getStandardDisciplineName(name);
                if (dispType == null) continue;
                log.debug((Object)("    Found[" + dispType + "]"));
                if (!dispType.isPaleo() && (StringUtils.contains((String)taxonDescrStr, (String)"paleo") || StringUtils.contains((String)taxonDescrStr, (String)"fossil") || StringUtils.contains((String)catSeriesName.toLowerCase(), (String)"paleo") || StringUtils.contains((String)catSeriesName.toLowerCase(), (String)"fossil"))) {
                    if (dispType.getDisciplineType() == DisciplineType.STD_DISCIPLINES.botany) {
                        return DisciplineType.getDiscipline(DisciplineType.STD_DISCIPLINES.paleobotany);
                    }
                    if (dispType.getDisciplineType() == DisciplineType.STD_DISCIPLINES.invertebrate) {
                        return DisciplineType.getDiscipline(DisciplineType.STD_DISCIPLINES.invertpaleo);
                    }
                    return DisciplineType.getDiscipline(DisciplineType.STD_DISCIPLINES.vertpaleo);
                }
                return dispType;
            }
        }
        String msg = String.format("<html>Unable to automap type '%s' <BR>Catalog Series: '%s'", taxonDefName, catSeriesName);
        ToggleButtonChooserDlg<DisciplineType> dlg = new ToggleButtonChooserDlg<DisciplineType>(null, "Choose a Discipline", msg, (List<DisciplineType>)DisciplineType.getDisciplineList(), 3, ToggleButtonChooserPanel.Type.RadioButton);
        dlg.setUseScrollPane(true);
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            return dlg.getSelectedObject();
        }
        return null;
    }

    private DisciplineType getStandardDisciplineName(String name) {
        DisciplineType dispType = DisciplineType.getDiscipline(name.toLowerCase());
        if (dispType != null) {
            return dispType;
        }
        DisciplineType.STD_DISCIPLINES type = null;
        if (StringUtils.contains((String)name.toLowerCase(), (String)"paleo") || StringUtils.contains((String)name.toLowerCase(), (String)"fossil")) {
            type = StringUtils.contains((String)name.toLowerCase(), (String)"invert") ? DisciplineType.STD_DISCIPLINES.invertpaleo : (StringUtils.contains((String)name.toLowerCase(), (String)"botan") ? DisciplineType.STD_DISCIPLINES.paleobotany : DisciplineType.STD_DISCIPLINES.vertpaleo);
        } else if (this.checkName(new String[]{"Plant", "Herb", "Botan", "Fungi"}, name)) {
            type = DisciplineType.STD_DISCIPLINES.botany;
        } else if (this.checkName(new String[]{"ichthy", "Fish"}, name)) {
            type = DisciplineType.STD_DISCIPLINES.fish;
        } else if (this.checkName(new String[]{"FishHerps", "Herps", "Herp", "Frog", "Reptile", "Amphib"}, name)) {
            type = DisciplineType.STD_DISCIPLINES.herpetology;
        } else if (this.checkName(new String[]{"Bird", "Ornithology", "Ornith"}, name)) {
            type = DisciplineType.STD_DISCIPLINES.bird;
        } else if (this.checkName(new String[]{"Insect", "Ento", "Bug", "Spider", "arachn"}, name)) {
            type = DisciplineType.STD_DISCIPLINES.insect;
        } else if (this.checkName(new String[]{"Mineral", "Rock"}, name)) {
            type = DisciplineType.STD_DISCIPLINES.minerals;
        } else if (this.checkName(new String[]{"mammal", "mammals", "mammology"}, name)) {
            type = DisciplineType.STD_DISCIPLINES.mammal;
        }
        if (type != null) {
            return DisciplineType.getDiscipline(type);
        }
        return null;
    }

    public int createDataType() {
        int dataTypeId = -1;
        String dataTypeName = "Biota";
        if (dataTypeName == null) {
            return dataTypeId;
        }
        try {
            if (this.dataTypeNameToIds.get(dataTypeName) == null) {
                Statement updateStatement = this.newDBConn.createStatement();
                String updateStr = "INSERT INTO datatype ( TimestampCreated, TimestampModified, Name, Version, CreatedByAgentID, ModifiedByAgentID) VALUES ('" + nowStr + "','" + nowStr + "','" + dataTypeName + "', 0, " + this.getCreatorAgentId(null) + "," + this.getModifiedByAgentId(null) + ")";
                updateStatement.executeUpdate(updateStr);
                updateStatement.clearBatch();
                updateStatement.close();
                updateStatement = null;
                dataTypeId = BasicSQLUtils.getHighestId(this.newDBConn, "DataTypeID", "datatype");
                log.info((Object)("Created new datatype[" + dataTypeName + "]"));
                this.dataTypeNameToIds.put(dataTypeName, dataTypeId);
            } else {
                dataTypeId = this.dataTypeNameToIds.get(dataTypeName);
                log.info((Object)("Reusing new datatype[" + dataTypeName + "]"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)e);
            UIRegistry.showError(e.getMessage());
            throw new RuntimeException(e);
        }
        return dataTypeId;
    }

    public void doLocalizeSchema() {
        Session localSession = HibernateUtil.getNewSession();
        Transaction trans = null;
        try {
            try {
                for (Object obj : localSession.createQuery("FROM Discipline").list()) {
                    trans = localSession.beginTransaction();
                    Discipline discipline = (Discipline)obj;
                    BuildSampleDatabase bsd = new BuildSampleDatabase();
                    bsd.setSession(localSession);
                    bsd.loadSchemaLocalization(discipline, SpLocaleContainer.CORE_SCHEMA, DBTableIdMgr.getInstance(), "CatalogNumberNumeric", null, BuildSampleDatabase.UpdateType.eBuildNew, null);
                    localSession.save((Object)discipline);
                    trans.commit();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println(ex);
                trans.rollback();
                localSession.close();
            }
        }
        finally {
            localSession.close();
        }
    }

    public Integer createInstitution(String instName) {
        StorageTreeDef storageTreeDef = this.buildSampleStorageTreeDef();
        try {
            BasicSQLUtils.setIdentityInsertONCommandForSQLServer(this.newDBConn, "institution", BasicSQLUtils.myDestinationServerType);
            Statement updateStatement = this.newDBConn.createStatement();
            int institutionId = this.getNextIndex();
            strBuf.setLength(0);
            strBuf.append("INSERT INTO institution (InstitutionID, IsServerBased, IsAccessionsGlobal, IsSingleGeographyTree, IsSharingLocalities, TimestampModified, Name, TimestampCreated, StorageTreeDefID, ");
            strBuf.append("CreatedByAgentID, ModifiedByAgentID, Version, UserGroupScopeId, IsSecurityOn, Remarks) VALUES (");
            strBuf.append(String.valueOf(institutionId) + ",FALSE,FALSE,FALSE,FALSE,");
            strBuf.append("'" + dateTimeFormatter.format(now) + "',");
            strBuf.append("'" + instName + "',");
            strBuf.append("'" + dateTimeFormatter.format(now) + "',");
            strBuf.append(storageTreeDef.getStorageTreeDefId() + ",");
            strBuf.append(this.getCreatorAgentId(null) + "," + this.getModifiedByAgentId(null) + ",0, ");
            strBuf.append(institutionId);
            strBuf.append(", 0");
            strBuf.append(", 'Sp5Converted'");
            strBuf.append(")");
            log.info((Object)strBuf.toString());
            updateStatement.executeUpdate(strBuf.toString());
            updateStatement.clearBatch();
            updateStatement.close();
            return institutionId;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public void convertDivision(Integer institutionId) {
        try {
            strBuf.setLength(0);
            this.curDivisionID = this.getNextIndex();
            Statement updateStatement = this.newDBConn.createStatement();
            strBuf.append("INSERT INTO division (DivisionID, InstitutionID, TimestampModified, DisciplineType, Name, AltName, Abbrev, TimestampCreated, ");
            strBuf.append("CreatedByAgentID, ModifiedByAgentID, Version, UserGroupScopeId) VALUES (");
            strBuf.append(this.curDivisionID + ",");
            strBuf.append(institutionId + ",");
            strBuf.append("'" + dateTimeFormatter.format(now) + "',");
            strBuf.append("'" + this.disciplineType.getName() + "',");
            strBuf.append("'" + this.disciplineType.getTitle() + "',");
            strBuf.append("NULL,");
            strBuf.append("'" + this.disciplineType.getAbbrev() + "',");
            strBuf.append("'" + dateTimeFormatter.format(now) + "',");
            strBuf.append(this.getCreatorAgentId(null) + "," + this.getModifiedByAgentId(null) + ",0, ");
            strBuf.append(this.curDivisionID);
            strBuf.append(")");
            log.info((Object)strBuf.toString());
            updateStatement.executeUpdate(strBuf.toString());
            updateStatement.clearBatch();
            updateStatement.close();
            updateStatement = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Session cacheSession = DataBuilder.getSession();
        DataBuilder.setSession(null);
        Session localSession = HibernateUtil.getNewSession();
        List list = localSession.createQuery("FROM Division WHERE id = " + this.curDivisionID).list();
        this.division = (Division)list.get(0);
        localSession.close();
        AppContextMgr.getInstance().setClassObject(Division.class, this.division);
        DataBuilder.setSession(cacheSession);
    }

    public void persist(Object o) {
        if (this.session != null) {
            this.session.saveOrUpdate(o);
        }
    }

    public void setSession(Session s) {
        this.session = s;
    }

    public void startTx() {
        HibernateUtil.beginTransaction();
    }

    public void commitTx() {
        HibernateUtil.commitTransaction();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean convertCollectionObjectTypes(int specifyUserId, Agent userAgent) {
        try {
            Vector<Integer> colList;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            StringBuilder inSB = new StringBuilder();
            for (CollectionInfo ci : this.collectionInfoShortList) {
                if (hashSet.contains(ci.getTaxonomyTypeId())) continue;
                if (inSB.length() > 0) {
                    inSB.append(',');
                }
                inSB.append(ci.getTaxonomyTypeId());
                hashSet.add(ci.getTaxonomyTypeId());
            }
            StringBuilder sb = new StringBuilder("SELECT TaxonomyTypeID FROM taxonomytype WHERE TaxonomyTypeId in (");
            sb.append((CharSequence)inSB);
            sb.append(')');
            log.debug((Object)sb.toString());
            BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "datatype", BasicSQLUtils.myDestinationServerType);
            BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "discipline", BasicSQLUtils.myDestinationServerType);
            BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "collection", BasicSQLUtils.myDestinationServerType);
            Hashtable<Integer, Integer> newColObjIDTotaxonomyTypeID = new Hashtable<Integer, Integer>();
            TableWriter tblWriter = this.convLogger.getWriter("convertCollectionObjectTypes.html", "Collection Object Type");
            HashMap<Integer, Vector<CollectionInfo>> collDispHash = new HashMap<Integer, Vector<CollectionInfo>>();
            for (CollectionInfo info : this.collectionInfoShortList) {
                Vector<CollectionInfo> colInfoList = (Vector<CollectionInfo>)collDispHash.get(info.getTaxonomyTypeId());
                if (colInfoList == null) {
                    colInfoList = new Vector<CollectionInfo>();
                    collDispHash.put(info.getTaxonomyTypeId(), colInfoList);
                }
                colInfoList.add(info);
            }
            String dateTimeNow = dateTimeFormatter.format(now);
            int collectionCnt = 0;
            for (Integer taxonTypeId : collDispHash.keySet()) {
                DisciplineType.STD_DISCIPLINES dspType;
                boolean isEmbeddedCE;
                Vector collInfoList = (Vector)collDispHash.get(taxonTypeId);
                CollectionInfo info = null;
                for (CollectionInfo ci : collInfoList) {
                    if (ci.getCatSeriesId() == null) continue;
                    info = ci;
                    break;
                }
                if (info == null) {
                    info = (CollectionInfo)collInfoList.get(0);
                }
                String taxonomyTypeName = info.getTaxonomyTypeName();
                Integer taxonomyTypeID = info.getTaxonomyTypeId();
                String lastEditedBy = null;
                String msg = "Creating a new Discipline for taxonomyTypeName[" + taxonomyTypeName + "] disciplineType[" + this.disciplineType.getTitle() + "]";
                log.info((Object)msg);
                tblWriter.log(msg);
                DisciplineType disciplineTypeObj = info.getDisciplineTypeObj();
                if (disciplineTypeObj == null) {
                    disciplineTypeObj = this.getStandardDisciplineName(info.getTaxonomyTypeName(), info.getColObjTypeName(), info.getCatSeriesName());
                }
                boolean bl = isEmbeddedCE = (dspType = disciplineTypeObj.getDisciplineType()) != DisciplineType.STD_DISCIPLINES.fish;
                if (isEmbeddedCE && this.isSharingCollectingEvents) {
                    msg = "Will this Collection (" + info.getCatSeriesName() + ") be using Embedded Collecting Events (sub-form)?\n(You are being asked because it is sharing\nCollecting Events which means it should use a QueryCombobox)";
                    isEmbeddedCE = UIHelper.promptForAction("Embed", "Shared", "Embedded Collecting Events", msg);
                }
                taxonomyTypeName = disciplineTypeObj.getName();
                BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "datatype", BasicSQLUtils.myDestinationServerType);
                int dataTypeId = this.createDataType();
                if (dataTypeId == -1) {
                    msg = "**** Had to Skip record because of DataType mapping error[" + taxonomyTypeName + "]";
                    log.error((Object)msg);
                    tblWriter.logError(msg);
                    System.exit(1);
                }
                String taxTypeName = info.getTaxonomyTypeName();
                lastEditedBy = info.getCatSeriesLastEditedBy();
                taxonomyTypeID = info.getTaxonomyTypeId();
                BasicSQLUtils.setIdentityInsertONCommandForSQLServer(this.newDBConn, "discipline", BasicSQLUtils.myDestinationServerType);
                Statement updateStatement = this.newDBConn.createStatement();
                StringBuilder strBuf2 = new StringBuilder();
                this.curDisciplineID = this.getNextIndex();
                info.setDisciplineId(this.curDisciplineID);
                strBuf2.setLength(0);
                strBuf2.append("INSERT INTO discipline (DisciplineID, TimestampModified, Type, Name, TimestampCreated, ");
                strBuf2.append("DataTypeID, GeographyTreeDefID, GeologicTimePeriodTreeDefID, TaxonTreeDefID, DivisionID, ");
                strBuf2.append("CreatedByAgentID, ModifiedByAgentID, Version, UserGroupScopeId) VALUES (");
                strBuf2.append(info.getDisciplineId() + ",");
                strBuf2.append("'" + dateTimeNow + "',");
                strBuf2.append("'" + disciplineTypeObj.getName() + "',");
                strBuf2.append("'" + disciplineTypeObj.getTitle() + "',");
                strBuf2.append("'" + dateTimeNow + "',");
                strBuf2.append(String.valueOf(dataTypeId) + ",");
                strBuf2.append("1,");
                strBuf2.append("1,");
                strBuf2.append("1,");
                strBuf2.append(this.division.getDivisionId() + ",");
                strBuf2.append(this.getCreatorAgentId(null) + "," + this.getModifiedByAgentIdForAgent(lastEditedBy) + ",0, ");
                strBuf2.append(this.curDisciplineID);
                strBuf2.append(")");
                log.info((Object)strBuf2.toString());
                BasicSQLUtils.removeForeignKeyConstraints(this.newDBConn, BasicSQLUtils.myDestinationServerType);
                updateStatement.executeUpdate(strBuf2.toString());
                updateStatement.clearBatch();
                updateStatement.close();
                updateStatement = null;
                BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "discipline", BasicSQLUtils.myDestinationServerType);
                newColObjIDTotaxonomyTypeID.put(this.curDisciplineID, taxonomyTypeID);
                msg = "**** Created new discipline[" + taxonomyTypeName + "] is dataType [" + dataTypeId + "]";
                log.info((Object)msg);
                tblWriter.log(msg);
                Session localSession = HibernateUtil.getNewSession();
                for (CollectionInfo collInfo : collInfoList) {
                    Integer catalogSeriesID = collInfo.getCatSeriesId();
                    String seriesName = collInfo.getCatSeriesName();
                    String prefix = collInfo.getCatSeriesPrefix();
                    String remarks = collInfo.getCatSeriesRemarks();
                    collInfo.setDisciplineId(this.curDisciplineID);
                    AutoNumberingScheme cns = null;
                    if (catalogSeriesID != null && StringUtils.isNotEmpty((String)seriesName)) {
                        cns = this.catSeriesToAutoNumSchemeHash.get(catalogSeriesID);
                        if (cns == null) {
                            try {
                                cns = new AutoNumberingScheme();
                                cns.initialize();
                                cns.setIsNumericOnly(true);
                                cns.setSchemeClassName("");
                                cns.setSchemeName(seriesName);
                                cns.setTableNumber(CollectionObject.getClassTableId());
                                Transaction trans = localSession.beginTransaction();
                                localSession.save((Object)cns);
                                trans.commit();
                                this.catSeriesToAutoNumSchemeHash.put(catalogSeriesID, cns);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                throw new RuntimeException(ex);
                            }
                        }
                    } else {
                        seriesName = taxTypeName;
                    }
                    Integer catNumSchemeId = cns != null ? cns.getAutoNumberingSchemeId() : null;
                    collInfo.setCollectionId(this.getNextIndex());
                    this.curCollectionID = collInfo.getCollectionId();
                    msg = "**** Created new Collection [" + seriesName + "] is curCollectionID [" + this.curCollectionID + "]";
                    log.info((Object)msg);
                    updateStatement = this.newDBConn.createStatement();
                    strBuf.setLength(0);
                    strBuf.append("INSERT INTO collection (CollectionID, DisciplineID, CollectionName, Code, Remarks, CatalogFormatNumName, ");
                    strBuf.append("IsEmbeddedCollectingEvent, TimestampCreated, TimestampModified, CreatedByAgentID, ModifiedByAgentID, ");
                    strBuf.append("Version, UserGroupScopeId) VALUES (");
                    strBuf.append(this.curCollectionID + ",");
                    strBuf.append(this.curDisciplineID + ",");
                    strBuf.append(String.valueOf(BasicSQLUtils.getStrValue(seriesName)) + ",");
                    strBuf.append(String.valueOf(BasicSQLUtils.getStrValue(prefix)) + ",");
                    strBuf.append(String.valueOf(BasicSQLUtils.getStrValue(remarks)) + ",");
                    strBuf.append("'CatalogNumberNumeric',");
                    strBuf.append(String.valueOf(isEmbeddedCE ? 1 : 0) + ",");
                    strBuf.append("'" + dateTimeFormatter.format(now) + "',");
                    strBuf.append("'" + dateTimeFormatter.format(now) + "',");
                    strBuf.append(this.getCreatorAgentId(null) + "," + this.getModifiedByAgentId(lastEditedBy) + ", 0, ");
                    strBuf.append(this.curCollectionID);
                    strBuf.append(")");
                    log.debug((Object)strBuf.toString());
                    updateStatement.executeUpdate(strBuf.toString());
                    updateStatement.clearBatch();
                    updateStatement.close();
                    updateStatement = null;
                    if (catNumSchemeId != null && catalogSeriesID != null) {
                        this.joinCollectionAndAutoNum(this.curCollectionID, catNumSchemeId);
                        String hashKey = catalogSeriesID + "_" + taxonomyTypeID;
                        Integer newCatSeriesID = BasicSQLUtils.getHighestId(this.newDBConn, "CollectionID", "collection");
                        this.collectionHash.put(hashKey, newCatSeriesID);
                        if (StringUtils.isNotEmpty((String)prefix)) {
                            this.prefixHash.put(hashKey, prefix);
                        }
                        msg = "Collection New[" + newCatSeriesID + "] [" + seriesName + "] [" + prefix + "] curDisciplineID[" + this.curDisciplineID + "]";
                    } else {
                        msg = "Collection New[" + seriesName + "] [" + prefix + "] curDisciplineID[" + this.curDisciplineID + "]";
                    }
                    log.info((Object)msg);
                    tblWriter.log(msg);
                    ++collectionCnt;
                }
                localSession.close();
            }
            tblWriter.close();
            for (CollectionInfo ci : this.collectionInfoShortList) {
                if (ci.getCatSeriesId() == null) continue;
                log.debug((Object)("Cat Series: " + ci.getCatSeriesId() + " " + ci.getCollectionId()));
                colList = this.catSeriesToNewCollectionID.get(ci.getCatSeriesId());
                if (colList == null) {
                    colList = new Vector();
                    this.catSeriesToNewCollectionID.put(ci.getCatSeriesId(), colList);
                }
                colList.add(ci.getCollectionId());
            }
            for (Integer catSeriesId : this.catSeriesToNewCollectionID.keySet()) {
                colList = this.catSeriesToNewCollectionID.get(catSeriesId);
                if (colList.size() <= 1) continue;
                UIRegistry.showError("There are multiple Collections assigned to the same CatalogSeries and we can't handle that right now.");
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)e);
            UIRegistry.showError(e.toString());
            System.exit(0);
            return false;
        }
    }

    protected void joinCollectionAndAutoNum(Integer collId, Integer autoNumId) {
        try {
            Statement updateStatement = this.newDBConn.createStatement();
            strBuf.setLength(0);
            strBuf.append("INSERT INTO autonumsch_coll (CollectionID, AutoNumberingSchemeID) VALUES (");
            strBuf.append(collId + ",");
            strBuf.append(autoNumId.toString());
            strBuf.append(")");
            log.debug((Object)strBuf.toString());
            updateStatement.executeUpdate(strBuf.toString());
            updateStatement.clearBatch();
            updateStatement.close();
            updateStatement = null;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            UIRegistry.showError(ex.getMessage());
        }
    }

    public void createPermitTypePickList() {
        Session localSession = HibernateUtil.getCurrentSession();
        PickList pl = new PickList();
        pl.initialize();
        Set<PickListItemIFace> items = pl.getItems();
        try {
            pl.setName("Permit");
            pl.setSizeLimit(-1);
            HibernateUtil.beginTransaction();
            localSession.saveOrUpdate((Object)pl);
            HibernateUtil.commitTransaction();
        }
        catch (Exception ex) {
            log.error((Object)("******* " + ex));
            HibernateUtil.rollbackTransaction();
            throw new RuntimeException("Couldn't create PickList for [Permit]");
        }
        try {
            Statement stmt = this.oldDBConn.createStatement(1004, 1007);
            stmt.setFetchSize(Integer.MIN_VALUE);
            String sqlStr = "select distinct Type from permit where Type is not null";
            log.info((Object)sqlStr);
            ResultSet rs = stmt.executeQuery(sqlStr);
            if (!rs.first()) {
                return;
            }
            int count = 0;
            do {
                String typeStr;
                if ((typeStr = rs.getString(1)) == null) continue;
                log.info((Object)("Permit Type[" + typeStr + "]"));
                PickListItem pli = new PickListItem();
                pli.initialize();
                pli.setTitle(typeStr);
                pli.setValue(typeStr);
                pli.setTimestampCreated(now);
                items.add(pli);
                pli.setPickList(pl);
                ++count;
            } while (rs.next());
            log.info((Object)("Processed Permit Types " + count + " records."));
            HibernateUtil.beginTransaction();
            localSession.saveOrUpdate((Object)pl);
            HibernateUtil.commitTransaction();
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public boolean convertUSYSToPicklist(Session localSession, Collection collection, String usysTableName, String pickListName) {
        ResultSet rs;
        boolean useField;
        PickList pl;
        int fieldSetInx;
        int dataInx;
        block17: {
            List<FieldMetaData> fieldMetaData = BasicSQLUtils.getFieldMetaDataFromSchema(this.oldDBConn, usysTableName);
            int ifaceInx = -1;
            dataInx = -1;
            fieldSetInx = -1;
            int i = 0;
            for (FieldMetaData md : fieldMetaData) {
                if (ifaceInx == -1 && md.getName().equals("InterfaceID")) {
                    ifaceInx = i + 1;
                } else if (fieldSetInx == -1 && md.getName().equals("FieldSetSubTypeID")) {
                    fieldSetInx = i + 1;
                } else if (dataInx == -1 && md.getType().toLowerCase().indexOf("varchar") > -1) {
                    dataInx = i + 1;
                }
                ++i;
            }
            if (ifaceInx == -1 || dataInx == -1 || fieldSetInx == -1) {
                throw new RuntimeException("Couldn't decypher USYS table ifaceInx[" + ifaceInx + "] dataInx[" + dataInx + "] fieldSetInx[" + fieldSetInx + "]");
            }
            pl = new PickList();
            pl.initialize();
            try {
                pl.setName(pickListName);
                if (pickListName.equals("PrepType")) {
                    pl.setReadOnly(true);
                    pl.setSizeLimit(-1);
                    pl.setIsSystem(true);
                    pl.setTableName("preptype");
                    pl.setType((byte)1);
                } else {
                    pl.setReadOnly(false);
                    pl.setSizeLimit(-1);
                }
                pl.setCollection(collection);
                collection.getPickLists().add(pl);
                Transaction trans = localSession.beginTransaction();
                localSession.saveOrUpdate((Object)pl);
                localSession.saveOrUpdate((Object)collection);
                trans.commit();
                localSession.flush();
            }
            catch (Exception ex) {
                log.error((Object)("******* " + ex));
                HibernateUtil.rollbackTransaction();
                throw new RuntimeException("Couldn't create PickList for [" + usysTableName + "]");
            }
            Statement stmt = this.oldDBConn.createStatement(1004, 1007);
            stmt.setFetchSize(Integer.MIN_VALUE);
            String sqlStr = "select * from " + usysTableName + " where InterfaceID is not null";
            log.info((Object)sqlStr);
            useField = false;
            rs = stmt.executeQuery(sqlStr);
            if (rs.first()) break block17;
            return true;
        }
        try {
            do {
                Object fieldObj;
                if ((fieldObj = rs.getObject(fieldSetInx)) == null) continue;
                useField = true;
                break;
            } while (rs.next());
            Hashtable<String, String> values = new Hashtable<String, String>();
            rs.first();
            int count = 0;
            do {
                if (useField && rs.getObject(fieldSetInx) == null) continue;
                String val = rs.getString(dataInx);
                String lowerStr = val.toLowerCase();
                if (values.get(lowerStr) == null) {
                    pl.addItem(val, val);
                    values.put(lowerStr, val);
                    ++count;
                    continue;
                }
                log.info((Object)("Discarding duplicate picklist value[" + val + "]"));
            } while (rs.next());
            log.info((Object)("Processed " + usysTableName + "  " + count + " records."));
            Transaction trans = localSession.beginTransaction();
            localSession.saveOrUpdate((Object)pl);
            trans.commit();
            localSession.flush();
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public boolean convertUSYSTables(Session localSession, Collection collection) {
        log.info((Object)"Creating picklists");
        log.info((Object)"Converting USYS Tables.");
        Session cachedSession = DataBuilder.getSession();
        DataBuilder.setSession(null);
        String[] tables = new String[]{"usysaccessionstatus", "AccessionStatus", "usysaccessiontype", "AccessionType", "usysborrowagenrole", "BorrowAgentRole", "usysaccessionarole", "AccessionRole", "usysdeaccessiorole", "DeaccessionaRole", "usysloanagentsrole", "LoanAgentRole", "usysbiologicalsex", "BiologicalSex", "usysbiologicalstage", "BiologicalStage", "usyscollectingmethod", "CollectingMethod", "usyscollobjprepmeth", "CollObjPrepMeth", "usysdeaccessiotype", "DeaccessionType", "usysdeterminatconfidence", "DeterminationConfidence", "usysdeterminatmethod", "DeterminationMethod", "usysdeterminattypestatusname", "TypeStatus", "usyshabitathabitattype", "HabitatType", "usyslocalityelevationmethod", "LocalityElevationMethod", "usysobservatioobservationmetho", "ObservationMethod", "usyspermittype", "PermitType", "usyspreparatiocontainertype", "PrepContainertype", "usyspreparatiomedium", "PreparatioMedium", "usysshipmentshipmentmethod", "ShipmentMethod", "usyslocalitylatlongmethod", "LatLonMethod"};
        this.setProcess(0, tables.length);
        int i = 0;
        while (i < tables.length) {
            this.setDesc("Converting " + tables[i]);
            this.setProcess(i);
            boolean status = this.convertUSYSToPicklist(localSession, collection, tables[i], tables[i + 1]);
            if (!status) {
                log.error((Object)(String.valueOf(tables[i]) + " failed to convert."));
                return false;
            }
            ++i;
            ++i;
        }
        DataBuilder.setSession(cachedSession);
        this.setProcess(tables.length);
        return true;
    }

    public Map<String, PrepType> createPreparationTypesFromUSys(Collection collection) {
        log.debug((Object)("Creating PrepTypes for Collection: " + collection.getCollectionName()));
        Hashtable<String, PrepType> prepTypeMapper = new Hashtable<String, PrepType>();
        CollectionInfo colInfo = CollectionInfo.getCollectionObjectTypeForNewCollection(collection);
        if (colInfo == null) {
            throw new RuntimeException("Couldn't locate a CollectionInfo for collection: " + collection.getId());
        }
        String sql = "select preparationmethod FROM usyscollobjprepmeth pt inner join usysmetafieldsetsubtype st on st.fieldsetsubtypeid = pt.fieldsetsubtypeid inner join collectionobjecttype ct1 on ct1.collectionobjecttypeid = st.fieldvalue inner join collectionobjecttype ct on ct.collectionobjecttypename = replace(ct1.collectionobjecttypename, ' Preparation', '') inner join catalogseriesdefinition csd on csd.objecttypeid = ct.collectionobjecttypeid inner join catalogseries cs on cs.catalogseriesid = csd.catalogseriesid WHERE csd.catalogseriesid = " + colInfo.getCatSeriesId() + "  GROUP BY preparationmethod";
        log.info((Object)sql);
        boolean foundMisc = false;
        int count = 0;
        Vector<Object> list = BasicSQLUtils.querySingleCol(this.oldDBConn, sql);
        if (list.size() > 0) {
            for (Object nameObj : list) {
                String name = nameObj.toString();
                log.debug((Object)("Creating prep type[" + name + "] for collection " + collection.getCollectionName()));
                PrepType prepType = AttrUtils.loadPrepType(name, collection);
                prepTypeMapper.put(name.toLowerCase(), prepType);
                if (name.equalsIgnoreCase("misc")) {
                    foundMisc = true;
                }
                ++count;
            }
        }
        if (!foundMisc) {
            String name = "Misc";
            PrepType prepType = AttrUtils.loadPrepType(name, collection);
            prepTypeMapper.put(name.toLowerCase(), prepType);
            ++count;
        }
        log.info((Object)("Processed PrepType " + count + " records."));
        return prepTypeMapper;
    }

    protected String convertColumnName(String name) {
        StringBuilder nameStr = new StringBuilder();
        int cnt = 0;
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (cnt == 0) {
                nameStr.append(name.toUpperCase().charAt(0));
                ++cnt;
            } else if (c < 'a') {
                nameStr.append(' ');
                nameStr.append(c);
            } else {
                nameStr.append(c);
            }
            ++n2;
        }
        return nameStr.toString();
    }

    protected Object getData(AttributeIFace.FieldType type, AttributeIFace attr) {
        if (type == AttributeIFace.FieldType.BooleanType) {
            if (attr.getDblValue() != 0.0) {
                return true;
            }
            return false;
        }
        if (type == AttributeIFace.FieldType.FloatType) {
            return Float.valueOf(attr.getDblValue().floatValue());
        }
        if (type == AttributeIFace.FieldType.DoubleType) {
            return attr.getDblValue();
        }
        if (type == AttributeIFace.FieldType.IntegerType) {
            return attr.getDblValue().intValue();
        }
        return attr.getStrValue();
    }

    protected Object getData(ResultSet rs, int index, AttributeIFace.FieldType type, FieldMetaData metaData) {
        AttributeIFace.FieldType oldType = this.getDataType(metaData.getName(), metaData.getType());
        try {
            Object value = rs.getObject(index);
            if (type == AttributeIFace.FieldType.BooleanType) {
                if (value == null) {
                    return false;
                }
                if (oldType == AttributeIFace.FieldType.IntegerType) {
                    if (rs.getInt(index) != 0) {
                        return true;
                    }
                    return false;
                }
                if (oldType == AttributeIFace.FieldType.FloatType) {
                    if (rs.getFloat(index) != 0.0f) {
                        return true;
                    }
                    return false;
                }
                if (oldType == AttributeIFace.FieldType.DoubleType) {
                    if (rs.getDouble(index) != 0.0) {
                        return true;
                    }
                    return false;
                }
                if (oldType == AttributeIFace.FieldType.StringType) {
                    return rs.getString(index).equalsIgnoreCase("true");
                }
                log.error((Object)("Error maping from schema[" + metaData.getType() + "] to [" + type.toString() + "]"));
                return false;
            }
            if (type == AttributeIFace.FieldType.FloatType) {
                if (value == null) {
                    return Float.valueOf(0.0f);
                }
                if (oldType == AttributeIFace.FieldType.FloatType) {
                    return Float.valueOf(rs.getFloat(index));
                }
                if (oldType == AttributeIFace.FieldType.DoubleType) {
                    return Float.valueOf(rs.getFloat(index));
                }
                log.error((Object)("Error maping from schema[" + metaData.getType() + "] to [" + type.toString() + "]"));
                return Float.valueOf(0.0f);
            }
            if (type == AttributeIFace.FieldType.DoubleType) {
                if (value == null) {
                    return 0.0;
                }
                if (oldType == AttributeIFace.FieldType.FloatType) {
                    return rs.getDouble(index);
                }
                if (oldType == AttributeIFace.FieldType.DoubleType) {
                    return rs.getDouble(index);
                }
                log.error((Object)("Error maping from schema[" + metaData.getType() + "] to [" + type.toString() + "]"));
                return 0.0;
            }
            if (type == AttributeIFace.FieldType.IntegerType) {
                if (value == null) {
                    return 0;
                }
                if (oldType == AttributeIFace.FieldType.IntegerType) {
                    if (rs.getInt(index) != 0) {
                        return true;
                    }
                    return false;
                }
                log.error((Object)("Error maping from schema[" + metaData.getType() + "] to [" + type.toString() + "]"));
                return 0;
            }
            return rs.getString(index);
        }
        catch (SQLException ex) {
            log.error((Object)("Error maping from schema[" + metaData.getType() + "] to [" + type.toString() + "]"));
            log.error((Object)ex);
            throw new RuntimeException(ex);
        }
    }

    protected void setData(ResultSet rs, int index, AttributeIFace.FieldType type, FieldMetaData metaData, CollectionObjectAttr colObjAttr) {
        AttributeIFace.FieldType oldType = this.getDataType(metaData.getName(), metaData.getType());
        try {
            Object value = rs.getObject(index);
            if (type == AttributeIFace.FieldType.BooleanType) {
                if (value == null) {
                    colObjAttr.setDblValue(0.0);
                } else if (oldType == AttributeIFace.FieldType.IntegerType) {
                    colObjAttr.setDblValue(rs.getInt(index) != 0 ? 1.0 : 0.0);
                } else if (oldType == AttributeIFace.FieldType.FloatType) {
                    colObjAttr.setDblValue(rs.getFloat(index) != 0.0f ? 1.0 : 0.0);
                } else if (oldType == AttributeIFace.FieldType.DoubleType) {
                    colObjAttr.setDblValue(rs.getDouble(index) != 0.0 ? 1.0 : 0.0);
                } else if (oldType == AttributeIFace.FieldType.StringType) {
                    colObjAttr.setDblValue(rs.getString(index).equalsIgnoreCase("true") ? 1.0 : 0.0);
                } else {
                    log.error((Object)("Error maping from schema[" + metaData.getType() + "] to [" + type.toString() + "]"));
                }
            } else if (type == AttributeIFace.FieldType.IntegerType || type == AttributeIFace.FieldType.DoubleType || type == AttributeIFace.FieldType.FloatType) {
                if (value == null) {
                    colObjAttr.setDblValue(0.0);
                } else if (oldType == AttributeIFace.FieldType.IntegerType) {
                    colObjAttr.setDblValue(Double.valueOf(rs.getInt(index)));
                } else if (oldType == AttributeIFace.FieldType.FloatType) {
                    colObjAttr.setDblValue(Double.valueOf(rs.getFloat(index)));
                } else if (oldType == AttributeIFace.FieldType.DoubleType) {
                    colObjAttr.setDblValue(rs.getDouble(index));
                } else {
                    log.error((Object)("Error maping from schema[" + metaData.getType() + "] to [" + type.toString() + "]"));
                }
            } else {
                colObjAttr.setStrValue(rs.getString(index));
            }
        }
        catch (SQLException ex) {
            log.error((Object)("Error maping from schema[" + metaData.getType() + "] to [" + type.toString() + "]"));
            log.error((Object)ex);
            throw new RuntimeException(ex);
        }
    }

    protected AttributeIFace.FieldType getDataType(String name, String type) {
        if (name.startsWith("YesNo")) {
            return AttributeIFace.FieldType.BooleanType;
        }
        if (type.equalsIgnoreCase("float")) {
            return AttributeIFace.FieldType.FloatType;
        }
        if (type.equalsIgnoreCase("double")) {
            return AttributeIFace.FieldType.DoubleType;
        }
        if (type.startsWith("varchar") || type.startsWith("text") || type.startsWith("longtext")) {
            return AttributeIFace.FieldType.StringType;
        }
        return AttributeIFace.FieldType.IntegerType;
    }

    protected Object getMappedId(Object data, String fromTableName, String oldColName) {
        if (this.idMapperMgr != null && oldColName.endsWith("ID")) {
            IdMapperIFace idMapper = this.idMapperMgr.get(fromTableName, oldColName);
            if (idMapper != null) {
                return idMapper.get((Integer)data);
            }
            if (!(oldColName.equals("MethodID") || oldColName.equals("RoleID") || oldColName.equals("CollectionID") || oldColName.equals("ConfidenceID") || oldColName.equals("TypeStatusNameID") || oldColName.equals("ObservationMethodID"))) {
                log.debug((Object)("No Map for [" + fromTableName + "][" + oldColName + "]"));
            }
        }
        return data;
    }

    public boolean convertBiologicalAttrs(Discipline discipline, Map<String, String> colToNameMap, Map<String, Short> typeMap) {
        block21: {
            AttributeIFace.FieldType[] attrTypes = new AttributeIFace.FieldType[]{AttributeIFace.FieldType.IntegerType, AttributeIFace.FieldType.FloatType, AttributeIFace.FieldType.DoubleType, AttributeIFace.FieldType.BooleanType, AttributeIFace.FieldType.StringType};
            Session localSession = HibernateUtil.getCurrentSession();
            BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "collectionobjectattr", BasicSQLUtils.myDestinationServerType);
            BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "attributedef", BasicSQLUtils.myDestinationServerType);
            try {
                Statement stmt = this.oldDBConn.createStatement(1004, 1007);
                stmt.setFetchSize(Integer.MIN_VALUE);
                ArrayList oldFieldMetaData = new ArrayList();
                Map<String, FieldMetaData> oldFieldMetaDataMap = BasicSQLUtils.getFieldMetaDataFromSchemaHash(this.oldDBConn, "biologicalobjectattributes");
                ArrayList<String> columnsInUse = new ArrayList<String>();
                Hashtable<String, AttributeDef> attrDefs = new Hashtable<String, AttributeDef>();
                ArrayList<Integer> counts = new ArrayList<Integer>();
                int totalCount = 0;
                for (FieldMetaData md : oldFieldMetaData) {
                    if (md.getName().indexOf("ID") != -1 || md.getName().indexOf("Timestamp") != -1 || md.getName().indexOf("LastEditedBy") != -1) continue;
                    oldFieldMetaDataMap.put(md.getName(), md);
                    String sqlStr = "select count(" + md.getName() + ") from biologicalobjectattributes where " + md.getName() + " is not null";
                    ResultSet rs = stmt.executeQuery(sqlStr);
                    if (rs.first() && rs.getInt(1) > 0) {
                        Short type;
                        int rowCount = rs.getInt(1);
                        totalCount += rowCount;
                        counts.add(rowCount);
                        log.info((Object)(String.valueOf(md.getName()) + " has " + rowCount + " rows of values"));
                        columnsInUse.add(md.getName());
                        AttributeDef attrDef = new AttributeDef();
                        String newName = this.convertColumnName(md.getName());
                        attrDef.setFieldName(newName);
                        log.debug((Object)("mapping[" + newName + "][" + md.getName() + "]"));
                        short dataType = -1;
                        if (typeMap != null && (type = typeMap.get(md.getName())) == null) {
                            dataType = type;
                        }
                        if (dataType == -1) {
                            dataType = this.getDataType(md.getName(), md.getType()).getType();
                        }
                        attrDef.setDataType(dataType);
                        attrDef.setDiscipline(discipline);
                        attrDef.setTableType(TableType.CollectionObject.getType());
                        attrDef.setTimestampCreated(now);
                        attrDefs.put(md.getName(), attrDef);
                        try {
                            HibernateUtil.beginTransaction();
                            localSession.save((Object)attrDef);
                            HibernateUtil.commitTransaction();
                        }
                        catch (Exception e) {
                            log.error((Object)("******* " + e));
                            HibernateUtil.rollbackTransaction();
                            throw new RuntimeException(e);
                        }
                    }
                    rs.close();
                }
                log.info((Object)("Total Number of Attrs: " + totalCount));
                log.info((Object)("biologicalobjectattributes columns in use: " + columnsInUse.size()));
                if (columnsInUse.size() <= 0) break block21;
                int inx = 0;
                StringBuilder str = new StringBuilder("select BiologicalObjectAttributesID");
                for (String name : columnsInUse) {
                    str.append(", ");
                    str.append(name);
                    ++inx;
                }
                str.append(" from biologicalobjectattributes order by BiologicalObjectAttributesID");
                log.info((Object)("sql: " + str.toString()));
                ResultSet rs = stmt.executeQuery(str.toString());
                int[] countVerify = new int[counts.size()];
                int i = 0;
                while (i < countVerify.length) {
                    countVerify[i] = 0;
                    ++i;
                }
                boolean useHibernate = false;
                StringBuilder strBufInner = new StringBuilder();
                int recordCount = 0;
                while (rs.next()) {
                    if (useHibernate) {
                        Criteria criteria = localSession.createCriteria(CollectionObject.class);
                        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
                        criteria.add((Criterion)Restrictions.eq((String)"collectionObjectId", (Object)rs.getInt(1)));
                        List list = criteria.list();
                        if (list.size() == 0) {
                            log.error((Object)("**** Can't find the CollectionObject " + rs.getInt(1)));
                            continue;
                        }
                        CollectionObject colObj = (CollectionObject)list.get(0);
                        inx = 2;
                        for (String name : columnsInUse) {
                            AttributeDef attrDef = (AttributeDef)attrDefs.get(name);
                            FieldMetaData md = oldFieldMetaDataMap.get(name);
                            CollectionObjectAttr colObjAttr = new CollectionObjectAttr();
                            colObjAttr.setCollectionObject(colObj);
                            colObjAttr.setDefinition(attrDef);
                            colObjAttr.setTimestampCreated(now);
                            this.setData(rs, inx, attrTypes[attrDef.getDataType()], md, colObjAttr);
                            HibernateUtil.beginTransaction();
                            localSession.save((Object)colObjAttr);
                            HibernateUtil.commitTransaction();
                            ++inx;
                            if (recordCount % 2000 == 0) {
                                log.info((Object)("CollectionObjectAttr Records Processed: " + recordCount));
                            }
                            ++recordCount;
                        }
                        continue;
                    }
                    inx = 2;
                    for (String name : columnsInUse) {
                        AttributeDef attrDef = (AttributeDef)attrDefs.get(name);
                        FieldMetaData md = oldFieldMetaDataMap.get(name);
                        if (rs.getObject(inx) != null) {
                            Integer newRecId = (Integer)this.getMappedId(rs.getInt(1), "biologicalobjectattributes", "BiologicalObjectAttributesID");
                            Object data = this.getData(rs, inx, attrTypes[attrDef.getDataType()], md);
                            boolean isStr = data instanceof String;
                            int n = inx - 2;
                            countVerify[n] = countVerify[n] + 1;
                            strBufInner.setLength(0);
                            strBufInner.append("INSERT INTO collectionobjectattr VALUES (");
                            strBufInner.append("NULL");
                            strBufInner.append(",");
                            strBufInner.append(BasicSQLUtils.getStrValue(isStr ? data : null));
                            strBufInner.append(",");
                            strBufInner.append(BasicSQLUtils.getStrValue(isStr ? null : data));
                            strBufInner.append(",");
                            strBufInner.append(BasicSQLUtils.getStrValue(now));
                            strBufInner.append(",");
                            strBufInner.append(BasicSQLUtils.getStrValue(now));
                            strBufInner.append(",");
                            strBufInner.append(newRecId);
                            strBufInner.append(",");
                            strBufInner.append(BasicSQLUtils.getStrValue(attrDef.getAttributeDefId()));
                            strBufInner.append(")");
                            try {
                                Statement updateStatement = this.newDBConn.createStatement();
                                BasicSQLUtils.removeForeignKeyConstraints(this.newDBConn, BasicSQLUtils.myDestinationServerType);
                                updateStatement.executeUpdate(strBufInner.toString());
                                updateStatement.clearBatch();
                                updateStatement.close();
                                updateStatement = null;
                            }
                            catch (SQLException e) {
                                log.error((Object)strBufInner.toString());
                                log.error((Object)("Count: " + recordCount));
                                e.printStackTrace();
                                log.error((Object)e);
                                throw new RuntimeException(e);
                            }
                            if (recordCount % 2000 == 0) {
                                log.info((Object)("CollectionObjectAttr Records Processed: " + recordCount));
                            }
                            ++recordCount;
                        }
                        ++inx;
                    }
                }
                rs.close();
                stmt.close();
                log.info((Object)"Count Verification:");
                int i2 = 0;
                while (i2 < counts.size()) {
                    log.info((Object)(String.valueOf((String)columnsInUse.get(i2)) + " [" + counts.get(i2) + "][" + countVerify[i2] + "] " + ((Integer)counts.get(i2) - countVerify[i2])));
                    ++i2;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                log.error((Object)e);
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public boolean convertLoanRecords(boolean doingGifts) {
        ResultSet rs;
        Map<String, String> colNewToOldMap;
        Hashtable<String, Integer> oldNameIndex;
        List<FieldMetaData> newFieldMetaData;
        StringBuilder str;
        Statement stmt;
        IdTableMapper loanIdMapper;
        Hashtable<String, Boolean> fieldToSkip;
        String newTableName;
        block46: {
            block45: {
                newTableName = doingGifts ? "gift" : "loan";
                BasicSQLUtils.setIdentityInsertONCommandForSQLServer(this.newDBConn, newTableName, BasicSQLUtils.myDestinationServerType);
                BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, newTableName, BasicSQLUtils.myDestinationServerType);
                if (BasicSQLUtils.getNumRecords(this.oldDBConn, "loan") == 0) {
                    return true;
                }
                String[] ignoredFields = new String[]{"SpecialConditions", "AddressOfRecordID", "DateReceived", "ReceivedComments", "PurposeOfLoan", "OverdueNotiSetDate", "IsFinancialResponsibility", "Version", "CreatedByAgentID", "IsFinancialResponsibility", "SrcTaxonomy", "SrcGeography", "CollectionMemberID", "PurposeOfGift", "IsFinancialResponsibility", "SpecialConditions", "ReceivedComments", "AddressOfRecordID"};
                fieldToSkip = new Hashtable<String, Boolean>();
                String[] stringArray = ignoredFields;
                int n = ignoredFields.length;
                int n2 = 0;
                while (n2 < n) {
                    String nm = stringArray[n2];
                    fieldToSkip.put(nm, true);
                    ++n2;
                }
                loanIdMapper = (IdTableMapper)this.idMapperMgr.get(newTableName, doingGifts ? "GiftID" : "LoanID");
                stmt = this.oldDBConn.createStatement(1004, 1007);
                stmt.setFetchSize(Integer.MIN_VALUE);
                str = new StringBuilder();
                List<String> oldFieldNames = BasicSQLUtils.getFieldNamesFromSchema(this.oldDBConn, "loan");
                StringBuilder sql = new StringBuilder("SELECT ");
                sql.append(BasicSQLUtils.buildSelectFieldList(oldFieldNames, "loan"));
                sql.append(" FROM loan WHERE loan.Category = ");
                sql.append(doingGifts ? "1" : "0");
                sql.append(" ORDER BY loan.LoanID");
                log.info((Object)sql);
                newFieldMetaData = BasicSQLUtils.getFieldMetaDataFromSchema(this.newDBConn, newTableName);
                log.info((Object)("Number of Fields in New " + newTableName + " " + newFieldMetaData.size()));
                String sqlStr = sql.toString();
                if (doingGifts && loanIdMapper == null) {
                    StringBuilder mapSQL = new StringBuilder("SELECT LoanID FROM loan WHERE loan.Category = ");
                    mapSQL.append(doingGifts ? "1" : "0");
                    mapSQL.append(" ORDER BY loan.LoanID");
                    log.info((Object)mapSQL.toString());
                    BasicSQLUtils.deleteAllRecordsFromTable(this.oldDBConn, "gift_GiftID", BasicSQLUtils.myDestinationServerType);
                    loanIdMapper = new IdTableMapper(newTableName, "GiftID", mapSQL.toString(), false, false);
                    this.idMapperMgr.addMapper(loanIdMapper);
                    loanIdMapper.mapAllIdsWithSQL();
                }
                oldNameIndex = new Hashtable<String, Integer>();
                int inx = 1;
                for (String name : oldFieldNames) {
                    oldNameIndex.put(name, inx++);
                }
                colNewToOldMap = doingGifts ? BasicSQLUtils.createFieldNameMap(new String[]{"GiftNumber", "LoanNumber", "GiftDate", "LoanDate", "IsCurrent", "Current", "IsClosed", "Closed"}) : BasicSQLUtils.createFieldNameMap(new String[]{"IsCurrent", "Current", "IsClosed", "Closed"});
                log.info((Object)sqlStr);
                rs = stmt.executeQuery(sqlStr);
                if (!this.hasFrame) break block45;
                if (rs.last()) {
                    this.setProcess(0, rs.getRow());
                    rs.first();
                    break block46;
                }
                rs.close();
                stmt.close();
                return true;
            }
            if (rs.first()) break block46;
            rs.close();
            stmt.close();
            return true;
        }
        try {
            PartialDateConv partialDateConv = new PartialDateConv();
            int lastEditedByInx = (Integer)oldNameIndex.get("LastEditedBy");
            int count = 0;
            do {
                String newFieldName;
                partialDateConv.nullAll();
                String lastEditedBy = rs.getString(lastEditedByInx);
                str.setLength(0);
                StringBuffer fieldList = new StringBuffer();
                fieldList.append("( ");
                int i = 0;
                while (i < newFieldMetaData.size()) {
                    if (i > 0 && i < newFieldMetaData.size()) {
                        fieldList.append(", ");
                    }
                    newFieldName = newFieldMetaData.get(i).getName();
                    fieldList.append(newFieldName);
                    ++i;
                }
                fieldList.append(")");
                str.append("INSERT INTO " + newTableName + " " + fieldList + " VALUES (");
                i = 0;
                while (i < newFieldMetaData.size()) {
                    if (i > 0) {
                        str.append(", ");
                    }
                    newFieldName = newFieldMetaData.get(i).getName();
                    if (i == 0) {
                        Integer oldID = rs.getInt(1);
                        Integer newID = loanIdMapper.get(oldID);
                        if (newID != null) {
                            str.append(BasicSQLUtils.getStrValue(newID));
                        } else {
                            log.error((Object)(String.valueOf(newTableName) + " Old/New ID problem [" + oldID + "][" + newID + "]"));
                        }
                    } else if (newFieldName.equals("Version")) {
                        str.append("0");
                    } else if (newFieldName.equals("CreatedByAgentID")) {
                        str.append(this.getCreatorAgentId(null));
                    } else if (newFieldName.equals("ModifiedByAgentID")) {
                        String lastEditedByStr = rs.getString(lastEditedByInx);
                        str.append(this.getModifiedByAgentId(lastEditedByStr));
                    } else if (fieldToSkip.get(newFieldName) != null) {
                        str.append("NULL");
                    } else if (newFieldName.equals("DisciplineID")) {
                        str.append(this.curDisciplineID);
                    } else if (newFieldName.equals("DivisionID")) {
                        str.append(this.curDivisionID);
                    } else {
                        Integer index = null;
                        String oldMappedColName = colNewToOldMap.get(newFieldName);
                        if (oldMappedColName != null) {
                            index = (Integer)oldNameIndex.get(oldMappedColName);
                        } else {
                            index = (Integer)oldNameIndex.get(newFieldName);
                            oldMappedColName = newFieldName;
                        }
                        if (index == null) {
                            String msg = "convertLoanRecords - Couldn't find new field name[" + newFieldName + "] in old field name in index Map";
                            log.error((Object)msg);
                            stmt.close();
                            throw new RuntimeException(msg);
                        }
                        Object data = rs.getObject(index);
                        if (data != null) {
                            int idInx = newFieldName.lastIndexOf("ID");
                            if (this.idMapperMgr != null && idInx > -1) {
                                IdMapperIFace idMapper = this.idMapperMgr.get("loan", oldMappedColName);
                                if (idMapper != null) {
                                    data = idMapper.get(rs.getInt(index));
                                } else {
                                    log.error((Object)("No Map for [loan][" + oldMappedColName + "]"));
                                }
                            }
                        }
                        BasicSQLUtils.fixTimestamps(newFieldName, newFieldMetaData.get(i).getType(), data, str);
                    }
                    ++i;
                }
                str.append(")");
                if (this.hasFrame) {
                    if (count % 500 == 0) {
                        this.setProcess(count);
                    }
                } else if (count % 2000 == 0) {
                    log.info((Object)("Loan/Gifts Records: " + count));
                }
                try {
                    Statement updateStatement = this.newDBConn.createStatement();
                    updateStatement.executeUpdate(str.toString());
                    updateStatement.clearBatch();
                    updateStatement.close();
                    updateStatement = null;
                }
                catch (SQLException e) {
                    log.error((Object)("Count: " + count));
                    log.error((Object)("Exception on insert: " + str.toString()));
                    e.printStackTrace();
                    log.error((Object)e);
                    rs.close();
                    stmt.close();
                    throw new RuntimeException(e);
                }
                ++count;
            } while (rs.next());
            if (this.hasFrame) {
                this.setProcess(count);
            } else {
                log.info((Object)("Processed Loan/Gift " + count + " records."));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "determination", BasicSQLUtils.myDestinationServerType);
        return true;
    }

    public boolean convertLoanAgentRecords(boolean doingGifts) {
        Integer totalCnt;
        StringBuilder str;
        IdMapperIFace loanMapper;
        IdMapperIFace agentAddrIDMapper;
        String refName;
        String idName;
        String newTableName;
        TableWriter tblWriter;
        block21: {
            tblWriter = this.convLogger.getWriter("convert" + (doingGifts ? "Gift" : "Loan") + ".html", doingGifts ? "Gifts" : "Loans");
            newTableName = doingGifts ? "giftagent" : "loanagent";
            idName = doingGifts ? "GiftAgentID" : "LoanAgentID";
            refName = doingGifts ? "GiftID" : "LoanID";
            BasicSQLUtils.setIdentityInsertONCommandForSQLServer(this.newDBConn, newTableName, BasicSQLUtils.myDestinationServerType);
            BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, newTableName, BasicSQLUtils.myDestinationServerType);
            if (BasicSQLUtils.getNumRecords(this.oldDBConn, "loanagents") == 0) {
                return true;
            }
            agentAddrIDMapper = this.idMapperMgr.get("agentaddress", "AgentAddressID");
            loanMapper = null;
            if (doingGifts) {
                IdTableMapper idMapper = new IdTableMapper(newTableName, "GiftID", "SELECT LoanID FROM loan WHERE Category = 1 ORDER BY LoanID", true, false);
                this.idMapperMgr.addMapper(idMapper);
                if (shouldCreateMapTables) {
                    idMapper.mapAllIdsWithSQL();
                }
                loanMapper = idMapper;
            } else {
                loanMapper = this.idMapperMgr.get("loan", "LoanID");
            }
            str = new StringBuilder();
            StringBuilder cntSQL = new StringBuilder("SELECT count(*) FROM loanagents la INNER JOIN loan l ON la.LoanID = l.LoanID WHERE l.Category = ");
            cntSQL.append(doingGifts ? "1" : "0");
            totalCnt = BasicSQLUtils.getCount(this.oldDBConn, cntSQL.toString());
            if (totalCnt != null && totalCnt != 0) break block21;
            return true;
        }
        try {
            StringBuilder sql = new StringBuilder("SELECT la.LoanAgentsID, la.Role, la.Remarks, la.LoanID, la.AgentAddressID, la.TimestampCreated, la.TimestampModified ");
            sql.append("FROM loanagents la INNER JOIN loan l ON la.LoanID = l.LoanID WHERE l.Category = ");
            sql.append(doingGifts ? "1" : "0");
            sql.append(" ORDER BY l.LoanID");
            String sqlStr = sql.toString();
            log.info((Object)sqlStr);
            Statement stmt = this.oldDBConn.createStatement();
            ResultSet rs = stmt.executeQuery(sqlStr);
            if (this.hasFrame) {
                this.setProcess(0, totalCnt);
            }
            Statement updateStatement = this.newDBConn.createStatement();
            int count = 0;
            while (rs.next()) {
                Integer id = rs.getInt(1);
                String role = rs.getString(2);
                String remarks = BasicSQLUtils.escapeStringLiterals(rs.getString(3));
                Integer loadId = rs.getInt(4);
                Integer agentAddrId = rs.getInt(5);
                Timestamp timestampCr = rs.getTimestamp(6);
                Timestamp timestampMd = rs.getTimestamp(7);
                Integer newId = count + 1;
                Integer newLoanId = loanMapper.get(loadId);
                Integer newAgentId = agentAddrIDMapper.get(agentAddrId);
                if (newLoanId == null) {
                    tblWriter.logError("The new Loan Id mapped from [" + newLoanId + "] was not found in the mappers. Skipping LoanAgent Record: " + id);
                    continue;
                }
                if (newAgentId == null) {
                    tblWriter.logError("The new Agent Id mapped from [" + agentAddrId + "] was not found in the mapper. Skipping LoanAgent Record: " + id);
                    continue;
                }
                String tsStr = timestampCr == null ? nowStr : dateTimeFormatter.format(timestampMd);
                String tmStr = timestampMd == null ? nowStr : dateTimeFormatter.format(timestampCr);
                String insertSQLFmt = "INSERT INTO %s (%s, Role, Remarks, %s, AgentID, TimestampCreated, TimestampModified, Version, DisciplineID) VALUES(%d, '%s', '%s', %d, %d, '%s', '%s', 0, %d)";
                String insertSql = String.format(insertSQLFmt, newTableName, idName, refName, newId, role, remarks, newLoanId, newAgentId, tsStr, tmStr, this.getDisciplineId());
                if (this.hasFrame) {
                    if (count % 10 == 0) {
                        this.setProcess(count);
                    }
                } else if (count % 10 == 0) {
                    log.info((Object)("Loan Agent Records: " + count));
                }
                try {
                    String chkSQL = String.format("SELECT COUNT(*) FROM %s WHERE %s = %d AND Role = '%s' AND AgentID = %d", newTableName, refName, newLoanId, role, newAgentId);
                    int cnt = BasicSQLUtils.getCountAsInt(chkSQL);
                    if (cnt < 1) {
                        updateStatement.executeUpdate(insertSql);
                    } else {
                        String errStr = String.format("Duplciate key Tbl: %s WHERE %s = %d Role = '%s' AND AgentID = %d", newTableName, refName, newLoanId, role, newAgentId);
                        log.error((Object)errStr);
                        tblWriter.log(errStr);
                    }
                }
                catch (SQLException e) {
                    log.error((Object)("Count: " + count));
                    log.error((Object)("Exception on insert: " + str.toString()));
                    e.printStackTrace();
                    log.error((Object)e);
                    rs.close();
                    updateStatement.close();
                    stmt.close();
                    throw new RuntimeException(e);
                }
                ++count;
            }
            if (this.hasFrame) {
                this.setProcess(count);
            } else {
                log.info((Object)("Processed LoanAgents " + count + " records."));
            }
            rs.close();
            stmt.close();
            updateStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "loanagents", BasicSQLUtils.myDestinationServerType);
        return true;
    }

    public void convertHostTaxonId() {
        int total = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*) FROM habitat WHERE HostTaxonID IS NOT NULL");
        if (total > 0) {
            this.setProcess(0, total);
            String sql = "SELECT h.HabitatID, co.CollectionObjectID FROM habitat h INNER JOIN collectingevent ce ON h.HabitatID = ce.CollectingEventID INNER JOIN collectionobject co ON ce.CollectingEventID = co.CollectingEventID WHERE h.HostTaxonID IS NOT NULL";
            String lookupSql = "SELECT ca.CollectionObjectAttributeID FROM collectionobject co INNER JOIN collectionobjectattribute ca ON co.CollectionObjectAttributeID = ca.CollectionObjectAttributeID WHERE co.CollectionObjectID";
            try {
                IdMapperIFace coMapper = IdMapperMgr.getInstance().get("collectionobject", "CollectionObjectID");
                IdMapperIFace txMapper = IdMapperMgr.getInstance().get("taxonname", "TaxonNameID");
                Statement stmt = this.oldDBConn.createStatement();
                PreparedStatement updateStmt = this.newDBConn.prepareStatement("UPDATE collectionobjectattribute SET RelatedTaxonID=? WHERE CollectionObjectAttributeID = ?");
                PreparedStatement insertStmt = this.newDBConn.prepareStatement("INSERT INTO collectionobjectattribute (RelatedTaxonID) VALUES(?)");
                int count = 0;
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    String msg;
                    Integer newCOId;
                    this.setProcess(count++);
                    boolean isErr = false;
                    Integer newTXId = txMapper.get(rs.getInt(1));
                    if (newTXId == null) {
                        String msg2 = "Couldn't map old Taxon Id " + rs.getInt(1);
                        log.error((Object)msg2);
                        isErr = true;
                    }
                    if ((newCOId = coMapper.get(rs.getInt(2))) == null) {
                        String msg3 = "Couldn't map old CO Id " + rs.getInt(2);
                        log.error((Object)msg3);
                        isErr = true;
                    }
                    if (isErr) continue;
                    Integer coAttrId = BasicSQLUtils.getCount(this.newDBConn, String.valueOf(lookupSql) + newCOId);
                    if (coAttrId == null) {
                        insertStmt.setInt(1, newTXId);
                        if (insertStmt.executeUpdate() != 1) {
                            msg = "Error inserting CO Attr record for CO Id: " + newCOId + " and TxId: " + newTXId;
                            log.error((Object)msg);
                        }
                        coAttrId = BasicSQLUtils.getInsertedId(insertStmt);
                    }
                    updateStmt.setInt(1, newTXId);
                    updateStmt.setInt(2, newCOId);
                    if (updateStmt.executeUpdate() == 1) continue;
                    msg = "Error updating CO RelatedTaxonId record for CO Id: " + newCOId + " and TxId: " + newTXId;
                    log.error((Object)msg);
                }
                rs.close();
                stmt.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean convertPreparationRecords(Hashtable<Integer, Map<String, PrepType>> collToPrepTypeHash) {
        TableWriter tblWriter = this.convLogger.getWriter("convertPreparations.html", "Preparations");
        BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "preparation", BasicSQLUtils.myDestinationServerType);
        TimeLogger timeLogger = new TimeLogger();
        try {
            String postSQL;
            int cntTotal;
            Statement stmt = this.oldDBConn.createStatement(1004, 1007);
            stmt.setFetchSize(Integer.MIN_VALUE);
            StringBuilder str = new StringBuilder();
            ArrayList<String> oldFieldNames = new ArrayList<String>();
            StringBuilder sql = new StringBuilder("SELECT ");
            List<String> names = BasicSQLUtils.getFieldNamesFromSchema(this.oldDBConn, "collectionobject");
            sql.append(BasicSQLUtils.buildSelectFieldList(names, "co"));
            sql.append(", ");
            oldFieldNames.addAll(names);
            names = BasicSQLUtils.getFieldNamesFromSchema(this.oldDBConn, "collectionobjectcatalog");
            sql.append(BasicSQLUtils.buildSelectFieldList(names, "cc"));
            oldFieldNames.addAll(names);
            String sqlPostfix = " FROM collectionobject co LEFT JOIN collectionobjectcatalog cc ON co.CollectionObjectID = cc.CollectionObjectCatalogID WHERE NOT (co.DerivedFromID IS NULL) AND CatalogSeriesID IS NOT NULL ORDER BY co.CollectionObjectID";
            sql.append(sqlPostfix);
            log.info((Object)sql);
            List<FieldMetaData> newFieldMetaData = BasicSQLUtils.getFieldMetaDataFromSchema(this.newDBConn, "preparation");
            log.info((Object)("Number of Fields in (New) Preparation " + newFieldMetaData.size()));
            for (FieldMetaData field : newFieldMetaData) {
                log.info((Object)field.getName());
            }
            String sqlStr = sql.toString();
            log.debug((Object)sql);
            log.debug((Object)"------------------------ Old Names");
            Hashtable<String, Integer> oldNameIndex = new Hashtable<String, Integer>();
            int inx = 1;
            for (String name : oldFieldNames) {
                oldNameIndex.put(name, inx++);
                log.debug((Object)("OldName: " + name + " " + (inx - 1)));
            }
            log.debug((Object)"------------------------");
            Hashtable<String, String> newToOld = new Hashtable<String, String>();
            newToOld.put("PreparationID", "CollectionObjectID");
            newToOld.put("CollectionObjectID", "DerivedFromID");
            newToOld.put("StorageLocation", "Location");
            boolean doDebug = false;
            ResultSet rs = stmt.executeQuery(sqlStr);
            if (!rs.next()) {
                rs.close();
                stmt.close();
                this.setProcess(0, 0);
                return true;
            }
            Statement prepStmt = this.oldDBConn.createStatement(1004, 1007);
            prepStmt.setFetchSize(Integer.MIN_VALUE);
            IdTableMapper prepIdMapper = this.idMapperMgr.addTableMapper("CollectionObject", "CollectionObjectID", doDeleteAllMappings);
            if (shouldCreateMapTables) {
                String sql2 = "SELECT c.CollectionObjectID FROM collectionobject c WHERE NOT (c.DerivedFromID IS NULL) ORDER BY c.CollectionObjectID";
                prepIdMapper.mapAllIds(sql2);
            } else {
                prepIdMapper = (IdTableMapper)this.idMapperMgr.get("preparation", "PreparationID");
            }
            String insertStmtStr = null;
            boolean shouldCheckPrepAttrs = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM preparation WHERE PreparedByID IS NOT NULL OR PreparedDate IS NOT NULL") > 0;
            Statement prepTypeStmt = this.oldDBConn.createStatement(1004, 1007);
            prepTypeStmt.setFetchSize(Integer.MIN_VALUE);
            PartialDateConv partialDateConv = new PartialDateConv();
            prepIdMapper.setShowLogErrors(false);
            int totalPrepCount = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*)" + sqlPostfix);
            this.setProcess(0, totalPrepCount);
            Statement updateStatement = this.newDBConn.createStatement();
            int lastEditedByInx = (Integer)oldNameIndex.get("LastEditedBy");
            Integer idIndex = (Integer)oldNameIndex.get("CollectionObjectID");
            Integer catSeriesIdInx = (Integer)oldNameIndex.get("CatalogSeriesID");
            int count = 0;
            do {
                Integer catSeriesId;
                Vector<Integer> collectionIdList;
                partialDateConv.nullAll();
                Integer preparedById = null;
                if (shouldCheckPrepAttrs) {
                    Integer recordId = rs.getInt(idIndex + 1);
                    String subQueryStr = "select PreparedByID, PreparedDate from preparation where PreparationID = " + recordId;
                    ResultSet subQueryRS = prepTypeStmt.executeQuery(subQueryStr);
                    if (subQueryRS.next()) {
                        preparedById = subQueryRS.getInt(1);
                        BasicSQLUtils.getPartialDate(rs.getObject(2), partialDateConv);
                    } else {
                        partialDateConv.setDateStr("NULL");
                        partialDateConv.setPartial("NULL");
                    }
                    subQueryRS.close();
                }
                if ((collectionIdList = this.catSeriesToNewCollectionID.get(catSeriesId = Integer.valueOf(rs.getInt(catSeriesIdInx)))) == null) {
                    throw new RuntimeException("There are no Collections mapped to CatSeriesId[" + catSeriesId + "]");
                }
                if (collectionIdList.size() == 0) {
                    UIRegistry.showError("There are NO Collections assigned to the same CatalogSeries and we can't handle that right now.");
                    return false;
                }
                if (collectionIdList.size() > 1) {
                    UIRegistry.showError("There are multiple Collections assigned to the same CatalogSeries and we can't handle that right now.");
                    return false;
                }
                Integer colId = collectionIdList.get(0);
                Collection collection = this.collIdToCollObj.get(colId);
                if (collection == null) {
                    Session localSession = HibernateUtil.getCurrentSession();
                    List colList = localSession.createQuery("FROM Collection WHERE id = " + colId).list();
                    if (colList == null || colList.size() == 0) {
                        UIRegistry.showError("The collection is null for Catalog Series ID: " + catSeriesId);
                        return false;
                    }
                    collection = (Collection)colList.get(0);
                    this.collIdToCollObj.put(colId, collection);
                }
                Map<String, PrepType> prepTypeMap = collToPrepTypeHash.get(collectionIdList.get(0));
                String lastEditedBy = rs.getString(lastEditedByInx);
                str.setLength(0);
                if (insertStmtStr == null) {
                    StringBuffer fieldList = new StringBuffer();
                    fieldList.append("( ");
                    int i = 0;
                    while (i < newFieldMetaData.size()) {
                        if (i > 0 && i < newFieldMetaData.size()) {
                            fieldList.append(", ");
                        }
                        String newFieldName = newFieldMetaData.get(i).getName();
                        fieldList.append(String.valueOf(newFieldName) + " ");
                        ++i;
                    }
                    fieldList.append(")");
                    insertStmtStr = "INSERT INTO preparation " + fieldList + " VALUES (";
                }
                str.append(insertStmtStr);
                Integer oldId = null;
                boolean isError = false;
                int i = 0;
                while (i < newFieldMetaData.size()) {
                    block63: {
                        String msg;
                        Object data;
                        String newFieldName;
                        String mappedName;
                        block77: {
                            PrepType prepType;
                            Object value;
                            block76: {
                                block75: {
                                    block74: {
                                        block73: {
                                            block72: {
                                                block71: {
                                                    block70: {
                                                        block69: {
                                                            block68: {
                                                                block67: {
                                                                    block66: {
                                                                        block65: {
                                                                            block64: {
                                                                                if (i > 0) {
                                                                                    str.append(", ");
                                                                                }
                                                                                if ((mappedName = (String)newToOld.get(newFieldName = newFieldMetaData.get(i).getName())) != null) {
                                                                                    newFieldName = mappedName;
                                                                                } else {
                                                                                    mappedName = newFieldName;
                                                                                }
                                                                                if (i != 0) break block64;
                                                                                oldId = rs.getInt(1);
                                                                                Integer newId = prepIdMapper.get(oldId);
                                                                                if (newId == null) {
                                                                                    isError = true;
                                                                                    break;
                                                                                }
                                                                                str.append(newId);
                                                                                break block63;
                                                                            }
                                                                            if (!newFieldName.equals("PreparedByID")) break block65;
                                                                            if (agentIdMapper != null) {
                                                                                str.append(BasicSQLUtils.getStrValue(agentIdMapper.get(preparedById)));
                                                                                break block63;
                                                                            } else {
                                                                                str.append("NULL");
                                                                            }
                                                                            break block63;
                                                                        }
                                                                        if (!newFieldName.equals("PreparedDate")) break block66;
                                                                        str.append(partialDateConv.getDateStr());
                                                                        break block63;
                                                                    }
                                                                    if (!newFieldName.equals("PreparedDatePrecision")) break block67;
                                                                    str.append(partialDateConv.getPartial());
                                                                    break block63;
                                                                }
                                                                if (newFieldName.equals("DerivedFromIDX")) break block63;
                                                                if (!newFieldName.equals("PreparationAttributeID")) break block68;
                                                                Integer id = rs.getInt(idIndex + 1);
                                                                data = prepIdMapper.get(id);
                                                                if (data == null) {
                                                                    str.append("NULL");
                                                                    break block63;
                                                                } else {
                                                                    ResultSet prepRS = prepStmt.executeQuery("select PreparationID from preparation where PreparationID = " + id);
                                                                    if (prepRS.first()) {
                                                                        str.append(BasicSQLUtils.getStrValue(data));
                                                                    } else {
                                                                        str.append("NULL");
                                                                    }
                                                                    prepRS.close();
                                                                }
                                                                break block63;
                                                            }
                                                            if (!newFieldName.equals("CountAmt")) break block69;
                                                            value = rs.getInt("Count");
                                                            if (rs.wasNull()) {
                                                                value = null;
                                                            }
                                                            str.append(BasicSQLUtils.getStrValue(value));
                                                            break block63;
                                                        }
                                                        if (!newFieldName.equalsIgnoreCase("SampleNumber") && !newFieldName.equalsIgnoreCase("Status") && !newFieldName.equalsIgnoreCase("YesNo3")) break block70;
                                                        str.append("NULL");
                                                        break block63;
                                                    }
                                                    if (!newFieldName.equalsIgnoreCase("Version")) break block71;
                                                    str.append("0");
                                                    break block63;
                                                }
                                                if (!newFieldName.equalsIgnoreCase("CollectionMemberID")) break block72;
                                                str.append(this.getCollectionMemberId());
                                                break block63;
                                            }
                                            if (!newFieldName.equalsIgnoreCase("TimestampCreated")) break block73;
                                            value = rs.getString((Integer)oldNameIndex.get("TimestampCreated"));
                                            if (value == null) {
                                                value = new Timestamp(Calendar.getInstance().getTime().getTime());
                                            }
                                            str.append(BasicSQLUtils.getStrValue(value, newFieldMetaData.get(i).getType()));
                                            break block63;
                                        }
                                        if (!newFieldName.equalsIgnoreCase("TimestampModified")) break block74;
                                        value = rs.getString((Integer)oldNameIndex.get("TimestampModified"));
                                        if (value == null) {
                                            value = new Timestamp(Calendar.getInstance().getTime().getTime());
                                        }
                                        str.append(BasicSQLUtils.getStrValue(value, newFieldMetaData.get(i).getType()));
                                        break block63;
                                    }
                                    if (!newFieldName.equalsIgnoreCase("ModifiedByAgentID")) break block75;
                                    str.append(this.getModifiedByAgentId(lastEditedBy));
                                    break block63;
                                }
                                if (!newFieldName.equalsIgnoreCase("CreatedByAgentID")) break block76;
                                str.append(this.getCreatorAgentId(null));
                                break block63;
                            }
                            if (!newFieldName.equals("PrepTypeID")) break block77;
                            value = rs.getString((Integer)oldNameIndex.get("PreparationMethod"));
                            if (value == null || ((String)value).length() == 0) {
                                value = "n/a";
                            }
                            if ((prepType = prepTypeMap.get(((String)value).toLowerCase())) != null) {
                                Integer prepTypeId = prepType.getPrepTypeId();
                                if (prepTypeId != null) {
                                    str.append(BasicSQLUtils.getStrValue(prepTypeId));
                                    break block63;
                                } else {
                                    str.append("NULL");
                                    msg = "***************** Couldn't find PreparationMethod[" + (String)value + "] in PrepTypeMap";
                                    log.error((Object)msg);
                                    tblWriter.log(msg);
                                }
                                break block63;
                            } else {
                                String msg2 = "Couldn't find PrepType[" + (String)value + "] creating it.";
                                log.info((Object)msg2);
                                tblWriter.log(msg2);
                                prepType = new PrepType();
                                prepType.initialize();
                                prepType.setName((String)value);
                                prepType.setCollection(collection);
                                prepTypeMap.put((String)value, prepType);
                                Session tmpSession = null;
                                try {
                                    tmpSession = HibernateUtil.getCurrentSession();
                                    Transaction trans = tmpSession.beginTransaction();
                                    trans.begin();
                                    tmpSession.save((Object)prepType);
                                    trans.commit();
                                    str.append(BasicSQLUtils.getStrValue(prepType.getPrepTypeId()));
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    throw new RuntimeException(ex);
                                }
                            }
                        }
                        if (newFieldName.equals("StorageID") || newFieldName.equals("Storage")) {
                            str.append("NULL");
                        } else {
                            Integer index = (Integer)oldNameIndex.get(newFieldName);
                            if (index == null) {
                                String msg3 = "convertPreparationRecords - Couldn't find new field name[" + newFieldName + "] in old field name in index Map";
                                log.error((Object)msg3);
                                stmt.close();
                                throw new RuntimeException(msg3);
                            }
                            data = rs.getObject(index);
                            if (this.idMapperMgr != null && mappedName.endsWith("ID")) {
                                IdMapperIFace idMapper = mappedName.equals("DerivedFromID") ? this.idMapperMgr.get("collectionobjectcatalog", "CollectionObjectCatalogID") : this.idMapperMgr.get("collectionobject", mappedName);
                                if (idMapper != null) {
                                    if ((data = idMapper.get((Integer)data)) == null) {
                                        msg = "The mapped value came back null for old record Id [" + oldId + "] field [" + mappedName + "] => [" + data + "]";
                                        log.error((Object)msg);
                                        tblWriter.logError(msg);
                                        isError = true;
                                        break;
                                    }
                                } else {
                                    msg = "The could find mapper collectionobject_" + mappedName + " for old record Id [" + oldId + "] field=[" + data + "]";
                                    log.error((Object)msg);
                                    tblWriter.logError(msg);
                                    isError = true;
                                    break;
                                }
                            }
                            str.append(BasicSQLUtils.getStrValue(data, newFieldMetaData.get(i).getType()));
                        }
                    }
                    ++i;
                }
                str.append(")");
                if (this.hasFrame) {
                    if (count % 500 == 0) {
                        this.setProcess(count);
                        log.info((Object)("Preparation Records: " + count));
                    }
                } else if (count % 2000 == 0) {
                    log.info((Object)("Preparation Records: " + count));
                }
                if (!isError) {
                    try {
                        if (BasicSQLUtils.myDestinationServerType != BasicSQLUtils.SERVERTYPE.MS_SQLServer) {
                            BasicSQLUtils.removeForeignKeyConstraints(this.newDBConn, "preparation", BasicSQLUtils.myDestinationServerType);
                        }
                        if (doDebug) {
                            log.debug((Object)str.toString());
                        }
                        updateStatement.executeUpdate(str.toString());
                    }
                    catch (Exception e) {
                        log.error((Object)("Error trying to execute: " + str.toString()));
                        log.error((Object)("Count: " + count));
                        e.printStackTrace();
                        log.error((Object)e);
                        throw new RuntimeException(e);
                    }
                }
                ++count;
            } while (rs.next());
            prepTypeStmt.close();
            prepStmt.close();
            updateStatement.clearBatch();
            updateStatement.close();
            updateStatement = null;
            if (this.hasFrame) {
                if (count % 2000 == 0) {
                    final int cnt = count;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GenericDBConversion.this.setProcess(cnt);
                        }
                    });
                }
            } else if (count % 2000 == 0) {
                log.info((Object)("Processed CollectionObject " + count + " records."));
            }
            if ((cntTotal = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*) " + (postSQL = " FROM collectionobject co INNER JOIN collectionobjectcatalog cc ON co.CollectionObjectID = cc.CollectionObjectCatalogID WHERE NOT (co.DerivedFromID IS NOT NULL) AND Location IS NOT NULL"))) > 0) {
                this.frame.setProcess(0, cntTotal);
                this.frame.setDesc("Moving Location data to Preparations...");
                IdMapperIFace idMapper = this.idMapperMgr.get("collectionobjectcatalog", "CollectionObjectCatalogID");
                PreparedStatement pStmt = this.newDBConn.prepareStatement("UPDATE preparation SET StorageLocation=? WHERE CollectionObjectID=?");
                stmt = this.oldDBConn.createStatement();
                sqlStr = "SELECT CollectionObjectID, Location " + postSQL;
                log.debug((Object)sqlStr);
                rs = stmt.executeQuery(sqlStr);
                int cnt = 0;
                while (rs.next()) {
                    int id = rs.getInt(1);
                    String locStr = rs.getString(2);
                    Integer newId = idMapper.get(id);
                    if (newId != null) {
                        pStmt.setString(1, locStr);
                        pStmt.setInt(2, newId);
                        pStmt.execute();
                    }
                    if (++cnt % 100 != 0) continue;
                    this.frame.setProcess(cnt);
                }
                rs.close();
                stmt.close();
                pStmt.close();
                this.frame.setProcess(cntTotal);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        tblWriter.log(String.format("Preparations Processing Time: %s", timeLogger.end()));
        tblWriter.close();
        return true;
    }

    public boolean convertDeterminationRecords() {
        ResultSet rs;
        String tableName;
        Hashtable<String, Integer> oldNameIndex;
        List<FieldMetaData> newFieldMetaData;
        Statement stmt;
        Map<String, String> colNewToOldMap;
        TimeLogger timeLogger;
        TableWriter tblWriter;
        block70: {
            block69: {
                tblWriter = this.convLogger.getWriter("convertDeterminations.html", "Determinations");
                BasicSQLUtils.setIdentityInsertONCommandForSQLServer(this.newDBConn, "determination", BasicSQLUtils.myDestinationServerType);
                BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "determination", BasicSQLUtils.myDestinationServerType);
                if (BasicSQLUtils.getNumRecords(this.oldDBConn, "determination") == 0) {
                    return true;
                }
                timeLogger = new TimeLogger();
                String oldDetermination_Current = "Current";
                String oldDetermination_Date = "Date";
                colNewToOldMap = BasicSQLUtils.createFieldNameMap(new String[]{"CollectionObjectID", "BiologicalObjectID", "IsCurrent", oldDetermination_Current, "DeterminedDate", oldDetermination_Date, "TaxonID", "TaxonNameID"});
                stmt = this.oldDBConn.createStatement(1004, 1007);
                stmt.setFetchSize(Integer.MIN_VALUE);
                ArrayList<String> oldFieldNames = new ArrayList<String>();
                StringBuilder sql = new StringBuilder("SELECT ");
                List<String> names = BasicSQLUtils.getFieldNamesFromSchema(this.oldDBConn, "determination");
                sql.append(BasicSQLUtils.buildSelectFieldList(names, "determination"));
                oldFieldNames.addAll(names);
                sql.append(", cc.CatalogSeriesID AS CatSeriesID FROM determination Inner Join collectionobjectcatalog AS cc ON determination.BiologicalObjectID = cc.CollectionObjectCatalogID");
                log.info((Object)sql);
                if (BasicSQLUtils.mySourceServerType == BasicSQLUtils.SERVERTYPE.MS_SQLServer) {
                    log.debug((Object)"FIXING select statement to run against SQL Server.......");
                    log.debug((Object)("old string: " + sql.toString()));
                    String currentSQL = sql.toString();
                    currentSQL = currentSQL.replaceAll("Current", "[Current]");
                    log.debug((Object)("new string: " + currentSQL));
                    sql = new StringBuilder(currentSQL);
                }
                oldFieldNames.add("CatSeriesID");
                log.info((Object)sql);
                newFieldMetaData = BasicSQLUtils.getFieldMetaDataFromSchema(this.newDBConn, "determination");
                log.info((Object)("Number of Fields in New Determination " + newFieldMetaData.size()));
                String sqlStr = sql.toString();
                oldNameIndex = new Hashtable<String, Integer>();
                int inx = 1;
                for (String name : oldFieldNames) {
                    oldNameIndex.put(name, inx++);
                }
                tableName = "determination";
                log.info((Object)sqlStr);
                System.err.println(sqlStr);
                rs = stmt.executeQuery(sqlStr);
                if (!this.hasFrame) break block69;
                if (rs.last()) {
                    this.setProcess(0, rs.getRow());
                    rs.first();
                    break block70;
                }
                rs.close();
                stmt.close();
                return true;
            }
            if (rs.first()) break block70;
            rs.close();
            stmt.close();
            return true;
        }
        try {
            PartialDateConv partialDateConv = new PartialDateConv();
            IdMapperIFace detIdMapper = IdMapperMgr.getInstance().get("determination", "DeterminationID");
            IdMapperIFace colObjIdMapper = this.idMapperMgr.get("collectionobjectcatalog", "CollectionObjectCatalogID");
            IdMapperIFace colObjCatIdMapper = this.idMapperMgr.get("collectionobject", "CollectionObjectID");
            Integer catSeriesIdInx = (Integer)oldNameIndex.get("CatSeriesID");
            Integer oldRecIDInx = (Integer)oldNameIndex.get("DeterminationID");
            int lastEditedByInx = (Integer)oldNameIndex.get("LastEditedBy");
            Integer detDateInx = (Integer)oldNameIndex.get("Date");
            System.err.println("catSeriesIdInx: " + catSeriesIdInx);
            HashMap<String, Integer> nameToInxHash = new HashMap<String, Integer>();
            StringBuffer fieldList = new StringBuffer();
            StringBuilder insertQuesDB = new StringBuilder();
            int i = 0;
            while (i < newFieldMetaData.size()) {
                if (i > 0) {
                    fieldList.append(',');
                    insertQuesDB.append(',');
                }
                String newFieldName = newFieldMetaData.get(i).getName();
                fieldList.append(newFieldName);
                insertQuesDB.append('?');
                nameToInxHash.put(newFieldName, i + 1);
                System.out.println(String.valueOf(newFieldName) + " " + (i + 1));
                ++i;
            }
            String insertStmtStr = "INSERT INTO determination (" + fieldList + ") VALUES (" + insertQuesDB.toString() + ')';
            log.debug((Object)insertStmtStr);
            PreparedStatement pStmt = this.newDBConn.prepareStatement(insertStmtStr);
            int count = 0;
            do {
                Integer collectionId;
                partialDateConv.nullAll();
                String lastEditedBy = rs.getString(lastEditedByInx);
                Integer catSeriesId = rs.getInt(catSeriesIdInx);
                if (catSeriesId != null && rs.wasNull()) {
                    String msg = String.format("Error - The Determination had a null CatalogSeries DeterminationID %d; it's CollectionObjectID: %d", rs.getInt(1), rs.getInt(6));
                    log.error((Object)msg);
                    tblWriter.logError(msg);
                    continue;
                }
                Vector<Integer> collectionIdList = this.catSeriesToNewCollectionID.get(catSeriesId);
                if (collectionIdList == null) {
                    throw new RuntimeException("There are no Collections mapped to CatSeriesId[" + catSeriesId + "]");
                }
                if (collectionIdList.size() > 1) {
                    UIRegistry.showError("There are multiple Collections assigned to the same CatalogSeries and we can't handle that right now.");
                }
                if ((collectionId = collectionIdList.get(0)) == null) {
                    throw new RuntimeException("CollectionId is null when mapped from CatSeriesId");
                }
                this.curCollectionID = collectionId;
                boolean isError = false;
                int i2 = 0;
                while (i2 < newFieldMetaData.size()) {
                    Integer agentId;
                    String msg;
                    String newFieldName = newFieldMetaData.get(i2).getName();
                    int fldInx = (Integer)nameToInxHash.get(newFieldName);
                    if (i2 == 0) {
                        Integer recId = rs.getInt(oldRecIDInx);
                        Integer newId = detIdMapper.get(recId);
                        if (newId != null) {
                            pStmt.setInt(fldInx, newId);
                        } else {
                            msg = String.format("Error - Unable to map old id %d to new Id", recId);
                            log.error((Object)msg);
                            tblWriter.logError(msg);
                            isError = true;
                        }
                    } else if (newFieldName.equals("Version")) {
                        pStmt.setInt(fldInx, 0);
                    } else if (newFieldName.equals("DeterminedDate")) {
                        if (partialDateConv.getDateStr() == null) {
                            BasicSQLUtils.getPartialDate(rs.getObject(detDateInx), partialDateConv);
                        }
                        if (!partialDateConv.isNull()) {
                            int len = partialDateConv.getDateStr().length();
                            if (len == 12) {
                                String tsStr = partialDateConv.getDateStr().length() == 12 ? partialDateConv.getDateStr().substring(1, 11) : partialDateConv.getDateStr();
                                pStmt.setString(fldInx, tsStr);
                            } else {
                                if (!partialDateConv.getDateStr().equals("NULL")) {
                                    log.error((Object)("Determined Date was in error[" + partialDateConv.getDateStr() + "]"));
                                }
                                pStmt.setObject(fldInx, null);
                            }
                        } else {
                            pStmt.setObject(fldInx, null);
                        }
                    } else if (newFieldName.equals("DeterminedDatePrecision")) {
                        if (partialDateConv.getDateStr() == null) {
                            BasicSQLUtils.getPartialDate(rs.getObject(detDateInx), partialDateConv);
                        }
                        if (partialDateConv.getPartial() != null) {
                            if (partialDateConv.getPartial().length() > 1) {
                                pStmt.setInt(fldInx, 1);
                            } else {
                                pStmt.setInt(fldInx, Integer.parseInt(partialDateConv.getPartial()));
                            }
                        } else {
                            pStmt.setInt(fldInx, 1);
                        }
                    } else if (newFieldName.equals("CreatedByAgentID")) {
                        agentId = this.getCreatorAgentId(null);
                        pStmt.setInt(fldInx, agentId);
                    } else if (newFieldName.equals("ModifiedByAgentID")) {
                        agentId = this.getModifiedByAgentId(lastEditedBy);
                        pStmt.setInt(fldInx, agentId);
                    } else if (newFieldName.equals("Qualifier") || newFieldName.equals("SubSpQualifier") || newFieldName.equals("VarQualifier") || newFieldName.equals("Addendum") || newFieldName.equals("AlternateName") || newFieldName.equals("NameUsage") || newFieldName.equals("PreferredTaxonID")) {
                        pStmt.setObject(fldInx, null);
                    } else if (newFieldName.equals("CollectionMemberID")) {
                        pStmt.setInt(fldInx, this.getCollectionMemberId());
                    } else {
                        FieldMetaData fldMetaData;
                        Integer index = null;
                        String oldMappedColName = colNewToOldMap.get(newFieldName);
                        if (oldMappedColName != null) {
                            index = (Integer)oldNameIndex.get(oldMappedColName);
                        } else {
                            index = (Integer)oldNameIndex.get(newFieldName);
                            oldMappedColName = newFieldName;
                        }
                        if (index == null) {
                            msg = "convertDeterminationRecords - Couldn't find new field name[" + newFieldName + "] in old field name in index Map";
                            log.error((Object)msg);
                            stmt.close();
                            tblWriter.logError(msg);
                            throw new RuntimeException(msg);
                        }
                        Object data = rs.getObject(index);
                        if (data != null) {
                            int idInx = newFieldName.lastIndexOf("ID");
                            if (this.idMapperMgr != null && idInx > -1) {
                                String msg2;
                                Integer oldId = (Integer)data;
                                if (oldMappedColName.equals("BiologicalObjectID")) {
                                    data = colObjIdMapper.get(oldId);
                                    if (data == null) {
                                        data = colObjCatIdMapper.get(oldId);
                                    }
                                } else {
                                    IdMapperIFace idMapper = this.idMapperMgr.get(tableName, oldMappedColName);
                                    if (idMapper != null) {
                                        data = idMapper.get(oldId);
                                    } else {
                                        msg2 = "No Map for [" + tableName + "][" + oldMappedColName + "]";
                                        log.error((Object)msg2);
                                        tblWriter.logError(msg2);
                                        isError = true;
                                        break;
                                    }
                                }
                                if (data == null) {
                                    msg2 = "The determination with recordID[" + rs.getInt(oldRecIDInx) + "] could not find a mapping for record ID[" + oldId + "] for Old Field[" + oldMappedColName + "]";
                                    log.debug((Object)msg2);
                                    tblWriter.logError(msg2);
                                    tblWriter.log(ConvertVerifier.dumpSQL(this.oldDBConn, "SELECT * FROM determination WHERE DeterminationId = " + rs.getInt(oldRecIDInx)));
                                    if (this.isValueRequired(tableName, newFieldName)) {
                                        msg2 = "For table[" + tableName + "] the field [" + newFieldName + "] is null and can't be. Old value[" + oldId + "]";
                                        log.error((Object)msg2);
                                        tblWriter.logError(msg2);
                                    }
                                    isError = true;
                                    break;
                                }
                            }
                        }
                        if ((fldMetaData = newFieldMetaData.get(i2)) == null) {
                            String msg3 = "For table[" + tableName + "] the field [" + newFieldName + "] FieldMeataDate was null for index[" + i2 + "]";
                            log.error((Object)msg3);
                            tblWriter.logError(msg3);
                        } else {
                            BasicSQLUtils.setData(pStmt, newFieldMetaData.get(i2).getSqlType(), fldInx, data);
                        }
                    }
                    ++i2;
                }
                if (this.hasFrame) {
                    if (count % 500 == 0) {
                        this.setProcess(count);
                    }
                } else if (count % 2000 == 0) {
                    log.info((Object)("Determination Records: " + count));
                }
                if (!isError) {
                    try {
                        if (pStmt.executeUpdate() != 1) {
                            log.error((Object)("Count:  " + count));
                            log.error((Object)"Error inserting record.");
                        }
                    }
                    catch (SQLException e) {
                        log.error((Object)("Count:  " + count));
                        e.printStackTrace();
                        log.error((Object)e);
                        rs.close();
                        stmt.close();
                        UIRegistry.showError(e.toString());
                        throw new RuntimeException(e);
                    }
                }
                ++count;
            } while (rs.next());
            pStmt.close();
            if (this.hasFrame) {
                this.setProcess(count);
            } else {
                log.info((Object)("Processed Determination " + count + " records."));
            }
            rs.close();
            stmt.close();
            tblWriter.log(String.format("Determination Processing Time: %s", timeLogger.end()));
            tblWriter.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "determination", BasicSQLUtils.myDestinationServerType);
        return true;
    }

    private boolean isValueRequired(String tableName, String fieldName) {
        DBTableInfo ti = DBTableIdMgr.getInstance().getInfoByTableName(tableName);
        if (ti != null) {
            DBFieldInfo fi = ti.getFieldByName(fieldName);
            if (fi != null) {
                return fi.isRequired();
            }
            DBRelationshipInfo ri = ti.getRelationshipByName(fieldName);
            if (ri != null) {
                return ri.isRequired();
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean convertCollectionObjects(boolean useNumericCatNumbers, boolean usePrefix) {
        ZEROES = "000000000";
        formatter0 = UIFieldFormatterMgr.getInstance().getFormatter("CatalogNumber");
        GenericDBConversion.log.debug((Object)formatter0);
        formatter = UIFieldFormatterMgr.getInstance().getFormatter("CatalogNumberNumeric");
        GenericDBConversion.log.debug((Object)formatter);
        discipline = AppContextMgr.getInstance().getClassObject(Discipline.class);
        if (discipline != null) {
            System.out.println("discipline.getType()[" + discipline.getType() + "]");
            dt = DisciplineType.getDiscipline(discipline.getType());
        } else {
            list = BasicSQLUtils.query(this.newDBConn, "SELECT Type FROM discipline");
            typeStr = (String)list.get(0)[0];
            System.out.println("typeStr[" + typeStr + "]");
            dt = DisciplineType.getDiscipline(typeStr);
        }
        objTypePair = this.dispToObjTypeHash.get((Object)dt.getDisciplineType());
        if (objTypePair == null) {
            System.out.println("objTypePair is null dt[" + dt.getName() + "][" + dt.getTitle() + "]");
            for (DisciplineType.STD_DISCIPLINES key : this.dispToObjTypeHash.keySet()) {
                p = this.dispToObjTypeHash.get((Object)key);
                System.out.println("[" + (Object)key + "] [" + p.first + "][" + p.second + "]");
            }
        } else if (objTypePair.first == null) {
            System.out.println("objTypePair.first is null dt[" + dt + "]");
            for (DisciplineType.STD_DISCIPLINES key : this.dispToObjTypeHash.keySet()) {
                p = this.dispToObjTypeHash.get((Object)key);
                System.out.println("[" + (Object)key + "] [" + p.first + "][" + p.second + "]");
            }
        }
        this.idMapperMgr.dumpKeys();
        colObjTaxonMapper = (IdHashMapper)this.idMapperMgr.get("ColObjCatToTaxonType".toLowerCase());
        colObjAttrMapper = (IdHashMapper)this.idMapperMgr.get("biologicalobjectattributes_BiologicalObjectAttributesID");
        colObjMapper = (IdHashMapper)this.idMapperMgr.get("collectionobjectcatalog_CollectionObjectCatalogID");
        colObjTaxonMapper.setShowLogErrors(false);
        colObjAttrMapper.setShowLogErrors(false);
        fieldsToSkip = new String[]{"ContainerID", "ContainerItemID", "AltCatalogNumber", "GUID", "ContainerOwnerID", "RepositoryAgreementID", "GroupPermittedToView", "CollectionObjectID", "VisibilitySetBy", "ContainerOwnerID", "InventoryDate", "ObjectCondition", "Notifications", "ProjectNumber", "Restrictions", "YesNo3", "YesNo4", "YesNo5", "YesNo6", "FieldNotebookPageID", "ColObjAttributesID", "DNASequenceID", "AppraisalID", "TotalValue", "Description", "SGRStatus", "OCR"};
        fieldsToSkipHash = new HashSet<String>();
        var17_14 = fieldsToSkip;
        var16_16 = fieldsToSkip.length;
        var15_18 = 0;
        while (var15_18 < var16_16) {
            fName = var17_14[var15_18];
            fieldsToSkipHash.add(fName);
            ++var15_18;
        }
        tblWriter = this.convLogger.getWriter("convertCollectionObjects.html", "Collection Objects");
        msg = "colObjTaxonMapper: " + colObjTaxonMapper.size();
        GenericDBConversion.log.info((Object)msg);
        tblWriter.log(msg);
        BasicSQLUtils.setIdentityInsertONCommandForSQLServer(this.newDBConn, "collectionobject", BasicSQLUtils.myDestinationServerType);
        BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "collectionobject", BasicSQLUtils.myDestinationServerType);
        timeLogger = new TimeLogger();
        try {
            block100: {
                block101: {
                    stmt = this.oldDBConn.createStatement(1004, 1007);
                    stmt.setFetchSize(-2147483648);
                    str = new StringBuilder();
                    oldFieldNames = new ArrayList<String>();
                    sql = new StringBuilder("select ");
                    names = BasicSQLUtils.getFieldNamesFromSchema(this.oldDBConn, "collectionobject");
                    sql.append(BasicSQLUtils.buildSelectFieldList(names, "collectionobject"));
                    sql.append(", ");
                    oldFieldNames.addAll(names);
                    names = BasicSQLUtils.getFieldNamesFromSchema(this.oldDBConn, "collectionobjectcatalog");
                    sql.append(BasicSQLUtils.buildSelectFieldList(names, "collectionobjectcatalog"));
                    oldFieldNames.addAll(names);
                    fromClause = " FROM collectionobject Inner Join collectionobjectcatalog ON collectionobject.CollectionObjectID = collectionobjectcatalog.CollectionObjectCatalogID WHERE (collectionobject.DerivedFromID IS NULL) AND collectionobjectcatalog.CollectionObjectCatalogID = ";
                    sql.append(fromClause);
                    GenericDBConversion.log.info((Object)sql);
                    sqlStr = sql.toString();
                    newFieldMetaData = BasicSQLUtils.getFieldMetaDataFromSchema(this.newDBConn, "collectionobject");
                    GenericDBConversion.log.info((Object)("Number of Fields in New CollectionObject " + newFieldMetaData.size()));
                    oldNameIndex = new Hashtable<String, Integer>();
                    inx = 1;
                    GenericDBConversion.log.info((Object)"---- Old Names ----");
                    for (String name : oldFieldNames) {
                        GenericDBConversion.log.info((Object)("[" + name + "][" + inx + "]"));
                        oldNameIndex.put(name, inx++);
                    }
                    GenericDBConversion.log.info((Object)"---- New Names ----");
                    for (FieldMetaData fmd : newFieldMetaData) {
                        GenericDBConversion.log.info((Object)("[" + fmd.getName() + "]"));
                    }
                    tableName = "collectionobject";
                    newStmt = this.oldDBConn.createStatement(1004, 1007);
                    newStmt.setFetchSize(-2147483648);
                    rsLooping = newStmt.executeQuery("SELECT OldID, NewID FROM collectionobjectcatalog_CollectionObjectCatalogID ORDER BY OldID");
                    if (!this.hasFrame) break block100;
                    if (!rsLooping.last()) break block101;
                    this.setProcess(0, rsLooping.getRow());
                    rsLooping.first();
                    ** GOTO lbl112
                }
                rsLooping.close();
                stmt.close();
lbl104:
                // 2 sources

                return true;
            }
            try {
                if (!rsLooping.first()) {
                    rsLooping.close();
                    stmt.close();
                    ** continue;
                }
lbl112:
                // 3 sources

                boaCnt = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*) FROM biologicalobjectattributes");
                partialDateConv = new PartialDateConv();
                stmt2 = this.oldDBConn.createStatement(1004, 1007);
                stmt2.setFetchSize(-2147483648);
                catNumInx = (Integer)oldNameIndex.get("CatalogNumber");
                catDateInx = (Integer)oldNameIndex.get("CatalogedDate");
                catSeriesIdInx = (Integer)oldNameIndex.get("CatalogSeriesID");
                lastEditedByInx = (Integer)oldNameIndex.get("LastEditedBy");
                oldCatSeriesIDToCollInfo = new Hashtable<Integer, CollectionInfo>();
                for (CollectionInfo ci : this.collectionInfoShortList) {
                    if (ci.getCatSeriesId() == null) continue;
                    oldCatSeriesIDToCollInfo.put(ci.getCatSeriesId(), ci);
                }
                insertStmtStr = null;
                colObjAttrsNotMapped = 0;
                count = 0;
                skipRecord = false;
                do {
                    if (!(rs = stmt.executeQuery(catSQL = String.valueOf(sqlStr) + rsLooping.getInt(1))).next()) {
                        GenericDBConversion.log.error((Object)("Couldn't find CO with old  id[" + rsLooping.getInt(1) + "] " + catSQL));
                        continue;
                    }
                    partialDateConv.nullAll();
                    skipRecord = false;
                    collInfo = (CollectionInfo)oldCatSeriesIDToCollInfo.get(rs.getInt(catSeriesIdInx));
                    catalogNumber = null;
                    colObjId = null;
                    str.setLength(0);
                    if (insertStmtStr == null) {
                        fieldList = new StringBuffer();
                        fieldList.append("( ");
                        i = 0;
                        while (i < newFieldMetaData.size()) {
                            if (i > 0 && i < newFieldMetaData.size()) {
                                fieldList.append(", ");
                            }
                            newFieldName = newFieldMetaData.get(i).getName();
                            fieldList.append(String.valueOf(newFieldName) + " ");
                            ++i;
                        }
                        fieldList.append(")");
                        insertStmtStr = "INSERT INTO collectionobject " + fieldList + "  VALUES (";
                    }
                    str.append(insertStmtStr);
                    i = 0;
                    while (i < newFieldMetaData.size()) {
                        if (i > 0) {
                            str.append(", ");
                        }
                        newFieldName = newFieldMetaData.get(i).getName();
                        if (i == 0) {
                            oldColObjId = rs.getInt(1);
                            newColObjId = colObjMapper.get(oldColObjId);
                            if (newColObjId == null) {
                                msg = "Couldn't find new ColObj Id for old [" + oldColObjId + "]";
                                tblWriter.logError(msg);
                                UIRegistry.showError(msg);
                                throw new RuntimeException(msg);
                            }
                            colObjId = BasicSQLUtils.getStrValue(newColObjId);
                            if (StringUtils.contains((String)colObjId, (char)'.')) {
                                msgStr = String.format("CatalogNumber '%d' contains a decimal point.", new Object[]{colObjId});
                                GenericDBConversion.log.debug((Object)msgStr);
                                tblWriter.logError(msgStr);
                                skipRecord = true;
                                break;
                            }
                            str.append(colObjId);
                            if (useNumericCatNumbers) {
                                catalogNumber = rs.getString(catNumInx);
                                if (catalogNumber != null) {
                                    catNumInt = (int)Math.abs(rs.getDouble(catNumInx));
                                    catalogNumber = Integer.toString(catNumInt);
                                    if (catalogNumber.length() > 0 && catalogNumber.length() < "000000000".length()) {
                                        catalogNumber = "\"" + "000000000".substring(catalogNumber.length()) + catalogNumber + "\"";
                                    } else if (catalogNumber.length() > "000000000".length()) {
                                        UIRegistry.showError("Catalog Number[" + catalogNumber + "] is too long for formatter of 9");
                                    }
                                } else {
                                    mssg = "Empty catalog number.";
                                    GenericDBConversion.log.debug((Object)mssg);
                                    tblWriter.logError(mssg);
                                }
                            } else {
                                prefix = collInfo.getCatSeriesPrefix();
                                catNum = rs.getFloat(catNumInx);
                                catalogNumber = "\"" + (usePrefix != false && StringUtils.isNotEmpty((String)prefix) != false ? String.valueOf(prefix) + "-" : "") + String.format("%9.0f", new Object[]{Float.valueOf(catNum)}).trim() + "\"";
                            }
                            subNumber = rs.getInt((Integer)oldNameIndex.get("SubNumber"));
                            if (subNumber < 0) {
                                skipRecord = true;
                                break;
                            }
                        } else if (fieldsToSkipHash.contains(newFieldName)) {
                            str.append("NULL");
                        } else if (newFieldName.equals("CollectionID")) {
                            str.append(collInfo.getCollectionId());
                        } else if (newFieldName.equals("Version")) {
                            str.append("0");
                        } else if (newFieldName.equals("CreatedByAgentID")) {
                            str.append(this.getCreatorAgentId(null));
                        } else if (newFieldName.equals("ModifiedByAgentID")) {
                            lastEditedByStr = rs.getString(lastEditedByInx);
                            str.append(this.getModifiedByAgentId(lastEditedByStr));
                        } else if (newFieldName.equals("CollectionMemberID")) {
                            str.append(collInfo.getCollectionId());
                        } else if (newFieldName.equals("PaleoContextID")) {
                            str.append("NULL");
                        } else if (newFieldName.equals("CollectionObjectAttributeID")) {
                            idObj = rs.getObject(1);
                            if (idObj != null) {
                                coId = rs.getInt(1);
                                newId = colObjAttrMapper.get(coId);
                                if (newId != null) {
                                    str.append(BasicSQLUtils.getStrValue(newId));
                                } else {
                                    if (boaCnt > 0) {
                                        ++colObjAttrsNotMapped;
                                    }
                                    str.append("NULL");
                                }
                            } else {
                                str.append("NULL");
                            }
                        } else if (newFieldName.equals("CatalogedDate")) {
                            if (partialDateConv.getDateStr() == null) {
                                BasicSQLUtils.getPartialDate(rs.getObject(catDateInx), partialDateConv);
                            }
                            str.append(partialDateConv.getDateStr());
                        } else if (newFieldName.equals("CatalogedDatePrecision")) {
                            if (partialDateConv.getDateStr() == null) {
                                BasicSQLUtils.getPartialDate(rs.getObject(catDateInx), partialDateConv);
                            }
                            str.append(partialDateConv.getPartial());
                        } else if (newFieldName.equals("CatalogedDateVerbatim")) {
                            if (partialDateConv.getDateStr() == null) {
                                BasicSQLUtils.getPartialDate(rs.getObject(catDateInx), partialDateConv);
                            }
                            str.append(partialDateConv.getVerbatim());
                        } else if (newFieldName.equals("Availability")) {
                            str.append("NULL");
                        } else if (newFieldName.equals("CatalogNumber")) {
                            str.append(catalogNumber);
                        } else if (newFieldName.equals("Visibility")) {
                            str.append("0");
                        } else if (newFieldName.equals("VisibilitySetByID")) {
                            str.append("NULL");
                        } else if (newFieldName.equals("CountAmt")) {
                            index = (Integer)oldNameIndex.get("Count1");
                            if (index == null) {
                                index = (Integer)oldNameIndex.get("Count");
                            }
                            if ((countObj = rs.getObject(index)) != null) {
                                str.append(BasicSQLUtils.getStrValue(countObj, newFieldMetaData.get(i).getType()));
                            } else {
                                str.append("NULL");
                            }
                        } else {
                            index = (Integer)oldNameIndex.get(newFieldName);
                            if (index == null) {
                                msg = "convertCollectionObjects - Couldn't find new field name[" + newFieldName + "] in old field name in index Map";
                                GenericDBConversion.log.error((Object)msg);
                                tblWriter.logError(msg);
                                UIRegistry.showError(msg);
                                stmt.close();
                                throw new RuntimeException(msg);
                            }
                            data = rs.getObject(index);
                            if (data != null) {
                                idInx = newFieldName.lastIndexOf("ID");
                                if (this.idMapperMgr != null && idInx > -1) {
                                    idMapper = this.idMapperMgr.get(tableName, newFieldName);
                                    if (idMapper != null) {
                                        origValue = rs.getInt(index);
                                        data = idMapper.get(origValue);
                                        if (data == null) {
                                            msg = "No value [" + origValue + "] in map  [" + tableName + "][" + newFieldName + "]";
                                            GenericDBConversion.log.error((Object)msg);
                                            tblWriter.logError(msg);
                                        }
                                    } else {
                                        msg = "No Map for [" + tableName + "][" + newFieldName + "]";
                                        GenericDBConversion.log.error((Object)msg);
                                        tblWriter.logError(msg);
                                    }
                                }
                            }
                            str.append(BasicSQLUtils.getStrValue(data, newFieldMetaData.get(i).getType()));
                        }
                        ++i;
                    }
                    if (!skipRecord) {
                        str.append(")");
                        if (this.hasFrame) {
                            if (count % 500 == 0) {
                                this.setProcess(count);
                            }
                            if (count % 5000 == 0) {
                                GenericDBConversion.log.info((Object)("CollectionObject Records: " + count));
                            }
                        } else if (count % 2000 == 0) {
                            GenericDBConversion.log.info((Object)("CollectionObject Records: " + count));
                        }
                        try {
                            updateStatement = this.newDBConn.createStatement();
                            if (BasicSQLUtils.myDestinationServerType != BasicSQLUtils.SERVERTYPE.MS_SQLServer) {
                                BasicSQLUtils.removeForeignKeyConstraints(this.newDBConn, BasicSQLUtils.myDestinationServerType);
                            }
                            updateStatement.executeUpdate(str.toString());
                            updateStatement.clearBatch();
                            updateStatement.close();
                            updateStatement = null;
                        }
                        catch (SQLException e) {
                            GenericDBConversion.log.error((Object)("Count: " + count));
                            GenericDBConversion.log.error((Object)("Key: [" + colObjId + "][" + catalogNumber + "]"));
                            GenericDBConversion.log.error((Object)("SQL: " + str.toString()));
                            e.printStackTrace();
                            GenericDBConversion.log.error((Object)e);
                            UIRegistry.showError(e.getMessage());
                            rs.close();
                            stmt.close();
                            throw new RuntimeException(e);
                        }
                        ++count;
                    } else {
                        tblWriter.logError("Skipping - CatNo:" + catalogNumber);
                    }
                    rs.close();
                } while (rsLooping.next());
                stmt2.close();
                if (this.hasFrame) {
                    this.setProcess(count);
                } else {
                    GenericDBConversion.log.info((Object)("Processed CollectionObject " + count + " records."));
                }
                tblWriter.log(String.format("Collection Objects Processing Time: %s", new Object[]{timeLogger.end()}));
                tblWriter.log("Processed CollectionObject " + count + " records.");
                rsLooping.close();
                newStmt.close();
                stmt.close();
            }
            catch (SQLException e) {
                BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "collectionobject", BasicSQLUtils.myDestinationServerType);
                e.printStackTrace();
                GenericDBConversion.log.error((Object)e);
                tblWriter.logError(e.getMessage());
                UIRegistry.showError(e.getMessage());
                throw new RuntimeException(e);
            }
        }
        finally {
            tblWriter.close();
        }
        BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "collectionobject", BasicSQLUtils.myDestinationServerType);
        return true;
    }

    protected int getIntValue(ResultSet rs, int columnIndex) {
        try {
            int val = rs.getInt(columnIndex);
            return rs.wasNull() ? 0 : val;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean convertLoanPreparations() {
        BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "determination", BasicSQLUtils.myDestinationServerType);
        BasicSQLUtils.setIdentityInsertONCommandForSQLServer(this.newDBConn, "loanpreparation", BasicSQLUtils.myDestinationServerType);
        BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "loanpreparation", BasicSQLUtils.myDestinationServerType);
        if (BasicSQLUtils.getNumRecords(this.oldDBConn, "loanphysicalobject") == 0) {
            BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "loanpreparation", BasicSQLUtils.myDestinationServerType);
            return true;
        }
        Integer recCount = BasicSQLUtils.getCount(this.oldDBConn, "SELECT count(*) FROM loan WHERE Category = 0 ORDER BY LoanID");
        if (recCount == null || recCount == 0) {
            return true;
        }
        IdTableMapper loanPrepsMapper = IdMapperMgr.getInstance().addTableMapper("loanphysicalobject", "LoanPhysicalObjectID", false);
        TableWriter tblWriter = this.convLogger.getWriter("convertLoanPreparations.html", "Loan Preparations");
        TimeLogger timeLogger = new TimeLogger();
        try {
            ResultSet rs;
            int lastEditedByInx;
            int quantityResIndex;
            int quantityRetIndex;
            int quantityIndex;
            int loanPhysIdIndex;
            String tableName;
            Hashtable<String, Integer> oldNameIndex;
            List<FieldMetaData> newFieldMetaData;
            StringBuilder str;
            Statement stmt;
            Map<String, String> colNewToOldMap;
            block47: {
                colNewToOldMap = BasicSQLUtils.createFieldNameMap(new String[]{"PreparationID", "PhysicalObjectID"});
                stmt = this.oldDBConn.createStatement(1004, 1007);
                stmt.setFetchSize(Integer.MIN_VALUE);
                str = new StringBuilder();
                ArrayList<String> oldFieldNames = new ArrayList<String>();
                StringBuilder sql = new StringBuilder("SELECT ");
                List<String> names = BasicSQLUtils.getFieldNamesFromSchema(this.oldDBConn, "loanphysicalobject");
                sql.append(BasicSQLUtils.buildSelectFieldList(names, "loanphysicalobject"));
                oldFieldNames.addAll(names);
                sql.append(" FROM loanphysicalobject INNER JOIN loan ON loanphysicalobject.LoanID = loan.LoanID WHERE loan.Category = 0");
                log.info((Object)sql);
                newFieldMetaData = BasicSQLUtils.getFieldMetaDataFromSchema(this.newDBConn, "loanpreparation");
                log.info((Object)("Number of Fields in New loanpreparation " + newFieldMetaData.size()));
                String sqlStr = sql.toString();
                oldNameIndex = new Hashtable<String, Integer>();
                int inx = 1;
                Iterator iterator = oldFieldNames.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        tableName = "loanphysicalobject";
                        loanPhysIdIndex = (Integer)oldNameIndex.get("LoanPhysicalObjectID");
                        quantityIndex = (Integer)oldNameIndex.get("Quantity");
                        quantityRetIndex = (Integer)oldNameIndex.get("QuantityReturned");
                        quantityResIndex = (Integer)oldNameIndex.get("QuantityResolved");
                        lastEditedByInx = (Integer)oldNameIndex.get("LastEditedBy");
                        log.info((Object)sqlStr);
                        rs = stmt.executeQuery(sqlStr);
                        if (!this.hasFrame) break;
                        if (!rs.last()) {
                            rs.close();
                            stmt.close();
                            return true;
                        }
                        this.setProcess(0, rs.getRow());
                        rs.first();
                        break block47;
                    }
                    String name = (String)iterator.next();
                    oldNameIndex.put(name, inx++);
                }
                if (!rs.first()) {
                    rs.close();
                    stmt.close();
                    return true;
                }
            }
            String insertStmtStr = null;
            int count = 0;
            do {
                boolean skipInsert;
                block48: {
                    skipInsert = false;
                    int quantity = this.getIntValue(rs, quantityIndex);
                    int quantityResolved = this.getIntValue(rs, quantityResIndex);
                    int quantityReturned = this.getIntValue(rs, quantityRetIndex);
                    Boolean isResolved = quantityReturned == quantity || quantityResolved == quantity;
                    String lastEditedBy = rs.getString(lastEditedByInx);
                    str.setLength(0);
                    if (insertStmtStr == null) {
                        StringBuffer fieldList = new StringBuffer();
                        fieldList.append("( ");
                        int i = 0;
                        while (true) {
                            if (i >= newFieldMetaData.size()) {
                                fieldList.append(")");
                                insertStmtStr = "INSERT INTO loanpreparation " + fieldList + " VALUES (";
                                break;
                            }
                            if (i > 0 && i < newFieldMetaData.size()) {
                                fieldList.append(", ");
                            }
                            String newFieldName = newFieldMetaData.get(i).getName();
                            fieldList.append(String.valueOf(newFieldName) + " ");
                            ++i;
                        }
                    }
                    str.append(insertStmtStr);
                    int i = 0;
                    while (true) {
                        String msg;
                        if (i >= newFieldMetaData.size()) {
                            str.append(")");
                            if (!this.hasFrame) break;
                            if (count % 500 == 0) {
                                this.setProcess(count);
                            }
                            break block48;
                        }
                        if (i > 0) {
                            str.append(", ");
                        }
                        String newFieldName = newFieldMetaData.get(i).getName();
                        if (i == 0) {
                            Integer oldId = rs.getInt(loanPhysIdIndex);
                            Integer newID = loanPrepsMapper.get(oldId);
                            if (newID == null) {
                                msg = String.format("loanPhysIdIndex: %d; Old Id: %d could be mapped to a new ID. (This was a fatal error).", loanPhysIdIndex, oldId);
                                tblWriter.logError(msg);
                                log.error((Object)msg);
                                return false;
                            }
                            str.append(BasicSQLUtils.getStrValue(newID));
                        } else if (newFieldName.equals("ReceivedComments")) {
                            str.append("NULL");
                        } else if (newFieldName.equals("IsResolved")) {
                            str.append(BasicSQLUtils.getStrValue(isResolved));
                        } else if (newFieldName.equalsIgnoreCase("Version")) {
                            str.append("0");
                        } else if (newFieldName.equalsIgnoreCase("DisciplineID")) {
                            str.append(this.getDisciplineId());
                        } else if (newFieldName.equalsIgnoreCase("ModifiedByAgentID")) {
                            str.append(this.getModifiedByAgentId(lastEditedBy));
                        } else if (newFieldName.equalsIgnoreCase("CreatedByAgentID")) {
                            str.append(this.getCreatorAgentId(null));
                        } else {
                            Integer index = null;
                            String oldMappedColName = colNewToOldMap.get(newFieldName);
                            if (oldMappedColName != null) {
                                index = (Integer)oldNameIndex.get(oldMappedColName);
                            } else {
                                index = (Integer)oldNameIndex.get(newFieldName);
                                oldMappedColName = newFieldName;
                            }
                            if (index == null) {
                                msg = "convertLoanPreparations - Couldn't find new field name[" + newFieldName + "] in old field name in index Map";
                                log.error((Object)msg);
                                stmt.close();
                                tblWriter.logError(msg);
                                UIRegistry.showError(msg);
                                throw new RuntimeException(msg);
                            }
                            Object data = rs.getObject(index);
                            if (data != null) {
                                int idInx = newFieldName.lastIndexOf("ID");
                                if (this.idMapperMgr != null && idInx > -1) {
                                    IdMapperIFace idMapper = this.idMapperMgr.get(tableName, oldMappedColName);
                                    if (idMapper != null) {
                                        Integer oldId = rs.getInt(index);
                                        data = idMapper.get(oldId);
                                        if (data == null) {
                                            String msg2 = "No Map ID for [" + tableName + "][" + oldMappedColName + "] for ID[" + oldId + "]";
                                            log.error((Object)msg2);
                                            tblWriter.logError(msg2);
                                            skipInsert = true;
                                        }
                                    } else {
                                        String msg3 = "No Map for [" + tableName + "][" + oldMappedColName + "]";
                                        log.error((Object)msg3);
                                        tblWriter.logError(msg3);
                                        skipInsert = true;
                                    }
                                }
                            }
                            str.append(BasicSQLUtils.getStrValue(data, newFieldMetaData.get(i).getType()));
                        }
                        ++i;
                    }
                    if (count % 2000 == 0) {
                        log.info((Object)("LoanPreparation Records: " + count));
                    }
                }
                try {
                    if (!skipInsert) {
                        Statement updateStatement = this.newDBConn.createStatement();
                        if (BasicSQLUtils.myDestinationServerType != BasicSQLUtils.SERVERTYPE.MS_SQLServer) {
                            BasicSQLUtils.removeForeignKeyConstraints(this.newDBConn, BasicSQLUtils.myDestinationServerType);
                        }
                        updateStatement.executeUpdate(str.toString());
                        updateStatement.clearBatch();
                        updateStatement.close();
                        updateStatement = null;
                    }
                }
                catch (SQLException e) {
                    log.error((Object)("Count: " + count));
                    e.printStackTrace();
                    log.error((Object)e);
                    rs.close();
                    stmt.close();
                    throw new RuntimeException(e);
                }
                ++count;
            } while (rs.next());
            if (this.hasFrame) {
                this.setProcess(count);
                log.info((Object)("Processed LoanPreparation " + count + " records."));
            } else {
                log.info((Object)("Processed LoanPreparation " + count + " records."));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)e);
            BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "LoanPreparation", BasicSQLUtils.myDestinationServerType);
            throw new RuntimeException(e);
        }
        log.info((Object)"Done processing LoanPhysicalObject");
        BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "LoanPreparation", BasicSQLUtils.myDestinationServerType);
        tblWriter.close();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean convertGiftPreparations() {
        BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "determination", BasicSQLUtils.myDestinationServerType);
        BasicSQLUtils.setIdentityInsertONCommandForSQLServer(this.newDBConn, "giftpreparation", BasicSQLUtils.myDestinationServerType);
        BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "giftpreparation", BasicSQLUtils.myDestinationServerType);
        if (BasicSQLUtils.getNumRecords(this.oldDBConn, "loanphysicalobject") == 0) {
            BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "giftpreparation", BasicSQLUtils.myDestinationServerType);
            return true;
        }
        Integer recCount = BasicSQLUtils.getCount(this.oldDBConn, "SELECT count(*) FROM loan WHERE Category = 1 ORDER BY LoanID");
        if (recCount == null || recCount == 0) {
            return true;
        }
        IdMapperIFace giftsIdMapper = IdMapperMgr.getInstance().get("gift", "GiftID");
        IdMapperIFace giftPrepsIdMapper = IdMapperMgr.getInstance().get("giftphysicalobject", "id");
        TableWriter tblWriter = this.convLogger.getWriter("convertGiftPreparations.html", "Gift Preparations");
        TimeLogger timeLogger = new TimeLogger();
        try {
            ResultSet rs;
            int loanPhysIdIndex;
            int lastEditedByInx;
            String tableName;
            Hashtable<String, Integer> oldNameIndex;
            List<FieldMetaData> newFieldMetaData;
            StringBuilder str;
            Statement stmt;
            Map<String, String> colNewToOldMap;
            block46: {
                colNewToOldMap = BasicSQLUtils.createFieldNameMap(new String[]{"PreparationID", "PhysicalObjectID"});
                stmt = this.oldDBConn.createStatement(1004, 1007);
                stmt.setFetchSize(Integer.MIN_VALUE);
                str = new StringBuilder();
                ArrayList<String> oldFieldNames = new ArrayList<String>();
                StringBuilder sql = new StringBuilder("SELECT ");
                List<String> names = BasicSQLUtils.getFieldNamesFromSchema(this.oldDBConn, "loanphysicalobject");
                sql.append(BasicSQLUtils.buildSelectFieldList(names, "loanphysicalobject"));
                oldFieldNames.addAll(names);
                sql.append(" FROM loanphysicalobject INNER JOIN loan ON loanphysicalobject.LoanID = loan.LoanID WHERE loan.Category = 1 ORDER BY loanphysicalobject.LoanPhysicalObjectID");
                log.info((Object)sql);
                newFieldMetaData = BasicSQLUtils.getFieldMetaDataFromSchema(this.newDBConn, "giftpreparation");
                log.info((Object)("Number of Fields in New giftpreparation " + newFieldMetaData.size()));
                String sqlStr = sql.toString();
                colNewToOldMap.put("GiftID", "LoanID");
                oldNameIndex = new Hashtable<String, Integer>();
                int inx = 1;
                Iterator iterator = oldFieldNames.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        tableName = "loanphysicalobject";
                        lastEditedByInx = (Integer)oldNameIndex.get("LastEditedBy");
                        loanPhysIdIndex = (Integer)oldNameIndex.get("LoanPhysicalObjectID");
                        log.info((Object)sqlStr);
                        rs = stmt.executeQuery(sqlStr);
                        if (!this.hasFrame) break;
                        if (!rs.last()) {
                            rs.close();
                            stmt.close();
                            return true;
                        }
                        this.setProcess(0, rs.getRow());
                        rs.first();
                        break block46;
                    }
                    String name = (String)iterator.next();
                    oldNameIndex.put(name, inx++);
                }
                if (!rs.first()) {
                    rs.close();
                    stmt.close();
                    return true;
                }
            }
            String insertStmtStr = null;
            int count = 0;
            do {
                block47: {
                    String lastEditedBy = rs.getString(lastEditedByInx);
                    str.setLength(0);
                    if (insertStmtStr == null) {
                        StringBuffer fieldList = new StringBuffer();
                        fieldList.append("( ");
                        int i = 0;
                        while (true) {
                            if (i >= newFieldMetaData.size()) {
                                fieldList.append(")");
                                insertStmtStr = "INSERT INTO giftpreparation " + fieldList + " VALUES (";
                                break;
                            }
                            if (i > 0 && i < newFieldMetaData.size()) {
                                fieldList.append(", ");
                            }
                            String newFieldName = newFieldMetaData.get(i).getName();
                            fieldList.append(String.valueOf(newFieldName) + " ");
                            ++i;
                        }
                    }
                    str.append(insertStmtStr);
                    int i = 0;
                    while (true) {
                        String msg;
                        if (i >= newFieldMetaData.size()) {
                            str.append(")");
                            if (!this.hasFrame) break;
                            if (count % 500 == 0) {
                                this.setProcess(count);
                            }
                            break block47;
                        }
                        if (i > 0) {
                            str.append(", ");
                        }
                        String newFieldName = newFieldMetaData.get(i).getName();
                        if (i == 0) {
                            Integer oldId = rs.getInt(loanPhysIdIndex);
                            Integer newID = giftPrepsIdMapper.get(oldId);
                            if (newID == null) {
                                msg = String.format("loanPhysIdIndex: %d; Old Id: %d could be mapped to a new ID. (This was a fatal error).", loanPhysIdIndex, oldId);
                                tblWriter.logError(msg);
                                log.error((Object)msg);
                                return false;
                            }
                            str.append(BasicSQLUtils.getStrValue(newID));
                        } else if (newFieldName.equals("ReceivedComments")) {
                            str.append("NULL");
                        } else if (newFieldName.equalsIgnoreCase("Version")) {
                            str.append("0");
                        } else if (newFieldName.equalsIgnoreCase("DisciplineID")) {
                            str.append(this.getDisciplineId());
                        } else if (newFieldName.equalsIgnoreCase("ModifiedByAgentID")) {
                            str.append(this.getModifiedByAgentId(lastEditedBy));
                        } else if (newFieldName.equalsIgnoreCase("CreatedByAgentID")) {
                            str.append(this.getCreatorAgentId(null));
                        } else {
                            Integer index = null;
                            String oldMappedColName = colNewToOldMap.get(newFieldName);
                            if (oldMappedColName != null) {
                                index = (Integer)oldNameIndex.get(oldMappedColName);
                            } else {
                                index = (Integer)oldNameIndex.get(newFieldName);
                                oldMappedColName = newFieldName;
                            }
                            if (index == null) {
                                msg = "convertGiftPreparations - Couldn't find new field name[" + newFieldName + "] in old field name in index Map";
                                log.error((Object)msg);
                                stmt.close();
                                tblWriter.logError(msg);
                                UIRegistry.showError(msg);
                                throw new RuntimeException(msg);
                            }
                            Object data = rs.getObject(index);
                            if (data != null) {
                                if (newFieldName.equalsIgnoreCase("GiftID")) {
                                    data = giftsIdMapper.get((Integer)data);
                                } else {
                                    int idInx = newFieldName.lastIndexOf("ID");
                                    if (this.idMapperMgr != null && idInx > -1) {
                                        IdMapperIFace idMapper = this.idMapperMgr.get(tableName, oldMappedColName);
                                        if (idMapper != null) {
                                            Integer oldId = rs.getInt(index);
                                            data = idMapper.get(oldId);
                                            if (data == null) {
                                                String msg2 = "No Map ID for [" + tableName + "][" + oldMappedColName + "] for ID[" + oldId + "]";
                                                log.error((Object)msg2);
                                                tblWriter.logError(msg2);
                                            }
                                        } else {
                                            String msg3 = "No Map for [" + tableName + "][" + oldMappedColName + "]";
                                            log.error((Object)msg3);
                                            tblWriter.logError(msg3);
                                        }
                                    }
                                }
                            }
                            str.append(BasicSQLUtils.getStrValue(data, newFieldMetaData.get(i).getType()));
                        }
                        ++i;
                    }
                    if (count % 2000 == 0) {
                        log.info((Object)("LoanPreparation Records: " + count));
                    }
                }
                try {
                    Statement updateStatement = this.newDBConn.createStatement();
                    if (BasicSQLUtils.myDestinationServerType != BasicSQLUtils.SERVERTYPE.MS_SQLServer) {
                        BasicSQLUtils.removeForeignKeyConstraints(this.newDBConn, BasicSQLUtils.myDestinationServerType);
                    }
                    updateStatement.executeUpdate(str.toString());
                    updateStatement.clearBatch();
                    updateStatement.close();
                    updateStatement = null;
                }
                catch (SQLException e) {
                    log.error((Object)("Count: " + count));
                    e.printStackTrace();
                    log.error((Object)e);
                    rs.close();
                    stmt.close();
                    throw new RuntimeException(e);
                }
                ++count;
            } while (rs.next());
            if (this.hasFrame) {
                this.setProcess(count);
                log.info((Object)("Processed LoanPreparation " + count + " records."));
            } else {
                log.info((Object)("Processed LoanPreparation " + count + " records."));
            }
            rs.close();
            stmt.close();
            tblWriter.log(String.format("Determinations Processing Time: %s", timeLogger.end()));
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)e);
            BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "LoanPreparation", BasicSQLUtils.myDestinationServerType);
            throw new RuntimeException(e);
        }
        log.info((Object)"Done processing LoanPhysicalObject");
        BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "LoanPreparation", BasicSQLUtils.myDestinationServerType);
        tblWriter.close();
        return true;
    }

    public DataType createDataTypes(String returnName) {
        String[] dataTypeNames = new String[]{"Animal", "Plant", "Fungi", "Mineral", "Other"};
        DataType retDataType = null;
        try {
            Session localSession = HibernateUtil.getCurrentSession();
            HibernateUtil.beginTransaction();
            String[] stringArray = dataTypeNames;
            int n = dataTypeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                DataType dataType = new DataType();
                dataType.initialize();
                dataType.setName(name);
                localSession.save((Object)dataType);
                if (returnName != null && name.equals(returnName)) {
                    retDataType = dataType;
                }
                ++n2;
            }
            HibernateUtil.commitTransaction();
        }
        catch (Exception e) {
            log.error((Object)("******* " + e));
            HibernateUtil.rollbackTransaction();
            throw new RuntimeException(e);
        }
        return retDataType;
    }

    public GeographyTreeDef createStandardGeographyDefinitionAndItems(boolean doDelete) {
        if (doDelete) {
            BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "geographytreedef", BasicSQLUtils.myDestinationServerType);
            BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "geographytreedefitem", BasicSQLUtils.myDestinationServerType);
        }
        Session localSession = HibernateUtil.getCurrentSession();
        HibernateUtil.beginTransaction();
        GeographyTreeDef def = new GeographyTreeDef();
        def.initialize();
        def.setName("Default Geography Definition");
        def.setRemarks("A simple continent/country/state/county geography tree");
        def.setFullNameDirection(-1);
        GeographyTreeDefItem planet = new GeographyTreeDefItem();
        planet.initialize();
        planet.setName("Planet");
        planet.setRankId(0);
        planet.setIsEnforced(true);
        planet.setFullNameSeparator(", ");
        GeographyTreeDefItem cont = new GeographyTreeDefItem();
        cont.initialize();
        cont.setName("Continent");
        cont.setRankId(100);
        cont.setFullNameSeparator(", ");
        GeographyTreeDefItem country = new GeographyTreeDefItem();
        country.initialize();
        country.setName("Country");
        country.setRankId(200);
        country.setIsInFullName(true);
        country.setFullNameSeparator(", ");
        GeographyTreeDefItem state = new GeographyTreeDefItem();
        state.initialize();
        state.setName("State");
        state.setRankId(300);
        state.setIsInFullName(true);
        state.setFullNameSeparator(", ");
        GeographyTreeDefItem county = new GeographyTreeDefItem();
        county.initialize();
        county.setName("County");
        county.setRankId(400);
        county.setIsInFullName(true);
        county.setFullNameSeparator(", ");
        county.setParent(state);
        state.setParent(country);
        country.setParent(cont);
        cont.setParent(planet);
        planet.setTreeDef(def);
        cont.setTreeDef(def);
        country.setTreeDef(def);
        state.setTreeDef(def);
        county.setTreeDef(def);
        Set<GeographyTreeDefItem> defItems = def.getTreeDefItems();
        defItems.add(planet);
        defItems.add(cont);
        defItems.add(country);
        defItems.add(state);
        defItems.add(county);
        localSession.save((Object)def);
        HibernateUtil.commitTransaction();
        return def;
    }

    public static LithoStratTreeDef createStandardLithoStratDefinitionAndItems(Connection dbConn) {
        BasicSQLUtils.deleteAllRecordsFromTable(dbConn, "lithostrattreedef", BasicSQLUtils.myDestinationServerType);
        BasicSQLUtils.deleteAllRecordsFromTable(dbConn, "lithostrattreedefitem", BasicSQLUtils.myDestinationServerType);
        Session localSession = HibernateUtil.getCurrentSession();
        HibernateUtil.beginTransaction();
        LithoStratTreeDef def = DataBuilder.createLithoStratTreeDef("Standard LithoStrat Tree");
        BuildSampleDatabase.createSimpleLithoStrat(def, true);
        localSession.save((Object)def);
        HibernateUtil.commitTransaction();
        return def;
    }

    public boolean convertDeaccessionCollectionObject() {
        BasicSQLUtils.deleteAllRecordsFromTable("deaccessionpreparation", BasicSQLUtils.myDestinationServerType);
        if (BasicSQLUtils.getNumRecords(this.oldDBConn, "deaccessioncollectionobject") == 0) {
            return true;
        }
        Map<String, String> colNewToOldMap = BasicSQLUtils.createFieldNameMap(new String[]{"PreparationID", "CollectionObjectID", "DeaccessionPreparationID", "DeaccessionCollectionObjectID"});
        BasicSQLUtils.setIdentityInsertONCommandForSQLServer(this.newDBConn, "deaccessionpreparation", BasicSQLUtils.myDestinationServerType);
        if (BasicSQLUtils.copyTable(this.oldDBConn, this.newDBConn, "deaccessioncollectionobject", "deaccessionpreparation", colNewToOldMap, null, BasicSQLUtils.mySourceServerType, BasicSQLUtils.myDestinationServerType)) {
            log.info((Object)"deaccessionpreparation copied ok.");
        } else {
            log.error((Object)"problems coverting deaccessionpreparation");
        }
        BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "deaccessionpreparation", BasicSQLUtils.myDestinationServerType);
        BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(null);
        return true;
    }

    protected void removeFieldsFromList(List<String> fields, String[] fieldNames) {
        String[] stringArray = fieldNames;
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            int fndInx = -1;
            int inx = 0;
            for (String fld : fields) {
                if (StringUtils.contains((String)fld, (String)fieldName)) {
                    fndInx = inx;
                }
                ++inx;
            }
            if (fndInx != -1) {
                fields.remove(fndInx);
            }
            ++n2;
        }
    }

    protected void convertLocalityExtraInfo(String tableName, boolean isGeoCoordDetail) {
        BasicSQLUtils.removeForeignKeyConstraints(this.newDBConn, BasicSQLUtils.myDestinationServerType);
        String capName = StringUtils.capitalize((String)tableName);
        TableWriter tblWriter = this.convLogger.getWriter(String.valueOf(capName) + ".html", capName);
        BasicSQLUtils.setTblWriter(tblWriter);
        IdHashMapper.setTblWriter(tblWriter);
        this.setDesc("Converting " + capName);
        List<String> localityDetailNamesTmp = BasicSQLUtils.getFieldNamesFromSchema(this.newDBConn, tableName);
        ArrayList<String> localityDetailNames = new ArrayList<String>();
        Hashtable<String, Boolean> nameHash = new Hashtable<String, Boolean>();
        for (String fieldName : localityDetailNamesTmp) {
            localityDetailNames.add(fieldName);
            nameHash.put(fieldName, true);
            System.out.println("[" + fieldName + "]");
        }
        String fieldList = BasicSQLUtils.buildSelectFieldList(localityDetailNames, null);
        log.info((Object)fieldList);
        IdMapperIFace locIdMapper = this.idMapperMgr.get("locality", "LocalityID");
        IdMapperIFace agtIdMapper = this.idMapperMgr.get("agent", "AgentID");
        Statement updateStatement = null;
        try {
            try {
                updateStatement = this.newDBConn.createStatement();
                Hashtable<String, Boolean> usedFieldHash = new Hashtable<String, Boolean>();
                Statement stmt = this.oldDBConn.createStatement(1004, 1007);
                stmt.setFetchSize(Integer.MIN_VALUE);
                Integer countRows = BasicSQLUtils.getCount("select count(LocalityID) from locality,geography where locality.GeographyID = geography.GeographyID");
                if (countRows != null) {
                    this.frame.setProcess(0, countRows);
                }
                ResultSet rs = stmt.executeQuery("select locality.*,geography.* from locality LEFT JOIN geography on locality.GeographyID = geography.GeographyID ");
                StringBuilder colSQL = new StringBuilder();
                StringBuilder valuesSQL = new StringBuilder();
                int rows = 0;
                while (rs.next()) {
                    usedFieldHash.clear();
                    valuesSQL.setLength(0);
                    boolean hasData = false;
                    ResultSetMetaData metaData = rs.getMetaData();
                    int cols = metaData.getColumnCount();
                    int i = 1;
                    while (i <= cols) {
                        String colName = metaData.getColumnName(i);
                        if (colName.equals("GeoRefDetBy")) {
                            colName = "AgentID";
                        }
                        if (!(nameHash.get(colName) != null && usedFieldHash.get(colName) == null || colName.startsWith("Range"))) {
                            if (rows == 0) {
                                log.debug((Object)("Skipping[" + colName + "]"));
                            }
                        } else {
                            String msg;
                            String value;
                            usedFieldHash.put(colName, true);
                            if (rows == 0) {
                                System.err.println("[" + colName + "]");
                                if (colName.equals("Range")) {
                                    if (!isGeoCoordDetail) {
                                        if (colSQL.length() > 0) {
                                            colSQL.append(",");
                                        }
                                        colSQL.append("RangeDesc");
                                    }
                                } else if (isGeoCoordDetail) {
                                    if (!colName.equals("RangeDirection")) {
                                        if (colSQL.length() > 0) {
                                            colSQL.append(",");
                                        }
                                        colSQL.append(colName);
                                    }
                                } else {
                                    if (colSQL.length() > 0) {
                                        colSQL.append(",");
                                    }
                                    colSQL.append(colName);
                                }
                            }
                            if (colName.equals("LocalityID")) {
                                Integer oldId = rs.getInt(i);
                                Integer newId = locIdMapper.get(oldId);
                                if (newId != null) {
                                    value = Integer.toString(newId);
                                } else {
                                    msg = "Couldn't map LocalityId oldId[" + rs.getInt(i) + "]";
                                    log.error((Object)msg);
                                    tblWriter.logError(msg);
                                    value = "NULL";
                                }
                            } else if (isGeoCoordDetail && colName.equals("GeoRefDetDate")) {
                                Integer dateInt = rs.getInt(i);
                                value = BasicSQLUtils.getStrValue(dateInt, "date");
                            } else if (colName.startsWith("YesNo")) {
                                Integer bool = rs.getInt(i);
                                value = bool == null ? "NULL" : (bool == 0 ? "0" : "1");
                            } else if (isGeoCoordDetail && colName.equals("AgentID")) {
                                Integer agentID = (Integer)rs.getObject(i);
                                if (agentID != null) {
                                    Integer newID = agtIdMapper.get(agentID);
                                    if (newID != null) {
                                        value = newID.toString();
                                    } else {
                                        msg = "Couldn't map GeoRefDetBY (Agent) oldId[" + agentID + "]";
                                        log.error((Object)msg);
                                        tblWriter.logError(msg);
                                        value = "NULL";
                                    }
                                } else {
                                    value = "NULL";
                                }
                            } else if (colName.equals("Range") || colName.equals("RangeDirection")) {
                                if (!isGeoCoordDetail) {
                                    String range = rs.getString(i);
                                    if ((range = BasicSQLUtils.escapeStringLiterals(range)) != null) {
                                        hasData = true;
                                        value = "'" + range + "'";
                                    } else {
                                        value = "NULL";
                                    }
                                } else {
                                    value = null;
                                }
                            } else {
                                Object obj = rs.getObject(i);
                                if (obj != null && !colName.equals("TimestampCreated") && !colName.equals("TimestampModified")) {
                                    hasData = true;
                                }
                                value = BasicSQLUtils.getStrValue(obj);
                            }
                            if (value != null) {
                                if (valuesSQL.length() > 0) {
                                    valuesSQL.append(",");
                                }
                                valuesSQL.append(value);
                            }
                        }
                        ++i;
                    }
                    if (hasData) {
                        String insertSQL = "INSERT INTO " + tableName + " (" + colSQL.toString() + ", Version, CreatedByAgentID, ModifiedByAgentID) " + " VALUES(" + valuesSQL.toString() + ", 0, " + this.getCreatorAgentId(null) + "," + this.getModifiedByAgentId(null) + ")";
                        try {
                            updateStatement.executeUpdate(insertSQL);
                            updateStatement.clearBatch();
                        }
                        catch (Exception ex) {
                            System.out.println("isGeoCoordDetail: " + isGeoCoordDetail);
                            System.out.println(insertSQL);
                            ex.printStackTrace();
                        }
                    }
                    if (++rows % 500 != 0) continue;
                    this.frame.setProcess(rows);
                }
                rs.close();
                stmt.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    updateStatement.close();
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                updateStatement.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void convertLocality() {
        block24: {
            int errorsToShow = 63;
            log.debug((Object)"Preparing to convert localities");
            BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "collectionobject", BasicSQLUtils.myDestinationServerType);
            BasicSQLUtils.setIdentityInsertONCommandForSQLServer(this.newDBConn, "locality", BasicSQLUtils.myDestinationServerType);
            BasicSQLUtils.deleteAllRecordsFromTable("locality", BasicSQLUtils.myDestinationServerType);
            Hashtable<String, String> newToOldColMap = new Hashtable<String, String>();
            newToOldColMap.put("Visibility", "GroupPermittedToView");
            String[] fieldsToIgnore = new String[]{"GML", "NamedPlaceExtent", "GeoRefAccuracyUnits", "GeoRefDetRef", "GeoRefDetDate", "GeoRefDetBy", "NoGeoRefBecause", "GeoRefRemarks", "GeoRefVerificationStatus", "NationalParkName", "VisibilitySetBy", "GeoRefDetByID", "Drainage", "Island", "IslandGroup", "WaterBody", "Version", "CreatedByAgentID", "CollectionMemberID", "ShortName", "DisciplineID", "GUID", "GML", "SrcLatLongUnit", "Visibility", "VisibilitySetByID", "LocalityName", "NamedPlace", "RelationToNamedPlace", "SGRStatus"};
            BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(fieldsToIgnore);
            BasicSQLUtils.setShowErrors(errorsToShow &= 0xFFFFFFFB);
            TableWriter tblWriter = this.convLogger.getWriter("Locality.html", "Localities");
            BasicSQLUtils.setTblWriter(tblWriter);
            IdHashMapper.setTblWriter(tblWriter);
            Map<String, String> mappedFields = BasicSQLUtils.createFieldNameMap(new String[]{"ModifiedByAgentID", "LastEditedBy"});
            String sql = "SELECT locality.*,g.* FROM locality LEFT JOIN geography g on locality.GeographyID = g.GeographyID WHERE locality.GeographyID IS NOT NULL";
            if (BasicSQLUtils.copyTable(this.oldDBConn, this.newDBConn, sql, "locality", "locality", mappedFields, null, BasicSQLUtils.mySourceServerType, BasicSQLUtils.myDestinationServerType)) {
                log.info((Object)"Locality/Geography copied ok.");
            } else {
                log.error((Object)"Copying locality/geography (fields) to new Locality");
            }
            BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(fieldsToIgnore);
            sql = "SELECT * FROM locality WHERE locality.GeographyID IS NULL";
            if (BasicSQLUtils.copyTable(this.oldDBConn, this.newDBConn, sql, "locality", "locality", mappedFields, null, BasicSQLUtils.mySourceServerType, BasicSQLUtils.myDestinationServerType)) {
                log.info((Object)"Locality/Geography copied ok.");
            } else {
                log.error((Object)"Copying locality/geography (fields) to new Locality");
            }
            this.frame.setProcess(0, BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM locality"));
            Statement pStmt = null;
            Statement stmt = null;
            sql = "SELECT LocalityID, LocalityName, NamedPlace, RelationToNamedPlace, Remarks FROM locality ORDER BY LocalityID";
            try {
                try {
                    IdMapperIFace locMapper = this.idMapperMgr.get("locality_LocalityID");
                    pStmt = this.newDBConn.prepareStatement("UPDATE locality SET LocalityName=?, NamedPlace=?, RelationToNamedPlace=?, Remarks=? WHERE LocalityID=?");
                    stmt = this.oldDBConn.createStatement(1004, 1007);
                    stmt.setFetchSize(Integer.MIN_VALUE);
                    ResultSet rs = stmt.executeQuery(sql);
                    int cnt = 0;
                    while (rs.next()) {
                        int oldId = rs.getInt(1);
                        Integer newId = locMapper.get(oldId);
                        if (newId != null) {
                            pStmt.setString(1, rs.getString(2));
                            pStmt.setString(2, rs.getString(3));
                            pStmt.setString(3, rs.getString(4));
                            pStmt.setString(4, rs.getString(5));
                            pStmt.setInt(5, newId);
                            pStmt.execute();
                        } else {
                            String msg = "No Mapping for OldId [" + rs.getInt(1) + "]";
                            log.error((Object)msg);
                            tblWriter.logErrors(Integer.toString(rs.getInt(1)), msg);
                        }
                        if (++cnt % 500 != 0) continue;
                        this.frame.setProcess(cnt);
                    }
                    this.frame.setProcess(cnt);
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                    tblWriter.logErrors("Exception", ex.toString());
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (pStmt != null) {
                            pStmt.close();
                        }
                        break block24;
                    }
                    catch (SQLException sQLException) {}
                    break block24;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (pStmt != null) {
                        pStmt.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.convertLocalityExtraInfo("localitydetail", false);
        this.convertLocalityExtraInfo("geocoorddetail", true);
        BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(null);
        BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "locality", BasicSQLUtils.myDestinationServerType);
        BasicSQLUtils.setTblWriter(null);
        IdHashMapper.setTblWriter(null);
    }

    private void fixGeography(String fieldName) {
        int cnt = BasicSQLUtils.getCountAsInt(this.oldDBConn, String.format("SELECT COUNT(*) FROM geography WHERE %s = 'null'", fieldName));
        if (cnt > 0) {
            int recs = BasicSQLUtils.update(this.oldDBConn, String.format("UPDATE geography SET %s = NULL WHERE %s = 'null'", fieldName, fieldName));
            if (cnt == recs) {
                log.debug((Object)String.format("%d Geography field %s  was updated correctly .", recs, fieldName));
            } else {
                log.debug((Object)String.format("Geography field %s  was updated in error %d / %d.", fieldName, cnt, recs));
            }
        }
    }

    private Agent getAgentObj(Session sessionArg, Integer agtId) {
        if (agtId != null) {
            Agent agent = agentHash.get(agtId);
            if (agent != null) {
                return agent;
            }
            List list = sessionArg.createQuery("FROM Agent WHERE id = " + agtId).list();
            if (list != null && list.size() == 1) {
                agentHash.put(agtId, (Agent)list.get(0));
                return (Agent)list.get(0);
            }
        }
        return null;
    }

    private Agent getCreatedByAgent(Session sessionArg, Integer agtId) {
        Agent agent = this.getAgentObj(sessionArg, agtId);
        if (agent == null) {
            agent = this.getAgentObj(sessionArg, this.getCurAgentCreatorID());
        }
        return null;
    }

    private Agent getModifiedByAgent(Session sessionArg, Integer agtId) {
        Agent agent = this.getAgentObj(sessionArg, agtId);
        if (agent == null) {
            agent = this.getAgentObj(sessionArg, this.getCurAgentModifierID());
        }
        return null;
    }

    private String fixSize(TableWriter tblWriter, int id, String desc, String str, int len) {
        String s = str;
        if (StringUtils.isNotEmpty((String)str) && s.length() > len) {
            s = str.substring(0, len);
            String msg = String.format("Id; %d %s - %s chopped[%s]", id, desc, str, str.substring(64, str.length()));
            log.debug((Object)msg);
            tblWriter.logError(msg);
        }
        return s;
    }

    public void convertGeography(GeographyTreeDef treeDef, String dispName, boolean firstTime) throws SQLException {
        GeographyTreeDefItem defItem2;
        IdTableMapper geoIdMapper;
        TableWriter tblWriter = this.convLogger.getWriter("Geography" + (dispName != null ? dispName : "") + ".html", "Geography");
        BasicSQLUtils.setTblWriter(tblWriter);
        IdHashMapper.setTblWriter(tblWriter);
        if (firstTime) {
            BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "geography", BasicSQLUtils.myDestinationServerType);
        }
        if ((geoIdMapper = (IdTableMapper)IdMapperMgr.getInstance().get("geography", "GeographyID")) == null) {
            geoIdMapper = IdMapperMgr.getInstance().addTableMapper("geography", "GeographyID");
        } else {
            geoIdMapper.clearRecords();
        }
        Hashtable<Integer, Geography> oldIdToGeoMap = new Hashtable<Integer, Geography>();
        Session localSession = HibernateUtil.getCurrentSession();
        HibernateUtil.beginTransaction();
        String sql = "SELECT GeographyID,ContinentOrOcean,Country,State,County,LastEditedBy FROM geography";
        Statement statement = this.oldDBConn.createStatement(1004, 1007);
        statement.setFetchSize(Integer.MIN_VALUE);
        ResultSet oldGeoRecords = statement.executeQuery(sql);
        this.fixGeography("ContinentOrOcean");
        this.fixGeography("Country");
        this.fixGeography("State");
        this.fixGeography("County");
        if (this.hasFrame) {
            if (oldGeoRecords.last()) {
                this.setProcess(0, oldGeoRecords.getRow());
                oldGeoRecords.first();
            }
        } else {
            oldGeoRecords.first();
        }
        Geography planetEarth = new Geography();
        planetEarth.initialize();
        planetEarth.setName("Earth");
        planetEarth.setCommonName("Earth");
        planetEarth.setRankId(0);
        planetEarth.setDefinition(treeDef);
        for (GeographyTreeDefItem defItem2 : treeDef.getTreeDefItems()) {
            if (defItem2.getRankId() != 0) continue;
            planetEarth.setDefinitionItem(defItem2);
            break;
        }
        defItem2 = treeDef.getDefItemByRank(0);
        planetEarth.setDefinitionItem(defItem2);
        int counter = 0;
        do {
            if (counter % 500 == 0) {
                if (this.hasFrame) {
                    this.setProcess(counter);
                } else {
                    log.info((Object)("Converted " + counter + " geography records"));
                }
            }
            int oldId = oldGeoRecords.getInt(1);
            String cont = this.fixSize(tblWriter, oldId, "continent", oldGeoRecords.getString(2), 64);
            String country = this.fixSize(tblWriter, oldId, "country", oldGeoRecords.getString(3), 64);
            String state = this.fixSize(tblWriter, oldId, "state", oldGeoRecords.getString(4), 64);
            String county = this.fixSize(tblWriter, oldId, "county", oldGeoRecords.getString(5), 64);
            String lastEditedBy = oldGeoRecords.getString(6);
            Integer agtId = this.getCreatorAgentId(lastEditedBy);
            Agent createdByAgent = this.getCreatedByAgent(localSession, agtId);
            Agent modifiedByAgent = this.getAgentObj(localSession, this.getCurAgentModifierID());
            if (StringUtils.isEmpty((String)cont) && StringUtils.isEmpty((String)country) && StringUtils.isEmpty((String)state) && StringUtils.isEmpty((String)county)) {
                cont = "Undefined";
                country = "Undefined";
                state = "Undefined";
                county = "Undefined";
            } else if (StringUtils.isEmpty((String)cont) && StringUtils.isEmpty((String)country) && StringUtils.isEmpty((String)state)) {
                cont = "Undefined";
                country = "Undefined";
                state = "Undefined";
            } else if (StringUtils.isEmpty((String)cont) && StringUtils.isEmpty((String)country)) {
                cont = "Undefined";
                country = "Undefined";
            } else if (StringUtils.isEmpty((String)cont)) {
                cont = "Undefined";
            }
            List<Geography> newGeos = this.convertOldGeoRecord(cont, country, state, county, createdByAgent, modifiedByAgent, planetEarth);
            if (newGeos.size() > 0) {
                Geography lowestLevel = newGeos.get(newGeos.size() - 1);
                oldIdToGeoMap.put(oldId, lowestLevel);
            }
            ++counter;
        } while (oldGeoRecords.next());
        if (this.hasFrame) {
            this.setProcess(counter);
        } else {
            log.info((Object)("Converted " + counter + " geography records"));
        }
        TreeHelper.fixFullnameForNodeAndDescendants(planetEarth);
        planetEarth.setNodeNumber(1);
        GenericDBConversion.fixNodeNumbersFromRoot(planetEarth);
        localSession.save((Object)planetEarth);
        HibernateUtil.commitTransaction();
        log.info((Object)("Converted " + counter + " geography records"));
        if (shouldCreateMapTables) {
            for (Integer oldId : oldIdToGeoMap.keySet()) {
                Geography geo = (Geography)oldIdToGeoMap.get(oldId);
                geoIdMapper.put(oldId, geo.getId());
            }
        }
        if (firstTime) {
            this.idMapperMgr.mapForeignKey("Locality", "GeographyID", "Geography", "GeographyID");
        }
    }

    protected List<Geography> convertOldGeoRecord(String cont, String country, String state, String county, Agent createdByAgent, Agent modifiedByAgent, Geography geoRoot) {
        Vector<Geography> newRecords = new Vector<Geography>();
        String[] levelNames = new String[]{cont, country, state, county};
        int levelsToBuild = 0;
        int i = 4;
        while (i > 0) {
            if (levelNames[i - 1] != null) {
                levelsToBuild = i;
                break;
            }
            --i;
        }
        Geography prevLevelGeo = geoRoot;
        int i2 = 0;
        while (i2 < levelsToBuild) {
            Geography newLevelGeo = this.buildGeoLevel(levelNames[i2], createdByAgent, modifiedByAgent, prevLevelGeo);
            newRecords.add(newLevelGeo);
            prevLevelGeo = newLevelGeo;
            ++i2;
        }
        return newRecords;
    }

    protected Geography buildGeoLevel(String nameArg, Agent modifiedByAgent, Agent createdByAgent, Geography parentArg) {
        String name = nameArg;
        if (name == null) {
            name = "N/A";
        }
        Set<Geography> children = parentArg.getChildren();
        for (Geography child : children) {
            if (!name.equalsIgnoreCase(child.getName())) continue;
            return child;
        }
        Geography newGeo = new Geography();
        newGeo.initialize();
        newGeo.setName(name);
        newGeo.setParent(parentArg);
        parentArg.addChild(newGeo);
        newGeo.setDefinition(parentArg.getDefinition());
        int newGeoRank = parentArg.getRankId() + 100;
        GeographyTreeDefItem defItem = parentArg.getDefinition().getDefItemByRank(newGeoRank);
        newGeo.setDefinitionItem(defItem);
        newGeo.setRankId(newGeoRank);
        newGeo.setCreatedByAgent(createdByAgent);
        newGeo.setModifiedByAgent(modifiedByAgent);
        return newGeo;
    }

    public boolean convertHabitat() {
        BasicSQLUtils.deleteAllRecordsFromTable("collectingeventattribute", BasicSQLUtils.myDestinationServerType);
        if (BasicSQLUtils.getNumRecords(this.oldDBConn, "habitat") == 0) {
            return true;
        }
        BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(this.getHabitatAttributeToIgnore());
        BasicSQLUtils.setIdentityInsertONCommandForSQLServer(this.newDBConn, "collectingeventattribute", BasicSQLUtils.myDestinationServerType);
        BasicSQLUtils.clearValueMapper();
        BasicSQLUtils.addToValueMapper("CollectionMemberID", this.getCollectionMemberIDValueMapper());
        BasicSQLUtils.addToValueMapper("CreatedByAgentID", this.getAgentCreatorValueMapper());
        BasicSQLUtils.addToValueMapper("ModifiedByAgentID", this.getAgentModiferValueMapper());
        BasicSQLUtils.addToValueMapper("Version", this.getVersionValueMapper());
        BasicSQLUtils.addToValueMapper("DivisionID", this.getDivisionValueMapper());
        BasicSQLUtils.addToValueMapper("DisciplineID", this.getDisciplineValueMapper());
        BasicSQLUtils.addToValueMapper("IsPrimary", this.getIsPrimaryValueMapper());
        BasicSQLUtils.addToValueMapper("SrcLatLongUnit", this.getSrcLatLongUnitValueMapper());
        int errorsToShow = 63;
        BasicSQLUtils.setShowErrors(errorsToShow &= 0xFFFFFFFB);
        if (BasicSQLUtils.copyTable(this.oldDBConn, this.newDBConn, "habitat", "collectingeventattribute", BasicSQLUtils.createFieldNameMap(this.getHabitatAttributeMappings()), null, BasicSQLUtils.mySourceServerType, BasicSQLUtils.myDestinationServerType)) {
            log.info((Object)"habitat copied ok.");
        } else {
            log.error((Object)"problems coverting habitat");
        }
        BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "collectingeventattribute", BasicSQLUtils.myDestinationServerType);
        BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(null);
        BasicSQLUtils.setShowErrors(63);
        return true;
    }

    public void updateHabitatIds() {
        Statement pStmtUpd = null;
        Statement stmt = null;
        IdMapperIFace ceMapper = IdMapperMgr.getInstance().get("collectingevent", "CollectingEventID");
        IdMapperIFace hbMapper = IdMapperMgr.getInstance().get("habitat", "HabitatID");
        try {
            try {
                String sql = " SELECT CollectingEventID, HabitatID FROM collectingevent Inner Join habitat ON CollectingEventID = HabitatID";
                stmt = this.oldDBConn.createStatement();
                pStmtUpd = this.newDBConn.prepareStatement("UPDATE collectingevent SET CollectingEventAttributeID=?, DisciplineID=? WHERE CollectingEventID = ?");
                int cnt = 0;
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    Integer ceId = rs.getInt(1);
                    Integer hbId = rs.getInt(2);
                    Integer newCEID = ceMapper.get(ceId);
                    Integer newHBID = hbMapper.get(hbId);
                    Integer colMemID = BasicSQLUtils.getCount("SELECT DisciplineID FROM collectingevent WHERE CollectingEventID = " + newCEID);
                    if (colMemID == null) {
                        log.debug((Object)("DisciplineID is null for CE ID " + newCEID));
                    }
                    if (newHBID == null) continue;
                    pStmtUpd.setInt(1, newHBID);
                    pStmtUpd.setInt(2, colMemID);
                    pStmtUpd.setInt(3, newCEID);
                    pStmtUpd.execute();
                    ++cnt;
                }
                rs.close();
                log.debug((Object)("Updated CollectingEvents: " + cnt));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    stmt.close();
                    pStmtUpd.close();
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                stmt.close();
                pStmtUpd.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void updateBioLogicalObjAttrIds() {
        Statement pStmtUpd = null;
        Statement stmt = null;
        IdMapperIFace ceMapper = IdMapperMgr.getInstance().get("collectionobjectcatalog", "CollectionObjectCatalogID");
        IdMapperIFace hbMapper = IdMapperMgr.getInstance().get("biologicalobjectattributes", "BiologicalObjectAttributesID");
        try {
            try {
                String sql = "SELECT c.CollectionObjectID, p.BiologicalObjectAttributesID FROM collectionobject c INNER Join biologicalobjectattributes p ON c.CollectionObjectID = p.BiologicalObjectAttributesID";
                stmt = this.oldDBConn.createStatement();
                pStmtUpd = this.newDBConn.prepareStatement("UPDATE collectionobject SET CollectionObjectAttributeID=? WHERE CollectionObjectID = ?");
                int cnt = 0;
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    Integer ceId = rs.getInt(1);
                    Integer hbId = rs.getInt(2);
                    Integer newCEID = ceMapper.get(ceId);
                    Integer newHBID = hbMapper.get(hbId);
                    if (newHBID == null) continue;
                    pStmtUpd.setInt(1, newHBID);
                    pStmtUpd.setInt(2, newCEID);
                    pStmtUpd.execute();
                    ++cnt;
                }
                rs.close();
                log.debug((Object)("Updated Preparations: " + cnt));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    stmt.close();
                    pStmtUpd.close();
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                stmt.close();
                pStmtUpd.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void updatePrepAttrIds() {
        Statement pStmtUpd = null;
        Statement stmt = null;
        IdMapperIFace coMapper = IdMapperMgr.getInstance().get("collectionobject", "CollectionObjectID");
        IdMapperIFace ccMapper = IdMapperMgr.getInstance().get("collectionobjectcatalog", "CollectionObjectCatalogID");
        IdMapperIFace ppMapper = IdMapperMgr.getInstance().get("preparation", "PreparationID");
        try {
            try {
                String sql = "SELECT c.CollectionObjectID, p.PreparationID FROM collectionobject c INNER Join preparation p ON c.CollectionObjectID = p.PreparationID";
                stmt = this.oldDBConn.createStatement();
                pStmtUpd = this.newDBConn.prepareStatement("UPDATE preparation SET PreparationAttributeID=? WHERE PreparationID = ?");
                int cnt = 0;
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    Integer coId = rs.getInt(1);
                    Integer ppId = rs.getInt(2);
                    Integer newCOID = coMapper.get(coId);
                    Integer newPPID = ppMapper.get(ppId);
                    if (newCOID == null) {
                        newCOID = ccMapper.get(coId);
                    }
                    if (newPPID != null && newCOID != null) {
                        pStmtUpd.setInt(1, newPPID);
                        pStmtUpd.setInt(2, newCOID);
                        pStmtUpd.execute();
                        ++cnt;
                        continue;
                    }
                    log.debug((Object)("newPPID: " + newPPID + "  or newCOID: " + newCOID + "  was null coId: " + coId + "  ppId " + ppId));
                }
                rs.close();
                log.debug((Object)("Updated Preparations: " + cnt));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    stmt.close();
                    pStmtUpd.close();
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                stmt.close();
                pStmtUpd.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void convertLithoStrat(LithoStratTreeDef treeDef, LithoStrat earth, TableWriter tblWriter, String srcTableName, boolean doMapGTPIds) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        String s = "";
        try {
            Integer gtpId;
            IdHashMapper lithoStratIdMapper;
            Session localSession = HibernateUtil.getCurrentSession();
            HibernateUtil.beginTransaction();
            int count = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*) FROM " + srcTableName);
            if (count < 1) {
                return;
            }
            if (this.hasFrame) {
                this.setProcess(0, count);
            }
            if ((lithoStratIdMapper = IdMapperMgr.getInstance().addHashMapper("stratigraphy_StratigraphyID", true)) == null) {
                UIRegistry.showError("The lithoStratIdMapper was null.");
                return;
            }
            IdTableMapper gtpIdMapper = IdMapperMgr.getInstance().addTableMapper("geologictimeperiod", "GeologicTimePeriodID", null, false);
            if (doMapGTPIds) {
                gtpIdMapper.clearRecords();
                gtpIdMapper.mapAllIds();
            }
            Hashtable<Integer, Integer> stratGTPIdHash = new Hashtable<Integer, Integer>();
            IdHashMapper newCEIdToNewStratIdHash = IdMapperMgr.getInstance().addHashMapper("stratigraphy_StratigraphyID_2", true);
            newCEIdToNewStratIdHash.setShowLogErrors(false);
            IdMapperIFace ceMapper = IdMapperMgr.getInstance().get("collectingevent", "CollectingEventID");
            if (ceMapper == null) {
                ceMapper = IdMapperMgr.getInstance().addTableMapper("collectingevent", "CollectingEventID", null, false);
            }
            String sql = String.format("SELECT s.StratigraphyID, s.SuperGroup, s.Group, s.Formation, s.Member, s.Bed, Remarks, Text1, Text2, Number1, Number2, YesNo1, YesNo2, GeologicTimePeriodID FROM %s s ORDER BY s.StratigraphyID", srcTableName);
            stmt = this.oldDBConn.createStatement(1004, 1007);
            stmt.setFetchSize(Integer.MIN_VALUE);
            rs = stmt.executeQuery(sql);
            int stratsWithNoGTP = 0;
            int stratsWithNoMappedGTP = 0;
            int missingCEMapping = 0;
            int counter = 0;
            while (rs.next()) {
                Boolean yesNo2;
                if (counter % 500 == 0) {
                    if (this.hasFrame) {
                        this.setProcess(counter);
                    } else {
                        log.info((Object)("Converted " + counter + " Stratigraphy records"));
                    }
                }
                int oldStratId = rs.getInt(1);
                String superGroup = rs.getString(2);
                String lithoGroup = rs.getString(3);
                String formation = rs.getString(4);
                String member = rs.getString(5);
                String bed = rs.getString(6);
                String remarks = BasicSQLUtils.escapeStringLiterals(rs.getString(7));
                String text1 = BasicSQLUtils.escapeStringLiterals(rs.getString(8));
                String text2 = BasicSQLUtils.escapeStringLiterals(rs.getString(9));
                Double number1 = rs.getObject(10) != null ? Double.valueOf(rs.getDouble(10)) : null;
                Double number2 = rs.getObject(11) != null ? Double.valueOf(rs.getDouble(11)) : null;
                Boolean yesNo1 = rs.getObject(12) != null ? Boolean.valueOf(rs.getBoolean(12)) : null;
                Boolean bl = yesNo2 = rs.getObject(13) != null ? Boolean.valueOf(rs.getBoolean(13)) : null;
                gtpId = doMapGTPIds ? (rs.getObject(14) != null ? Integer.valueOf(rs.getInt(14)) : null) : oldStratId;
                if (gtpId != null) {
                    if ((gtpId = gtpIdMapper.get(gtpId)) == null) {
                        tblWriter.logError("Old GTPID[" + gtpId + "] in the Strat record could not be mapped for Old StratID[" + oldStratId + "]");
                        ++stratsWithNoMappedGTP;
                    }
                } else {
                    ++stratsWithNoGTP;
                }
                LithoStrat[] newStrats = this.convertOldStratRecord(superGroup, lithoGroup, formation, member, bed, remarks, text1, text2, number1, number2, yesNo1, yesNo2, earth, localSession);
                LithoStrat newStrat = this.getLastLithoStrat(newStrats);
                ++counter;
                if (newStrat != null) {
                    lithoStratIdMapper.put(oldStratId, newStrat.getLithoStratId());
                    Integer newCEId = ceMapper.get(oldStratId);
                    if (newCEId != null) {
                        newCEIdToNewStratIdHash.put(newCEId, newStrat.getLithoStratId());
                    } else {
                        String msg = String.format("No CE mapping for Old StratId %d, when they are a one-to-one.", oldStratId);
                        tblWriter.logError(msg);
                        log.error((Object)msg);
                        ++missingCEMapping;
                    }
                    if (gtpId == null || stratGTPIdHash.get(newStrat.getLithoStratId()) != null) continue;
                    stratGTPIdHash.put(newStrat.getLithoStratId(), gtpId);
                    continue;
                }
                String msg = String.format("Strat Fields were all null for oldID", oldStratId);
                tblWriter.logError(msg);
                log.error((Object)msg);
                ++missingCEMapping;
            }
            stmt.close();
            if (this.hasFrame) {
                this.setProcess(counter);
            } else {
                log.info((Object)("Converted " + counter + " Stratigraphy records"));
            }
            TreeHelper.fixFullnameForNodeAndDescendants(earth);
            earth.setNodeNumber(1);
            GenericDBConversion.fixNodeNumbersFromRoot(earth);
            HibernateUtil.commitTransaction();
            log.info((Object)("Converted " + counter + " Stratigraphy records"));
            rs.close();
            Statement updateStatement = this.newDBConn.createStatement();
            int ceCnt = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT Count(CollectingEventID) FROM collectingevent");
            int stratCnt = BasicSQLUtils.getCountAsInt(this.oldDBConn, String.format("SELECT Count(CollectingEventID) FROM collectingevent INNER JOIN %s ON CollectingEventID = StratigraphyID", srcTableName));
            String msg = String.format("There are %d CE->Strat and %d CEs. The diff is %d", stratCnt, ceCnt, ceCnt - stratCnt);
            tblWriter.log(msg);
            log.debug((Object)msg);
            stmt = this.newDBConn.createStatement(1004, 1007);
            stmt.setFetchSize(Integer.MIN_VALUE);
            int processCnt = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM collectionobject WHERE CollectingEventID IS NOT NULL");
            if (this.frame != null) {
                this.frame.setDesc("Converting PaleoContext...");
                this.frame.setProcess(0, processCnt);
            }
            TreeSet<Integer> missingStratIds = new TreeSet<Integer>();
            int missingStrat = 0;
            int missingGTP = 0;
            int coUpdateCnt = 0;
            int cnt = 0;
            sql = "SELECT CollectionObjectID, CollectingEventID FROM collectionobject WHERE CollectingEventID IS NOT NULL ORDER BY CollectionObjectID";
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                int coId = rs.getInt(1);
                Integer ceId = rs.getInt(2);
                Integer newLithoId = newCEIdToNewStratIdHash.get(ceId);
                if (newLithoId == null) {
                    ++missingStrat;
                    missingStratIds.add(ceId);
                    continue;
                }
                gtpId = (Integer)stratGTPIdHash.get(newLithoId);
                if (gtpId == null) {
                    ++missingGTP;
                }
                try {
                    String updateStr = "INSERT INTO paleocontext (TimestampCreated, TimestampModified, CollectionMemberID, Version, CreatedByAgentID, ModifiedByAgentID, LithoStratID, ChronosStratID) VALUES ('" + nowStr + "','" + nowStr + "'," + this.getCollectionMemberId() + ", 0, " + this.getCreatorAgentId(null) + "," + this.getModifiedByAgentId(null) + "," + newLithoId + "," + (gtpId != null ? gtpId : "NULL") + ")";
                    updateStatement.executeUpdate(updateStr);
                    Integer paleoContextID = BasicSQLUtils.getInsertedId(updateStatement);
                    if (paleoContextID == null) {
                        throw new RuntimeException("Couldn't get the Agent's inserted ID");
                    }
                    String sqlUpdate = "UPDATE collectionobject SET PaleoContextID=" + paleoContextID + " WHERE CollectionObjectID = " + coId;
                    updateStatement.executeUpdate(sqlUpdate);
                    ++coUpdateCnt;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    log.error((Object)e);
                    UIRegistry.showError(e.getMessage());
                    throw new RuntimeException(e);
                }
                ++processCnt;
                if (this.frame == null || cnt % 100 != 0) continue;
                this.frame.setProcess(cnt);
            }
            rs.close();
            stmt.close();
            if (this.frame != null) {
                this.frame.setProcess(processCnt);
            }
            msg = String.format("There are %d unmappable Strat Records and %d unmappable GTP records.", missingStrat, missingGTP);
            tblWriter.log(msg);
            log.debug((Object)msg);
            msg = String.format("There are %d CO records updated.", coUpdateCnt);
            tblWriter.log(msg);
            log.debug((Object)msg);
            updateStatement.close();
            msg = String.format("No CE mapping for Old StratId Count: %d", missingCEMapping);
            tblWriter.logError(msg);
            log.error((Object)msg);
            msg = String.format("Strats with No GTP Count: %d", stratsWithNoGTP);
            tblWriter.logError(msg);
            log.error((Object)msg);
            msg = String.format("Strats with missing Mapping to GTP Count: %d", stratsWithNoMappedGTP);
            tblWriter.logError(msg);
            log.error((Object)msg);
            msg = String.format("Number of Old StratIds mapped to a new Strat ID Count: %d", lithoStratIdMapper.size());
            tblWriter.logError(msg);
            log.error((Object)msg);
            for (Integer id : missingStratIds) {
                msg = String.format("Missing New Strat %d", id);
                tblWriter.logError(msg);
                log.error((Object)msg);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private LithoStrat getLastLithoStrat(LithoStrat[] lithoStrats) {
        if (lithoStrats != null && lithoStrats.length > 0) {
            int inx = lithoStrats.length - 1;
            while (lithoStrats[inx] == null) {
                ++inx;
            }
            return lithoStrats[inx];
        }
        return null;
    }

    public LithoStrat convertLithoStratFromCSV(LithoStratTreeDef treeDef, boolean doSave) {
        Session localSession;
        this.lithoStratHash.clear();
        File file = new File("Stratigraphy.csv");
        if (!file.exists()) {
            log.error((Object)("Couldn't file[" + file.getAbsolutePath() + "]"));
            return null;
        }
        BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "lithostrat", BasicSQLUtils.myDestinationServerType);
        Object object = localSession = doSave ? HibernateUtil.getCurrentSession() : null;
        if (localSession != null) {
            HibernateUtil.beginTransaction();
        }
        List lines = null;
        try {
            lines = FileUtils.readLines((File)file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        LithoStrat earth = new LithoStrat();
        earth.initialize();
        earth.setName("Earth");
        earth.setRankId(0);
        earth.setDefinition(treeDef);
        for (LithoStratTreeDefItem o : treeDef.getTreeDefItems()) {
            LithoStratTreeDefItem defItem = o;
            if (defItem.getRankId() != 0) continue;
            earth.setDefinitionItem(defItem);
            break;
        }
        LithoStratTreeDefItem defItem = treeDef.getDefItemByRank(0);
        earth.setDefinitionItem(defItem);
        if (doSave) {
            localSession.save((Object)earth);
        }
        IdTableMapper lithoStratIdMapper = doSave ? IdMapperMgr.getInstance().addTableMapper("lithostrat", "LithoStratID") : null;
        int counter = 0;
        for (String line : lines) {
            String[] columns;
            if (counter == 0) {
                counter = 1;
                continue;
            }
            if (counter % 500 == 0) {
                if (this.hasFrame) {
                    this.setProcess(counter);
                } else {
                    log.info((Object)("Converted " + counter + " Stratigraphy records"));
                }
            }
            if ((columns = StringUtils.splitPreserveAllTokens((String)line, (char)',')).length < 7) {
                log.error((Object)("Skipping[" + line + "]"));
                continue;
            }
            int oldId = Integer.parseInt(columns[0]);
            String superGroup = columns[2];
            String lithoGroup = columns[3];
            String formation = columns[4];
            String member = columns[5];
            String bed = columns[6];
            LithoStrat[] newStrats = this.convertOldStratRecord(superGroup, lithoGroup, formation, member, bed, null, null, null, null, null, null, null, earth, localSession);
            ++counter;
            if (!shouldCreateMapTables || lithoStratIdMapper == null) continue;
            lithoStratIdMapper.put(oldId, this.getLastLithoStrat(newStrats).getLithoStratId());
        }
        if (this.hasFrame) {
            this.setProcess(counter);
        } else {
            log.info((Object)("Converted " + counter + " Stratigraphy records"));
        }
        TreeHelper.fixFullnameForNodeAndDescendants(earth);
        earth.setNodeNumber(1);
        GenericDBConversion.fixNodeNumbersFromRoot(earth);
        if (doSave) {
            HibernateUtil.commitTransaction();
        }
        log.info((Object)("Converted " + counter + " Stratigraphy records"));
        if (doSave) {
            this.idMapperMgr.mapForeignKey("Locality", "StratigraphyID", "LithoStrat", "LithoStratID");
        }
        this.lithoStratHash.clear();
        return earth;
    }

    protected LithoStrat buildLithoStratLevel(String nameArg, String remarks, String text1, String text2, Double number1, Double number2, Boolean yesNo1, Boolean yesNo2, LithoStrat parentArg, Session sessionArg) {
        String name = nameArg;
        if (name == null) {
            name = "N/A";
        }
        Set<LithoStrat> children = parentArg.getChildren();
        for (LithoStrat child : children) {
            if (!name.equalsIgnoreCase(child.getName())) continue;
            return child;
        }
        LithoStrat newStrat = new LithoStrat();
        newStrat.initialize();
        newStrat.setName(name);
        newStrat.setRemarks(remarks);
        newStrat.setText1(text1);
        newStrat.setText2(text2);
        newStrat.setNumber1(number1);
        newStrat.setNumber2(number2);
        newStrat.setYesNo1(yesNo1);
        newStrat.setYesNo2(yesNo2);
        newStrat.setParent(parentArg);
        parentArg.addChild(newStrat);
        newStrat.setDefinition(parentArg.getDefinition());
        int newGeoRank = parentArg.getRankId() + 100;
        LithoStratTreeDefItem defItem = parentArg.getDefinition().getDefItemByRank(newGeoRank);
        newStrat.setDefinitionItem(defItem);
        newStrat.setRankId(newGeoRank);
        if (sessionArg != null) {
            sessionArg.save((Object)newStrat);
        }
        return newStrat;
    }

    protected LithoStrat[] convertOldStratRecord(String superGroup, String lithoGroup, String formation, String member, String bed, String remarks, String text1, String text2, Double number1, Double number2, Boolean yesNo1, Boolean yesNo2, LithoStrat stratRoot, Session localSession) {
        String[] levelNames = new String[]{superGroup, lithoGroup, formation, member, bed};
        int levelsToBuild = 0;
        int i = levelNames.length;
        while (i > 0) {
            if (StringUtils.isNotEmpty((String)levelNames[i - 1])) {
                levelsToBuild = i;
                break;
            }
            --i;
        }
        i = 0;
        while (i < levelsToBuild) {
            if (StringUtils.isEmpty((String)levelNames[i])) {
                levelNames[i] = "(Empty)";
            }
            ++i;
        }
        LithoStrat[] newStrat = new LithoStrat[levelsToBuild];
        LithoStrat prevLevelGeo = stratRoot;
        int i2 = 0;
        while (i2 < levelsToBuild) {
            LithoStrat newLevelStrat;
            newStrat[i2] = newLevelStrat = this.buildLithoStratLevel(levelNames[i2], remarks, text1, text2, number1, number2, yesNo1, yesNo2, prevLevelGeo, localSession);
            prevLevelGeo = newLevelStrat;
            ++i2;
        }
        return newStrat;
    }

    public StorageTreeDef buildSampleStorageTreeDef() {
        BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "storagetreedef", BasicSQLUtils.myDestinationServerType);
        BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "storagetreedefitem", BasicSQLUtils.myDestinationServerType);
        log.info((Object)"Creating a sample storage tree definition");
        Session localSession = HibernateUtil.getCurrentSession();
        HibernateUtil.beginTransaction();
        StorageTreeDef locDef = TreeFactory.createStdStorageTreeDef("Sample storage tree", null);
        locDef.setRemarks("This definition is merely for demonstration purposes.  Consult documentation or support staff for instructions on creating one tailored for an institutions specific needs.");
        locDef.setFullNameDirection(1);
        localSession.save((Object)locDef);
        StorageTreeDefItem rootItem = locDef.getTreeDefItems().iterator().next();
        rootItem.setFullNameSeparator(", ");
        localSession.save((Object)rootItem);
        Storage rootNode = rootItem.getTreeEntries().iterator().next();
        localSession.save((Object)rootNode);
        StorageTreeDefItem building = new StorageTreeDefItem();
        building.initialize();
        building.setRankId(100);
        building.setName("Building");
        building.setIsEnforced(false);
        building.setIsInFullName(false);
        building.setTreeDef(locDef);
        building.setFullNameSeparator(", ");
        localSession.save((Object)building);
        StorageTreeDefItem room = new StorageTreeDefItem();
        room.initialize();
        room.setRankId(200);
        room.setName("Room");
        room.setIsEnforced(true);
        room.setIsInFullName(true);
        room.setTreeDef(locDef);
        room.setFullNameSeparator(", ");
        localSession.save((Object)room);
        StorageTreeDefItem freezer = new StorageTreeDefItem();
        freezer.initialize();
        freezer.setRankId(300);
        freezer.setName("Freezer");
        freezer.setIsEnforced(true);
        freezer.setIsInFullName(true);
        freezer.setTreeDef(locDef);
        freezer.setFullNameSeparator(", ");
        localSession.save((Object)freezer);
        rootItem.setChild(building);
        building.setParent(rootItem);
        building.setChild(room);
        room.setParent(building);
        room.setChild(freezer);
        freezer.setParent(room);
        locDef.addTreeDefItem(building);
        locDef.addTreeDefItem(room);
        locDef.addTreeDefItem(freezer);
        HibernateUtil.commitTransaction();
        return locDef;
    }

    public GeologicTimePeriodTreeDef convertGTPDefAndItems(boolean isPaleo) throws SQLException {
        BasicSQLUtils.deleteAllRecordsFromTable("geologictimeperiodtreedef", BasicSQLUtils.myDestinationServerType);
        BasicSQLUtils.deleteAllRecordsFromTable("geologictimeperiodtreedefitem", BasicSQLUtils.myDestinationServerType);
        log.info((Object)"Inferring geologic time period definition from old records");
        int count = 0;
        String sql = "SELECT RankCode, RankName from geologictimeperiod";
        Statement statement = this.oldDBConn.createStatement(1004, 1007);
        statement.setFetchSize(Integer.MIN_VALUE);
        ResultSet oldGtpRecords = statement.executeQuery(sql);
        Session localSession = HibernateUtil.getCurrentSession();
        HibernateUtil.beginTransaction();
        GeologicTimePeriodTreeDef def = new GeologicTimePeriodTreeDef();
        def.initialize();
        def.setName("Inferred Geologic Time Period Definition");
        def.setRemarks("");
        def.setFullNameDirection(-1);
        localSession.save((Object)def);
        Vector<GeologicTimePeriodTreeDefItem> newItems = new Vector<GeologicTimePeriodTreeDefItem>();
        GeologicTimePeriodTreeDefItem rootItem = this.addGtpDefItem(0, "Time Root", def);
        rootItem.setIsEnforced(true);
        rootItem.setIsInFullName(false);
        rootItem.setFullNameSeparator(", ");
        localSession.save((Object)rootItem);
        newItems.add(rootItem);
        ++count;
        if (isPaleo) {
            while (oldGtpRecords.next()) {
                String rankName;
                Integer rankCode = oldGtpRecords.getInt(1) * 100;
                GeologicTimePeriodTreeDefItem newItem = this.addGtpDefItem(rankCode, rankName = oldGtpRecords.getString(2), def);
                if (newItem != null) {
                    newItem.setFullNameSeparator(", ");
                    localSession.save((Object)newItem);
                    newItems.add(newItem);
                }
                if (++count % 1000 != 0) continue;
                log.info((Object)(String.valueOf(count) + " geologic time period records processed"));
            }
        }
        Comparator<GeologicTimePeriodTreeDefItem> itemComparator = new Comparator<GeologicTimePeriodTreeDefItem>(){

            @Override
            public int compare(GeologicTimePeriodTreeDefItem o1, GeologicTimePeriodTreeDefItem o2) {
                return o1.getRankId().compareTo(o2.getRankId());
            }
        };
        Collections.sort(newItems, itemComparator);
        int i = 0;
        while (i < newItems.size() - 1) {
            ((GeologicTimePeriodTreeDefItem)newItems.get(i)).setChild((GeologicTimePeriodTreeDefItem)newItems.get(i + 1));
            ++i;
        }
        HibernateUtil.commitTransaction();
        log.info((Object)"Finished inferring GTP tree definition and items");
        return def;
    }

    protected GeologicTimePeriodTreeDefItem addGtpDefItem(Integer rankCode, String rankName, GeologicTimePeriodTreeDef def) {
        for (GeologicTimePeriodTreeDefItem o : def.getTreeDefItems()) {
            GeologicTimePeriodTreeDefItem item = o;
            if (!item.getRankId().equals(rankCode)) continue;
            return null;
        }
        GeologicTimePeriodTreeDefItem item = new GeologicTimePeriodTreeDefItem();
        item.initialize();
        item.setRankId(rankCode);
        item.setName(rankName);
        def.addTreeDefItem(item);
        return item;
    }

    public void convertGTP(TableWriter tblWriter, GeologicTimePeriodTreeDef treeDef, boolean isPaleo) throws SQLException {
        BasicSQLUtils.deleteAllRecordsFromTable("geologictimeperiod", BasicSQLUtils.myDestinationServerType);
        log.info((Object)"Converting old geologic time period records");
        int count = 0;
        IdTableMapper gtpIdMapper = IdMapperMgr.getInstance().addTableMapper("geologictimeperiod", "GeologicTimePeriodID");
        Hashtable<Integer, GeologicTimePeriod> oldIdToGTPMap = new Hashtable<Integer, GeologicTimePeriod>();
        String sql = "SELECT g.GeologicTimePeriodID,g.RankCode,g.Name,g.Standard,g.Remarks,g.TimestampModified,g.TimestampCreated,p1.Age as Upper,p1.AgeUncertainty as UpperUncertainty,p2.Age as Lower,p2.AgeUncertainty as LowerUncertainty FROM geologictimeperiod g, geologictimeboundary p1, geologictimeboundary p2 WHERE g.UpperBoundaryID=p1.GeologicTimeBoundaryID AND g.LowerBoundaryID=p2.GeologicTimeBoundaryID ORDER BY Lower DESC, RankCode";
        Statement statement = this.oldDBConn.createStatement(1004, 1007);
        statement.setFetchSize(Integer.MIN_VALUE);
        ResultSet rs = statement.executeQuery(sql);
        Session localSession = HibernateUtil.getCurrentSession();
        HibernateUtil.beginTransaction();
        Vector<GeologicTimePeriod> newItems = new Vector<GeologicTimePeriod>();
        GeologicTimePeriod allTime = new GeologicTimePeriod();
        allTime.initialize();
        allTime.setDefinition(treeDef);
        GeologicTimePeriodTreeDefItem rootDefItem = treeDef.getDefItemByRank(0);
        allTime.setDefinitionItem(rootDefItem);
        allTime.setRankId(0);
        allTime.setName("Time");
        allTime.setFullName("Time");
        allTime.setStartPeriod(Float.valueOf(100000.0f));
        allTime.setEndPeriod(Float.valueOf(0.0f));
        allTime.setEndUncertainty(Float.valueOf(0.0f));
        allTime.setTimestampCreated(now);
        ++count;
        newItems.add(allTime);
        boolean needsTbl = true;
        if (isPaleo) {
            while (rs.next()) {
                Integer id = rs.getInt(1);
                Integer rank = rs.getInt(2) * 100;
                String name = rs.getString(3);
                String std = rs.getString(4);
                String rem = rs.getString(5);
                Date modTDate = rs.getDate(6);
                Date creTDate = rs.getDate(7);
                Timestamp modT = modTDate != null ? new Timestamp(modTDate.getTime()) : null;
                Timestamp creT = creTDate != null ? new Timestamp(creTDate.getTime()) : null;
                Float upper = Float.valueOf(rs.getFloat(8));
                Float uError = (Float)rs.getObject(9);
                Float lower = Float.valueOf(rs.getFloat(10));
                Float lError = (Float)rs.getObject(11);
                if (StringUtils.isEmpty((String)name)) {
                    if (needsTbl) {
                        tblWriter.startTable();
                        tblWriter.logHdr("ID", "Rank Name", "Name", "Reason");
                        needsTbl = false;
                    }
                    tblWriter.log(id.toString(), rank.toString(), name, "Name is null, Name set to 'XXXX'");
                    log.error((Object)("The Name is empty (or null) for GTP ID[" + id + "]  Rank[" + rank + "]"));
                    name = "XXXX";
                }
                if (modT == null && creT == null) {
                    creT = now;
                    modT = now;
                } else if (modT == null && creT != null) {
                    modT = new Timestamp(creT.getTime());
                } else if (modT != null && creT == null) {
                    creT = new Timestamp(modT.getTime());
                }
                GeologicTimePeriod gtp = new GeologicTimePeriod();
                gtp.initialize();
                gtp.setName(name);
                gtp.setFullName(name);
                GeologicTimePeriodTreeDefItem defItem = treeDef.getDefItemByRank(rank);
                gtp.setDefinitionItem(defItem);
                gtp.setRankId(rank);
                gtp.setDefinition(treeDef);
                gtp.setStartPeriod(lower);
                gtp.setStartUncertainty(lError);
                gtp.setEndPeriod(upper);
                gtp.setEndUncertainty(uError);
                gtp.setStandard(std);
                gtp.setRemarks(rem);
                gtp.setTimestampCreated(creT);
                gtp.setTimestampModified(modT);
                newItems.add(gtp);
                oldIdToGTPMap.put(id, gtp);
                if (++count % 500 != 0) continue;
                log.info((Object)(String.valueOf(count) + " geologic time period records converted"));
            }
            int i = 0;
            while (i < newItems.size()) {
                GeologicTimePeriod gtp = (GeologicTimePeriod)newItems.get(i);
                int j = 0;
                while (j < newItems.size()) {
                    GeologicTimePeriod child = (GeologicTimePeriod)newItems.get(j);
                    if (this.isParentChildPair(gtp, child)) {
                        gtp.addChild(child);
                    }
                    ++j;
                }
                ++i;
            }
            TreeHelper.fixFullnameForNodeAndDescendants(allTime);
        }
        allTime.setNodeNumber(1);
        GenericDBConversion.fixNodeNumbersFromRoot(allTime);
        localSession.save((Object)allTime);
        HibernateUtil.commitTransaction();
        if (shouldCreateMapTables) {
            for (Integer oldId : oldIdToGTPMap.keySet()) {
                GeologicTimePeriod gtp = (GeologicTimePeriod)oldIdToGTPMap.get(oldId);
                gtpIdMapper.put(oldId, gtp.getId());
            }
        }
        IdMapperMgr.getInstance().mapForeignKey("Stratigraphy", "GeologicTimePeriodID", "GeologicTimePeriod", "GeologicTimePeriodID");
        log.info((Object)(String.valueOf(count) + " geologic time period records converted"));
        if (!needsTbl) {
            tblWriter.endTable();
        }
    }

    public void convertStrat(TableWriter tblWriter, boolean isPaleo) throws SQLException {
        Transaction trans = null;
        Session lclSession = null;
        try {
            try {
                BasicSQLUtils.deleteAllRecordsFromTable(this.newDBConn, "lithostrat", BasicSQLUtils.myDestinationServerType);
                lclSession = HibernateUtil.getNewSession();
                List disciplineeList = lclSession.createQuery("FROM Discipline").list();
                for (Object obj : disciplineeList) {
                    trans = lclSession.beginTransaction();
                    Discipline discipline = (Discipline)obj;
                    LithoStratTreeDef lithoStratTreeDef = DataBuilder.createLithoStratTreeDef("LithoStrat");
                    lithoStratTreeDef.getDisciplines().add(discipline);
                    discipline.setLithoStratTreeDef(lithoStratTreeDef);
                    lclSession.saveOrUpdate((Object)lithoStratTreeDef);
                    lclSession.saveOrUpdate((Object)discipline);
                    LithoStratTreeDefItem earth = DataBuilder.createLithoStratTreeDefItem(lithoStratTreeDef, "Surface", 0, false);
                    LithoStratTreeDefItem superGrp = DataBuilder.createLithoStratTreeDefItem(earth, "Super Group", 100, false);
                    LithoStratTreeDefItem lithoGrp = DataBuilder.createLithoStratTreeDefItem(superGrp, "Litho Group", 200, false);
                    LithoStratTreeDefItem formation = DataBuilder.createLithoStratTreeDefItem(lithoGrp, "Formation", 300, false);
                    LithoStratTreeDefItem member = DataBuilder.createLithoStratTreeDefItem(formation, "Member", 400, false);
                    LithoStratTreeDefItem bed = DataBuilder.createLithoStratTreeDefItem(member, "Bed", 500, true);
                    lclSession.saveOrUpdate((Object)earth);
                    LithoStrat earthNode = new LithoStrat();
                    earthNode.initialize();
                    earthNode.setName("Earth");
                    earthNode.setFullName("Earth");
                    earthNode.setNodeNumber(1);
                    earthNode.setHighestChildNodeNumber(1);
                    earthNode.setRankId(0);
                    earthNode.setDefinition(lithoStratTreeDef);
                    earthNode.setDefinitionItem(earth);
                    earth.getTreeEntries().add(earthNode);
                    lclSession.saveOrUpdate((Object)earthNode);
                    trans.commit();
                    if (!isPaleo) continue;
                    this.convertLithoStrat(lithoStratTreeDef, earthNode, tblWriter, "stratigraphy", true);
                }
            }
            catch (Exception ex) {
                if (trans != null) {
                    trans.rollback();
                }
                ex.printStackTrace();
                if (lclSession != null) {
                    lclSession.close();
                }
            }
        }
        finally {
            if (lclSession != null) {
                lclSession.close();
            }
        }
    }

    public static <T extends Treeable<T, ?, ?>> int fixNodeNumbersFromRoot(T root) {
        int nextNodeNumber = root.getNodeNumber();
        for (Treeable child : root.getChildren()) {
            child.setNodeNumber(++nextNodeNumber);
            nextNodeNumber = GenericDBConversion.fixNodeNumbersFromRoot(child);
        }
        root.setHighestChildNodeNumber(nextNodeNumber);
        return nextNodeNumber;
    }

    protected boolean isParentChildPair(GeologicTimePeriod parent, GeologicTimePeriod child) {
        if (parent == child) {
            return false;
        }
        Float startParent = parent.getStartPeriod();
        Float endParent = parent.getEndPeriod();
        Float startChild = child.getStartPeriod();
        Float endChild = child.getEndPeriod();
        return startParent.floatValue() >= startChild.floatValue() && endParent.floatValue() <= endChild.floatValue() && parent.getRankId() < child.getRankId();
    }

    protected static void addNamesWithTableName(List<String> list, List<String> fieldNames, String tableName) {
        for (String fldName : fieldNames) {
            list.add(String.valueOf(tableName) + "." + fldName);
        }
    }

    protected void buildIndexMapFromMetaData(ResultSetMetaData rsmd, Hashtable<String, Integer> map, String[] tableNames) throws SQLException {
        map.clear();
        Hashtable<String, Boolean> existsMap = new Hashtable<String, Boolean>();
        String[] stringArray = tableNames;
        int n = tableNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tblName = stringArray[n2];
            existsMap.put(tblName, true);
            log.debug((Object)("[" + tblName + "]"));
            ++n2;
        }
        int i = 1;
        while (i <= rsmd.getColumnCount()) {
            String tableName = rsmd.getTableName(i);
            if (StringUtils.isNotEmpty((String)tableName) && existsMap.get(tableName) != null) {
                existsMap.remove(tableName);
                log.info((Object)("Removing Table Name[" + tableName + "]"));
            }
            ++i;
        }
        String missingTableName = null;
        if (existsMap.size() == 1) {
            missingTableName = (String)existsMap.keys().nextElement();
            log.info((Object)("Missing Table Name[" + missingTableName + "]"));
        } else {
            if (existsMap.size() > 1) {
                throw new RuntimeException("ExistsMap cannot have more than one name in it!");
            }
            log.info((Object)"No Missing Table Names.");
        }
        int i2 = 1;
        while (i2 <= rsmd.getColumnCount()) {
            strBuf.setLength(0);
            String tableName = rsmd.getTableName(i2);
            strBuf.append(StringUtils.isNotEmpty((String)tableName) ? tableName : missingTableName);
            strBuf.append(".");
            strBuf.append(rsmd.getColumnName(i2));
            map.put(strBuf.toString(), i2);
            ++i2;
        }
    }

    protected void buildIndexMapFromMetaData(ResultSetMetaData rsmd, List<String> origList, Hashtable<String, Integer> map) throws SQLException {
        map.clear();
        StringBuilder sb = new StringBuilder();
        int i = 1;
        while (i <= rsmd.getColumnCount()) {
            sb.setLength(0);
            String tableName = rsmd.getTableName(i);
            String fieldName = rsmd.getColumnName(i);
            if (StringUtils.isNotEmpty((String)tableName)) {
                sb.append(tableName);
            } else {
                for (String fullName : origList) {
                    String[] parts = StringUtils.split((String)fullName, (String)".");
                    if (!parts[1].equals(fieldName)) continue;
                    sb.append(parts[0]);
                    break;
                }
            }
            sb.append(".");
            sb.append(fieldName);
            map.put(sb.toString(), i);
            ++i;
        }
    }

    public void cleanUp() {
        try {
            PrintWriter pw = new PrintWriter("unmappedagents.txt");
            Vector<String> nameList = new Vector<String>(oldUnmappedAgentNames);
            Collections.sort(nameList);
            for (String name : nameList) {
                pw.println(name);
            }
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        File indexFile = this.convLogger.closeAll();
        if (indexFile != null && indexFile.exists()) {
            try {
                AttachmentUtils.openURI(indexFile.toURI());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void createAndFillStatTable() {
        try {
            Statement stmtNew = this.newDBConn.createStatement();
            String str = "DROP TABLE `webstats`";
            try {
                stmtNew.executeUpdate(str);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            str = "CREATE TABLE `webstats` (`WebStatsID` int(11) NOT NULL default '0', `UniqueVisitors1` int(11), `UniqueVisitors2` int(11), `UniqueVisitors3` int(11), `UniqueVisitors4` int(11), `UniqueVisitors5` int(11), `UniqueVisitors6` int(11), `UniqueVisitorsMon1` varchar(32), `UniqueVisitorsMon2` varchar(32), `UniqueVisitorsMon3` varchar(32), `UniqueVisitorsMon4` varchar(32), `UniqueVisitorsMon5` varchar(32), `UniqueVisitorsMon6` varchar(32), `UniqueVisitorsYear` varchar(32), `Taxon1` varchar(32), `TaxonCnt1` int(11), `Taxon2` varchar(32), `TaxonCnt2` int(11), `Taxon3` varchar(32), `TaxonCnt3` int(11), `Taxon4` varchar(32), `TaxonCnt4` int(11), `Taxon5` varchar(32), `TaxonCnt5` int(11),  PRIMARY KEY (`WebStatsID`) ) ENGINE=InnoDB DEFAULT CHARSET=latin1";
            stmtNew.executeUpdate(str);
            str = "INSERT INTO webstats VALUES (0, 234, 189, 211, 302, 229, 276, 'Nov', 'Dec', 'Jan', 'Feb', 'Mar', 'Apr',  2621, 'Etheostoma',  54,'notatus',  39,'lutrensis',  22,'anomalum',  12,'platostomus',  8)";
            stmtNew.executeUpdate(str);
            stmtNew.clearBatch();
            stmtNew.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void setSharingCollectingEvents(boolean isSharingCollectingEvents) {
        this.isSharingCollectingEvents = isSharingCollectingEvents;
    }

    @Override
    public int getNextIndex() {
        return this.globalIdNumber++;
    }

    public static boolean shouldCreateMapTables() {
        return shouldCreateMapTables;
    }

    public static boolean shouldDeleteMapTables() {
        return shouldDeleteMapTables;
    }

    public static void setShouldCreateMapTables(boolean shouldCreateMapTables) {
        GenericDBConversion.shouldCreateMapTables = shouldCreateMapTables;
    }

    public static void setShouldDeleteMapTables(boolean shouldDeleteMapTables) {
        GenericDBConversion.shouldDeleteMapTables = shouldDeleteMapTables;
    }

    public Integer getCurDivisionID() {
        return this.curDivisionID;
    }

    public Integer getCurDisciplineID() {
        return this.curDisciplineID;
    }

    public Integer getCurCollectionID() {
        return this.curCollectionID;
    }

    public Integer getCurAgentCreatorID() {
        return this.curAgentCreatorID;
    }

    public Integer getCurAgentModifierID() {
        return this.curAgentModifierID;
    }

    public ConversionLogger getConvLogger() {
        return this.convLogger;
    }

    public Hashtable<String, BasicSQLUtilsMapValueIFace> getColumnValueMapper() {
        return this.columnValueMapper;
    }

    public Connection getOldDBConn() {
        return this.oldDBConn;
    }

    public void setOldDBConn(Connection oldDBConn) {
        this.oldDBConn = oldDBConn;
    }

    public Connection getNewDBConn() {
        return this.newDBConn;
    }

    public static enum CollectionResultType {
        eOK,
        eCancel,
        eError;

    }

    public static enum TableType {
        CollectingEvent(0),
        CollectionObject(1),
        ExternalResource(2),
        Preparation(3);

        private short ord;

        private TableType(int ord) {
            this.ord = (short)ord;
        }

        public short getType() {
            return this.ord;
        }
    }

    class TaxonTypeHolder {
        private Object[] row;

        public TaxonTypeHolder(Object[] row) {
            this.row = row;
        }

        public Integer getId() {
            return (Integer)this.row[0];
        }

        public String getName() {
            return this.row[1].toString();
        }

        public String toString() {
            return this.row[1] + " - " + this.row[2];
        }
    }
}

