/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.AttributeIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.AttrUtils;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.GenericDBConversion;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.PrepType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class FishConversion {
    protected static final Logger log = Logger.getLogger(FishConversion.class);
    protected static Hashtable<String, Integer> prepTypeMapper = new Hashtable();
    protected static int attrsId = 0;
    protected static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    protected static StringBuilder strBuf = new StringBuilder("");
    protected static Calendar calendar = Calendar.getInstance();
    protected Discipline discipline;

    public FishConversion(Discipline discipline) {
        this.discipline = discipline;
    }

    public void loadAttrs(boolean cleanTables, Map<String, PrepType> prepTypesMap) {
        if (cleanTables) {
            BasicSQLUtils.deleteAllRecordsFromTable("attrsdef", BasicSQLUtils.myDestinationServerType);
            BasicSQLUtils.deleteAllRecordsFromTable("prepattr", BasicSQLUtils.myDestinationServerType);
        }
        String[] fishEtOHAttrs = new String[]{"size", "sex"};
        short[] fishEtOHTypes = new short[]{AttributeIFace.FieldType.StringType.getType(), AttributeIFace.FieldType.StringType.getType()};
        String[] fishSkelAttrs = new String[]{"size"};
        short[] fishSkelTypes = new short[]{AttributeIFace.FieldType.StringType.getType()};
        String[] fishTissueAttrs = new String[]{"dna"};
        short[] fishTissueTypes = new short[]{AttributeIFace.FieldType.StringType.getType()};
        String[] fishClearStainAttrs = new String[]{"stain_color"};
        short[] fishClearStainTypes = new short[]{AttributeIFace.FieldType.StringType.getType()};
        String[] fishXRayAttrs = new String[]{"film_no"};
        short[] fishXRayTypes = new short[]{AttributeIFace.FieldType.StringType.getType()};
        String[] fishMiscAttrs = new String[]{"misc"};
        short[] fishMiscTypes = new short[]{AttributeIFace.FieldType.StringType.getType()};
        AttrUtils.loadAttrDefs(this.discipline, GenericDBConversion.TableType.Preparation, null, fishEtOHAttrs, fishEtOHTypes);
        AttrUtils.loadAttrDefs(this.discipline, GenericDBConversion.TableType.Preparation, null, fishSkelAttrs, fishSkelTypes);
        AttrUtils.loadAttrDefs(this.discipline, GenericDBConversion.TableType.Preparation, null, fishClearStainAttrs, fishClearStainTypes);
        AttrUtils.loadAttrDefs(this.discipline, GenericDBConversion.TableType.Preparation, null, fishTissueAttrs, fishTissueTypes);
        AttrUtils.loadAttrDefs(this.discipline, GenericDBConversion.TableType.Preparation, null, fishXRayAttrs, fishXRayTypes);
        AttrUtils.loadAttrDefs(this.discipline, GenericDBConversion.TableType.Preparation, null, fishMiscAttrs, fishMiscTypes);
        String[] fishBioAttrs = new String[]{"sex", "weight", "length", "remarks"};
        short[] fishBioTypes = new short[]{AttributeIFace.FieldType.StringType.getType(), AttributeIFace.FieldType.FloatType.getType(), AttributeIFace.FieldType.FloatType.getType()};
        AttrUtils.loadAttrDefs(this.discipline, GenericDBConversion.TableType.CollectionObject, null, fishBioAttrs, fishBioTypes);
        String[] fishHabitatAttrs = new String[]{"waterpH", "turbidity", "clarity", "salinity", "current", "substrate", "remarks", "minDepth", "maxDepth"};
        short[] fishHabitatTypes = new short[]{AttributeIFace.FieldType.FloatType.getType(), AttributeIFace.FieldType.FloatType.getType(), AttributeIFace.FieldType.StringType.getType(), AttributeIFace.FieldType.StringType.getType(), AttributeIFace.FieldType.StringType.getType(), AttributeIFace.FieldType.StringType.getType(), AttributeIFace.FieldType.FloatType.getType(), AttributeIFace.FieldType.FloatType.getType()};
        AttrUtils.loadAttrDefs(this.discipline, GenericDBConversion.TableType.CollectingEvent, null, fishHabitatAttrs, fishHabitatTypes);
    }

    public void loadPrepAttrs(Connection oldDBConn, Connection newDBConn) {
        try {
            Statement stmt = oldDBConn.createStatement(1004, 1007);
            StringBuilder sqlStr = new StringBuilder("Select collectionobject.CollectionObjectID, determination.Confidence, determination.Text1");
            sqlStr.append(" From collectionobject Inner Join collectionobjectcatalog ON collectionobject.CollectionObjectID = collectionobjectcatalog.CollectionObjectCatalogID Inner Join determination ON determination.BiologicalObjectID = collectionobjectcatalog.CollectionObjectCatalogID Where collectionobject.DerivedFromID Is Null");
            ResultSet rs = stmt.executeQuery(sqlStr.toString());
            int prepAttrsID = 1;
            Date timeStamp = new Date();
            Date modifiedDate = new Date();
            int count = 0;
            while (rs.next()) {
                Statement updateStatement = newDBConn.createStatement(1004, 1007);
                if (BasicSQLUtils.myDestinationServerType != BasicSQLUtils.SERVERTYPE.MS_SQLServer) {
                    BasicSQLUtils.removeForeignKeyConstraints(newDBConn, BasicSQLUtils.myDestinationServerType);
                }
                String sex = rs.getString(2);
                String size = rs.getString(3);
                if (size != null) {
                    BasicSQLUtils.exeUpdateCmd(updateStatement, AttrUtils.createPrepsInsert(prepAttrsID, "size", size, null, AttributeIFace.FieldType.StringType.getType(), null, timeStamp, modifiedDate, null, rs.getInt(1), null));
                    ++prepAttrsID;
                }
                if (sex != null) {
                    BasicSQLUtils.exeUpdateCmd(updateStatement, AttrUtils.createPrepsInsert(prepAttrsID, "sex", sex, null, AttributeIFace.FieldType.StringType.getType(), null, timeStamp, modifiedDate, null, rs.getInt(1), null));
                    ++prepAttrsID;
                }
                if (++count % 1000 == 0) {
                    log.info((Object)("Processed " + count));
                }
                updateStatement.clearBatch();
                updateStatement.close();
            }
            System.out.println("Processed " + count + " records.");
            stmt.close();
        }
        catch (SQLException e) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(FishConversion.class, e);
            e.printStackTrace();
            log.error((Object)e);
        }
    }
}

