/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import edu.ku.brc.specify.conversion.IdTableMapper;
import edu.ku.brc.specify.datamodel.CollectingEvent;
import edu.ku.brc.specify.datamodel.CollectingEventAttribute;
import edu.ku.brc.specify.datamodel.Collector;
import edu.ku.brc.ui.CustomFrame;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DuplicateCollectingEvents {
    protected static final Logger log = Logger.getLogger(DuplicateCollectingEvents.class);
    protected Connection oldDBConn;
    protected Connection newDBConn;
    protected ProgressFrame progressFrame;
    protected int createdByAgentId;
    protected Integer disciplineId;
    protected Vector<Integer> cesNoCOList = new Vector(1000);

    public DuplicateCollectingEvents(Connection oldDBConn, Connection newDBConn, ProgressFrame progressFrame, int createdByAgentId, Integer disciplineId) {
        this.oldDBConn = oldDBConn;
        this.newDBConn = newDBConn;
        this.progressFrame = progressFrame;
        this.createdByAgentId = createdByAgentId;
        this.disciplineId = disciplineId;
    }

    public DuplicateCollectingEvents(Connection oldDBConn, Connection newDBConn) {
        this(oldDBConn, newDBConn, null, 0, null);
        this.disciplineId = BasicSQLUtils.getCount("SELECT DisciplineID FROM discipline ORDER BY DisciplineID LIMIT 0,1");
        this.createdByAgentId = BasicSQLUtils.getCount("SELECT AgentID FROM agent ORDER BY AgentID LIMIT 0,1");
    }

    private String getQueryPostfix() {
        return " FROM (SELECT ce.CollectingEventID, COUNT(ce.CollectingEventID) AS cnt FROM collectingevent ce INNER JOIN collectionobject co ON ce.CollectingEventID = co.CollectingEventID INNER JOIN collectionobjectcatalog cc ON co.CollectionObjectID = cc.CollectionObjectCatalogID WHERE co.CollectionObjectTypeID > 8 AND co.CollectionObjectTypeID < 20 AND cc.SubNumber >= 0 GROUP BY ce.CollectingEventID) T1 WHERE cnt > 1 ";
    }

    private Vector<Integer> getCollectingEventsWithManyCollectionObjects(Connection oldDBConn) {
        String sql = "SELECT CollectingEventID" + this.getQueryPostfix();
        return BasicSQLUtils.queryForInts(oldDBConn, sql);
    }

    private int getCollectingEventsWithManyCollectionObjectsCount() {
        String sql = "SELECT SUM(cnt)" + this.getQueryPostfix();
        return BasicSQLUtils.getCountAsInt(this.oldDBConn, sql);
    }

    protected int duplicateCollectingEvents() {
        IdTableMapper ceMapper = (IdTableMapper)IdMapperMgr.getInstance().get("collectingevent", "CollectingEventID");
        Statement prepCEStmt = null;
        Statement stmtCE = null;
        Statement prepCECStmt = null;
        Statement stmtCEC = null;
        Statement prepCEAStmt = null;
        Statement stmtCEA = null;
        try {
            String selectCESQL = DuplicateCollectingEvents.createSelectStmt(CollectingEvent.getClassTableId(), "CollectingEventID = %d");
            prepCEStmt = DuplicateCollectingEvents.createPreparedStmt(this.newDBConn, CollectingEvent.getClassTableId());
            stmtCE = this.newDBConn.createStatement();
            String selectCEASQL = DuplicateCollectingEvents.createSelectStmt(CollectingEventAttribute.getClassTableId(), "CollectingEventAttributeID = %d");
            prepCEAStmt = DuplicateCollectingEvents.createPreparedStmt(this.newDBConn, CollectingEventAttribute.getClassTableId());
            stmtCEA = this.newDBConn.createStatement();
            String selectCECSQL = DuplicateCollectingEvents.createSelectStmt(Collector.getClassTableId(), "CollectingEventID = %d");
            prepCECStmt = DuplicateCollectingEvents.createPreparedStmt(this.newDBConn, Collector.getClassTableId());
            stmtCEC = this.newDBConn.createStatement();
            log.debug((Object)selectCESQL);
            log.debug((Object)selectCEASQL);
            log.debug((Object)selectCECSQL);
            int totalCnt = this.getCollectingEventsWithManyCollectionObjectsCount();
            log.debug((Object)String.format("%d CEs with more than one CO for all Collections", totalCnt));
            if (this.progressFrame != null) {
                this.progressFrame.setProcess(0, totalCnt);
            }
            Vector<Integer> list = this.getCollectingEventsWithManyCollectionObjects(this.oldDBConn);
            int cnt = 0;
            int percent = 0;
            for (Integer ceID : list) {
                Integer newCEID = ceMapper.get(ceID);
                if (newCEID != null) {
                    int p = (int)((double)(cnt += this.duplicateCollectingEvent(newCEID, String.format(selectCESQL, newCEID), stmtCE, (PreparedStatement)prepCEStmt, selectCEASQL, stmtCEA, (PreparedStatement)prepCEAStmt, selectCECSQL, stmtCEC, (PreparedStatement)prepCECStmt)) * 100.0 / (double)totalCnt);
                    if (p == percent) continue;
                    if (this.progressFrame != null) {
                        this.progressFrame.setProcess(cnt);
                    }
                    percent = p;
                    continue;
                }
                log.error((Object)("Unable to map old CEId [" + ceID + "] to new CE Id."));
            }
            if (cnt != totalCnt) {
                log.debug((Object)String.format("%d processed doesn't match %d", cnt, totalCnt));
            }
            if (this.progressFrame != null) {
                this.progressFrame.setProcess(cnt);
            }
            int n = cnt;
            return n;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (prepCEStmt != null) {
                    prepCEStmt.close();
                }
                if (stmtCE != null) {
                    stmtCE.close();
                }
                if (prepCEAStmt != null) {
                    prepCEAStmt.close();
                }
                if (stmtCEA != null) {
                    stmtCEA.close();
                }
                if (prepCECStmt != null) {
                    prepCECStmt.close();
                }
                if (stmtCEC != null) {
                    stmtCE.close();
                }
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    private int getColumnIndex(ResultSetMetaData rsmd, String columnName) throws SQLException {
        int i = 1;
        while (i <= rsmd.getColumnCount()) {
            if (rsmd.getColumnName(i).equals(columnName)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected int duplicateCollectingEvent(int ceID, String selectCEStr, Statement stmtCE, PreparedStatement prepCEStmt, String selectCEAStr, Statement stmtCEA, PreparedStatement prepCEAStmt, String selectCECStr, Statement stmtCEC, PreparedStatement prepCECStmt) throws SQLException {
        boolean doCollectors = true;
        int dispId = BasicSQLUtils.getCountAsInt("SELECT DisciplineID FROM collectingevent WHERE CollectingEventID = " + ceID);
        int divId = BasicSQLUtils.getCountAsInt("SELECT DivisionID FROM discipline WHERE DisciplineID = " + dispId);
        Statement stmt2 = null;
        ResultSet coRS = null;
        ResultSet rs = null;
        ResultSet ceaRS = null;
        try {
            stmt2 = this.newDBConn.createStatement();
            int cnt = 0;
            rs = stmtCE.executeQuery(selectCEStr);
            ResultSetMetaData rsmd = rs.getMetaData();
            int dispInx = this.getColumnIndex(rsmd, "DisciplineID");
            int ceaInx = this.getColumnIndex(rsmd, "CollectingEventAttributeID");
            Integer newCEID = null;
            while (rs.next()) {
                Integer ceaId = rs.getObject(ceaInx) != null ? Integer.valueOf(rs.getInt(ceaInx)) : null;
                String sql = "SELECT CollectionObjectID FROM collectionobject WHERE CollectingEventID = " + ceID;
                coRS = stmt2.executeQuery(sql);
                if (coRS.next()) {
                    while (coRS.next()) {
                        int coId = coRS.getInt(1);
                        int i = 1;
                        while (i <= rs.getMetaData().getColumnCount()) {
                            prepCEStmt.setObject(i, rs.getObject(i));
                            ++i;
                        }
                        prepCEStmt.setInt(dispInx, dispId);
                        if (prepCEStmt.executeUpdate() != 1) {
                            throw new RuntimeException("Couldn't insert CE row.");
                        }
                        newCEID = BasicSQLUtils.getInsertedId(prepCEStmt);
                        ++cnt;
                        sql = String.format("UPDATE collectionobject SET CollectingEventID=%d WHERE CollectionObjectID = %d", newCEID, coId);
                        if (BasicSQLUtils.update(sql) != 1) {
                            throw new RuntimeException(String.valueOf(sql) + " didn't update CO correctly.");
                        }
                        if (ceaId != null) {
                            ceaRS = stmtCEA.executeQuery(String.format(selectCEAStr, ceaId));
                            int dispCEAInx = this.getColumnIndex(ceaRS.getMetaData(), "DisciplineID");
                            if (ceaRS.next()) {
                                int i2 = 1;
                                while (i2 <= ceaRS.getMetaData().getColumnCount()) {
                                    prepCEAStmt.setObject(i2, ceaRS.getObject(i2));
                                    ++i2;
                                }
                                prepCEAStmt.setInt(dispCEAInx, dispId);
                                prepCEAStmt.setInt(dispCEAInx, dispId);
                                if (prepCEAStmt.executeUpdate() != 1) {
                                    throw new RuntimeException("Couldn't insert CEA row.");
                                }
                                int newCEAID = BasicSQLUtils.getInsertedId(prepCEAStmt);
                                sql = String.format("UPDATE collectingevent SET CollectingEventAttributeID=%d WHERE CollectingEventID = %d", newCEAID, newCEID);
                                if (BasicSQLUtils.update(sql) != 1) {
                                    String msg = "[" + sql + "] didn't update CE correctly.";
                                    log.error((Object)("************************ " + msg));
                                }
                            }
                            ceaRS.close();
                            ceaRS = null;
                        }
                        if (!doCollectors) continue;
                        sql = String.format(selectCECStr, ceID);
                        ResultSet rsCEC = stmtCEC.executeQuery(sql);
                        while (rsCEC.next()) {
                            int divCECInx = this.getColumnIndex(rsCEC.getMetaData(), "DivisionID");
                            int newCEIDInx = this.getColumnIndex(rsCEC.getMetaData(), "CollectingEventID");
                            int i3 = 1;
                            while (i3 <= rsCEC.getMetaData().getColumnCount()) {
                                prepCECStmt.setObject(i3, rsCEC.getObject(i3));
                                ++i3;
                            }
                            prepCECStmt.setInt(divCECInx, divId);
                            prepCECStmt.setInt(newCEIDInx, newCEID);
                            if (prepCECStmt.executeUpdate() == 1) continue;
                            throw new RuntimeException("Couldn't insert CECollector row.");
                        }
                    }
                }
                coRS.close();
                coRS = null;
            }
            rs.close();
            rs = null;
            int n = cnt;
            return n;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            log.error((Object)ex);
        }
        finally {
            try {
                if (coRS != null) {
                    coRS.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return 0;
    }

    public void removeUnneededCEs() {
        log.debug((Object)"Deleting extra CollectingEvents.");
        try {
            PreparedStatement pStmt = this.newDBConn.prepareStatement("DELETE FROM collectingevent WHERE CollectingEventID = ?");
            String sql = "SELECT ce.CollectingEventID FROM collectingevent ce LEFT JOIN collectionobject co ON ce.CollectingEventID = co.CollectingEventID WHERE co.CollectionObjectID IS NULL";
            log.debug((Object)sql);
            Vector<Integer> ids = BasicSQLUtils.queryForInts(this.newDBConn, sql);
            int cnt = 0;
            int rmCnt = 0;
            for (Integer id : ids) {
                pStmt.setInt(1, id);
                int rv = pStmt.executeUpdate();
                if (rv == 1) {
                    ++rmCnt;
                } else {
                    log.error((Object)("Couldn't remove CE Id: " + id));
                }
                if (++cnt % 1000 != 0) continue;
                log.debug((Object)String.format("%d / %d", cnt, ids.size()));
            }
            pStmt.close();
            log.debug((Object)String.format("Done deleting CollectingEvents. %d removed out of %d", rmCnt, cnt));
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private boolean compareStr(String oldStr, String newStr) {
        if (oldStr == null && newStr == null) {
            return true;
        }
        if (oldStr == null || newStr == null) {
            return false;
        }
        return oldStr.equals(newStr);
    }

    public void fixCollectorsForCollectingEvents2() {
        IdTableMapper agentMapper = IdMapperMgr.getInstance().addTableMapper("agent", "AgentID", false);
        IdTableMapper colMapper = IdMapperMgr.getInstance().addTableMapper("collectors", "CollectorsID", false);
        IdTableMapper ceMapper = IdMapperMgr.getInstance().addTableMapper("collectingevent", "CollectingEventID", false);
        IdTableMapper coMapper = IdMapperMgr.getInstance().addTableMapper("collectionobjectcatalog", "CollectionObjectCatalogID", false);
        Statement prepCEStmt = null;
        Statement stmtCE = null;
        try {
            try {
                String selectCECSQL = DuplicateCollectingEvents.createSelectStmt(Collector.getClassTableId(), "CollectingEventID = %d");
                PreparedStatement prepCECStmt = DuplicateCollectingEvents.createPreparedStmt(this.newDBConn, Collector.getClassTableId());
                Statement stmtCEC = this.newDBConn.createStatement();
                PreparedStatement pStmt = this.newDBConn.prepareStatement("UPDATE agent SET LastName=?,FirstName=?,Initials=? WHERE AgentID=?");
                int totalCnt = this.getCollectingEventsWithManyCollectionObjectsCount();
                log.debug((Object)String.format("%d CEs with more than one CO for all Collections", totalCnt));
                String oSQL = "SELECT CollectingEventID FROM collectingevent ORDER BY CollectingEventID ASC";
                Statement oStmt = this.oldDBConn.createStatement(1004, 1007);
                Statement stmtOld = this.oldDBConn.createStatement(1004, 1007);
                Statement stmtNew = this.newDBConn.createStatement(1004, 1007);
                HashMap<Integer, Integer> fixedAgentIdsHash = new HashMap<Integer, Integer>();
                int cnt = 0;
                int okCnt = 0;
                int fixCnt = 0;
                ResultSet rs = oStmt.executeQuery(oSQL);
                while (rs.next()) {
                    int oldCEID = rs.getInt(1);
                    int newCEID = ceMapper.get(oldCEID);
                    String newSQL = "SELECT ce.CollectingEventID, c.CollectorID, a.AgentID, a.LastName, a.FirstName, a.Initials FROM collectingevent AS ce LEFT Join collector AS c ON ce.CollectingEventID = c.CollectingEventID LEFT Join agent AS a ON c.AgentID = a.AgentID WHERE ce.CollectingEventID = " + newCEID + " ORDER BY OrderNumber";
                    String oldSQL = "SELECT ce.CollectingEventID, c.CollectorsID, a.AgentID, IF(a.Name IS NULL, LastName, Name), a.FirstName, a.MiddleInitial FROM collectingevent AS ce INNER Join collectors AS c ON ce.CollectingEventID = c.CollectingEventID INNER Join agent AS a ON c.AgentID = a.AgentID WHERE ce.CollectingEventID = " + oldCEID + " ORDER BY `Order`";
                    if (oldCEID == -2132584997) {
                        System.out.println("\n" + oldSQL);
                        System.out.println(newSQL);
                    }
                    ResultSet rsOld = stmtOld.executeQuery(oldSQL);
                    ResultSet rsNew = stmtNew.executeQuery(newSQL);
                    boolean oldOK = rsOld.next();
                    boolean newOK = rsNew.next();
                    if (oldOK && newOK) {
                        Integer newCollectorID = rsNew.getObject(2) != null ? Integer.valueOf(rsNew.getInt(2)) : null;
                        Integer oldCollectorID = rsOld.getObject(2) != null ? Integer.valueOf(rsOld.getInt(2)) : null;
                        Integer newAgentId = rsNew.getObject(3) != null ? Integer.valueOf(rsNew.getInt(3)) : null;
                        Integer oldAgentId = rsOld.getObject(3) != null ? Integer.valueOf(rsOld.getInt(3)) : null;
                        String oldLast = rsOld.getString(4);
                        String oldFirst = rsOld.getString(5);
                        String oldMid = rsOld.getString(6);
                        String newLast = rsNew.getString(4);
                        String newFirst = rsNew.getString(5);
                        String newMid = rsNew.getString(6);
                        if (!(this.compareStr(oldLast, newLast) && this.compareStr(oldFirst, newFirst) && this.compareStr(oldMid, newMid))) {
                            Integer hits = (Integer)fixedAgentIdsHash.get(newAgentId);
                            if (hits == null) {
                                fixedAgentIdsHash.put(newAgentId, 1);
                                pStmt.setString(1, oldLast);
                                pStmt.setString(2, oldFirst);
                                pStmt.setString(3, oldMid);
                                pStmt.setInt(4, newAgentId);
                                pStmt.executeUpdate();
                                continue;
                            }
                            log.error((Object)("Agent Id " + newAgentId + " has already been fixed."));
                            continue;
                        }
                        if (newCollectorID == null || newAgentId == null) {
                            Integer mappedAgentID = agentMapper.get(oldAgentId);
                            Integer mappedColID = colMapper.get(oldCollectorID);
                            if (mappedColID != null && !mappedColID.equals(newCollectorID)) {
                                log.error((Object)String.format("Old Collector ID %d doesn't map to New Id %d - it was mapped to %d", oldCollectorID, newCollectorID, mappedColID));
                                continue;
                            }
                            if (mappedAgentID != null && !mappedAgentID.equals(newAgentId)) {
                                log.error((Object)String.format("Old Agent ID %d doesn't map to New Id %d - it was mapped to %d", oldAgentId, newAgentId, mappedColID));
                                continue;
                            }
                            int dispId = BasicSQLUtils.getCountAsInt("SELECT DisciplineID FROM collectingevent WHERE CollectingEventID = " + rsNew.getObject(1));
                            int divId = BasicSQLUtils.getCountAsInt("SELECT DivisionID FROM discipline WHERE DisciplineID = " + dispId);
                            String sql = String.format(selectCECSQL, oldCEID);
                            ResultSet rsCEC = stmtCEC.executeQuery(sql);
                            while (rsCEC.next()) {
                                int divCECInx = this.getColumnIndex(rsCEC.getMetaData(), "DivisionID");
                                int ceIDInx = this.getColumnIndex(rsCEC.getMetaData(), "CollectingEventID");
                                int agtInx = this.getColumnIndex(rsCEC.getMetaData(), "AgentID");
                                int i = 1;
                                while (i <= rsCEC.getMetaData().getColumnCount()) {
                                    if (i == agtInx) {
                                        Integer newAgtID = agentMapper.get(rsCEC.getInt(i));
                                        if (newAgtID != null) {
                                            prepCECStmt.setObject(i, newAgtID);
                                        } else {
                                            System.err.println(String.format("Error couldn't find old Agent Id[" + rsCEC.getInt(i) + "] in the agent mapper. For %d / %d", oldCEID, rsOld.getInt(2)));
                                            prepCECStmt.setObject(i, null);
                                        }
                                    } else {
                                        prepCECStmt.setObject(i, rsCEC.getObject(i));
                                    }
                                    ++i;
                                }
                                prepCECStmt.setInt(divCECInx, divId);
                                prepCECStmt.setInt(ceIDInx, newCEID);
                                if (prepCECStmt.executeUpdate() != 1) {
                                    throw new RuntimeException("Couldn't insert CE Collector row.");
                                }
                                ++fixCnt;
                            }
                        } else {
                            ++okCnt;
                        }
                    }
                    rsOld.close();
                    if (++cnt % 1000 != 0) continue;
                    System.out.println(String.valueOf(cnt) + " - " + oldCEID + " " + newCEID);
                }
                rs.close();
                log.debug((Object)("okCnt: " + okCnt + "  fixCnt: " + fixCnt + "  cnt: " + cnt));
                oStmt.close();
                stmtOld.close();
                stmtNew.close();
                pStmt.close();
                for (Integer id : fixedAgentIdsHash.keySet()) {
                    System.out.println("Id: " + id + " - " + fixedAgentIdsHash.get(id));
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                try {
                    if (prepCEStmt != null) {
                        prepCEStmt.close();
                    }
                    if (stmtCE != null) {
                        stmtCE.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (prepCEStmt != null) {
                    prepCEStmt.close();
                }
                if (stmtCE != null) {
                    stmtCE.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void fixCollectorsForCollectingEvents() {
        IdTableMapper ceMapper = IdMapperMgr.getInstance().addTableMapper("collectingevent", "CollectingEventID", false);
        IdTableMapper coMapper = IdMapperMgr.getInstance().addTableMapper("collectionobjectcatalog", "CollectionObjectCatalogID", false);
        Statement prepCEStmt = null;
        Statement stmtCE = null;
        try {
            try {
                Statement stmt = this.oldDBConn.createStatement();
                PreparedStatement pStmt = this.newDBConn.prepareStatement("UPDATE collectionobject SET CollectingEventID=? WHERE CollectionObjectID=?");
                String postfix = " FROM collectionobject co INNER JOIN collectionobjectcatalog cc ON co.CollectionObjectID = cc.CollectionObjectCatalogID WHERE co.CollectionObjectTypeID > 8 && co.CollectionObjectTypeID < 20  AND cc.SubNumber >= 0 ORDER BY co.CollectionObjectID";
                String sql = "SELECT co.CollectionObjectID, co.CollectingEventID" + postfix;
                log.debug((Object)sql);
                int totCnt = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*)" + postfix);
                Integer lastCEId = null;
                ceMapper.setShowLogErrors(false);
                int cnt = 0;
                int coCnt = 0;
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    int oldCOId = rs.getInt(1);
                    int oldCEId = rs.getInt(2);
                    Integer newCOId = coMapper.get(oldCOId);
                    Integer newCEId = ceMapper.get(oldCEId);
                    if (newCOId != null) {
                        if (newCEId != null) {
                            pStmt.setInt(1, newCEId);
                        } else {
                            pStmt.setObject(1, null);
                        }
                        try {
                            pStmt.setInt(2, newCOId);
                            if (pStmt.executeUpdate() != 1) {
                                throw new RuntimeException(String.format("Couldn't update CO with correct CEId; oldCOId: %d   newCOId: %d   oldCEId: %d  newCEId: %d", oldCOId, newCOId, oldCEId, newCEId != null ? newCEId : -1));
                            }
                        }
                        catch (SQLException ex) {
                            log.error((Object)ex.toString());
                            log.error((Object)String.format("oldCOId: %d   newCOId: %d   oldCEId: %d  newCEId: %d", oldCOId, newCOId, oldCEId, newCEId != null ? newCEId : -1));
                        }
                        lastCEId = newCEId;
                        ++coCnt;
                    } else {
                        log.error((Object)String.format("Error oldCOId: %d is mapped to null", oldCOId));
                    }
                    if (++cnt % 1000 != 0) continue;
                    System.out.println(String.valueOf(cnt) + " / " + totCnt);
                }
                rs.close();
                pStmt.close();
                log.debug((Object)(String.valueOf(cnt) + " / " + totCnt));
                log.debug((Object)("The last new CE Changed was " + lastCEId));
                log.debug((Object)String.format("%d COs were updated out of %d", coCnt, cnt));
                int lastCEAttrID = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT NewID FROM habitat_HabitatID ORDER BY NewID DESC LIMIT 0,1");
                sql = "SELECT COUNT(*) FROM collectionobject WHERE TimestampCreated < '2010-01-01'";
                log.debug((Object)sql);
                int badCnt = BasicSQLUtils.getCountAsInt(sql);
                log.debug((Object)String.format("COs with CE Id %d and there shouldn't be any.", badCnt));
                int c = 0;
                for (Integer id : BasicSQLUtils.queryForInts("SELECT CollectingEventID FROM collectionobject WHERE CollectingEventID > " + lastCEId)) {
                    System.out.print(id);
                    System.out.print(',');
                    if (++c <= 20) continue;
                    System.out.println();
                }
                System.out.println();
                sql = "UPDATE collectionobject SET CollectingEventID=NULL WHERE CollectingEventID > " + lastCEId;
                log.debug((Object)sql);
                int fixCOCnt = BasicSQLUtils.update(sql);
                log.debug((Object)String.format("Set %d CO->CEID to NULL.", fixCOCnt));
                int lastCollectorID = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT NewID FROM collectors_CollectorsID ORDER BY NewID DESC LIMIT 0,1");
                sql = "DELETE FROM collector WHERE CollectorID > " + lastCollectorID;
                log.debug((Object)sql);
                int updateColCnt = BasicSQLUtils.update(sql);
                log.debug((Object)String.format("Deleted %d extra Collectors", updateColCnt));
                sql = "DELETE FROM collectingevent WHERE CollectingEventID > " + lastCEId;
                log.debug((Object)sql);
                int updateCECnt = BasicSQLUtils.update(sql);
                log.debug((Object)String.format("Deleted %d extra CollectingEvents", updateCECnt));
                sql = "DELETE FROM collectingeventattribute WHERE CollectingEventAttributeID > " + lastCEAttrID;
                log.debug((Object)sql);
                int updateCEACnt = BasicSQLUtils.update(sql);
                log.debug((Object)String.format("Deleted %d extra CollectingEventAttributes", updateCEACnt));
                int totalCnt = this.getCollectingEventsWithManyCollectionObjectsCount();
                log.debug((Object)String.format("%d CEs with more than one CO for all Collections", totalCnt));
                this.performMaint(false);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                try {
                    if (prepCEStmt != null) {
                        prepCEStmt.close();
                    }
                    if (stmtCE != null) {
                        stmtCE.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (prepCEStmt != null) {
                    prepCEStmt.close();
                }
                if (stmtCE != null) {
                    stmtCE.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void showStats(boolean isStart) {
        String noCOSQL = " FROM collectingevent ce LEFT JOIN collectionobject co ON ce.CollectingEventID = co.CollectingEventID WHERE co.CollectionObjectID IS NULL";
        int totalWithCOs = BasicSQLUtils.getCountAsInt(this.newDBConn, "SELECT COUNT(ce.CollectingEventID) FROM collectingevent ce INNER JOIN collectionobject co ON ce.CollectingEventID = co.CollectingEventID");
        int totalCEWithoutCO = BasicSQLUtils.getCountAsInt(this.newDBConn, "SELECT COUNT(ce.CollectingEventID)" + noCOSQL);
        int totalCE = BasicSQLUtils.getCountAsInt(this.newDBConn, "SELECT COUNT(*) FROM collectingevent");
        int totalCO = BasicSQLUtils.getCountAsInt(this.newDBConn, "SELECT COUNT(*) FROM collectionobject");
        int coWithoutCE = BasicSQLUtils.getCountAsInt(this.newDBConn, "SELECT COUNT(*) FROM collectionobject WHERE CollectingEventID is NULL");
        String msg = "<HTML><table border=\"1\"><tr><td >Total CO w/o CE</td><td>" + coWithoutCE + "</td></tr>" + "<tr><td>Total CE w/  CO</td><td>" + totalWithCOs + "</td></tr>" + "<tr><td>Total CE w/o CO</td><td>" + totalCEWithoutCO + "</td></tr>" + "<tr><td>Dif          </td><td>" + (totalCEWithoutCO - totalWithCOs) + "</td></tr>" + "<tr><td>Total CE     </td><td>" + totalCE + "</td></tr>" + "<tr><td>Total CO     </td><td>" + totalCO + "</td></tr>" + "<tr><td>Dif          </td><td>" + (totalCE - totalCO) + "</td></tr>" + "</table>";
        Vector<Object> list = BasicSQLUtils.querySingleCol(this.newDBConn, "SELECT ce.CollectingEventID " + noCOSQL);
        if (isStart) {
            int i = 0;
            for (Object obj : list) {
                Integer id = (Integer)obj;
                this.cesNoCOList.add(id);
                System.out.print(id + ", ");
                if (++i % 10 != 0) continue;
                System.out.println("");
            }
            System.out.println("");
        } else {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (Integer id : this.cesNoCOList) {
                hashSet.add(id);
            }
            Vector<Integer> diffList = new Vector<Integer>();
            for (Object obj : list) {
                Integer n = (Integer)obj;
                if (hashSet.contains(n)) continue;
                diffList.add(n);
            }
            System.out.println("-------- CE with no COs -------- ");
            int i = 0;
            for (Object id : diffList) {
                System.out.print(id + ", ");
                if (++i % 10 != 0) continue;
                System.out.println();
            }
            System.out.println("");
            hashSet.clear();
            Hashtable<Integer, Boolean> hash = new Hashtable<Integer, Boolean>();
            for (Object object : list) {
                hash.put((Integer)object, Boolean.TRUE);
            }
            diffList.clear();
            for (Integer n : this.cesNoCOList) {
                if (hash.get(n) != null) continue;
                diffList.add(n);
            }
            System.out.println("=========== CE with no COs =========== ");
            for (Integer n : diffList) {
                System.out.print(n + ", ");
                if (++i % 10 != 0) continue;
                System.out.println();
            }
            System.out.println("");
        }
        log.info((Object)msg);
        JPanel panel = new JPanel(new BorderLayout());
        JLabel lbl = UIHelper.createLabel(msg);
        panel.add((Component)lbl, "Center");
        CustomFrame statsFrame = new CustomFrame(String.valueOf(isStart ? "Before" : "After") + " Duplication", 1, panel);
        statsFrame.pack();
        statsFrame.setVisible(true);
    }

    public void performMaint(boolean doAddCEMapper) {
        int count;
        if (doAddCEMapper) {
            IdMapperMgr.getInstance().addTableMapper("collectingevent", "CollectingEventID", false);
        }
        if ((count = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM collection WHERE IsEmbeddedCollectingEvent <> 0")) == 0) {
            return;
        }
        if (this.progressFrame != null) {
            this.progressFrame.setDesc("Fixing Collecting Events...");
        }
        count = this.duplicateCollectingEvents();
        this.addCEsForCOWithNone();
        log.debug((Object)("*** Total for Collections: " + count));
    }

    private void addCEsForCOWithNone() {
        try {
            String sql = "INSERT INTO collectingevent (TimestampCreated, TimestampModified, Version, CreatedByAgentID, ModifiedByAgentID, DisciplineID) VALUES(?,?,?,?,?,?)";
            PreparedStatement pStmt = this.newDBConn.prepareStatement(sql);
            Calendar now = Calendar.getInstance();
            for (Object idObj : BasicSQLUtils.querySingleCol(this.newDBConn, "SELECT CollectionObjectID FROM collectionobject WHERE CollectingEventID is NULL")) {
                Integer coID = (Integer)idObj;
                pStmt.setTimestamp(1, new Timestamp(now.getTime().getTime()));
                pStmt.setTimestamp(2, new Timestamp(now.getTime().getTime()));
                pStmt.setInt(3, 0);
                pStmt.setInt(4, this.createdByAgentId);
                pStmt.setInt(5, this.createdByAgentId);
                pStmt.setInt(6, this.disciplineId);
                try {
                    if (pStmt.executeUpdate() != 1) {
                        throw new RuntimeException(String.valueOf(sql) + " didn't update correctly.");
                    }
                }
                catch (SQLException ex) {
                    log.debug((Object)ex.toString());
                    log.error((Object)String.format("%d %d %d", coID, this.createdByAgentId, this.disciplineId));
                    continue;
                }
                int newCEID = BasicSQLUtils.getInsertedId(pStmt);
                sql = String.format("UPDATE collectionobject SET CollectingEventID=%d WHERE CollectionObjectID = %d", newCEID, coID);
                if (BasicSQLUtils.update(sql) == 1) continue;
                throw new RuntimeException(String.valueOf(sql) + " didn't update correctly.");
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public static PreparedStatement createPreparedStmt(Connection conn, int tableID) throws SQLException {
        DBTableInfo tblInfo = DBTableIdMgr.getInstance().getInfoById(tableID);
        StringBuilder sb = new StringBuilder("INSERT INTO " + tblInfo.getName() + " (");
        int fldCnt = 0;
        String keyName = tblInfo.getIdFieldName();
        for (DBFieldInfo fi : tblInfo.getFields()) {
            if (fi.getColumn().equals(keyName)) continue;
            sb.append(fi.getColumn());
            sb.append(',');
            ++fldCnt;
        }
        for (DBRelationshipInfo ri : tblInfo.getRelationships()) {
            if (ri.getType() != DBRelationshipInfo.RelationshipType.ManyToOne) continue;
            sb.append(ri.getColName());
            sb.append(',');
            ++fldCnt;
        }
        sb.setLength(sb.length() - 1);
        sb.append(") VALUES(");
        int i = 0;
        while (i < fldCnt) {
            sb.append("?,");
            ++i;
        }
        sb.setLength(sb.length() - 1);
        sb.append(")");
        log.debug((Object)sb.toString());
        return conn.prepareStatement(sb.toString());
    }

    public static String createSelectStmt(int tableID, String whereClauseStr) {
        DBTableInfo tblInfo = DBTableIdMgr.getInstance().getInfoById(tableID);
        StringBuilder sb = new StringBuilder("SELECT ");
        for (DBFieldInfo fi : tblInfo.getFields()) {
            sb.append(fi.getColumn());
            sb.append(',');
        }
        for (DBRelationshipInfo ri : tblInfo.getRelationships()) {
            if (ri.getType() != DBRelationshipInfo.RelationshipType.ManyToOne) continue;
            sb.append(ri.getColName());
            sb.append(',');
        }
        sb.setLength(sb.length() - 1);
        sb.append(" FROM ");
        sb.append(tblInfo.getName());
        if (StringUtils.isNotEmpty((String)whereClauseStr)) {
            sb.append(" WHERE ");
            sb.append(whereClauseStr);
        }
        log.debug((Object)sb.toString());
        return sb.toString();
    }
}

