/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.GenericDBConversion;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import edu.ku.brc.specify.conversion.IdTableMapper;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.GeographyTreeDef;
import edu.ku.brc.specify.utilapps.BuildSampleDatabase;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIRegistry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DisciplineDuplicator {
    protected static final Logger log = Logger.getLogger(DisciplineDuplicator.class);
    protected Connection oldDBConn;
    protected Connection newDBConn;
    protected TableWriter tblWriter;
    protected ProgressFrame prgFrame;
    protected GenericDBConversion conversion;
    protected IdTableMapper origGeoIdMapper = null;
    protected boolean debug = true;

    public DisciplineDuplicator(Connection oldDBConn, Connection newDBConn, TableWriter tblWriter, ProgressFrame prgFrame, GenericDBConversion conversion) {
        this.oldDBConn = oldDBConn;
        this.newDBConn = newDBConn;
        this.tblWriter = tblWriter;
        this.prgFrame = prgFrame;
        this.conversion = conversion;
    }

    public void doShowFieldsForDiscipline() {
        DataProviderSessionIFace session = null;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                for (Discipline discipline : session.createQuery("FROM Discipline", false).list()) {
                    BuildSampleDatabase.makeFieldVisible(null, discipline);
                    BuildSampleDatabase.makeFieldVisible(discipline.getType(), discipline);
                }
            }
            catch (Exception ex) {
                log.error((Object)"Error while  show fields in Discipline.");
                ex.printStackTrace();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static List<String> getColumnNames(Connection conn, String catalog, String tableName, boolean skipFirst) {
        Vector<String> list;
        block13: {
            list = new Vector<String>();
            Statement stmt = null;
            try {
                try {
                    stmt = conn.createStatement();
                    String sql = String.format("SELECT COLUMN_NAME FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s'", catalog, tableName);
                    ResultSet rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        list.add(rs.getString(1));
                    }
                    rs.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (skipFirst) {
            list.remove(0);
        }
        return list;
    }

    public static String getFieldNameList(Connection conn, String tblName) throws SQLException {
        StringBuilder fieldNames = new StringBuilder();
        int cnt = 0;
        for (String colName : DisciplineDuplicator.getColumnNames(conn, conn.getCatalog(), tblName, true)) {
            if (cnt > 0) {
                fieldNames.append(',');
            }
            fieldNames.append(colName);
            ++cnt;
        }
        return fieldNames.toString();
    }

    public void duplicateCollectingEvents() {
        Statement stmt = null;
        Statement stmt2 = null;
        Statement stmt3 = null;
        Statement uStmt = null;
        int changeCOCnt = 0;
        int changeCECnt = 0;
        int insertCECnt = 0;
        int insertCEACnt = 0;
        try {
            try {
                PreparedStatement pStmt = this.newDBConn.prepareStatement("UPDATE collectingevent SET DisciplineID=? WHERE CollectingEventID=?");
                PreparedStatement pStmt2 = this.newDBConn.prepareStatement("UPDATE collectionobject SET CollectingEventID=? WHERE CollectionObjectID=?");
                PreparedStatement pCECEA = this.newDBConn.prepareStatement("UPDATE collectingevent SET CollectingEventAttributeID=? WHERE CollectingEventID=?");
                stmt = this.newDBConn.createStatement(1004, 1007);
                stmt2 = this.newDBConn.createStatement(1004, 1007);
                stmt3 = this.newDBConn.createStatement(1004, 1007);
                uStmt = this.newDBConn.createStatement();
                stmt.setFetchSize(Integer.MIN_VALUE);
                stmt2.setFetchSize(Integer.MIN_VALUE);
                stmt3.setFetchSize(Integer.MIN_VALUE);
                uStmt.setFetchSize(Integer.MIN_VALUE);
                String ceFldNames = DisciplineDuplicator.getFieldNameList(this.newDBConn, "collectingevent");
                String ceaFldNames = DisciplineDuplicator.getFieldNameList(this.newDBConn, "collectingeventattribute");
                String sql = " FROM collectionobject Inner Join collection ON collectionobject.CollectionID = collection.UserGroupScopeId Inner Join collectingevent ON collectionobject.CollectingEventID = collectingevent.CollectingEventID WHERE collection.DisciplineID <> collectingevent.DisciplineID";
                int total = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) " + sql);
                if (this.prgFrame != null) {
                    this.prgFrame.setProcess(0, total);
                }
                String selectPrefix = "SELECT DISTINCT collectingevent.CollectingEventID  ";
                log.debug((Object)(String.valueOf(selectPrefix) + sql));
                int cnt = 0;
                ResultSet rs = stmt.executeQuery(String.valueOf(selectPrefix) + sql);
                while (rs.next()) {
                    int ceID = rs.getInt(1);
                    boolean debug = false;
                    String sqlStr = String.format("SELECT collectingevent.DisciplineID, collection.DisciplineID, collectionobject.CollectionID, collectingevent.CollectingEventAttributeID" + sql + " AND collectingevent.CollectingEventID = %d", ceID);
                    if (debug) {
                        log.debug((Object)sqlStr);
                    }
                    int ceCnt = 0;
                    ResultSet rs2 = stmt2.executeQuery(sqlStr);
                    while (rs2.next()) {
                        Integer ceAttrID;
                        int ceDspID = rs2.getInt(1);
                        int colDspID = rs2.getInt(2);
                        int colMemID = rs2.getInt(3);
                        Integer n = ceAttrID = rs2.getObject(4) != null ? Integer.valueOf(rs2.getInt(4)) : null;
                        if (debug) {
                            log.debug((Object)String.format("ceDspID %d,  colDspID %d,  colMemID %d,  ", ceDspID, colDspID, colMemID));
                        }
                        Integer newCEId = null;
                        if (ceCnt == 0) {
                            newCEId = ceID;
                            ++changeCOCnt;
                        } else {
                            String insertSQL = String.format("INSERT INTO collectingevent (%s) (SELECT %s FROM collectingevent WHERE CollectingEventID = %d)", ceFldNames.toString(), ceFldNames.toString(), ceID);
                            if (debug) {
                                log.debug((Object)insertSQL);
                            }
                            uStmt.executeUpdate(insertSQL);
                            newCEId = BasicSQLUtils.getInsertedId(uStmt);
                            ++insertCECnt;
                            this.tblWriter.log(String.format("Duplicated collectingevent Old %d to New %d", ceID, newCEId));
                            if (ceAttrID != null) {
                                int newCEAttrsId = this.dupRecord(uStmt, "collectingeventattribute", "CollectingEventAttributeID", ceaFldNames, ceAttrID, "CollectingEventID");
                                pCECEA.setInt(1, newCEAttrsId);
                                pCECEA.setInt(1, newCEId);
                                pCECEA.executeUpdate();
                                ++insertCEACnt;
                            }
                            sqlStr = String.format("SELECT CollectionObjectID FROM collectionobject WHERE  CollectingEventID = %d AND CollectionMemberID = %d", ceID, colMemID);
                            if (debug) {
                                log.debug((Object)sqlStr);
                            }
                            ResultSet rs3 = stmt3.executeQuery(sqlStr);
                            while (rs3.next()) {
                                int colObjId = rs3.getInt(1);
                                pStmt2.setInt(1, newCEId);
                                pStmt2.setInt(2, colObjId);
                                pStmt2.execute();
                                this.tblWriter.log(String.format("Updated ColObj Id: %d to new CE Id %d", colObjId, newCEId));
                                ++changeCOCnt;
                            }
                            rs3.close();
                        }
                        pStmt.setInt(1, colDspID);
                        pStmt.setInt(2, newCEId);
                        pStmt.execute();
                        ++changeCECnt;
                        if (debug) {
                            log.debug((Object)String.format("UPDATE collectingevent SET DisciplineID=%d WHERE CollectingEventID=%d", colDspID, newCEId));
                        }
                        ++ceCnt;
                    }
                    rs2.close();
                    if (++cnt % 500 != 0) continue;
                    log.debug((Object)("Processed: " + cnt));
                    if (this.prgFrame == null) continue;
                    this.prgFrame.setProcess(cnt);
                }
                log.debug((Object)("Processed: " + cnt));
                rs.close();
                pStmt.close();
                pStmt2.close();
                pCECEA.close();
                this.tblWriter.log(String.format("There were %d CollectingEvent records changed.", changeCECnt));
                this.tblWriter.log(String.format("There were %d CollectionObject records changed.", changeCOCnt));
                this.tblWriter.log(String.format("There were %d records CollectingEvent copied and inserted.", insertCECnt));
                this.tblWriter.log(String.format("There were %d records CollectingEvent copied and inserted.", insertCEACnt));
                this.tblWriter.log("<BR>");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    stmt.close();
                    stmt2.close();
                    stmt3.close();
                    uStmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                stmt.close();
                stmt2.close();
                stmt3.close();
                uStmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private int dupRecord(Statement uStmt, String tblName, String idName, String fieldNames, int oldId, String primaryKeyName) throws SQLException {
        String insertSQL = String.format("INSERT INTO %s (%s) (SELECT %s FROM %s WHERE %s = %d)", tblName, fieldNames, fieldNames, tblName, primaryKeyName, oldId);
        if (this.debug) {
            log.debug((Object)insertSQL);
        }
        uStmt.executeUpdate(insertSQL);
        int newId = BasicSQLUtils.getInsertedId(uStmt);
        this.tblWriter.log(String.format("Duplicated %s Old %d to New %d", tblName, oldId, newId));
        return newId;
    }

    public void duplicateLocalities() {
        Statement stmt = null;
        Statement stmt2 = null;
        Statement stmt3 = null;
        Statement uStmt = null;
        int changeCECnt = 0;
        int changeLCCnt = 0;
        int insertLocCnt = 0;
        int insertGCDCnt = 0;
        int insertLDCnt = 0;
        try {
            try {
                PreparedStatement pStmt = this.newDBConn.prepareStatement("UPDATE locality SET DisciplineID=? WHERE LocalityID=?");
                PreparedStatement pStmtCE = this.newDBConn.prepareStatement("UPDATE collectingevent SET LocalityID=? WHERE CollectingEventID=?");
                PreparedStatement pGCDLoc = this.newDBConn.prepareStatement("UPDATE geocoorddetail SET LocalityID=? WHERE GeoCoordDetailID=?");
                stmt = this.newDBConn.createStatement(1004, 1007);
                stmt2 = this.newDBConn.createStatement(1004, 1007);
                stmt3 = this.newDBConn.createStatement(1004, 1007);
                uStmt = this.newDBConn.createStatement();
                stmt.setFetchSize(Integer.MIN_VALUE);
                stmt2.setFetchSize(Integer.MIN_VALUE);
                stmt3.setFetchSize(Integer.MIN_VALUE);
                uStmt.setFetchSize(Integer.MIN_VALUE);
                int cnt = 0;
                String locFldNames = DisciplineDuplicator.getFieldNameList(this.newDBConn, "locality");
                String gcdFldNames = DisciplineDuplicator.getFieldNameList(this.newDBConn, "geocoorddetail");
                String ldFldNames = DisciplineDuplicator.getFieldNameList(this.newDBConn, "localitydetail");
                String fromSQL = " FROM locality l INNER JOIN collectingevent ce ON l.LocalityID = ce.LocalityID WHERE l.DisciplineID != ce.DisciplineID";
                int total = BasicSQLUtils.getCountAsInt("SELECT COUNT(*) " + fromSQL);
                System.out.println("Total: " + total);
                if (this.prgFrame != null) {
                    this.prgFrame.setProcess(0, total);
                }
                String sql = String.format("SELECT l.LocalityID %s GROUP BY l.LocalityID", fromSQL);
                log.debug((Object)sql);
                boolean debug = false;
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    int localityId = rs.getInt(1);
                    debug = localityId == 1116;
                    sql = String.format("SELECT COUNT(*) FROM (SELECT CEDSPID, COUNT(CEDSPID) FROM (SELECT l.LocalityID, l.DisciplineID as LOCDSPID, ce.CollectingEventID, ce.DisciplineID as CEDSPID FROM locality l INNER JOIN collectingevent ce ON l.LocalityID = ce.LocalityID WHERE l.DisciplineID != ce.DisciplineID AND l.LocalityID = %d) T1 GROUP BY CEDSPID) T2", localityId);
                    if (debug) {
                        log.debug((Object)sql);
                    }
                    if (BasicSQLUtils.getCountAsInt(sql) == 1) {
                        sql = String.format("SELECT ce.DisciplineID FROM locality l INNER JOIN collectingevent ce ON l.LocalityID = ce.LocalityID WHERE l.DisciplineID != ce.DisciplineID AND l.LocalityID = %d LIMIT 0,1", localityId);
                        int ceDiscipline = BasicSQLUtils.getCountAsInt(sql);
                        pStmt.setInt(1, ceDiscipline);
                        pStmt.setInt(2, localityId);
                        pStmt.execute();
                        ++changeLCCnt;
                    } else {
                        sql = String.format("SELECT CEDSPID, COUNT(CEDSPID) FROM (SELECT l.LocalityID, l.DisciplineID as LOCDSPID, ce.CollectingEventID, ce.DisciplineID as CEDSPID FROM locality l INNER JOIN collectingevent ce ON l.LocalityID = ce.LocalityID WHERE l.DisciplineID != ce.DisciplineID AND l.LocalityID = %d) T1 GROUP BY CEDSPID", localityId);
                        if (debug) {
                            log.debug((Object)sql);
                        }
                        int locCnt = 0;
                        ResultSet rs2 = stmt2.executeQuery(sql);
                        while (rs2.next()) {
                            if (locCnt == 0) {
                                pStmt.setInt(1, rs2.getInt(1));
                                pStmt.setInt(2, localityId);
                                pStmt.execute();
                                ++changeLCCnt;
                            } else {
                                int ceDspId = rs2.getInt(1);
                                sql = String.format("SELECT l.LocalityID, l.DisciplineID, ce.CollectingEventID FROM locality l INNER JOIN collectingevent ce ON l.LocalityID = ce.LocalityID WHERE l.DisciplineID != ce.DisciplineID AND l.LocalityID = %d AND ce.DisciplineID = %d ORDER BY ce.DisciplineID", localityId, ceDspId);
                                log.debug((Object)sql);
                                int ceLocCnt = 0;
                                Integer newLocID = null;
                                ResultSet rs3 = stmt3.executeQuery(sql);
                                while (rs3.next()) {
                                    int ceID = rs3.getInt(3);
                                    if (ceLocCnt == 0) {
                                        Integer ldId;
                                        sql = String.format("INSERT INTO locality (%s) (SELECT %s FROM locality WHERE LocalityID = %d)", locFldNames, locFldNames, localityId);
                                        uStmt.executeUpdate(sql);
                                        newLocID = BasicSQLUtils.getInsertedId(uStmt);
                                        log.debug((Object)("New Locality[" + newLocID + "] from Old Loc[" + localityId + "] for CE[" + ceID + "]"));
                                        pStmt.setInt(1, ceDspId);
                                        pStmt.setInt(2, newLocID);
                                        pStmt.execute();
                                        ++changeLCCnt;
                                        this.tblWriter.log(String.format("Duplicated Locality Old %d to New %d", localityId, newLocID));
                                        Integer gcdId = BasicSQLUtils.getCount("SELECT GeoCoordDetailID FROM geocoorddetail WHERE LocalityID = " + localityId);
                                        if (gcdId != null) {
                                            int newGCDId = this.dupRecord(uStmt, "geocoorddetail", "GeoCoordDetailID", gcdFldNames, gcdId, "CollectingEventID");
                                            pGCDLoc.setInt(1, newGCDId);
                                            pGCDLoc.setInt(1, newLocID);
                                            pGCDLoc.executeUpdate();
                                            ++insertGCDCnt;
                                        }
                                        if ((ldId = BasicSQLUtils.getCount("SELECT LocalityDetailID FROM localitydetail WHERE LocalityID = " + localityId)) != null) {
                                            int newLDId = this.dupRecord(uStmt, "localitydetail", "LocalityDetailID", ldFldNames, ldId, "LocalityID");
                                            pGCDLoc.setInt(1, newLDId);
                                            pGCDLoc.setInt(2, newLocID);
                                            pGCDLoc.executeUpdate();
                                            ++insertLDCnt;
                                        }
                                    }
                                    pStmtCE.setInt(1, newLocID);
                                    pStmtCE.setInt(2, ceID);
                                    pStmtCE.execute();
                                    ++changeCECnt;
                                    this.tblWriter.log(String.format("Updated collectingevent's %d  Locality ID: %d to new CE Id %d", ceID, localityId, newLocID));
                                    ++ceLocCnt;
                                }
                                rs3.close();
                            }
                            ++locCnt;
                        }
                        rs2.close();
                    }
                    if (++cnt % 500 != 0) continue;
                    log.debug((Object)("Processed: " + cnt));
                    if (this.prgFrame == null) continue;
                    this.prgFrame.setProcess(cnt);
                }
                log.debug((Object)("Done - Processed: " + cnt));
                rs.close();
                pStmt.close();
                pStmtCE.close();
                this.tblWriter.log(String.format("There were %d Locality records changed.", changeLCCnt));
                this.tblWriter.log(String.format("There were %d Locality records inserted.", insertLocCnt));
                this.tblWriter.log(String.format("There were %d Collecting Events records changed.", changeCECnt));
                this.tblWriter.log("<BR>");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    stmt.close();
                    stmt2.close();
                    stmt3.close();
                    uStmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                stmt.close();
                stmt2.close();
                stmt3.close();
                uStmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void duplicateGeography() {
        String sql = " SELECT collectionobjectcatalog.CollectionObjectTypeID, Count(collectionobjectcatalog.CollectionObjectTypeID), collectionobjecttype.CollectionObjectTypeName FROM collectionobjectcatalog Inner Join collectionobject ON collectionobjectcatalog.CollectionObjectCatalogID = collectionobject.CollectionObjectID Inner Join collectingevent ON collectionobject.CollectingEventID = collectingevent.CollectingEventID Inner Join locality ON collectingevent.LocalityID = locality.LocalityID Inner Join geography ON locality.GeographyID = geography.GeographyID Inner Join collectionobjecttype ON collectionobjectcatalog.CollectionObjectTypeID = collectionobjecttype.CollectionObjectTypeID  WHERE collectionobject.DerivedFromID IS NULL GROUP BY collectionobjectcatalog.CollectionObjectTypeID";
        this.tblWriter.startTable();
        this.tblWriter.logHdr("Discipline ID", "Number of ColObjs", "Discipline");
        for (Object[] row : BasicSQLUtils.query(this.oldDBConn, sql)) {
            this.tblWriter.logObjRow(row);
        }
        this.tblWriter.endTable();
        if (BasicSQLUtils.getCountAsInt("SELECT COUNT(*) FROM discipline") > 1) {
            try {
                this.newDBConn.setAutoCommit(false);
                Integer mainGeoDiscipline = null;
                sql = "SELECT DISTINCT d.UserGroupScopeId FROM discipline d Inner Join geographytreedef gtd ON d.GeographyTreeDefID = gtd.GeographyTreeDefID Inner Join geography g ON gtd.GeographyTreeDefID = g.GeographyTreeDefID";
                Vector<Integer> dispsInGeo = BasicSQLUtils.queryForInts(sql);
                if (dispsInGeo.size() == 0) {
                    UIRegistry.showError("There are no disciplines in the Geography tree and there should only be one.");
                    return;
                }
                try {
                    mainGeoDiscipline = dispsInGeo.get(0);
                    IdTableMapper geoIdMapper = (IdTableMapper)IdMapperMgr.getInstance().get("geography", "GeographyID");
                    if (this.origGeoIdMapper == null) {
                        this.origGeoIdMapper = new IdTableMapper("geography", "orig", false, false);
                        IdMapperMgr.getInstance().addMapper(this.origGeoIdMapper);
                        this.origGeoIdMapper.clearRecords();
                        geoIdMapper.copy(this.origGeoIdMapper);
                    }
                    geoIdMapper.clearRecords();
                    PreparedStatement pStmt = this.newDBConn.prepareStatement("UPDATE locality SET GeographyID=? WHERE LocalityID=?");
                    Statement stmt = this.newDBConn.createStatement();
                    int fixCnt = 0;
                    for (Object[] row : BasicSQLUtils.query("SELECT DisciplineID, Name FROM discipline ORDER BY DisciplineID")) {
                        Integer dspId = (Integer)row[0];
                        String dspName = (String)row[1];
                        this.tblWriter.log(String.format("Duplicating Geography for Disicpline '%s'", dspName));
                        this.tblWriter.log("<BR>");
                        if (mainGeoDiscipline.equals(dspId)) continue;
                        GeographyTreeDef geoTreeDef = this.conversion.createStandardGeographyDefinitionAndItems(false);
                        BasicSQLUtils.update(String.format("UPDATE discipline SET GeographyTreeDefID=%d WHERE DisciplineID = %d", geoTreeDef.getId(), dspId));
                        this.conversion.convertGeography(geoTreeDef, dspName, false);
                        ResultSet rs = stmt.executeQuery("SELECT LocalityID, GeographyID FROM locality WHERE DisciplineID = " + dspId);
                        while (rs.next()) {
                            int locId = rs.getInt(1);
                            int geoId = rs.getInt(2);
                            Integer oldId = this.origGeoIdMapper.reverseGet(geoId);
                            if (oldId != null) {
                                Integer newGeoId = geoIdMapper.get(oldId);
                                if (newGeoId != null) {
                                    pStmt.setInt(1, newGeoId);
                                    pStmt.setInt(2, locId);
                                    pStmt.execute();
                                } else {
                                    this.tblWriter.log(String.format("can't find new Geography Id for Old Id '%d'", oldId));
                                }
                            } else {
                                this.tblWriter.log(String.format("Reverse Look up of 'original mapper' New Geography Id %d didn't have an OldID", geoId));
                            }
                            ++fixCnt;
                        }
                        rs.close();
                        this.newDBConn.commit();
                    }
                    pStmt.close();
                    stmt.close();
                    this.tblWriter.log(String.format("There were %d Locality records changed.", fixCnt));
                    this.tblWriter.log("<BR>");
                    sql = " SELECT discipline.UserGroupScopeId, COUNT(discipline.UserGroupScopeId), discipline.Name FROM discipline Inner Join collection ON discipline.UserGroupScopeId = collection.DisciplineID Inner Join collectionobject ON collection.UserGroupScopeId = collectionobject.CollectionMemberID Inner Join collectingevent ON collectionobject.CollectingEventID = collectingevent.CollectingEventID Inner Join locality ON collectingevent.LocalityID = locality.LocalityID Inner Join geography ON locality.GeographyID = geography.GeographyID GROUP BY discipline.UserGroupScopeId ";
                    this.tblWriter.startTable();
                    this.tblWriter.logHdr("Discipline ID", "Number of ColObjs", "Discipline");
                    for (Object[] row : BasicSQLUtils.query(sql)) {
                        this.tblWriter.logObjRow(row);
                    }
                    this.tblWriter.endTable();
                    this.tblWriter.log("<BR>");
                }
                catch (SQLException ex) {
                    try {
                        this.newDBConn.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ex.printStackTrace();
                }
            }
            finally {
                try {
                    this.newDBConn.setAutoCommit(true);
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

