/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.db.PropertiesPickListAdapter;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.helpers.Encryption;
import edu.ku.brc.specify.conversion.CustomDBConverterDlg;
import edu.ku.brc.specify.conversion.CustomDBConverterListener;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CustomDBConverterPanel
extends JPanel
implements CustomDBConverterListener {
    private static final Logger log = Logger.getLogger(CustomDBConverterPanel.class);
    protected JTextField usernameSource;
    protected JPasswordField passwordSource;
    protected JCheckBox rememberUsernameSourceCBX;
    protected JCheckBox rememberPasswordSourceCBX;
    protected JTextField usernameDest;
    protected JPasswordField passwordDest;
    protected ValComboBox databasesDest;
    protected ValComboBox databasesSource;
    protected ValComboBox serversDest;
    protected ValComboBox serversSource;
    protected JCheckBox rememberUsernameDestCBX;
    protected JCheckBox rememberPasswordDestCBX;
    protected JCheckBox autoLoginDestCBX;
    protected JButton cancelBtn;
    protected JButton loginBtn;
    protected JButton helpBtn;
    protected ImageIcon forwardImgIcon;
    protected ImageIcon downImgIcon;
    protected JStatusBar statusBar;
    protected JComboBox dbDriverCBX;
    protected JComboBox dbDriverCBX2;
    protected JPanel extraPanel;
    protected JDialog thisDlg;
    protected boolean isCancelled = true;
    protected boolean isLoggingIn = false;
    protected boolean isAutoClose = false;
    protected CustomDBConverterListener dbConverterListener;
    protected CustomDBConverterDlg dbConverterDlg;
    protected Window window;
    protected Vector<DatabaseDriverInfo> dbDrivers = new Vector();
    protected long elapsedTime = -1L;
    protected long loginCount = 0L;
    protected long loginAccumTime = 0L;
    protected ProgressWorker progressWorker = null;
    protected List<String> dbNamesToConvert = null;

    public CustomDBConverterPanel(CustomDBConverterListener dbConverterListener, CustomDBConverterDlg dlg, boolean isDlg) {
        this.dbConverterListener = dbConverterListener;
        this.dbConverterDlg = dlg;
        this.createUI(isDlg);
    }

    public void setWindow(Window window) {
        this.window = window;
    }

    public Window getWindow() {
        return this.window;
    }

    public JButton getLoginBtn() {
        return this.loginBtn;
    }

    public JStatusBar getStatusBar() {
        return this.statusBar;
    }

    protected int addLine(String label, JComponent comp, PanelBuilder pb, CellConstraints cc, int y) {
        int yy = y;
        pb.add((Component)UIHelper.createLabel(label != null ? String.valueOf(UIRegistry.getResourceString(label)) + ":" : " ", 4), cc.xy(1, yy));
        pb.add((Component)comp, cc.xy(3, yy));
        return yy += 2;
    }

    protected int addLine(String label, JComponent comp, PanelBuilder pb, CellConstraints cc, int x, int y) {
        int yy = y;
        pb.add((Component)UIHelper.createLabel(label != null ? String.valueOf(UIRegistry.getResourceString(label)) + ":" : " ", 4), cc.xy(x, yy));
        pb.add((Component)comp, cc.xy(x + 2, yy));
        return yy += 2;
    }

    protected void createUI(boolean isDlg) {
        PropertiesPickListAdapter dbPickList = new PropertiesPickListAdapter("convert.databasesSource");
        PropertiesPickListAdapter svPickList = new PropertiesPickListAdapter("convert.serversSource");
        PropertiesPickListAdapter dbDestPickList = new PropertiesPickListAdapter("convert.databasesDest");
        PropertiesPickListAdapter svDestPickList = new PropertiesPickListAdapter("convert.serversDest");
        this.usernameSource = UIHelper.createTextField(20);
        this.passwordSource = UIHelper.createPasswordField(20);
        this.usernameDest = UIHelper.createTextField(20);
        this.passwordDest = UIHelper.createPasswordField(20);
        this.databasesSource = new ValComboBox(dbPickList);
        this.serversSource = new ValComboBox(svPickList);
        this.databasesDest = new ValComboBox(dbDestPickList);
        this.serversDest = new ValComboBox(svDestPickList);
        UIHelper.setControlSize(this.passwordSource);
        UIHelper.setControlSize(this.passwordDest);
        UIHelper.setControlSize(this.databasesSource);
        UIHelper.setControlSize(this.serversSource);
        UIHelper.setControlSize(this.databasesDest);
        UIHelper.setControlSize(this.serversDest);
        dbPickList.setComboBox(this.databasesSource);
        svPickList.setComboBox(this.serversSource);
        dbDestPickList.setComboBox(this.databasesDest);
        svDestPickList.setComboBox(this.serversDest);
        this.rememberUsernameSourceCBX = UIHelper.createCheckBox(UIRegistry.getResourceString("rememberuser"));
        this.rememberPasswordSourceCBX = UIHelper.createCheckBox(UIRegistry.getResourceString("rememberpassword"));
        this.autoLoginDestCBX = UIHelper.createCheckBox(UIRegistry.getResourceString("autologin"));
        this.rememberUsernameDestCBX = UIHelper.createCheckBox(UIRegistry.getResourceString("rememberuser"));
        this.rememberPasswordDestCBX = UIHelper.createCheckBox(UIRegistry.getResourceString("rememberpassword"));
        this.statusBar = new JStatusBar();
        this.statusBar.setErrorIcon(IconManager.getIcon("Error", IconManager.IconSize.Std16));
        this.cancelBtn = UIHelper.createButton(UIRegistry.getResourceString("CANCEL"));
        this.loginBtn = UIHelper.createButton(UIRegistry.getResourceString("Login"));
        this.helpBtn = UIHelper.createButton(UIRegistry.getResourceString("HELP"));
        this.forwardImgIcon = IconManager.getIcon("Forward");
        this.downImgIcon = IconManager.getIcon("Down");
        this.dbDrivers = DatabaseDriverInfo.getDriversList();
        this.dbDriverCBX = UIHelper.createComboBox(this.dbDrivers);
        this.dbDriverCBX2 = UIHelper.createComboBox(this.dbDrivers);
        if (this.dbDrivers.size() > 0) {
            String selectedStr = AppPreferences.getLocalPrefs().get("convert.dbdriverSource_selected", "SQLServer");
            int inx = Collections.binarySearch(this.dbDrivers, new DatabaseDriverInfo(selectedStr, null, null, false, null));
            this.dbDriverCBX.setSelectedIndex(inx > -1 ? inx : -1);
            selectedStr = AppPreferences.getLocalPrefs().get("convert.dbdriverDest_selected", "SQLServer");
            inx = Collections.binarySearch(this.dbDrivers, new DatabaseDriverInfo(selectedStr, null, null, false, null));
            this.dbDriverCBX2.setSelectedIndex(inx > -1 ? inx : -1);
        } else {
            JOptionPane.showConfirmDialog(null, UIRegistry.getResourceString("NO_DBDRIVERS"), UIRegistry.getResourceString("NO_DBDRIVERS_TITLE"), -1);
            System.exit(1);
        }
        this.dbDriverCBX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomDBConverterPanel.this.updateUIControls();
            }
        });
        this.dbDriverCBX2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomDBConverterPanel.this.updateUIControls();
            }
        });
        this.addFocusListenerForTextComp(this.usernameSource);
        this.addFocusListenerForTextComp(this.passwordSource);
        this.addKeyListenerFor(this.usernameSource, !isDlg);
        this.addKeyListenerFor(this.passwordSource, !isDlg);
        this.addKeyListenerFor(this.databasesSource.getTextField(), !isDlg);
        this.addKeyListenerFor(this.serversSource.getTextField(), !isDlg);
        this.addFocusListenerForTextComp(this.usernameDest);
        this.addFocusListenerForTextComp(this.passwordDest);
        this.addKeyListenerFor(this.usernameDest, !isDlg);
        this.addKeyListenerFor(this.passwordDest, !isDlg);
        this.addKeyListenerFor(this.databasesDest.getTextField(), !isDlg);
        this.addKeyListenerFor(this.serversDest.getTextField(), !isDlg);
        if (!isDlg) {
            this.addKeyListenerFor(this.loginBtn, true);
        }
        this.rememberUsernameSourceCBX.setSelected(AppPreferences.getLocalPrefs().getBoolean("convert.rememberuserSource", false));
        this.rememberPasswordSourceCBX.setSelected(AppPreferences.getLocalPrefs().getBoolean("convert.rememberpasswordSource", false));
        this.autoLoginDestCBX.setSelected(AppPreferences.getLocalPrefs().getBoolean("convert.autologin2", false));
        this.rememberUsernameDestCBX.setSelected(AppPreferences.getLocalPrefs().getBoolean("convert.rememberuserDest", false));
        this.rememberPasswordDestCBX.setSelected(AppPreferences.getLocalPrefs().getBoolean("convert.rememberpasswordDest", false));
        if (this.rememberUsernameSourceCBX.isSelected()) {
            this.usernameSource.setText(AppPreferences.getLocalPrefs().get("convert.usernameSource", ""));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CustomDBConverterPanel.this.passwordSource.requestFocus();
                }
            });
        }
        if (this.rememberPasswordSourceCBX.isSelected()) {
            this.passwordSource.setText(Encryption.decrypt(AppPreferences.getLocalPrefs().get("convert.passwordSource", "")));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CustomDBConverterPanel.this.loginBtn.requestFocus();
                }
            });
        }
        if (this.autoLoginDestCBX.isSelected()) {
            this.usernameDest.setText(AppPreferences.getLocalPrefs().get("convert.usernameDest", ""));
            this.passwordDest.setText(Encryption.decrypt(AppPreferences.getLocalPrefs().get("convert.passwordDest", "")));
            this.usernameDest.requestFocus();
        } else {
            if (this.rememberUsernameDestCBX.isSelected()) {
                this.usernameDest.setText(AppPreferences.getLocalPrefs().get("convert.usernameDest", ""));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CustomDBConverterPanel.this.passwordDest.requestFocus();
                    }
                });
            }
            if (this.rememberPasswordDestCBX.isSelected()) {
                this.passwordDest.setText(Encryption.decrypt(AppPreferences.getLocalPrefs().get("convert.passwordDest", "")));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CustomDBConverterPanel.this.loginBtn.requestFocus();
                    }
                });
            }
        }
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomDBConverterPanel.this.dbConverterListener != null) {
                    CustomDBConverterPanel.this.dbConverterListener.cancelled();
                }
            }
        });
        this.loginBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomDBConverterPanel.this.doLogin();
            }
        });
        HelpMgr.registerComponent((AbstractButton)this.helpBtn, "convert");
        dbPickList.setSelectedIndex();
        svPickList.setSelectedIndex();
        dbDestPickList.setSelectedIndex();
        svDestPickList.setSelectedIndex();
        this.serversSource.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                CustomDBConverterPanel.this.updateUIControls();
            }
        });
        this.databasesSource.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                CustomDBConverterPanel.this.updateUIControls();
            }
        });
        JPanel p = new JPanel();
        PanelBuilder formBuilder = new PanelBuilder(new FormLayout("p,3dlu,max(220px;p):g,3dlu,p,3dlu,max(220px;p):g", UIHelper.createDuplicateJGoodiesDef("p", "2dlu", 13)), p);
        CellConstraints cc = new CellConstraints();
        formBuilder.addSeparator(UIRegistry.getResourceString("SOURCE_DB"), cc.xywh(1, 1, 3, 1));
        int y = 3;
        y = this.addLine("username", this.usernameSource, formBuilder, cc, y);
        y = this.addLine("password", this.passwordSource, formBuilder, cc, y);
        y = this.addLine("databases", this.databasesSource, formBuilder, cc, y);
        y = this.addLine("servers", this.serversSource, formBuilder, cc, y);
        y = this.addLine("driver", this.dbDriverCBX, formBuilder, cc, y);
        y = this.addLine(null, this.rememberUsernameSourceCBX, formBuilder, cc, y);
        y = this.addLine(null, this.rememberPasswordSourceCBX, formBuilder, cc, y);
        int x = 5;
        formBuilder.addSeparator(UIRegistry.getResourceString("DEST_DB"), cc.xywh(x, 1, 3, 1));
        y = 3;
        y = this.addLine("username", this.usernameDest, formBuilder, cc, x, y);
        y = this.addLine("password", this.passwordDest, formBuilder, cc, x, y);
        y = this.addLine("databases", this.databasesDest, formBuilder, cc, x, y);
        y = this.addLine("servers", this.serversDest, formBuilder, cc, x, y);
        y = this.addLine("driver", this.dbDriverCBX2, formBuilder, cc, x, y);
        y = this.addLine(null, this.rememberUsernameDestCBX, formBuilder, cc, x, y);
        y = this.addLine(null, this.rememberPasswordDestCBX, formBuilder, cc, x, y);
        y = this.addLine(null, this.autoLoginDestCBX, formBuilder, cc, x, y);
        PanelBuilder extraPanelBlder = new PanelBuilder(new FormLayout("p,3dlu,max(220px;p):g", "p,2dlu,p,2dlu,p"));
        this.extraPanel = extraPanelBlder.getPanel();
        this.extraPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        PanelBuilder outerPanel = new PanelBuilder(new FormLayout("p,3dlu,p:g", "p,2dlu,p,2dlu,p"), (JPanel)this);
        formBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(2, 5, 0, 5));
        outerPanel.add((Component)formBuilder.getPanel(), cc.xy(3, 1));
        outerPanel.add((Component)ButtonBarFactory.buildOKCancelHelpBar((JButton)this.loginBtn, (JButton)this.cancelBtn, (JButton)this.helpBtn), cc.xywh(1, 3, 3, 1));
        outerPanel.add((Component)this.statusBar, cc.xywh(1, 5, 3, 1));
        this.updateUIControls();
    }

    protected void addFocusListenerForTextComp(JTextComponent textField) {
        textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                CustomDBConverterPanel.this.updateUIControls();
            }
        });
    }

    protected void addDocListenerForTextComp(JTextComponent textField) {
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                CustomDBConverterPanel.this.updateUIControls();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CustomDBConverterPanel.this.updateUIControls();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CustomDBConverterPanel.this.updateUIControls();
            }
        });
    }

    protected void addKeyListenerFor(JComponent comp, boolean checkForRet) {
        class KeyAdp
        extends KeyAdapter {
            private boolean checkForRetLocal = false;

            public KeyAdp(boolean checkForRetArg) {
                this.checkForRetLocal = checkForRetArg;
            }

            @Override
            public void keyPressed(KeyEvent e) {
                CustomDBConverterPanel.this.updateUIControls();
                if (this.checkForRetLocal && e.getKeyCode() == 10) {
                    CustomDBConverterPanel.this.doLogin();
                }
            }
        }
        comp.addKeyListener(new KeyAdp(checkForRet));
    }

    protected void updateUIControls() {
        boolean shouldEnable;
        if (this.extraPanel == null || this.isLoggingIn) {
            return;
        }
        boolean bl = shouldEnable = StringUtils.isNotEmpty((String)this.usernameSource.getText()) && StringUtils.isNotEmpty((String)new String(this.passwordSource.getPassword())) && (this.serversSource.getComboBox().getSelectedIndex() != -1 || StringUtils.isNotEmpty((String)this.serversSource.getTextField().getText()) && (this.databasesSource.getComboBox().getSelectedIndex() != -1 || StringUtils.isNotEmpty((String)this.databasesSource.getTextField().getText())));
        if (this.dbDriverCBX.getSelectedIndex() == -1) {
            shouldEnable = false;
            this.setMessage(UIRegistry.getResourceString("MISSING_DRIVER"), true);
        }
        if (this.dbDriverCBX2.getSelectedIndex() == -1) {
            shouldEnable = false;
            this.setMessage(UIRegistry.getResourceString("MISSING_DRIVER"), true);
        }
        this.loginBtn.setEnabled(shouldEnable);
        if (shouldEnable) {
            this.setMessage("", false);
        }
    }

    public void setMessage(String msg, boolean isError) {
        if (this.statusBar != null) {
            if (isError) {
                this.statusBar.setErrorMessage(msg, null);
            } else {
                this.statusBar.setText(msg);
            }
        }
    }

    protected void save() {
        this.databasesSource.saveControlData();
        this.serversSource.saveControlData();
        AppPreferences.getLocalPrefs().putBoolean("convert.rememberuserSource", this.rememberUsernameSourceCBX.isSelected());
        AppPreferences.getLocalPrefs().putBoolean("convert.rememberpasswordSource", this.rememberPasswordSourceCBX.isSelected());
        AppPreferences.getLocalPrefs().putBoolean("convert.rememberuserDest", this.rememberUsernameDestCBX.isSelected());
        AppPreferences.getLocalPrefs().putBoolean("convert.rememberpasswordDest", this.rememberPasswordDestCBX.isSelected());
        if (this.rememberUsernameSourceCBX.isSelected()) {
            AppPreferences.getLocalPrefs().put("convert.usernameSource", this.usernameSource.getText());
        } else if (AppPreferences.getLocalPrefs().exists("convert.usernameSource")) {
            AppPreferences.getLocalPrefs().remove("convert.usernameSource");
        }
        if (this.rememberPasswordSourceCBX.isSelected()) {
            AppPreferences.getLocalPrefs().put("convert.passwordSource", Encryption.encrypt(new String(this.passwordSource.getPassword())));
        } else if (AppPreferences.getLocalPrefs().exists("convert.passwordSource")) {
            AppPreferences.getLocalPrefs().remove("convert.passwordSource");
        }
        if (this.rememberUsernameDestCBX.isSelected()) {
            AppPreferences.getLocalPrefs().put("convert.usernameDest", this.usernameDest.getText());
        } else if (AppPreferences.getLocalPrefs().exists("convert.usernameDest")) {
            AppPreferences.getLocalPrefs().remove("convert.usernameDest");
        }
        if (this.rememberPasswordSourceCBX.isSelected()) {
            AppPreferences.getLocalPrefs().put("convert.passwordDest", Encryption.encrypt(new String(this.passwordDest.getPassword())));
        } else if (AppPreferences.getLocalPrefs().exists("convert.passwordDest")) {
            AppPreferences.getLocalPrefs().remove("convert.passwordDest");
        }
    }

    protected void loginOK() {
        this.isCancelled = false;
        if (this.dbConverterListener != null) {
            this.dbConverterListener.loggedIn(this.getSourceDatabaseName(), this.getSourceUserName());
        }
    }

    public void setAutoClose(boolean isAutoClose) {
        this.isAutoClose = isAutoClose;
    }

    protected void enableUI(boolean enable) {
        this.cancelBtn.setEnabled(enable);
        this.loginBtn.setEnabled(enable);
        this.helpBtn.setEnabled(enable);
        this.usernameSource.setEnabled(enable);
        this.passwordSource.setEnabled(enable);
        this.databasesSource.setEnabled(enable);
        this.serversSource.setEnabled(enable);
        this.rememberUsernameSourceCBX.setEnabled(enable);
        this.rememberPasswordSourceCBX.setEnabled(enable);
        this.usernameDest.setEnabled(enable);
        this.passwordDest.setEnabled(enable);
        this.databasesDest.setEnabled(enable);
        this.serversDest.setEnabled(enable);
        this.rememberUsernameDestCBX.setEnabled(enable);
        this.rememberPasswordDestCBX.setEnabled(enable);
    }

    public void doLogin() {
        log.debug((Object)"do nothing for now");
        this.save();
        this.isLoggingIn = true;
        this.save();
        this.enableUI(false);
        this.getDbConverterDlg().setVisible(false);
    }

    public String getSourceServerName() {
        return this.serversSource.getTextField().getText();
    }

    public String getDestServerName() {
        return this.serversDest.getTextField().getText();
    }

    public String getSourceDatabaseName() {
        return this.databasesSource.getTextField().getText();
    }

    public String getDestDatabaseName() {
        return this.databasesDest.getTextField().getText();
    }

    public String getSourceUserName() {
        return this.usernameSource.getText();
    }

    public String getDestUserName() {
        return this.usernameDest.getText();
    }

    public String getSourcePassword() {
        return new String(this.passwordSource.getPassword());
    }

    public String getDestPassword() {
        return new String(this.passwordDest.getPassword());
    }

    public String getSourceConnectionStr() {
        if (this.dbDriverCBX.getSelectedIndex() > -1) {
            return this.dbDrivers.get(this.dbDriverCBX.getSelectedIndex()).getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, this.getSourceServerName(), this.getSourceDatabaseName(), this.getSourceUserName(), this.getSourcePassword(), this.getSourceDriverType());
        }
        return null;
    }

    public String getDestConnectionStr() {
        if (this.dbDriverCBX2.getSelectedIndex() > -1) {
            return this.dbDrivers.get(this.dbDriverCBX2.getSelectedIndex()).getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, this.getDestServerName(), this.getDestDatabaseName(), this.getDestUserName(), this.getDestPassword(), this.getDestDriverType());
        }
        return null;
    }

    public String getSourceDialectClassName() {
        if (this.dbDriverCBX.getSelectedIndex() > -1) {
            return this.dbDrivers.get(this.dbDriverCBX.getSelectedIndex()).getDialectClassName();
        }
        return null;
    }

    public String getDestDialectClassName() {
        if (this.dbDriverCBX2.getSelectedIndex() > -1) {
            return this.dbDrivers.get(this.dbDriverCBX2.getSelectedIndex()).getDialectClassName();
        }
        return null;
    }

    public String getSourceDriverClassName() {
        if (this.dbDriverCBX.getSelectedIndex() > -1) {
            return this.dbDrivers.get(this.dbDriverCBX.getSelectedIndex()).getDriverClassName();
        }
        return null;
    }

    public String getDestDriverClassName() {
        if (this.dbDriverCBX2.getSelectedIndex() > -1) {
            return this.dbDrivers.get(this.dbDriverCBX2.getSelectedIndex()).getDriverClassName();
        }
        return null;
    }

    public String getSourceDriverType() {
        if (this.dbDriverCBX.getSelectedIndex() > -1) {
            return this.dbDrivers.get(this.dbDriverCBX.getSelectedIndex()).getName();
        }
        return null;
    }

    public String getDestDriverType() {
        if (this.dbDriverCBX2.getSelectedIndex() > -1) {
            return this.dbDrivers.get(this.dbDriverCBX2.getSelectedIndex()).getName();
        }
        return null;
    }

    public boolean doingAutoLogin() {
        return AppPreferences.getLocalPrefs().getBoolean("autologin", false);
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void loggedIn(String databaseNameArg, String userNameArg) {
    }

    @Override
    public void cancelled() {
    }

    public List<String> getSelectedObjects() {
        ArrayList<String> selectedItems = new ArrayList<String>(5);
        selectedItems.add(this.getSourceDatabaseName().toLowerCase());
        selectedItems.add(this.getDestDatabaseName().toLowerCase());
        return selectedItems;
    }

    public CustomDBConverterDlg getDbConverterDlg() {
        return this.dbConverterDlg;
    }

    public void setDbConverterDlg(CustomDBConverterDlg dbConverterDlg) {
        this.dbConverterDlg = dbConverterDlg;
    }

    class ProgressWorker
    implements ActionListener {
        protected int timesASecond;
        protected JProgressBar progressBar;
        protected int count;
        protected int totalCount;
        protected boolean stop = false;

        public ProgressWorker(JProgressBar progressBar, int count, int totalCount, int timesPerSecond) {
            this.timesASecond = timesPerSecond;
            this.progressBar = progressBar;
            this.count = count;
            this.totalCount = totalCount * this.timesASecond;
            this.progressBar.setIndeterminate(false);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(this.totalCount);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ++this.count;
            this.progressBar.setValue(this.count);
            if (!this.stop) {
                if (this.count >= this.totalCount || this.progressBar.getValue() >= this.totalCount) {
                    this.progressBar.setIndeterminate(true);
                }
            } else {
                ((Timer)e.getSource()).stop();
            }
        }

        public synchronized void stop() {
            this.stop = true;
        }
    }
}

