/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.specify.conversion.CustomDBConverterListener;
import edu.ku.brc.specify.conversion.CustomDBConverterPanel;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class CustomDBConverterDlg
extends JDialog
implements CustomDBConverterListener {
    private static final Logger log = Logger.getLogger(CustomDBConverterDlg.class);
    protected CustomDBConverterPanel dbConverterPanel;
    protected CustomDBConverterListener dbConverterListener;
    protected boolean doAutoLogin = false;
    protected boolean doAutoClose = true;
    protected JPanel glassPane = new JPanel();

    public CustomDBConverterDlg(Frame frame, CustomDBConverterListener listener) {
        super(frame);
        this.dbConverterListener = listener;
        this.setTitle(UIRegistry.getResourceString("LOGINTITLE"));
        this.dbConverterPanel = new CustomDBConverterPanel(this, this, true);
        this.setContentPane(this.dbConverterPanel);
        this.setLocationRelativeTo(UIRegistry.get("frame"));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.dbConverterPanel.getLoginBtn());
        this.pack();
    }

    public boolean isCancelled() {
        return this.dbConverterPanel.isCancelled();
    }

    public boolean doingAutoLogin() {
        return this.dbConverterPanel.doingAutoLogin();
    }

    public void setDoAutoLogin(boolean doAutoLogin) {
        this.doAutoLogin = doAutoLogin;
    }

    public void setDoAutoClose(boolean doAutoClose) {
        this.doAutoClose = doAutoClose;
        if (this.dbConverterPanel != null) {
            this.dbConverterPanel.setAutoClose(doAutoClose);
        }
    }

    public CustomDBConverterPanel getCustomDBConverterPanel() {
        return this.dbConverterPanel;
    }

    @Override
    public void setVisible(boolean show) {
        if (show && this.doAutoLogin) {
            this.dbConverterPanel.doLogin();
        }
        super.setVisible(show);
    }

    public void aboutToLoginIn() {
        this.glassPane.setSize(this.getSize());
        this.setGlassPane(this.glassPane);
    }

    @Override
    public void loggedIn(String databaseName, String userName) {
        log.debug((Object)"loggedIn");
        this.setVisible(false);
        this.dispose();
        if (this.dbConverterListener != null) {
            this.dbConverterListener.loggedIn(databaseName, userName);
        }
    }

    @Override
    public void cancelled() {
        log.debug((Object)"cancelled");
        this.setVisible(false);
        this.dispose();
        if (this.dbConverterListener != null) {
            this.dbConverterListener.cancelled();
        }
    }
}

