/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.DesertBlue;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.dbsupport.MySQLDMBSUserMgr;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.ConversionLogger;
import edu.ku.brc.specify.conversion.CustomDBConverterDlg;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import edu.ku.brc.specify.conversion.IdTableMapper;
import edu.ku.brc.specify.conversion.PartialDateConv;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.specify.dbsupport.PostInsertEventListener;
import edu.ku.brc.specify.ui.AppBase;
import edu.ku.brc.specify.utilapps.BuildSampleDatabase;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.ToggleButtonChooserPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.Pair;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ConvertVerifier
extends AppBase {
    private static final Logger log = Logger.getLogger(ConvertVerifier.class);
    private Pair<String, String> itUsrPwd = new Pair<Object, Object>(null, null);
    private String hostName = "localhost";
    private Pair<String, String> namePairToConvert = null;
    private boolean dbgStatus = false;
    private boolean compareTo6DBs = false;
    public static final long NO_OPTIONS = 0L;
    public static final long DO_CO_PREPARATION = 1L;
    public static final long DO_CO_CE = 2L;
    public static final long DO_CO_LOCALITY = 4L;
    public static final long DO_CO_PREPARER = 8L;
    public static final long DO_CO_CATLOGER = 16L;
    public static final long DO_CO_DETERMINER = 32L;
    public static final long DO_CO_TAXON = 64L;
    public static final long DO_CO_GEO = 128L;
    public static final long DO_COLLECTORS = 256L;
    public static final long DO_COLLEVENTS = 512L;
    public static final long DO_TAXON_CIT = 1024L;
    public static final long DO_SHIPMENTS = 2048L;
    public static final long DO_OTHER_IDENT = 4096L;
    public static final long DO_CO_COLLECTORS = 8192L;
    public static final long DO_AGENTS = 16384L;
    public static final long DO_LOANS = 32768L;
    public static final long DO_CO_ALL = 65535L;
    private String[] labels = new String[]{"None", "Preparations", "CO Collecting Events", "Localities", "Preparers", "Catalogers", "Determiners", "Taxon", "Geographies", "Collectors", "Collecting Events", "Taxon Citations", "Shipments", "Other Ident", "ColObj Collectors", "Agents", "Loans", "All"};
    private ToggleButtonChooserPanel<String> chkPanel;
    public static final long DO_ACCESSIONS = 1L;
    public static final long DO_AC_AUTHS = 2L;
    public static final long DO_AC_AGENTS = 4L;
    public static final long DO_AC_ALL = 7L;
    private String[] accLabels = new String[]{"None", "Accessions", "Authorizations", "Agents", "All"};
    private static long coOptions = 0L;
    private static long acOptions = 0L;
    private Hashtable<String, Integer> catNumsInErrHash = new Hashtable();
    private Hashtable<String, String> accNumsInErrHash = new Hashtable();
    private IdMapperMgr idMapperMgr;
    private Connection oldDBConn;
    private Connection newDBConn;
    private Statement oldDBStmt;
    private Statement newDBStmt;
    private ResultSet oldDBRS;
    private ResultSet newDBRS;
    private String newSQL;
    private String oldSQL;
    private int numErrors = 0;
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private boolean debug = false;
    private static ProgressFrame progressFrame;
    private ConversionLogger convLogger = new ConversionLogger();
    private TableWriter tblWriter = null;

    public ConvertVerifier() {
        PostInsertEventListener.setAuditOn(false);
        ConvertVerifier.setUpSystemProperties();
        AppContextMgr.getInstance().setHasContext(true);
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        localPrefs.setDirPath(UIRegistry.getAppDataDir());
        IconManager.setApplicationClass(Specify.class);
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_datamodel.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_plugins.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_disciplines.xml"));
        this.appIcon = new JLabel("  ");
        this.setAppIcon(null);
        this.idMapperMgr = IdMapperMgr.getInstance();
    }

    public void verifyDB(String databaseNameSource, String databaseNameDest) throws Exception {
        String path = String.valueOf(UIRegistry.getUserHomeDir()) + File.separator + "verify";
        this.convLogger.initialize(path, databaseNameDest);
        String title = "From " + databaseNameSource + " to " + databaseNameDest;
        System.out.println("************************************************************");
        System.out.println(title);
        System.out.println("************************************************************");
        HibernateUtil.shutdown();
        Properties initPrefs = BuildSampleDatabase.getInitializePrefs(databaseNameDest);
        String driverNameSource = "";
        String databaseHostSource = "";
        DatabaseDriverInfo driverInfoSource = null;
        String driverNameDest = "";
        String databaseHostDest = "";
        DatabaseDriverInfo driverInfoDest = null;
        log.debug((Object)"Running an non-custom MySQL convert, using old default login creds");
        driverNameSource = initPrefs.getProperty("initializer.driver", "MySQL");
        databaseHostSource = initPrefs.getProperty("initializer.host", "localhost");
        driverNameDest = initPrefs.getProperty("initializer.driver", "MySQL");
        databaseHostDest = initPrefs.getProperty("initializer.host", "localhost");
        log.debug((Object)"Custom Convert Source Properties ----------------------");
        log.debug((Object)("databaseNameSource: " + databaseNameSource));
        log.debug((Object)("driverNameSource: " + driverNameSource));
        log.debug((Object)("databaseHostSource: " + databaseHostSource));
        log.debug((Object)"Custom Convert Destination Properties ----------------------");
        log.debug((Object)("databaseNameDest: " + databaseNameDest));
        log.debug((Object)("driverNameDest: " + driverNameDest));
        log.debug((Object)("databaseHostDest: " + databaseHostDest));
        driverInfoSource = DatabaseDriverInfo.getDriver(driverNameSource);
        driverInfoDest = DatabaseDriverInfo.getDriver(driverNameDest);
        if (driverInfoSource == null) {
            throw new RuntimeException("Couldn't find Source DB driver by name [" + driverInfoSource + "] in driver list.");
        }
        if (driverInfoDest == null) {
            throw new RuntimeException("Couldn't find Destination driver by name [" + driverInfoDest + "] in driver list.");
        }
        if (driverNameDest.equals("MySQL")) {
            BasicSQLUtils.myDestinationServerType = BasicSQLUtils.SERVERTYPE.MySQL;
        } else if (driverNameDest.equals("SQLServer")) {
            BasicSQLUtils.myDestinationServerType = BasicSQLUtils.SERVERTYPE.MS_SQLServer;
        }
        if (driverNameSource.equals("MySQL")) {
            BasicSQLUtils.mySourceServerType = BasicSQLUtils.SERVERTYPE.MySQL;
        } else if (driverNameSource.equals("SQLServer")) {
            BasicSQLUtils.mySourceServerType = BasicSQLUtils.SERVERTYPE.MS_SQLServer;
        } else {
            log.error((Object)"Error setting ServerType for destination database for conversion.  Could affect the way that SQL string are generated and executed on differetn DB egnines");
        }
        String destConnectionString = driverInfoDest.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, databaseHostDest, "", (String)this.itUsrPwd.first, (String)this.itUsrPwd.second, driverNameDest);
        log.debug((Object)("attempting login to destination: " + destConnectionString));
        if (!UIHelper.tryLogin(driverInfoDest.getDriverClassName(), driverInfoDest.getDialectClassName(), databaseNameDest, destConnectionString, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second)) {
            log.error((Object)("Failed connection string: " + driverInfoSource.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, databaseHostDest, databaseNameDest, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second, driverNameDest)));
            throw new RuntimeException("Couldn't login into [" + databaseNameDest + "] " + DBConnection.getInstance().getErrorMsg());
        }
        this.convLogger.setIndexTitle(String.valueOf(databaseNameDest) + " Verify " + new SimpleDateFormat("yyy-MM-dd hh:mm:ss").format(Calendar.getInstance().getTime()));
        log.debug((Object)("DESTINATION driver class: " + driverInfoDest.getDriverClassName()));
        log.debug((Object)("DESTINATION dialect class: " + driverInfoDest.getDialectClassName()));
        log.debug((Object)("DESTINATION Connection String: " + driverInfoDest.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, databaseHostDest, databaseNameDest, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second, driverNameDest)));
        if (!UIHelper.tryLogin(driverInfoDest.getDriverClassName(), driverInfoDest.getDialectClassName(), databaseNameDest, driverInfoDest.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, databaseHostDest, databaseNameDest, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second, driverNameDest), (String)this.itUsrPwd.first, (String)this.itUsrPwd.second)) {
            throw new RuntimeException("Couldn't login into [" + databaseNameDest + "] " + DBConnection.getInstance().getErrorMsg());
        }
        String srcConStr = driverInfoSource.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, databaseHostSource, databaseNameSource, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second, driverNameSource);
        DBConnection oldDB = DBConnection.createInstance(driverInfoSource.getDriverClassName(), null, databaseNameSource, srcConStr, (String)this.itUsrPwd.first, (String)this.itUsrPwd.second);
        this.oldDBConn = oldDB.getConnection();
        if (this.oldDBConn == null) {
            throw new RuntimeException(oldDB.getErrorMsg());
        }
        this.newDBConn = DBConnection.getInstance().createConnection();
        this.newDBStmt = this.newDBConn.createStatement(1004, 1007);
        this.oldDBStmt = this.oldDBConn.createStatement(1004, 1007);
        IdMapperMgr.getInstance().setDBs(this.oldDBConn, this.newDBConn);
        long startTime = System.currentTimeMillis();
        String[] tableNames = new String[]{"CollectingEvent", "CollectingEvent", "Locality", "Locality"};
        int i = 0;
        while (i < tableNames.length) {
            this.verifyTableCounts(tableNames[i].toLowerCase(), tableNames[i + 1].toLowerCase());
            i += 2;
        }
        progressFrame = new ProgressFrame("Checking Catalog Objects....");
        progressFrame.adjustProgressFrame();
        String cntSQL = this.compareTo6DBs ? "SELECT COUNT(*) FROM collectionobject" : "SELECT COUNT(*) FROM collectionobjectcatalog WHERE CollectionObjectTypeID > 8 && CollectionObjectTypeID < 20";
        Integer numColObjs = BasicSQLUtils.getCount(this.oldDBConn, cntSQL);
        progressFrame.setProcess(0, numColObjs);
        progressFrame.setOverall(0, numColObjs * 4);
        progressFrame.setOverall(0);
        progressFrame.setDesc("");
        UIHelper.centerAndShow(progressFrame);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIHelper.centerAndShow(progressFrame);
            }
        });
        HashMap<Long, TableWriter> tblWriterHash = new HashMap<Long, TableWriter>();
        int i2 = 1;
        while (i2 < this.labels.length - 1) {
            long id = (long)Math.pow(2.0, i2 - 1);
            id = Math.max(id, 1L);
            this.tblWriter = this.convLogger.getWriter(String.valueOf(this.labels[i2]) + ".html", this.labels[i2]);
            this.tblWriter.startTable();
            this.tblWriter.logHdr("ID", "Desc");
            tblWriterHash.put(id, this.tblWriter);
            System.out.println(String.valueOf(id) + " - " + this.labels[i2]);
            ++i2;
        }
        boolean nullCEOk = false;
        File ceFile = new File(String.valueOf(databaseNameDest) + ".ce_all");
        if (ceFile.exists()) {
            nullCEOk = true;
        }
        nullCEOk = true;
        coOptions = 65535L;
        int i3 = 0;
        Statement stmt = this.oldDBConn.createStatement(1004, 1007);
        String sql = this.compareTo6DBs ? "SELECT CatalogNumber FROM collectionobject ORDER BY CatalogNumber ASC" : "SELECT CatalogNumber FROM collectionobjectcatalog WHERE CollectionObjectTypeID > 8 && CollectionObjectTypeID < 20 AND SubNumber >= 0 ORDER BY CatalogNumber ASC";
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            int oldCatNum = rs.getInt(1);
            String newCatNum = ConvertVerifier.convertCatNum(oldCatNum);
            if (i3 % 100 == 0) {
                System.out.println(String.valueOf(i3) + "  " + oldCatNum);
                progressFrame.setProcess(i3);
                progressFrame.setOverall(i3);
            }
            if (i3 % 1000 == 0) {
                for (TableWriter tw : tblWriterHash.values()) {
                    tw.flush();
                }
            }
            ++i3;
        }
        rs.close();
        stmt.close();
        progressFrame.setProcess(numColObjs);
        if (ConvertVerifier.isCOOn(256L)) {
            this.tblWriter = (TableWriter)tblWriterHash.get(256L);
        }
        if (ConvertVerifier.isCOOn(16384L)) {
            this.tblWriter = (TableWriter)tblWriterHash.get(16384L);
            this.verifyAgents();
        }
        progressFrame.setOverall(numColObjs * 2);
        if (ConvertVerifier.isCOOn(512L)) {
            this.tblWriter = (TableWriter)tblWriterHash.get(512L);
            this.verifyCEs();
        }
        if (ConvertVerifier.isCOOn(512L)) {
            this.tblWriter = (TableWriter)tblWriterHash.get(512L);
            this.verifyShipments();
        }
        if (ConvertVerifier.isCOOn(32768L)) {
            this.tblWriter = (TableWriter)tblWriterHash.get(32768L);
            this.verifyLoans();
            this.verifyGifts();
            this.verifyLoanRetPreps();
        }
        for (TableWriter tw : tblWriterHash.values()) {
            tw.endTable();
        }
        progressFrame.setOverall(numColObjs * 3);
        this.tblWriter = this.convLogger.getWriter("CatalogNumberSummary.html", "Catalog Nummber Summary");
        this.tblWriter.startTable();
        this.tblWriter.logHdr("Number", "Description");
        this.tblWriter.logErrors(Integer.toString(this.numErrors), "All Errors");
        this.tblWriter.logErrors(Integer.toString(this.catNumsInErrHash.size()), "Catalog Number with Errors");
        this.tblWriter.endTable();
        this.tblWriter.println("<BR>");
        this.tblWriter.println("Catalog Summary:<BR>");
        Vector<String> catNumList = new Vector<String>(this.catNumsInErrHash.keySet());
        Collections.sort(catNumList);
        for (String catNum : catNumList) {
            this.tblWriter.println(String.valueOf(catNum) + "<BR>");
        }
        this.tblWriter.println("<BR>");
        this.numErrors = 0;
        acOptions = 7L;
        HashMap<Long, TableWriter> accTblWriterHash = new HashMap<Long, TableWriter>();
        int i4 = 1;
        while (i4 < this.accLabels.length) {
            long id = (long)Math.pow(2.0, i4 - 1);
            id = Math.max(id, 1L);
            this.tblWriter = this.convLogger.getWriter("accession_" + this.accLabels[i4] + ".html", "Accession " + this.accLabels[i4]);
            this.tblWriter.startTable();
            this.tblWriter.logHdr("ID", "Desc");
            accTblWriterHash.put(id, this.tblWriter);
            ++i4;
        }
        if (acOptions > 0L) {
            i4 = 0;
            Statement stmt2 = this.oldDBConn.createStatement(1004, 1007);
            ResultSet rs2 = stmt2.executeQuery("SELECT Number FROM accession ORDER BY Number ASC");
            while (rs2.next()) {
                String oldAccNum;
                String newAccNum = oldAccNum = rs2.getString(1);
                if (ConvertVerifier.isACOn(1L)) {
                    this.tblWriter = (TableWriter)accTblWriterHash.get(1L);
                    if (!this.verifyAccessions(oldAccNum, newAccNum)) {
                        log.error((Object)("Accession Num: " + oldAccNum));
                        this.accNumsInErrHash.put(newAccNum, oldAccNum);
                    }
                }
                if (ConvertVerifier.isACOn(4L)) {
                    this.tblWriter = (TableWriter)accTblWriterHash.get(4L);
                    if (!this.verifyAccessionAgents(oldAccNum, newAccNum)) {
                        log.error((Object)("Accession Num: " + oldAccNum));
                        this.accNumsInErrHash.put(newAccNum, oldAccNum);
                    }
                }
                if (i4 % 100 == 0) {
                    System.out.println(String.valueOf(i4) + "  " + oldAccNum);
                }
                ++i4;
            }
            rs2.close();
            stmt2.close();
        }
        progressFrame.setOverall(numColObjs * 4);
        this.newDBConn.close();
        this.oldDBConn.close();
        for (TableWriter tw : accTblWriterHash.values()) {
            tw.endTable();
        }
        this.printAccessionTotal("Accession");
        File indexFile = this.convLogger.closeAll();
        long endTime = System.currentTimeMillis();
        int convertTimeInSeconds = (int)((double)(endTime - startTime) / 1000.0);
        log.info((Object)"Done.");
        progressFrame.setVisible(false);
        AttachmentUtils.openURI(indexFile.toURI());
        System.exit(0);
    }

    public void setCompareTo6DBs(boolean compareTo6DBs) {
        this.compareTo6DBs = compareTo6DBs;
    }

    private void printAccessionTotal(String prefix) throws FileNotFoundException {
        this.tblWriter = this.convLogger.getWriter(String.valueOf(prefix) + "Summary.html", String.valueOf(prefix) + " Summary");
        this.tblWriter.startTable();
        this.tblWriter.logHdr("Number", "Description");
        this.tblWriter.logErrors(Integer.toString(this.numErrors), "All Errors");
        this.tblWriter.logErrors(Integer.toString(this.accNumsInErrHash.size()), "Accession Numbers with Errors");
        this.tblWriter.endTable();
    }

    private boolean verifyTaxon(int oldCatNum, String newCatNum) throws SQLException {
        this.newSQL = "SELECT co.CollectionObjectID, co.CatalogedDate, co.CatalogedDatePrecision, determination.DeterminedDate, determination.DeterminedDatePrecision, tx.FullName FROM determination LEFT JOIN collectionobject co ON determination.CollectionObjectID = co.CollectionObjectID LEFT JOIN taxon tx ON determination.TaxonID = tx.TaxonID WHERE CatalogNumber = '" + newCatNum + "'";
        this.oldSQL = "SELECT cc.CollectionObjectCatalogID, cc.CatalogedDate, determination.Date,taxonname.FullTaxonName FROM determination LEFT JOIN taxonname ON determination.TaxonNameID = taxonname.TaxonNameID LEFT JOIN collectionobjectcatalog cc ON cc.CollectionObjectCatalogID = determination.BiologicalObjectID WHERE cc.SubNumber > -1 AND CatalogNumber = " + oldCatNum;
        if (this.debug) {
            log.debug((Object)("New SQL: " + this.newSQL));
            log.debug((Object)("Old SQL: " + this.oldSQL));
        }
        StatusType status = this.compareRecords("Taxon", oldCatNum, newCatNum, this.oldSQL, this.newSQL);
        this.dumpStatus(status);
        return status == StatusType.COMPARE_OK;
    }

    private boolean verifyOtherIdentifier(int oldCatNum, String newCatNum) throws SQLException {
        this.newSQL = "SELECT collectionobject.CatalogNumber, otheridentifier.Identifier FROM collectionobject Inner Join otheridentifier ON collectionobject.CollectionObjectID = otheridentifier.CollectionObjectID WHERE CatalogNumber = '" + newCatNum + "'" + "ORDER BY collectionobject.CatalogNumber ASC, otheridentifier.Identifier ASC";
        this.oldSQL = "SELECT cc.CatalogNumber, i.Identifier FROM collectionobject AS c Inner Join collectionobjectcatalog AS cc ON c.CollectionObjectID = cc.CollectionObjectCatalogID Inner Join otheridentifier AS i ON cc.CollectionObjectCatalogID = i.CollectionObjectID WHERE c.CollectionObjectTypeID <  21 AND cc.SubNumber > -1 AND cc.CatalogNumber = " + oldCatNum + " " + "ORDER BY " + " cc.CatalogNumber ASC, i.Identifier ASC";
        if (this.debug) {
            log.debug((Object)("New SQL: " + this.newSQL));
            log.debug((Object)("Old SQL: " + this.oldSQL));
        }
        StatusType status = this.compareRecords("OtherIdentifier", oldCatNum, newCatNum, this.oldSQL, this.newSQL);
        this.dumpStatus(status);
        return status == StatusType.COMPARE_OK;
    }

    private void dumpStatus(StatusType status) {
        if (this.dbgStatus) {
            switch (status) {
                case OLD_VAL_NULL: {
                    this.tblWriter.print("<tr><td colspan=\"2\">");
                    this.tblWriter.println(ConvertVerifier.dumpSQL(this.newDBConn, this.newSQL));
                    this.tblWriter.println(ConvertVerifier.dumpSQL(this.oldDBConn, this.oldSQL));
                    this.tblWriter.println("<BR>");
                    this.tblWriter.println("</td></tr><!-- 4 -->");
                    this.tblWriter.flush();
                    break;
                }
                case NO_OLD_REC: {
                    this.tblWriter.print("<tr><td colspan=\"2\">");
                    this.tblWriter.println(ConvertVerifier.dumpSQL(this.newDBConn, this.newSQL));
                    this.tblWriter.println("<BR>");
                    this.tblWriter.println("</td></tr><!-- 4 -->");
                    this.tblWriter.flush();
                    break;
                }
                case NEW_VAL_NULL: {
                    this.tblWriter.print("<tr><td colspan=\"2\">");
                    this.tblWriter.println(ConvertVerifier.dumpSQL(this.newDBConn, this.newSQL));
                    this.tblWriter.println(ConvertVerifier.dumpSQL(this.oldDBConn, this.oldSQL));
                    this.tblWriter.println("<BR>");
                    this.tblWriter.println("</td></tr><!-- 4 -->");
                    this.tblWriter.flush();
                    break;
                }
                case NO_NEW_REC: {
                    this.tblWriter.print("<tr><td colspan=\"2\">");
                    this.tblWriter.println(ConvertVerifier.dumpSQL(this.oldDBConn, this.oldSQL));
                    this.tblWriter.println("<BR>");
                    this.tblWriter.println("</td></tr><!-- 4 -->");
                    this.tblWriter.flush();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean verifyGeography(int oldCatNum, String newCatNum) throws SQLException {
        String[] lbls = new String[]{"ContinentOrOcean", "Country", "State", "County"};
        this.newSQL = "SELECT g.GeographyID, g.Name FROM collectionobject co INNER JOIN collectingevent ce ON co.CollectingEventID = ce.CollectingEventID INNER JOIN locality l ON ce.LocalityID = l.LocalityID INNER JOIN geography g ON l.GeographyID = g.GeographyID WHERE CatalogNumber = '" + newCatNum + "'";
        this.oldSQL = "SELECT g.GeographyID, g.ContinentOrOcean, g.Country, g.State, g.County FROM collectionobjectcatalog cc INNER JOIN collectionobject co ON cc.CollectionObjectCatalogID = co.CollectionObjectID INNER JOIN collectingevent ce ON co.CollectingEventID = ce.CollectingEventID INNER JOIN locality l ON ce.LocalityID = l.LocalityID INNER JOIN geography g ON l.GeographyID = g.GeographyID WHERE cc.SubNumber > -1 AND CatalogNumber = " + oldCatNum;
        if (this.debug) {
            log.debug((Object)("New SQL: " + this.newSQL));
            log.debug((Object)("Old SQL: " + this.oldSQL));
        }
        try {
            this.getResultSets(this.oldSQL, this.newSQL);
            boolean hasOldRec = this.oldDBRS.next();
            boolean hasNewRec = this.newDBRS.next();
            if (!hasOldRec && !hasNewRec) {
                return true;
            }
            if (!hasOldRec) {
                log.error((Object)("Geography - No Old Record for [" + oldCatNum + "]"));
                return false;
            }
            if (!hasNewRec) {
                log.error((Object)("Geography - No New Record for [" + newCatNum + "]"));
                return false;
            }
            String newGeoName = this.newDBRS.getString(2);
            String[] names = new String[4];
            int i = 0;
            while (i < names.length) {
                names[i] = this.oldDBRS.getString(i + 2);
                ++i;
            }
            i = names.length - 1;
            while (i >= 0) {
                if (newGeoName.equalsIgnoreCase(names[i])) {
                    return true;
                }
                --i;
            }
            if (newGeoName.equals("Undefined")) return true;
            StringBuilder sb = new StringBuilder("Couldn't find New Geo Name[");
            sb.append(newGeoName);
            sb.append("] Old Id[");
            sb.append(this.oldDBRS.getInt(1));
            sb.append("] New Id[");
            sb.append(this.newDBRS.getInt(1));
            sb.append("]");
            int i2 = names.length - 1;
            while (i2 >= 0) {
                sb.append(" ");
                sb.append(lbls[i2]);
                sb.append("[");
                sb.append(names[i2]);
                sb.append("]");
                --i2;
            }
            String oldNewIdStr = String.valueOf(oldCatNum) + " / " + newCatNum + " ";
            log.error((Object)(String.valueOf(oldNewIdStr) + " - " + sb.toString()));
            this.tblWriter.logErrors(oldNewIdStr, sb.toString());
            return false;
        }
        finally {
            this.doneWithRS();
        }
    }

    public static String dumpSQL(Connection conn, String sql) {
        StringBuilder sb = new StringBuilder("<table class=\"i\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n");
        Vector<Object[]> list = BasicSQLUtils.query(conn, sql, true);
        for (Object[] row : list) {
            sb.append("<tr>");
            Object[] objectArray = row;
            int n = row.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                sb.append("<td>");
                sb.append(obj);
                sb.append("</td>");
                ++n2;
            }
            sb.append("</tr>\n");
        }
        sb.append("</table>\n");
        return sb.toString();
    }

    private boolean verifyTableCounts(String newTableName, String oldTableName) {
        int oldCnt;
        int newCnt = BasicSQLUtils.getNumRecords(this.newDBConn, newTableName);
        if (newCnt != (oldCnt = BasicSQLUtils.getNumRecords(this.oldDBConn, oldTableName))) {
            log.error((Object)("Table Record Counts don't match New[" + newTableName + "  " + newCnt + "][" + oldTableName + "  " + oldCnt + "]"));
            return false;
        }
        return true;
    }

    private boolean verifyCOToLocality(int oldCatNum, String newCatNum) throws SQLException {
        this.newSQL = "SELECT l.LocalityID, l.LocalityName FROM collectionobject co INNER JOIN collectingevent ce ON co.CollectingEventID = ce.CollectingEventID INNER JOIN locality l ON ce.LocalityID = l.LocalityID WHERE CatalogNumber = '" + newCatNum + "'";
        this.oldSQL = "SELECT l.LocalityID, l.LocalityName  FROM collectionobjectcatalog cc INNER JOIN collectionobject co ON cc.CollectionObjectCatalogID = co.CollectionObjectID INNER JOIN collectingevent ce ON co.CollectingEventID = ce.CollectingEventID INNER JOIN locality l ON ce.LocalityID = l.LocalityID WHERE cc.SubNumber > -1 AND CatalogNumber = " + oldCatNum;
        if (this.debug) {
            log.debug((Object)("New SQL: " + this.newSQL));
            log.debug((Object)("Old SQL: " + this.oldSQL));
        }
        StatusType status = this.compareRecords("Locality", oldCatNum, newCatNum, this.oldSQL, this.newSQL);
        this.dumpStatus(status);
        return status == StatusType.COMPARE_OK;
    }

    private boolean verifyCataloger(int oldCatNum, String newCatNum) throws SQLException {
        this.newSQL = "SELECT a.AgentID, a.FirstName, a.MiddleInitial, a.LastName FROM collectionobject co INNER JOIN agent a ON co.CatalogerID = a.AgentID WHERE CatalogNumber = '" + newCatNum + "'";
        this.oldSQL = "SELECT a.AgentID, a.FirstName, a.MiddleInitial, a.LastName, a.Name  FROM collectionobjectcatalog cc INNER JOIN agent a ON cc.CatalogerID = a.AgentID WHERE cc.SubNumber = 0 AND CatalogNumber = " + oldCatNum;
        if (this.debug) {
            log.debug((Object)("New SQL: " + this.newSQL));
            log.debug((Object)("Old SQL: " + this.oldSQL));
        }
        StatusType status = this.compareRecords("Cataloger", oldCatNum, newCatNum, this.oldSQL, this.newSQL);
        this.dumpStatus(status);
        return status == StatusType.COMPARE_OK;
    }

    private boolean verifyCollector(int oldCatNum, String newCatNum) throws SQLException {
        this.newSQL = "SELECT a.AgentID, a.FirstName, a.MiddleInitial, a.LastName FROM collectionobject AS co INNER Join collectingevent AS ce ON co.CollectingEventID = ce.CollectingEventID INNER Join collector AS c ON ce.CollectingEventID = c.CollectingEventID INNER Join agent AS a ON c.AgentID = a.AgentID WHERE co.CatalogNumber =  '" + newCatNum + "' ORDER BY OrderNumber, c.TimestampCreated, a.LastName";
        this.oldSQL = "SELECT a.AgentID, a.FirstName, a.MiddleInitial, a.LastName, a.Name FROM collectionobjectcatalog AS cc INNER Join collectionobject AS co ON cc.CollectionObjectCatalogID = co.CollectionObjectID INNER Join collectingevent AS ce ON co.CollectingEventID = ce.CollectingEventID INNER Join collectors AS c ON ce.CollectingEventID = c.CollectingEventID INNER Join agent AS a ON c.AgentID = a.AgentID WHERE cc.CatalogNumber = " + oldCatNum + " ORDER BY `Order`, c.TimestampCreated, a.LastName, a.Name";
        if (this.debug) {
            log.debug((Object)("New SQL: " + this.newSQL));
            log.debug((Object)("Old SQL: " + this.oldSQL));
        }
        StatusType status = this.compareRecords("Collector", oldCatNum, newCatNum, this.oldSQL, this.newSQL);
        this.dumpStatus(status);
        return status == StatusType.COMPARE_OK;
    }

    private boolean verifyDeterminer(int oldCatNum, String newCatNum) throws SQLException {
        this.newSQL = "SELECT a.AgentID, a.FirstName, a.MiddleInitial, a.LastName FROM collectionobject co INNER JOIN determination ON co.CollectionObjectID = determination.CollectionObjectID INNER JOIN agent a ON determination.DeterminerID = a.AgentID WHERE CatalogNumber = '" + newCatNum + "'";
        this.oldSQL = "SELECT a.AgentID, a.FirstName, a.MiddleInitial, a.LastName, a.Name  FROM collectionobjectcatalog cc INNER JOIN collectionobject co ON cc.CollectionObjectCatalogID = co.CollectionObjectID INNER JOIN determination ON determination.BiologicalObjectID = co.CollectionObjectID INNER JOIN agent a ON determination.DeterminerID = a.AgentID WHERE cc.SubNumber > -1 AND CatalogNumber = " + oldCatNum;
        if (this.debug) {
            log.debug((Object)("New SQL: " + this.newSQL));
            log.debug((Object)("Old SQL: " + this.oldSQL));
        }
        StatusType status = this.compareRecords("Determiner", oldCatNum, newCatNum, this.oldSQL, this.newSQL);
        this.dumpStatus(status);
        return status == StatusType.COMPARE_OK;
    }

    private boolean verifyPreparer(int oldCatNum, String newCatNum) throws SQLException {
        this.newSQL = "SELECT a.AgentID, a.FirstName, a.MiddleInitial, a.LastName FROM collectionobject co INNER JOIN preparation p ON co.CollectionObjectID = p.CollectionObjectID INNER JOIN agent a ON p.PreparedByID = a.AgentID WHERE CatalogNumber = '" + newCatNum + "'";
        this.oldSQL = "SELECT a.AgentID, a.FirstName, a.MiddleInitial, a.LastName, a.Name  FROM collectionobjectcatalog cc INNER JOIN collectionobject co ON cc.CollectionObjectCatalogID = co.DerivedFromID INNER JOIN preparation p ON co.CollectionObjectID = p.PhysicalObjectTypeID INNER JOIN agent a ON p.PreparedByID = a.AgentID WHERE cc.SubNumber > -1 AND CatalogNumber = " + oldCatNum;
        if (this.debug) {
            log.debug((Object)("New SQL: " + this.newSQL));
            log.debug((Object)("Old SQL: " + this.oldSQL));
        }
        StatusType status = this.compareRecords("Preparer", oldCatNum, newCatNum, this.oldSQL, this.newSQL);
        this.dumpStatus(status);
        return status == StatusType.COMPARE_OK;
    }

    private boolean verifyTaxonCitations(int oldCatNum, String newCatNum) throws SQLException {
        this.newSQL = "SELECT t.TaxonID, t.Name, tc.Text1, tc.Text2, tc.Number1, tc.Number2, tc.YesNo1, tc.YesNo2, rw.ReferenceWorkType, rw.Title, rw.Publisher, rw.PlaceOfPublication, rw.Volume, rw.Pages, rw.LibraryNumber FROM collectionobject co INNER JOIN determination d ON co.CollectionObjectID = d.CollectionObjectID INNER JOIN taxon t ON d.TaxonID = t.TaxonID INNER JOIN taxoncitation tc ON t.TaxonID = tc.TaxonID INNER JOIN referencework rw ON tc.ReferenceWorkID = rw.ReferenceWorkID WHERE CatalogNumber = '" + newCatNum + "'";
        this.oldSQL = "SELECT t.TaxonNameID, t.TaxonName, tc.Text1, tc.Text2, tc.Number1, tc.Number2, tc.YesNo1, tc.YesNo2, rw.ReferenceWorkType, rw.Title, rw.Publisher, rw.PlaceOfPublication, rw.Volume, rw.Pages, rw.LibraryNumber FROM collectionobjectcatalog cc INNER JOIN determination d ON cc.CollectionObjectCatalogID = d.BiologicalObjectID INNER JOIN taxonname t ON d.TaxonNameID = t.TaxonNameID INNER JOIN taxoncitation tc ON t.TaxonNameID = tc.TaxonNameID INNER JOIN referencework rw ON tc.ReferenceWorkID = rw.ReferenceWorkID WHERE cc.SubNumber > -1 AND CatalogNumber = " + oldCatNum;
        if (this.debug) {
            log.debug((Object)("New SQL: " + this.newSQL));
            log.debug((Object)("Old SQL: " + this.oldSQL));
        }
        StatusType status = this.compareRecords("TaxonCitation", oldCatNum, newCatNum, this.oldSQL, this.newSQL);
        this.dumpStatus(status);
        return status == StatusType.COMPARE_OK;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean verifyAllLocalityToGeo() throws SQLException {
        this.newSQL = "SELECT l.LocalityID, g.GeographyID, g.Name FROM locality l INNER JOIN geography g ON l.GeographyID = g.GeographyID ";
        this.oldSQL = "SELECT l.LocalityID, g.GeographyID, g.GeographyID, g.ContinentOrOcean, g.Country, g.State, g.County FROM locality l INNER JOIN geography g ON l.GeographyID = g.GeographyID ";
        try {
            this.getResultSets(this.oldSQL, this.newSQL);
            boolean hasOldRec = this.oldDBRS.next();
            boolean hasNewRec = this.newDBRS.next();
            String[] names = new String[4];
            int startInx = 3;
            while (hasOldRec && hasNewRec) {
                String newGeoName = this.newDBRS.getString(startInx);
                int i = 0;
                while (i < names.length) {
                    names[i] = this.oldDBRS.getString(i + startInx);
                    ++i;
                }
                boolean fnd = true;
                int i2 = names.length - 1;
                while (i2 >= 0) {
                    if (names[i2] != null && !newGeoName.equalsIgnoreCase(names[i2])) {
                        fnd = false;
                    }
                    --i2;
                }
                if (!fnd) {
                    log.error((Object)("Couldn't find new Geo Name[" + newGeoName + "]  Loc NewId[" + this.newDBRS.getObject(1) + "]  Loc Old Id[" + this.oldDBRS.getObject(1) + "]"));
                    log.error((Object)("  Geo NewId[" + this.newDBRS.getObject(2) + "]  Geo Old Id[" + this.oldDBRS.getObject(2) + "]"));
                    i2 = names.length - 1;
                    while (i2 >= 0) {
                        log.error((Object)("  [" + names[i2] + "]"));
                        --i2;
                    }
                }
                hasOldRec = this.oldDBRS.next();
                hasNewRec = this.newDBRS.next();
                if (!hasOldRec && !hasNewRec) {
                    return true;
                }
                if (!hasOldRec) {
                    log.error((Object)("Geography - No Old Record for [" + this.newDBRS.getObject(1) + "]"));
                    return false;
                }
                if (hasNewRec) continue;
                log.error((Object)("Geography - No New Record for [" + this.oldDBRS.getObject(1) + "]"));
                return false;
            }
            return false;
        }
        finally {
            this.doneWithRS();
        }
    }

    private boolean verifyCollectingEvent(int oldCatNum, String newCatNum, boolean nullsAreOK) throws SQLException {
        this.newSQL = "SELECT ce.CollectingEventID, ce.StartDate, ce.StartDatePrecision, ce.StationFieldNumber FROM collectionobject co INNER JOIN collectingevent ce ON co.CollectingEventID = ce.CollectingEventID WHERE CatalogNumber = '" + newCatNum + "'";
        this.oldSQL = "SELECT ce.CollectingEventID, ce.StartDate, ce.StationFieldNumber  FROM collectionobjectcatalog cc INNER JOIN collectionobject co ON cc.CollectionObjectCatalogID = co.CollectionObjectID INNER JOIN collectingevent ce ON co.CollectingEventID = ce.CollectingEventID WHERE cc.SubNumber > -1 AND CatalogNumber = " + oldCatNum;
        StatusType status = this.compareRecords("CE To  Locality", oldCatNum, newCatNum, this.oldSQL, this.newSQL);
        this.dumpStatus(status);
        return status == StatusType.COMPARE_OK;
    }

    private boolean verifyPreparation(int oldCatNum, String newCatNum) throws SQLException {
        this.newSQL = "SELECT co.CollectionObjectID, p.CountAmt, preptype.Name, p.Text1, p.Text2 FROM collectionobject co INNER JOIN preparation p ON co.CollectionObjectID = p.CollectionObjectID INNER JOIN preptype ON p.PrepTypeID = preptype.PrepTypeID WHERE CatalogNumber = '" + newCatNum + "' ORDER BY preptype.Name, p.TimestampCreated";
        this.oldSQL = "SELECT cc.CollectionObjectCatalogID, co.Count, co.PreparationMethod, co.Text1, co.Text2 FROM collectionobject co INNER JOIN collectionobjectcatalog cc ON co.DerivedFromID = cc.CollectionObjectCatalogID WHERE cc.SubNumber > -1 AND co.CollectionObjectTypeID > 20 AND CatalogNumber = " + oldCatNum + "  ORDER BY co.PreparationMethod, co.TimestampCreated";
        StatusType status = this.compareRecords("Preparation", oldCatNum, newCatNum, this.oldSQL, this.newSQL);
        this.dumpStatus(status);
        return status == StatusType.COMPARE_OK;
    }

    private boolean verifyAccessions(String oldAccNum, String newAccNum) throws SQLException {
        this.newSQL = "SELECT AccessionID, AccessionNumber, Status, Type, VerbatimDate, DateAccessioned, DateReceived, Number1, Number2, YesNo1, YesNo2 FROM accession  WHERE AccessionNumber = \"" + newAccNum + "\"";
        this.oldSQL = "SELECT AccessionID, Number, Status, Type, VerbatimDate, DateAccessioned, DateReceived, Number1, Number2, YesNo1, YesNo2 FROM accession WHERE Number = \"" + oldAccNum + "\"";
        StatusType status = this.compareRecords("Accession", oldAccNum, newAccNum, this.oldSQL, this.newSQL, false);
        this.dumpStatus(status);
        return status == StatusType.COMPARE_OK;
    }

    private boolean verifyAccessionAgents(String oldAccNum, String newAccNum) throws SQLException {
        this.newSQL = "SELECT ac.AccessionID, aa.Role, a.FirstName, a.MiddleInitial, a.LastName FROM accession ac INNER JOIN accessionagent aa ON ac.AccessionID = aa.AccessionID INNER JOIN agent a ON aa.AgentID = a.AgentID  WHERE ac.AccessionNumber = '" + newAccNum + "' ORDER BY aa.Role, aa.TimestampCreated,  a.LastName";
        this.oldSQL = "SELECT ac.AccessionID, aa.Role, a.FirstName, a.MiddleInitial, a.LastName, a.Name FROM accession ac INNER JOIN accessionagents aa ON ac.AccessionID = aa.AccessionID INNER JOIN agentaddress ON aa.AgentAddressID = agentaddress.AgentAddressID INNER JOIN agent a ON agentaddress.AgentID = a.AgentID WHERE ac.Number = '" + oldAccNum + "' ORDER BY aa.Role, aa.TimestampCreated, a.Name, a.LastName";
        StatusType status = this.compareRecords("Accession", oldAccNum, newAccNum, this.oldSQL, this.newSQL, false);
        this.dumpStatus(status);
        return status == StatusType.COMPARE_OK;
    }

    private void getResultSets(String oldSQLArg, String newSQLArg) throws SQLException {
        try {
            this.newDBRS = this.newDBStmt.executeQuery(newSQLArg);
            this.oldDBRS = this.oldDBStmt.executeQuery(this.compareTo6DBs ? newSQLArg : oldSQLArg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doneWithRS() throws SQLException {
        this.newDBRS.close();
        this.oldDBRS.close();
    }

    public static String convertCatNum(int oldCatNum) {
        int size = 9;
        String fmt = size == 0 ? "%d" : "%0" + size + "d";
        return String.format(fmt, oldCatNum);
    }

    private StatusType compareRecords(String desc, int oldCatNum, String newCatNum, String oldSQLArg, String newSQLArg) throws SQLException {
        return this.compareRecords(desc, Integer.toString(oldCatNum), newCatNum, oldSQLArg, newSQLArg, false);
    }

    private void dump(String desc, Connection conn, String sql) {
        System.out.println("----- " + desc + "-----");
        System.out.println(sql);
        Iterator<Object[]> iterator = BasicSQLUtils.query(conn, sql).iterator();
        while (iterator.hasNext()) {
            Object[] rows;
            Object[] objectArray = rows = iterator.next();
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                System.out.print(obj);
                System.out.print(", ");
                ++n2;
            }
            System.out.println();
        }
        System.out.println("------------------------------------------");
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StatusType compareRecords(String desc, String oldCatNumArg, String newCatNumArg, String oldSQLArg, String newSQLArg, boolean nullsAreOK) throws SQLException {
        boolean dbg = false;
        if (dbg) {
            System.out.println(oldSQLArg);
            System.out.println(newSQLArg);
        }
        if (dbg) {
            System.out.println("\n" + desc);
            this.dump(desc, this.oldDBConn, this.compareTo6DBs ? newSQLArg : oldSQLArg);
            this.dump(desc, this.newDBConn, newSQLArg);
        }
        String oldCatNum = oldCatNumArg;
        String newCatNum = newCatNumArg;
        if (this.compareTo6DBs) {
            oldCatNum = newCatNumArg;
        }
        this.getResultSets(oldSQLArg, newSQLArg);
        try {
            block67: {
                StringBuilder errSB;
                Calendar cal;
                PartialDateConv datePair;
                ResultSetMetaData newRsmd;
                ResultSetMetaData oldRsmd;
                boolean checkForAgent;
                String oldNewIdStr;
                boolean hasNewRec;
                boolean hasOldRec;
                block66: {
                    hasOldRec = this.oldDBRS.next();
                    hasNewRec = this.newDBRS.next();
                    if (!hasOldRec && !hasNewRec) {
                        StatusType statusType = StatusType.COMPARE_OK;
                        return statusType;
                    }
                    if (!hasOldRec) {
                        if (nullsAreOK) {
                            log.error((Object)(String.valueOf(desc) + " - No Old Record for [" + oldCatNum + "]"));
                            this.tblWriter.logErrors(oldCatNum, "No Old Record");
                            StatusType statusType = StatusType.NO_OLD_REC;
                            return statusType;
                        }
                        StatusType statusType = StatusType.COMPARE_OK;
                        return statusType;
                    }
                    if (!hasNewRec) {
                        log.error((Object)(String.valueOf(desc) + " - No New Record for [" + newCatNum + "]"));
                        this.tblWriter.logErrors(newCatNum, "No New Record");
                        StatusType statusType = StatusType.NO_NEW_REC;
                        return statusType;
                    }
                    oldNewIdStr = String.valueOf(oldCatNum) + " / " + newCatNum;
                    checkForAgent = this.newSQL.indexOf("a.LastName") > -1;
                    oldRsmd = this.oldDBRS.getMetaData();
                    newRsmd = this.newDBRS.getMetaData();
                    datePair = new PartialDateConv();
                    cal = Calendar.getInstance();
                    errSB = new StringBuilder();
                    if (!true) break block66;
                    if (!hasNewRec) return StatusType.COMPARE_OK;
                    if (!hasOldRec) break block67;
                }
                do {
                    errSB.setLength(0);
                    int oldColInx = 0;
                    int newColInx = 0;
                    String idMsgStr = "";
                    int numCols = newRsmd.getColumnCount();
                    int col = 0;
                    while (col < numCols) {
                        block69: {
                            String oldColName;
                            Object oldObj;
                            Object newObj;
                            block73: {
                                Byte partialDateType;
                                boolean isPartialDate;
                                block74: {
                                    block72: {
                                        block71: {
                                            block70: {
                                                block68: {
                                                    ++newColInx;
                                                    ++oldColInx;
                                                    if (dbg) {
                                                        System.out.println("\ncol       " + col + " / " + oldRsmd.getColumnCount());
                                                        System.out.println("newColInx " + newColInx);
                                                        System.out.println("oldColInx " + oldColInx);
                                                        System.out.println(oldRsmd.getColumnName(oldColInx));
                                                        System.out.println(newRsmd.getColumnName(newColInx));
                                                    }
                                                    newObj = this.newDBRS.getObject(newColInx);
                                                    oldObj = this.oldDBRS.getObject(oldColInx);
                                                    if (oldObj != null || newObj != null) break block68;
                                                    String colName = newRsmd.getColumnName(newColInx);
                                                    if (StringUtils.contains((String)colName, (String)"Date") && StringUtils.contains((String)newRsmd.getColumnName(newColInx + 1), (String)"DatePrecision")) {
                                                        ++newColInx;
                                                        --numCols;
                                                        if (this.compareTo6DBs) {
                                                            ++oldColInx;
                                                        }
                                                    }
                                                    break block69;
                                                }
                                                if (col != 0) break block70;
                                                idMsgStr = String.format(" - Rec Ids[%s / %s] ", oldObj != null ? oldObj : Integer.valueOf(-1), newObj != null ? newObj : Integer.valueOf(-1));
                                                break block69;
                                            }
                                            oldColName = oldRsmd.getColumnName(oldColInx);
                                            if (!oldColName.equals("PreparationMethod") || newObj == null) break block71;
                                            String newObjStr = newObj.toString();
                                            if (oldObj == null && !newObjStr.equalsIgnoreCase("Misc") || oldObj != null && !newObjStr.equalsIgnoreCase(oldObj.toString())) {
                                                String msg = String.valueOf(idMsgStr) + "Old Value was null and shouldn't have been for Old CatNum [" + oldCatNum + "] Field [" + oldColName + "] oldObj[" + oldObj + "] newObj [" + newObj + "]";
                                                log.error((Object)(String.valueOf(desc) + " - " + msg));
                                                this.tblWriter.logErrors(oldCatNum, msg);
                                                StatusType statusType = StatusType.OLD_VAL_NULL;
                                                return statusType;
                                            }
                                            break block69;
                                        }
                                        if (!(oldObj != null || StringUtils.contains((String)oldColName, (String)"LastName") || oldColName.equals("PreparationMethod") && newObj.equals("Misc"))) {
                                            String msg = String.valueOf(idMsgStr) + "Old Value was null and shouldn't have been for Old CatNum [" + oldCatNum + "] Field [" + oldColName + "]  New Val[" + newObj + "]";
                                            log.error((Object)(String.valueOf(desc) + " - " + msg));
                                            this.tblWriter.logErrors(oldCatNum, msg);
                                            StatusType statusType = StatusType.OLD_VAL_NULL;
                                            return statusType;
                                        }
                                        if (newObj != null) break block72;
                                        String clsName = newRsmd.getColumnClassName(newColInx);
                                        String colName = newRsmd.getColumnName(newColInx);
                                        if (this.compareTo6DBs) {
                                            if (!clsName.equals("java.sql.Date") || oldObj != null) {
                                                String msg = "New Value was null and shouldn't have been for Key Value New CatNo[" + newCatNum + "] Field [" + colName + "] [" + oldObj + "]";
                                                log.error((Object)(String.valueOf(desc) + " - " + msg));
                                                this.tblWriter.logErrors(newCatNum, msg);
                                                StatusType statusType = StatusType.NEW_VAL_NULL;
                                                return statusType;
                                            }
                                        } else if (!clsName.equals("java.sql.Date") || !(oldObj instanceof String) && ((Number)oldObj).intValue() != 0) {
                                            String msg = "New Value was null and shouldn't have been for Key Value New CatNo[" + newCatNum + "] Field [" + colName + "] [" + oldObj + "]";
                                            log.error((Object)(String.valueOf(desc) + " - " + msg));
                                            this.tblWriter.logErrors(newCatNum, msg);
                                            dbg = true;
                                            StatusType statusType = StatusType.NEW_VAL_NULL;
                                            return statusType;
                                        }
                                        if (StringUtils.contains((String)colName, (String)"Date") && StringUtils.contains((String)newRsmd.getColumnName(newColInx + 1), (String)"DatePrecision")) {
                                            ++newColInx;
                                            --numCols;
                                            if (this.compareTo6DBs) {
                                                ++oldColInx;
                                            }
                                        }
                                        break block69;
                                    }
                                    if (!(newObj instanceof java.sql.Date)) break block73;
                                    isPartialDate = false;
                                    partialDateType = null;
                                    if (StringUtils.contains((String)newRsmd.getColumnName(newColInx + 1), (String)"DatePrecision")) {
                                        --numCols;
                                        partialDateType = this.newDBRS.getByte(++newColInx);
                                        isPartialDate = true;
                                    }
                                    if (!this.compareTo6DBs) break block74;
                                    Object dateObj = this.oldDBRS.getObject(oldColInx);
                                    boolean isPartialDate2 = false;
                                    Byte partialDateType2 = null;
                                    if (StringUtils.contains((String)oldRsmd.getColumnName(oldColInx + 1), (String)"DatePrecision")) {
                                        partialDateType2 = this.newDBRS.getByte(++oldColInx);
                                        isPartialDate2 = true;
                                    } else {
                                        log.error((Object)"Next isn't DatePrecision and can't be!");
                                        this.tblWriter.logErrors(oldNewIdStr, errSB.toString());
                                    }
                                    if (!newObj.equals(dateObj) || isPartialDate2 && !partialDateType2.equals(partialDateType)) {
                                        errSB.insert(0, String.valueOf(oldColName) + "  ");
                                        errSB.append("[");
                                        errSB.append(datePair);
                                        errSB.append("][");
                                        errSB.append(dateFormatter.format((Date)newObj));
                                        errSB.append("] oldDate[");
                                        errSB.append(dateFormatter.format((Date)dateObj));
                                        errSB.append("]");
                                        log.error((Object)errSB.toString());
                                        this.tblWriter.logErrors(oldNewIdStr, errSB.toString());
                                        StatusType statusType = StatusType.BAD_DATE;
                                        return statusType;
                                    }
                                    break block69;
                                }
                                int oldIntDate = this.oldDBRS.getInt(oldColInx);
                                if (oldIntDate != 0) {
                                    BasicSQLUtils.getPartialDate(oldIntDate, datePair, false);
                                    if (partialDateType != null) {
                                        boolean ok;
                                        boolean bl = ok = StringUtils.isNotEmpty((String)datePair.getPartial()) && StringUtils.isNumeric((String)datePair.getPartial());
                                        if (!ok || Byte.parseByte(datePair.getPartial()) != partialDateType) {
                                            errSB.append("Partial Dates Type do not match. Old[" + datePair.getPartial() + "]  New [" + partialDateType + "]");
                                        }
                                    }
                                    cal.setTime((Date)newObj);
                                    if (StringUtils.isNotEmpty((String)datePair.getDateStr()) && !datePair.getDateStr().equalsIgnoreCase("null")) {
                                        int year = Integer.parseInt(datePair.getDateStr().substring(0, 4));
                                        int mon = Integer.parseInt(datePair.getDateStr().substring(5, 7));
                                        int day = Integer.parseInt(datePair.getDateStr().substring(8, 10));
                                        if (mon > 0) {
                                            --mon;
                                        }
                                        boolean isYearOK = true;
                                        int yr = cal.get(1);
                                        if (year != yr) {
                                            errSB.append("Year mismatch Old[" + year + "]  New [" + yr + "] ");
                                            isYearOK = false;
                                        }
                                        if (mon != cal.get(2)) {
                                            errSB.append("Month mismatch Old[" + mon + "]  New [" + cal.get(2) + "] ");
                                        }
                                        if (day != cal.get(5)) {
                                            errSB.append("Day mismatch Old[" + day + "]  New [" + cal.get(5) + "] ");
                                        }
                                        if (!(errSB.length() <= 0 || isYearOK && isPartialDate)) {
                                            errSB.insert(0, String.valueOf(oldColName) + "  ");
                                            errSB.append("[");
                                            errSB.append(datePair);
                                            errSB.append("][");
                                            errSB.append(dateFormatter.format((Date)newObj));
                                            errSB.append("]");
                                            log.error((Object)errSB.toString());
                                            this.tblWriter.logErrors(oldNewIdStr, errSB.toString());
                                            StatusType statusType = StatusType.BAD_DATE;
                                            return statusType;
                                        }
                                    }
                                }
                                break block69;
                            }
                            if (newObj instanceof Float || newObj instanceof Double) {
                                String s1 = String.format("%10.5f", newObj instanceof Float ? (double)((Float)newObj).floatValue() : (Double)newObj);
                                String s2 = String.format("%10.5f", oldObj instanceof Float ? (double)((Float)oldObj).floatValue() : (Double)oldObj);
                                if (!s1.equals(s2)) {
                                    String msg = String.valueOf(idMsgStr) + "Columns don't compare[" + s1 + "][" + s2 + "]  [" + newRsmd.getColumnName(col) + "][" + oldRsmd.getColumnName(oldColInx) + "]";
                                    log.error((Object)(String.valueOf(desc) + " - " + msg));
                                    this.tblWriter.logErrors(oldNewIdStr, msg);
                                    StatusType statusType = StatusType.NO_COMPARE;
                                    return statusType;
                                }
                            } else {
                                String newColName = newRsmd.getColumnName(newColInx);
                                if (checkForAgent && StringUtils.contains((String)newColName, (String)"LastName")) {
                                    String lastName = this.oldDBRS.getString(oldColInx);
                                    String agentName = this.oldDBRS.getString(oldColInx + 1);
                                    String newLastName = this.newDBRS.getString(newColInx);
                                    if (!newLastName.equals(lastName) && !newLastName.equals(agentName)) {
                                        String msg = String.valueOf(idMsgStr) + "Name Columns don't compare[" + newObj + "][" + oldObj + "]  [" + newColName + "][" + oldColName + "]";
                                        log.error((Object)(String.valueOf(desc) + " - " + msg));
                                        this.tblWriter.logErrors(oldNewIdStr, msg);
                                        log.error((Object)(String.valueOf(oldSQLArg) + "\n" + newSQLArg));
                                        StatusType statusType = StatusType.NO_COMPARE;
                                        return statusType;
                                    }
                                } else if (StringUtils.contains((String)newColName, (String)"YesNo")) {
                                    boolean yesNoOld;
                                    boolean yesNoNew = this.newDBRS.getBoolean(newColInx);
                                    boolean bl = yesNoOld = this.oldDBRS.getInt(oldColInx) != 0;
                                    if (yesNoNew != yesNoOld) {
                                        String msg = String.valueOf(idMsgStr) + "Columns don't Cat Num[" + oldCatNum + "] compare[" + yesNoNew + "][" + yesNoOld + "]  [" + newColName + "][" + oldColName + "]";
                                        log.error((Object)(String.valueOf(desc) + " - " + msg));
                                        this.tblWriter.logErrors(oldNewIdStr, msg);
                                        StatusType statusType = StatusType.NO_COMPARE;
                                        return statusType;
                                    }
                                } else if (!newObj.equals(oldObj)) {
                                    String msg = String.valueOf(idMsgStr) + "Columns don't Cat Num[" + oldCatNum + "] compare[" + newObj + "][" + oldObj + "]  [" + newColName + "][" + oldColName + "]";
                                    log.error((Object)(String.valueOf(desc) + " - " + msg));
                                    this.tblWriter.logErrors(oldNewIdStr, msg);
                                    StatusType statusType = StatusType.NO_COMPARE;
                                    return statusType;
                                }
                            }
                        }
                        ++col;
                    }
                    hasOldRec = this.oldDBRS.next();
                    hasNewRec = this.newDBRS.next();
                    if (!hasOldRec && !hasNewRec) {
                        StatusType statusType = StatusType.COMPARE_OK;
                        return statusType;
                    }
                    if (!hasOldRec) {
                        log.error((Object)(String.valueOf(desc) + idMsgStr + " - No Old Record for [" + oldCatNum + "]"));
                        this.tblWriter.logErrors(oldNewIdStr, "No Old Record for [" + oldCatNum + "]");
                        StatusType statusType = StatusType.NO_OLD_REC;
                        return statusType;
                    }
                    if (!hasNewRec) {
                        log.error((Object)(String.valueOf(desc) + idMsgStr + " No New Record for [" + newCatNum + "]"));
                        this.tblWriter.logErrors(oldNewIdStr, "No New Record for [" + newCatNum + "]");
                        StatusType statusType = StatusType.NO_NEW_REC;
                        return statusType;
                    }
                    if (!hasNewRec) return StatusType.COMPARE_OK;
                } while (hasOldRec);
            }
            return StatusType.COMPARE_OK;
        }
        finally {
            this.doneWithRS();
        }
    }

    private StatusType compareDates(String oldNewIdStr, int newColInx, int oldColInx) throws SQLException {
        PartialDateConv datePair = new PartialDateConv();
        Object newObj = this.newDBRS.getObject(newColInx);
        Object oldObj = this.oldDBRS.getObject(oldColInx);
        ResultSetMetaData newRsmd = this.newDBRS.getMetaData();
        ResultSetMetaData oldRsmd = this.oldDBRS.getMetaData();
        String newColName = newRsmd.getColumnName(newColInx);
        String oldColName = oldRsmd.getColumnName(oldColInx);
        if (newObj == null) {
            String clsName = newRsmd.getColumnClassName(newColInx);
            if (this.compareTo6DBs) {
                if (!clsName.equals("java.sql.Date") || oldObj != null) {
                    String msg = "New Value was null and shouldn't have been for Key Value New  Field [" + newColName + "] [" + oldObj + "]";
                    log.error((Object)msg);
                    this.tblWriter.logErrors(newColName, msg);
                    return StatusType.NEW_VAL_NULL;
                }
            } else if (oldObj != null) {
                if (oldObj instanceof Number && ((Number)oldObj).intValue() == 0) {
                    return StatusType.COMPARE_OK;
                }
                if (!clsName.equals("java.sql.Date") || !(oldObj instanceof String) && ((Number)oldObj).intValue() != 0) {
                    String msg = "New Value was null and shouldn't have been for Key Value New Field [" + newColName + "] [" + oldObj + "]";
                    log.error((Object)msg);
                    this.tblWriter.logErrors(newColName, msg);
                    return StatusType.NEW_VAL_NULL;
                }
            } else {
                return StatusType.COMPARE_OK;
            }
        }
        StringBuilder errSB = new StringBuilder();
        if (newObj instanceof java.sql.Date) {
            boolean isPartialDate = false;
            Byte partialDateType = null;
            if (StringUtils.contains((String)newRsmd.getColumnName(newColInx + 1), (String)"DatePrecision")) {
                partialDateType = this.newDBRS.getByte(newColInx);
                isPartialDate = true;
            }
            if (this.compareTo6DBs) {
                Object dateObj = this.oldDBRS.getObject(oldColInx);
                boolean isPartialDate2 = false;
                Byte partialDateType2 = null;
                if (StringUtils.contains((String)oldRsmd.getColumnName(oldColInx + 1), (String)"DatePrecision")) {
                    partialDateType2 = this.newDBRS.getByte(oldColInx);
                    isPartialDate2 = true;
                } else {
                    log.error((Object)"Next isn't DatePrecision and can't be!");
                    this.tblWriter.logErrors(oldNewIdStr, errSB.toString());
                }
                if (!newObj.equals(dateObj) || isPartialDate2 && !partialDateType2.equals(partialDateType)) {
                    errSB.insert(0, String.valueOf(oldColName) + "  ");
                    errSB.append("[");
                    errSB.append(datePair);
                    errSB.append("][");
                    errSB.append(dateFormatter.format((Date)newObj));
                    errSB.append("] oldDate[");
                    errSB.append(dateFormatter.format((Date)dateObj));
                    errSB.append("]");
                    log.error((Object)errSB.toString());
                    this.tblWriter.logErrors(oldNewIdStr, errSB.toString());
                    return StatusType.BAD_DATE;
                }
            } else {
                int oldIntDate = this.oldDBRS.getInt(oldColInx);
                if (oldIntDate == 0) {
                    return StatusType.NO_OLD_REC;
                }
                BasicSQLUtils.getPartialDate(oldIntDate, datePair, false);
                if (partialDateType != null && Byte.parseByte(datePair.getPartial()) != partialDateType) {
                    errSB.append("Partial Dates Type do not match. Old[" + datePair.getPartial() + "]  New [" + partialDateType + "]");
                }
                Calendar cal = Calendar.getInstance();
                cal.setTime((Date)newObj);
                int year = Integer.parseInt(datePair.getDateStr().substring(0, 4));
                int mon = Integer.parseInt(datePair.getDateStr().substring(5, 7));
                int day = Integer.parseInt(datePair.getDateStr().substring(8, 10));
                if (mon > 0) {
                    --mon;
                }
                boolean isYearOK = true;
                int yr = cal.get(1);
                if (year != yr) {
                    errSB.append("Year mismatch Old[" + year + "]  New [" + yr + "] ");
                    isYearOK = false;
                }
                if (mon != cal.get(2)) {
                    errSB.append("Month mismatch Old[" + mon + "]  New [" + cal.get(2) + "] ");
                }
                if (day != cal.get(5)) {
                    errSB.append("Day mismatch Old[" + day + "]  New [" + cal.get(5) + "] ");
                }
                if (!(errSB.length() <= 0 || isYearOK && isPartialDate)) {
                    errSB.insert(0, String.valueOf(oldColName) + "  ");
                    errSB.append("[");
                    errSB.append(datePair);
                    errSB.append("][");
                    errSB.append(dateFormatter.format((Date)newObj));
                    errSB.append("]");
                    log.error((Object)errSB.toString());
                    this.tblWriter.logErrors(oldNewIdStr, errSB.toString());
                    return StatusType.BAD_DATE;
                }
            }
        }
        return StatusType.COMPARE_OK;
    }

    private void compareNames(String oldNewIdStr, int startInxNewArg, int startInxOldArg) throws SQLException {
        String msg;
        String newFirstName = this.newDBRS.getString(startInxNewArg);
        String newLastName = this.newDBRS.getString(startInxNewArg + 1);
        String oldFirstName = this.oldDBRS.getString(startInxOldArg);
        String oldLastName = this.oldDBRS.getString(startInxOldArg + 1);
        String oldName = this.oldDBRS.getString(startInxOldArg + 2);
        if (StringUtils.isNotEmpty((String)oldName) && StringUtils.isEmpty((String)oldLastName)) {
            oldLastName = oldName;
        }
        if (oldFirstName == null && oldLastName == null && oldName != null) {
            oldLastName = oldName;
        }
        if (oldFirstName == null && newFirstName != null) {
            msg = "Old FirstName[" + oldFirstName + "] is NULL   New FirstName[" + newFirstName + "] is not";
            log.error((Object)(String.valueOf(oldNewIdStr) + " " + msg));
            this.tblWriter.logErrors(oldNewIdStr, msg);
        } else if (oldFirstName != null && newFirstName == null) {
            msg = "Old FirstName[" + oldFirstName + "] is not null   New FirstName[" + newFirstName + "] is NULL";
            log.error((Object)(String.valueOf(oldNewIdStr) + " " + msg));
            this.tblWriter.logErrors(oldNewIdStr, msg);
        }
        if (oldFirstName != null && newFirstName != null && !oldFirstName.equals(newFirstName)) {
            msg = "Old FirstName[" + oldFirstName + "] is NOT equals   New FirstName[" + newFirstName + "]";
            log.error((Object)(String.valueOf(oldNewIdStr) + " " + msg));
            this.tblWriter.logErrors(oldNewIdStr, msg);
        }
        if (oldLastName == null && newLastName != null) {
            msg = "Old LastName[" + oldLastName + "] is NULL   New LastName[" + newLastName + "] is not";
            log.error((Object)(String.valueOf(oldNewIdStr) + " " + msg));
            this.tblWriter.logErrors(oldNewIdStr, msg);
        } else if (oldLastName != null && newLastName == null) {
            msg = "Old LastName[" + oldLastName + "] is not null   New LastName[" + newLastName + "] is NULL";
            log.error((Object)(String.valueOf(oldNewIdStr) + " " + msg));
            this.tblWriter.logErrors(oldNewIdStr, msg);
        } else if (oldLastName != null && newLastName != null && !oldLastName.equals(newLastName)) {
            msg = "Old LastName[" + oldLastName + "] is NOT equals   New LastName[" + newLastName + "]";
            log.error((Object)(String.valueOf(oldNewIdStr) + " " + msg));
            this.tblWriter.logErrors(oldNewIdStr, msg);
        }
    }

    private void compareStrings(String oldNewIdStr, String colName, int startInxNewArg, int startInxOldArg) throws SQLException {
        String newStr = this.newDBRS.getString(startInxNewArg);
        String oldStr = this.oldDBRS.getString(startInxOldArg);
        if (oldStr == null && newStr == null) {
            return;
        }
        if (oldStr == null && newStr != null) {
            String msg = "Old " + colName + " [" + oldStr + "] is NULL   New " + colName + "[" + newStr + "] is not";
            log.error((Object)(String.valueOf(oldNewIdStr) + " " + msg));
            this.tblWriter.logErrors(oldNewIdStr, msg);
        } else if (oldStr != null && newStr == null) {
            String msg = "Old " + colName + "[" + oldStr + "] is not null   New " + colName + "[" + newStr + "] is NULL";
            log.error((Object)(String.valueOf(oldNewIdStr) + " " + msg));
            this.tblWriter.logErrors(oldNewIdStr, msg);
        } else if (!oldStr.equals(newStr)) {
            String msg = "Old " + colName + "[" + oldStr + "] is not equal   New " + colName + "[" + newStr + "]";
            log.error((Object)(String.valueOf(oldNewIdStr) + " " + msg));
            this.tblWriter.logErrors(oldNewIdStr, msg);
        }
    }

    private void compareBoolean(String oldNewIdStr, String colName, int startInxNewArg, int startInxOldArg) throws SQLException {
        boolean oldBool;
        boolean newBool = this.newDBRS.getBoolean(startInxNewArg);
        if (newBool != (oldBool = this.oldDBRS.getBoolean(startInxOldArg))) {
            String msg = "Old " + colName + "[" + oldBool + "] is not null   New " + colName + "[" + newBool + "] is NULL";
            log.error((Object)(String.valueOf(oldNewIdStr) + " " + msg));
            this.tblWriter.logErrors(oldNewIdStr, msg);
        }
    }

    private void compareNumber(String oldNewIdStr, String colName, int startInxNewArg, int startInxOldArg) throws SQLException {
        Integer newInt = (Integer)this.newDBRS.getObject(startInxNewArg);
        Integer oldInt = (Integer)this.oldDBRS.getObject(startInxOldArg);
        if (oldInt == null && newInt == null) {
            return;
        }
        if (oldInt == null && newInt != null) {
            String msg = "Old " + colName + " [" + oldInt + "] is NULL New " + colName + "[" + newInt + "] is not";
            log.error((Object)(String.valueOf(oldNewIdStr) + " " + msg));
            this.tblWriter.logErrors(oldNewIdStr, msg);
        } else if (oldInt != null && newInt == null) {
            String msg = "Old " + colName + "[" + oldInt + "] is not null New " + colName + "[" + newInt + "] is NULL";
            log.error((Object)(String.valueOf(oldNewIdStr) + " " + msg));
            this.tblWriter.logErrors(oldNewIdStr, msg);
        } else if (!oldInt.equals(newInt)) {
            String msg = "Old " + colName + "[" + oldInt + "] is not equal New " + colName + "[" + newInt + "]";
            log.error((Object)(String.valueOf(oldNewIdStr) + " " + msg));
            this.tblWriter.logErrors(oldNewIdStr, msg);
        }
    }

    private void verifyCollectors() {
        boolean dbg = true;
        IdTableMapper ceIdMapper = this.idMapperMgr.addTableMapper("collectingevent", "CollectingEventID", false);
        this.oldSQL = "SELECT ce.CollectingEventID, a.FirstName,  a.LastName, a.Name, collectors.Order  FROM collectingevent ce INNER JOIN collectors ON ce.CollectingEventID = collectors.CollectingEventID INNER JOIN agent a ON collectors.AgentID = a.AgentID ORDER BY ce.CollectingEventID, collectors.Order";
        this.newSQL = "SELECT ce.CollectingEventID, a.FirstName, a.LastName, collector.OrderNumber   FROM collectingevent ce INNER JOIN collector ON ce.CollectingEventID = collector.CollectingEventID  INNER JOIN agent a ON collector.AgentID = a.AgentID WHERE ce.CollectingEventID = %d ORDER BY collector.OrderNumber ";
        int prevOldId = Integer.MAX_VALUE;
        int prevNewId = Integer.MAX_VALUE;
        try {
            this.oldDBRS = this.oldDBStmt.executeQuery(this.oldSQL);
            if (dbg) {
                System.out.println(this.oldSQL);
            }
            while (this.oldDBRS.next()) {
                String msg;
                boolean isOldNextCE;
                int oldId = this.oldDBRS.getInt(1);
                Integer newId = ceIdMapper.get(oldId);
                String oldNewIdStr = String.valueOf(oldId) + " / " + newId;
                if (newId == null) {
                    String msg2 = "No New Id from mapping New [" + newId + "]";
                    log.error((Object)msg2);
                    this.tblWriter.logErrors(oldNewIdStr, msg2);
                    continue;
                }
                String sql = String.format(this.newSQL, newId);
                if (dbg) {
                    System.out.println(sql);
                }
                this.newDBRS = this.newDBStmt.executeQuery(sql);
                if (!this.newDBRS.next()) {
                    String msg3 = "No New record  New [" + newId + "] from Old[" + oldId + "]";
                    log.error((Object)msg3);
                    this.tblWriter.logErrors(oldNewIdStr, msg3);
                    continue;
                }
                int newOrder = this.newDBRS.getInt(4);
                int oldOrder = this.oldDBRS.getInt(5);
                if (newId == Integer.MAX_VALUE) {
                    prevNewId = newId;
                }
                if (oldId == Integer.MAX_VALUE) {
                    prevOldId = oldId;
                }
                boolean isNewNextCE = prevNewId != newId;
                boolean bl = isOldNextCE = prevOldId != oldId;
                if (isNewNextCE != isOldNextCE) {
                    msg = "The is a mismatch in the number of Collectors for Old[" + oldId + "]  New [" + newId + "] Old[" + isOldNextCE + "]  New [" + isNewNextCE + "] ";
                    log.error((Object)msg);
                    this.tblWriter.logErrors(oldNewIdStr, msg);
                    break;
                }
                this.compareNames(oldNewIdStr, 2, 2);
                if (oldOrder == newOrder) continue;
                msg = "Old Order[" + oldOrder + "] is not equal [" + newOrder + "]";
                log.error((Object)(String.valueOf(oldNewIdStr) + " " + msg));
                this.tblWriter.logErrors(oldNewIdStr, msg);
            }
            this.oldDBRS.close();
            this.newDBRS.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private void verifyCEs() {
        this.newSQL = "SELECT c.CollectingEventID, c.StartTime, l.LocalityName, l.Latitude1, l.Longitude1, g.Name FROM collectingevent c LEFT JOIN locality l ON c.LocalityID = l.LocalityID LEFT JOIN geography g ON l.GeographyID = g.GeographyID ORDER BY c.CollectingEventID";
        this.oldSQL = "SELECT c.CollectingEventID, c.StartTime, l.LocalityName, l.Latitude1, l.Longitude1, g.ContinentOrOcean, g.Country, g.State,  g.County, g.IslandGroup, g.Island, g.WaterBody, g.Drainage FROM collectingevent c LEFT JOIN locality l ON c.LocalityID = l.LocalityID LEFT JOIN geography g ON l.GeographyID = g.GeographyID ORDER BY c.CollectingEventID";
        String newCntSQL = "SELECT count(*) FROM collectingevent c LEFT JOIN locality l ON c.LocalityID = l.LocalityID LEFT JOIN geography g ON l.GeographyID = g.GeographyID ORDER BY c.CollectingEventID";
        String oldCntSQL = "SELECT count(*) FROM collectingevent c LEFT JOIN locality l ON c.LocalityID = l.LocalityID LEFT JOIN geography g ON l.GeographyID = g.GeographyID ORDER BY c.CollectingEventID";
        log.info((Object)newCntSQL);
        log.info((Object)oldCntSQL);
        log.info((Object)this.newSQL);
        log.info((Object)this.oldSQL);
        Integer oldCnt = BasicSQLUtils.getCount(oldCntSQL);
        Integer newCnt = BasicSQLUtils.getCount(newCntSQL);
        String msg2 = "Record Counts [" + oldCnt + " / " + newCnt + "]";
        log.info((Object)msg2);
        this.tblWriter.flush();
        try {
            this.getResultSets(this.oldSQL, this.newSQL);
            while (true) {
                boolean hasOldRec = this.oldDBRS.next();
                boolean hasNewRec = this.newDBRS.next();
                if (!hasOldRec || !hasNewRec) break;
                int col = 1;
                int newId = this.newDBRS.getInt(col++);
                Integer newStartTime = this.newDBRS.getInt(col++);
                String newLocalityName = this.newDBRS.getString(col++);
                Object bigDecObj = this.newDBRS.getObject(col);
                BigDecimal newLatitude = bigDecObj == null ? null : this.newDBRS.getBigDecimal(col);
                bigDecObj = this.newDBRS.getObject(++col);
                BigDecimal newLongitude = bigDecObj == null ? null : this.newDBRS.getBigDecimal(col);
                int n = ++col;
                ++col;
                String newGeoName = this.newDBRS.getString(n);
                col = 1;
                int oldId = this.oldDBRS.getInt(col++);
                Integer oldStartTime = this.oldDBRS.getInt(col++);
                String oldLocalityName = this.oldDBRS.getString(col++);
                bigDecObj = this.newDBRS.getObject(col);
                Double oldLatitude = bigDecObj == null ? null : Double.valueOf(this.oldDBRS.getDouble(col));
                bigDecObj = this.newDBRS.getObject(++col);
                Double oldLongitude = bigDecObj == null ? null : Double.valueOf(this.oldDBRS.getDouble(col));
                ++col;
                String oldNewIdStr = String.valueOf(oldId) + " / " + newId;
                if (newGeoName != null && !newGeoName.equals("Undefined")) {
                    boolean fnd = false;
                    int i = 6;
                    while (i < 14) {
                        String name = this.oldDBRS.getString(i);
                        if (name != null && name.equalsIgnoreCase(newGeoName)) {
                            fnd = true;
                            break;
                        }
                        ++i;
                    }
                    if (!fnd) {
                        String msg = "No match found for new Geo [" + newGeoName + "] [" + oldId + " / " + newId + "]";
                        log.error((Object)msg);
                        this.tblWriter.logErrors(oldNewIdStr, msg);
                    }
                }
                if (oldStartTime == null && newStartTime != null) {
                    String msg = "LocName[" + oldId + " / " + newId + "]  Old StartTime[" + oldStartTime + "] is NULL   New StartTime[" + newStartTime + "] is not";
                    log.error((Object)msg);
                    this.tblWriter.logErrors(oldNewIdStr, msg);
                } else if (oldStartTime != null && newStartTime == null) {
                    String msg = "LocName[" + oldId + " / " + newId + "]  Old StartTime[" + oldStartTime + "] is not null   New StartTime[" + newStartTime + "] is NULL";
                    log.error((Object)msg);
                    this.tblWriter.logErrors(oldNewIdStr, msg);
                } else if (oldStartTime != null && newStartTime != null && !oldStartTime.equals(newStartTime)) {
                    String msg = "LocName[" + oldId + " / " + newId + "]  Old StartTime[" + oldStartTime + "] is NOT equals   New StartTime[" + newStartTime + "]";
                    log.error((Object)msg);
                    this.tblWriter.logErrors(oldNewIdStr, msg);
                }
                if (oldLocalityName == null && newLocalityName != null) {
                    String msg = "LocName[" + oldId + " / " + newId + "]  Old LocalityName[" + oldLocalityName + "] is NULL   New LocalityName[" + newLocalityName + "] is not";
                    log.error((Object)msg);
                    this.tblWriter.logErrors(oldNewIdStr, msg);
                } else if (oldLocalityName != null && newLocalityName == null) {
                    String msg = "LocName[" + oldId + " / " + newId + "]  Old LocalityName[" + oldLocalityName + "] is not null   New LocalityName[" + newLocalityName + "] is NULL";
                    log.error((Object)msg);
                    this.tblWriter.logErrors(oldNewIdStr, msg);
                } else if (oldLocalityName != null && newLocalityName != null && !oldLocalityName.equals(newLocalityName)) {
                    String msg = "LocName[" + oldId + " / " + newId + "]  Old LocalityName[" + oldLocalityName + "] is NOT equals   New LocalityName[" + newLocalityName + "]";
                    log.error((Object)msg);
                    this.tblWriter.logErrors(oldNewIdStr, msg);
                }
                if (oldLatitude == null && newLatitude != null) {
                    String msg = "Latitude[" + oldId + " / " + newId + "]  Old Latitude[" + oldLatitude + "] is NULL   New Latitude[" + newLatitude + "] is not";
                    log.error((Object)msg);
                    this.tblWriter.logErrors(oldNewIdStr, msg);
                } else if (oldLatitude != null && newLatitude == null) {
                    String msg = "Latitude[" + oldId + " / " + newId + "]  Old Latitude[" + oldLatitude + "] is not null   New Latitude[" + newLatitude + "] is NULL";
                    log.error((Object)msg);
                    this.tblWriter.logErrors(oldNewIdStr, msg);
                } else if (oldLatitude != null && newLatitude != null && !oldLatitude.equals(newLatitude.doubleValue())) {
                    String msg = "Latitude[" + oldId + " / " + newId + "]  Old Latitude[" + oldLatitude + "] is NOT equals   New Latitude[" + newLatitude + "]";
                    log.error((Object)msg);
                    this.tblWriter.logErrors(oldNewIdStr, msg);
                }
                if (oldLongitude == null && newLongitude != null) {
                    String msg = "Longitude[" + oldId + " / " + newId + "]  Old Longitude[" + oldLongitude + "] is NULL   New Longitude[" + newLongitude + "] is not";
                    log.error((Object)msg);
                    this.tblWriter.logErrors(oldNewIdStr, msg);
                    continue;
                }
                if (oldLongitude != null && newLongitude == null) {
                    String msg = "Longitude[" + oldId + " / " + newId + "]  Old Longitude[" + oldLongitude + "] is not null   New Longitude[" + newLongitude + "] is NULL";
                    log.error((Object)msg);
                    this.tblWriter.logErrors(oldNewIdStr, msg);
                    continue;
                }
                if (oldLongitude == null || newLongitude == null || oldLongitude.equals(newLongitude.doubleValue())) continue;
                String msg = "Longitude[" + oldId + " / " + newId + "]  Old Longitude[" + oldLongitude + "] is NOT equals   New Longitude[" + newLongitude + "]";
                log.error((Object)msg);
                this.tblWriter.logErrors(oldNewIdStr, msg);
            }
            this.oldDBRS.close();
            this.newDBRS.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean compareStr(String oldStr, String newStr) {
        if (oldStr == null && newStr == null) {
            return true;
        }
        if (oldStr == null || newStr == null) {
            return false;
        }
        return oldStr.equals(newStr);
    }

    private void verifyAgents() {
        try {
            Statement stmt = this.oldDBConn.createStatement(1004, 1007);
            ResultSet rs = stmt.executeQuery("SELECT OldID, NewID FROM agent_AgentID");
            block2: while (rs.next()) {
                int oldId = rs.getInt(1);
                int newId = rs.getInt(2);
                this.newSQL = "SELECT a.AgentType, a.LastName, a.MiddleInitial, a.FirstName, adr.Phone1, adr.Phone2, adr.Address, adr.City, adr.State, adr.PostalCode, adr.Country FROM agent AS a Left Join address AS adr ON a.AgentID = adr.AgentID WHERE a.AgentID = " + newId + " ORDER BY adr.Phone1, adr.Address, adr.City, adr.State, adr.PostalCode";
                this.oldSQL = "SELECT a.AgentType, IF (a.LastName IS null OR LENGTH(a.LastName) = 0, a.Name, a.LastName), a.MiddleInitial, a.FirstName,aa.Phone1, aa.Phone2 ,adr.Address, adr.City, adr.State ,adr.Postalcode, adr.Country FROM agent AS a Left Join agentaddress AS aa ON a.AgentID = aa.AgentID Left Join address AS adr ON aa.AddressID = adr.AddressID WHERE a.AgentID = " + oldId + " ORDER BY aa.Phone1, adr.Address, adr.City, adr.State ,adr.Postalcode";
                this.getResultSets(this.oldSQL, this.newSQL);
                block3: while (true) {
                    boolean hasOldRec = this.oldDBRS.next();
                    boolean hasNewRec = this.newDBRS.next();
                    if (!hasOldRec || !hasNewRec) continue block2;
                    int i = 1;
                    while (true) {
                        if (i > this.newDBRS.getMetaData().getColumnCount()) continue block3;
                        String newStr = this.newDBRS.getString(i);
                        String oldStr = this.oldDBRS.getString(i);
                        if (!this.compareStr(oldStr, newStr)) {
                            String fldName = this.newDBRS.getMetaData().getColumnName(i);
                            String oldNewIdStr = String.valueOf(oldId) + " / " + newId;
                            String msg = " Fields " + fldName + " don't match. [" + oldStr + "][" + newStr + "]";
                            this.tblWriter.logErrors(oldNewIdStr, msg);
                            log.error((Object)(String.valueOf(oldNewIdStr) + msg));
                        }
                        ++i;
                    }
                    break;
                }
            }
            rs.close();
            stmt.close();
            this.oldDBRS.close();
            this.newDBRS.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void verifyShipments() {
        this.newSQL = "SELECT s.ShipmentNumber,s.ShipmentDate, s.ShipmentMethod, s.NumberOfPackages, s.Weight, s.InsuredForAmount, ato.FirstName, ato.LastName, aby.FirstName, aby.LastName FROM shipment AS s Inner Join agent AS ato ON s.ShippedToID = ato.AgentID Inner Join agent AS aby ON s.ShippedByID = aby.AgentID ORDER BY s.ShipmentNumber ASC";
        this.oldSQL = "SELECT s.ShipmentNumber,s.ShipmentDate, s.ShipmentMethod, s.NumberOfPackages, s.Weight, s.InsuredForAmount, ato.FirstName, ato.LastName, ato.Name, aby.FirstName, aby.LastName, aby.Name FROM shipment AS s Inner Join agent AS ato ON s.ShippedToID = ato.AgentID Inner Join agent AS aby ON s.ShippedByID = aby.AgentID ORDER BY s.ShipmentNumber ASC";
        log.info((Object)this.newSQL);
        log.info((Object)this.oldSQL);
        int prevOldId = Integer.MAX_VALUE;
        int prevNewId = Integer.MAX_VALUE;
        try {
            this.getResultSets(this.oldSQL, this.newSQL);
            ResultSetMetaData rmd = this.newDBRS.getMetaData();
            while (true) {
                boolean hasOldRec = this.oldDBRS.next();
                boolean hasNewRec = this.newDBRS.next();
                if (!hasOldRec && !hasNewRec) break;
                int newId = this.newDBRS.getInt(1);
                System.out.println(newId);
                int oldId = this.oldDBRS.getInt(1);
                String oldNewIdStr = String.valueOf(oldId) + " / " + newId;
                if (newId == Integer.MAX_VALUE) {
                    prevNewId = newId;
                }
                if (oldId == Integer.MAX_VALUE) {
                    prevOldId = oldId;
                }
                this.compareStrings(oldNewIdStr, rmd.getColumnName(1), 1, 1);
                this.compareStrings(oldNewIdStr, rmd.getColumnName(2), 2, 2);
                this.compareDates(oldNewIdStr, 3, 3);
                this.compareStrings(oldNewIdStr, rmd.getColumnName(4), 4, 4);
                this.compareStrings(oldNewIdStr, rmd.getColumnName(5), 5, 5);
                this.compareStrings(oldNewIdStr, rmd.getColumnName(6), 6, 6);
                this.compareNames(oldNewIdStr, 7, 7);
                this.compareNames(oldNewIdStr, 9, 10);
            }
            this.oldDBRS.close();
            this.newDBRS.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void verifyLoans() {
        this.newSQL = "SELECT l.LoanNumber, l.LoanDate, l.IsClosed, l.CurrentDueDate, l.OriginalDueDate, l.DateClosed, l.Text1, l.Text2, l.Number1, l.Number2, l.YesNo1, l.YesNo2, lp.Quantity, lp.DescriptionOfMaterial, lp.OutComments, lp.InComments, lp.QuantityResolved, lp.QuantityReturned, LoanPreparationID FROM loan l Inner Join loanpreparation lp ON l.LoanID = lp.LoanID WHERE LoanNumber = '%s' ORDER BY LoanPreparationID";
        this.oldSQL = "SELECT l.LoanNumber, l.LoanDate, l.Closed, l.CurrentDueDate, l.OriginalDueDate, l.DateClosed, l.Text1, l.Text2, l.Number1, l.Number2, l.YesNo1, l.YesNo2, lp.Quantity, lp.DescriptionOfMaterial, lp.OutComments, lp.InComments, lp.QuantityResolved, lp.QuantityReturned, lp.LoanPhysicalObjectID FROM loan AS l Inner Join loanphysicalobject AS lp ON l.LoanID = lp.LoanID Left Join loanphysicalobject_LoanPhysicalObjectID AS lr ON lp.LoanPhysicalObjectID = lr.OldID WHERE l.Category = 0 AND LoanNumber = '%s' ORDER BY lr.NewID ASC";
        String newSQLCnt = "SELECT COUNT(*) FROM loan l Inner Join loanpreparation lp ON l.LoanID = lp.LoanID WHERE LoanNumber = '%s'";
        String oldSQLCnt = "SELECT COUNT(*) FROM loan AS l Inner Join loanphysicalobject AS lp ON l.LoanID = lp.LoanID WHERE l.Category = 0 AND LoanNumber = '%s'";
        log.info((Object)this.newSQL);
        log.info((Object)this.oldSQL);
        try {
            Vector<Object> loanNums = BasicSQLUtils.querySingleCol(this.oldDBConn, "SELECT LoanNumber FROM loan WHERE Category = 0");
            for (Object loanNum : loanNums) {
                int newCnt;
                int oldCnt = BasicSQLUtils.getCountAsInt(this.oldDBConn, String.format(oldSQLCnt, loanNum));
                if (oldCnt != (newCnt = BasicSQLUtils.getCountAsInt(this.newDBConn, String.format(newSQLCnt, loanNum)))) {
                    String msg = "For Loan Number[" + loanNum + " the number of New LoanPreps[" + newCnt + "] doesn't match the old[" + oldCnt + "]";
                    log.error((Object)msg);
                    this.tblWriter.logErrors(loanNum.toString(), msg);
                }
                this.getResultSets(String.format(this.oldSQL, loanNum), String.format(this.newSQL, loanNum));
                ResultSetMetaData rmd = this.newDBRS.getMetaData();
                while (true) {
                    boolean hasOldRec = this.oldDBRS.next();
                    boolean hasNewRec = this.newDBRS.next();
                    if (!hasOldRec && !hasNewRec) break;
                    int newId = this.newDBRS.getInt(1);
                    int oldId = this.oldDBRS.getInt(1);
                    String oldNewIdStr = String.valueOf(oldId) + " / " + newId + " (" + this.oldDBRS.getInt(19) + " / " + this.newDBRS.getInt(19) + ")";
                    this.compareStrings(oldNewIdStr, rmd.getColumnName(1), 1, 1);
                    this.compareDates(oldNewIdStr, 2, 2);
                    this.compareBoolean(oldNewIdStr, rmd.getColumnName(3), 3, 3);
                    this.compareDates(oldNewIdStr, 4, 4);
                    this.compareDates(oldNewIdStr, 5, 5);
                    this.compareDates(oldNewIdStr, 6, 6);
                    this.compareStrings(oldNewIdStr, rmd.getColumnName(7), 7, 7);
                    this.compareStrings(oldNewIdStr, rmd.getColumnName(8), 8, 8);
                    this.compareNumber(oldNewIdStr, rmd.getColumnName(9), 9, 9);
                    this.compareNumber(oldNewIdStr, rmd.getColumnName(10), 10, 10);
                    this.compareBoolean(oldNewIdStr, rmd.getColumnName(11), 11, 11);
                    this.compareBoolean(oldNewIdStr, rmd.getColumnName(12), 12, 12);
                    this.compareNumber(oldNewIdStr, rmd.getColumnName(13), 13, 13);
                    this.compareStrings(oldNewIdStr, rmd.getColumnName(14), 14, 14);
                    this.compareStrings(oldNewIdStr, rmd.getColumnName(15), 15, 15);
                    this.compareStrings(oldNewIdStr, rmd.getColumnName(16), 16, 16);
                    this.compareNumber(oldNewIdStr, rmd.getColumnName(17), 17, 17);
                    this.compareNumber(oldNewIdStr, rmd.getColumnName(18), 18, 18);
                }
                this.oldDBRS.close();
                this.newDBRS.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void verifyGifts() {
        this.newSQL = "SELECT g.GiftNumber, g.GiftDate, g.Remarks, g.Number1, g.Number2, g.Text1, g.Text2, g.YesNo1, g.YesNo2, gp.Quantity, gp.DescriptionOfMaterial, gp.OutComments, gp.InComments FROM gift AS g Inner Join giftpreparation AS gp ON g.GiftID = gp.GiftID WHERE g.GiftNumber = '%s' ORDER BY gp.GiftPreparationID";
        this.oldSQL = "SELECT g.LoanNumber, g.LoanDate, g.Remarks, g.Number1, g.Number2, g.Text1, g.Text2, g.YesNo1, g.YesNo2, gp.Quantity, gp.DescriptionOfMaterial, gp.OutComments, gp.InComments FROM loan AS g Inner Join loanphysicalobject AS gp ON g.LoanID = gp.LoanID Left Join loanphysicalobject_LoanPhysicalObjectID AS lr ON gp.LoanPhysicalObjectID = lr.OldID WHERE g.Category = 1 AND g.LoanNumber = '%s' ORDER BY lr.NewID ASC";
        String newSQLCnt = "SELECT COUNT(*) FROM gift AS g Inner Join giftpreparation AS gp ON g.GiftID = gp.GiftID WHERE GiftNumber = '%s'";
        String oldSQLCnt = "SELECT COUNT(*) FROM loan AS g Inner Join loanphysicalobject AS gp ON g.LoanID = gp.LoanID WHERE g.Category = 1 AND g.LoanNumber = '%s'";
        log.info((Object)this.newSQL);
        log.info((Object)this.oldSQL);
        try {
            Vector<Object> loanNums = BasicSQLUtils.querySingleCol(this.oldDBConn, "SELECT LoanNumber FROM loan WHERE Category = 1");
            for (Object loanNum : loanNums) {
                int newCnt;
                int oldCnt = BasicSQLUtils.getCountAsInt(this.oldDBConn, String.format(oldSQLCnt, loanNum));
                if (oldCnt != (newCnt = BasicSQLUtils.getCountAsInt(this.newDBConn, String.format(newSQLCnt, loanNum)))) {
                    String msg = "For Loan Number[" + loanNum + " the number of New LoanPreps[" + newCnt + "] doesn't match the old[" + oldCnt + "]";
                    log.error((Object)msg);
                    this.tblWriter.logErrors(loanNum.toString(), msg);
                }
                this.getResultSets(String.format(this.oldSQL, loanNum), String.format(this.newSQL, loanNum));
                ResultSetMetaData rmd = this.newDBRS.getMetaData();
                while (true) {
                    boolean hasOldRec = this.oldDBRS.next();
                    boolean hasNewRec = this.newDBRS.next();
                    if (!hasOldRec && !hasNewRec) break;
                    int newId = this.newDBRS.getInt(1);
                    int oldId = this.oldDBRS.getInt(1);
                    String oldNewIdStr = String.valueOf(oldId) + " / " + newId;
                    int inx = 1;
                    this.compareStrings(oldNewIdStr, rmd.getColumnName(inx), inx, inx);
                    this.compareDates(oldNewIdStr, ++inx, inx);
                    this.compareStrings(oldNewIdStr, rmd.getColumnName(++inx), inx, inx);
                    this.compareNumber(oldNewIdStr, rmd.getColumnName(++inx), inx, inx);
                    this.compareNumber(oldNewIdStr, rmd.getColumnName(++inx), inx, inx);
                    this.compareStrings(oldNewIdStr, rmd.getColumnName(++inx), inx, inx);
                    this.compareStrings(oldNewIdStr, rmd.getColumnName(++inx), inx, inx);
                    this.compareBoolean(oldNewIdStr, rmd.getColumnName(++inx), inx, inx);
                    this.compareBoolean(oldNewIdStr, rmd.getColumnName(++inx), inx, inx);
                    this.compareNumber(oldNewIdStr, rmd.getColumnName(++inx), inx, inx);
                    this.compareStrings(oldNewIdStr, rmd.getColumnName(++inx), inx, inx);
                    this.compareStrings(oldNewIdStr, rmd.getColumnName(++inx), inx, inx);
                    this.compareStrings(oldNewIdStr, rmd.getColumnName(++inx), inx, inx);
                    ++inx;
                }
                this.oldDBRS.close();
                this.newDBRS.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void verifyLoanRetPreps() {
        this.newSQL = "SELECT l.LoanNumber, r.ReturnedDate, r.QuantityResolved, r.Remarks FROM loan AS l Inner Join loanpreparation AS lp ON l.LoanID = lp.LoanID LEFT Join loanreturnpreparation AS r ON lp.LoanPreparationID = r.LoanPreparationID WHERE l.LoanNumber = '%s' ORDER BY lp.LoanPreparationID";
        this.oldSQL = "SELECT l.LoanNumber, r.`Date`, r.Quantity, r.Remarks FROM loan AS l Inner Join loanphysicalobject AS lp ON l.LoanID = lp.LoanID LEFT Join loanreturnphysicalobject AS r ON lp.LoanPhysicalObjectID = r.LoanPhysicalObjectID Left Join loanphysicalobject_LoanPhysicalObjectID AS lr ON lp.LoanPhysicalObjectID = lr.OldID WHERE l.Category = 0 AND LoanNumber = '%s' ORDER BY lr.NewID ASC";
        String newSQLCnt = "SELECT COUNT(ID) FROM (SELECT LoanReturnPreparationID AS ID, LoanNumber FROM loan AS l Inner Join loanpreparation AS lp ON l.LoanID = lp.LoanID Left Join loanreturnpreparation AS r ON lp.LoanPreparationID = r.LoanPreparationID WHERE LoanReturnPreparationID IS NOT NULL AND LoanNumber = '%s') T1";
        String oldSQLCnt = "SELECT COUNT(ID) FROM (SELECT LoanReturnPhysicalObjectID AS ID, LoanNumber FROM loan AS l Inner Join loanphysicalobject AS lp ON l.LoanID = lp.LoanID Left Join loanreturnphysicalobject AS r ON lp.LoanPhysicalObjectID = r.LoanPhysicalObjectID WHERE LoanReturnPhysicalObjectID IS NOT NULL AND LoanNumber = '%s') T1";
        log.info((Object)this.newSQL);
        log.info((Object)this.oldSQL);
        try {
            Vector<Object> loanNums = BasicSQLUtils.querySingleCol(this.oldDBConn, "SELECT LoanNumber FROM loan WHERE Category = 0");
            for (Object loanNum : loanNums) {
                int newCnt;
                int oldCnt = BasicSQLUtils.getCountAsInt(this.oldDBConn, String.format(oldSQLCnt, loanNum));
                if (oldCnt != (newCnt = BasicSQLUtils.getCountAsInt(this.newDBConn, String.format(newSQLCnt, loanNum)))) {
                    String msg = "For Loan Number[" + loanNum + " the number of New LoanPreps[" + newCnt + "] doesn't match the old[" + oldCnt + "]";
                    log.error((Object)msg);
                    this.tblWriter.logErrors(loanNum.toString(), msg);
                }
                this.getResultSets(String.format(this.oldSQL, loanNum), String.format(this.newSQL, loanNum));
                ResultSetMetaData rmd = this.newDBRS.getMetaData();
                while (true) {
                    boolean hasOldRec = this.oldDBRS.next();
                    boolean hasNewRec = this.newDBRS.next();
                    if (!hasOldRec && !hasNewRec) break;
                    int newId = this.newDBRS.getInt(1);
                    int oldId = this.oldDBRS.getInt(1);
                    String oldNewIdStr = String.valueOf(oldId) + " / " + newId;
                    int inx = 1;
                    this.compareStrings(oldNewIdStr, rmd.getColumnName(inx), inx, inx);
                    this.compareDates(oldNewIdStr, ++inx, inx);
                    this.compareNumber(oldNewIdStr, rmd.getColumnName(++inx), inx, inx);
                    this.compareStrings(oldNewIdStr, rmd.getColumnName(++inx), inx, inx);
                    ++inx;
                }
                this.oldDBRS.close();
                this.newDBRS.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        UIRegistry.setAppName("Specify");
        AppBase.processArgs(args);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConvertVerifier cv;
                try {
                    if (!System.getProperty("os.name").equals("Mac OS X")) {
                        UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
                        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new DesertBlue());
                    }
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(ConvertVerifier.class, e);
                    log.error((Object)"Can't change L&F: ", (Throwable)e);
                }
                if ((cv = new ConvertVerifier()).selectedDBsToConvert()) {
                    try {
                        final Pair pair = cv.chooseTable();
                        if (pair != null) {
                            SwingWorker workerThread = new SwingWorker(){

                                @Override
                                public Object construct() {
                                    try {
                                        boolean compareTo6DBS = false;
                                        if (compareTo6DBS) {
                                            pair.first = "ku_fish";
                                            pair.second = "kui_fish_dbo_6";
                                            cv.setCompareTo6DBs(compareTo6DBS);
                                        }
                                        cv.verifyDB((String)pair.first, (String)pair.second);
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                    return null;
                                }

                                @Override
                                public void finished() {
                                }
                            };
                            workerThread.start();
                        } else {
                            JOptionPane.showMessageDialog(null, "The ConvertVerifier was unable to login", "Not Logged In", 0);
                            System.exit(0);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        System.exit(0);
                    }
                }
            }
        });
    }

    public static boolean isCOOn(long opt) {
        return (coOptions & opt) == opt;
    }

    public static boolean isACOn(long opt) {
        return (acOptions & opt) == opt;
    }

    private boolean selectedDBsToConvert() {
        JTextField itUserNameTF = UIHelper.createTextField("root", 15);
        JPasswordField itPasswordTF = UIHelper.createPasswordField("", 15);
        JTextField hostNameTF = UIHelper.createTextField("localhost", 15);
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,p,f:p:g", "p,2px,p,2px,p,8px,p"));
        int y = 1;
        pb.addSeparator("IT User", cc.xyw(1, y, 4));
        pb.add((Component)UIHelper.createLabel("Username:", 4), cc.xy(1, y += 2));
        pb.add((Component)itUserNameTF, cc.xy(3, y));
        pb.add((Component)UIHelper.createLabel("Password:", 4), cc.xy(1, y += 2));
        pb.add((Component)itPasswordTF, cc.xy(3, y));
        pb.add((Component)UIHelper.createLabel("Host Name:", 4), cc.xy(1, y += 2));
        pb.add((Component)hostNameTF, cc.xy(3, y));
        y += 2;
        PanelBuilder panel = new PanelBuilder(new FormLayout("f:p:g,10px,f:p:g", "f:p:g"));
        panel.add((Component)new JLabel(IconManager.getIcon("SpecifyLargeIcon")), cc.xy(1, 1));
        panel.add((Component)pb.getPanel(), cc.xy(3, 1));
        CustomDialog dlg = new CustomDialog(null, "Database Info", true, panel.getPanel());
        ((JPanel)dlg.getContentPanel()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        UIHelper.centerAndShow(dlg);
        dlg.dispose();
        if (dlg.isCancelled()) {
            return false;
        }
        this.hostName = hostNameTF.getText();
        this.itUsrPwd.first = itUserNameTF.getText();
        this.itUsrPwd.second = ((JTextComponent)itPasswordTF).getText();
        return true;
    }

    private Pair<String, String> chooseTable() throws SQLException {
        block12: {
            JList newList;
            JList oldlist;
            block13: {
                MySQLDMBSUserMgr mgr = new MySQLDMBSUserMgr();
                Vector<DBNamePair> availOldPairs = new Vector<DBNamePair>();
                final Vector<DBNamePair> availNewPairs = new Vector<DBNamePair>();
                if (!mgr.connectToDBMS((String)this.itUsrPwd.first, (String)this.itUsrPwd.second, this.hostName)) break block12;
                BasicSQLUtils.setSkipTrackExceptions(true);
                Connection conn = mgr.getConnection();
                Vector<Object[]> dbNames = BasicSQLUtils.query(conn, "show databases");
                for (Object[] row : dbNames) {
                    System.err.println("Setting [" + row[0].toString() + "] ");
                    conn.setCatalog(row[0].toString());
                    boolean isSp5 = false;
                    boolean isSp6 = false;
                    Vector<Object[]> tables = BasicSQLUtils.query(conn, "show tables");
                    for (Object[] tblRow : tables) {
                        if (row[0].toString().equals("debugdb")) {
                            System.err.println(tblRow[0].toString());
                        }
                        if (tblRow[0].toString().equals("usysversion")) {
                            isSp5 = true;
                            break;
                        }
                        if (!tblRow[0].toString().equals("gift")) continue;
                        isSp6 = true;
                        break;
                    }
                    if (isSp5 || isSp6) {
                        String collName = null;
                        Vector<Object[]> tableDesc = BasicSQLUtils.query(conn, "SELECT CollectionName FROM collection");
                        if (tableDesc.size() > 0) {
                            collName = tableDesc.get(0)[0].toString();
                        }
                        if (collName == null) continue;
                        if (isSp5) {
                            availOldPairs.add(new DBNamePair(collName, row[0].toString()));
                        } else {
                            availNewPairs.add(new DBNamePair(collName, row[0].toString()));
                        }
                    }
                    System.err.println("isSp5 [" + isSp5 + "] isSp6 [" + isSp6 + "] ");
                }
                Comparator<Pair<String, String>> comparator = new Comparator<Pair<String, String>>(){

                    @Override
                    public int compare(Pair<String, String> o1, Pair<String, String> o2) {
                        return ((String)o1.second).compareTo((String)o2.second);
                    }
                };
                Collections.sort(availOldPairs, comparator);
                Collections.sort(availNewPairs, comparator);
                mgr.close();
                BasicSQLUtils.setSkipTrackExceptions(false);
                oldlist = new JList(availOldPairs);
                newList = new JList(availNewPairs);
                CellConstraints cc = new CellConstraints();
                PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,10px,f:p:g", "p,2px,f:p:g,4px,p"));
                pb.addSeparator("Specify 5 Databases", cc.xy(1, 1));
                pb.add((Component)UIHelper.createScrollPane(oldlist), cc.xy(1, 3));
                pb.addSeparator("Specify 6 Databases", cc.xy(3, 1));
                pb.add((Component)UIHelper.createScrollPane(newList), cc.xy(3, 3));
                ArrayList<String> list = new ArrayList<String>(this.labels.length);
                String[] stringArray = this.labels;
                int n = this.labels.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    list.add(s);
                    ++n2;
                }
                this.chkPanel = new ToggleButtonChooserPanel(list, ToggleButtonChooserPanel.Type.Checkbox);
                this.chkPanel.setUseScrollPane(true);
                this.chkPanel.createUI();
                ListSelectionListener oldDBListener = new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        DBNamePair pair;
                        if (!e.getValueIsAdjusting() && (pair = (DBNamePair)oldlist.getSelectedValue()) != null) {
                            int index = 0;
                            for (DBNamePair p : availNewPairs) {
                                if (((String)p.second).startsWith((String)pair.second)) {
                                    final int inx = index;
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            newList.setSelectedIndex(inx);
                                            newList.ensureIndexIsVisible(inx);
                                        }
                                    });
                                }
                                ++index;
                            }
                        }
                    }
                };
                oldlist.getSelectionModel().addListSelectionListener(oldDBListener);
                MouseAdapter ma = new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        block4: {
                            Vector<JToggleButton> btns;
                            block3: {
                                super.mouseClicked(e);
                                btns = ConvertVerifier.this.chkPanel.getButtons();
                                if (e.getSource() != btns.get(0)) break block3;
                                boolean isSelected = btns.get(0).isSelected();
                                int i = 1;
                                while (i < btns.size()) {
                                    btns.get(i).setEnabled(!isSelected);
                                    ++i;
                                }
                                break block4;
                            }
                            if (e.getSource() != btns.get(btns.size() - 1)) break block4;
                            boolean isSelected = btns.get(btns.size() - 1).isSelected();
                            int i = 0;
                            while (i < btns.size() - 1) {
                                if (i > 0) {
                                    btns.get(i).setSelected(!isSelected);
                                }
                                btns.get(i).setEnabled(!isSelected);
                                ++i;
                            }
                        }
                    }
                };
                this.chkPanel.getButtons().get(0).addMouseListener(ma);
                this.chkPanel.getButtons().get(this.chkPanel.getButtons().size() - 1).addMouseListener(ma);
                pb.setDefaultDialogBorder();
                final CustomDialog dlg = new CustomDialog(null, "Select a DB to Verify", true, pb.getPanel());
                ListSelectionListener lsl = new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (!e.getValueIsAdjusting()) {
                            dlg.getOkBtn().setEnabled(oldlist.getSelectedIndex() > -1);
                        }
                    }
                };
                oldlist.addListSelectionListener(lsl);
                newList.addListSelectionListener(lsl);
                oldlist.setSelectionMode(0);
                newList.setSelectionMode(0);
                MouseAdapter listMA = new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() == 2) {
                            dlg.getOkBtn().setEnabled(oldlist.getSelectedIndex() > -1 && newList.getSelectedIndex() > -1);
                            dlg.getOkBtn().doClick();
                        }
                    }
                };
                oldlist.addMouseListener(listMA);
                newList.addMouseListener(listMA);
                dlg.createUI();
                dlg.pack();
                dlg.pack();
                dlg.setVisible(true);
                if (!dlg.isCancelled()) break block13;
                return null;
            }
            try {
                DBNamePair oldPair = (DBNamePair)oldlist.getSelectedValue();
                this.namePairToConvert = (DBNamePair)newList.getSelectedValue();
                this.namePairToConvert.first = (String)oldPair.second;
                return this.namePairToConvert;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public CustomDBConverterDlg runCustomConverter() {
        return UIHelper.doSpecifyConvert();
    }

    class DBNamePair
    extends Pair<String, String> {
        public DBNamePair() {
        }

        public DBNamePair(String first, String second) {
            super(first, second);
        }

        @Override
        public String toString() {
            return String.valueOf((String)this.second) + "   (" + (String)this.first + ")";
        }
    }

    private static enum StatusType {
        NO_OLD_REC,
        NO_NEW_REC,
        OLD_VAL_NULL,
        NEW_VAL_NULL,
        BAD_COMPARE,
        BAD_DATE,
        COMPARE_OK,
        NO_COMPARE;

    }
}

