/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.conversion.CollectionInfo;
import edu.ku.brc.specify.conversion.ConvertVerifier;
import edu.ku.brc.specify.conversion.GenericDBConversion;
import edu.ku.brc.specify.conversion.IdHashMapper;
import edu.ku.brc.specify.conversion.IdMapperIFace;
import edu.ku.brc.specify.conversion.IdMapperIndexIncrementerIFace;
import edu.ku.brc.specify.conversion.IdMapperMgr;
import edu.ku.brc.specify.conversion.IdTableMapper;
import edu.ku.brc.specify.conversion.TableWriter;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonTreeDef;
import edu.ku.brc.specify.datamodel.TaxonTreeDefItem;
import edu.ku.brc.specify.treeutils.NodeNumberer;
import edu.ku.brc.ui.ProgressFrame;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class ConvertTaxonHelper {
    protected static final Logger log = Logger.getLogger(ConvertTaxonHelper.class);
    protected static SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    protected static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    protected static Timestamp now = new Timestamp(System.currentTimeMillis());
    protected static String nowStr = dateTimeFormatter.format(now);
    protected static int taxonomicUnitTypeId = 11111111;
    protected Connection oldDBConn;
    protected Connection newDBConn;
    protected String oldDBName;
    protected TableWriter tblWriter;
    protected IdMapperIndexIncrementerIFace indexIncremeter;
    protected GenericDBConversion conversion;
    protected ProgressFrame frame;
    protected String taxonomyTypeIdInClause = null;
    protected String taxonFromClause = null;
    protected Vector<CollectionInfo> collectionInfoList;
    protected HashMap<Integer, Vector<CollectionInfo>> collDispHash;
    protected HashMap<Integer, TaxonTreeDef> newTaxonInfoHash = new HashMap();
    protected HashSet<Integer> taxonTypesInUse = new HashSet();
    protected HashMap<Integer, TaxonTreeDef> taxonTreeDefHash = new HashMap();
    protected HashMap<Integer, Taxon> taxonTreeHash = new HashMap();
    protected IdMapperIFace txMapper = null;
    protected IdMapperIFace txTypMapper = null;
    protected IdMapperIFace txUnitTypMapper = null;
    protected IdMapperIFace[] mappers = null;
    protected String[] oldCols = new String[]{"TaxonNameID", "ParentTaxonNameID", "TaxonomyTypeID", "AcceptedID", "TaxonomicUnitTypeID", "TaxonomicSerialNumber", "TaxonName", "UnitInd1", "UnitName1", "UnitInd2", "UnitName2", "UnitInd3", "UnitName3", "UnitInd4", "UnitName4", "FullTaxonName", "CommonName", "Author", "Source", "GroupPermittedToView", "EnvironmentalProtectionStatus", "Remarks", "NodeNumber", "HighestChildNodeNumber", "LastEditedBy", "Accepted", "RankID", "GroupNumber", "TimestampCreated", "TimestampModified"};
    protected String[] cols = new String[]{"TaxonID", "Author", "CitesStatus", "COLStatus", "CommonName", "CultivarName", "EnvironmentalProtectionStatus", "EsaStatus", "FullName", "GroupNumber", "GUID", "HighestChildNodeNumber", "IsAccepted", "IsHybrid", "IsisNumber", "LabelFormat", "Name", "NcbiTaxonNumber", "NodeNumber", "Number1", "Number2", "RankID", "Remarks", "Source", "TaxonomicSerialNumber", "Text1", "Text2", "UnitInd1", "UnitInd2", "UnitInd3", "UnitInd4", "UnitName1", "UnitName2", "UnitName3", "UnitName4", "UsfwsCode", "Visibility", "ParentID", "AcceptedID", "ModifiedByAgentID", "TaxonTreeDefItemID", "VisibilitySetByID", "CreatedByAgentID", "HybridParent1ID", "TaxonTreeDefID", "HybridParent2ID", "TimestampCreated", "TimestampModified", "Version"};
    protected int[] colTypes = null;
    protected int[] colSizes = null;
    protected Hashtable<String, String> newToOldColMap = new Hashtable();
    protected Hashtable<String, String> oldToNewColMap = new Hashtable();
    protected HashMap<String, Integer> fieldToColHash = new HashMap();
    protected HashMap<Integer, String> colToFieldHash = new HashMap();
    protected HashMap<String, Integer> oldFieldToColHash = new HashMap();
    protected PreparedStatement pStmtTx = null;
    protected Statement stmtTx = null;
    protected int missingParentTaxonCount = 0;
    protected int lastEditedByInx;
    protected int modifiedByAgentInx;
    protected int rankIdOldDBInx;

    public ConvertTaxonHelper(Connection oldDBConn, Connection newDBConn, String oldDBName, ProgressFrame frame, TableWriter tblWriter, GenericDBConversion conversion, IdMapperIndexIncrementerIFace indexIncremeter) {
        this.oldDBConn = oldDBConn;
        this.newDBConn = newDBConn;
        this.oldDBName = oldDBName;
        this.frame = frame;
        this.tblWriter = tblWriter;
        this.indexIncremeter = indexIncremeter;
        this.conversion = conversion;
        CollectionInfo.getCollectionInfoList(oldDBConn);
        this.collectionInfoList = CollectionInfo.getFilteredCollectionInfoList();
        this.collDispHash = new HashMap();
        for (CollectionInfo info : this.collectionInfoList) {
            if (!info.isTaxonomicUnitTypeInUse()) continue;
            Vector<CollectionInfo> colInfoList = this.collDispHash.get(info.getTaxonomyTypeId());
            if (colInfoList == null) {
                colInfoList = new Vector();
                this.collDispHash.put(info.getTaxonomyTypeId(), colInfoList);
            }
            colInfoList.add(info);
        }
    }

    public void doForeignKeyMappings() {
        String[] mappings = new String[]{"Determination", "TaxonNameID", "TaxonName", "TaxonNameID", "Preparation", "ParasiteTaxonNameID", "TaxonName", "TaxonNameID", "Habitat", "HostTaxonID", "TaxonName", "TaxonNameID", "TaxonCitation", "ReferenceWorkID", "ReferenceWork", "ReferenceWorkID", "TaxonCitation", "TaxonNameID", "TaxonName", "TaxonNameID", "TaxonName", "ParentTaxonNameID", "TaxonName", "TaxonNameID", "TaxonName", "TaxonomicUnitTypeID", "TaxonomicUnitType", "TaxonomicUnitTypeID", "TaxonName", "TaxonomyTypeID", "TaxonomyType", "TaxonomyTypeID", "TaxonName", "AcceptedID", "TaxonName", "TaxonNameID", "TaxonomicUnitType", "TaxonomyTypeID", "TaxonomyType", "TaxonomyTypeID"};
        int i = 0;
        while (i < mappings.length) {
            IdMapperMgr.getInstance().mapForeignKey(mappings[i], mappings[i + 1], mappings[i + 2], mappings[i + 3]);
            i += 4;
        }
    }

    public void createTaxonIdMappings() {
        IdMapperMgr idMapperMgr = IdMapperMgr.getInstance();
        String[] tableNames = new String[]{"Habitat", "TaxonCitation", "TaxonomicUnitType"};
        int i = 0;
        IdTableMapper idMapper = null;
        String[] stringArray = tableNames;
        int n = tableNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tableName = stringArray[n2];
            idMapper = idMapperMgr.addTableMapper(tableName, String.valueOf(tableName) + "ID");
            log.debug((Object)("mapIds() for table" + tableName));
            if (i < tableNames.length - 1) {
                idMapper.mapAllIds();
            }
            ++i;
            ++n2;
        }
        HashSet<Integer> txTypHashSet = new HashSet<Integer>();
        StringBuilder inSB = new StringBuilder();
        for (CollectionInfo ci : CollectionInfo.getFilteredCollectionInfoList()) {
            log.debug((Object)("For Collection[" + ci.getCatSeriesName() + "]  TaxonomyTypeId: " + ci.getTaxonomyTypeId() + "  " + (txTypHashSet.contains(ci.getTaxonomyTypeId()) ? "Done" : "not Done.")));
            if (txTypHashSet.contains(ci.getTaxonomyTypeId())) continue;
            log.debug((Object)("Mapping TaxonomyTypeId [" + ci.getTaxonomyTypeId() + "]  For Collection[" + ci.getCatSeriesName() + "]"));
            if (inSB.length() > 0) {
                inSB.append(',');
            }
            inSB.append(ci.getTaxonomyTypeId());
            txTypHashSet.add(ci.getTaxonomyTypeId());
        }
        this.taxonomyTypeIdInClause = " in (" + inSB.toString() + ")";
        IdTableMapper taxonomyTypeMapper = idMapperMgr.addTableMapper("TaxonomyType", "TaxonomyTypeID", true);
        this.taxonFromClause = String.format(" FROM taxonname tx INNER JOIN taxonomicunittype tu ON tx.TaxonomicUnitTypeID = tu.TaxonomicUnitTypeID WHERE tx.RankID IS NOT NULL AND tx.TaxonomyTypeId %s ORDER BY tx.RankID", this.taxonomyTypeIdInClause);
        String sql = "SELECT COUNT(*)" + this.taxonFromClause;
        log.debug((Object)sql);
        int count = BasicSQLUtils.getCountAsInt(this.oldDBConn, sql);
        sql = "SELECT tx.TaxonNameID" + this.taxonFromClause;
        log.debug((Object)(String.valueOf(count) + " - " + sql));
        idMapper = idMapperMgr.addTableMapper("TaxonName", "TaxonNameID", sql, true);
        idMapper.mapAllIdsWithSQL();
    }

    protected void getTaxonTreesTypesInUse() {
        for (CollectionInfo colInfo : this.collectionInfoList) {
            this.taxonTypesInUse.add(colInfo.getTaxonNameId());
        }
    }

    public void convertAllTaxonTreeDefs() {
        IdMapperMgr.getInstance().get("TaxonomicUnitType", "TaxonomicUnitTypeID").reset();
        for (CollectionInfo colInfo : this.collectionInfoList) {
            this.convertTaxonTreeDefinition(colInfo);
        }
    }

    public void convertTaxonTreeDefinition(CollectionInfo colInfo) {
        if (!colInfo.isInUse()) {
            return;
        }
        TaxonTreeDef taxonTreeDef = this.newTaxonInfoHash.get(colInfo.getTaxonNameId());
        if (taxonTreeDef != null) {
            colInfo.setTaxonTreeDef(taxonTreeDef);
            return;
        }
        Integer oldTaxonRootId = colInfo.getTaxonNameId();
        Integer taxonomyTypeId = colInfo.getTaxonomyTypeId();
        try {
            Statement st = this.oldDBConn.createStatement(1004, 1007);
            taxonTreeDef = new TaxonTreeDef();
            taxonTreeDef.initialize();
            String sql = "SELECT TaxonomyTypeName, KingdomID FROM taxonomytype WHERE TaxonomyTypeID = " + taxonomyTypeId;
            log.debug((Object)sql);
            ResultSet rs = st.executeQuery(sql);
            rs.next();
            String taxonomyTypeName = rs.getString(1);
            int kingdomID = rs.getInt(2);
            rs.close();
            taxonTreeDef.setName(String.valueOf(taxonomyTypeName) + " taxonomy tree");
            taxonTreeDef.setRemarks("Tree converted from " + this.oldDBName);
            taxonTreeDef.setFullNameDirection(1);
            sql = String.format("SELECT RankID, RankName, RequiredParentRankID, TaxonomicUnitTypeID FROM taxonomicunittype WHERE TaxonomyTypeID = %d AND (Kingdom = %d  OR RankID = 0) ORDER BY RankID", taxonomyTypeId, kingdomID);
            log.debug((Object)sql);
            rs = st.executeQuery(sql);
            Hashtable<Integer, Integer> rankId2TxnUntTypId = new Hashtable<Integer, Integer>();
            Vector<Object> items = new Vector<Object>();
            Vector<Integer> enforcedRanks = new Vector<Integer>();
            while (rs.next()) {
                int rank = rs.getInt(1);
                String name = rs.getString(2);
                int requiredRank = rs.getInt(3);
                int n = rs.getInt(4);
                if (StringUtils.isEmpty((String)name) || rank > 0 && requiredRank == 0) continue;
                if (rankId2TxnUntTypId.get(rank) != null) {
                    String msg = String.format("Old TreeDef has two of the same Rank %d, throwing it out.\n\nYou must fix this before proceeding.", rank);
                    this.tblWriter.logError(msg);
                    log.debug((Object)msg);
                    UIRegistry.displayErrorDlg(msg);
                    System.exit(0);
                }
                rankId2TxnUntTypId.put(rank, n);
                log.debug((Object)(String.valueOf(rank) + "  " + name + "  TaxonomicUnitTypeID: " + n));
                TaxonTreeDefItem ttdi = new TaxonTreeDefItem();
                ttdi.initialize();
                ttdi.setName(name);
                ttdi.setFullNameSeparator(" ");
                ttdi.setRankId(rank);
                ttdi.setTreeDef(taxonTreeDef);
                taxonTreeDef.getTreeDefItems().add(ttdi);
                ttdi.setIsInFullName(rank >= 180);
                if (items.isEmpty()) {
                    ttdi.setParent((TaxonTreeDefItem)null);
                } else {
                    ttdi.setParent((TaxonTreeDefItem)items.lastElement());
                }
                items.add(ttdi);
                enforcedRanks.add(requiredRank);
            }
            rs.close();
            for (TaxonTreeDefItem taxonTreeDefItem : items) {
                taxonTreeDefItem.setIsEnforced(enforcedRanks.contains(taxonTreeDefItem.getRankId()));
            }
            try {
                Session session = HibernateUtil.getNewSession();
                Transaction trans = session.beginTransaction();
                session.save((Object)taxonTreeDef);
                trans.commit();
                session.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception);
            }
            IdMapperMgr idMapperMgr = IdMapperMgr.getInstance();
            IdMapperIFace tutMapper = idMapperMgr.get("TaxonomicUnitType", "TaxonomicUnitTypeID");
            IdMapperIFace taxonomyTypeMapper = idMapperMgr.get("TaxonomyType", "TaxonomyTypeID");
            taxonomyTypeMapper.put(taxonomyTypeId, taxonTreeDef.getId());
            for (TaxonTreeDefItem ttdi : taxonTreeDef.getTreeDefItems()) {
                int ttdiId = (Integer)rankId2TxnUntTypId.get(ttdi.getRankId());
                log.debug((Object)("Mapping " + ttdiId + " -> " + ttdi.getId() + "  RankId: " + ttdi.getRankId()));
                tutMapper.put(ttdiId, ttdi.getId());
            }
            this.newTaxonInfoHash.put(oldTaxonRootId, taxonTreeDef);
            CollectionInfo ci = this.getCIByTaxonTypeId(taxonomyTypeId);
            ci.setTaxonTreeDef(taxonTreeDef);
            this.taxonTreeDefHash.put(taxonomyTypeId, taxonTreeDef);
            log.debug((Object)("Hashing taxonomyTypeId: " + taxonomyTypeId + " ->  taxonTreeDefId:" + taxonTreeDef.getId()));
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    protected CollectionInfo getCIByTaxonTypeId(int taxonomyTypeId) {
        for (CollectionInfo ci : CollectionInfo.getCollectionInfoList(this.oldDBConn, true)) {
            if (ci.getTaxonomyTypeId() != taxonomyTypeId) continue;
            return ci;
        }
        log.error((Object)("Couldn't find [" + taxonomyTypeId + "] in CollectionInfo list"));
        return null;
    }

    private void convertTaxonRecords() {
        this.txMapper = IdMapperMgr.getInstance().get("taxonname", "TaxonNameID");
        this.txTypMapper = IdMapperMgr.getInstance().get("TaxonomyType", "TaxonomyTypeID");
        this.txUnitTypMapper = IdMapperMgr.getInstance().get("TaxonomicUnitType", "TaxonomicUnitTypeID");
        this.mappers = new IdMapperIFace[]{this.txMapper, this.txMapper, this.txTypMapper, this.txMapper, this.txUnitTypMapper};
        this.newToOldColMap.put("TaxonID", "TaxonNameID");
        this.newToOldColMap.put("ParentID", "ParentTaxonNameID");
        this.newToOldColMap.put("TaxonTreeDefID", "TaxonomyTypeID");
        this.newToOldColMap.put("TaxonTreeDefItemID", "TaxonomicUnitTypeID");
        this.newToOldColMap.put("Name", "TaxonName");
        this.newToOldColMap.put("FullName", "FullTaxonName");
        this.newToOldColMap.put("IsAccepted", "Accepted");
        this.oldToNewColMap.put("TaxonNameID", "TaxonID");
        this.oldToNewColMap.put("ParentTaxonNameID", "ParentID");
        this.oldToNewColMap.put("TaxonomyTypeID", "TaxonTreeDefID");
        this.oldToNewColMap.put("TaxonomicUnitTypeID", "TaxonTreeDefItemID");
        this.oldToNewColMap.put("TaxonName", "Name");
        this.oldToNewColMap.put("FullTaxonName", "FullName");
        this.oldToNewColMap.put("Accepted", "IsAccepted");
        StringBuilder newSB = new StringBuilder();
        StringBuilder vl = new StringBuilder();
        int i = 0;
        while (i < this.cols.length) {
            this.fieldToColHash.put(this.cols[i], i + 1);
            this.colToFieldHash.put(i + 1, this.cols[i]);
            if (newSB.length() > 0) {
                newSB.append(", ");
            }
            newSB.append(this.cols[i]);
            if (vl.length() > 0) {
                vl.append(',');
            }
            vl.append('?');
            ++i;
        }
        StringBuilder oldSB = new StringBuilder();
        int i2 = 0;
        while (i2 < this.oldCols.length) {
            this.oldFieldToColHash.put(this.oldCols[i2], i2 + 1);
            if (oldSB.length() > 0) {
                oldSB.append(", ");
            }
            oldSB.append("tx.");
            oldSB.append(this.oldCols[i2]);
            ++i2;
        }
        this.rankIdOldDBInx = this.oldFieldToColHash.get("RankID");
        String sqlStr = String.format("SELECT %s FROM taxon", newSB.toString());
        log.debug((Object)sqlStr);
        String sql = String.format("SELECT %s %s", oldSB.toString(), this.taxonFromClause);
        log.debug((Object)sql);
        String cntSQL = String.format("SELECT COUNT(*) %s", this.taxonFromClause);
        log.debug((Object)cntSQL);
        int txCnt = BasicSQLUtils.getCountAsInt(this.oldDBConn, cntSQL);
        if (this.frame != null) {
            this.frame.setProcess(0, txCnt);
        }
        String pStr = String.format("INSERT INTO taxon (%s) VALUES (%s)", newSB.toString(), vl.toString());
        log.debug((Object)pStr);
        try {
            try {
                this.stmtTx = this.newDBConn.createStatement(1004, 1007);
                ResultSet rs1 = this.stmtTx.executeQuery(sqlStr);
                ResultSetMetaData rsmd1 = rs1.getMetaData();
                this.colTypes = new int[rsmd1.getColumnCount()];
                this.colSizes = new int[rsmd1.getColumnCount()];
                int i3 = 0;
                while (i3 < this.colTypes.length) {
                    this.colTypes[i3] = rsmd1.getColumnType(i3 + 1);
                    this.colSizes[i3] = rsmd1.getPrecision(i3 + 1);
                    ++i3;
                }
                rs1.close();
                this.stmtTx.close();
                this.missingParentTaxonCount = 0;
                this.lastEditedByInx = this.oldFieldToColHash.get("LastEditedBy");
                this.modifiedByAgentInx = this.fieldToColHash.get("ModifiedByAgentID");
                this.stmtTx = this.oldDBConn.createStatement(1004, 1007);
                this.pStmtTx = this.newDBConn.prepareStatement(pStr);
                int cnt = 0;
                ResultSet rs = this.stmtTx.executeQuery(sql);
                ResultSetMetaData rsmd = rs.getMetaData();
                while (rs.next()) {
                    this.processRow(rs, rsmd, null);
                    if (++cnt % 1000 != 0) continue;
                    log.debug((Object)cnt);
                    if (this.frame == null) continue;
                    this.frame.setProcess(cnt);
                }
                rs.close();
                if (this.frame != null) {
                    this.frame.setProcess(txCnt, txCnt);
                }
                String msg = String.format("Stranded Taxon (no parent): %d", this.missingParentTaxonCount);
                this.tblWriter.log(msg);
                log.debug((Object)msg);
                if (this.missingParentTaxonCount > 0) {
                    this.fixStrandedTaxon(oldSB);
                    this.frame.setDesc("Renumbering the tree nodes, this may take a while...");
                    HashSet<Integer> ttdHash = new HashSet<Integer>();
                    for (CollectionInfo colInfo : CollectionInfo.getFilteredCollectionInfoList()) {
                        block30: {
                            if (ttdHash.contains(colInfo.getTaxonTreeDef().getId())) continue;
                            DataProviderSessionIFace session = null;
                            try {
                                try {
                                    session = DataProviderFactory.getInstance().createSession();
                                    TaxonTreeDef taxonTreeDef = colInfo.getTaxonTreeDef();
                                    taxonTreeDef = (TaxonTreeDef)session.getData("FROM TaxonTreeDef WHERE id = " + taxonTreeDef.getId());
                                    sql = "SELECT TaxonID FROM taxon WHERE RankID = 0 AND TaxonTreeDefID = " + taxonTreeDef.getId();
                                    log.debug((Object)sql);
                                    Integer txRootId = BasicSQLUtils.getCount(sql);
                                    Taxon txRoot = (Taxon)session.getData("FROM Taxon WHERE id = " + txRootId);
                                    NodeNumberer nodeNumberer = new NodeNumberer(txRoot.getDefinition());
                                    nodeNumberer.doInBackground();
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    if (session != null) {
                                        session.close();
                                    }
                                    break block30;
                                }
                            }
                            catch (Throwable throwable) {
                                if (session != null) {
                                    session.close();
                                }
                                throw throwable;
                            }
                            if (session != null) {
                                session.close();
                            }
                        }
                        ttdHash.add(colInfo.getTaxonTreeDef().getId());
                    }
                    this.frame.setDesc("Renumbering done.");
                }
                this.missingParentTaxonCount = 0;
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                try {
                    this.stmtTx.close();
                    this.pStmtTx.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                this.stmtTx.close();
                this.pStmtTx.close();
            }
            catch (Exception exception) {}
        }
    }

    protected boolean processRow(ResultSet rs, ResultSetMetaData rsmd, Integer parentNodeId) throws SQLException {
        int colInx = 1;
        while (colInx <= this.cols.length) {
            this.pStmtTx.setNull(colInx, this.colTypes[colInx - 1]);
            ++colInx;
        }
        Boolean isRoot = null;
        boolean skip = false;
        int colInx2 = 1;
        while (colInx2 <= this.oldCols.length && !skip) {
            block39: {
                Integer newInx;
                String oldName;
                block36: {
                    block38: {
                        Integer agtId;
                        block37: {
                            oldName = this.oldCols[colInx2 - 1];
                            newInx = this.fieldToColHash.get(oldName);
                            if (newInx != null) break block36;
                            String newName = this.oldToNewColMap.get(oldName);
                            if (newName == null) break block37;
                            newInx = this.fieldToColHash.get(newName);
                            if (newInx == -1) {
                                String msg = "Couldn't find column index for New Name[" + newName + "]";
                                log.error((Object)msg);
                                this.tblWriter.logError(msg);
                            }
                            break block36;
                        }
                        if (colInx2 != this.lastEditedByInx) break block38;
                        String lastEditedByStr = rs.getString(colInx2);
                        if (StringUtils.isNotEmpty((String)lastEditedByStr) && (agtId = this.conversion.getModifiedByAgentId(lastEditedByStr)) != null) {
                            this.pStmtTx.setInt(this.modifiedByAgentInx, agtId);
                        } else {
                            this.pStmtTx.setInt(colInx2, this.conversion.getCurAgentModifierID());
                        }
                        break block39;
                    }
                    if (colInx2 == 20) break block39;
                    String msg = "Couldn't find Old Name[" + oldName + "]";
                    log.error((Object)msg);
                    this.tblWriter.logError(msg);
                }
                if (colInx2 < 6) {
                    if (isRoot == null) {
                        isRoot = rs.getInt(this.rankIdOldDBInx) == 0;
                    }
                    Integer oldID = rs.getInt(colInx2);
                    if (!rs.wasNull() || isRoot.booleanValue() && colInx2 == 2) {
                        boolean skipError = false;
                        Integer newID = this.mappers[colInx2 - 1].get(oldID);
                        if (newID == null) {
                            if (colInx2 == 3 || colInx2 == 5) {
                                if (!isRoot.booleanValue()) {
                                    skip = true;
                                }
                            } else if (colInx2 == 2 && (parentNodeId != null || isRoot.booleanValue())) {
                                newID = parentNodeId;
                            } else {
                                boolean isDetPointToTaxon;
                                boolean wasInOldTaxonTable = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*) FROM taxonname WHERE TaxonNameID = " + oldID) > 0;
                                boolean bl = isDetPointToTaxon = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*) FROM determination WHERE TaxonNameID = " + oldID) > 0;
                                if (isDetPointToTaxon) {
                                    String msg = String.format("***** Couldn't get %s NewID [%d] from mapper for colInx[%d] In Old taxonname table: %s  WasParentID: %s  Det Using: %s", colInx2 == 2 ? "Parent" : "", oldID, colInx2, wasInOldTaxonTable ? "YES" : "no", colInx2 == 2 ? "YES" : "no", isDetPointToTaxon ? "YES" : "no");
                                    log.error((Object)msg);
                                    this.tblWriter.logError(msg);
                                }
                                skipError = true;
                                ++this.missingParentTaxonCount;
                            }
                        }
                        if (!skip) {
                            if (newID != null) {
                                this.pStmtTx.setInt(newInx, newID);
                            } else if (!skipError && !isRoot.booleanValue()) {
                                String msg = "Unable to map old TaxonNameID[" + oldID + "]";
                                log.error((Object)msg);
                                this.tblWriter.logError(msg);
                            }
                        }
                    }
                } else {
                    switch (this.colTypes[newInx - 1]) {
                        case -7: {
                            boolean val = rs.getBoolean(colInx2);
                            if (rs.wasNull()) break;
                            this.pStmtTx.setBoolean(newInx, val);
                            break;
                        }
                        case 4: {
                            int val = rs.getInt(colInx2);
                            if (rs.wasNull()) break;
                            this.pStmtTx.setInt(newInx, val);
                            break;
                        }
                        case 5: {
                            short val = rs.getShort(colInx2);
                            if (rs.wasNull()) break;
                            this.pStmtTx.setShort(newInx, val);
                            break;
                        }
                        case 93: {
                            Timestamp val = rs.getTimestamp(colInx2);
                            this.pStmtTx.setTimestamp(newInx, !rs.wasNull() ? val : null);
                            break;
                        }
                        case -1: 
                        case 12: {
                            int len = this.colSizes[newInx - 1];
                            String val = rs.getString(colInx2);
                            if (val != null && val.length() > len) {
                                String newName = this.oldToNewColMap.get(oldName);
                                String msg = String.format("Concatinating field [%s] from length %d to %d String Lost:[%s]", newName, val.length(), len, val.substring(len));
                                log.debug((Object)msg);
                                this.tblWriter.logError(msg);
                                val = val.substring(0, len);
                            }
                            if (!rs.wasNull()) {
                                this.pStmtTx.setString(newInx, val);
                                break;
                            }
                            if (colInx2 != 7) break;
                            this.pStmtTx.setString(newInx, "Empty");
                            break;
                        }
                        default: {
                            log.error((Object)("Didn't support SQL Type: " + rsmd.getColumnType(colInx2)));
                        }
                    }
                }
            }
            ++colInx2;
        }
        if (!skip) {
            if (parentNodeId != null) {
                int nxtId = BasicSQLUtils.getCountAsInt("SELECT TaxonID FROM taxon ORDER BY TaxonID DESC LIMIT 0,1") + 1;
                this.pStmtTx.setInt(1, nxtId);
            }
            this.pStmtTx.setInt(this.fieldToColHash.get("Version"), 0);
            try {
                this.pStmtTx.execute();
            }
            catch (Exception ex) {
                UIRegistry.showError(ex.toString());
            }
        }
        return true;
    }

    private void fixStrandedTaxon(StringBuilder colDBColumns) {
        String fromClause = String.format(" FROM taxonname tx LEFT JOIN taxonname t2 ON tx.ParentTaxonNameID = t2.TaxonNameID Inner Join taxonomicunittype tu ON tx.TaxonomicUnitTypeID = tu.TaxonomicUnitTypeID WHERE t2.TaxonNameID IS NULL AND tx.RankID IS NOT NULL AND tx.RankID > 0 AND tx.TaxonomyTypeID %s", this.taxonomyTypeIdInClause);
        String sql = "SELECT COUNT(*)" + fromClause;
        int numStrandedTaxon = BasicSQLUtils.getCountAsInt(this.oldDBConn, sql);
        if (numStrandedTaxon > 0) {
            if (this.frame != null) {
                this.frame.setDesc(String.format("Fixing %d stranded Taxon records", numStrandedTaxon));
                this.frame.setProcess(0, numStrandedTaxon);
            }
            String sqlStr = String.format("SELECT %s %s", colDBColumns.toString(), fromClause);
            log.debug((Object)sqlStr);
            int rankIdInx = this.oldFieldToColHash.get("RankID");
            int taxonomyTypeInx = this.oldFieldToColHash.get("TaxonomyTypeID");
            try {
                int cnt = 0;
                ResultSet rs = this.stmtTx.executeQuery(sqlStr);
                ResultSetMetaData rsmd = rs.getMetaData();
                while (rs.next()) {
                    int taxonomyTypeId = rs.getInt(taxonomyTypeInx);
                    CollectionInfo colInfo = this.getCIByTaxonTypeId(taxonomyTypeId);
                    if (colInfo != null) {
                        int rankId = rs.getInt(rankIdInx);
                        Integer parentRankId = colInfo.getRankParentHash().get(rankId);
                        if (parentRankId != null) {
                            TaxonTreeDefItem item = colInfo.getTreeDefItemHash().get(rankId);
                            if (item != null) {
                                Taxon taxonParent = colInfo.getPlaceHolderTreeHash().get(parentRankId);
                                if (taxonParent != null) {
                                    this.processRow(rs, rsmd, taxonParent.getId());
                                } else {
                                    log.error((Object)("Taxon PlaceHolder parent was missing for RankId: " + rankId));
                                }
                            } else {
                                log.error((Object)("TaxonTreeDefItem was missing for RankId: " + rankId));
                            }
                        } else {
                            log.error((Object)("No Parent RankID mapping for RankId: " + rankId));
                        }
                    } else {
                        log.error((Object)("Couldn't find CollectionInfo for taxonomyTypeId: " + taxonomyTypeId));
                    }
                    ++cnt;
                    if (this.frame == null) continue;
                    this.frame.setProcess(cnt);
                }
                rs.close();
                if (this.frame != null) {
                    this.frame.setProcess(numStrandedTaxon);
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void convertTaxonTreeDefSeparators() {
        Session session = HibernateUtil.getCurrentSession();
        Query q = session.createQuery("FROM TaxonTreeDef");
        List allTTDs = q.list();
        HibernateUtil.beginTransaction();
        for (Object o : allTTDs) {
            TaxonTreeDef ttd = (TaxonTreeDef)o;
            ttd.setFullNameDirection(1);
            session.saveOrUpdate((Object)ttd);
        }
        try {
            HibernateUtil.commitTransaction();
        }
        catch (Exception ex) {
            log.error((Object)"Error while setting the fullname direction of taxonomy tree definitions.");
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        session = HibernateUtil.getCurrentSession();
        q = session.createQuery("FROM TaxonTreeDefItem");
        List allTTDIs = q.list();
        HibernateUtil.beginTransaction();
        for (Object o : allTTDIs) {
            TaxonTreeDefItem ttdi = (TaxonTreeDefItem)o;
            ttdi.setFullNameSeparator(" ");
            session.saveOrUpdate((Object)ttdi);
        }
        try {
            HibernateUtil.commitTransaction();
        }
        catch (Exception ex) {
            log.error((Object)"Error while setting the fullname separator of taxonomy tree definition items.");
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public Pair<TaxonTreeDef, Discipline> doTaxonForCollection(int disciplineId, int taxonRootId) {
        Pair<TaxonTreeDef, Discipline> dataForColInfo = null;
        int newTaxonRootID = this.txMapper.get(taxonRootId);
        int taxonTreeDefId = BasicSQLUtils.getCountAsInt(this.newDBConn, "SELECT TaxonTreeDefID FROM taxon WHERE TaxonID = " + newTaxonRootID);
        DataProviderSessionIFace session = null;
        try {
            try {
                session = DataProviderFactory.getInstance().createSession();
                TaxonTreeDef ttd = session.get(TaxonTreeDef.class, taxonTreeDefId);
                Discipline discipline = (Discipline)session.getData("FROM Discipline WHERE id = " + disciplineId);
                session.beginTransaction();
                discipline.setTaxonTreeDef(ttd);
                session.saveOrUpdate(discipline);
                session.commit();
                dataForColInfo = new Pair<TaxonTreeDef, Discipline>(ttd, discipline);
            }
            catch (Exception ex) {
                session.rollback();
                log.error((Object)"Error while setting TaxonTreeDef into the Discipline.");
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        this.tblWriter.append("<H3>Taxon with null RankIDs</H3>");
        this.tblWriter.startTable();
        String missingRankSQL = "SELECT * FROM taxonname WHERE RankID IS NULL";
        Vector<Object[]> rows = BasicSQLUtils.query(this.oldDBConn, missingRankSQL);
        for (Object[] row : rows) {
            this.tblWriter.append("<TR>");
            Object[] objectArray = row;
            int n = row.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                this.tblWriter.append("<TD>");
                this.tblWriter.append(obj != null ? obj.toString() : "null");
                this.tblWriter.append("</TD>");
                ++n2;
            }
            this.tblWriter.append("</TR>");
        }
        this.tblWriter.endTable();
        this.tblWriter.append("<BR>");
        if (this.txMapper instanceof IdHashMapper) {
            for (Integer oldId : ((IdHashMapper)this.txMapper).getOldIdNullList()) {
                this.tblWriter.println(ConvertVerifier.dumpSQL(this.oldDBConn, "SELECT * FROM taxonname WHERE ParentTaxonNameID = " + oldId));
            }
        }
        BasicSQLUtils.setFieldsToIgnoreWhenMappingNames(null);
        BasicSQLUtils.setIdentityInsertOFFCommandForSQLServer(this.newDBConn, "taxon", BasicSQLUtils.myDestinationServerType);
        IdHashMapper.setTblWriter(null);
        return dataForColInfo;
    }

    public void convertTaxonCitationToTaxonImage() {
        String sql = "SELECT tn.TaxonNameID, c.Text1 ";
        String fromStr = " FROM taxonname AS tn Inner Join taxoncitation AS c ON tn.TaxonNameID = c.TaxonNameID";
        String whereStr = " WHERE c.Text1 IS NOT NULL";
        String updateStr = "UPDATE taxon SET GUID=? WHERE TaxonID = ?";
        int numTaxCit = BasicSQLUtils.getCountAsInt(this.oldDBConn, "SELECT COUNT(*) " + fromStr + whereStr);
        if (numTaxCit > 0) {
            if (this.frame != null) {
                this.frame.setDesc(String.format("Fixing Taxon Citations", numTaxCit));
                this.frame.setProcess(0, numTaxCit);
            }
            String sqlStr = String.valueOf(sql) + fromStr + whereStr;
            log.debug((Object)sqlStr);
            Statement stmt = null;
            Statement pStmt = null;
            try {
                try {
                    stmt = this.oldDBConn.createStatement(1004, 1007);
                    pStmt = this.newDBConn.prepareStatement(updateStr);
                    int cnt = 0;
                    ResultSet rs = stmt.executeQuery(sqlStr);
                    while (rs.next()) {
                        int oldTaxonId = rs.getInt(1);
                        Integer newTaxonID = this.txMapper.get(oldTaxonId);
                        if (newTaxonID != null) {
                            String imgURL = rs.getString(2);
                            pStmt.setString(1, imgURL);
                            pStmt.setInt(2, newTaxonID);
                            if (pStmt.executeUpdate() != 1) {
                                String msg = String.format("Unable to update new taxonID %d with image url[%s].", newTaxonID, imgURL);
                                log.error((Object)msg);
                                this.tblWriter.logError(msg);
                            }
                            ++cnt;
                            if (this.frame == null) continue;
                            this.frame.setProcess(cnt);
                            continue;
                        }
                        String msg = String.format("Unable to map old id [%d] to new taxonID.", oldTaxonId);
                        log.error((Object)msg);
                        this.tblWriter.logError(msg);
                    }
                    rs.close();
                    if (this.frame != null) {
                        this.frame.setProcess(numTaxCit);
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (pStmt != null) {
                            pStmt.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (pStmt != null) {
                        pStmt.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void doConvert() {
        this.getTaxonTreesTypesInUse();
        this.convertAllTaxonTreeDefs();
        this.convertTaxonTreeDefSeparators();
        this.convertTaxonRecords();
        HashMap<Integer, Integer> dispTxnRootHash = new HashMap<Integer, Integer>();
        for (CollectionInfo colInfo : this.collectionInfoList) {
            Integer txnRootId = (Integer)dispTxnRootHash.get(colInfo.getDisciplineId());
            if (txnRootId == null) {
                dispTxnRootHash.put(colInfo.getDisciplineId(), colInfo.getTaxonNameId());
                continue;
            }
            if (txnRootId.equals(colInfo.getTaxonNameId())) continue;
            UIRegistry.showError("Two (or more) Disciplines have different Taxon Root Id records.  Dsp[" + colInfo.getDisciplineId() + "]  Prev RootId[" + txnRootId + "] New RootId[" + colInfo.getTaxonNameId() + "]");
        }
        for (Integer dispId : dispTxnRootHash.keySet()) {
            Pair<TaxonTreeDef, Discipline> dispTxn = this.doTaxonForCollection(dispId, (Integer)dispTxnRootHash.get(dispId));
            if (dispTxn == null) continue;
            for (CollectionInfo colInfo : this.collectionInfoList) {
                if (!colInfo.getDisciplineId().equals(((Discipline)dispTxn.second).getId())) continue;
                colInfo.setTaxonTreeDef((TaxonTreeDef)dispTxn.first);
            }
        }
    }

    private static String makeKey(int taxTypeId, int rankId) {
        return String.format("%d %d", taxTypeId, rankId);
    }

    public static boolean fixTaxonomicUnitType(Connection oldDBConn) {
        if (BasicSQLUtils.getCountAsInt(oldDBConn, "SELECT COUNT(*) FROM taxonname WHERE RankID = 10") > 0) {
            UIRegistry.displayErrorDlg("There are already a RankID of '10', can't fix the Taxonomy.");
            return false;
        }
        StringBuilder sb = new StringBuilder();
        HashSet<Integer> taxTypeIdsInUseSet = new HashSet<Integer>();
        ArrayList<Integer> taxTypeIdsInUse = new ArrayList<Integer>();
        String sql = "SELECT DISTINCT TaxonomyTypeID FROM taxonname WHERE RankID = 0";
        for (Object obj : BasicSQLUtils.querySingleCol(oldDBConn, sql)) {
            taxTypeIdsInUse.add((Integer)obj);
            taxTypeIdsInUseSet.add((Integer)obj);
            sb.append(obj.toString());
            sb.append(',');
        }
        sb.setLength(sb.length() - 1);
        sql = String.format("SELECT TaxonomyTypeID, CNT FROM (SELECT TaxonomyTypeID, COUNT(TaxonomyTypeID) CNT FROM taxonomicunittype t WHERE TaxonomyTypeID in (%s) GROUP BY TaxonomyTypeID) T1 ORDER BY CNT DESC LIMIT 0,1", sb.toString());
        int taxonomyTypeId = 0;
        sql = String.format("SELECT TaxonomicUnitTypeID FROM taxonomicunittype t WHERE TaxonomyTypeID = %d AND RankID = 0", taxonomyTypeId);
        int taxonomyUnitTypeId = BasicSQLUtils.getCountAsInt(oldDBConn, sql);
        sql = String.format("SELECT Kingdom FROM taxonomicunittype t WHERE TaxonomyTypeID = %d AND RankID = 0", taxonomyTypeId);
        int initialKingdom = BasicSQLUtils.getCountAsInt(oldDBConn, sql);
        sql = String.format("SELECT TaxonomicUnitTypeID FROM taxonomicunittype t WHERE TaxonomyTypeID = %d AND RankID = 10", taxonomyTypeId);
        int kingdomTUTId = BasicSQLUtils.getCountAsInt(oldDBConn, sql);
        sql = String.format("SELECT TaxonNameID FROM taxonname WHERE RankID = 0 AND TaxonomyTypeID = %d AND TaxonomicUnitTypeID = %d", taxonomyTypeId, taxonomyUnitTypeId);
        log.debug((Object)sql);
        Integer taxonRootId = BasicSQLUtils.getCount(oldDBConn, sql);
        if (taxonRootId == null) {
            taxonRootId = 0;
            while (BasicSQLUtils.getCountAsInt(oldDBConn, "SELECT COUNT(*) FROM taxonname WHERE TaxonNameID = " + taxonRootId) != 0) {
                taxonRootId = taxonRootId + 1;
            }
            sql = String.format("INSERT INTO taxonname (TaxonNameID, ParentTaxonNameID, TaxonomyTypeID, TaxonomicUnitTypeID, TaxonName, FullTaxonName, NodeNumber, HighestChildNodeNumber, TimestampCreated, TimestampModified, RankID) VALUES(%s, NULL, %d, %d, 'Root', 'Root', 0, 0, '2011-01-01 00:00:00', NULL, 0)", taxonRootId, taxonomyTypeId, taxonomyUnitTypeId);
            log.debug((Object)sql);
            BasicSQLUtils.update(oldDBConn, sql);
        } else {
            sql = String.format("UPDATE taxonname SET TaxonName='Root' WHERE TaxonNameID = %d", taxonRootId);
            log.debug((Object)sql);
            BasicSQLUtils.update(oldDBConn, sql);
        }
        HashMap<String, Integer> rankIdToTaxUnitTypeIdHash = new HashMap<String, Integer>();
        sql = "SELECT RankID, TaxonomicUnitTypeID FROM taxonomicunittype WHERE TaxonomyTypeID = " + taxonomyTypeId;
        for (Object[] row : BasicSQLUtils.query(oldDBConn, sql)) {
            int rankId = (Integer)row[0];
            int oldId = (Integer)row[1];
            System.out.println(String.format("Mapping taxonomyTypeId %d rankId %d to oldId %d", taxonomyTypeId, rankId, oldId));
            rankIdToTaxUnitTypeIdHash.put(ConvertTaxonHelper.makeKey(taxonomyTypeId, rankId), oldId);
        }
        HashMap<Integer, Integer> tutHash = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> taxUnitTypeIdMapper = new HashMap<Integer, Integer>();
        sql = String.format("SELECT TaxonomyTypeID, RankID, TaxonomicUnitTypeID, RankName, DirectParentRankID, RequiredParentRankID FROM taxonomicunittype WHERE TaxonomyTypeID in (%s) AND TaxonomyTypeID <> %d", sb.toString(), taxonomyTypeId);
        log.debug((Object)sql);
        for (Object[] row : BasicSQLUtils.query(oldDBConn, sql)) {
            int taxTypeId = (Integer)row[0];
            int rankId = (Integer)row[1];
            int oldId = (Integer)row[2];
            String rankName = (String)row[3];
            int dirPrtId = (Integer)row[4];
            int reqPrId = (Integer)row[5];
            System.out.println(String.format("\nMapping taxTypeId: %d   rankId: %d   to   oldId %d", taxTypeId, rankId, oldId));
            Integer newId = (Integer)rankIdToTaxUnitTypeIdHash.get(ConvertTaxonHelper.makeKey(taxonomyTypeId, rankId));
            if (newId == null && rankId != 0 && BasicSQLUtils.getCountAsInt(oldDBConn, sql = String.format("SELECT COUNT(*) FROM taxonname WHERE RankID = %d", rankId)) > 0 && (newId = (Integer)tutHash.get(rankId)) == null) {
                newId = taxonomicUnitTypeId;
                ++taxonomicUnitTypeId;
                String updateSQL1 = String.format("INSERT INTO taxonomicunittype (TaxonomicUnitTypeID, TaxonomyTypeID, RankID, Kingdom, RankName, DirectParentRankID, RequiredParentRankID) VALUES(%d, %d, %d, %d, '%s', %d, %d)", newId, taxonomyTypeId, rankId, initialKingdom, rankName, dirPrtId, reqPrId);
                log.debug((Object)updateSQL1);
                rankIdToTaxUnitTypeIdHash.put(ConvertTaxonHelper.makeKey(taxTypeId, rankId), oldId);
                System.out.println(String.format("Moving RankID %d from TaxonomyTypeID %d to %d", rankId, taxTypeId, taxonomyTypeId));
                tutHash.put(rankId, newId);
            }
            taxUnitTypeIdMapper.put(oldId, newId);
            System.out.println(String.format("Mapping oldId %d to newId %d", oldId, newId));
        }
        String updateSQL1 = String.format("UPDATE taxonname SET RankID=10, TaxonomicUnitTypeID=%d, ParentTaxonNameID = %d WHERE RankID = 0 AND TaxonomicUnitTypeID <> %d", kingdomTUTId, taxonRootId, taxonomyUnitTypeId);
        BasicSQLUtils.update(oldDBConn, updateSQL1);
        for (Object oldId : taxUnitTypeIdMapper.keySet()) {
            Integer newId = (Integer)taxUnitTypeIdMapper.get(oldId);
            if (newId == null) continue;
            sql = String.format("UPDATE taxonname SET TaxonomicUnitTypeID = %d WHERE TaxonomicUnitTypeID = %d", newId, oldId);
            System.out.println(String.format("Seting Old TaxonomicUnitTypeID %d to new %d", oldId, newId));
            BasicSQLUtils.update(oldDBConn, sql);
        }
        updateSQL1 = String.format("UPDATE taxonname SET TaxonomyTypeID = %d", taxonomyTypeId);
        BasicSQLUtils.update(oldDBConn, updateSQL1);
        updateSQL1 = "UPDATE taxonname SET RankID = 0 WHERE TaxonName = 'Root'";
        BasicSQLUtils.update(oldDBConn, updateSQL1);
        return true;
    }
}

