/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify.conversion;

import edu.ku.brc.specify.conversion.TableWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class ConversionLogger {
    protected Hashtable<String, String> printWritersNameHash = new Hashtable();
    protected Hashtable<String, TableWriter> printWritersHash = new Hashtable();
    protected Vector<TableWriter> printWritersList = new Vector();
    protected String indexTitle = "Index";
    protected File dir;

    public boolean initialize(String baseDirName, String dirName) {
        this.dir = new File(String.valueOf(baseDirName) + File.separator + dirName);
        if (!this.dir.exists()) {
            return this.dir.mkdirs();
        }
        return false;
    }

    public void setIndexTitle(String indexTitle) {
        this.indexTitle = indexTitle;
    }

    public TableWriter getWriter(String fileName, String title) {
        return this.getWriter(fileName, title, false);
    }

    public TableWriter getWriter(String fileName, String title, String extraStyle) {
        return this.getWriter(fileName, title, extraStyle, false);
    }

    public TableWriter getWriter(String fileName, String title, boolean doCenterTitle) {
        return this.getWriter(fileName, title, null, doCenterTitle);
    }

    public TableWriter getWriter(String fileName, String title, String extraStyle, boolean doCenterTitle) {
        TableWriter tblWriter = null;
        try {
            if (this.printWritersNameHash.get(fileName) == null) {
                String path = String.valueOf(this.dir.getAbsolutePath()) + File.separator + StringUtils.replace((String)fileName, (String)" ", (String)"_");
                tblWriter = new TableWriter(path, title, extraStyle, doCenterTitle);
                this.printWritersNameHash.put(fileName, path);
                this.printWritersHash.put(fileName, tblWriter);
                this.printWritersList.add(tblWriter);
            } else {
                System.err.println("Duplicate file name[" + fileName + "]");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return tblWriter;
    }

    public File closeAll() {
        return this.closeAll(false);
    }

    protected void writeIndex(TableWriter indexWriter, Vector<TableWriter> orderList) {
        indexWriter.startTable();
        for (TableWriter tblWriter : orderList) {
            System.out.println(tblWriter.getTitle());
            try {
                if (tblWriter.hasLines()) {
                    indexWriter.log("<A href=\"" + FilenameUtils.getName((String)tblWriter.getFileName()) + "\">" + tblWriter.getTitle() + "</A>");
                    tblWriter.close();
                    continue;
                }
                tblWriter.flush();
                tblWriter.close();
                File f = new File(tblWriter.getFileName());
                if (!f.exists()) continue;
                f.delete();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        indexWriter.endTable();
    }

    public File closeAll(boolean byOrderAdded) {
        try {
            Vector<TableWriter> orderList;
            if (this.dir == null) {
                this.dir = new File(".");
            }
            String path = String.valueOf(this.dir.getAbsolutePath()) + File.separator + "index.html";
            TableWriter indexWriter = new TableWriter(path, this.indexTitle);
            if (byOrderAdded) {
                orderList = this.printWritersList;
            } else {
                orderList = new Vector();
                Vector<String> names = new Vector<String>(this.printWritersHash.keySet());
                Collections.sort(names);
                for (String nm : names) {
                    orderList.add(this.printWritersHash.get(nm));
                }
            }
            this.writeIndex(indexWriter, orderList);
            indexWriter.close();
            return new File(path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }
}

